
; ---------------------------------------------------------------------------

; enum IO_Ports
KBD_R4:		 equ 4
KBD_R5:		 equ 5
VV51_Data:	 equ 6
VV51_StatCtrl:	 equ 7
TMR_CH0:	 equ 8
TMR_CH1:	 equ 9
TMR_CH2:	 equ 0Ah
TMR_RUS:	 equ 0Bh
PIC_0C_REQ_CMD:	 equ 0Ch
PIC_0D_MASK_CMD: equ 0Dh
PIC_0E_REQ_CMD:	 equ 0Eh
PIC_0F_MASK_CMD: equ 0Fh
PPA_A:		 equ 10h
PPA_B:		 equ 11h
PPA_C:		 equ 12h
PPA_RUS:	 equ 13h
ROMDISK_PORT:	 equ 14h
VID_MODE:	 equ 0D8h
VID_COLOR:	 equ 0D9h
VID_PAGE:	 equ 0DAh

; ---------------------------------------------------------------------------

; enum _VID_MODE (bitfield)
_HDCM:		 equ 1
_MRHR:		 equ 1000b
_VIEN:		 equ 10000b

; ---------------------------------------------------------------------------

; enum PPA_RUS_BITS
_C0_0:		 equ 0
_C0_1:		 equ 1
_C1_0:		 equ 2
_C1_1:		 equ 3
_C2_0:		 equ 4
_C2_1:		 equ 5
_C3_0:		 equ 6
_C3_1:		 equ 7
_C4_0:		 equ 8
_C4_1:		 equ 9
_C5_0:		 equ 0Ah
_C5_1:		 equ 0Bh
_C6_0:		 equ 0Ch
_C6_1:		 equ 0Dh
_C7_0:		 equ 0Eh
_C7_1:		 equ 0Fh

;
; +-------------------------------------------------------------------------+
; |   This file	has been generated by The Interactive Disassembler (IDA)    |
; |	   Copyright (c) 2009 by Hex-Rays, <support@hex-rays.com>	    |
; |			 License info: FB-DEFD-3B71-CE			    |
; |				 Licensed User				    |
; +-------------------------------------------------------------------------+
;
; Input	MD5   :	17F3F1C57E5117BA39911BC517667614

; ---------------------------------------------------------------------------
; File Name   :	Z:\ida\irisha\irisha.rom
; Format      :	Binary file
; Base Address:	0000h Range: 0000h - 4000h Loaded length: 4000h

; Processor	  : z80	[]
; Target assembler: Zilog Macro	Assembler

; ===========================================================================

; Segment type:	Regular
		segment	RAM

loc_0:					; CODE XREF: RAM:GAMEj	RAM:RES1j ...
		di
		ld	sp, 0D000h
		jp	_Init0
; ---------------------------------------------------------------------------
		db 0, 0C3h, 0FBh, 9Ch
		db [ 35h ], 0
; ---------------------------------------------------------------------------

TAPEREA:
		jp	_TAPEREA
; ---------------------------------------------------------------------------

TAPEWRI:
		jp	_TAPEWRI
; ---------------------------------------------------------------------------

SHAPE:
		jp	_SHAPE
; ---------------------------------------------------------------------------

GAME:
		jp	loc_0
; ---------------------------------------------------------------------------

RES1:
		jp	loc_0
; ---------------------------------------------------------------------------

RES2:
		jp	loc_0
; ---------------------------------------------------------------------------

MENU:
		jp	_MENU

; =============== S U B	R O U T	I N E =======================================

; Attributes: thunk

MELODY:					; CODE XREF: sub_1B42+Fp
		jp	_MELODY
; End of function MELODY

; ---------------------------------------------------------------------------

CONST:
		jp	_CONST

; =============== S U B	R O U T	I N E =======================================

; Attributes: thunk

_CONIN?:				; CODE XREF: RAM:0353p	RAM:048Ep
		jp	_CONIN
; End of function _CONIN?

; ---------------------------------------------------------------------------
ARORMR:		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0
		db    0

; =============== S U B	R O U T	I N E =======================================


_LDIR:					; CODE XREF: _LDIR+7j RAM:0254p ...
		ld	a, (hl)
		ld	(de), a
		inc	hl
		inc	de
		dec	bc
		ld	a, b
		or	c
		jp	nz, _LDIR
		ret
; End of function _LDIR

; ---------------------------------------------------------------------------

_HOOK3_Sound?:				; DATA XREF: RAM:02A2o
		cp	0
		jp	nz, loc_85
		ld	bc, _Sond00
		jp	_DoSoundHook
; ---------------------------------------------------------------------------

loc_85:					; CODE XREF: RAM:007Cj
		ld	bc, _SoundFF
		jp	_DoSoundHook
; ---------------------------------------------------------------------------

_HOOK2_Img?:				; DATA XREF: RAM:02A8o
		cp	0FFh
		ret	nz
		jp	_SHAPE
; ---------------------------------------------------------------------------
_init_VV51:	db 0, 0, 0, 40h, 0CEh, 15h ; DATA XREF:	RAM:0275o
_toAsrar:	db 0FFh,0FFh,0,0FFh,50h,41h,0,0,0,0,50h,19h,0,0,0FFh,20h
					; DATA XREF: RAM:024Bo
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR _Logo_and_inits

_ShowLogo:				; CODE XREF: _Logo_and_inits+19j
					; _Logo_and_inits+60j
		ld	hl, _LOGO?
		ld	(_ShapeFle), hl
		call	_SHAPE
		call	?BEEP?
		ld	bc, __StartMusic
		call	_MELODY
		ld	de, _Circle
		jp	PutString_DE
; END OF FUNCTION CHUNK	FOR _Logo_and_inits
; ---------------------------------------------------------------------------
_Circle:	db 1Bh			; DATA XREF: _Logo_and_inits-1786o
		.ascii 'G'              ; GraphLangStart
		.ascii 'C1'             ; Color
		.ascii 'P248,34'        ; Pset
		.ascii 'S0,0'           ; SzhatieOcr
		.ascii 'F0,0'           ; Ellipse
		.ascii 'R32'            ; Radius
		.ascii 'I'              ; Circle
		.ascii 'TT'             ; Reset ConOut
		db 0
_LOGO?:		db 6			; DATA XREF: _Logo_and_inits:_ShowLogoo
		db 15
		dw 42Ch
		db 0C1h, 83h,0F9h,0F8h,0FCh, 41h
		db 0C1h, 82h,	8,   4,	82h, 63h
		db 0C1h, 82h,	8, 7Ch,0FCh, 55h
		db 0C1h, 82h,	8,   4,	82h, 49h
		db 0C1h, 82h,	9,0F8h,0FCh, 41h
		db 0C1h, 80h,	0,   0,	  0,   0
		db 0C3h, 80h,	0,   0,	  0,   0
		db 0C7h, 9Fh,0C6h, 33h,	0Ch, 38h
		db 0CDh, 98h, 66h, 73h,	6Ch, 6Ch
		db 0D9h, 98h, 66h,0F3h,	6Ch, 44h
		db 0F1h, 98h, 67h,0B3h,	6Ch,0FEh
		db 0E1h, 98h, 67h, 33h,	6Ch,0C6h
		db 0C1h, 9Fh,0C6h, 33h,0FCh,0C6h
		db    0, 18h,	0,   0,	  0,   0
		db 0FFh, 99h,0FFh,0FFh,0FFh,0FFh
__StartMusic:	db 0A0h, 15h, 19h, 1Ch,	1Eh, 1Fh, 1Eh, 1Ch, 19h
					; DATA XREF: _Logo_and_inits-178Co
					; RAM:028Eo
_SoundFF:	db 0A0h, 15h, 19h, 1Ch,	1Eh, 1Fh, 1Eh ;	DATA XREF: RAM:loc_85o
_Sond00:	db 0A0h, 1Ch, 19h, 0	; DATA XREF: RAM:007Fo
; ---------------------------------------------------------------------------

_SHAPE:					; CODE XREF: RAM:SHAPEj RAM:008Ej ...
		ld	hl, (_ShapeFle)
		ld	c, (hl)
		inc	hl
		ld	b, (hl)
		inc	hl
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		inc	hl
		push	hl
		ld	a, (_ConOut_Mode)
		and	10h
		ld	hl, byte_C000
		jp	z, loc_165
		ld	hl, byte_E000

loc_165:				; CODE XREF: RAM:015Fj
		add	hl, de
		pop	de
		push	bc
		ld	a, (_ConOut4080)
		sub	c
		push	af

loc_16D:				; CODE XREF: RAM:0173j	RAM:017Fj
		ld	a, (de)
		xor	(hl)
		ld	(hl), a
		inc	de
		inc	hl
		dec	c
		jp	nz, loc_16D
		pop	af
		ld	c, a
		ld	b, 0
		add	hl, bc
		pop	bc
		dec	b
		push	bc
		push	af
		jp	nz, loc_16D
		pop	af
		pop	bc
		ret

; =============== S U B	R O U T	I N E =======================================


?BEEP?:					; CODE XREF: _Logo_and_inits-178Fp
		ld	a, 0B6h	; ''
		out	(TMR_RUS), a
		ld	a, _C5_0
		out	(PPA_RUS), a
; End of function ?BEEP?


; =============== S U B	R O U T	I N E =======================================


_SoundOff:				; CODE XREF: _PlayNote_BC+17p
		xor	a
; End of function _SoundOff


; =============== S U B	R O U T	I N E =======================================


_SoundPort:				; CODE XREF: _PlayNote_BC+9p
		out	(PPA_A), a
		ld	a, 0Dh
		out	(PPA_RUS), a
		ld	a, 0Ch
		out	(PPA_RUS), a
		ret
; End of function _SoundPort


; =============== S U B	R O U T	I N E =======================================


_PlayNote_BC:				; CODE XREF: _PlayNote+15p
		push	bc
		ld	a, c
		out	(TMR_CH2), a	; Timer
		ld	a, b
		out	(TMR_CH2), a
		ld	a, 20h ; ' '
		call	_SoundPort
		push	hl
		ld	hl, (_NoteLength)

loc_1A9:				; CODE XREF: _PlayNote_BC+13j
		dec	hl
		ld	a, l
		or	h
		jp	nz, loc_1A9
		pop	hl
		call	_SoundOff
		pop	bc
		ret
; End of function _PlayNote_BC


; =============== S U B	R O U T	I N E =======================================


_PlayNote:				; CODE XREF: _MELODY+Ep
		push	hl
		push	af
		push	bc
		ld	hl,  loc_1F2+1
		cp	40
		jp	nc, loc_1D1

loc_1C0:				; CODE XREF: _PlayNote+1Ej
		ld	b, 0
		ld	c, a
		add	hl, bc
		add	hl, bc
		ld	a, (hl)
		ld	b, a
		inc	hl
		ld	a, (hl)
		ld	c, a
		call	_PlayNote_BC
		pop	bc
		pop	af
		pop	hl
		ret
; ---------------------------------------------------------------------------

loc_1D1:				; CODE XREF: _PlayNote+8j
		ld	a, 40
		jp	loc_1C0
; End of function _PlayNote


; =============== S U B	R O U T	I N E =======================================


_MELODY:				; CODE XREF: MELODYj
					; _Logo_and_inits-1789p
		ld	hl, (_MelodyFile)
		ld	b, h
		ld	c, l

_DoSoundHook:				; CODE XREF: RAM:0082j	RAM:0088j ...
		ld	a, (bc)
		rla
		jp	c, _music_setLen
		rra
		cp	0
		ret	z
		call	_PlayNote
		inc	bc
		jp	_DoSoundHook
; ---------------------------------------------------------------------------

_music_setLen:				; CODE XREF: _MELODY+7j
		rra
		and	7Fh ; ''
		inc	bc
		ld	(_NoteLength+1), a

loc_1F2:				; DATA XREF: _PlayNote+3o
		jp	_DoSoundHook
; End of function _MELODY

; ---------------------------------------------------------------------------
		db '*'
__Melody__:	dw 2723h, 25C5h, 238Ah,	216Eh, 1F71h, 1D91h, 1CCBh, 1A1Fh
		dw 198Bh, 170Eh, 16A6h,	1552h, 1311h, 12E3h, 11C5h, 10B7h
		dw 0FB9h, 0EC8h, 0EE6h,	0D10h, 0C46h, 0B87h, 0BD3h, 0A29h
		dw 989h, 9F1h, 862h, 8DCh, 75Ch, 7E4h, 773h, 608h, 6A3h
		dw 543h, 5E9h, 594h, 444h, 4F9h, 4B1h, 6Eh
		db    8
; ---------------------------------------------------------------------------

_Init0:					; CODE XREF: RAM:0004j
		ld	a, 82h ; ''
		out	(PPA_RUS), a
		ld	hl, _toAsrar
		ld	bc, 10h
		ld	de, ASRAR
		call	_LDIR
		ld	a, 76h ; 'v'
		out	(TMR_RUS), a
		ld	a, 21h ; '!'
		out	(TMR_CH1), a
		ld	a, 1Bh
		out	(TMR_CH1), a
		ld	a, 36h ; '6'
		out	(PIC_0C_REQ_CMD), a
		ld	a, 88h ; ''
		out	(PIC_0D_MASK_CMD), a
		ld	a, 0FFh
		out	(PIC_0D_MASK_CMD), a
		ld	a, 20h ; ' '
		out	(PIC_0C_REQ_CMD), a
		ld	c, 6
		ld	hl, _init_VV51

loc_278:				; CODE XREF: RAM:027Dj
		ld	a, (hl)
		out	(VV51_StatCtrl), a
		dec	c
		inc	hl
		jp	nz, loc_278
		in	a, (VV51_Data)
		ld	a, 36h ; '6'
		out	(TMR_RUS), a
		ld	a, 0Ch
		out	(TMR_CH0), a
		ld	a, 0
		out	(TMR_CH0), a
		ld	hl, __StartMusic
		ld	(_MelodyFile), hl
		call	ConOut_INIT
		call	_Logo_and_inits
		ld	a, 0C3h	; ''
		ld	(HOOK3_Sound), a
		ld	(HOOK2_Img), a
		ld	hl, _HOOK3_Sound?
		ld	(HOOK3_Sound+1), hl
		ld	hl, _HOOK2_Img?
		ld	(HOOK2_Img+1), hl

loc_2AE:				; CODE XREF: RAM:0496j
		ld	hl, 0CF00h
		ld	(CSTACK), hl
		ld	hl, 0
		add	hl, sp
		ld	sp, 0CEFDh
		ld	b, 3
		ld	a, (_RunDebugger)
		cp	0F3h ; ''
		jp	z, loc_386
		ld	de, aMonitor	; "monitor"
		push	de
		ld	de, _RunDebugger

loc_2CC:				; CODE XREF: RAM:038Dj
		push	de
		ld	de, aMagnitofon	; "magnitofon"
		push	de
		ld	de, _Magnitofon
		push	de
		ld	de, aDisk	; "disk"
		push	de
		ld	a, _C7_0
		out	(PPA_RUS), a
		in	a, (PPA_B)
		rla
		rla
		jp	nc, loc_390
		ld	de, _runDisk1?

loc_2E7:				; CODE XREF: RAM:0393j
		push	de
		push	hl
		out	(ROMDISK_PORT),	a ; ResetExtRom
		ld	hl, 0
		ld	(_ExtRomAddr???), hl
		call	_CheckExtRomEmpty
		pop	hl
		jp	z, loc_301
		inc	b
		ld	de, aDop_pzu	; "dop.pzu"
		push	de
		ld	de, _Run_Dop_Pzu
		push	de

loc_301:				; CODE XREF: RAM:02F5j
		ld	a, _C7_1
		out	(PPA_RUS), a
		in	a, (PPA_B)
		rra
		jp	c, nonet
		ld	de, aSetx	; "setx"
		push	de
		inc	b
		ld	de, _Run_NET
		push	de

nonet:					; CODE XREF: RAM:0308j
		ld	a, b
		ld	(_MainMenuElemnts), a
		ld	de, a@AStart?	; "\v\n\n\x1B@\x1Ba\x0E  start?"
		ex	de, hl
		ld	(_MainMenuMainText), hl
		ex	de, hl
		ld	sp, hl
		ld	hl,  _MainMenuMainText+1

_MENU:					; CODE XREF: RAM:MENUj	RAM:055Bj
		ld	d, (hl)
		dec	hl
		ld	e, (hl)
		dec	hl
		push	hl
		call	PutString_DE
		ld	a, 8
		cp	(hl)
		jp	nc, loc_333
		ld	(hl), a

loc_333:				; CODE XREF: RAM:032Fj
		ld	b, (hl)
		ld	c, b
		dec	hl

loc_336:				; CODE XREF: RAM:0340j
		ld	d, (hl)
		dec	hl
		ld	e, (hl)
		dec	hl
		dec	hl
		dec	hl
		call	sub_404
		dec	c
		jp	nz, loc_336
		ld	c, b
		ld	de, PuskWk	; "\x1BY5*pusk=wk\x0F"
		call	PutString_DE

loc_34A:				; CODE XREF: RAM:035Fj
		xor	a
		ld	de, a_clearSellection?
		call	PutString_DE

loc_351:				; CODE XREF: RAM:0368j
		push	af
		push	bc
		call	_CONIN?
		cp	0Dh
		pop	bc
		jp	z, _RUN
		pop	af
		inc	a
		cp	b
		jp	nc, loc_34A
		ld	de, a_selected
		call	PutString_DE
		jp	loc_351
; ---------------------------------------------------------------------------

_RUN:					; CODE XREF: RAM:0359j
		pop	af
		pop	hl
		or	a
		ld	b, a
		dec	hl

loc_370:				; CODE XREF: RAM:0378j
		dec	hl
		dec	hl
		jp	z, loc_37B
		dec	hl
		dec	hl
		dec	a
		jp	loc_370
; ---------------------------------------------------------------------------

loc_37B:				; CODE XREF: RAM:0372j
		ld	d, (hl)
		dec	hl
		ld	e, (hl)
		ex	de, hl
		ld	de, a_CursorOn
		call	PutString_DE
		jp	(hl)
; ---------------------------------------------------------------------------

loc_386:				; CODE XREF: RAM:02C2j
		ld	de, aAdr_4000	; "adr.4000"
		push	de
		ld	de, 4000h
		jp	loc_2CC
; ---------------------------------------------------------------------------

loc_390:				; CODE XREF: RAM:02E1j
		ld	de, loc_423
		jp	loc_2E7
; ---------------------------------------------------------------------------
a@AStart?:	.ascii '\v\n'           ; DATA XREF: RAM:0318o
		.ascii '\n'
		.ascii '\x1B@\x1Ba\x0E  start?',0
aMonitor:	.ascii 'monitor',0      ; DATA XREF: RAM:02C5o
aAdr_4000:	.ascii 'adr.4000',0     ; DATA XREF: RAM:loc_386o
aMagnitofon:	.ascii 'magnitofon',0   ; DATA XREF: RAM:02CDo
aDop_pzu:	.ascii 'dop.pzu',0      ; DATA XREF: RAM:02F9o
aSetx:		.ascii 'setx',0         ; DATA XREF: RAM:030Bo
aDisk:		.ascii 'disk',0         ; DATA XREF: RAM:02D5o
a_mezhduelement:.ascii '\n'             ; DATA XREF: sub_404+1o
		.ascii '\r  - - - - -\n'
		.ascii '\r  ',0
PuskWk:		.ascii '\x1BY5*pusk=wk\x0F',0 ; DATA XREF: RAM:0344o
a_clearSellection?:db 0Dh, 20h,	0Bh, 0Ah, 0Ah ;	DATA XREF: RAM:034Bo
a_selected:	db 0Dh,	20h, 0Ah, 0Ah, 0Dh, 1, 1Ah, 0 ;	DATA XREF: RAM:0362o
a_CursorOn:	db 1Bh,	62h, 0		; DATA XREF: RAM:037Fo

; =============== S U B	R O U T	I N E =======================================


sub_404:				; CODE XREF: RAM:033Cp
		push	de
		ld	de, a_mezhduelement ; "\n\r  - - - - -\n\r  "
		call	PutString_DE
		pop	de
; End of function sub_404


; =============== S U B	R O U T	I N E =======================================


PutString_DE:				; CODE XREF: _Logo_and_inits-1783j
					; RAM:0329p ...
		push	af
		push	bc
		push	hl

loc_40F:				; CODE XREF: PutString_DE+10j
		ld	a, (de)
		cp	0
		jp	z, loc_41F
		ld	c, a
		push	de
		call	ConOut
		pop	de
		inc	de
		jp	loc_40F
; ---------------------------------------------------------------------------

loc_41F:				; CODE XREF: PutString_DE+6j
		pop	hl
		pop	bc
		pop	af
		ret
; End of function PutString_DE

; ---------------------------------------------------------------------------

loc_423:				; DATA XREF: RAM:loc_390o
		nop
		nop
		nop
		jp	loc_1800
; ---------------------------------------------------------------------------
aDk2?:		.ascii 'DK2?',0
; ---------------------------------------------------------------------------

_Run_NET:				; DATA XREF: RAM:0310o
		ld	hl, aNet?	; "NET?"
		jp	_MenuError
; ---------------------------------------------------------------------------
aNet?:		.ascii 'NET?',0         ; DATA XREF: RAM:_Run_NETo
; ---------------------------------------------------------------------------

_runDisk1?:				; CODE XREF: RAM:0440j	RAM:045Dj
					; DATA XREF: ...
		ld	a, 0A0h	; ''
		out	(50h), a
		call	_dsk_Wait?
		jp	c, _runDisk1?
		ld	a, 23h ; '#'
		out	(50h), a
		ld	hl, byte_A000
		ld	c, 80h ; ''

loc_44C:				; CODE XREF: RAM:044Fj	RAM:0457j
		in	a, (50h)
		rla
		jp	nc, loc_44C
		in	a, (51h)
		ld	(hl), a
		inc	hl
		dec	c
		jp	nz, loc_44C
		call	_dsk_Wait?
		jp	c, _runDisk1?
		jp	byte_A000

; =============== S U B	R O U T	I N E =======================================


_dsk_Wait?:				; CODE XREF: RAM:043Dp	RAM:045Ap ...
		in	a, (50h)
		rla
		rla
		rla
		rla
		jp	nc, _dsk_Wait?
		rra
		ret
; End of function _dsk_Wait?

; ---------------------------------------------------------------------------

_Magnitofon:				; DATA XREF: RAM:02D1o
		ld	de, aMlZagruzka	; "\f\x1BY0*\x0E"
		call	PutString_DE
		ld	hl, 0A000h
		ld	bc, 100h
		call	_TAPEREA
		jp	nc, byte_A000
		ld	de, aOIbkaMl	; "\x0EO[IBKA ML\x0F"

_MenuError:				; CODE XREF: RAM:0431j	RAM:052Cj ...
		push	de
		ld	de, aY2		; "\x1BY2*\a"
		call	PutString_DE
		pop	de
		call	PutString_DE
		call	_CONIN?
		ld	c, 0Ch
		call	ConOut
		jp	loc_2AE
; ---------------------------------------------------------------------------
aMlZagruzka:	.ascii '\f\x1BY0*\x0E'  ; DATA XREF: RAM:_Magnitofono
		.ascii 'ML-ZAGRUZKA\x0F',0
aY2:		.ascii '\x1BY2*\a',0    ; DATA XREF: RAM:0484o
aOIbkaMl:	.ascii '\x0EO[IBKA ML\x0F',0 ; DATA XREF: RAM:0480o
; ---------------------------------------------------------------------------

loc_4BE:				; DATA XREF: RAM:05D3o
		in	a, (12h)
		or	8
		out	(12h), a
		ld	a, b
		or	c
		jp	z, byte_DF53
		in	a, (14h)
		ld	(de), a
		dec	bc
		inc	de
		jp	byte_DF46
; ---------------------------------------------------------------------------
		in	a, (12h)
		and	0F3h ; ''
		out	(12h), a
		ret
; ---------------------------------------------------------------------------
		in	a, (12h)
		or	8
		out	(12h), a
		jp	(hl)

; =============== S U B	R O U T	I N E =======================================


sub_4DF:				; CODE XREF: sub_4DF+6j sub_4E8+7p ...
		ld	a, b
		or	c
		ret	z
		dec	bc
		in	a, (14h)
		jp	sub_4DF
; End of function sub_4DF


; =============== S U B	R O U T	I N E =======================================


sub_4E8:				; CODE XREF: RAM:05A5p	RAM:05AEp
		ld	hl, (_ExtRomAddr???)
		add	hl, bc
		ld	(_ExtRomAddr???), hl
		call	sub_4DF
; End of function sub_4E8


; =============== S U B	R O U T	I N E =======================================


_CheckExtRomEmpty:			; CODE XREF: RAM:02F1p	RAM:0516p
		ld	hl, (_ExtRomAddr???)

loc_4F5:				; CODE XREF: _CheckExtRomEmpty+Cj
		inc	hl
		ld	a, h
		or	l
		ret	z
		in	a, (ROMDISK_PORT)
		cp	0FFh
		ret	nz
		jp	loc_4F5
; End of function _CheckExtRomEmpty

; ---------------------------------------------------------------------------

_Run_Dop_Pzu:				; DATA XREF: RAM:02FDo
		out	(14h), a
		ld	de, _MenuItemsFromRom
		ld	hl, _MainMenuElemnts
		ld	(word_CF02), hl
		ld	hl, 0
		ld	(_ExtRomAddr???), hl
		xor	a
		ld	(_MainMenuElemnts), a
		call	_CheckExtRomEmpty

loc_519:				; CODE XREF: RAM:05A8j	RAM:05B1j
		ld	(_ExtRomAddr???), hl
		jp	z, loc_52F
		cp	0E5h ; ''
		jp	z, loc_573
		cp	5Eh ; '^'
		jp	z, loc_5AB
		ld	de, 549h
		jp	_MenuError
; ---------------------------------------------------------------------------

loc_52F:				; CODE XREF: RAM:051Cj
		ld	a, (_MainMenuElemnts)
		or	a
		jp	nz, loc_552
		ld	de, aPzuPusto	; "\x0EPZU PUSTO\x0F\a"
		jp	_MenuError
; ---------------------------------------------------------------------------
aPzuPusto:	.ascii '\x0EPZU PUSTO\x0F\a',0 ; DATA XREF: RAM:0536o
aO_pzu:		.ascii '\x0Eo{.pzu\x0F',0
; ---------------------------------------------------------------------------

loc_552:				; CODE XREF: RAM:0533j
		ld	hl, aAFajlyPzu	; "\f\n\x1Ba\n\a\x0E   FAJLY PZU\r"
		ld	(_MainMenuMainText), hl
		ld	hl, 0CEFFh
		jp	_MENU
; ---------------------------------------------------------------------------
aAFajlyPzu:	.ascii '\f\n'           ; DATA XREF: RAM:loc_552o
		.ascii '\x1Ba\n'
		.ascii '\a\x0E   FAJLY PZU\r',0
; ---------------------------------------------------------------------------

loc_573:				; CODE XREF: RAM:0521j
		ld	hl, _MainMenuElemnts
		inc	(hl)
		call	sub_5B4
		ld	hl, 0
		add	hl, sp
		ld	(word_CF04), hl
		ld	hl, (word_CF02)
		ld	sp, hl
		push	de
		ld	hl, loc_5D1
		push	hl
		ld	hl, 0
		add	hl, sp
		ld	(word_CF02), hl
		ld	hl, (word_CF04)
		ld	sp, hl

loc_595:				; CODE XREF: RAM:05A2j
		ld	hl, (_ExtRomAddr???)
		inc	hl
		ld	(_ExtRomAddr???), hl
		in	a, (ROMDISK_PORT)
		ld	(de), a
		inc	de
		cp	0
		jp	nz, loc_595
		call	sub_4E8
		jp	loc_519
; ---------------------------------------------------------------------------

loc_5AB:				; CODE XREF: RAM:0526j
		call	sub_5B4
		call	sub_4E8
		jp	loc_519

; =============== S U B	R O U T	I N E =======================================


sub_5B4:				; CODE XREF: RAM:0577p	RAM:loc_5ABp
		ld	hl, (_ExtRomAddr???)
		inc	hl
		inc	hl
		inc	hl
		inc	hl
		ld	(_ExtRomAddr???), hl

loc_5BE:				; CODE XREF: RAM:05EAp	RAM:05FBp
		in	a, (14h)
		in	a, (14h)
		in	a, (14h)
		ld	b, a
		in	a, (14h)
		ld	c, a
		ret
; End of function sub_5B4


; =============== S U B	R O U T	I N E =======================================


sub_5C9:				; CODE XREF: sub_5C9+4j RAM:05E1p ...
		in	a, (14h)
		cp	0FFh
		jp	z, sub_5C9
		ret
; End of function sub_5C9

; ---------------------------------------------------------------------------

loc_5D1:				; DATA XREF: RAM:0586o
		inc	b
		push	bc
		ld	hl, loc_4BE
		ld	de, byte_DF40
		ld	bc, 33
		call	_LDIR
		out	(14h), a
		call	sub_5C9

loc_5E4:				; CODE XREF: RAM:05F8j
		pop	bc
		dec	b
		jp	z, loc_604
		push	bc
		call	loc_5BE
		call	sub_620
		call	sub_4DF

loc_5F3:				; CODE XREF: RAM:0601j
		call	sub_5C9
		cp	0E5h ; ''
		jp	z, loc_5E4
		call	loc_5BE
		call	sub_4DF
		jp	loc_5F3
; ---------------------------------------------------------------------------

loc_604:				; CODE XREF: RAM:05E6j
		call	sub_628
		ld	h, d
		ld	l, e
		call	sub_620
		call	byte_DF40

loc_60F:				; CODE XREF: RAM:061Dj
		call	sub_5C9
		cp	0E5h ; ''
		jp	z, byte_DF5A
		call	sub_628
		call	byte_DF40
		jp	loc_60F

; =============== S U B	R O U T	I N E =======================================


sub_620:				; CODE XREF: RAM:05EDp	RAM:0609p ...
		in	a, (14h)
		cp	0
		ret	z
		jp	sub_620
; End of function sub_620


; =============== S U B	R O U T	I N E =======================================


sub_628:				; CODE XREF: RAM:loc_604p RAM:0617p
		in	a, (14h)
		ld	d, a
		in	a, (14h)
		ld	e, a
		in	a, (14h)
		ld	b, a
		in	a, (14h)
		ld	c, a
		ret
; End of function sub_628


; =============== S U B	R O U T	I N E =======================================


_TAPEREA:				; CODE XREF: RAM:TAPEREAj RAM:047Ap

arg_11		=  13h

		ld	a, _C7_0
		out	(PPA_RUS), a
		push	hl
		push	bc
		call	sub_703
		pop	bc
		pop	hl

loc_640:				; CODE XREF: _TAPEREA+1Aj
		push	hl
		push	bc
		call	sub_75E
		pop	bc
		pop	hl
		jp	c, loc_652
		ld	(hl), a
		dec	bc
		inc	hl
		ld	a, b
		or	c
		jp	nz, loc_640

loc_652:				; CODE XREF: _TAPEREA+12j
		push	hl
		push	af
		call	sub_683
		pop	af
		pop	hl
		ret
; End of function _TAPEREA

; ---------------------------------------------------------------------------

_TAPEWRI:				; CODE XREF: RAM:TAPEWRIj
		push	hl
		push	bc
		call	sub_68F
		pop	bc
		pop	hl

loc_661:				; CODE XREF: RAM:066Dj
		push	bc
		push	hl
		ld	a, (hl)
		call	sub_6BA
		pop	hl
		pop	bc
		inc	hl
		dec	bc
		ld	a, b
		or	c
		jp	nz, loc_661
		push	hl
		call	sub_676
		pop	hl
		ret

; =============== S U B	R O U T	I N E =======================================


sub_676:				; CODE XREF: RAM:0671p
		push	bc
		push	af
		ld	bc, 0

loc_67B:				; CODE XREF: sub_676+8j
		dec	bc
		ld	a, b
		or	c
		jp	nz, loc_67B
		pop	af
		pop	bc
; End of function sub_676


; =============== S U B	R O U T	I N E =======================================


sub_683:				; CODE XREF: _TAPEREA+1Fp
		push	af
		ld	a, 0
		out	(7), a
		ld	a, 0Eh
		out	(13h), a
		pop	af
		ei
		ret
; End of function sub_683


; =============== S U B	R O U T	I N E =======================================


sub_68F:				; CODE XREF: RAM:065Cp
		or	a
		push	af
		ld	a, 2
		out	(VV51_StatCtrl), a
		ld	hl, 0

loc_698:				; CODE XREF: sub_68F+Cj
		dec	hl
		ld	a, h
		or	l
		jp	nz, loc_698
		pop	af
		ld	bc, 0FA0h
		jp	z, loc_6A8
		ld	bc, 3E80h

loc_6A8:				; CODE XREF: sub_68F+13j
		ld	a, 0Fh
		out	(13h), a
		di

loc_6AD:				; CODE XREF: sub_68F+27j
		call	sub_6EB
		call	nullsub_1
		dec	bc
		ld	a, b
		or	c
		jp	nz, loc_6AD
		ret
; End of function sub_68F


; =============== S U B	R O U T	I N E =======================================


sub_6BA:				; CODE XREF: RAM:0664p
		ld	hl, 2826h
		push	af
		ld	a, l
		sub	2
		ld	l, a
		call	sub_6F0
		pop	af
		ld	b, 8

loc_6C8:				; CODE XREF: sub_6BA+16j
		rrca
		call	c, sub_6E4
		call	nc, sub_6DB
		dec	b
		jp	nz, loc_6C8
		call	sub_6E4
		call	sub_6E4
		or	a
		ret
; End of function sub_6BA


; =============== S U B	R O U T	I N E =======================================


sub_6DB:				; CODE XREF: sub_6BA+12p
		ld	hl, 2826h
		nop
		nop
		call	sub_6F0
; End of function sub_6DB

; [00000001 BYTES: COLLAPSED FUNCTION nullsub_1. PRESS KEYPAD "+" TO EXPAND]

; =============== S U B	R O U T	I N E =======================================


sub_6E4:				; CODE XREF: sub_6BA+Fp sub_6BA+19p ...
		call	sub_6EB
		call	sub_6EB
		ret
; End of function sub_6E4


; =============== S U B	R O U T	I N E =======================================


sub_6EB:				; CODE XREF: sub_68F:loc_6ADp sub_6E4p ...
		ld	hl, 1017h
		nop
		nop
; End of function sub_6EB


; =============== S U B	R O U T	I N E =======================================


sub_6F0:				; CODE XREF: sub_6BA+8p sub_6DB+5p
		push	af

loc_6F1:				; CODE XREF: sub_6F0+2j
		dec	l
		jp	nz, loc_6F1
		ld	a, 80h ; ''
		out	(10h), a

loc_6F9:				; CODE XREF: sub_6F0+Aj
		dec	h
		jp	nz, loc_6F9
		ld	a, 0
		out	(10h), a
		pop	af
		ret
; End of function sub_6F0


; =============== S U B	R O U T	I N E =======================================


sub_703:				; CODE XREF: _TAPEREA+6p
		di
		ld	a, _C7_0
		out	(PPA_RUS), a
		ld	a, 2
		out	(VV51_StatCtrl), a

loc_70C:				; CODE XREF: sub_703+14j sub_703+19j ...
		ld	hl, 7A1h

loc_70F:				; CODE XREF: sub_703+2Aj
		ld	d, c
		call	sub_7DF
		ret	c
		ld	a, c
		cp	0DEh ; ''
		jp	nc, loc_70C
		cp	5
		jp	c, loc_70C
		sub	d
		jp	nc, loc_725
		cpl
		inc	a

loc_725:				; CODE XREF: sub_703+1Dj
		cp	8
		jp	nc, loc_70C
		dec	hl
		ld	a, h
		or	l
		jp	nz, loc_70F
		ld	hl, 0
		ld	b, l
		ld	d, l

loc_735:				; CODE XREF: sub_703+38j
		call	sub_7DF
		ret	c
		add	hl, bc
		dec	d
		jp	nz, loc_735
		ld	bc, 6AEh
		add	hl, bc
		ld	a, h
		rra
		and	7Fh ; ''
		ld	d, a
		add	hl, hl
		ld	a, h
		sub	d
		ld	d, a
		sub	4
		ld	(byte_FFBE), a
		ld	a, d
		add	a, a
		add	a, d
		and	0FCh ; ''
		rrca
		rrca
		sub	7
		ld	(byte_FFBC), a
		or	a
		ret
; End of function sub_703


; =============== S U B	R O U T	I N E =======================================


sub_75E:				; CODE XREF: _TAPEREA+Dp
		ld	a, (byte_FFBE)
		ld	d, a

loc_762:				; CODE XREF: sub_75E+Bj
		call	sub_7F1
		ret	c
		in	a, (7)
		rlca
		jp	nc, loc_762

loc_76C:				; CODE XREF: sub_75E+15j
		call	sub_7F1
		ret	c
		in	a, (7)
		rlca
		jp	c, loc_76C
		ld	e, 0
		call	sub_7C9

loc_77B:				; CODE XREF: sub_75E+24j sub_75E+28j
		ld	b, c
		call	sub_7C9
		ret	c
		ld	a, b
		add	a, c
		jp	c, loc_77B
		cp	d
		jp	c, loc_77B
		ld	l, 8

loc_78B:				; CODE XREF: sub_75E+43j
		call	sub_7A9
		cp	4
		ccf
		ret	c
		cp	2
		ccf
		ld	a, d
		rra
		ld	d, a
		ld	a, c
		rrca
		call	nc, sub_7CD
		call	sub_7C9
		dec	l
		jp	nz, loc_78B
		call	sub_7F1
		ld	a, d
		ret
; End of function sub_75E


; =============== S U B	R O U T	I N E =======================================


sub_7A9:				; CODE XREF: sub_75E:loc_78Bp
		ld	a, (byte_FFBC)
		ld	b, a
		ld	c, 0

loc_7AF:				; CODE XREF: sub_7A9+11j sub_7A9+1Bj
		in	a, (7)
		xor	e
		jp	p, loc_7BF
		ld	a, e
		cpl
		ld	e, a
		inc	c
		dec	b
		jp	nz, loc_7AF
		ld	a, c
		ret
; ---------------------------------------------------------------------------

loc_7BF:				; CODE XREF: sub_7A9+9j
		nop
		nop
		nop
		inc	a
		dec	b
		jp	nz, loc_7AF
		ld	a, c
		ret
; End of function sub_7A9


; =============== S U B	R O U T	I N E =======================================


sub_7C9:				; CODE XREF: sub_75E+1Ap sub_75E+1Ep ...
		call	sub_7F1
		ret	c
; End of function sub_7C9


; =============== S U B	R O U T	I N E =======================================


sub_7CD:				; CODE XREF: sub_75E+3Cp sub_7DF+Cp
		ld	c, 0

loc_7CF:				; CODE XREF: sub_7CD+9j sub_7DF+Fj
		inc	c
		jp	z, loc_7DD
		in	a, (7)
		xor	e
		jp	p, loc_7CF
		ld	a, e
		cpl
		ld	e, a
		ret
; ---------------------------------------------------------------------------

loc_7DD:				; CODE XREF: sub_7CD+3j
		dec	c
		ret
; End of function sub_7CD


; =============== S U B	R O U T	I N E =======================================


sub_7DF:				; CODE XREF: sub_703+Dp
					; sub_703:loc_735p ...
		call	sub_7F1
		ret	c
		in	a, (VV51_StatCtrl)
		rlca
		jp	c, sub_7DF
		ld	e, 0
		call	sub_7CD
		jp	loc_7CF
; End of function sub_7DF


; =============== S U B	R O U T	I N E =======================================


sub_7F1:				; CODE XREF: sub_75E:loc_762p
					; sub_75E:loc_76Cp ...
		in	a, (11h)
		rlca
		inc	a
		inc	a
		inc	a
		inc	a
		ret
; End of function sub_7F1

; ---------------------------------------------------------------------------
aRtv0687:	.ascii 'rtv0687'
; ---------------------------------------------------------------------------

_RunDebugger:				; DATA XREF: RAM:02BDr	RAM:02C9o
		ld	hl, __Debugger
		ld	de, MonitorHere
		ld	bc, 1000h
		call	_LDIR
		jp	MonitorHere
; ---------------------------------------------------------------------------
		db 0FFh
__Debugger:	db 0C3h, 8Dh, 9Fh, 0C3h, 15h, 90h, 0C3h, 0FAh, 9Eh, 0C3h
					; DATA XREF: RAM:_RunDebuggero
		db 9, 9Fh, 0C3h, 0E0h, 9Eh, 0C3h, 0B2h,	9Fh, 0C3h, 99h
		db 9Fh,	21h, 0FBh, 9Ch,	22h, 9,	0, 3Eh,	0C3h, 32h, 8, 0
		db 3Eh,	20h, 32h, 2Bh, 0A0h, 21h, 2Ch, 97h, 11h, 83h, 0A0h
		db 6, 0Bh, 7Eh,	12h, 23h, 13h, 5, 0C2h,	2Dh, 90h, 21h
		db 4Ah,	90h, 4Eh, 0AFh,	32h, 93h, 0A0h,	0B9h, 0CAh, 0B3h
		db 96h,	23h, 0E5h, 0CDh, 0Ch, 90h, 0E1h, 0C3h, 38h, 90h
		db 0Ch,	0Eh, 69h, 72h, 69h, 7Bh, 61h, 20h, 6Fh,	74h, 6Ch
		db 61h,	64h, 7Eh, 69h, 6Bh, 0Fh, 0Dh, 0Ah, 0, 0F5h, 79h
		db 0CDh, 60h, 9Eh, 0F1h, 0C9h, 0FEh, 20h, 0C8h,	0FEh, 9
		db 0C8h, 0FEh, 2Ch, 0C8h, 0FEh,	0Dh, 0C8h, 0FEh, 7Fh, 0CAh
		db 5Dh,	95h, 0C9h, 0Eh,	0Dh, 0CDh, 5Eh,	90h, 0Eh, 0Ah
		db 0CDh, 5Eh, 90h, 0C9h, 0CDh, 4, 9Bh, 0FEh, 0Dh, 0CAh
		db 51h,	95h, 0CDh, 65h,	90h, 0CAh, 82h,	90h, 0Eh, 4, 21h
		db 9, 0A0h, 36h, 20h, 23h, 0Dh,	0C2h, 95h, 90h,	0Eh, 5
		db 21h,	9, 0A0h, 77h, 0CDh, 4, 9Bh, 0CDh, 65h, 90h, 0CAh
		db 0B3h, 90h, 23h, 0Dh,	0CAh, 51h, 95h,	0C3h, 0A1h, 90h
		db 3Ah,	9, 0A0h, 0FEh, 20h, 0C9h, 0CDh,	0A9h, 9Bh, 3Dh
		db 0C2h, 51h, 95h, 0EBh, 4Eh, 23h, 46h,	79h, 5,	4, 0C9h
		db 0CDh, 0B9h, 90h, 0C2h, 51h, 95h, 0C9h
		db [ 3 ], 17h
		db 0E6h, 38h, 0C9h
		db [ 4 ], 17h
		db 0E6h, 30h, 0C9h, 0EBh, 2Ah, 9, 0A0h,	0EBh, 7Bh, 0BEh
		db 0C2h, 0EBh, 90h, 23h, 7Ah, 0BEh, 0C8h
		db [ 3 ], 2Bh
		db 0Dh,	0C2h, 0E1h, 90h, 0Dh, 0C9h, 6, 4, 0D5h,	11h, 9
		db 0A0h, 1Ah, 0BEh, 0C2h, 6, 91h, 23h, 13h, 5, 0C2h, 0F9h
		db 90h,	0D1h, 0C9h, 23h, 5, 0C2h, 6, 91h, 11h, 0F8h, 0FFh
		db 19h,	0D1h, 13h, 0Dh,	0C2h, 0F3h, 90h, 0Dh, 0C9h, 0C5h
		db 0CDh, 82h, 90h, 0CAh, 51h, 95h, 0Eh,	8, 21h,	99h, 96h
		db 0CDh, 0DCh, 90h, 0C2h, 51h, 95h, 0Dh, 79h, 0C1h, 0C9h
		db 0C5h, 0CDh, 82h, 90h, 0CAh, 51h, 95h, 0Eh, 5, 21h, 0ABh
		db 96h,	0CDh, 0F3h, 90h, 0C2h, 51h, 95h, 0Dh, 79h, 0C1h
		db 0C9h, 0CDh, 2Dh, 91h, 0FEh, 4, 0CAh,	51h, 95h, 0C9h
		db 0CDh, 2Dh, 91h, 0FEh, 3, 0CAh, 51h, 95h, 0FEh, 4, 0C0h
		db 3Dh,	0C9h, 21h, 9, 0A0h, 11h, 0Ah, 0A0h, 0Eh, 2, 1Ah
		db 77h,	23h, 13h, 0Dh, 0C2h, 61h, 91h, 1Ah, 0FEh, 20h
		db 0C2h, 51h, 95h, 77h,	21h, 89h, 96h, 0Eh, 8, 0CDh, 0DCh
		db 90h,	0C2h, 51h, 95h,	0Dh, 79h, 0CDh,	0CFh, 90h, 0C9h
		db 0CDh, 59h, 91h, 0F5h, 0CDh, 0B9h, 90h, 0F1h,	0F6h, 0C0h
		db 0C9h, 1Ah, 2Ah, 5, 0A0h, 77h, 23h, 22h, 5, 0A0h, 0C9h
		db 0CDh, 4, 9Bh, 0FEh, 0Dh, 0CAh, 79h, 95h, 0FEh, 2Eh
		db 0CAh, 79h, 95h, 0CDh, 85h, 90h, 0CAh, 51h, 95h, 0Eh
		db 11h,	21h, 0DFh, 95h,	11h, 7Eh, 95h, 0CDh, 0F3h, 90h
		db 0C2h, 0BAh, 91h, 0C3h, 8Ch, 91h, 0Eh, 0Ah, 21h, 7, 96h
		db 0CDh, 0F3h, 90h, 0C2h, 0CEh,	91h, 0CDh, 8Ch,	91h, 0CDh
		db 0C8h, 90h, 0C3h, 8Dh, 91h, 0Eh, 6, 21h, 1Fh,	96h, 0CDh
		db 0F3h, 90h, 0C2h, 0E6h, 91h, 0CDh, 8Ch, 91h, 0CDh, 0B9h
		db 90h,	0CDh, 8Dh, 91h,	78h, 0C3h, 8Dh,	91h, 0Eh, 1, 21h
		db 23h,	96h, 0CDh, 0F3h, 90h, 0C2h, 2, 92h, 0CDh, 17h
		db 91h,	0CDh, 0CFh, 90h, 47h, 0Eh, 40h,	0CDh, 17h, 91h
		db 0B1h, 0B0h, 0C3h, 8Dh, 91h, 0Eh, 8, 21h, 43h, 96h, 0CDh
		db 0F3h, 90h, 0C2h, 18h, 92h, 0Dh, 79h,	0CDh, 0CFh, 90h
		db 47h,	0Eh, 80h, 0C3h,	0FAh, 91h, 0Eh,	2, 21h,	4Bh, 96h
		db 0CDh, 0F3h, 90h, 0C2h, 30h, 92h
		db [ 3 ], 0Ch
		db 0CDh, 17h, 91h, 0CDh, 0CFh, 90h, 0B1h, 0C3h,	8Dh, 91h
		db 0Eh,	1, 21h,	4Fh, 96h, 0CDh,	0F3h, 90h, 0C2h, 4Ch, 92h
		db 0CDh, 17h, 91h, 0CDh, 0CFh, 90h, 0F6h, 6, 0CDh, 8Dh
		db 91h,	0CDh, 0C8h, 90h, 0C3h, 8Dh, 91h, 0Eh, 6, 21h, 67h
		db 96h,	0CDh, 0F3h, 90h, 0C2h, 72h, 92h, 79h, 0FEh, 4
		db 0DAh, 5Fh, 92h, 0C6h, 5, 47h, 0CDh, 43h, 91h, 0CDh
		db 0D5h, 90h, 0B0h, 0CDh, 8Dh, 91h, 0E6h, 0CFh,	0FEh, 1
		db 0C0h, 0C3h, 0DCh, 91h, 0Eh, 1, 21h, 6Bh, 96h, 0CDh
		db 0F3h, 90h, 0C2h, 8Dh, 92h, 0CDh, 0C8h, 90h, 0FEh, 8
		db 0D2h, 51h, 95h, 0CDh, 0CFh, 90h, 0F6h, 0C7h,	0C3h, 8Dh
		db 91h,	0Eh, 2,	21h, 77h, 96h, 0CDh, 0F3h, 90h,	0C2h, 0ADh
		db 92h,	0Dh, 0C2h, 0A1h, 92h, 0Eh, 0C1h, 0C3h, 0A3h, 92h
		db 0Eh,	0C5h, 0CDh, 4Ch, 91h, 0CDh, 0D5h, 90h, 0B1h, 0C3h
		db 8Dh,	91h, 3Ah, 9, 0A0h, 0FEh, 4Ah, 0C2h, 0BDh, 92h
		db 0CDh, 81h, 91h, 0F6h, 2, 0C3h, 0C7h,	92h, 0FEh, 43h
		db 0C2h, 0D2h, 92h, 0CDh, 81h, 91h, 0F6h, 4, 0CDh, 8Dh
		db 91h,	79h, 0CDh, 8Dh,	91h, 78h, 0C3h,	8Dh, 91h, 0FEh
		db 52h,	0C2h, 51h, 95h,	0CDh, 59h, 91h,	0F6h, 0C0h, 0C3h
		db 8Dh,	91h, 2Ah, 2, 0A0h, 0D5h, 0EBh, 2Ah, 0, 0A0h, 7Bh
		db 95h,	7Ah, 9Ch, 0D2h,	0F3h, 92h, 2Ah,	7, 0A0h, 0F9h
		db 0C9h, 0D1h, 7Eh, 23h, 22h, 0, 0A0h, 0C9h, 3Ch, 0E6h
		db 7, 0FEh, 6, 0DAh, 4,	93h, 0C6h, 3, 0FEh, 5, 0DAh, 0Bh
		db 93h,	0C6h, 2, 0C6h, 41h, 4Fh, 0C3h, 5Eh, 90h, 47h, 0E6h
		db 0F0h
		db [ 4 ], 0Fh
		db 0C6h, 90h, 27h, 0CEh, 40h, 27h, 4Fh,	0CDh, 5Eh, 90h
		db 78h,	0E6h, 0Fh, 0C6h, 90h, 27h, 0CEh, 40h, 27h, 4Fh
		db 0C3h, 5Eh, 90h, 6, 4, 4Eh, 0CDh, 5Eh, 90h, 23h, 5, 0C2h
		db 31h,	93h, 0Eh, 20h, 0C3h, 5Eh, 90h, 7Ah, 0E6h, 38h
		db [ 3 ], 0Fh
		db 0C9h, 0CDh, 3Fh, 93h, 87h, 4Fh, 21h,	7Bh, 96h, 9, 4Eh
		db 0CDh, 5Eh, 90h, 23h,	4Eh, 0CDh, 5Eh,	90h, 0Eh, 20h
		db 0CDh, 5Eh, 90h, 0C3h, 5Eh, 90h, 0CDh, 3Fh, 93h, 0E6h
		db 6, 0FEh, 6, 0C2h, 0FAh, 92h,	0Eh, 53h, 0CDh,	5Eh, 90h
		db 0Eh,	50h, 0C3h, 5Eh,	90h, 0CDh, 77h,	90h, 2Ah, 0, 0A0h
		db 7Ch,	0CDh, 11h, 93h,	7Dh, 0CDh, 11h,	93h, 0Eh, 20h
		db 0CDh, 5Eh, 90h, 0CDh, 5Eh, 90h, 0C9h, 21h
		db [ 2 ], 0
		db 39h,	22h, 7,	0A0h, 3Ah, 4, 0A0h, 0B7h, 0CAh,	0ADh, 93h
		db 21h
		db [ 2 ], 0FFh
		db 22h,	2, 0A0h, 3Ch, 0C2h, 0ADh, 93h, 3Ch, 32h, 4, 0A0h
		db 2Ah,	0, 0A0h, 0C3h, 0D0h, 93h, 0CDh,	0BCh, 9Eh, 0DAh
		db 79h,	95h, 21h, 4, 0A0h, 7Eh,	0B7h, 0CAh, 0BFh, 93h
		db 35h,	0CAh, 79h, 95h,	2Ah, 0,	0A0h, 0CDh, 77h, 90h, 0Eh
		db 20h,	0CDh, 5Eh, 90h,	0CDh, 5Eh, 90h,	0CDh, 77h, 93h
		db 0CDh, 0DFh, 92h, 57h, 21h, 7Eh, 95h,	1, 11h,	0, 0BEh
		db 0CAh, 36h, 95h, 23h,	0Dh, 0C2h, 0DAh, 93h, 0Eh, 0Ah
		db 0BEh, 0CAh, 22h, 95h, 23h, 0Dh, 0C2h, 0E5h, 93h, 0Eh
		db 6, 0BEh, 0CAh, 7, 95h, 23h, 0Dh, 0C2h, 0F0h,	93h, 0E6h
		db 0C0h, 0FEh, 40h, 0CAh, 0EDh,	94h, 0FEh, 80h,	0CAh, 0DEh
		db 94h,	7Ah, 0E6h, 0C7h, 0D6h, 4, 0CAh,	0CFh, 94h, 3Dh
		db 0CAh, 0C9h, 94h, 3Dh, 0CAh, 0B5h, 94h, 7Ah, 0E6h, 0C0h
		db 0CAh, 83h, 94h, 7Ah,	0E6h, 7, 0CAh, 78h, 94h, 0D6h
		db 2, 0CAh, 6Dh, 94h, 0D6h, 2, 0CAh, 62h, 94h, 0D6h, 3
		db 0CAh, 53h, 94h, 7Ah,	0E6h, 8, 0C2h, 44h, 95h, 7Ah, 0E6h
		db 7, 4Fh, 3Dh,	21h, 72h, 96h, 9, 0CDh,	2Fh, 93h, 0CDh
		db 3Fh,	93h, 0FEh, 6, 0C2h, 0D8h, 94h, 21h, 6Fh, 96h, 0CDh
		db 2Fh,	93h, 0C3h, 0ADh, 93h, 21h, 6Bh,	96h, 0CDh, 2Fh
		db 93h,	0CDh, 3Fh, 93h,	0CDh, 11h, 93h,	0C3h, 0ADh, 93h
		db 0Eh,	43h, 0CDh, 5Eh,	90h, 0CDh, 46h,	93h, 0C3h, 12h
		db 95h,	0Eh, 4Ah, 0CDh,	5Eh, 90h, 0CDh,	46h, 93h, 0C3h
		db 12h,	95h, 0Eh, 52h, 0CDh, 5Eh, 90h, 0CDh, 46h, 93h
		db 0C3h, 0ADh, 93h, 21h, 53h, 96h, 7Ah,	0E6h, 7, 0CAh
		db 44h,	95h, 7Ah, 0E6h,	0Fh, 3Dh, 0CAh,	0A7h, 94h, 0FEh
		db 3, 0DAh, 9Ah, 94h, 0D6h, 5
		db [ 2 ], 87h
		db 4Fh,	9, 0CDh, 2Fh, 93h, 0CDh, 60h, 93h, 0C3h, 0ADh
		db 93h,	0CDh, 2Fh, 93h,	0CDh, 60h, 93h,	0Eh, 2Ch, 0CDh
		db 5Eh,	90h, 0C3h, 12h,	95h, 21h, 4Fh, 96h, 0CDh, 2Fh
		db 93h,	0CDh, 3Fh, 93h,	0CDh, 0FAh, 92h, 0Eh, 2Ch, 0CDh
		db 5Eh,	90h, 0C3h, 2Dh,	95h, 21h, 4Bh, 96h, 0C3h, 0D2h
		db 94h,	21h, 47h, 96h, 0CDh, 2Fh, 93h, 0CDh, 3Fh, 93h
		db 0CDh, 0FAh, 92h, 0C3h, 0ADh,	93h, 7Ah, 0E6h,	38h, 0Fh
		db 4Fh,	21h, 27h, 96h, 9, 0CDh,	2Fh, 93h, 0C3h,	0FEh, 94h
		db 21h,	23h, 96h, 0CDh,	2Fh, 93h, 0CDh,	3Fh, 93h, 0CDh
		db 0FAh, 92h, 0Eh, 2Ch,	0CDh, 5Eh, 90h,	7Ah, 0E6h, 7, 0CDh
		db 0FAh, 92h, 0C3h, 0ADh, 93h, 79h
		db [ 2 ], 87h
		db 4Fh,	21h, 7,	96h, 9,	0CDh, 2Fh, 93h,	0CDh, 0DFh, 92h
		db 0F5h, 0CDh, 0DFh, 92h, 57h, 0F1h, 5Fh, 0CDh,	46h, 9Bh
		db 0C3h, 0ADh, 93h, 79h
		db [ 2 ], 87h
		db 4Fh,	21h, 0DFh, 95h,	9, 0CDh, 2Fh, 93h, 0CDh, 0DFh
		db 92h,	0CDh, 2Ch, 9Bh,	0C3h, 0ADh, 93h, 79h
		db [ 2 ], 87h
		db 4Fh,	21h, 9Bh, 95h, 9, 0CDh,	2Fh, 93h, 0C3h,	0ADh, 93h
		db 21h,	0AFh, 96h, 0CDh, 2Fh, 93h, 7Ah,	0CDh, 2Ch, 9Bh
		db 0C3h, 0ADh, 93h, 0CDh, 77h, 90h, 0Eh, 3Fh, 0CDh, 5Eh
		db 90h,	2Ah, 7,	0A0h, 0F9h, 21h
		db [ 2 ], 0
		db 39h,	22h, 7,	0A0h, 0CDh, 74h, 93h, 22h, 5, 0A0h, 0CDh
		db 6Bh,	9Eh, 0CDh, 96h,	91h, 2Ah, 5, 0A0h, 22h,	0, 0A0h
		db 0C3h, 64h, 95h, 2Ah,	7, 0A0h, 0F9h, 0C9h, 0,	7, 0Fh
		db 17h,	1Fh, 27h, 2Fh, 37h, 3Fh, 76h, 0C9h, 0E3h, 0E9h
		db 0EBh, 0F3h, 0F9h, 0FBh, 0C6h, 0CEh, 0D3h, 0D6h, 0DBh
		db 0DEh, 0E6h, 0EEh, 0F6h, 0FEh, 22h, 2Ah, 32h,	3Ah, 0C3h
		db 0CDh, 45h, 49h
		db [ 2 ], 20h
		db 53h,	50h, 48h, 4Ch, 44h, 49h
		db [ 2 ], 20h
		db 58h,	43h, 48h, 47h, 50h, 43h, 48h, 4Ch, 58h,	54h, 48h
		db 4Ch,	52h, 45h, 54h, 20h, 48h, 4Ch, 54h, 20h,	43h, 4Dh
		db 43h,	20h, 53h, 54h, 43h, 20h, 43h, 4Dh, 41h,	20h, 44h
		db [ 2 ], 41h
		db 20h,	52h, 41h, 52h, 20h, 52h, 41h, 4Ch, 20h
		db [ 2 ], 52h
		db 43h,	20h, 52h, 4Ch, 43h, 20h, 4Eh, 4Fh, 50h,	20h, 43h
		db 50h,	49h, 20h, 4Fh, 52h, 49h, 20h, 58h, 52h,	49h, 20h
		db 41h,	4Eh, 49h, 20h, 53h, 42h, 49h, 20h, 49h,	4Eh
		db [ 2 ], 20h
		db 53h,	55h, 49h, 20h, 4Fh, 55h, 54h, 20h, 41h,	43h, 49h
		db 20h,	41h, 44h, 49h, 20h, 43h, 41h
		db [ 2 ], 4Ch
		db 4Ah,	4Dh, 50h, 20h, 4Ch, 44h, 41h, 20h, 53h,	54h, 41h
		db 20h,	4Ch, 48h, 4Ch, 44h, 53h, 48h, 4Ch, 44h,	4Dh, 4Fh
		db 56h,	20h, 41h
		db [ 2 ], 44h
		db 20h,	41h, 44h, 43h, 20h, 53h, 55h, 42h, 20h,	53h
		db [ 2 ], 42h
		db 20h,	41h, 4Eh, 41h, 20h, 58h, 52h, 41h, 20h,	4Fh, 52h
		db 41h,	20h, 43h, 4Dh, 50h, 20h, 49h, 4Eh, 52h,	20h, 44h
		db 43h,	52h, 20h, 4Dh, 56h, 49h, 20h, 4Ch, 58h,	49h, 20h
		db 53h,	54h, 41h, 58h, 49h, 4Eh, 58h, 20h, 44h,	41h, 44h
		db 20h,	4Ch, 44h, 41h, 58h, 44h, 43h, 58h, 20h,	52h, 53h
		db 54h,	20h, 50h, 53h, 57h, 20h, 50h, 4Fh, 50h,	20h, 50h
		db 55h,	53h, 48h, 4Eh
		db [ 2 ], 5Ah
		db 20h,	4Eh
		db [ 2 ], 43h
		db 20h,	50h, 4Fh, 50h, 45h, 50h, 20h, 4Dh, 20h,	42h, 20h
		db 43h,	20h, 44h, 20h, 45h, 20h, 48h, 20h, 4Ch,	20h, 4Dh
		db 20h,	41h, 20h, 42h
		db [ 3 ], 20h
		db 44h
		db [ 3 ], 20h
		db 48h
		db [ 3 ], 20h
		db 53h,	50h
		db [ 2 ], 20h
		db 50h,	53h, 57h, 20h
		db [ 2 ], 3Fh
		db 3Dh,	20h, 32h, 15h, 0A0h, 32h, 92h, 0A0h, 21h, 0, 1
		db 22h,	0, 0A0h, 22h, 23h, 0A0h, 22h, 8Eh, 0A0h, 22h, 90h
		db 0A0h, 22h, 4Dh, 0A0h, 22h, 7Fh, 0A0h, 31h, 7Dh, 0A0h
		db 0E5h, 21h, 2, 0, 0E5h
		db [ 2 ], 2Bh
		db 22h,	7Dh, 0A0h
		db [ 2 ], 0E5h
		db 22h,	13h, 0A0h, 31h,	75h, 0A0h, 0CDh, 3Ch, 9Bh
		db [ 2 ], 3Eh
		db 0CDh, 60h, 9Eh, 0CDh, 6Bh, 9Eh, 0CDh, 4, 9Bh, 0FEh
		db 0Dh,	0CAh, 0E0h, 96h, 0D6h, 41h, 0DAh, 0EBh,	9Ah, 0FEh
		db 1Ah,	0D2h, 0EBh, 9Ah, 5Fh, 16h, 0, 21h, 0AEh, 97h
		db [ 2 ], 19h
		db 5Eh,	23h, 56h, 0EBh,	0E9h, 0CDh, 0A9h, 9Bh, 0FEh, 2
		db 0C2h, 0EBh, 9Ah, 0CDh, 7Fh, 9Bh, 22h, 23h, 0A0h, 7Dh
		db 32h,	84h, 0A0h, 0CDh, 7Fh, 9Bh, 22h,	25h, 0A0h, 7Dh
		db 32h,	86h, 0A0h, 0C3h, 83h, 0A0h, 3Eh, 0, 0D3h, 0, 0C3h
		db 0E0h, 96h, 0DBh, 0, 0C9h, 0CDh, 0A9h, 9Bh, 0FEh, 2
		db 0C2h, 0EBh, 9Ah, 0CDh, 7Fh, 9Bh, 0E5h, 0CDh,	7Fh, 9Bh
		db 44h,	4Dh, 0E1h, 0C3h, 12h, 90h, 0CDh, 0A9h, 9Bh, 0FEh
		db 2, 0C2h, 0EBh, 9Ah, 0CDh, 7Fh, 9Bh, 0E5h, 0CDh, 7Fh
		db 9Bh,	44h, 4Dh, 0E1h,	0C3h, 0Fh, 90h,	0CDh, 0A9h, 9Bh
		db 3Dh,	0C2h, 0EBh, 9Ah, 0CDh, 7Fh, 9Bh, 22h, 23h, 0A0h
		db 7Dh,	32h, 8Bh, 0A0h,	0CDh, 8Ah, 0A0h, 0F5h, 0CDh, 77h
		db 90h,	0CDh, 2Ch, 9Bh,	0CDh, 77h, 90h,	3Eh, 37h, 0F5h
		db 0CDh, 60h, 9Eh, 0F1h, 3Dh, 0FEh, 2Fh, 0C2h, 80h, 97h
		db 0CDh, 77h, 90h, 3Eh,	8, 32h,	23h, 0A0h, 0F1h, 7, 0F5h
		db 3Eh,	30h, 0D2h, 9Dh,	97h, 3Eh, 31h, 0CDh, 60h, 9Eh
		db 3Ah,	23h, 0A0h, 3Dh,	32h, 23h, 0A0h,	0C2h, 93h, 97h
		db 0F1h, 0C3h, 0E0h, 96h, 0E2h,	97h, 0EBh, 9Ah,	0EBh, 9Ah
		db 2Ah,	98h, 0EBh, 9Ah,	0C0h, 98h, 0, 99h, 80h,	99h, 60h
		db 97h,	0EBh, 9Ah, 0EBh, 9Ah, 0FBh, 97h, 0AAh, 99h, 0EBh
		db 9Ah,	0Dh, 97h, 0D4h,	98h, 0EBh, 9Ah,	36h, 97h, 0ECh
		db 99h,	35h, 9Ah, 31h, 9Ah, 0EBh, 9Ah, 4Bh, 97h, 5Eh, 9Ah
		db 0EBh, 9Ah, 0EBh, 9Ah, 0CDh, 0E3h, 99h, 0D2h,	0EBh, 9Ah
		db 0CDh, 0A9h, 9Bh, 3Dh, 0C2h, 0EBh, 9Ah, 0CDh,	7Fh, 9Bh
		db 22h,	0, 0A0h, 0CDh, 5Dh, 95h, 0C3h, 0E0h, 96h, 0CDh
		db 0E3h, 99h, 0D2h, 0EBh, 9Ah, 0CDh, 0A9h, 9Bh,	0CAh, 1Fh
		db 98h,	0CDh, 7Fh, 9Bh,	22h, 0,	0A0h, 3Dh, 0CAh, 1Fh, 98h
		db 0CDh, 7Fh, 9Bh, 22h,	2, 0A0h, 3Dh, 0C2h, 0EBh, 9Ah
		db 0AFh, 0C3h, 21h, 98h, 3Eh, 0Ch, 32h,	4, 0A0h, 0CDh
		db 8Bh,	93h, 0C3h, 0E0h, 96h, 0CDh, 0A9h, 9Bh, 0CAh, 49h
		db 98h,	0CDh, 7Fh, 9Bh,	0DAh, 39h, 98h,	22h, 23h, 0A0h
		db 0E6h, 7Fh, 3Dh, 0CAh, 49h, 98h, 0CDh, 7Fh, 9Bh, 3Dh
		db 0C2h, 0EBh, 9Ah, 0C3h, 54h, 98h, 2Ah, 23h, 0A0h, 7Dh
		db 0E6h, 0F0h, 6Fh, 11h, 7Fh, 0, 19h, 22h, 25h,	0A0h, 0CDh
		db 3Ch,	9Bh, 0CDh, 0BCh, 9Eh, 0DAh, 0E0h, 96h, 2Ah, 23h
		db 0A0h, 22h, 27h, 0A0h, 0CDh, 47h, 9Bh, 0CDh, 0F6h, 9Ah
		db 7Eh,	0CDh, 2Ch, 9Bh,	23h, 0CDh, 5Eh,	9Bh, 0DAh, 7Dh
		db 98h,	7Dh, 0E6h, 7, 0C2h, 69h, 98h, 22h, 23h,	0A0h, 2Ah
		db 27h,	0A0h, 0EBh, 0CDh, 0F6h,	9Ah, 1Ah, 0CDh,	4Fh, 9Bh
		db 13h,	2Ah, 23h, 0A0h,	7Dh, 93h, 0C2h,	87h, 98h, 7Ch
		db 92h,	0C2h, 87h, 98h,	2Ah, 23h, 0A0h,	0CDh, 5Eh, 9Bh
		db 0DAh, 0E0h, 96h, 0C3h, 57h, 98h, 0CDh, 0A9h,	9Bh, 0FEh
		db 3, 0C2h, 0EBh, 9Ah, 0CDh, 7Fh, 9Bh, 0E5h, 0CDh, 7Fh
		db 9Bh,	0E5h, 0CDh, 7Fh, 9Bh, 0D1h, 0C1h, 0C9h,	7Bh, 91h
		db 7Ah,	98h, 0C9h, 0CDh, 0A5h, 98h, 7Ch, 0B7h, 0C2h, 0EBh
		db 9Ah,	0CDh, 0BBh, 98h, 0DAh, 0E0h, 96h, 7Dh, 2, 3, 0C3h
		db 0C8h, 98h, 0CDh, 0C3h, 9Bh, 2Ah, 90h, 0A0h, 7Eh, 0FEh
		db 0CDh, 0C2h, 0EBh, 9Ah, 54h, 5Dh
		db [ 3 ], 13h
		db 3Ah,	92h, 0A0h, 0B7h, 0CAh, 0F6h, 98h, 0E5h,	2Ah, 7Bh
		db 0A0h
		db [ 2 ], 23h
		db 22h,	7Bh, 0A0h, 0E1h, 0AFh, 32h, 92h, 0A0h, 3Eh, 2
		db 0B7h, 0C3h, 19h, 99h, 0AFh, 32h, 92h, 0A0h, 0CDh, 3Ch
		db 9Bh,	0CDh, 0A9h, 9Bh, 0CDh, 7Fh, 9Bh, 0E5h, 0CDh, 7Fh
		db 9Bh,	0E5h, 0CDh, 7Fh, 9Bh, 44h, 4Dh,	0D1h, 0E1h, 0EBh
		db 22h,	8Eh, 0A0h
		db [ 2 ], 0EBh
		db 0E5h, 2Ah, 8Eh, 0A0h, 22h, 90h, 0A0h, 0E1h, 22h, 8Eh
		db 0A0h, 0EBh, 0F3h, 0CAh, 47h,	99h, 0DAh, 35h,	99h, 22h
		db 7Fh,	0A0h, 0E6h, 7Fh, 3Dh, 0CAh, 47h, 99h, 0CDh, 58h
		db 99h,	3Dh, 0CAh, 47h,	99h, 59h, 50h, 0CDh, 58h, 99h
		db 31h,	75h, 0A0h, 0D1h, 0C1h, 0F1h, 0E1h, 0F9h, 2Ah, 7Fh
		db 0A0h, 0E5h, 2Ah, 7Dh, 0A0h, 0FBh, 0C9h, 0F5h, 0C5h
		db 21h,	15h, 0A0h, 7Eh,	34h, 0B7h, 0CAh, 73h, 99h, 23h
		db 7Eh,	23h, 46h, 23h, 0BBh, 0C2h, 73h,	99h, 78h, 0BAh
		db 0C2h, 73h, 99h, 7Eh,	12h, 23h, 73h, 23h, 72h, 23h, 1Ah
		db 77h,	3Eh, 0CFh, 12h,	0C1h, 0F1h, 0C9h, 0CDh,	0A9h, 9Bh
		db 0FEh, 2, 0C2h, 0EBh,	9Ah, 0CDh, 7Fh,	9Bh, 0E5h, 0CDh
		db 7Fh,	9Bh, 0D1h, 0E5h, 0CDh, 3Ch, 9Bh, 19h, 0CDh, 47h
		db 9Bh,	0CDh, 0F6h, 9Ah, 0E1h, 0AFh, 95h, 6Fh, 3Eh, 0
		db 9Ch,	67h, 19h, 0CDh,	47h, 9Bh, 0C3h,	0E0h, 96h, 0CDh
		db 0A5h, 98h, 0CDh, 0BBh, 98h, 0DAh, 0E0h, 96h,	0Ah, 3
		db 77h,	23h, 0C3h, 0ADh, 99h, 21h, 65h,	0, 7Eh,	0E6h, 7Fh
		db 0FEh, 48h, 0C0h, 23h, 7Eh, 0E6h, 7Fh, 0FEh, 45h, 0C0h
		db 23h,	7Eh, 0E6h, 7Fh,	0FEh, 58h, 0C9h, 0EBh, 2Ah, 4Dh
		db 0A0h, 7Dh, 93h, 7Ch,	9Ah, 0EBh, 0C9h, 0CDh, 0D1h, 99h
		db 0D0h, 22h, 4Dh, 0A0h, 0C9h, 0E5h, 21h
		db [ 2 ], 0FFh
		db 0CDh, 0D1h, 99h, 0E1h, 0C9h,	0CDh, 0A9h, 9Bh, 3Dh, 0C2h
		db 0EBh, 9Ah, 0CDh, 7Fh, 9Bh, 0CDh, 3Ch, 9Bh, 0E5h, 0CDh
		db 47h,	9Bh, 0CDh, 0F6h, 9Ah, 0E1h, 7Eh, 0E5h, 0CDh, 2Ch
		db 9Bh,	0CDh, 0F6h, 9Ah, 0CDh, 6Bh, 9Eh, 0CDh, 4, 9Bh
		db 0E1h, 0FEh, 0Dh, 0CAh, 2Dh, 9Ah, 0FEh, 2Eh, 0CAh, 0E0h
		db 96h,	0E5h, 0CDh, 0ACh, 9Bh, 3Dh, 0C2h, 0EBh,	9Ah, 0CDh
		db 7Fh,	9Bh, 7Ch, 0B7h,	0C2h, 0EBh, 9Ah, 7Dh, 0E1h, 77h
		db 23h,	0C3h, 0F6h, 99h, 0AFh, 0C3h, 37h, 9Ah, 3Eh, 0FFh
		db 32h,	12h, 0A0h, 3Eh,	1, 32h,	92h, 0A0h, 0CDh, 0A9h
		db 9Bh,	21h
		db [ 2 ], 0
		db 0CAh, 55h, 9Ah, 3Dh,	0C2h, 0EBh, 9Ah, 0CDh, 7Fh, 9Bh
		db 7Dh,	0B4h, 0CAh, 0EBh, 9Ah, 2Bh, 22h, 13h, 0A0h, 0CDh
		db 5Dh,	9Ch, 0C3h, 1Eh,	99h, 0CDh, 4, 9Bh, 0FEh, 0Dh, 0C2h
		db 6Ch,	9Ah, 0CDh, 5Dh,	9Ch, 0C3h, 0E0h, 96h, 1, 0Bh, 0
		db 21h,	0DFh, 9Ch, 0BEh, 0CAh, 7Fh, 9Ah, 23h, 4, 0Dh, 0C2h
		db 72h,	9Ah, 0C3h, 0EBh, 9Ah, 0CDh, 4, 9Bh, 0FEh, 0Dh
		db 0C2h, 0EBh, 9Ah, 0C5h, 0CDh,	3Ch, 9Bh, 0CDh,	33h, 9Ch
		db 0CDh, 0F6h, 9Ah, 0CDh, 6Bh, 9Eh, 0CDh, 0A9h,	9Bh, 0B7h
		db 0CAh, 0E0h, 96h, 3Dh, 0C2h, 0EBh, 9Ah, 0CDh,	7Fh, 9Bh
		db 0C1h, 78h, 0FEh, 5, 0D2h, 0D0h, 9Ah,	7Ch, 0B7h, 0C2h
		db 0EBh, 9Ah, 7Dh, 0FEh, 2, 0D2h, 0EBh,	9Ah, 0CDh, 0FCh
		db 9Bh,	67h, 41h, 3Eh, 0FEh, 0CDh, 0CAh, 9Ah, 0A4h, 41h
		db 67h,	7Dh, 0CDh, 0CAh, 9Ah, 0B4h, 12h, 0C3h, 0E0h, 96h
		db 5, 0C8h, 7, 0C3h, 0CAh, 9Ah,	0C2h, 0E0h, 9Ah, 7Ch, 0B7h
		db 0C2h, 0EBh, 9Ah, 7Dh, 21h, 7Ah, 0A0h, 77h, 0C3h, 0E0h
		db 96h,	0E5h, 0CDh, 1Ah, 9Ch, 0D1h, 73h, 23h, 72h, 0C3h
		db 0E0h, 96h, 0CDh, 3Ch, 9Bh, 3Eh, 3Fh,	0CDh, 60h, 9Eh
		db 0C3h, 0E0h, 96h, 3Eh, 20h, 0C3h, 60h, 9Eh, 0FEh, 7Fh
		db 0C8h, 0FEh, 61h, 0D8h, 0E6h,	5Fh, 0C9h, 0E5h, 21h, 2Ch
		db 0A0h, 7Eh, 0B7h, 3Eh, 0Dh, 0CAh, 1Bh, 9Bh, 35h, 2Ah
		db 29h,	0A0h, 7Eh, 23h,	22h, 29h, 0A0h,	0CDh, 0FBh, 9Ah
		db 0E1h, 0C9h, 0FEh, 0Ah, 0D2h,	27h, 9Bh, 0C6h,	30h, 0C3h
		db 60h,	9Eh, 0C6h, 37h,	0C3h, 60h, 9Eh,	0F5h
		db [ 4 ], 1Fh
		db 0E6h, 0Fh, 0CDh, 1Dh, 9Bh, 0F1h, 0E6h, 0Fh, 0C3h, 1Dh
		db 9Bh,	3Eh, 0Dh, 0CDh,	60h, 9Eh, 3Eh, 0Ah, 0C3h, 60h
		db 9Eh,	0EBh, 7Ch, 0CDh, 2Ch, 9Bh, 7Dh,	0C3h, 2Ch, 9Bh
		db 0FEh, 7Fh, 0D2h, 59h, 9Bh, 0FEh, 20h, 0D2h, 60h, 9Eh
		db 3Eh,	2Eh, 0C3h, 60h,	9Eh, 0EBh, 2Ah,	25h, 0A0h, 7Dh
		db 93h,	6Fh, 7Ch, 9Ah, 0EBh, 0C9h, 0FEh, 0Dh, 0C8h, 0FEh
		db 2Ch,	0C8h, 0FEh, 20h, 0C9h, 0D6h, 30h, 0FEh,	0Ah, 0D8h
		db 0C6h, 0F9h, 0FEh, 10h, 0D8h,	0C3h, 0EBh, 9Ah, 0EBh
		db 5Eh,	23h, 56h, 23h, 0EBh, 0C9h, 0EBh, 21h
		db [ 2 ], 0
		db 0CDh, 72h, 9Bh
		db [ 4 ], 29h
		db 0B5h, 6Fh, 0CDh, 4, 9Bh, 0CDh, 69h, 9Bh, 0C2h, 8Ah
		db 9Bh,	0EBh, 0C9h, 73h, 23h, 72h, 23h,	0E5h, 21h, 1Ch
		db 0A0h, 34h, 0E1h, 0C9h, 0CDh,	4, 9Bh,	21h, 1Ch, 0A0h
		db 36h,	0, 23h,	0FEh, 0Dh, 0CAh, 0EEh, 9Bh, 0FEh, 2Ch
		db 0C2h, 0C7h, 9Bh, 3Eh, 80h, 32h, 1Ch,	0A0h, 11h
		db [ 2 ], 0
		db 0C3h, 0CAh, 9Bh, 0CDh, 86h, 9Bh, 0CDh, 9Eh, 9Bh, 0FEh
		db 0Dh,	0CAh, 0EEh, 9Bh, 0CDh, 4, 9Bh, 0CDh, 86h, 9Bh
		db 0CDh, 9Eh, 9Bh, 0FEh, 0Dh, 0CAh, 0EEh, 9Bh, 0CDh, 4
		db 9Bh,	0CDh, 86h, 9Bh,	0CDh, 9Eh, 9Bh,	0FEh, 0Dh, 0C2h
		db 0EBh, 9Ah, 11h, 1Ch,	0A0h, 1Ah, 0FEh, 81h, 0CAh, 0EBh
		db 9Ah,	13h, 0B7h, 7, 0Fh, 0C9h, 0E5h, 21h, 0EFh, 9Ch
		db 58h,	16h, 0,	19h, 4Eh, 21h, 79h, 0A0h, 7Eh, 0EBh, 0E1h
		db 0C9h, 0CDh, 0FCh, 9Bh, 0Dh, 0CAh, 17h, 9Ch, 1Fh, 0C3h
		db 0Fh,	9Ch, 0E6h, 1, 0C9h, 0D6h, 6, 21h, 0EAh,	9Ch, 5Fh
		db 16h,	0, 19h,	5Eh, 16h, 0FFh,	21h, 81h, 0A0h,	19h, 0C9h
		db 0CDh, 1Ah, 9Ch, 5Eh,	23h, 56h, 0EBh,	0C9h, 7Eh, 0CDh
		db 60h,	9Eh, 78h, 0FEh,	5, 0D2h, 44h, 9Ch, 0CDh, 0Ch, 9Ch
		db 0CDh, 1Dh, 9Bh, 0C9h, 0F5h, 3Eh, 3Dh, 0CDh, 60h, 9Eh
		db 0F1h, 0C2h, 56h, 9Ch, 21h, 7Ah, 0A0h, 7Eh, 0CDh, 2Ch
		db 9Bh,	0C9h, 0CDh, 2Bh, 9Ch, 0CDh, 47h, 9Bh, 0C9h, 21h
		db 0DFh, 9Ch, 6, 0, 0CDh, 3Ch, 9Bh, 0C5h, 0E5h,	0CDh, 33h
		db 9Ch,	0E1h, 0C1h, 4, 23h, 78h, 0FEh, 5, 0C2h,	77h, 9Ch
		db 0CDh, 77h, 90h, 0FEh, 0Bh, 0D2h, 92h, 9Ch, 0FEh, 9
		db 0C2h, 87h, 9Ch, 0CDh, 77h, 90h, 0C3h, 65h, 9Ch, 0FEh
		db 6, 0DAh, 65h, 9Ch, 0CDh, 0F6h, 9Ah, 0C3h, 65h, 9Ch
		db 0CDh, 0F6h, 9Ah, 0CDh, 0B8h,	9Dh, 0F5h, 0D5h, 0C5h
		db 0CDh, 0E3h, 99h, 0D2h, 0B2h,	9Ch, 2Ah, 7Fh, 0A0h, 22h
		db 0, 0A0h, 21h, 4, 0A0h, 36h, 0FFh, 0CDh, 8Bh,	93h, 0C3h
		db 0DBh, 9Ch, 2Bh, 22h,	25h, 0A0h, 2Ah,	7Fh, 0A0h, 7Eh
		db 0CDh, 2Ch, 9Bh, 23h,	0CDh, 5Eh, 9Bh,	0DAh, 0DBh, 9Ch
		db 0F5h, 0CDh, 0F6h, 9Ah, 0F1h,	0B3h, 0CAh, 0D7h, 9Ch
		db 5Eh,	23h, 56h, 0EBh,	0CDh, 47h, 9Bh,	0C3h, 0DBh, 9Ch
		db 7Eh,	0CDh, 2Ch, 9Bh,	0C1h, 0D1h, 0F1h, 0C9h,	43h, 5Ah
		db 4Dh,	45h, 49h, 41h, 42h, 44h, 48h, 53h, 50h,	0F6h, 0F4h
		db 0FCh, 0FAh, 0FEh, 1,	7, 8, 3, 5, 21h
		db [ 2 ], 0
		db 22h,	13h, 0A0h, 0C9h, 0F3h, 22h, 7Dh, 0A0h, 0E1h, 2Bh
		db 22h,	7Fh, 0A0h, 0F5h, 21h, 2, 0, 39h, 0F1h, 31h, 7Dh
		db 0A0h, 0E5h, 0F5h, 0C5h, 0D5h, 2Ah, 7Fh, 0A0h, 7Eh, 0FEh
		db 0CFh, 0F5h, 0E5h, 21h, 15h, 0A0h, 7Eh, 36h, 0, 0B7h
		db 0CAh, 30h, 9Dh, 3Dh,	47h, 23h, 5Eh, 23h, 56h, 23h, 7Eh
		db 12h,	78h, 0C3h, 1Fh,	9Dh, 0E1h, 0F1h, 0CAh, 51h, 9Dh
		db 23h,	22h, 7Fh, 0A0h,	0EBh, 1
		db [ 2 ], 0FFh
		db 0CDh, 0BBh, 98h, 0DAh, 51h, 9Dh, 0CDh, 0F4h,	9Ch, 2Ah
		db 10h,	0A0h, 0EBh, 3Eh, 82h, 0B7h, 37h, 0C3h, 1Eh, 99h
		db 0FBh, 2Ah, 13h, 0A0h, 7Ch, 0B5h, 0CAh, 77h, 9Dh, 2Bh
		db 22h,	13h, 0A0h, 0CDh, 0BCh, 9Eh, 0DAh, 77h, 9Dh, 3Ah
		db 12h,	0A0h, 0B7h, 0C2h, 71h, 9Dh, 0CDh, 0B8h,	9Dh, 0C3h
		db 1Eh,	99h, 0CDh, 5Dh,	9Ch, 0C3h, 1Eh,	99h, 0CDh, 0F4h
		db 9Ch,	3Eh, 20h, 0CDh,	60h, 9Eh, 3Eh, 20h, 0CDh, 60h
		db 9Eh,	3Eh, 2Ah, 0CDh,	60h, 9Eh, 2Ah, 7Fh, 0A0h, 0CDh
		db 0E3h, 99h, 0D2h, 95h, 9Dh, 22h, 0, 0A0h, 0CDh, 47h
		db 9Bh,	2Ah, 7Dh, 0A0h,	22h, 23h, 0A0h,	0C3h, 0E0h, 96h
		db 11h,	0Dh, 0,	21h, 0C6h, 9Eh,	7Eh, 0A0h, 23h,	0BEh, 23h
		db 0CAh, 0B4h, 9Dh, 14h, 1Dh, 0C2h, 0A7h, 9Dh, 5Ah, 16h
		db 0, 0C9h, 2Ah, 7Fh, 0A0h, 46h, 23h, 0E5h, 0CDh, 0A1h
		db 9Dh,	21h, 0Fh, 0A0h,	73h, 21h, 0CFh,	9Dh
		db [ 2 ], 19h
		db 5Eh,	23h, 56h, 0EBh,	0E9h, 0EBh, 9Dh, 11h, 9Eh, 0EBh
		db 9Dh,	11h, 9Eh, 0F1h,	9Dh, 23h, 9Eh, 35h, 9Eh, 57h, 9Eh
		db 57h,	9Eh, 54h, 9Eh, 54h, 9Eh, 4Ah, 9Eh, 57h,	9Eh, 45h
		db 9Eh,	0CDh, 0FFh, 9Dh, 0C2h, 5Ah, 9Eh, 0CDh, 0Ah, 9Eh
		db 0C3h, 5Ah, 9Eh, 3Eh,	0FFh, 0BBh, 0C0h, 3Eh, 0FFh, 0BAh
		db 0C9h, 0C1h, 0E1h, 5Eh, 23h, 56h, 23h, 0E5h, 0C5h, 0C3h
		db 0F7h, 9Dh, 2Ah, 7Bh,	0A0h, 5Eh, 23h,	56h, 0C9h, 0CDh
		db 0FFh, 9Dh, 0CAh, 1Eh, 9Eh, 0C1h, 0C5h, 3Eh, 2, 0C3h
		db 5Ch,	9Eh, 0D1h, 0D5h, 0C3h, 5Ah, 9Eh, 78h, 0FEh, 0CFh
		db 0C2h, 2Dh, 9Eh, 0AFh, 0C3h, 5Eh, 9Eh, 0E6h, 38h, 5Fh
		db 16h,	0, 0C3h, 5Ah, 9Eh, 2Ah,	7Dh, 0A0h, 0EBh, 0CDh
		db 0F7h, 9Dh, 0C2h, 5Ah, 9Eh, 0C3h, 0F1h, 9Dh, 0C3h, 5Ah
		db 9Eh,	0D1h, 0D5h, 0C3h, 5Ah, 9Eh, 0CDh, 0Ah, 9Eh, 0C1h
		db 0C5h, 3Eh, 2, 0C3h, 5Ch, 9Eh, 0D1h, 13h, 0D5h, 0D1h
		db 13h,	0D5h, 3Eh, 1, 3Ch, 37h,	0E1h, 0C9h, 0E5h, 0D5h
		db 0C5h, 4Fh, 0CDh, 0Ch, 90h, 0C1h, 0D1h, 0E1h,	0C9h, 11h
		db 2Dh,	0A0h, 6, 0, 0C5h, 0D5h,	0CDh, 9, 90h, 0FEh, 8
		db 0CAh, 97h, 9Eh, 0FEh, 7Fh, 0CAh, 97h, 9Eh, 0F5h, 0CDh
		db 60h,	9Eh, 0F1h, 0D1h, 0C1h, 12h, 13h, 0FEh, 0Dh, 0CAh
		db 0B2h, 9Eh, 4, 3Eh, 23h, 0B8h, 0CAh, 0EBh, 9Ah, 0C3h
		db 70h,	9Eh, 0D1h, 0C1h, 0AFh, 0B0h, 0CAh, 70h,	9Eh, 5
		db 1Bh,	3Eh, 8,	0CDh, 60h, 9Eh,	3Eh, 20h, 0CDh,	60h, 9Eh
		db 3Eh,	8, 0CDh, 60h, 9Eh, 0C3h, 70h, 9Eh, 21h,	2Dh, 0A0h
		db 22h,	29h, 0A0h, 2Bh,	70h, 23h, 0C9h,	0C5h, 0D5h, 0E5h
		db 0CDh, 6, 90h, 0E1h, 0D1h, 0C1h, 0C9h, 0FFh, 0C3h, 0C7h
		db 0C2h, 0FFh, 0CDh, 0C7h, 0C4h, 0FFh, 0C9h
		db [ 2 ], 0C7h
		db 0FFh, 0E9h, 0C7h, 6,	0C7h, 0C6h, 0CFh, 1, 0E7h, 22h
		db 0C7h, 0C0h, 0F7h, 0D3h, 3Ah,	93h, 0A0h, 0B7h, 0CAh
		db 0ECh, 9Eh, 0C5h, 0CDh, 2Eh, 9Fh, 0C1h, 0DBh,	12h, 0F5h
		db 0E6h, 0F3h, 0D3h, 12h, 0CDh,	0, 20h,	0F1h, 0D3h, 12h
		db 0C9h, 0DBh, 12h, 0F5h, 0E6h,	0F3h, 0D3h, 12h, 0CDh
		db 58h,	0, 0E1h, 7Ch, 0D3h, 12h, 0C9h, 0DBh, 12h, 0F5h
		db 0E6h, 0F3h, 0D3h, 12h, 0CDh,	5Bh, 0,	0E1h, 0F5h, 7Ch
		db 0D3h, 12h, 0F1h, 0E6h, 7Fh, 0F5h, 0FEh, 10h,	0C2h, 2Ch
		db 9Fh,	3Ah, 93h, 0A0h,	2Fh, 32h, 93h, 0A0h, 0F1h, 0C3h
		db 9, 9Fh, 0F1h, 0C9h, 3Eh, 0Ah, 0B9h, 0C2h, 45h, 9Fh
		db 0CDh, 45h, 9Fh, 6, 8, 0Eh, 20h, 0C5h, 0CDh, 45h, 9Fh
		db 0C1h, 5, 0C2h, 3Bh, 9Fh, 0C9h, 0CDh,	7Ah, 9Fh, 0CDh
		db 67h,	9Fh, 0B7h, 0CAh, 45h, 9Fh, 79h,	0D3h, 10h, 0DBh
		db 12h,	0F5h, 0F6h, 83h, 0D3h, 12h, 0DBh, 11h, 0E6h, 20h
		db 0CDh, 67h, 9Fh, 0CAh, 59h, 9Fh, 0F1h, 0D3h, 12h, 0C9h
		db 0F5h, 0CDh, 6, 90h, 0D2h, 78h, 9Fh, 0F1h, 3Ah, 93h
		db 0A0h, 2Fh, 32h, 93h,	0A0h, 0F1h, 0C9h, 0F1h,	0C9h, 0DBh
		db 12h,	47h, 0F6h, 81h,	0D3h, 12h, 0DBh, 11h, 0E6h, 30h
		db 78h,	0D3h, 12h, 3Eh,	1, 0C8h, 0AFh, 0C9h, 31h, 80h
		db 0A0h, 0DBh, 12h, 0F6h, 8, 0D3h, 12h,	0C3h, 3, 90h, 0DBh
		db 12h,	0F5h, 0E6h, 0F3h, 0D3h,	12h, 0CDh, 40h,	0, 0DAh
		db 0ACh, 9Fh, 0F1h, 0D3h, 12h, 0C3h, 0E0h, 96h,	0F1h, 0D3h
		db 12h,	0C3h, 0EBh, 9Ah, 0DBh, 12h, 0F5h, 0E6h,	0F3h, 0D3h
		db 12h,	0AFh, 0D3h, 0D8h, 0CDh,	43h, 0,	3Eh, 1Ah, 0D3h
		db 0D8h, 0F1h, 0D3h, 12h, 0C3h,	0E0h, 96h
		db [ 27h ], 0
; ---------------------------------------------------------------------------

loc_1800:				; CODE XREF: RAM:0426j
		ld	a, 0FFh
		out	(20h), a
		out	(21h), a
		out	(22h), a
		out	(23h), a
		out	(28h), a
		out	(29h), a
		out	(2Ah), a
		out	(2Bh), a
		out	(2Ch), a
		out	(2Dh), a
		out	(2Eh), a
		out	(2Fh), a
		ld	a, 0Dh
		out	(24h), a
		out	(25h), a
		ld	a, 7
		out	(26h), a
		ld	a, 0Bh
		out	(27h), a
		ld	a, 0
		out	(38h), a
		ld	hl, _Out12JPHL
		ld	(hl), 0D3h ; ''
		inc	hl
		ld	(hl), PPA_C
		inc	hl
		ld	(hl), 0E9h ; ''
		ld	a, _C6_0
		ld	hl, 4000h
		jp	_Out12JPHL

; =============== S U B	R O U T	I N E =======================================


_Logo_and_inits:			; CODE XREF: RAM:0297p

; FUNCTION CHUNK AT 00A7 SIZE 00000018 BYTES

		xor	a
		ld	(byte_BE22), a
		in	a, (12h)
		ld	b, a
		ld	a, 0Fh
		out	(13h), a
		in	a, (11h)
		rla
		rla
		ld	a, b
		out	(12h), a
		jp	nc, loc_185B
		xor	a
		ld	(byte_BE20), a
		jp	_ShowLogo
; ---------------------------------------------------------------------------

loc_185B:				; CODE XREF: _Logo_and_inits+12j
					; _Logo_and_inits+24j
		call	sub_18A2
		jp	nc, loc_1866
		in	a, (4)
		jp	loc_185B
; ---------------------------------------------------------------------------

loc_1866:				; CODE XREF: _Logo_and_inits+1Fj
		ld	hl, unk_1B90
		ld	de, byte_BE25
		ld	bc, 10
		call	_LDIR
		ld	hl, unk_BE37
		ld	a, 0FFh
		ld	c, 0Ah

loc_1879:				; CODE XREF: _Logo_and_inits+3Dj
		ld	(hl), a
		inc	hl
		dec	c
		jp	nz, loc_1879
		ld	hl, unk_1B9A
		ld	(word_BE2F), hl
		ld	(word_BE31), hl
		ld	(word_BE33), hl
		ld	hl, unk_1BB7
		ld	(word_BE35), hl
		ld	hl, byte_BE4F
		ld	(word_BE4B), hl
		ld	(word_BE4D), hl
		ld	a, 2
		ld	(byte_BE20), a
		jp	_ShowLogo
; End of function _Logo_and_inits


; =============== S U B	R O U T	I N E =======================================


sub_18A2:				; CODE XREF: _Logo_and_inits:loc_185Bp
					; _CONST+Dp ...
		in	a, (PPA_C)
		push	bc
		ld	b, a
		ld	a, _C7_0
		out	(PPA_RUS), a
		in	a, (11h)
		rla
		ld	a, b
		pop	bc
		out	(PPA_C), a
		ret
; End of function sub_18A2


; =============== S U B	R O U T	I N E =======================================


_CONST:					; CODE XREF: RAM:CONSTj _CONINp
		ld	a, (byte_BE20)
		or	a
		jp	nz, loc_18D6
		ld	a, (byte_BE22)
		or	a
		scf
		ret	nz
		call	sub_18A2
		ret	nc
		in	a, (KBD_R4)
		cp	9Fh ; ''
		jp	nc, loc_18CC
		and	7Fh ; ''

loc_18CC:				; CODE XREF: _CONST+15j
		ld	(byte_BE21), a
		push	hl
		call	sub_1B36
		pop	hl
		scf
		ret
; ---------------------------------------------------------------------------

loc_18D6:				; CODE XREF: _CONST+4j
		call	sub_18A2
		jp	nc, loc_18DF
		call	sub_1902

loc_18DF:				; CODE XREF: _CONST+27j _CONST+37j
		ld	a, (byte_BE22)
		or	a
		scf
		ret	nz
		call	sub_1A22
		ret	nc
		jp	loc_18DF
; End of function _CONST


; =============== S U B	R O U T	I N E =======================================


_CONIN:					; CODE XREF: _CONIN?j _CONIN+3j
		call	_CONST
		jp	nc, _CONIN
		push	hl
		ld	hl, (word_BE23)
		ld	c, (hl)
		inc	hl
		ld	(word_BE23), hl
		ld	hl, byte_BE22
		dec	(hl)
		ld	a, c
		pop	hl
		ret
; End of function _CONIN


; =============== S U B	R O U T	I N E =======================================


sub_1902:				; CODE XREF: _CONST+2Ap
		push	hl
		push	de
		push	bc
		in	a, (4)
		ld	hl, unk_BE41
		ld	b, 0Ah

loc_190C:				; CODE XREF: sub_1902+Fj
		in	a, (4)
		ld	(hl), a
		inc	hl
		dec	b
		jp	nz, loc_190C
		ld	a, (byte_BE4A)
		and	10h
		call	z, sub_198C
		ld	de, 0Ah
		ld	c, 50h ; 'P'
		push	de
		push	bc
		ld	l, 80h ; ''
		call	sub_193F
		pop	bc
		pop	de
		ld	l, 0
		call	sub_193F
		ld	hl, unk_BE41
		ld	de, unk_BE37
		ld	bc, 0Ah
		call	_LDIR
		pop	bc
		pop	de
		pop	hl
		ret
; End of function sub_1902


; =============== S U B	R O U T	I N E =======================================


sub_193F:				; CODE XREF: sub_1902+23p sub_1902+2Ap ...
		dec	e
		push	hl
		ld	a, l
		or	a
		jp	nz, loc_194C
		call	sub_1980
		jp	loc_194F
; ---------------------------------------------------------------------------

loc_194C:				; CODE XREF: sub_193F+4j
		call	sub_196C

loc_194F:				; CODE XREF: sub_193F+Aj
		pop	hl
		or	a
		jp	nz, loc_195B
		ld	a, c
		sub	8
		ld	c, a
		jp	loc_1966
; ---------------------------------------------------------------------------

loc_195B:				; CODE XREF: sub_193F+12j
		ld	b, 8

loc_195D:				; CODE XREF: sub_193F+24j
		rla
		call	c, sub_19A8
		dec	c
		dec	b
		jp	nz, loc_195D

loc_1966:				; CODE XREF: sub_193F+19j
		ld	a, e
		or	a
		jp	nz, sub_193F
		ret
; End of function sub_193F


; =============== S U B	R O U T	I N E =======================================


sub_196C:				; CODE XREF: sub_193F:loc_194Cp
		ld	hl, unk_199E
		add	hl, de
		ld	a, (hl)
		cpl
		ld	b, a
		ld	hl, unk_BE37
		add	hl, de
		ld	a, (hl)
		ld	hl, unk_BE41
		add	hl, de
		xor	(hl)
		and	(hl)
		and	b
		ret
; End of function sub_196C


; =============== S U B	R O U T	I N E =======================================


sub_1980:				; CODE XREF: sub_193F+7p
		ld	hl, unk_BE41
		add	hl, de
		ld	a, (hl)
		ld	hl, unk_BE37
		add	hl, de
		xor	(hl)
		and	(hl)
		ret
; End of function sub_1980


; =============== S U B	R O U T	I N E =======================================


sub_198C:				; CODE XREF: sub_1902+17p
		ld	hl, 199Eh
		ld	de, 0BE37h
		ld	c, 0Ah

loc_1994:				; CODE XREF: sub_198C+Ej
		ld	a, (de)
		or	(hl)
		ld	(de), a
		inc	hl
		inc	de
		dec	c
		jp	nz, loc_1994
		ret
; End of function sub_198C

; ---------------------------------------------------------------------------
unk_199E:	db 0FFh			; DATA XREF: sub_196Co
		db 0FFh
		db 0FFh
		db 0FFh
		db 0FFh
		db 0FFh
		db  7Eh	; ~
		db 0FFh
		db 0FFh
		db  1Fh

; =============== S U B	R O U T	I N E =======================================


sub_19A8:				; CODE XREF: sub_193F+1Fp
		push	af
		push	bc
		push	de
		push	hl
		ld	b, l
		dec	c
		ld	e, c
		ld	hl, _KeyCode?
		add	hl, de
		ld	a, (hl)
		or	b
		ld	hl, (word_BE4B)
		ld	(hl), a
		inc	hl
		ld	a, l
		cp	60h ; '`'
		jp	nz, loc_19C3
		ld	hl, byte_BE4F

loc_19C3:				; CODE XREF: sub_19A8+15j
		ld	a, (word_BE4D)
		cp	l
		jp	z, loc_19CD
		ld	(word_BE4B), hl

loc_19CD:				; CODE XREF: sub_19A8+1Fj
		pop	hl
		pop	de
		pop	bc
		pop	af
		ret
; End of function sub_19A8

; ---------------------------------------------------------------------------
_KeyCode?:	db 10h,	11h, 12h, 13h, 14h, 15h, 16h, 17h, 18h,	19h, 1Ah
					; DATA XREF: sub_19A8+7o
		db 1Bh,	0Ch, 0Dh, 0Eh, 0Fh, ' ', '!', 22h, '#', '$', '%'
		db '&', 27h, '(', ')', '*', '+', ',', '-', '.', '/', '0'
		db '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';'
		db '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F'
		db 'G', 'H', 'I'
		db [ 3 ], 0FFh
		db 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W'
		db [ 5 ], 0FFh
		db ']', '^', '_'

; =============== S U B	R O U T	I N E =======================================


sub_1A22:				; CODE XREF: _CONST+33p

; FUNCTION CHUNK AT 1B5C SIZE 00000018 BYTES

		push	hl
		ld	hl, (word_BE4D)
		ld	a, (word_BE4B)
		cp	l
		jp	nz, loc_1A30
		pop	hl
		or	a
		ret
; ---------------------------------------------------------------------------

loc_1A30:				; CODE XREF: sub_1A22+8j
		push	bc
		push	de
		ld	c, (hl)
		inc	hl
		ld	a, l
		cp	60h ; '`'
		jp	nz, loc_1A3D
		ld	hl, byte_BE4F

loc_1A3D:				; CODE XREF: sub_1A22+15j
		ld	(word_BE4D), hl
		ld	a, c
		ld	b, 4
		ld	hl, byte_BE25

loc_1A46:				; CODE XREF: sub_1A22+2Aj
		cp	(hl)
		jp	z, loc_1B5C
		inc	hl
		dec	b
		jp	nz, loc_1A46
		rla
		jp	c, loc_1B65
		ld	a, c
		cp	47h ; 'G'
		jp	z, loc_1B6A
		ld	b, 10h
		cp	20h ; ' '
		jp	c, loc_1AF5
		ld	b, 20h ; ' '
		cp	40h ; '@'
		jp	c, loc_1AF5
		cp	46h ; 'F'
		jp	nc, loc_1AD9
		cp	41h ; 'A'
		jp	c, loc_1AD9
		sub	40h ; '@'
		push	af
		ld	a, (byte_BE25)
		ld	hl, (word_BE2F)
		rla
		jp	nc, loc_1A8B
		ld	a, (byte_BE26)
		rla
		jp	c, loc_1AC3
		ld	hl, (word_BE31)
		jp	loc_1A95
; ---------------------------------------------------------------------------

loc_1A8B:				; CODE XREF: sub_1A22+59j
		ld	a, (byte_BE26)
		rla
		jp	nc, loc_1A95
		ld	hl, (word_BE33)

loc_1A95:				; CODE XREF: sub_1A22+66j sub_1A22+6Dj ...
		pop	af

loc_1A96:				; CODE XREF: sub_1A22+7Cj
		dec	a
		jp	z, loc_1AA4
		ld	b, (hl)
		inc	b

loc_1A9C:				; CODE XREF: sub_1A22+7Fj
		inc	hl
		dec	b
		jp	z, loc_1A96
		jp	loc_1A9C
; ---------------------------------------------------------------------------

loc_1AA4:				; CODE XREF: sub_1A22+75j
		ld	a, (hl)
		or	a
		jp	z, loc_1B62
		ld	a, (byte_BE27)
		rla
		jp	nc, loc_1AB8
		ld	b, (hl)
		inc	hl
		call	sub_1B74
		jp	loc_1B62
; ---------------------------------------------------------------------------

loc_1AB8:				; CODE XREF: sub_1A22+8Bj
		ld	a, (hl)
		inc	hl
		ld	(byte_BE22), a
		ld	(word_BE23), hl
		jp	loc_1B62
; ---------------------------------------------------------------------------

loc_1AC3:				; CODE XREF: sub_1A22+60j
		pop	af
		cp	5
		jp	nz, loc_1AD2
		ld	hl, 0BE2Ah
		ld	a, (hl)
		xor	c
		ld	(hl), a
		jp	loc_1B62
; ---------------------------------------------------------------------------

loc_1AD2:				; CODE XREF: sub_1A22+A4j
		push	af
		ld	hl, (word_BE35)
		jp	loc_1A95
; ---------------------------------------------------------------------------

loc_1AD9:				; CODE XREF: sub_1A22+47j sub_1A22+4Cj
		cp	58h ; 'X'
		jp	nc, loc_1B65
		ld	hl, 1B82h
		cp	54h ; 'T'
		jp	c, loc_1AEB
		sub	0Eh
		ld	hl, 0BE2Bh

loc_1AEB:				; CODE XREF: sub_1A22+C1j
		sub	46h ; 'F'
		ld	e, a
		ld	d, 0
		add	hl, de
		ld	c, (hl)
		jp	loc_1B22
; ---------------------------------------------------------------------------

loc_1AF5:				; CODE XREF: sub_1A22+3Bj sub_1A22+42j
		add	a, 20h ; ' '
		ld	c, a
		ld	a, (byte_BE25)
		rla
		jp	nc, loc_1B02
		ld	a, c
		xor	b
		ld	c, a

loc_1B02:				; CODE XREF: sub_1A22+DAj
		ld	a, (byte_BE29)
		or	a
		jp	z, loc_1B0C
		ld	a, c
		xor	b
		ld	c, a

loc_1B0C:				; CODE XREF: sub_1A22+E4j
		ld	a, (byte_BE26)
		rla
		jp	nc, loc_1B17
		ld	a, c
		and	1Fh
		ld	c, a

loc_1B17:				; CODE XREF: sub_1A22+EEj
		ld	a, (byte_BE28)
		rla
		jp	nc, loc_1B22
		ld	a, c
		or	80h ; ''
		ld	c, a

loc_1B22:				; CODE XREF: sub_1A22+D0j sub_1A22+F9j
		ld	a, (byte_BE27)
		rla
		jp	nc, loc_1B2F
		call	ConOut
		jp	loc_1B62
; ---------------------------------------------------------------------------

loc_1B2F:				; CODE XREF: sub_1A22+104j
		call	sub_1B36
		ld	(hl), c
		jp	loc_1B62
; End of function sub_1A22


; =============== S U B	R O U T	I N E =======================================


sub_1B36:				; CODE XREF: _CONST+1Ep
					; sub_1A22:loc_1B2Fp
		ld	a, 1
		ld	(byte_BE22), a
		ld	hl, byte_BE21
		ld	(word_BE23), hl
		ret
; End of function sub_1B36


; =============== S U B	R O U T	I N E =======================================


sub_1B42:				; CODE XREF: sub_1A22:loc_1B62p
		ld	a, (byte_BE2A)
		or	a
		ret	z
		ld	hl, (_MelodyFile)
		push	hl
		ld	hl, byte_1B59
		ld	(_MelodyFile), hl
		call	MELODY
		pop	hl
		ld	(_MelodyFile), hl
		ret
; End of function sub_1B42

; ---------------------------------------------------------------------------
byte_1B59:	db 88h,	1Fh, 0		; DATA XREF: sub_1B42+9o
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_1A22

loc_1B5C:				; CODE XREF: sub_1A22+25j
		xor	80h ; ''
		ld	(hl), a
		jp	loc_1B65
; ---------------------------------------------------------------------------

loc_1B62:				; CODE XREF: sub_1A22+84j sub_1A22+93j ...
		call	sub_1B42

loc_1B65:				; CODE XREF: sub_1A22+2Ej sub_1A22+B9j ...
		pop	de
		pop	bc
		pop	hl
		scf
		ret
; ---------------------------------------------------------------------------

loc_1B6A:				; CODE XREF: sub_1A22+34j
		ld	hl, 0BE29h
		ld	a, (hl)
		xor	1
		ld	(hl), a
		jp	loc_1B62
; END OF FUNCTION CHUNK	FOR sub_1A22

; =============== S U B	R O U T	I N E =======================================


sub_1B74:				; CODE XREF: sub_1A22+90p sub_1B74+Aj
		push	bc
		ld	c, (hl)
		push	hl
		call	ConOut
		pop	hl
		pop	bc
		inc	hl
		dec	b
		jp	nz, sub_1B74
		ret
; End of function sub_1B74

; ---------------------------------------------------------------------------
		db  0Ah
		db    0
		db    8
		db    9
		db    0
		db    0
		db    0
		db  0Dh
		db    2
		db  7Fh	; 
		db  20h
		db  0Ch
		db    3
		db  1Bh
unk_1B90:	db  5Dh	; ]		; DATA XREF: _Logo_and_inits:loc_1866o
		db  5Fh	; _
		db  5Eh	; ^
		db  40h	; @
		db    0
		db    0
		db  19h
		db  1Ah
		db  1Ch
		db  1Dh
unk_1B9A:	db    4			; DATA XREF: _Logo_and_inits+40o
		db  44h	; D
		db  49h	; I
		db  52h	; R
		db  20h
		db    6
		db  50h	; P
		db  4Fh	; O
		db  57h	; W
		db  45h	; E
		db  52h	; R
		db  0Dh
		db    5
		db  54h	; T
		db  59h	; Y
		db  50h	; P
		db  45h	; E
		db  20h
		db    5
		db  43h	; C
		db  4Fh	; O
		db  50h	; P
		db  59h	; Y
		db  20h
		db    4
		db  52h	; R
		db  55h	; U
		db  4Eh	; N
		db  20h
unk_1BB7:	db    6			; DATA XREF: _Logo_and_inits+4Co
		db  1Bh
		db  45h	; E
		db  1Bh
		db  5Eh	; ^
		db  1Bh
		db  40h	; @
		db    9
		db  1Bh
		db  51h	; Q
		db  42h	; B
		db  1Bh
		db  50h	; P
		db  31h	; 1
		db  1Bh
		db  4Ch	; L
		db  0Ch
		db    9
		db  1Bh
		db  51h	; Q
		db  43h	; C
		db  1Bh
		db  50h	; P
		db  31h	; 1
		db  1Bh
		db  4Ch	; L
		db  0Ch
		db    2
		db  1Bh
		db  5Ch	; \
		db [ 42Bh ], 0FFh

; =============== S U B	R O U T	I N E =======================================


ConOut:					; CODE XREF: PutString_DE+Bp RAM:0493p ...

; FUNCTION CHUNK AT 2025 SIZE 00000009 BYTES

		jp	_ConOut
; End of function ConOut

; ---------------------------------------------------------------------------
		db  43h	; C
		db  4Fh	; O
		db    6
		db  86h	; 
		db    1
		db    0
		db    0

; =============== S U B	R O U T	I N E =======================================


ConOut_INIT:				; CODE XREF: RAM:0294p

; FUNCTION CHUNK AT 2533 SIZE 00000011 BYTES

		ld	a, 0C3h	; ''
		ld	(HOOK1_conout),	a
		ld	hl, CONOUT_Default
		ld	(HOOK1_conout+1), hl
		ld	a, 0C9h	; ''
		ld	b, 8
		ld	hl, HOOK2_Img

loc_201C:				; CODE XREF: ConOut_INIT+15j
		ld	(hl), a
		inc	hl
		dec	b
		jp	nz, loc_201C
		jp	_ESC_E_Init
; End of function ConOut_INIT

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR ConOut

_ConOut:				; CODE XREF: ConOutj
		call	UpdateCursor?
		call	_ConOut_Default1
		jp	UpdateCursor?
; END OF FUNCTION CHUNK	FOR ConOut

; =============== S U B	R O U T	I N E =======================================


UpdateCursor?:				; CODE XREF: ConOut:_ConOutp
		ld	a, (_ConOut_MODEC) ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		rra
		ret	c		; NoCursor
		push	hl
		push	bc
		call	CursorBlink
		pop	bc
		pop	hl
		ret
; End of function UpdateCursor?


; =============== S U B	R O U T	I N E =======================================


_ConOut_Default1:			; CODE XREF: ConOut+28p
		nop
		nop
		nop
		ld	a, c
		jp	HOOK1_conout
; End of function _ConOut_Default1

; ---------------------------------------------------------------------------
		db 0E6h	; 
		db  7Fh	; 
; ---------------------------------------------------------------------------

CONOUT_Default:				; DATA XREF: ConOut_INIT+5o
					; __RestoreDefConout+1o ...
		cp	20h ; ' '
		jp	c, _LowChars
		ld	a, c
		call	_conOut_RealChar
		jp	sub_219D
; ---------------------------------------------------------------------------

_LowChars:				; CODE XREF: RAM:2046j
		cp	1
		jp	z, _TurnGraphModeOn
		cp	1Bh
		jp	z, __ESC
		ld	hl, _TableControlChar

JmpTable2:				; CODE XREF: RAM:20DFj
		call	JumpStrangeTableHiLo
		push	de
		ret

; =============== S U B	R O U T	I N E =======================================


JumpStrangeTableHiLo:			; CODE XREF: RAM:JmpTable2p RAM:3647p
		push	hl

loc_2063:				; CODE XREF: JumpStrangeTableHiLo+Dj
		ld	b, (hl)
		inc	b
		jp	z, loc_2072
		cp	(hl)
		jp	c, loc_2076
		inc	hl
		inc	hl
		inc	hl
		jp	loc_2063
; ---------------------------------------------------------------------------

loc_2072:				; CODE XREF: JumpStrangeTableHiLo+3j
					; JumpStrangeTableHiLo+1Aj
		pop	hl
		pop	hl
		scf
		ret
; ---------------------------------------------------------------------------

loc_2076:				; CODE XREF: JumpStrangeTableHiLo+7j
		ld	b, a
		ld	a, (hl)
		sub	b
		dec	a
		inc	hl
		cp	(hl)
		jp	nc, loc_2072
		add	a, a
		inc	hl
		ld	b, a
		ld	a, (hl)
		sub	b
		ld	e, a
		ld	d, 0
		pop	hl
		add	hl, de
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		ret
; End of function JumpStrangeTableHiLo

; ---------------------------------------------------------------------------
_TableControlChar:db 10h		; DATA XREF: RAM:205Ao
		db 9
		db 20
		db 0FFh
		dw _chr_07_Beep
		dw _chr_08_BackSpace
		dw _chr_09_TAB
		dw _chr_0A_LF
		dw _chr_0B_HOME
		dw _chr_0C_FF_ClearWindow
		dw _chr_0D_CR
		dw _chr_0E_SI0
		dw _chr_0F_SI1
; ---------------------------------------------------------------------------

_TurnGraphModeOn:			; CODE XREF: RAM:2052j
		ld	hl, _GraphConOut
		ld	(HOOK1_conout+1), hl

loc_20A9:				; CODE XREF: RAM:2727j
		ld	hl, (_ConOut_CharGen_5)
		ld	(_ConOutSaveCharGen5), hl
		ld	hl,  ROM_CharGen+500h
		ld	(_ConOut_CharGen_5), hl
		ret
; ---------------------------------------------------------------------------

_GraphConOut:				; DATA XREF: RAM:_TurnGraphModeOno
		call	_conOut_RealChar
		call	sub_219D
		ld	hl, (_ConOutSaveCharGen5)
		ld	(_ConOut_CharGen_5), hl

; =============== S U B	R O U T	I N E =======================================


__RestoreDefConout:			; CODE XREF: sub_235A+27j sub_235A+2Dj ...
		push	hl
		ld	hl, CONOUT_Default
		ld	(HOOK1_conout+1), hl
		pop	hl
		ret
; End of function __RestoreDefConout

; ---------------------------------------------------------------------------

__ESC:					; CODE XREF: RAM:2057j
		ld	hl, _EscConOut
		ld	(HOOK1_conout+1), hl
		xor	a
		ld	(_ConOut_EscCntr), a
		ret
; ---------------------------------------------------------------------------

_EscConOut:				; DATA XREF: RAM:__ESCo
		ld	hl, CONOUT_Default
		ld	(HOOK1_conout+1), hl
		ld	hl, byte_20E2
		jp	JmpTable2
; ---------------------------------------------------------------------------
byte_20E2:	db 64h			; DATA XREF: RAM:20DCo
		db 24h
		db 4Ah
		db 0FFh
		dw _ESC_@_STI_RusLat
		dw loc_23AD
		dw loc_236F
		dw sub_235A
		dw _chr_08_BackSpace
		dw _ESC_E_Init
		dw _ESC_F_CreateSprite
		dw _InitGrOut_WithMod
		dw _chr_0B_HOME
		dw _ESC_I_Sprite
		dw loc_24F0
		dw sub_24D1
		dw _esc_L_WinFullScreen
		dw _ESC_M
		dw loc_2544
		dw loc_256F
		dw loc_2634
		dw loc_260B
		dw loc_26BD
		dw loc_22D6
		dw sub_2487
		dw loc_2683
		dw _EscU_SetColorMask
		dw _EscW
		dw _EscX
		dw _EscY_GotoXY
		dw _EscZ_setSTIxWideNarrow
		dw _conout_SETWide
		dw loc_2709
		dw loc_271C
		dw _conout_SETNarrow
		dw loc_26D4
		dw loc_2701
		dw _CursorOFF
		dw _CursorOn
		dw loc_2516
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR _chr_0C_FF_ClearWindow

_chr_0B_HOME:				; CODE XREF: _chr_0C_FF_ClearWindow+39j
					; DATA XREF: RAM:2099o	...
		ld	a, (_ConOut_WIN_Up)
		ld	(_ConOut_Cursor_Y), a

_chr_0D_CR:				; DATA XREF: RAM:209Do
		ld	a, (_ConOut_WIN_Left)
		ld	(_ConOut_Cursor_X), a
		ret
; END OF FUNCTION CHUNK	FOR _chr_0C_FF_ClearWindow

; =============== S U B	R O U T	I N E =======================================


_conOut_RealChar:			; CODE XREF: RAM:204Ap
					; RAM:_GraphConOutp ...

; FUNCTION CHUNK AT 21C8 SIZE 00000075 BYTES

		ld	b, a
		rrca
		rrca
		rrca
		rrca
		and	0Eh
		ld	de, _ConOut_CharGen_0
		ld	l, a
		ld	h, 0
		add	hl, de
		ld	e, (hl)
		inc	hl
		ld	d, (hl)
		ld	a, 1Fh
		and	b
		rlca
		rlca
		rlca
		ld	l, a
		ld	h, 0
		add	hl, de
		push	hl
		call	sub_2187
		pop	de
		ld	a, (_ConOut_Mode)
		and	82h ; ''
		jp	nz, loc_21C8
		ld	a, (_ConOut4080)
		ld	c, a
		ld	b, 8

loc_2169:				; CODE XREF: _conOut_RealChar+3Cj
		ld	a, (_ConOut_OutMask)
		ld	(hl), a
		ld	a, (de)
		xor	(hl)
		ld	(hl), a
		inc	de
		ld	a, b
		ld	b, 0
		add	hl, bc
		ld	b, a
		dec	b
		jp	nz, loc_2169
		ld	a, (_ConOut_Mode)
		and	40h ; '@'
		ret	nz
		ld	a, (_ConOut_OutMask)
		ld	(hl), a
		add	hl, bc
		ld	(hl), a
		ret
; End of function _conOut_RealChar


; =============== S U B	R O U T	I N E =======================================


sub_2187:				; CODE XREF: _conOut_RealChar+1Cp
					; CursorBlinkp
		ld	a, (_ConOut_Cursor_Y)
		call	sub_224D
		ld	b, c
		ld	a, (_ConOut_Mode)
		and	2
		ld	a, (_ConOut_Cursor_X)
		jp	z, loc_219A
		rlca

loc_219A:				; CODE XREF: sub_2187+Fj
		ld	c, a
		add	hl, bc
		ret
; End of function sub_2187


; =============== S U B	R O U T	I N E =======================================


sub_219D:				; CODE XREF: RAM:204Dj	RAM:20B9p

; FUNCTION CHUNK AT 22D6 SIZE 00000079 BYTES

		ld	a, (_ConOut_WIN_Right)
		ld	c, a
		call	sub_234F
		ld	a, (_ConOut_Cursor_X)
		add	a, b
		ld	(_ConOut_Cursor_X), a
		cp	c
		ret	c
		ld	a, (_ConOut_WIN_Left)
		ld	(_ConOut_Cursor_X), a

_chr_0A_LF:				; DATA XREF: RAM:2097o
		ld	a, (_ConOut_WIN_Down)
		ld	c, a
		ld	a, (_ConOut_Cursor_Y)
		inc	a
		ld	(_ConOut_Cursor_Y), a
		cp	c
		ret	c
		ld	a, c
		dec	a
		ld	(_ConOut_Cursor_Y), a
		jp	loc_22D6
; End of function sub_219D

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR _conOut_RealChar

loc_21C8:				; CODE XREF: _conOut_RealChar+25j
		ld	a, (_ConOut4080)
		ld	c, a
		ld	b, 8

loc_21CE:				; CODE XREF: _conOut_RealChar+DFj
		ld	a, (_ConOut_ColorMask)
		ld	(hl), a
		inc	hl
		ld	(hl), a
		push	bc
		ld	a, (de)
		ld	b, a
		ld	a, (_ConOut_OutMask)
		xor	b
		push	hl
		and	0Fh
		ld	c, a
		ld	b, 0
		ld	hl, 223Dh
		add	hl, bc
		ld	a, (hl)
		pop	hl
		and	(hl)
		ld	(hl), a
		dec	hl
		push	hl
		ld	a, (de)
		ld	b, a
		ld	a, (_ConOut_OutMask)
		xor	b
		and	0F0h ; ''
		rrca
		rrca
		rrca
		rrca
		ld	c, a
		ld	b, 0
		ld	hl, 223Dh
		add	hl, bc
		ld	a, (hl)
		pop	hl
		and	(hl)
		ld	(hl), a
		inc	de
		ld	a, (_ConOut_Mode)
		and	20h ; ' '
		jp	z, loc_2213
		ld	a, (_ConOut_ColorMask)
		rrca
		rrca
		ld	(_ConOut_ColorMask), a

loc_2213:				; CODE XREF: _conOut_RealChar+CDj
		pop	bc
		ld	a, b
		ld	b, 0
		add	hl, bc
		ld	b, a
		dec	b
		jp	nz, loc_21CE
		ld	a, (_ConOut_Mode)
		and	40h ; '@'
		ret	nz

loc_2223:				; CODE XREF: _conOut_RealChar+FFj
		ld	a, (_ConOut_ColorMask)
		ld	(hl), a
		inc	hl
		ld	(hl), a
		ld	a, (_ConOut_OutMask)
		and	(hl)
		ld	(hl), a
		dec	hl
		ld	a, (_ConOut_OutMask)
		and	(hl)
		ld	(hl), a
		ld	a, b
		or	a
		ret	nz
		add	hl, bc
		ld	b, 1
		jp	loc_2223
; END OF FUNCTION CHUNK	FOR _conOut_RealChar
; ---------------------------------------------------------------------------
		db 0, 3, 0Ch, 0Fh, 30h,	33h, 3Ch, 3Fh, 0C0h, 0C3h, 0CCh
		db 0CFh, 0F0h, 0F3h, 0FCh, 0FFh

; =============== S U B	R O U T	I N E =======================================


sub_224D:				; CODE XREF: sub_2187+3p sub_219D+144p ...
		ld	b, a
		ld	a, (_ConOut_Mode)
		and	3
		jp	z, loc_2259
		ld	a, b
		rlca
		ld	b, a

loc_2259:				; CODE XREF: sub_224D+6j
		ld	a, (_ConOut_Mode)
		and	40h ; '@'
		jp	nz, loc_227C
		xor	a
		ld	a, b
		rra
		ld	d, a
		ld	a, 0
		rra
		ld	e, a
		ld	a, b
		rrca
		rrca
		rrca
		rrca
		ld	h, a
		and	0F0h ; ''
		ld	l, a
		ld	a, h
		and	0Fh
		ld	h, a
		ld	c, 0
		add	hl, de
		jp	loc_2289
; ---------------------------------------------------------------------------

loc_227C:				; CODE XREF: sub_224D+11j
		ld	a, b
		rrca
		rrca
		ld	h, a
		and	0C0h ; ''
		ld	l, a
		ld	a, h
		and	3Fh ; '?'
		ld	h, a
		ld	c, 0

loc_2289:				; CODE XREF: sub_224D+2Cj
		add	hl, bc
		ld	a, (_ConOut_Mode)
		and	10h
		ld	de, 0C000h
		jp	z, loc_2298
		ld	de, 0E000h

loc_2298:				; CODE XREF: sub_224D+45j
		add	hl, de
		ret
; End of function sub_224D


; =============== S U B	R O U T	I N E =======================================


sub_229A:				; CODE XREF: sub_219D+152p
					; _chr_0C_FF_ClearWindow+Fp ...
		ld	a, (_ConOut_WIN_Up)
		ld	b, a
		ld	a, (_ConOut_WIN_Down)
		sub	b
		ld	b, a
		ld	a, (_ConOut_Mode)
		and	3
		jp	z, loc_22AE
		ld	a, b
		rlca
		ld	b, a

loc_22AE:				; CODE XREF: sub_229A+Ej
		ld	a, b
		rlca
		ld	c, a
		rlca
		rlca
		rlca
		ld	h, a
		and	0F0h ; ''
		ld	l, a
		ld	a, h
		and	0Fh
		ld	h, a
		ld	b, 0
		ld	d, h
		ld	e, l
		add	hl, de
		ld	a, (_ConOut_Mode)
		and	40h ; '@'
		jp	nz, loc_22CE
		add	hl, de
		add	hl, bc
		ld	b, h
		ld	c, l
		ret
; ---------------------------------------------------------------------------

loc_22CE:				; CODE XREF: sub_229A+2Cj
		ld	a, c
		rlca
		ld	c, a
		add	hl, bc
		add	hl, bc
		ld	b, h
		ld	c, l
		ret
; End of function sub_229A

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_219D

loc_22D6:				; CODE XREF: sub_219D+28j
					; DATA XREF: RAM:210Co
		di
		ld	hl, 0
		add	hl, sp
		ld	(SSTACK), hl
		ld	a, (_ConOut_WIN_Up)
		call	sub_224D
		ld	(_ConOutSaveCharGen5), hl
		ld	a, (_ConOut_WIN_Up)
		inc	a
		call	sub_224D
		push	hl
		call	sub_229A
		pop	hl
		ld	sp, hl
		inc	b
		ld	hl, (_ConOutSaveCharGen5)

loc_22F8:				; CODE XREF: sub_219D+170j
					; sub_219D+174j
		pop	de
		ld	(hl), e
		inc	hl
		ld	(hl), d
		inc	hl
		pop	de
		ld	(hl), e
		inc	hl
		ld	(hl), d
		inc	hl
		pop	de
		ld	(hl), e
		inc	hl
		ld	(hl), d
		inc	hl
		pop	de
		ld	(hl), e
		inc	hl
		ld	(hl), d
		inc	hl
		dec	c
		jp	nz, loc_22F8
		dec	b
		jp	nz, loc_22F8
		ld	hl, (SSTACK)
		ld	sp, hl
		ei
		ld	a, (_ConOut_WIN_Down)
		dec	a

loc_231D:				; CODE XREF: sub_2487+47j
		call	sub_224D
		ld	a, (_ConOut4080)
		ld	c, a
		ld	e, a
		ld	a, (_ConOut_Mode)
		and	40h ; '@'
		ld	b, 4
		jp	nz, loc_2330
		inc	b

loc_2330:				; CODE XREF: sub_219D+18Fj
		ld	a, (_ConOut_OutMask)
		ld	d, a
		ld	a, (_ConOut_Mode)
		and	82h ; ''
		ld	a, d
		jp	z, loc_2341
		ld	a, (_ConOut_ColorMask)
		and	d

loc_2341:				; CODE XREF: sub_219D+19Dj
					; sub_219D+1A9j ...
		ld	(hl), a
		inc	hl
		ld	(hl), a
		inc	hl
		dec	c
		jp	nz, loc_2341
		ld	c, e
		dec	b
		jp	nz, loc_2341
		ret
; END OF FUNCTION CHUNK	FOR sub_219D

; =============== S U B	R O U T	I N E =======================================


sub_234F:				; CODE XREF: sub_219D+4p sub_235Ap ...
		ld	b, 1
		ld	a, (_ConOut_Mode)
		and	80h ; ''
		rlca
		add	a, b
		ld	b, a
		ret
; End of function sub_234F


; =============== S U B	R O U T	I N E =======================================


sub_235A:				; CODE XREF: sub_24D1+Bp
					; DATA XREF: RAM:20ECo
		call	sub_234F
		ld	a, (_ConOut_WIN_Right)
		ld	c, a
		ld	a, (_ConOut_Cursor_X)
		add	a, b

loc_2365:				; CODE XREF: RAM:23D5j
		cp	c
		jp	c, loc_2384
		ld	a, (_ConOut_WIN_Left)
		ld	(_ConOut_Cursor_X), a

loc_236F:				; DATA XREF: RAM:20EAo
		ld	a, (_ConOut_WIN_Down)
		ld	c, a
		ld	a, (_ConOut_Cursor_Y)
		inc	a
		cp	c
		jp	c, loc_237E
		ld	a, (_ConOut_WIN_Up)

loc_237E:				; CODE XREF: sub_235A+1Ej RAM:23B9j ...
		ld	(_ConOut_Cursor_Y), a
		jp	__RestoreDefConout
; ---------------------------------------------------------------------------

loc_2384:				; CODE XREF: sub_235A+Cj RAM:2399j
		ld	(_ConOut_Cursor_X), a
		jp	__RestoreDefConout
; End of function sub_235A

; ---------------------------------------------------------------------------

_chr_08_BackSpace:			; DATA XREF: RAM:2093o	RAM:20EEo
		call	sub_234F
		ld	a, (_ConOut_WIN_Left)
		ld	c, a
		ld	a, (_ConOut_Cursor_X)
		cp	c
		jp	z, loc_239C
		sub	b
		jp	nc, loc_2384

loc_239C:				; CODE XREF: RAM:2395j
		ld	a, (_ConOut_WIN_Right)
		dec	a
		ld	c, a
		ld	a, (_ConOut_Mode)
		rla
		ld	a, c
		jp	nc, loc_23AA
		dec	a

loc_23AA:				; CODE XREF: RAM:23A6j
		ld	(_ConOut_Cursor_X), a

loc_23AD:				; DATA XREF: RAM:20E8o
		ld	a, (_ConOut_WIN_Up)
		ld	c, a
		ld	a, (_ConOut_Cursor_Y)
		cp	c
		jp	z, loc_23BC
		dec	a
		jp	nc, loc_237E

loc_23BC:				; CODE XREF: RAM:23B5j
		ld	a, (_ConOut_WIN_Down)
		dec	a
		jp	loc_237E
; ---------------------------------------------------------------------------

_chr_09_TAB:				; DATA XREF: RAM:2095o
		call	sub_234F
		ld	a, b
		rlca
		rlca
		rlca
		ld	b, a
		ld	a, (_ConOut_WIN_Right)
		ld	c, a
		ld	a, (_ConOut_Cursor_X)
		add	a, b
		and	0F8h ; ''
		jp	loc_2365
; ---------------------------------------------------------------------------

_chr_07_Beep:				; DATA XREF: RAM:2091o
		ld	a, 0
		jp	HOOK3_Sound

; =============== S U B	R O U T	I N E =======================================


_chr_0C_FF_ClearWindow:			; CODE XREF: RAM:2506p
					; ConOut_INIT+537j ...

; FUNCTION CHUNK AT 212E SIZE 0000000D BYTES

		di
		ld	hl, 0
		add	hl, sp
		ld	(SSTACK), hl
		ld	a, (_ConOut_WIN_Down)
		call	sub_224D
		push	hl
		call	sub_229A
		pop	hl
		ld	sp, hl
		ld	a, (_ConOut_OutMask)
		ld	d, a
		ld	a, (_ConOut_Mode)
		and	82h ; ''
		ld	a, d
		jp	z, loc_2402
		ld	a, (_ConOut_ColorMask)
		and	d

loc_2402:				; CODE XREF: _chr_0C_FF_ClearWindow+1Ej
		ld	d, a
		ld	e, a
		inc	b

loc_2405:				; CODE XREF: _chr_0C_FF_ClearWindow+2Dj
					; _chr_0C_FF_ClearWindow+31j
		push	de
		push	de
		push	de
		push	de
		dec	c
		jp	nz, loc_2405
		dec	b
		jp	nz, loc_2405
		ld	hl, (SSTACK)
		ld	sp, hl
		ei
		jp	_chr_0B_HOME
; End of function _chr_0C_FF_ClearWindow


; =============== S U B	R O U T	I N E =======================================


CursorBlink:				; CODE XREF: UpdateCursor?+7p
		call	sub_2187
		ld	a, (_ConOut4080)
		ld	e, a
		ld	d, 0
		ld	a, (_ConOut_Mode)
		ld	c, a
		ld	b, 4
		and	40h ; '@'
		jp	z, loc_245E

loc_242D:				; CODE XREF: CursorBlink+28j
		ld	a, (_ConOut_Cursor_Up_Down)
		xor	(hl)
		ld	(hl), a
		ld	a, c
		and	82h ; ''
		jp	z, loc_243F
		inc	hl
		ld	a, (_ConOut_Cursor_Up_Down)
		xor	(hl)
		ld	(hl), a
		dec	hl

loc_243F:				; CODE XREF: CursorBlink+1Cj
		add	hl, de
		dec	b
		jp	nz, loc_242D
		ld	b, 4

loc_2446:				; CODE XREF: CursorBlink+41j
		ld	a, (_ConOut_Cursor_Up_Down+1)
		xor	(hl)
		ld	(hl), a
		ld	a, c
		and	82h ; ''
		jp	z, loc_2458
		inc	hl
		ld	a, (_ConOut_Cursor_Up_Down+1)
		xor	(hl)
		ld	(hl), a
		dec	hl

loc_2458:				; CODE XREF: CursorBlink+35j
		add	hl, de
		dec	b
		jp	nz, loc_2446
		ret
; ---------------------------------------------------------------------------

loc_245E:				; CODE XREF: CursorBlink+11j
					; CursorBlink+48j
		add	hl, de
		add	hl, de
		dec	b
		jp	nz, loc_245E
		ld	a, (_ConOut_Cursor_Up_Down)
		xor	(hl)
		ld	(hl), a
		ld	a, c
		and	82h ; ''
		jp	z, loc_2476
		inc	hl
		ld	a, (_ConOut_Cursor_Up_Down)
		xor	(hl)
		ld	(hl), a
		dec	hl

loc_2476:				; CODE XREF: CursorBlink+53j
		add	hl, de
		ld	a, (_ConOut_Cursor_Up_Down+1)
		xor	(hl)
		ld	(hl), a
		ld	a, c
		and	82h ; ''
		ret	z
		inc	hl
		ld	a, (_ConOut_Cursor_Up_Down+1)
		xor	(hl)
		ld	(hl), a
		ret
; End of function CursorBlink


; =============== S U B	R O U T	I N E =======================================


sub_2487:				; CODE XREF: RAM:2523p
					; DATA XREF: RAM:210Eo
		di
		ld	hl, 0
		add	hl, sp
		ld	(SSTACK), hl
		ld	a, (_ConOut_WIN_Down)
		dec	a
		call	sub_224D
		dec	hl
		ld	(_ConOutSaveCharGen5), hl
		ld	a, (_ConOut_WIN_Down)
		call	sub_224D
		push	hl
		call	sub_229A
		inc	b
		pop	hl
		ld	sp, hl
		ld	hl, (_ConOutSaveCharGen5)

loc_24AA:				; CODE XREF: sub_2487+38j sub_2487+3Cj
		ld	d, (hl)
		dec	hl
		ld	e, (hl)
		dec	hl
		push	de
		ld	d, (hl)
		dec	hl
		ld	e, (hl)
		dec	hl
		push	de
		ld	d, (hl)
		dec	hl
		ld	e, (hl)
		dec	hl
		push	de
		ld	d, (hl)
		dec	hl
		ld	e, (hl)
		dec	hl
		push	de
		dec	c
		jp	nz, loc_24AA
		dec	b
		jp	nz, loc_24AA
		ld	hl, (SSTACK)
		ld	sp, hl
		ei
		ld	a, (_ConOut_WIN_Up)
		jp	loc_231D
; End of function sub_2487


; =============== S U B	R O U T	I N E =======================================


sub_24D1:				; CODE XREF: RAM:loc_24F0p
					; DATA XREF: RAM:20FCo
		ld	hl, (_ConOut_Cursor_X)
		ld	(word_FF72), hl

loc_24D7:				; CODE XREF: sub_24D1+15j
		ld	a, 20h ; ' '
		call	_conOut_RealChar
		call	sub_235A
		ld	a, (_ConOut_Cursor_X)
		ld	hl, 0FF48h
		cp	(hl)
		jp	nz, loc_24D7
		ld	hl, (word_FF72)
		ld	(_ConOut_Cursor_X), hl
		ret
; End of function sub_24D1

; ---------------------------------------------------------------------------

loc_24F0:				; DATA XREF: RAM:20FAo
		call	sub_24D1
		ld	a, (_ConOut_WIN_Up)
		ld	(word_FF72), a
		ld	a, (_ConOut_Cursor_Y)
		inc	a
		ld	(_ConOut_WIN_Up), a
		ld	hl, (_ConOut_Cursor_X)
		ld	(_ConOutSaveCharGen5), hl
		call	_chr_0C_FF_ClearWindow
		ld	hl, (_ConOutSaveCharGen5)
		ld	(_ConOut_Cursor_X), hl

loc_250F:				; CODE XREF: RAM:2526j
		ld	a, (word_FF72)
		ld	(_ConOut_WIN_Up), a
		ret
; ---------------------------------------------------------------------------

loc_2516:				; DATA XREF: RAM:212Co
		ld	a, (_ConOut_WIN_Up)
		ld	(word_FF72), a
		ld	a, (_ConOut_Cursor_Y)
		nop
		ld	(_ConOut_WIN_Up), a
		call	sub_2487
		jp	loc_250F
; ---------------------------------------------------------------------------
		db    0

; =============== S U B	R O U T	I N E =======================================


_LDIRB:					; CODE XREF: _LDIRB+5j
					; ConOut_INIT+531p ...
		ld	a, (hl)
		ld	(de), a
		inc	hl
		inc	de
		dec	b
		jp	nz, _LDIRB
		ret
; End of function _LDIRB

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR ConOut_INIT

_ESC_E_Init:				; CODE XREF: ConOut_INIT+18j
					; DATA XREF: RAM:20F0o
		ld	hl, _conout_DefaultVars
		ld	de, _ConOut_Cursor_Up_Down
		ld	b, 20h ; ' '
		call	_LDIRB
		call	_ConOut_FixScreenVar
		jp	_chr_0C_FF_ClearWindow
; END OF FUNCTION CHUNK	FOR ConOut_INIT
; ---------------------------------------------------------------------------

loc_2544:				; DATA XREF: RAM:2102o
		ld	hl, _ConOut_Cursor_Up_Down
		ld	de, ASRAR
		ld	b, 0Eh
		jp	_LDIRB
; ---------------------------------------------------------------------------
_conout_DefaultVars:db [ 2 ], 0FFh	; DATA XREF: ConOut_INIT:_ESC_E_Inito
		db 0, 0FFh, 28h, 10h
		db [ 4 ], 0
		db 28h,	14h, 0Eh
		db [ 4 ], 0
		db 38h
unk_2561:	db    0			; DATA XREF: RAM:2746o	RAM:2758o
		db  39h	; 9
		db    0
		db  3Ah	; :
		db    0
		db  3Bh	; ;
		db    0
		db  3Ch	; <
		db    0
		db  39h	; 9
		db    0
		db  3Eh	; >
		db    0
		db  3Fh	; ?
; ---------------------------------------------------------------------------

loc_256F:				; DATA XREF: RAM:2104o
		ld	hl, ASRAR
		ld	de, _ConOut_Cursor_Up_Down
		ld	b, 0Eh
		call	_LDIRB

; =============== S U B	R O U T	I N E =======================================


_ConOut_FixScreenVar:			; CODE XREF: ConOut_INIT+534p
					; RAM:262Dj ...
		ld	a, (_ConOut_Color)
		out	(VID_COLOR), a
		ld	a, (_ConOut_Mode)
		ld	b, a
		rla
		jp	c, loc_25E9

loc_2587:				; CODE XREF: _ConOut_FixScreenVar+79j
		ld	a, b
		or	a
		jp	z, loc_25A7
		and	3
		ld	a, 40
		ld	(_ConOut4080), a
		ld	a, 1Ah
		jp	z, loc_25A7
		ld	a, 80
		ld	(_ConOut4080), a
		ld	a, b
		and	2
		ld	a, _MRHR|_VIEN|82h
		jp	z, loc_25A7
		ld	a, _MRHR|82h

loc_25A7:				; CODE XREF: _ConOut_FixScreenVar+Fj
					; _ConOut_FixScreenVar+1Bj ...
		out	(VID_MODE), a
		ld	a, b
		and	10h		; C000/E000
		rrca
		rrca
		rrca
		rrca
		out	(VID_PAGE), a

loc_25B2:				; CODE XREF: RAM:26AFj	RAM:26BAj ...
		ld	hl, _ConOut_WIN_Right
		call	_ConOut_GetScrMode320640
		cp	(hl)
		jp	nc, loc_25BD
		ld	(hl), a

loc_25BD:				; CODE XREF: _ConOut_FixScreenVar+3Fj
		ld	hl, _ConOut_WIN_Left
		dec	a
		cp	(hl)
		jp	nc, loc_25C6
		ld	(hl), a

loc_25C6:				; CODE XREF: _ConOut_FixScreenVar+48j
		ld	hl, _ConOut_Cursor_X
		cp	(hl)
		jp	nc, loc_25CE
		ld	(hl), a

loc_25CE:				; CODE XREF: _ConOut_FixScreenVar+50j
		ld	hl, _ConOut_WIN_Down
		call	_ConOut_GetLines2025
		cp	(hl)
		jp	nc, loc_25D9
		ld	(hl), a

loc_25D9:				; CODE XREF: _ConOut_FixScreenVar+5Bj
		ld	hl, _ConOut_WIN_Up
		dec	a
		cp	(hl)
		jp	nc, loc_25E2
		ld	(hl), a

loc_25E2:				; CODE XREF: _ConOut_FixScreenVar+64j
		ld	hl, _ConOut_Cursor_Y
		cp	(hl)
		ret	nc
		ld	(hl), a
		ret
; ---------------------------------------------------------------------------

loc_25E9:				; CODE XREF: _ConOut_FixScreenVar+Aj
		ld	a, (_ConOut_Cursor_X)
		ld	c, a
		and	1
		add	a, c
		ld	(_ConOut_Cursor_X), a
		jp	loc_2587
; End of function _ConOut_FixScreenVar


; =============== S U B	R O U T	I N E =======================================


_ConOut_GetScrMode320640:		; CODE XREF: _ConOut_FixScreenVar+3Bp
					; RAM:265Ep ...
		ld	a, (_ConOut_Mode)
		and	1
		ld	a, 40
		ret	z
		rlca
		ret
; End of function _ConOut_GetScrMode320640


; =============== S U B	R O U T	I N E =======================================


_ConOut_GetLines2025:			; CODE XREF: _ConOut_FixScreenVar+57p
					; RAM:2664p ...
		ld	a, (_ConOut_Mode)
		and	40h ; '@'
		ld	a, 20
		ret	z
		ld	a, 25
		ret
; End of function _ConOut_GetLines2025

; ---------------------------------------------------------------------------

loc_260B:				; DATA XREF: RAM:2108o
		ld	hl, loc_2612
		ld	(HOOK1_conout+1), hl
		ret
; ---------------------------------------------------------------------------

loc_2612:				; DATA XREF: RAM:loc_260Bo
		and	10h
		ld	a, 0
		jp	nz, loc_2627
		ld	a, c
		and	3
		ld	hl, unk_2630
		ld	e, a
		ld	d, 0
		add	hl, de
		ld	a, 0ECh	; ''
		and	c
		or	(hl)

loc_2627:				; CODE XREF: RAM:2616j
		ld	(_ConOut_Mode),	a
		call	__RestoreDefConout
		jp	_ConOut_FixScreenVar
; ---------------------------------------------------------------------------
unk_2630:	db    0			; DATA XREF: RAM:261Co
		db  10h
		db    1
		db    2
; ---------------------------------------------------------------------------

loc_2634:				; DATA XREF: RAM:2106o
		ld	hl, loc_263B
		ld	(HOOK1_conout+1), hl
		ret
; ---------------------------------------------------------------------------

loc_263B:				; DATA XREF: RAM:loc_2634o
		ld	(_ConOut_Color), a
		call	__RestoreDefConout
		jp	_ConOut_FixScreenVar
; ---------------------------------------------------------------------------

_conout_SETWide:			; CODE XREF: RAM:2737j
					; DATA XREF: RAM:211Co
		ld	a, (_ConOut_Mode)
		or	80h ; ''

loc_2649:				; CODE XREF: RAM:2654j
		ld	(_ConOut_Mode),	a
		jp	_ConOut_FixScreenVar
; ---------------------------------------------------------------------------

_conout_SETNarrow:			; CODE XREF: RAM:2755j
					; DATA XREF: RAM:2122o
		ld	a, (_ConOut_Mode)
		and	7Fh ; ''
		jp	loc_2649
; ---------------------------------------------------------------------------

_esc_L_WinFullScreen:			; DATA XREF: RAM:20FEo
		xor	a
		ld	(_ConOut_WIN_Left), a
		ld	(_ConOut_WIN_Up), a
		call	_ConOut_GetScrMode320640
		ld	(_ConOut_WIN_Right), a
		call	_ConOut_GetLines2025
		ld	(_ConOut_WIN_Down), a
		ret
; ---------------------------------------------------------------------------

_EscX:					; DATA XREF: RAM:2116o
		xor	a
		ld	(_ConOut_WIN_Left), a
		call	_ConOut_GetScrMode320640
		ld	(_ConOut_WIN_Right), a
		call	_ConOut_GetLines2025
		ld	(_ConOut_WIN_Down), a
		sub	4
		ld	(_ConOut_WIN_Up), a
		jp	_chr_0C_FF_ClearWindow
; ---------------------------------------------------------------------------

loc_2683:				; DATA XREF: RAM:2110o
		ld	hl, loc_268A
		ld	(HOOK1_conout+1), hl
		ret
; ---------------------------------------------------------------------------

loc_268A:				; DATA XREF: RAM:loc_2683o
		ld	(_ConOut_OutMask), a
		jp	__RestoreDefConout
; ---------------------------------------------------------------------------

_EscU_SetColorMask:			; DATA XREF: RAM:2112o
		ld	hl, loc_2697
		ld	(HOOK1_conout+1), hl
		ret
; ---------------------------------------------------------------------------

loc_2697:				; DATA XREF: RAM:_EscU_SetColorMasko
		ld	(_ConOut_ColorMask), a
		jp	__RestoreDefConout
; ---------------------------------------------------------------------------

_EscY_GotoXY:				; DATA XREF: RAM:2118o
		ld	hl, loc_26A4
		ld	(HOOK1_conout+1), hl
		ret
; ---------------------------------------------------------------------------

loc_26A4:				; DATA XREF: RAM:_EscY_GotoXYo
		ld	hl, loc_26B2
		ld	(HOOK1_conout+1), hl
		sub	20h ; ' '
		ld	(_ConOut_Cursor_Y), a
		jp	loc_25B2
; ---------------------------------------------------------------------------

loc_26B2:				; DATA XREF: RAM:loc_26A4o
		sub	20h ; ' '
		ld	(_ConOut_Cursor_X), a
		call	__RestoreDefConout
		jp	loc_25B2
; ---------------------------------------------------------------------------

loc_26BD:				; DATA XREF: RAM:210Ao
		ld	hl, loc_26C4
		ld	(HOOK1_conout+1), hl
		ret
; ---------------------------------------------------------------------------

loc_26C4:				; DATA XREF: RAM:loc_26BDo
		ld	(_ConOut_Cursor_Up_Down), a
		ld	hl, loc_26CE
		ld	(HOOK1_conout+1), hl
		ret
; ---------------------------------------------------------------------------

loc_26CE:				; DATA XREF: RAM:26C7o
		ld	(_ConOut_Cursor_Up_Down+1), a
		jp	__RestoreDefConout
; ---------------------------------------------------------------------------

loc_26D4:				; DATA XREF: RAM:2124o
		ld	hl, _ConOut_CharGen_0
		ld	a, 10h

loc_26D9:				; CODE XREF: RAM:26FEj	RAM:2706j
		ld	(_ConOutSaveCharGen5), hl
		ld	(_ConOut_EscCntr), a
		ld	hl, loc_26E6
		ld	(HOOK1_conout+1), hl
		ret
; ---------------------------------------------------------------------------

loc_26E6:				; DATA XREF: RAM:26DFo
		ld	hl, (_ConOutSaveCharGen5)
		ld	(hl), a
		inc	hl
		ld	(_ConOutSaveCharGen5), hl
		ld	hl, _ConOut_EscCntr
		dec	(hl)
		ret	nz
		call	loc_25B2
		jp	__RestoreDefConout
; ---------------------------------------------------------------------------

_EscW:					; DATA XREF: RAM:2114o
		ld	hl, _ConOut_WIN_Left
		ld	a, 4
		jp	loc_26D9
; ---------------------------------------------------------------------------

loc_2701:				; DATA XREF: RAM:2126o
		ld	hl, ASRAR
		ld	a, 0Eh
		jp	loc_26D9
; ---------------------------------------------------------------------------

loc_2709:				; DATA XREF: RAM:211Eo
		ld	hl,  ROM_CharGen+700h
		ld	(_ConOut_CharGen_3), hl
		ld	hl,  ROM_CharGen+600h
		ld	(_ConOut_CharGen_7), hl
		ld	hl,  ROM_CharGen+300h
		ld	(_ConOut_CharGen_6), hl
		ret
; ---------------------------------------------------------------------------

loc_271C:				; DATA XREF: RAM:2120o
		ld	hl,  _conout_DefaultVars+10h
		ld	de, _ConOut_CharGen_0
		ld	b, 10h
		call	_LDIRB
		jp	loc_20A9
; ---------------------------------------------------------------------------

_ESC_@_STI_RusLat:			; DATA XREF: RAM:20E6o
		ld	a, (_ConOut_MODEC) ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		or	80h ; ''
		ld	(_ConOut_MODEC), a ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		ret
; ---------------------------------------------------------------------------

_chr_0E_SI0:				; DATA XREF: RAM:209Fo
		ld	a, (_ConOut_MODEC) ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		rla
		jp	nc, _conout_SETWide
		ld	hl,  ROM_CharGen+600h
		ld	(_ConOut_CharGen_2), hl
		ld	hl,  ROM_CharGen+700h
		ld	(_ConOut_CharGen_3), hl
		ld	hl, unk_2561
		ld	de, _ConOut_CharGen_5
		ld	b, 6
		jp	_LDIRB
; ---------------------------------------------------------------------------

_chr_0F_SI1:				; DATA XREF: RAM:20A1o
		ld	a, (_ConOut_MODEC) ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		rla
		jp	nc, _conout_SETNarrow
		ld	hl, unk_2561
		ld	de, _ConOut_CharGen_1
		ld	b, 0Eh
		jp	_LDIRB
; ---------------------------------------------------------------------------

_CursorOFF:				; DATA XREF: RAM:2128o
		ld	a, (_ConOut_MODEC) ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		or	1
		ld	(_ConOut_MODEC), a ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		ret
; ---------------------------------------------------------------------------

_CursorOn:				; DATA XREF: RAM:212Ao
		ld	a, (_ConOut_MODEC) ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		and	0FEh ; ''
		ld	(_ConOut_MODEC), a ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		ret
; ---------------------------------------------------------------------------

_EscZ_setSTIxWideNarrow:		; DATA XREF: RAM:211Ao
		ld	a, (_ConOut_MODEC) ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		and	7Fh ; ''
		ld	(_ConOut_MODEC), a ; D7(CharWidth 1-wide), D0(1-nocursor)
					;
		ret
; ---------------------------------------------------------------------------

_ESC_F_CreateSprite:			; DATA XREF: RAM:20F2o
		xor	a
		jp	HOOK2_Img
; ---------------------------------------------------------------------------

_ESC_I_Sprite:				; DATA XREF: RAM:20F8o
		ld	a, 0FFh
		jp	HOOK2_Img
; ---------------------------------------------------------------------------

_ESC_M:					; DATA XREF: RAM:2100o
		ld	a, 0FFh
		jp	HOOK3_Sound
; ---------------------------------------------------------------------------

InitGROUT:
		jp	_InitGrOut_WithMod
; ---------------------------------------------------------------------------

InitGrOut_WithMod:
		jp	_InitGrOut_WithMod_0
; ---------------------------------------------------------------------------

SetColor:
		jp	_G_C_SetColor_A
; ---------------------------------------------------------------------------
		jp	_RestoreDefConOut
; ---------------------------------------------------------------------------
		jp	_G_P_PSET_HLDE
; ---------------------------------------------------------------------------
		jp	_LINE_HLDE
; ---------------------------------------------------------------------------
		jp	_CIRCLE_HLDEA
; ---------------------------------------------------------------------------
		jp	_PAINT_HLDEA
; ---------------------------------------------------------------------------
		jp	_GraphLangNextChar
; ---------------------------------------------------------------------------

_CircleDugaParam:
		ld	(word_FFCB), a
		ld	a, h
		and	7
		ld	h, a
		ld	(word_FFB8), hl
		ex	de, hl
		ld	a, h
		and	7
		ld	h, a
		ld	(word_FFB6), hl
		ld	a, b
		ld	(word_FFCD), a
		ret
; ---------------------------------------------------------------------------

_G_C_SetColor_A:			; CODE XREF: RAM:SetColorj
					; DATA XREF: RAM:37D1o
		ld	hl,  word_FFC4+1
		and	3
		ld	(hl), a
		ld	b, a
		rlca
		rlca
		or	b
		rlca
		rlca
		or	b
		rlca
		rlca
		or	b
		ld	b, a
		ld	a, (_ConOut_Mode)
		and	1Fh
		dec	a
		dec	a
		ld	a, b
		jp	z, loc_27DC
		rlca
		or	b

loc_27DC:				; CODE XREF: RAM:27D7j
		inc	hl
		ld	(hl), a
		ret

; =============== S U B	R O U T	I N E =======================================

; Attributes: thunk

_RestoreDefConOut:			; CODE XREF: RAM:2795j
					; RAM:_G_T_restoreConOutp
		jp	__RestoreDefConout
; End of function _RestoreDefConOut

; ---------------------------------------------------------------------------
unk_27E2:	db    0			; DATA XREF: sub_284C:loc_285Fo
		db    3
		db  0Ch
		db    0
		db  30h	; 0
		db    0
		db    0
		db    0
		db 0C0h	; 
		db  80h	; 
		db  40h	; @
		db  20h
		db  10h
		db    8
		db    4
		db    2
		db    1
; ---------------------------------------------------------------------------

_InitGrOut_WithMod:			; CODE XREF: RAM:InitGROUTj
					; DATA XREF: RAM:20F4o
		ld	hl, _GraphLangNextChar
		ld	(HOOK1_conout+1), hl

_InitGrOut_WithMod_0:			; CODE XREF: RAM:InitGrOut_WithModj
		call	sub_35C2
		xor	a
		ld	(byte_FFF1), a
		ld	a, (_ConOut_Mode)
		and	1Fh
		jp	z, loc_2813
		dec	a
		jp	z, loc_287B
		dec	a
		jp	z, loc_283D
		jp	loc_2819
; ---------------------------------------------------------------------------

loc_2813:				; CODE XREF: RAM:2805j
		ld	hl, 0DF18h
		jp	loc_281C
; ---------------------------------------------------------------------------

loc_2819:				; CODE XREF: RAM:2810j
		ld	hl, 0FF18h

loc_281C:				; CODE XREF: RAM:2816j
		ld	(word_FFC9), hl
		ld	a, (unk_2829)
		ld	(word_FFD1), a
		jp	loc_2887
; ---------------------------------------------------------------------------
unk_2828:	db  29h	; )		; DATA XREF: RAM:2881r
unk_2829:	db 0C9h	; 		; DATA XREF: RAM:281Fr	RAM:2843r
; ---------------------------------------------------------------------------

loc_282A:				; DATA XREF: RAM:28D6o
		ld	b, a
		cpl
		ld	c, a
		ld	a, (_PeroOnOff)
		or	a
		jp	nz, loc_2838
		xor	a
		ld	c, 0FFh
		ret
; ---------------------------------------------------------------------------

loc_2838:				; CODE XREF: RAM:2831j
		ld	a, (byte_FFC6)
		and	b
		ret
; ---------------------------------------------------------------------------

loc_283D:				; CODE XREF: RAM:280Dj
		ld	hl, byte_DF18
		ld	(word_FFC9), hl
		ld	a, (unk_2829)
		ld	(word_FFD1), a
		jp	loc_2887

; =============== S U B	R O U T	I N E =======================================


sub_284C:				; CODE XREF: sub_2EDE+Ap
					; DATA XREF: RAM:28C8o
		add	hl, hl
		ld	b, a
		and	0Fh
		ex	de, hl
		jp	z, loc_2858
		inc	de
		jp	loc_285F
; ---------------------------------------------------------------------------

loc_2858:				; CODE XREF: sub_284C+5j
		ld	a, b
		and	0F0h ; ''
		rrca
		rrca
		rrca
		rrca

loc_285F:				; CODE XREF: sub_284C+9j
		ld	hl, unk_27E2
		add	a, l
		ld	l, a
		ld	a, (_PeroOnOff)
		push	af
		ld	c, a
		ld	a, (hl)
		ld	b, a
		and	c
		cpl
		ld	c, a
		ld	a, (byte_FFC6)
		and	b
		ex	de, hl
		ld	d, a
		ld	a, 0C0h	; ''
		or	h
		ld	h, a
		pop	af
		and	d
		ret
; End of function sub_284C

; ---------------------------------------------------------------------------

loc_287B:				; CODE XREF: RAM:2809j
		ld	hl, byte_FE30
		ld	(word_FFC9), hl
		ld	hl, (unk_2828)
		ld	(word_FFD1), hl

loc_2887:				; CODE XREF: RAM:2825j	RAM:2849j
		ld	a, 0CDh	; ''
		ld	(byte_FFD4), a
		ld	a, 0C3h	; ''
		ld	(byte_FFD8), a
		ld	(byte_FFDB), a
		ld	a, 0C9h	; ''
		ld	(byte_FFD7), a
		ld	a, (_ConOut_Mode)
		and	1Fh
		ld	hl, 13Fh
		cp	1
		jp	nz, loc_28A9
		ld	hl, 27Fh

loc_28A9:				; CODE XREF: RAM:28A3j
		ld	(word_FFCF), hl
		ld	hl, 0C000h
		cp	10h
		jp	nz, loc_28B6
		ld	h, 0E0h	; ''

loc_28B6:				; CODE XREF: RAM:28B1j
		ld	(word_FFC7), hl
		xor	a
		ld	b, a
		call	sub_2AD6
		ld	a, 0FFh
		ld	(_PeroOnOff), a
		ld	a, (_ConOut_Mode)
		and	1Fh
		ld	hl, sub_284C
		ld	de, loc_2BDB
		ld	bc, loc_2DBE
		cp	2
		jp	z, loc_28DF
		ld	hl, loc_282A
		ld	de, loc_2B9A
		ld	bc, loc_2F47

loc_28DF:				; CODE XREF: RAM:28D3j
		ld	(word_FFD5), hl
		ex	de, hl
		ld	(word_FFD9), hl
		ld	h, b
		ld	l, c
		ld	(word_FFDC), hl
		ret

; =============== S U B	R O U T	I N E =======================================


sub_28EC:				; CODE XREF: _G_P_PSET_HLDEp
					; RAM:_LINE_HLDEp
		push	de
		ex	de, hl
		ld	hl, (word_FFCF)
		call	sub_317C
		ld	b, 0
		jp	nc, loc_28FC
		ld	b, 1
		ex	de, hl

loc_28FC:				; CODE XREF: sub_28EC+Aj
		ex	de, hl
		pop	de
		push	hl
		ld	hl, 0C7h ; ''
		call	sub_317C
		ld	c, 0
		jp	nc, loc_290D
		ld	c, 1
		ex	de, hl

loc_290D:				; CODE XREF: sub_28EC+1Bj
		pop	hl
		ld	a, b
		or	a
		jp	nz, loc_2919
		ld	a, c
		or	a
		jp	nz, loc_2919
		ret
; ---------------------------------------------------------------------------

loc_2919:				; CODE XREF: sub_28EC+24j sub_28EC+29j
		pop	hl
		ret
; End of function sub_28EC


; =============== S U B	R O U T	I N E =======================================


_G_P_PSET_HLDE:				; CODE XREF: RAM:2798j	RAM:2B35p ...
		call	sub_28EC
		ld	(word_FF8C), hl
		ex	de, hl
		ld	(word_FF8E), hl
		add	hl, hl
		add	hl, hl
		add	hl, hl
		ld	b, h
		ld	c, l
		add	hl, hl
		add	hl, hl
		add	hl, bc
		call	word_FFD1
		ex	de, hl
		ld	hl, (word_FF8C)
		add	hl, hl
		add	hl, hl
		add	hl, hl
		add	hl, hl
		add	hl, hl
		ld	c, h
		ld	b, 0
		add	hl, hl
		add	hl, hl
		add	hl, hl
		ld	(word_FF92), hl
		ld	hl, 0
		add	hl, de
		add	hl, bc
		ex	de, hl
		ld	hl, (word_FFC7)
		add	hl, de
		ld	(word_FF90), hl
		ld	de, 27EBh
		ld	a, (word_FF92+1)
		and	7
		add	a, e
		ld	e, a
		ld	a, (de)
		ld	(word_FF92), a
		call	byte_FFD4
		ld	b, a
		ld	a, (hl)
		and	c
		or	b
		ld	(hl), a
		ret
; End of function _G_P_PSET_HLDE

; ---------------------------------------------------------------------------

_LINE_HLDE:				; CODE XREF: RAM:279Bj	RAM:3694j ...
		call	sub_28EC
		ld	(word_FF94), hl
		ex	de, hl
		ld	(word_FF96), hl
		ld	hl, (word_FF8C)
		ld	a, e
		sub	l
		ld	l, a
		ld	a, d
		sbc	a, h
		ld	h, a
		ld	a, 1
		jp	p, loc_2987
		xor	a
		sub	l
		ld	l, a
		ld	a, 0
		sbc	a, h
		ld	h, a
		ld	a, 0FFh

loc_2987:				; CODE XREF: RAM:297Bj
		ld	(byte_FF8A), a
		ld	(byte_FF8B), a
		ld	(word_FF84), hl
		ld	hl, (word_FF8E)
		ld	a, (word_FF96)
		sub	l
		ld	l, a
		ld	a, 0
		sbc	a, h
		ld	h, a
		ld	(word_FF86), hl
		push	af
		call	sub_2AD6
		pop	af
		jp	p, loc_29B6
		xor	a
		ld	(word_FF86+1), a
		ld	a, (word_FF86)
		cpl
		inc	a
		ld	(word_FF86), a
		ld	d, 0FFh
		ex	de, hl

loc_29B6:				; CODE XREF: RAM:29A4j
		ld	(word_FF88), hl
		ld	hl, (word_FF94)
		ld	(word_FF8C), hl
		ld	a, (word_FF96)
		ld	(word_FF8E), a
		ld	hl, (word_FF84)
		ld	a, (word_FF86)
		add	a, h
		adc	a, l
		adc	a, 0
		jp	z, sub_2AD6
		ld	(word_FF9C), hl
		ld	(word_FF98), hl
		ld	hl, (word_FF86)
		ld	(word_FF9E), hl
		ld	(word_FF9A), hl
		ld	hl, (word_FF86)
		ld	a, (word_FF84)
		sub	l
		ld	l, a
		ld	a, (word_FF84+1)
		sbc	a, h
		jp	p, loc_29F3
		jp	loc_2A66
; ---------------------------------------------------------------------------

loc_29F3:				; CODE XREF: RAM:29EDj
		ld	hl, (word_FF86)
		inc	hl
		ld	(word_FF86), hl

loc_29FA:				; CODE XREF: RAM:2A63j
		ld	a, (byte_FF8A)
		or	a
		ld	a, (word_FF92)
		jp	m, loc_2A0F
		rrca
		jp	nc, loc_2A1A
		ld	hl, (word_FF90)
		inc	hl
		jp	loc_2A17
; ---------------------------------------------------------------------------

loc_2A0F:				; CODE XREF: RAM:2A01j
		rlca
		jp	nc, loc_2A1A
		ld	hl, (word_FF90)
		dec	hl

loc_2A17:				; CODE XREF: RAM:2A0Cj
		ld	(word_FF90), hl

loc_2A1A:				; CODE XREF: RAM:2A05j	RAM:2A10j
		ld	(word_FF92), a
		ld	hl, (word_FF86)
		ld	a, (word_FF9C)
		sub	l
		ld	(word_FF9C), a
		ld	a, (word_FF9C+1)
		sbc	a, h
		ld	(word_FF9C+1), a
		jp	p, loc_2A47
		ld	hl, (word_FF84)
		ex	de, hl
		ld	hl, (word_FF9C)
		add	hl, de
		ld	(word_FF9C), hl
		ld	hl, (word_FF88)
		ex	de, hl
		ld	hl, (word_FF90)
		add	hl, de
		ld	(word_FF90), hl

loc_2A47:				; CODE XREF: RAM:2A2Ej
		ld	hl, (word_FF90)
		ld	a, (word_FF92)
		call	byte_FFD4
		ld	b, a
		ld	a, (hl)
		and	c
		or	b
		ld	(hl), a
		ld	hl, (word_FF98)
		dec	hl
		ld	(word_FF98), hl
		ld	a, h
		add	a, l
		adc	a, 0
		jp	z, sub_2AD6
		jp	loc_29FA
; ---------------------------------------------------------------------------

loc_2A66:				; CODE XREF: RAM:29F0j
		ld	hl, (word_FF84)
		inc	hl
		ld	(word_FF84), hl

loc_2A6D:				; CODE XREF: RAM:2AD3j
		ld	hl, (word_FF88)
		ex	de, hl
		ld	hl, (word_FF90)
		add	hl, de
		ld	(word_FF90), hl
		ld	hl, (word_FF84)
		ld	a, (word_FF9E)
		sub	l
		ld	(word_FF9E), a
		ld	a, (word_FF9E+1)
		sbc	a, h
		ld	(word_FF9E+1), a
		jp	p, loc_2ABA
		ld	hl, (word_FF86)
		ex	de, hl
		ld	hl, (word_FF9E)
		add	hl, de
		ld	(word_FF9E), hl
		ld	a, (byte_FF8A)
		or	a
		ld	a, (word_FF92)
		jp	m, loc_2AAC
		rrca
		jp	nc, loc_2AB7
		ld	hl, (word_FF90)
		inc	hl
		jp	loc_2AB4
; ---------------------------------------------------------------------------

loc_2AAC:				; CODE XREF: RAM:2A9Ej
		rlca
		jp	nc, loc_2AB7
		ld	hl, (word_FF90)
		dec	hl

loc_2AB4:				; CODE XREF: RAM:2AA9j
		ld	(word_FF90), hl

loc_2AB7:				; CODE XREF: RAM:2AA2j	RAM:2AADj
		ld	(word_FF92), a

loc_2ABA:				; CODE XREF: RAM:2A89j
		ld	a, (word_FF92)
		ld	hl, (word_FF90)
		call	byte_FFD4
		ld	b, a
		ld	a, (hl)
		and	c
		or	b
		ld	(hl), a
		ld	hl, (word_FF9A)
		dec	hl
		ld	(word_FF9A), hl
		ld	a, h
		add	a, l
		adc	a, 0
		jp	nz, loc_2A6D

; =============== S U B	R O U T	I N E =======================================


sub_2AD6:				; CODE XREF: RAM:28BBp	RAM:29A0p ...
		ld	hl, byte_D828
		ld	a, (_ConOut_Mode)
		and	1Fh
		cp	1
		jp	nz, loc_2AE4
		add	hl, hl

loc_2AE4:				; CODE XREF: sub_2AD6+Aj
		ld	e, h
		xor	a
		ld	d, a
		ld	h, a
		ld	(word_FF88), hl
		ret
; End of function sub_2AD6

; ---------------------------------------------------------------------------

_PAINT_HLDEA:				; CODE XREF: RAM:27A1j	RAM:368Dj
		and	3
		ld	(word_FFC4), a
		ld	(word_FF94), hl
		ex	de, hl
		ld	(word_FF96), hl
		ex	de, hl
		di
		ld	hl, 0
		add	hl, sp
		ld	(SSTACK), hl
		ld	hl, (CSTACK)
		ld	sp, hl
		ld	a, (_ConOut_Mode)
		and	1Fh
		dec	a
		dec	a
		jp	nz, loc_2B22
		ld	a, (word_FFC4)
		ld	b, a
		rlca
		rlca
		or	b
		rlca
		rlca
		or	b
		rlca
		rlca
		or	b
		ld	(word_FFB2), a
		jp	loc_2B2E
; ---------------------------------------------------------------------------

loc_2B22:				; CODE XREF: RAM:2B0Cj
		ld	a, (word_FFC4)
		or	a
		jp	z, loc_2B2B
		ld	a, 0FFh

loc_2B2B:				; CODE XREF: RAM:2B26j
		ld	(word_FFB2), a

loc_2B2E:				; CODE XREF: RAM:2B1Fj
		ld	hl, (word_FF96)
		ex	de, hl
		ld	hl, (word_FF94)
		call	_G_P_PSET_HLDE
		ld	h, 0FFh
		ld	a, h
		ld	(_PeroOnOff), a
		ld	l, h
		push	hl
		push	hl
		ld	hl, (word_FF94)
		add	hl, hl
		add	hl, hl
		add	hl, hl
		add	hl, hl
		add	hl, hl
		ld	a, (word_FF92)
		ld	l, h
		ld	h, a
		ex	de, hl
		ld	hl, (word_FF90)
		ld	a, l
		sub	e
		ld	l, a
		ld	a, h
		sbc	a, 0
		ld	h, a
		push	hl
		push	de
		ld	(word_FF90), hl
		xor	a
		ld	(word_FF94+1), a
		ld	a, e
		ld	(word_FF94), a

loc_2B66:				; CODE XREF: RAM:2B88j
		pop	hl
		ld	a, h
		ld	(word_FF92), a
		ld	a, l
		ld	(word_FF94), a
		pop	hl
		ld	(word_FF90), hl
		cp	0FFh
		jp	z, loc_2B8B
		call	byte_FFD8
		xor	a
		ld	(byte_FFC1), a
		ld	(byte_FFC0), a
		call	byte_FFDB
		call	sub_2C83
		jp	loc_2B66
; ---------------------------------------------------------------------------

loc_2B8B:				; CODE XREF: RAM:2B75j
		ld	hl, (SSTACK)
		ld	sp, hl
		ld	hl, (word_FF8E)
		ex	de, hl
		ld	hl, (word_FF8C)
		ei
		jp	_G_P_PSET_HLDE
; ---------------------------------------------------------------------------

loc_2B9A:				; CODE XREF: RAM:2BD3j
					; DATA XREF: RAM:28D9o
		ld	a, (word_FF94)
		ld	b, a
		ld	a, (word_FF88)
		dec	a
		cp	b
		ld	a, (word_FF92)
		jp	nz, loc_2BAC
		cp	1
		ret	z

loc_2BAC:				; CODE XREF: RAM:2BA6j
		rrca
		ld	hl, (word_FF94)
		jp	nc, loc_2BB4
		inc	hl

loc_2BB4:				; CODE XREF: RAM:2BB0j
		ld	b, a
		ex	de, hl
		ld	hl, (word_FF90)
		add	hl, de
		ld	a, (hl)
		and	b
		push	af
		ld	a, (word_FFC4)
		or	a
		jp	z, loc_2BC9
		pop	af
		ret	nz
		jp	loc_2BCB
; ---------------------------------------------------------------------------

loc_2BC9:				; CODE XREF: RAM:2BC1j
		pop	af
		ret	z

loc_2BCB:				; CODE XREF: RAM:2BC6j
		ex	de, hl
		ld	(word_FF94), hl
		ld	a, b
		ld	(word_FF92), a
		jp	loc_2B9A
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_2C15

loc_2BD6:				; CODE XREF: sub_2C15+44j sub_2C15+4Ej ...
		ld	hl, (word_FF9E)
		push	hl
		ret
; END OF FUNCTION CHUNK	FOR sub_2C15
; ---------------------------------------------------------------------------

loc_2BDB:				; CODE XREF: RAM:2C12j
					; DATA XREF: RAM:28CBo
		ld	a, (word_FF94)
		ld	b, a
		ld	a, (word_FF88)
		dec	a
		cp	b
		ld	a, (word_FF92)
		jp	nz, loc_2BED
		cp	1
		ret	z

loc_2BED:				; CODE XREF: RAM:2BE7j
		rrca
		ld	hl, (word_FF94)
		jp	nc, loc_2BF5
		inc	hl

loc_2BF5:				; CODE XREF: RAM:2BF1j
		push	af
		ex	de, hl
		ld	hl, (word_FF90)
		add	hl, de
		push	de
		call	sub_2EDE
		call	sub_2EF2
		pop	de
		ld	c, a
		ld	a, (word_FFC4)
		cp	c
		pop	bc
		ret	z
		ld	a, b
		ex	de, hl
		ld	(word_FF94), hl
		ld	(word_FF92), a
		jp	loc_2BDB

; =============== S U B	R O U T	I N E =======================================


sub_2C15:				; CODE XREF: sub_2C83+4p

; FUNCTION CHUNK AT 2BD6 SIZE 00000005 BYTES

		pop	hl
		ld	(word_FF9E), hl
		ld	hl, (word_FFC7)
		ex	de, hl
		ld	hl, (word_FF90)
		call	sub_317C
		jp	z, loc_2C5C
		ld	a, (byte_FFBA)
		ld	hl, (word_FFC4)
		cp	h
		jp	z, loc_2C4F
		cp	l
		jp	z, loc_2C4F
		ld	hl, 0FFC0h
		ld	(hl), 1
		ld	hl, (word_FF88)
		ex	de, hl
		ld	hl, (word_FF90)
		ld	a, l
		sub	e
		ld	l, a
		ld	a, h
		sbc	a, d
		ld	h, a
		push	hl
		ld	hl, (word_FF94)
		ld	a, (word_FF92)
		ld	h, a
		push	hl

loc_2C4F:				; CODE XREF: sub_2C15+18j sub_2C15+1Cj
		ld	hl, (word_FFC9)
		ex	de, hl
		ld	hl, (word_FF90)
		call	sub_317C
		jp	z, loc_2BD6

loc_2C5C:				; CODE XREF: sub_2C15+Ej
		ld	a, (byte_FFBB)
		ld	hl, (word_FFC4)
		cp	h
		jp	z, loc_2BD6
		cp	l
		jp	z, loc_2BD6
		ld	hl, 0FFC1h
		ld	(hl), 1
		ld	hl, (word_FF88)
		ex	de, hl
		ld	hl, (word_FF90)
		add	hl, de
		push	hl
		ld	hl, (word_FF94)
		ld	a, (word_FF92)
		ld	h, a
		push	hl
		jp	loc_2BD6
; End of function sub_2C15


; =============== S U B	R O U T	I N E =======================================


sub_2C83:				; CODE XREF: RAM:2B85p
		pop	hl
		ld	(word_FF9C), hl
		call	sub_2C15

loc_2C8A:				; CODE XREF: sub_2C83+138j
		ld	a, (word_FF94)
		or	a
		jp	nz, loc_2C99
		ld	a, (word_FF92)
		cp	80h ; ''
		jp	z, loc_2CFF

loc_2C99:				; CODE XREF: sub_2C83+Bj
		ld	hl, (word_FFC7)
		ex	de, hl
		ld	hl, (word_FF90)
		call	sub_317C
		jp	z, loc_2CFF
		ld	a, (byte_FFBE)
		ld	hl, (word_FFC4)
		cp	l
		jp	z, loc_2CFF
		ld	a, (byte_FFC0)
		dec	a
		jp	z, loc_2CBE
		ld	a, (byte_FFBA)
		cp	h
		jp	z, loc_2CD1

loc_2CBE:				; CODE XREF: sub_2C83+31j
		ld	a, (byte_FFBA)
		cp	l
		jp	nz, loc_2CFF
		ld	a, (byte_FFC0)
		or	a
		jp	z, loc_2CD1
		ld	a, h
		cp	l
		jp	nz, loc_2CD8

loc_2CD1:				; CODE XREF: sub_2C83+38j sub_2C83+46j
		ld	a, (byte_FFBD)
		cp	h
		jp	z, loc_2CFF

loc_2CD8:				; CODE XREF: sub_2C83+4Bj
		ld	a, (byte_FFBD)
		cp	l
		jp	z, loc_2CFF
		ld	hl, 0FFC0h
		ld	(hl), 1
		ld	hl, (word_FF88)
		ex	de, hl
		ld	hl, (word_FF90)
		ld	a, l
		sub	e
		ld	l, a
		ld	a, h
		sbc	a, d
		ld	h, a
		push	hl
		ld	hl, (word_FF94)
		ld	a, (word_FF92)
		rlca
		jp	nc, loc_2CFD
		dec	hl

loc_2CFD:				; CODE XREF: sub_2C83+76j
		ld	h, a
		push	hl

loc_2CFF:				; CODE XREF: sub_2C83+13j sub_2C83+20j ...
		ld	a, (word_FF94)
		or	a
		jp	nz, byte_D20E
		ld	a, (word_FF92)
		cp	80h ; ''
		jp	z, loc_2D6F
		ld	hl, (word_FFC9)
		ex	de, hl
		ld	hl, (word_FF90)
		call	sub_317C
		jp	z, loc_2D6F
		ld	a, (byte_FFBE)
		ld	hl, (word_FFC4)
		cp	l
		jp	z, loc_2D6F
		ld	a, (byte_FFC1)
		dec	a
		jp	z, loc_2D33
		ld	a, (byte_FFBB)
		cp	h
		jp	z, loc_2D46

loc_2D33:				; CODE XREF: sub_2C83+A6j
		ld	a, (byte_FFBB)
		cp	l
		jp	nz, loc_2D6F
		ld	a, (byte_FFC1)
		or	a
		jp	z, loc_2D46
		ld	h, a
		cp	l
		jp	nz, loc_2D4D

loc_2D46:				; CODE XREF: sub_2C83+ADj sub_2C83+BBj
		ld	a, (byte_FFBF)
		cp	h
		jp	z, loc_2D6F

loc_2D4D:				; CODE XREF: sub_2C83+C0j
		ld	a, (byte_FFBF)
		cp	l
		jp	z, loc_2D6F
		ld	hl, 0FFC1h
		ld	(hl), 1
		ld	hl, (word_FF90)
		ex	de, hl
		ld	hl, (word_FF88)
		add	hl, de
		ld	a, (word_FF92)
		rlca
		push	hl
		ld	hl, (word_FF94)
		jp	nc, loc_2D6D
		dec	hl

loc_2D6D:				; CODE XREF: sub_2C83+E6j
		ld	h, a
		push	hl

loc_2D6F:				; CODE XREF: sub_2C83+88j sub_2C83+95j ...
		ld	hl, (word_FF90)
		ld	a, (word_FF94)
		add	a, l
		ld	l, a
		ld	a, 0
		adc	a, h
		ld	h, a
		ld	a, (word_FF92)
		call	byte_FFD4
		ld	b, a
		ld	a, (hl)
		and	c
		or	b
		ld	(hl), a
		ld	a, (byte_FFBE)
		ld	hl, (word_FFC4)
		cp	l
		jp	z, loc_2DA2
		ld	a, (word_FF94)
		or	a
		jp	nz, loc_2DA7
		ld	a, (word_FF92)
		cp	80h ; ''
		jp	z, loc_2DA2
		jp	loc_2DA7
; ---------------------------------------------------------------------------

loc_2DA2:				; CODE XREF: sub_2C83+10Aj
					; sub_2C83+119j
		ld	hl, (word_FF9C)
		push	hl
		ret
; ---------------------------------------------------------------------------

loc_2DA7:				; CODE XREF: sub_2C83+111j
					; sub_2C83+11Cj
		ld	hl, (word_FF94)
		ld	a, (word_FF92)
		rlca
		jp	nc, loc_2DB2
		dec	hl

loc_2DB2:				; CODE XREF: sub_2C83+12Bj
		ld	(word_FF94), hl
		ld	(word_FF92), a
		call	byte_FFDB
		jp	loc_2C8A
; End of function sub_2C83

; ---------------------------------------------------------------------------

loc_2DBE:				; DATA XREF: RAM:28CEo
		ld	hl, (word_FF90)
		push	hl
		ex	de, hl
		ld	hl, (word_FF94)
		add	hl, de
		ld	a, (word_FF94)
		or	a
		ld	a, (word_FF92)
		jp	z, loc_2E8B
		cp	80h ; ''
		jp	nz, loc_2E8B
		call	sub_2EDE
		ld	a, (word_FF94)
		add	a, a
		ld	(word_FF94), a
		ld	a, (hl)
		and	3Fh ; '?'
		ld	b, a
		ld	a, (byte_FFC6)
		and	0C0h ; ''
		or	b
		ld	(hl), a

loc_2DEB:				; CODE XREF: RAM:2E59j
		ld	a, l
		sub	50h ; 'P'
		ld	l, a
		ld	a, h
		sbc	a, 0
		ld	h, a
		call	sub_2F04
		jp	nz, loc_2E71
		xor	c
		jp	nz, loc_2E71
		ld	a, (hl)
		ld	(byte_FFBA), a
		dec	hl
		push	bc
		call	sub_2F04
		ld	a, c
		pop	bc
		jp	nz, loc_2E71
		xor	c
		jp	nz, loc_2E71
		ld	a, (byte_FFBA)
		cp	(hl)
		jp	nz, loc_2E71
		ld	de, 50h	; 'P'
		add	hl, de
		ld	(word_FFB0), hl
		call	sub_2F22
		jp	nz, loc_2E71
		xor	c
		jp	nz, loc_2E71
		add	hl, de
		call	sub_2F04
		jp	nz, loc_2E71
		xor	c
		jp	nz, loc_2E71
		ld	a, (hl)
		ld	(byte_FFBA), a
		push	bc
		inc	hl
		call	sub_2F04
		ld	a, c
		pop	bc
		jp	nz, loc_2E71
		xor	c
		jp	nz, loc_2E71
		ld	a, (byte_FFBA)
		cp	(hl)
		jp	nz, loc_2E71
		ld	hl, (word_FFB0)
		ld	a, (byte_FFC6)
		ld	(hl), a
		ld	a, (word_FF94)
		dec	a
		ld	(word_FF94), a
		jp	nz, loc_2DEB
		ld	a, (hl)
		and	0FCh ; ''
		ld	b, a
		ld	a, (byte_FFC6)
		and	3
		or	b
		ld	(hl), a
		pop	hl
		push	hl
		ld	a, 10h
		ld	(word_FF92), a
		jp	loc_2E83
; ---------------------------------------------------------------------------

loc_2E71:				; CODE XREF: RAM:2DF6j	RAM:2DFAj ...
		pop	hl
		push	hl
		ld	a, (word_FF94)
		scf
		ccf
		rra
		ld	(word_FF94), a
		ld	a, 8
		jp	c, loc_2E83
		ld	a, 80h ; ''

loc_2E83:				; CODE XREF: RAM:2E6Ej	RAM:2E7Ej
		ld	(word_FF92), a
		ex	de, hl
		ld	hl, (word_FF94)
		add	hl, de

loc_2E8B:				; CODE XREF: RAM:2DCEj	RAM:2DD3j
		call	sub_2EDE
		ld	a, c
		cpl
		ld	c, a
		ld	(word_FF90), hl
		rlca
		rlca
		jp	nc, loc_2E9A
		dec	hl

loc_2E9A:				; CODE XREF: RAM:2E96j
		ld	b, a
		call	sub_2EF2
		ld	(byte_FFBE), a
		ld	de, 50h	; 'P'
		add	hl, de
		ld	a, b
		call	sub_2EF2
		ld	(byte_FFBF), a
		ld	hl, (word_FF90)
		ld	a, l
		sub	50h ; 'P'
		ld	l, a
		ld	a, h
		sbc	a, 0
		ld	h, a
		ld	a, c
		call	sub_2EF2
		ld	(byte_FFBA), a
		ld	a, c
		rlca
		rlca
		jp	nc, loc_2EC5
		dec	hl

loc_2EC5:				; CODE XREF: RAM:2EC1j
		call	sub_2EF2
		ld	(byte_FFBD), a
		ld	hl, (word_FF90)
		ld	a, c
		ld	de, 50h	; 'P'
		add	hl, de
		call	sub_2EF2
		ld	(byte_FFBB), a
		pop	hl
		ld	(word_FF90), hl
		ret

; =============== S U B	R O U T	I N E =======================================


sub_2EDE:				; CODE XREF: RAM:2BFCp	RAM:2DD6p ...
		ld	b, a
		ld	de, 0FFC6h
		ld	a, (de)
		push	af
		ld	a, 0FFh
		ld	(de), a
		ld	a, b
		call	sub_284C
		ld	b, a
		pop	af
		ld	(byte_FFC6), a
		ld	a, b
		ret
; End of function sub_2EDE


; =============== S U B	R O U T	I N E =======================================


sub_2EF2:				; CODE XREF: RAM:2BFFp	RAM:2E9Bp ...
		ld	d, a
		and	(hl)

loc_2EF4:				; CODE XREF: sub_2EF2+Dj
		push	af
		ld	a, d
		rrca
		rrca
		jp	c, loc_2F02
		ld	d, a
		pop	af
		rrca
		rrca
		jp	loc_2EF4
; ---------------------------------------------------------------------------

loc_2F02:				; CODE XREF: sub_2EF2+6j
		pop	af
		ret
; End of function sub_2EF2


; =============== S U B	R O U T	I N E =======================================


sub_2F04:				; CODE XREF: RAM:2DF3p	RAM:2E03p ...
		call	sub_2F22
		ret	nz
		cp	c
		jp	z, loc_2F1A
		push	hl
		ld	hl, (word_FFC4)
		ld	a, h
		cp	l
		jp	nz, loc_2F17
		ld	c, 0

loc_2F17:				; CODE XREF: sub_2F04+Ej
		pop	hl
		xor	a
		ret
; ---------------------------------------------------------------------------

loc_2F1A:				; CODE XREF: sub_2F04+5j
		ld	a, (byte_FFC6)
		xor	(hl)
		ld	b, a
		jp	loc_2F31
; End of function sub_2F04


; =============== S U B	R O U T	I N E =======================================


sub_2F22:				; CODE XREF: RAM:2E1Dp	sub_2F04p
		ld	a, (word_FFB2)
		ld	b, a
		xor	(hl)
		ld	c, 1
		ret	z
		cp	b
		ld	b, a
		ld	a, 0
		ld	c, 0
		ret	z

loc_2F31:				; CODE XREF: sub_2F04+1Bj
		ld	a, (byte_FFC6)
		cp	(hl)
		ld	a, 0
		ret	z
		ld	a, b
		and	55h ; 'U'
		rlca
		ld	c, a
		ld	a, b
		and	0AAh ; ''
		rrca
		or	c
		or	b
		inc	a
		ld	c, 0
		ret
; End of function sub_2F22

; ---------------------------------------------------------------------------

loc_2F47:				; DATA XREF: RAM:28DCo
		ld	hl, (word_FF90)
		push	hl
		ld	a, (word_FF94)
		add	a, l
		ld	l, a
		ld	a, 0
		adc	a, h
		ld	h, a
		ld	(word_FF90), hl
		ld	a, (word_FF94)
		or	a
		ld	a, (word_FF92)
		jp	z, loc_2FD5
		cp	80h ; ''
		jp	nz, loc_2FD5
		ld	a, (hl)
		and	7Fh ; ''
		ld	b, a
		ld	a, (byte_FFC6)
		and	80h ; ''
		or	b
		ld	(hl), a

loc_2F71:				; CODE XREF: RAM:2FC2j
		ld	a, (word_FF88)
		ld	b, a
		ld	a, l
		sub	b
		ld	l, a
		ld	a, h
		sbc	a, 0
		ld	h, a
		call	sub_302F
		jp	nz, loc_2FCA
		dec	hl
		push	bc
		call	sub_302F
		ld	a, c
		pop	bc
		jp	nz, loc_2FCA
		xor	c
		jp	nz, loc_2FCA
		ex	de, hl
		ld	hl, (word_FF88)
		ex	de, hl
		add	hl, de
		ld	(word_FFB0), hl
		call	sub_302F
		jp	nz, loc_2FCA
		add	hl, de
		call	sub_302F
		jp	nz, loc_2FCA
		push	bc
		inc	hl
		call	sub_302F
		ld	a, c
		pop	bc
		jp	nz, loc_2FCA
		xor	c
		jp	nz, loc_2FCA
		ld	hl, (word_FFB0)
		ld	a, (byte_FFC6)
		ld	(hl), a
		ld	a, (word_FF94)
		dec	a
		ld	(word_FF94), a
		jp	nz, loc_2F71
		ld	a, 1
		ld	(word_FF94), a

loc_2FCA:				; CODE XREF: RAM:2F7Fj	RAM:2F89j ...
		ld	a, 80h ; ''
		ld	(word_FF92), a
		pop	de
		push	de
		ld	hl, (word_FF94)
		add	hl, de

loc_2FD5:				; CODE XREF: RAM:2F5Ej	RAM:2F63j
		ld	(word_FF90), hl
		rlca
		jp	nc, loc_2FDD
		dec	hl

loc_2FDD:				; CODE XREF: RAM:2FD9j
		ld	b, a
		call	sub_302A
		ld	(byte_FFBE), a
		ex	de, hl
		ld	hl, (word_FF88)
		add	hl, de
		ld	a, b
		call	sub_302A
		ld	(byte_FFBF), a
		ld	hl, (word_FF90)
		ex	de, hl
		ld	hl, (word_FF88)
		ld	a, e
		sub	l
		ld	l, a
		ld	a, d
		sbc	a, h
		ld	h, a
		ld	a, (word_FF92)
		call	sub_302A
		ld	(byte_FFBA), a
		ld	a, (word_FF92)
		rlca
		jp	nc, loc_300E
		dec	hl

loc_300E:				; CODE XREF: RAM:300Aj
		call	sub_302A
		ld	(byte_FFBD), a
		ld	hl, (word_FF90)
		ld	a, (word_FF92)
		ex	de, hl
		ld	hl, (word_FF88)
		add	hl, de
		call	sub_302A
		ld	(byte_FFBB), a
		pop	hl
		ld	(word_FF90), hl
		ret

; =============== S U B	R O U T	I N E =======================================


sub_302A:				; CODE XREF: RAM:2FDEp	RAM:2FEAp ...
		and	(hl)
		ret	z
		ld	a, 1
		ret
; End of function sub_302A


; =============== S U B	R O U T	I N E =======================================


sub_302F:				; CODE XREF: RAM:2F7Cp	RAM:2F84p ...
		ld	a, (word_FFB2)
		ld	b, a
		xor	(hl)
		ld	c, 1
		ret	z
		cp	b
		ld	c, 0
		ret	z
		inc	a
		ld	c, 0
		ret
; End of function sub_302F

; ---------------------------------------------------------------------------

_CIRCLE_HLDEA:				; CODE XREF: RAM:279Ej	RAM:36A4j
		ld	(word_FFA8), a
		ld	(word_FFAA), hl
		ex	de, hl
		ld	(word_FFAC), hl
		ld	bc, 0FF8Ch
		ld	de, 0FFDFh
		ld	h, 8
		call	_LdirBCtoDE_H
		call	sub_3182
		xor	a
		ld	l, a
		ld	h, a
		ld	(word_FF94), hl
		ld	hl, (word_FFA8)
		ld	(word_FF96), hl
		ld	b, a
		ld	c, a
		add	hl, hl
		ld	a, 3
		sub	l
		ld	l, a
		ld	a, 0
		sbc	a, h
		ld	h, a
		ex	de, hl
		ld	hl, (word_FF96)

loc_3072:				; CODE XREF: RAM:30B0j
		push	bc
		push	de
		push	hl
		call	sub_30BE
		pop	hl
		pop	de
		pop	bc
		xor	a
		or	d
		jp	m, loc_3098
		push	hl
		ld	a, c
		sub	l
		ld	l, a
		ld	a, b
		sbc	a, h
		ld	h, a
		add	hl, hl
		add	hl, hl
		add	hl, de
		ld	a, l
		add	a, 0Ah
		ld	l, a
		ld	a, 0
		adc	a, h
		ld	h, a
		pop	de
		ex	de, hl
		dec	hl
		jp	loc_30AB
; ---------------------------------------------------------------------------

loc_3098:				; CODE XREF: RAM:307Dj
		push	hl
		xor	a
		ld	h, a
		ld	l, a
		add	hl, bc
		add	hl, bc
		add	hl, bc
		add	hl, bc
		ld	a, 6
		add	a, l
		ld	l, a
		ld	a, 0
		adc	a, h
		ld	h, a
		add	hl, de
		pop	de
		ex	de, hl

loc_30AB:				; CODE XREF: RAM:3095j
		inc	bc
		ld	a, l
		sub	c
		ld	a, h
		sbc	a, b
		jp	p, loc_3072
		ld	bc, 0FFDFh
		ld	de, 0FF8Ch
		ld	h, 8
		jp	_LdirBCtoDE_H

; =============== S U B	R O U T	I N E =======================================


sub_30BE:				; CODE XREF: RAM:3075p
		ld	a, (byte_FFBB)
		ex	de, hl
		ld	hl, 3365h
		call	_Call_to_JmpTbl??
		push	bc
		ex	(sp), hl
		pop	bc
		ld	a, (byte_FFBA)
		ex	de, hl
		ld	hl, loc_3312
		call	_Call_to_JmpTbl??
		push	hl
		xor	a
		sub	l
		ld	l, a
		ld	a, 0
		sbc	a, h
		ld	h, a
		ld	a, (byte_FFC1)
		ex	de, hl
		ld	hl, loc_3312
		call	_Call_to_JmpTbl??
		push	bc
		ex	(sp), hl
		pop	bc
		ld	a, (byte_FFBC)
		ex	de, hl
		ld	hl, loc_3365
		call	_Call_to_JmpTbl??
		xor	a
		sub	l
		ld	l, a
		ld	a, 0
		sbc	a, h
		ld	h, a
		ld	a, (byte_FFBF)
		ex	de, hl
		ld	hl, loc_3418
		call	_Call_to_JmpTbl??
		push	bc
		ex	(sp), hl
		pop	bc
		ld	a, (byte_FFBE)
		ex	de, hl
		ld	hl, loc_33C5
		call	_Call_to_JmpTbl??
		pop	hl
		ld	a, (byte_FFBD)
		ex	de, hl
		ld	hl, loc_33C5
		call	_Call_to_JmpTbl??
		push	bc
		ex	(sp), hl
		pop	bc
		ld	a, (byte_FFC0)
		ex	de, hl
		ld	hl, loc_3418
; End of function sub_30BE


; =============== S U B	R O U T	I N E =======================================


_Call_to_JmpTbl??:			; CODE XREF: sub_30BE+7p sub_30BE+14p	...
		or	a
		jp	nz, loc_312D
		ex	de, hl
		ret
; ---------------------------------------------------------------------------

loc_312D:				; CODE XREF: _Call_to_JmpTbl??+1j
		push	de
		dec	a
		ld	e, a
		ld	d, 0
		add	hl, de
		add	hl, de
		add	hl, de
		pop	de
		push	de
		push	bc
		push	hl
		ld	hl, loc_3140
		ex	(sp), hl
		push	hl
		ex	de, hl
		ret
; End of function _Call_to_JmpTbl??

; ---------------------------------------------------------------------------

loc_3140:				; DATA XREF: _Call_to_JmpTbl??+12o
		pop	bc
		pop	hl
		ret
; ---------------------------------------------------------------------------

loc_3143:				; CODE XREF: RAM:3318j	RAM:3329j ...
		push	bc
		ld	d, h
		ld	e, l
		ld	a, (_ConOut_Mode)
		rrca
		ld	a, (word_FFCD)
		jp	nc, loc_3158
		or	a
		jp	nz, loc_3156
		ld	a, 0FFh

loc_3156:				; CODE XREF: RAM:3151j
		or	a
		rra

loc_3158:				; CODE XREF: RAM:314Dj
		or	a
		jp	z, loc_3161
		call	sub_3490
		ld	e, d
		ld	d, c

loc_3161:				; CODE XREF: RAM:3159j
		ld	hl, (word_FFAC)
		add	hl, de
		ex	(sp), hl
		ld	d, h
		ld	e, l
		ld	a, (word_FFCB)
		or	a
		jp	z, loc_3174
		call	sub_3490
		ld	e, d
		ld	d, c

loc_3174:				; CODE XREF: RAM:316Cj
		ld	hl, (word_FFAA)
		add	hl, de
		pop	de
		jp	_G_P_PSET_HLDE

; =============== S U B	R O U T	I N E =======================================


sub_317C:				; CODE XREF: sub_28EC+5p sub_28EC+16p	...
		ld	a, h
		sub	d
		ret	nz
		ld	a, l
		sub	e
		ret
; End of function sub_317C


; =============== S U B	R O U T	I N E =======================================


sub_3182:				; CODE XREF: RAM:3054p	sub_3182+DDp

; FUNCTION CHUNK AT 3258 SIZE 00000028 BYTES

		ld	hl, (word_FFB6)
		ex	de, hl
		ld	hl, (word_FFB8)
		call	sub_317C
		jp	c, loc_3258
		jp	nz, loc_319D
		xor	a
		ld	b, 7
		ld	c, 3
		call	sub_347A
		jp	sub_3280
; ---------------------------------------------------------------------------

loc_319D:				; CODE XREF: sub_3182+Dj
		ld	a, (word_FFB6+1)
		ld	b, a
		ld	a, (word_FFB8+1)
		sub	b
		jp	nz, loc_31B4
		push	bc
		ld	b, 7
		ld	c, a
		call	sub_347A
		pop	af
		add	a, l
		ld	l, a
		ld	(hl), 4

loc_31B4:				; CODE XREF: sub_3182+23j
		ld	a, (word_FFB6+1)
		ld	b, a
		ld	a, (word_FFB8+1)
		dec	a
		sub	b
		jp	nz, loc_31C9
		ld	c, a
		ld	b, 7
		call	sub_347A
		jp	loc_320B
; ---------------------------------------------------------------------------

loc_31C9:				; CODE XREF: sub_3182+3Bj
		ld	a, (word_FFB8+1)
		dec	a
		ld	b, a
		ld	a, (word_FFB6+1)
		inc	a
		ld	c, 3
		call	sub_347A
		ld	a, (word_FFB6+1)
		or	a
		jp	nz, loc_31E6
		ld	a, 2
		ld	(byte_FFBA), a
		jp	loc_31F0
; ---------------------------------------------------------------------------

loc_31E6:				; CODE XREF: sub_3182+59j
		ld	a, (word_FFB6+1)
		dec	a
		ld	b, a
		xor	a
		ld	c, a
		call	sub_347A

loc_31F0:				; CODE XREF: sub_3182+61j
		ld	a, (word_FFB8+1)
		cp	7
		jp	nz, loc_3200
		ld	a, 1
		ld	(byte_FFC1), a
		jp	loc_320B
; ---------------------------------------------------------------------------

loc_3200:				; CODE XREF: sub_3182+73j
		ld	a, (word_FFB8+1)
		inc	a
		ld	b, 7
		ld	c, 0
		call	sub_347A

loc_320B:				; CODE XREF: sub_3182+44j sub_3182+7Bj
		ld	a, (word_FFB6+1)
		ld	hl, 0FFBAh
		or	a
		jp	z, loc_3223
		cp	5
		jp	nc, loc_3223
		ld	c, a
		ld	b, 0
		add	hl, bc
		ld	(hl), 1
		jp	loc_3229
; ---------------------------------------------------------------------------

loc_3223:				; CODE XREF: sub_3182+90j sub_3182+95j
		ld	c, a
		ld	b, 0
		add	hl, bc
		ld	(hl), 2

loc_3229:				; CODE XREF: sub_3182+9Ej
		ld	a, (word_FFB8+1)
		ld	hl, 0FFBAh
		or	a
		jp	z, loc_3241
		cp	5
		jp	nc, loc_3241
		ld	c, a
		ld	b, 0
		add	hl, bc
		ld	(hl), 2
		jp	loc_3247
; ---------------------------------------------------------------------------

loc_3241:				; CODE XREF: sub_3182+AEj sub_3182+B3j
		ld	c, a
		ld	b, 0
		add	hl, bc
		ld	(hl), 1

loc_3247:				; CODE XREF: sub_3182+BCj
		call	sub_3280
		ret
; End of function sub_3182


; =============== S U B	R O U T	I N E =======================================


sub_324B:				; CODE XREF: sub_3182+DAp sub_3182+E1p ...
		ld	hl, 0
		add	hl, sp
		ex	de, hl
		ld	sp, hl
		pop	hl
		pop	bc
		push	hl
		push	bc
		ex	de, hl
		ld	sp, hl
		ret
; End of function sub_324B

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_3182

loc_3258:				; CODE XREF: sub_3182+Aj
		ld	de, 0FFB6h
		push	de
		call	sub_324B
		call	sub_3182
		pop	de
		call	sub_324B
		ld	b, 8
		ld	hl, 0FFBAh

loc_326B:				; CODE XREF: sub_3182+F5j
		ld	c, (hl)
		ld	a, 3
		sub	c
		jp	p, loc_3274
		ld	a, 5

loc_3274:				; CODE XREF: sub_3182+EDj
		ld	(hl), a
		inc	hl
		dec	b
		jp	nz, loc_326B
		ld	de, 0FFB0h
		jp	sub_324B
; END OF FUNCTION CHUNK	FOR sub_3182

; =============== S U B	R O U T	I N E =======================================


sub_3280:				; CODE XREF: sub_3182+18j
					; sub_3182:loc_3247p
		ld	hl, (word_FFB8)
		push	hl
		ld	hl, (word_FFB6)
		ld	(word_FFB8), hl
		call	sub_3297
		ld	hl, (word_FFB2)
		ld	(word_FFB0), hl
		pop	hl
		ld	(word_FFB8), hl
; End of function sub_3280


; =============== S U B	R O U T	I N E =======================================


sub_3297:				; CODE XREF: sub_3280+Ap
		ld	hl, byte_34C2
		ld	a, (word_FFB8+1)
		or	a
		jp	z, loc_32C1
		dec	a
		jp	z, loc_32D4
		dec	a
		jp	z, loc_32BC
		dec	a
		jp	z, loc_32D4
		dec	a
		jp	z, loc_32BC
		dec	a
		jp	z, loc_32CF
		dec	a
		jp	z, loc_32C1
		jp	loc_32CF
; ---------------------------------------------------------------------------

loc_32BC:				; CODE XREF: sub_3297+Fj sub_3297+17j
		ld	b, 0FFh
		jp	loc_32C3
; ---------------------------------------------------------------------------

loc_32C1:				; CODE XREF: sub_3297+7j sub_3297+1Fj
		ld	b, 0

loc_32C3:				; CODE XREF: sub_3297+27j
		ld	a, (word_FFB8)
		cpl

loc_32C7:				; CODE XREF: sub_3297+42j
		ld	e, a
		ld	d, 0
		add	hl, de
		ld	a, (hl)
		jp	loc_32DC
; ---------------------------------------------------------------------------

loc_32CF:				; CODE XREF: sub_3297+1Bj sub_3297+22j
		ld	b, 0FFh
		jp	loc_32D6
; ---------------------------------------------------------------------------

loc_32D4:				; CODE XREF: sub_3297+Bj sub_3297+13j
		ld	b, 0

loc_32D6:				; CODE XREF: sub_3297+3Aj
		ld	a, (word_FFB8)
		jp	loc_32C7
; ---------------------------------------------------------------------------

loc_32DC:				; CODE XREF: sub_3297+35j
		ld	(word_FFB4), a
		xor	a
		ld	(word_FFB4+1), a
		ld	a, (word_FFB8)
		or	a
		jp	nz, loc_32F1
		ld	hl, (word_FFB4)
		inc	hl
		ld	(word_FFB4), hl

loc_32F1:				; CODE XREF: sub_3297+50j
		ld	a, b
		or	a
		jp	z, loc_3303
		ld	hl, (word_FFB4)
		xor	a
		sub	l
		ld	l, a
		ld	a, 0
		sbc	a, h
		ld	h, a
		ld	(word_FFB4), hl

loc_3303:				; CODE XREF: sub_3297+5Cj
		ld	hl, (word_FFB4)
		ld	a, (word_FFA8)
		call	sub_3490
		ld	h, c
		ld	l, d
		ld	(word_FFB2), hl
		ret
; End of function sub_3297

; ---------------------------------------------------------------------------

loc_3312:				; DATA XREF: sub_30BE+11o sub_30BE+23o
		jp	loc_3321
; ---------------------------------------------------------------------------
		jp	loc_332D
; ---------------------------------------------------------------------------
		jp	loc_3143
; ---------------------------------------------------------------------------
		jp	loc_3339
; ---------------------------------------------------------------------------
		jp	loc_334E
; ---------------------------------------------------------------------------

loc_3321:				; CODE XREF: RAM:loc_3312j
		ex	de, hl
		ld	hl, (word_FFB2)
		call	sub_317C
		ex	de, hl
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_332D:				; CODE XREF: RAM:3315j
		ex	de, hl
		ld	hl, (word_FFB0)
		ex	de, hl
		call	sub_317C
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_3339:				; CODE XREF: RAM:331Bj
		ex	de, hl
		ld	hl, (word_FFB0)
		ex	de, hl
		call	sub_317C
		ret	m
		ex	de, hl
		ld	hl, (word_FFB2)
		call	sub_317C
		ret	m
		ex	de, hl
		jp	loc_3143
; ---------------------------------------------------------------------------

loc_334E:				; CODE XREF: RAM:331Ej
		ex	de, hl
		ld	hl, (word_FFB0)
		ex	de, hl
		call	sub_317C
		jp	p, loc_3143
		ex	de, hl
		ld	hl, (word_FFB2)
		ex	de, hl
		call	sub_317C
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_3365:				; DATA XREF: sub_30BE+30o
		jp	loc_3374
; ---------------------------------------------------------------------------
		jp	loc_3382
; ---------------------------------------------------------------------------
		jp	loc_3143
; ---------------------------------------------------------------------------
		jp	loc_3391
; ---------------------------------------------------------------------------
		jp	loc_33A9
; ---------------------------------------------------------------------------

loc_3374:				; CODE XREF: RAM:loc_3365j
		ld	d, b
		ld	e, c
		push	hl
		ld	hl, (word_FFB0)
		call	sub_317C
		pop	hl
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_3382:				; CODE XREF: RAM:3368j
		push	hl
		ld	d, b
		ld	e, c
		ld	hl, (word_FFB2)
		ex	de, hl
		call	sub_317C
		pop	hl
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_3391:				; CODE XREF: RAM:336Ej
		push	hl
		ld	d, b
		ld	e, c
		ld	hl, (word_FFB2)
		ex	de, hl
		call	sub_317C
		pop	hl
		ret	m
		push	hl
		ld	hl, (word_FFB0)
		call	sub_317C
		pop	hl
		ret	m
		jp	loc_3143
; ---------------------------------------------------------------------------

loc_33A9:				; CODE XREF: RAM:3371j
		ld	d, b
		ld	e, c
		push	hl
		ld	hl, (word_FFB2)
		call	sub_317C
		pop	hl
		jp	p, loc_3143
		push	hl
		ld	hl, (word_FFB0)
		ld	d, b
		ld	e, c
		ex	de, hl
		call	sub_317C
		pop	hl
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_33C5:				; DATA XREF: sub_30BE+4Eo sub_30BE+59o
		jp	loc_33D4
; ---------------------------------------------------------------------------
		jp	loc_33E0
; ---------------------------------------------------------------------------
		jp	loc_3143
; ---------------------------------------------------------------------------
		jp	loc_33EC
; ---------------------------------------------------------------------------
		jp	loc_3401
; ---------------------------------------------------------------------------

loc_33D4:				; CODE XREF: RAM:loc_33C5j
		ex	de, hl
		ld	hl, (word_FFB0)
		call	sub_317C
		ex	de, hl
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_33E0:				; CODE XREF: RAM:33C8j
		ex	de, hl
		ld	hl, (word_FFB2)
		ex	de, hl
		call	sub_317C
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_33EC:				; CODE XREF: RAM:33CEj
		ex	de, hl
		ld	hl, (word_FFB2)
		ex	de, hl
		call	sub_317C
		ret	m
		ex	de, hl
		ld	hl, (word_FFB0)
		call	sub_317C
		ex	de, hl
		ret	m
		jp	loc_3143
; ---------------------------------------------------------------------------

loc_3401:				; CODE XREF: RAM:33D1j
		ex	de, hl
		ld	hl, (word_FFB2)
		call	sub_317C
		ex	de, hl
		jp	p, loc_3143
		ex	de, hl
		ld	hl, (word_FFB0)
		ex	de, hl
		call	sub_317C
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_3418:				; DATA XREF: sub_30BE+41o sub_30BE+66o
		jp	loc_3427
; ---------------------------------------------------------------------------
		jp	loc_3435
; ---------------------------------------------------------------------------
		jp	loc_3143
; ---------------------------------------------------------------------------
		jp	loc_3444
; ---------------------------------------------------------------------------
		jp	loc_345E
; ---------------------------------------------------------------------------

loc_3427:				; CODE XREF: RAM:loc_3418j
		push	hl
		ld	d, b
		ld	e, c
		ld	hl, (word_FFB2)
		call	sub_317C
		pop	hl
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_3435:				; CODE XREF: RAM:341Bj
		push	hl
		ld	d, b
		ld	e, c
		ld	hl, (word_FFB0)
		ex	de, hl
		call	sub_317C
		pop	hl
		jp	p, loc_3143
		ret
; ---------------------------------------------------------------------------

loc_3444:				; CODE XREF: RAM:3421j
		push	hl
		ld	d, b
		ld	e, c
		ld	hl, (word_FFB0)
		ex	de, hl
		call	sub_317C
		pop	hl
		ret	m
		push	hl
		push	bc
		pop	de
		ld	hl, (word_FFB2)
		call	sub_317C
		pop	hl
		ret	m
		jp	loc_3143
; ---------------------------------------------------------------------------

loc_345E:				; CODE XREF: RAM:3424j
		push	hl
		ld	hl, (word_FFB0)
		ld	d, b
		ld	e, c
		call	sub_317C
		pop	hl
		jp	p, loc_3143
		push	hl
		ld	hl, (word_FFB2)
		ex	de, hl
		ld	h, b
		ld	l, c
		call	sub_317C
		pop	hl
		jp	p, loc_3143
		ret

; =============== S U B	R O U T	I N E =======================================


sub_347A:				; CODE XREF: sub_3182+15p sub_3182+2Ap ...
		ld	hl, 0FFBAh
		push	af
		add	a, l
		ld	l, a
		ld	a, 0
		adc	a, h
		ld	h, a
		pop	af

loc_3485:				; CODE XREF: sub_347A+Fj sub_347A+12j
		ld	(hl), c
		dec	b
		cp	b
		inc	hl
		jp	m, loc_3485
		jp	z, loc_3485
		ret
; End of function sub_347A


; =============== S U B	R O U T	I N E =======================================


sub_3490:				; CODE XREF: RAM:315Cp	RAM:316Fp ...
		push	af
		ld	a, 8
		ld	(byte_FFA6), a
		xor	a
		ld	b, a
		ld	c, a
		ld	d, a
		ld	e, a
		ld	a, h
		or	a
		jp	p, loc_34A2
		ld	b, 0FFh

loc_34A2:				; CODE XREF: sub_3490+Dj sub_3490+2Dj
		pop	af
		rra
		push	af
		jp	nc, loc_34AF
		push	hl
		add	hl, de
		ex	de, hl
		ld	a, c
		adc	a, b
		ld	c, a
		pop	hl

loc_34AF:				; CODE XREF: sub_3490+15j
		add	hl, hl
		ld	a, b
		adc	a, b
		ld	b, a
		ld	a, (byte_FFA6)
		dec	a
		jp	z, loc_34C0
		ld	(byte_FFA6), a
		jp	loc_34A2
; ---------------------------------------------------------------------------

loc_34C0:				; CODE XREF: sub_3490+27j
		pop	af
		ret
; End of function sub_3490

; ---------------------------------------------------------------------------
byte_34C2:	db 0B5h,0B4h,0B3h,0B3h,0B2h,0B2h,0B1h,0B1h,0B0h,0AFh,0AFh,0AEh,0AEh,0ADh,0ADh,0ACh
					; DATA XREF: sub_3297o
		db 0ABh,0ABh,0AAh,0AAh,0A9h,0ABh,0A8h,0A7h,0A7h,0A6h,0A6h,0A5h,0A4h,0A4h,0A3h,0A3h
		db 0A2h,0A1h,0A1h,0A0h,	9Fh, 9Fh, 9Eh, 9Eh, 9Dh, 9Ch, 9Ch, 9Bh,	9Bh, 9Ah, 99h, 99h
		db  98h, 97h, 97h, 96h,	95h, 95h, 94h, 94h, 93h, 92h, 92h, 31h,	90h, 90h, 8Fh, 8Eh
		db  8Eh, 8Dh, 8Ch, 8Ch,	8Bh, 8Ah, 8Ah, 89h, 88h, 88h, 87h, 86h,	86h, 85h, 84h, 84h
		db  83h, 82h, 82h, 81h,	80h, 80h, 7Fh, 7Eh, 7Eh, 7Dh, 7Ch, 7Ch,	7Bh, 7Ah, 7Ah, 79h
		db  78h, 77h, 77h, 76h,	75h, 75h, 74h, 73h, 73h, 72h, 71h, 70h,	70h, 6Fh, 6Eh, 6Eh
		db  6Dh, 6Ch, 6Ch, 6Bh,	6Ah, 69h, 69h, 68h, 67h, 67h, 66h, 65h,	64h, 64h, 63h, 62h
		db  61h, 61h, 60h, 5Fh,	5Fh, 5Eh, 5Dh, 5Ch, 5Ch, 5Bh, 5Ah, 59h,	59h, 58h, 57h, 56h
		db  56h, 55h, 54h, 54h,	53h, 52h, 51h, 51h, 50h, 4Fh, 4Eh, 4Eh,	4Dh, 4Ch, 4Bh, 4Bh
		db  4Ah, 49h, 48h, 48h,	47h, 46h, 45h, 45h, 44h, 43h, 42h, 42h,	41h, 40h, 3Fh, 3Eh
		db  3Eh, 3Dh, 3Ch, 3Bh,	3Bh, 3Ah, 39h, 38h, 38h, 37h, 36h, 35h,	35h, 34h, 33h, 32h
		db  31h, 31h, 30h, 2Fh,	2Eh, 2Eh, 2Dh, 2Ch, 2Bh, 2Ah, 2Ah, 29h,	28h, 27h, 27h, 26h
		db  25h, 24h, 24h, 23h,	22h, 21h, 20h, 20h, 1Fh, 1Eh, 1Dh, 1Ch,	1Ch, 1Bh, 1Ah, 19h
		db  19h, 18h, 17h, 16h,	15h, 15h, 14h, 13h, 12h, 12h, 11h, 10h,	0Fh, 0Eh, 0Eh, 0Dh
		db  0Ch, 0Bh, 0Ah, 0Ah,	  9,   8,   7,	 7,   6,   5,	4,   3,	  3,   2,   1,	 0

; =============== S U B	R O U T	I N E =======================================


sub_35C2:				; CODE XREF: RAM:_InitGrOut_WithMod_0p
		ld	a, 0C3h	; ''
		ld	(byte_FFFA), a
		ld	hl, locret_365C
		ld	(unk_FFFB), hl
		ret
; End of function sub_35C2

; ---------------------------------------------------------------------------

_GraphLangNextChar:			; CODE XREF: RAM:27A4j
					; DATA XREF: RAM:_InitGrOut_WithModo
		cp	20h ; ' '
		ret	z
		cp	0Dh
		ret	z
		cp	0Ah
		ret	z
		cp	2Ch ; ','
		jp	z, loc_35EC
		cp	30h ; '0'
		jp	c, loc_3611
		cp	3Ah ; ':'
		jp	c, loc_35F9
		ld	(byte_FFF9), a
		jp	loc_3616
; ---------------------------------------------------------------------------

loc_35EC:				; CODE XREF: RAM:35D9j
		ld	hl, (word_FFF3)
		ld	(word_FFF5), hl
		ld	hl, 0
		ld	(word_FFF3), hl
		ret
; ---------------------------------------------------------------------------

loc_35F9:				; CODE XREF: RAM:35E3j
		ld	(byte_FFF7), a
		sub	30h ; '0'
		push	af
		ld	a, 0Ah
		ld	hl, (word_FFF3)
		call	sub_3490
		ex	de, hl
		pop	de
		ld	e, d
		ld	d, 0
		add	hl, de
		ld	(word_FFF3), hl
		ret
; ---------------------------------------------------------------------------

loc_3611:				; CODE XREF: RAM:35DEj
		ld	hl, 0FFF9h
		ld	(hl), 0

loc_3616:				; CODE XREF: RAM:35E9j
		push	af
		ld	a, (byte_FFF7)
		or	a
		jp	nz, loc_362A
		ld	hl, (word_FF8C)
		ld	(word_FFF5), hl
		ld	hl, (word_FF8E)
		ld	(word_FFF3), hl

loc_362A:				; CODE XREF: RAM:361Bj
		call	sub_378C
		ld	hl, (word_FFF3)
		ld	a, l
		ex	de, hl
		ld	hl, (word_FFF5)
		call	byte_FFFA
		pop	af
		ld	hl, 0
		ld	(word_FFF3), hl
		ld	hl, byte_FFF7
		ld	(hl), 0
		ld	hl, _TableGraphicsLang
		call	JumpStrangeTableHiLo
		ex	de, hl
		ld	(unk_FFFB), hl
		ld	a, (byte_FFF9)
		or	a
		ret	nz
		call	byte_FFFA
		ld	hl, 365Ch
		ld	(unk_FFFB), hl

locret_365C:				; DATA XREF: sub_35C2+5o RAM:37B9o ...
		ret

; =============== S U B	R O U T	I N E =======================================


_LdirBCtoDE_H:				; CODE XREF: RAM:3051p	RAM:30BBj ...
		ld	a, (bc)
		ld	(de), a
		inc	bc
		inc	de
		dec	h
		jp	nz, _LdirBCtoDE_H
		ret
; End of function _LdirBCtoDE_H

; ---------------------------------------------------------------------------

loc_3666:				; DATA XREF: RAM:37CBo
		ld	bc, word_FF8C
		ld	de, unk_FFE7
		ld	h, 8
		jp	_LdirBCtoDE_H

; =============== S U B	R O U T	I N E =======================================


sub_3671:				; CODE XREF: RAM:3699p
					; DATA XREF: RAM:37B1o
		call	sub_378C
		ld	bc, unk_FFE7
		ld	de, word_FF8C
		ld	h, 8
		jp	_LdirBCtoDE_H
; End of function sub_3671

; ---------------------------------------------------------------------------

_G_T_restoreConOut:			; DATA XREF: RAM:37F3o
		call	_RestoreDefConOut
		pop	hl
		pop	hl
		pop	hl
		ret
; ---------------------------------------------------------------------------

_G_B_SetPaintColor:			; DATA XREF: RAM:37CFo
		ld	(byte_FFF8), a
		ret
; ---------------------------------------------------------------------------

_G_A_Paint:				; DATA XREF: RAM:37CDo
		ld	a, (byte_FFF8)
		jp	_PAINT_HLDEA
; ---------------------------------------------------------------------------

_G_M_LINE:				; DATA XREF: RAM:37E5o
		ld	a, (byte_FFF7)
		or	a
		jp	nz, _LINE_HLDE
		push	hl
		push	de
		call	sub_3671
		pop	de
		pop	hl
		jp	_LINE_HLDE
; ---------------------------------------------------------------------------

_G_I_Circle:				; DATA XREF: RAM:37DDo
		ld	a, (word_FFA8)
		jp	_CIRCLE_HLDEA
; ---------------------------------------------------------------------------

_G_S_CircleSquize:			; DATA XREF: RAM:37EFo
		ex	de, hl
		ld	(word_FFA8), hl
		ret
; ---------------------------------------------------------------------------

_G_F_Ellipse:				; DATA XREF: RAM:37D7o
		ld	(word_FFB6), hl
		ex	de, hl
		ld	(word_FFB8), hl
		ret
; ---------------------------------------------------------------------------

_G_R_CircleR:				; DATA XREF: RAM:37F1o
		ld	(word_FFCB), hl
		ex	de, hl
		ld	(word_FFCD), hl
		ret
; ---------------------------------------------------------------------------

loc_36BC:				; DATA XREF: RAM:37C7o
		ld	c, 0

; =============== S U B	R O U T	I N E =======================================


sub_36BE:				; CODE XREF: sub_371B+25p sub_371B+4Cp
		ld	hl, (word_FF8E)
		ld	a, l
		or	a
		ret	z
		dec	hl
		ld	(word_FF8E), hl
		ld	hl, (word_FF88)
		ex	de, hl
		ld	hl, (word_FF90)
		ld	a, l
		sub	e
		ld	l, a
		ld	a, h
		sbc	a, d
		ld	h, a
		ld	(word_FF90), hl
		jp	loc_3772
; End of function sub_36BE

; ---------------------------------------------------------------------------

loc_36DB:				; DATA XREF: RAM:37C9o
		ld	c, 0

; =============== S U B	R O U T	I N E =======================================


sub_36DD:				; CODE XREF: sub_371B+32p sub_371B+3Fp
		ld	hl, (word_FF8E)
		ld	a, 0C7h	; ''
		cp	l
		ret	z
		inc	hl
		ld	(word_FF8E), hl
		ld	hl, (word_FF88)
		ex	de, hl
		ld	hl, (word_FF90)
		add	hl, de
		ld	(word_FF90), hl
		jp	loc_3772
; End of function sub_36DD

; ---------------------------------------------------------------------------

loc_36F6:				; DATA XREF: RAM:37C3o
		ld	c, 0

; =============== S U B	R O U T	I N E =======================================


sub_36F8:				; CODE XREF: sub_371B+44p sub_371B+51p
		ld	hl, (word_FF8C)
		xor	a
		add	a, h
		add	a, l
		adc	a, 0
		ret	z
		dec	hl
		ld	(word_FF8C), hl
		ld	hl, (word_FF90)
		ld	a, (word_FF92)
		rlca
		jp	nc, loc_3710
		dec	hl

loc_3710:				; CODE XREF: sub_36F8+14j
		ld	(word_FF92), a
		ld	(word_FF90), hl
		jp	loc_3772
; End of function sub_36F8

; ---------------------------------------------------------------------------

loc_3719:				; DATA XREF: RAM:37C1o
		ld	c, 0

; =============== S U B	R O U T	I N E =======================================


sub_371B:				; CODE XREF: sub_371B+2Ap sub_371B+37p
		ld	hl, (word_FFCF)
		ex	de, hl
		ld	hl, (word_FF8C)
		call	sub_317C
		ret	z
		inc	hl
		ld	(word_FF8C), hl
		ld	hl, (word_FF90)
		ld	a, (word_FF92)
		rrca
		jp	nc, loc_3735
		inc	hl

loc_3735:				; CODE XREF: sub_371B+16j
		ld	(word_FF92), a
		ld	(word_FF90), hl
		jp	loc_3772
; ---------------------------------------------------------------------------

loc_373E:				; DATA XREF: RAM:37B5o
		ld	c, 0FFh
		call	sub_36BE
		ld	c, 0FFh
		call	sub_371B
		jp	loc_3774
; ---------------------------------------------------------------------------

loc_374B:				; DATA XREF: RAM:37B3o
		ld	c, 0FFh
		call	sub_36DD
		ld	c, 0FFh
		call	sub_371B
		jp	loc_3774
; ---------------------------------------------------------------------------

loc_3758:				; DATA XREF: RAM:37BBo
		ld	c, 0FFh
		call	sub_36DD
		ld	c, 0FFh
		call	sub_36F8
		jp	loc_3774
; ---------------------------------------------------------------------------

loc_3765:				; DATA XREF: RAM:37B7o
		ld	c, 0FFh
		call	sub_36BE
		ld	c, 0FFh
		call	sub_36F8
		jp	loc_3774
; ---------------------------------------------------------------------------

loc_3772:				; CODE XREF: sub_36BE+1Aj sub_36DD+16j ...
		inc	c
		ret	z

loc_3774:				; CODE XREF: sub_371B+2Dj sub_371B+3Aj ...
		ld	a, (word_FF92)
		ld	hl, (word_FF90)
		call	byte_FFD4
		ld	d, a
		ld	a, (hl)
		and	c
		or	d
		ld	(hl), a
		ld	a, b
		ld	(byte_FFF1), a
		xor	(hl)
		ld	(hl), a
		ld	(word_FFEF), hl
		ret
; End of function sub_371B


; =============== S U B	R O U T	I N E =======================================


sub_378C:				; CODE XREF: RAM:loc_362Ap sub_3671p
		ld	a, (byte_FFF1)
		ld	hl, (word_FFEF)
		xor	(hl)
		ld	(hl), a
		xor	a
		ld	(byte_FFF1), a
		ret
; End of function sub_378C

; ---------------------------------------------------------------------------

_G_02_ToggleMode:			; DATA XREF: RAM:37AFo
		ld	hl, _PeroOnOff
		ld	a, (hl)
		cpl
		ld	(hl), a
		jp	loc_3774
; ---------------------------------------------------------------------------
_TableGraphicsLang:db 3			; DATA XREF: RAM:3644o
		db 1
		db 0Dh
		db 7
		db 1
		db 0Fh
		db 1Fh
		db 0Dh
		db 29h
		db 55h
		db 14h
		db 51h
		db 0FFh
		dw _G_02_ToggleMode
		dw sub_3671
		dw loc_374B
		dw loc_373E
		dw loc_3765
		dw locret_365C
		dw loc_3758
		dw locret_365C
		dw locret_365C
		dw loc_3719
		dw loc_36F6
		dw locret_365C
		dw loc_36BC
		dw loc_36DB
		dw loc_3666
		dw _G_A_Paint
		dw _G_B_SetPaintColor
		dw _G_C_SetColor_A
		dw locret_365C
		dw locret_365C
		dw _G_F_Ellipse
		dw locret_365C
		dw locret_365C
		dw _G_I_Circle
		dw locret_365C
		dw locret_365C
		dw locret_365C
		dw _G_M_LINE
		dw locret_365C
		dw locret_365C
		dw _G_P_PSET_HLDE
		dw locret_365C
		dw _G_S_CircleSquize
		dw _G_R_CircleR
		dw _G_T_restoreConOut
		dw locret_365C
		db  1Ah
		db  1Ah
		db  1Ah
		db  1Ah
		db  1Ah
		db  1Ah
		db  1Ah
		db  1Ah
		db  1Ah
ROM_CharGen:	db    0,   0,	0,   0,	  0,   0,   0,	 0
		db  7Eh, 81h,0A5h, 81h,0BDh, 99h, 81h, 7Eh
		db  7Eh,0FFh,0DBh,0FFh,0C3h,0E7h,0FFh, 7Eh
		db  6Ch,0FEh,0FEh,0FEh,	7Ch, 38h, 10h,	 0
		db  10h, 38h, 7Ch,0FEh,	7Ch, 38h, 10h,	 0
		db  38h, 7Ch, 38h,0FEh,0FEh,0D6h, 10h, 38h
		db  10h, 10h, 38h, 7Ch,0FEh, 7Ch, 10h, 38h
		db    0,   0, 18h, 3Ch,	3Ch, 18h,   0,	 0
		db 0FFh,0FFh,0E7h,0C3h,0C3h,0E7h,0FFh,0FFh
		db    0, 3Ch, 66h, 42h,	42h, 66h, 3Ch,	 0
		db 0FFh,0C3h, 99h,0BDh,0BDh, 99h,0C3h,0FFh
		db  0Fh,   7, 0Fh, 7Dh,0CCh,0CCh,0CCh, 78h
		db  3Ch, 66h, 66h, 66h,	3Ch, 18h, 7Eh, 18h
		db  3Fh, 33h, 3Fh, 30h,	30h, 70h,0F0h,0E0h
		db  7Fh, 63h, 7Fh, 63h,	63h, 67h,0E6h,0C0h
		db  18h,0DBh, 3Ch,0E7h,0E7h, 3Ch,0DBh, 18h
		db  80h,0E0h,0F8h,0FEh,0F8h,0E0h, 80h,	 0
		db    2, 0Eh, 3Eh,0FEh,	3Eh, 0Eh,   2,	 0
		db  18h, 3Ch, 7Eh, 18h,	18h, 7Eh, 3Ch, 18h
		db  66h, 66h, 66h, 66h,	66h,   0, 66h,	 0
		db  7Fh,0DBh,0DBh, 7Bh,	1Bh, 1Bh, 1Bh,	 0
		db  3Eh, 63h, 38h, 6Ch,	6Ch, 38h,0CCh, 78h
		db    0,   0,	0,   0,	7Eh, 7Eh, 7Eh,	 0
		db  18h, 3Ch, 7Eh, 18h,	7Eh, 3Ch, 18h,0FFh
		db  18h, 3Ch, 7Eh, 18h,	18h, 18h, 18h,	 0
		db  18h, 18h, 18h, 18h,	7Eh, 3Ch, 18h,	 0
		db    0, 18h, 0Ch,0FEh,	0Ch, 18h,   0,	 0
		db    0, 30h, 60h,0FEh,	60h, 30h,   0,	 0
		db    0,   0,0C0h,0C0h,0C0h,0FEh,   0,	 0
		db    0, 24h, 66h,0FFh,	66h, 24h,   0,	 0
		db    0, 18h, 3Ch, 7Eh,0FFh,0FFh,   0,	 0
		db    0,0FFh,0FFh, 7Eh,	3Ch, 18h,   0,	 0
		db    0,   0,	0,   0,	  0,   0,   0,	 0
		db  30h, 78h, 78h, 30h,	30h,   0, 30h,	 0
		db  6Ch, 6Ch, 6Ch,   0,	  0,   0,   0,	 0
		db  6Ch, 6Ch,0FEh, 6Ch,0FEh, 6Ch, 6Ch,	 0
		db  30h, 7Ch,0C0h, 78h,	0Ch,0F8h, 30h,	 0
		db    0,0C6h,0CCh, 18h,	30h, 66h,0C6h,	 0
		db  38h, 6Ch, 38h, 76h,0DCh,0CCh, 76h,	 0
		db  60h, 60h,0C0h,   0,	  0,   0,   0,	 0
		db  18h, 30h, 60h, 60h,	60h, 30h, 18h,	 0
		db  60h, 30h, 18h, 18h,	18h, 30h, 60h,	 0
		db    0, 66h, 3Ch,0FFh,	3Ch, 66h,   0,	 0
		db    0, 30h, 30h,0FCh,	30h, 30h,   0,	 0
		db    0,   0,	0,   0,	  0, 30h, 30h, 60h
		db    0,   0,	0,0FCh,	  0,   0,   0,	 0
		db    0,   0,	0,   0,	  0, 30h, 30h,	 0
		db    6, 0Ch, 18h, 30h,	60h,0C0h, 80h,	 0
		db  7Ch,0C6h,0CEh,0DEh,0F6h,0E6h, 7Ch,	 0
		db  30h, 70h, 30h, 30h,	30h, 30h,0FCh,	 0
		db  78h,0CCh, 0Ch, 38h,	60h,0CCh,0FCh,	 0
		db  78h,0CCh, 0Ch, 38h,	0Ch,0CCh, 78h,	 0
		db  1Ch, 3Ch, 6Ch,0CCh,0FEh, 0Ch, 1Eh,	 0
		db 0FCh,0C0h,0F8h, 0Ch,	0Ch,0CCh, 78h,	 0
		db  38h, 60h,0C0h,0F8h,0CCh,0CCh, 78h,	 0
		db 0FCh,0CCh, 0Ch, 18h,	30h, 30h, 30h,	 0
		db  78h,0CCh,0CCh, 78h,0CCh,0CCh, 78h,	 0
		db  78h,0CCh,0CCh, 7Ch,	0Ch, 18h, 70h,	 0
		db    0, 30h, 30h,   0,	  0, 30h, 30h,	 0
		db    0, 30h, 30h,   0,	  0, 30h, 30h, 60h
		db  18h, 30h, 60h,0C0h,	60h, 30h, 18h,	 0
		db    0,   0,0FCh,   0,0FCh,   0,   0,	 0
		db  60h, 30h, 18h, 0Ch,	18h, 30h, 60h,	 0
		db  78h,0CCh, 0Ch, 18h,	30h,   0, 30h,	 0
		db  7Ch,0C6h,0DEh,0DEh,0DEh,0C0h, 78h,	 0
		db  30h, 78h,0CCh,0CCh,0FCh,0CCh,0CCh,	 0
		db 0FCh, 66h, 66h, 7Ch,	66h, 66h,0FCh,	 0
		db  3Ch, 66h,0C0h,0C0h,0C0h, 66h, 3Ch,	 0
		db 0F8h, 6Ch, 66h, 66h,	66h, 6Ch,0F8h,	 0
		db 0FEh, 62h, 68h, 78h,	68h, 62h,0FEh,	 0
		db 0FEh, 62h, 68h, 78h,	68h, 60h,0F0h,	 0
		db  3Ch, 66h,0C0h,0C0h,0CEh, 66h, 3Eh,	 0
		db 0CCh,0CCh,0CCh,0FCh,0CCh,0CCh,0CCh,	 0
		db  78h, 30h, 30h, 30h,	30h, 30h, 78h,	 0
		db  1Eh, 0Ch, 0Ch, 0Ch,0CCh,0CCh, 78h,	 0
		db 0E6h, 66h, 6Ch, 78h,	6Ch, 66h,0E6h,	 0
		db 0F0h, 60h, 60h, 60h,	62h, 66h,0FEh,	 0
		db 0C6h,0EEh,0FEh,0FEh,0D6h,0C6h,0C6h,	 0
		db 0C6h,0E6h,0F6h,0DEh,0CEh,0C6h,0C6h,	 0
		db  38h, 6Ch,0C6h,0C6h,0C6h, 6Ch, 38h,	 0
		db 0FCh, 66h, 66h, 7Ch,	60h, 60h,0F0h,	 0
		db  78h,0CCh,0CCh,0CCh,0DCh, 78h, 1Ch,	 0
		db 0FCh, 66h, 66h, 7Ch,	6Ch, 66h,0E6h,	 0
		db  78h,0CCh, 60h, 30h,	18h,0CCh, 78h,	 0
		db 0FCh,0B4h, 30h, 30h,	30h, 30h, 78h,	 0
		db 0CCh,0CCh,0CCh,0CCh,0CCh,0CCh, 78h,	 0
		db 0CCh,0CCh,0CCh,0CCh,0CCh, 78h, 30h,	 0
		db 0C6h,0C6h,0C6h,0D6h,0FEh,0EEh,0C6h,	 0
		db 0C6h,0C6h, 6Ch, 38h,	38h, 6Ch,0C6h,	 0
		db 0CCh,0CCh,0CCh, 78h,	30h, 30h, 78h,	 0
		db 0FEh,0C6h, 8Ch, 18h,	32h, 66h,0FEh,	 0
		db  78h, 60h, 60h, 60h,	60h, 60h, 78h,	 0
		db 0C0h, 60h, 30h, 18h,	0Ch,   6,   2,	 0
		db  78h, 18h, 18h, 18h,	18h, 18h, 78h,	 0
		db  10h, 38h, 6Ch,0C6h,	  0,   0,   0,	 0
		db    0,   0,	0,   0,	  0,   0,   0,0FFh
		db  30h, 30h, 18h,   0,	  0,   0,   0,	 0
		db    0,   0, 78h, 0Ch,	7Ch,0CCh, 76h,	 0
		db 0E0h, 60h, 60h, 7Ch,	66h, 66h,0DCh,	 0
		db    0,   0, 78h,0CCh,0C0h,0CCh, 78h,	 0
		db  1Ch, 0Ch, 0Ch, 7Ch,0CCh,0CCh, 76h,	 0
		db    0,   0, 78h,0CCh,0FCh,0C0h, 78h,	 0
		db  38h, 6Ch, 60h,0F0h,	60h, 60h,0F0h,	 0
		db    0,   0, 76h,0CCh,0CCh, 7Ch, 0Ch,0F8h
		db 0E0h, 60h, 6Ch, 76h,	66h, 66h,0E6h,	 0
		db  30h,   0, 70h, 30h,	30h, 30h, 78h,	 0
		db  0Ch,   0, 0Ch, 0Ch,	0Ch,0CCh,0CCh, 78h
		db 0E0h, 60h, 66h, 6Ch,	78h, 6Ch,0E6h,	 0
		db  70h, 30h, 30h, 30h,	30h, 30h, 78h,	 0
		db    0,   0,0CCh,0FEh,0FEh,0D6h,0C6h,	 0
		db    0,   0,0F8h,0CCh,0CCh,0CCh,0CCh,	 0
		db    0,   0, 78h,0CCh,0CCh,0CCh, 78h,	 0
		db    0,   0,0DCh, 66h,	66h, 7Ch, 60h,0F0h
		db    0,   0, 76h,0CCh,0CCh, 7Ch, 0Ch, 1Eh
		db    0,   0,0DCh, 76h,	66h, 60h,0F0h,	 0
		db    0,   0, 7Ch,0C0h,	78h, 0Ch,0F8h,	 0
		db  10h, 30h, 7Ch, 30h,	30h, 34h, 18h,	 0
		db    0,   0,0CCh,0CCh,0CCh,0CCh, 76h,	 0
		db    0,   0,0CCh,0CCh,0CCh, 78h, 30h,	 0
		db    0,   0,0C6h,0D6h,0FEh,0FEh, 6Ch,	 0
		db    0,   0,0C6h, 6Ch,	38h, 6Ch,0C6h,	 0
		db    0,   0,0CCh,0CCh,0CCh, 7Ch, 0Ch,0F8h
		db    0,   0,0FCh, 98h,	30h, 64h,0FCh,	 0
		db  1Ch, 30h, 30h,0E0h,	30h, 30h, 1Ch,	 0
		db  18h, 18h, 18h,   0,	18h, 18h, 18h,	 0
		db 0E0h, 30h, 30h, 1Ch,	30h, 30h,0E0h,	 0
		db  76h,0DCh,	0,   0,	  0,   0,   0,	 0
		db    0, 10h, 38h, 6Ch,0C6h,0C6h,0FEh,	 0
		db  22h, 88h, 22h, 88h,	22h, 88h, 22h, 88h
		db  55h,0AAh, 55h,0AAh,	55h,0AAh, 55h,0AAh
		db 0DBh, 77h,0DBh,0EEh,0DBh, 77h,0DBh,0EEh
		db  18h, 18h, 18h, 18h,	18h, 18h, 18h, 18h
		db  18h, 18h, 18h, 18h,0F8h, 18h, 18h, 18h
		db  18h, 18h,0F8h, 18h,0F8h, 18h, 18h, 18h
		db  36h, 36h, 36h, 36h,0F6h, 36h, 36h, 36h
		db    0,   0,	0,   0,0FEh, 36h, 36h, 36h
		db    0,   0,0F8h, 18h,0F8h, 18h, 18h, 18h
		db  36h, 36h,0F6h,   6,0F6h, 36h, 36h, 36h
		db  36h, 36h, 36h, 36h,	36h, 36h, 36h, 36h
		db    0,   0,0FEh,   6,0F6h, 36h, 36h, 36h
		db  36h, 36h,0F6h,   6,0FEh,   0,   0,	 0
		db  36h, 36h, 36h, 36h,0FEh,   0,   0,	 0
		db  18h, 18h,0F8h, 18h,0F8h,   0,   0,	 0
		db    0,   0,	0,   0,0F8h, 18h, 18h, 18h
		db  18h, 18h, 18h, 18h,	1Fh,   0,   0,	 0
		db  18h, 18h, 18h, 18h,0FFh,   0,   0,	 0
		db    0,   0,	0,   0,0FFh, 18h, 18h, 18h
		db  18h, 18h, 18h, 18h,	1Fh, 18h, 18h, 18h
		db    0,   0,	0,   0,0FFh,   0,   0,	 0
		db  18h, 18h, 18h, 18h,0FFh, 18h, 18h, 18h
		db  18h, 18h, 1Fh, 18h,	1Fh, 18h, 18h, 18h
		db  36h, 36h, 36h, 36h,	37h, 36h, 36h, 36h
		db  36h, 36h, 37h, 30h,	3Fh,   0,   0,	 0
		db    0,   0, 3Fh, 30h,	37h, 36h, 36h, 36h
		db  36h, 36h,0F7h,   0,0FFh,   0,   0,	 0
		db    0,   0,0FFh,   0,0F7h, 36h, 36h, 36h
		db  36h, 36h, 37h, 30h,	37h, 36h, 36h, 36h
		db    0,   0,0FFh,   0,0FFh,   0,   0,	 0
		db  36h, 36h,0F7h,   0,0F7h, 36h, 36h, 36h
		db  18h, 18h,0FFh,   0,0FFh,   0,   0,	 0
		db    0,   0, 76h,0DCh,0C8h,0DCh, 76h,	 0
		db    0, 78h,0CCh,0F8h,0CCh,0F8h,0C0h,0C0h
		db    0,0FCh,0CCh,0C0h,0C0h,0C0h,0C0h,	 0
		db    0,0FEh, 6Ch, 6Ch,	6Ch, 6Ch, 6Ch,	 0
		db 0FCh,0CCh, 60h, 30h,	60h,0CCh,0FCh,	 0
		db    0,   0, 7Eh,0D8h,0D8h,0D8h, 70h,	 0
		db    0, 66h, 66h, 66h,	66h, 7Ch, 60h,0C0h
		db    0, 76h,0DCh, 18h,	18h, 18h, 18h,	 0
		db 0FCh, 30h, 78h,0CCh,0CCh, 78h, 30h,0FCh
		db  38h, 6Ch,0C6h,0FEh,0C6h, 6Ch, 38h,	 0
		db  38h, 6Ch,0C6h,0C6h,	6Ch, 6Ch,0EEh,	 0
		db  1Ch, 30h, 18h, 7Ch,0CCh,0CCh, 78h,	 0
		db    0,   0, 7Eh,0DBh,0DBh, 7Eh,   0,	 0
		db    6, 0Ch, 7Eh,0DBh,0DBh, 7Eh, 60h,0C0h
		db  38h, 60h,0C0h,0F8h,0C0h, 60h, 38h,	 0
		db  78h,0CCh,0CCh,0CCh,0CCh,0CCh,0CCh,	 0
		db    0,   0,	0,   8,	18h, 38h, 18h, 18h
		db    0,   0,	0, 38h,	6Ch, 18h, 30h, 7Ch
		db    0,   0,	0, 38h,	6Ch, 18h, 6Ch, 38h
		db    0,   0,	0, 6Ch,	6Ch, 7Ch, 0Ch, 0Ch
		db    0,   0,	0, 7Ch,	60h, 78h, 0Ch, 78h
		db    0,   0,	0, 38h,	60h, 78h, 6Ch, 38h
		db    0,   0,	0, 7Ch,	0Ch, 0Ch, 18h, 30h
		db    0,   0,	0, 38h,	6Ch, 38h, 6Ch, 38h
		db    0,   0,	0, 38h,	6Ch, 3Ch, 0Ch, 38h
		db    0,   0,	0, 38h,	6Ch, 6Ch, 6Ch, 38h
		db  38h, 6Ch, 6Ch, 38h,	  0,   0,   0,	 0
		db  38h, 6Ch, 6Ch, 6Ch,	38h,   0,   0,	 0
		db    8, 18h, 38h, 18h,	18h,   0,   0,	 0
		db  38h, 6Ch, 18h, 30h,	7Ch,   0,   0,	 0
		db  38h, 6Ch, 18h, 6Ch,	38h,   0,   0,	 0
		db  6Ch, 6Ch, 7Ch, 0Ch,	0Ch,   0,   0,	 0
		db    0,   0,0CCh,0D6h,0F6h,0D6h,0CCh,	 0
		db    0,   0, 78h, 0Ch,	7Ch,0CCh, 7Eh,	 0
		db    0,   0,0FCh,0C0h,0FCh,0C6h,0FCh,	 0
		db    0,   0,0CCh,0CCh,0CCh,0CCh,0FEh,	 6
		db    0,   0, 3Ch, 6Ch,	6Ch, 6Ch,0FEh,0C6h
		db    0,   0, 78h,0CCh,0FCh,0C0h, 78h,	 0
		db    0,   0, 18h, 7Eh,0DBh, 7Eh, 18h, 18h
		db    0,   0,0FCh,0C0h,0C0h,0C0h,0C0h,	 0
		db    0,   0,0C6h, 6Ch,	38h, 6Ch,0C6h,	 0
		db    0,   0,0C6h,0C6h,0CEh,0FEh, 66h,	 0
		db  0Ch, 18h,0C6h,0C6h,0CEh,0FEh, 66h,	 0
		db    0,   0,0CCh,0D8h,0F0h,0D8h,0CEh,	 0
		db    0,   0, 1Eh, 36h,	66h, 66h,0E6h,	 0
		db    0,   0,0C6h,0EEh,0FEh,0D6h,0C6h,	 0
		db    0,   0,0C6h,0C6h,0FEh,0C6h,0C6h,	 0
		db    0,   0, 7Ch,0C6h,0C6h,0C6h, 7Ch,	 0
		db    0,   0,0FEh,0C6h,0C6h,0C6h,0C6h,	 0
		db    0,   0, 7Eh,0C6h,	7Eh, 66h,0C6h,	 0
		db    0,   0,0FCh,0C6h,0C6h,0FCh,0C0h,0C0h
		db    0,   0, 7Ch,0C6h,0C0h,0C6h, 7Ch,	 0
		db    0,   0,0FCh, 30h,	30h, 30h, 30h,	 0
		db    0,   0,0C6h, 66h,	3Eh,   6, 7Ch,	 0
		db    0,   0,0D6h,0D6h,	7Ch,0D6h,0D6h,	 0
		db    0,   0,0F8h,0CCh,0F8h,0CCh,0F8h,	 0
		db    0,   0,0C0h,0C0h,0FCh,0C6h,0FCh,	 0
		db    0,   0,0C6h,0C6h,0F6h,0DAh,0F6h,	 0
		db    0,   0, 78h,0CCh,	18h,0CCh, 78h,	 0
		db    0,   0,0D6h,0D6h,0D6h,0D6h,0FEh,	 0
		db    0,   0,0FCh,   6,	1Eh,   6,0FCh,	 0
		db    0,   0,0D6h,0D6h,0D6h,0D6h,0FEh,	 6
		db    0,   0,0CCh,0CCh,	7Ch, 0Ch, 0Ch,	 0
		db    0,   0,0E0h, 60h,	7Ch, 66h, 7Ch,	 0
		db 0CCh,0D6h,0D6h,0F6h,0D6h,0D6h,0CCh,	 0
		db  30h, 78h,0CCh,0CCh,0FCh,0CCh,0CCh,	 0
		db 0FEh, 60h, 60h, 7Ch,	66h, 66h,0FCh,	 0
		db 0CCh,0CCh,0CCh,0CCh,0CCh,0CCh,0FEh,	 6
		db  3Ch, 6Ch, 6Ch, 6Ch,	6Ch, 6Ch,0FEh,0C6h
		db 0FEh, 62h, 68h, 78h,	68h, 62h,0FEh,	 0
		db  18h, 7Eh,0DBh,0DBh,	7Eh, 18h, 3Ch,	 0
		db 0FEh, 66h, 60h, 60h,	60h, 60h,0F0h,	 0
		db 0C6h, 6Ch, 38h, 38h,	6Ch,0C6h,0C6h,	 0
		db 0C6h,0C6h,0CEh,0DEh,0F6h,0E6h,0C6h,	 0
		db  38h,0C6h,0CEh,0DEh,0F6h,0E6h,0C6h,	 0
		db 0C6h,0CCh,0D8h,0F0h,0D8h,0CCh,0C6h,	 0
		db  1Eh, 36h, 66h, 66h,	66h, 66h,0C6h,	 0
		db 0C6h,0EEh,0FEh,0FEh,0D6h,0C6h,0C6h,	 0
		db 0CCh,0CCh,0CCh,0FCh,0CCh,0CCh,0CCh,	 0
		db  7Ch,0C6h,0C6h,0C6h,0C6h,0C6h, 7Ch,	 0
		db 0FEh,0C6h,0C6h,0C6h,0C6h,0C6h,0C6h,	 0
		db  7Eh,0C6h,0C6h, 7Eh,	36h, 66h,0C6h,	 0
		db 0FCh, 66h, 66h, 7Ch,	60h, 60h,0F0h,	 0
		db  3Ch, 66h,0C0h,0C0h,0C0h, 66h, 3Ch,	 0
		db 0FCh,0B4h, 30h, 30h,	30h, 30h, 78h,	 0
		db 0C6h,0C6h,0C6h, 7Eh,	  6, 0Ch, 78h,	 0
		db 0D6h,0D6h, 7Ch, 38h,	7Ch,0D6h,0D6h,	 0
		db 0FCh, 66h, 66h, 7Ch,	66h, 66h,0FCh,	 0
		db 0C0h,0C0h,0C0h,0FCh,0C6h,0C6h,0FCh,	 0
		db 0C6h,0C6h,0C6h,0F6h,0DAh,0DAh,0F6h,	 0
		db  7Ch,0C6h,	6, 1Ch,	  6,0C6h, 7Ch,	 0
		db 0C6h,0D6h,0D6h,0D6h,0D6h,0D6h,0FEh,	 0
		db  7Ch,0C6h,	6, 3Eh,	  6,0C6h, 7Ch,	 0
		db 0C6h,0D6h,0D6h,0D6h,0D6h,0D6h,0FEh,	 6
		db 0C6h,0C6h,0C6h, 7Eh,	  6,   6,   6,	 0
		db    0,   0,	0,   0,	  0,   0,   0,0FFh
		ds 5000h
MonitorHere:	ds 1000h		; CODE XREF: RAM:080Cj
					; DATA XREF: RAM:0803o
byte_A000:	ds 1A00h		; CODE XREF: RAM:0460j	RAM:047Dj
					; DATA XREF: ...
; ---------------------------------------------------------------------------

_Out12JPHL:				; CODE XREF: RAM:183Cj
					; DATA XREF: RAM:182Co
		out	(PPA_C), a
		jp	(hl)
; ---------------------------------------------------------------------------
		ds 41Dh
byte_BE20:	ds 1			; DATA XREF: _Logo_and_inits+16w
					; _Logo_and_inits+5Dw ...
byte_BE21:	ds 1			; DATA XREF: _CONST:loc_18CCw
					; sub_1B36+5o
byte_BE22:	ds 1			; DATA XREF: _Logo_and_inits+1w
					; _CONST+7r ...
word_BE23:	ds 2			; DATA XREF: _CONIN+7r	_CONIN+Cw ...
byte_BE25:	ds 1			; DATA XREF: _Logo_and_inits+2Ao
					; sub_1A22+21o	...
byte_BE26:	ds 1			; DATA XREF: sub_1A22+5Cr
					; sub_1A22:loc_1A8Br ...
byte_BE27:	ds 1			; DATA XREF: sub_1A22+87r
					; sub_1A22:loc_1B22r
byte_BE28:	ds 1			; DATA XREF: sub_1A22:loc_1B17r
byte_BE29:	ds 1			; DATA XREF: sub_1A22:loc_1B02r
byte_BE2A:	ds 1			; DATA XREF: sub_1B42r
		ds 1
		ds 1
		ds 1
		ds 1
word_BE2F:	ds 2			; DATA XREF: _Logo_and_inits+43w
					; sub_1A22+55r
word_BE31:	ds 2			; DATA XREF: _Logo_and_inits+46w
					; sub_1A22+63r
word_BE33:	ds 2			; DATA XREF: _Logo_and_inits+49w
					; sub_1A22+70r
word_BE35:	ds 2			; DATA XREF: _Logo_and_inits+4Fw
					; sub_1A22+B1r
unk_BE37:	ds 1			; DATA XREF: _Logo_and_inits+33o
					; sub_1902+30o	...
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
unk_BE41:	ds 1			; DATA XREF: sub_1902+5o sub_1902+2Do	...
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
byte_BE4A:	ds 1			; DATA XREF: sub_1902+12r
word_BE4B:	ds 2			; DATA XREF: _Logo_and_inits+55w
					; sub_19A8+Dr ...
word_BE4D:	ds 2			; DATA XREF: _Logo_and_inits+58w
					; sub_19A8:loc_19C3r ...
byte_BE4F:	ds 1B1h			; DATA XREF: _Logo_and_inits+52o
					; sub_19A8+18o	...
byte_C000:	ds 0E01h		; DATA XREF: RAM:015Co
_MenuItemsFromRom:ds 0FCh		; DATA XREF: RAM:0503o
_MainMenuElemnts:ds 1			; DATA XREF: RAM:0315w	RAM:0506o ...
_MainMenuMainText:ds 2			; DATA XREF: RAM:031Cw	RAM:0555w ...
_ExtRomAddr???:	ds 2			; DATA XREF: RAM:02EEw	sub_4E8r ...
word_CF02:	ds 2			; DATA XREF: RAM:0509w	RAM:0581r ...
word_CF04:	ds 30Ah			; DATA XREF: RAM:057Ew	RAM:0591r
byte_D20E:	ds 61Ah			; CODE XREF: sub_2C83+80j
byte_D828:	ds 6F0h			; DATA XREF: sub_2AD6o
byte_DF18:	ds 28h			; DATA XREF: RAM:loc_283Do
byte_DF40:	ds 6			; CODE XREF: RAM:060Cp	RAM:061Ap
					; DATA XREF: ...
byte_DF46:	ds 0Dh			; CODE XREF: RAM:04CEj
byte_DF53:	ds 7			; CODE XREF: RAM:04C6j
byte_DF5A:	ds 0A6h			; CODE XREF: RAM:0614j
byte_E000:	ds 1E30h		; DATA XREF: RAM:0162o
byte_FE30:	ds 110h			; DATA XREF: RAM:loc_287Bo
_ConOut_Cursor_Up_Down:ds 2		; DATA XREF: CursorBlink:loc_242Dr
					; CursorBlink+20r ...
_ConOut_OutMask:ds 1			; DATA XREF: _conOut_RealChar:loc_2169r
					; _conOut_RealChar+45r	...
_ConOut_ColorMask:ds 1			; DATA XREF: _conOut_RealChar:loc_21CEr
					; _conOut_RealChar+D0r	...
_ConOut4080:	ds 1			; DATA XREF: RAM:0168r
					; _conOut_RealChar+28r	...
_ConOut_Mode:	ds 1			; DATA XREF: RAM:0157r
					; _conOut_RealChar+20r	...
_ConOut_Cursor_X:ds 1			; DATA XREF: _chr_0C_FF_ClearWindow-2A6w
					; sub_2187+Cr ...
_ConOut_Cursor_Y:ds 1			; DATA XREF: _chr_0C_FF_ClearWindow-2ACw
					; sub_2187r ...
_ConOut_WIN_Left:ds 1			; DATA XREF: _chr_0C_FF_ClearWindow:_chr_0D_CRr
					; sub_219D+10r	...
_ConOut_WIN_Up:	ds 1			; DATA XREF: _chr_0C_FF_ClearWindow:_chr_0B_HOMEr
					; sub_229Ar ...
_ConOut_WIN_Right:ds 1			; DATA XREF: sub_219Dr	sub_235A+3r ...
_ConOut_WIN_Down:ds 1			; DATA XREF: sub_219D:_chr_0A_LFr
					; sub_229A+4r ...
_ConOut_Color:	ds 1			; DATA XREF: _ConOut_FixScreenVarr
					; RAM:loc_263Bw
_ConOut_MODEC:	ds 1			; DATA XREF: UpdateCursor?r
					; RAM:_ESC_@_STI_RusLatr ...
					; D7(CharWidth 1-wide),	D0(1-nocursor)
					;
_ConOut_EscCntr:ds 1			; DATA XREF: RAM:20D2w	RAM:26DCw ...
		ds 1
_ConOut_CharGen_0:ds 2			; DATA XREF: _conOut_RealChar+7o
					; RAM:loc_26D4o ...
_ConOut_CharGen_1:ds 2			; DATA XREF: RAM:275Bo
_ConOut_CharGen_2:ds 2			; DATA XREF: RAM:273Dw
_ConOut_CharGen_3:ds 2			; DATA XREF: RAM:270Cw	RAM:2743w
_ConOut_CharGen_4:ds 2
_ConOut_CharGen_5:ds 2			; DATA XREF: RAM:loc_20A9r RAM:20B2w ...
_ConOut_CharGen_6:ds 2			; DATA XREF: RAM:2718w
_ConOut_CharGen_7:ds 2			; DATA XREF: RAM:2712w
HOOK1_conout:	ds 4			; CODE XREF: _ConOut_Default1+4j
					; DATA XREF: ConOut_INIT+2w ...
HOOK2_Img:	ds 4			; CODE XREF: RAM:277Fj	RAM:2784j
					; DATA XREF: ...
HOOK3_Sound:	ds 4			; CODE XREF: RAM:23DAj	RAM:2789j
					; DATA XREF: ...
SSTACK:		ds 2			; DATA XREF: sub_219D+13Ew
					; sub_219D+177r ...
CSTACK:		ds 2			; DATA XREF: RAM:02B1w	RAM:2B01r
_ConOutSaveCharGen5:ds 2		; DATA XREF: RAM:20ACw	RAM:20BCr ...
word_FF72:	ds 2			; DATA XREF: sub_24D1+3w sub_24D1+18r	...
ASRAR:		ds 1			; DATA XREF: RAM:0251o	RAM:2547o ...
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
_NoteLength:	ds 2			; DATA XREF: _PlayNote_BC+Dr
					; _MELODY+19w
word_FF84:	ds 2			; DATA XREF: RAM:298Dw	RAM:29C5r ...
word_FF86:	ds 2			; DATA XREF: RAM:299Cw	RAM:29ABr ...
word_FF88:	ds 2			; DATA XREF: RAM:loc_29B6w RAM:2A3Cr ...
byte_FF8A:	ds 1			; DATA XREF: RAM:loc_2987w
					; RAM:loc_29FAr ...
byte_FF8B:	ds 1			; DATA XREF: RAM:298Aw
word_FF8C:	ds 2			; DATA XREF: _G_P_PSET_HLDE+3w
					; _G_P_PSET_HLDE+16r ...
word_FF8E:	ds 2			; DATA XREF: _G_P_PSET_HLDE+7w
					; RAM:2990r ...
word_FF90:	ds 2			; DATA XREF: _G_P_PSET_HLDE+31w
					; RAM:2A08r ...
word_FF92:	ds 2			; DATA XREF: _G_P_PSET_HLDE+24w
					; _G_P_PSET_HLDE+3Fw ...
word_FF94:	ds 2			; DATA XREF: RAM:2969w	RAM:29B9r ...
word_FF96:	ds 2			; DATA XREF: RAM:296Dw	RAM:2993r ...
word_FF98:	ds 2			; DATA XREF: RAM:29D5w	RAM:2A55r ...
word_FF9A:	ds 2			; DATA XREF: RAM:29DEw	RAM:2AC8r ...
word_FF9C:	ds 2			; DATA XREF: RAM:29D2w	RAM:2A20r ...
word_FF9E:	ds 2			; DATA XREF: RAM:29DBw	RAM:2A7Br ...
_PeroOnOff:	ds 1			; DATA XREF: RAM:282Dr	sub_284C+18r ...
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
byte_FFA6:	ds 1			; DATA XREF: sub_3490+3w sub_3490+23r	...
		ds 1
word_FFA8:	ds 2			; DATA XREF: RAM:_CIRCLE_HLDEAw
					; RAM:305Dr ...
word_FFAA:	ds 2			; DATA XREF: RAM:3042w	RAM:loc_3174r
word_FFAC:	ds 2			; DATA XREF: RAM:3046w	RAM:loc_3161r
		ds 1
		ds 1
word_FFB0:	ds 2			; DATA XREF: RAM:2E1Aw	RAM:2E4Br ...
word_FFB2:	ds 2			; DATA XREF: RAM:2B1Cw	RAM:loc_2B2Bw ...
word_FFB4:	ds 2			; DATA XREF: sub_3297:loc_32DCw
					; sub_3297+53r	...
word_FFB6:	ds 2			; DATA XREF: RAM:27B6w	sub_3182r ...
word_FFB8:	ds 2			; DATA XREF: RAM:27AEw	sub_3182+4r ...
byte_FFBA:	ds 1			; DATA XREF: sub_2C15+11r sub_2C83+34r ...
byte_FFBB:	ds 1			; DATA XREF: sub_2C15:loc_2C5Cr
					; sub_2C83+A9r	...
byte_FFBC:	ds 1			; DATA XREF: sub_703+56w sub_7A9r ...
byte_FFBD:	ds 1			; DATA XREF: sub_2C83:loc_2CD1r
					; sub_2C83:loc_2CD8r ...
byte_FFBE:	ds 1			; DATA XREF: sub_703+4Aw sub_75Er ...
byte_FFBF:	ds 1			; DATA XREF: sub_2C83:loc_2D46r
					; sub_2C83:loc_2D4Dr ...
byte_FFC0:	ds 1			; DATA XREF: RAM:2B7Fw	sub_2C83+2Dr ...
byte_FFC1:	ds 1			; DATA XREF: RAM:2B7Cw	sub_2C83+A2r ...
		ds 1
		ds 1
word_FFC4:	ds 2			; DATA XREF: RAM:2AEEw	RAM:2B0Fr ...
byte_FFC6:	ds 1			; DATA XREF: RAM:loc_2838r
					; sub_284C+22r	...
word_FFC7:	ds 2			; DATA XREF: RAM:loc_28B6w
					; _G_P_PSET_HLDE+2Dr ...
word_FFC9:	ds 2			; DATA XREF: RAM:loc_281Cw RAM:2840w ...
word_FFCB:	ds 2			; DATA XREF: RAM:_CircleDugaParamw
					; RAM:3168r ...
word_FFCD:	ds 2			; DATA XREF: RAM:27BAw	RAM:314Ar ...
word_FFCF:	ds 2			; DATA XREF: RAM:loc_28A9w sub_28EC+2r ...
word_FFD1:	ds 2			; CODE XREF: _G_P_PSET_HLDE+12p
					; DATA XREF: RAM:2822w	...
		ds 1
byte_FFD4:	ds 1			; CODE XREF: _G_P_PSET_HLDE+42p
					; RAM:2A4Dp ...
word_FFD5:	ds 2			; DATA XREF: RAM:loc_28DFw
byte_FFD7:	ds 1			; DATA XREF: RAM:2896w
byte_FFD8:	ds 1			; CODE XREF: RAM:2B78p
					; DATA XREF: RAM:288Ew
word_FFD9:	ds 2			; DATA XREF: RAM:28E3w
byte_FFDB:	ds 1			; CODE XREF: RAM:2B82p	sub_2C83+135p
					; DATA XREF: ...
word_FFDC:	ds 2			; DATA XREF: RAM:28E8w
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
unk_FFE7:	ds 1			; DATA XREF: RAM:3669o	sub_3671+3o
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
		ds 1
word_FFEF:	ds 2			; DATA XREF: sub_371B+6Dw sub_378C+3r
byte_FFF1:	ds 1			; DATA XREF: RAM:27FDw	sub_371B+68w ...
		ds 1
word_FFF3:	ds 2			; DATA XREF: RAM:loc_35ECr RAM:35F5w ...
word_FFF5:	ds 2			; DATA XREF: RAM:35EFw	RAM:3621w ...
byte_FFF7:	ds 1			; DATA XREF: RAM:loc_35F9w RAM:3617r ...
byte_FFF8:	ds 1			; DATA XREF: RAM:_G_B_SetPaintColorw
					; RAM:_G_A_Paintr
byte_FFF9:	ds 1			; DATA XREF: RAM:35E6w	RAM:364Er
byte_FFFA:	ds 1			; CODE XREF: RAM:3635p	RAM:3653p
					; DATA XREF: ...
unk_FFFB:	ds 1			; DATA XREF: sub_35C2+8w RAM:364Bw ...
_MelodyFile:	ds 2			; DATA XREF: _MELODYr RAM:0291w ...
_ShapeFle:	ds 2			; DATA XREF: _Logo_and_inits-1795w
					; RAM:_SHAPEr
; end of 'RAM'


		end
