
const NUM_WAVBUFFERS = 16;

const MAXWQSIZE = 32;
const MAXDSPIECE = (40000*4/20);

HWAVEOUT hwo = 0;
WAVEHDR wq[MAXWQSIZE];
unsigned char wbuffer[MAXWQSIZE*MAXDSPIECE];
unsigned wqhead, wqtail;


void wav_start()
{
   WAVEFORMATEX wf = { 0 };
   wf.wFormatTag = WAVE_FORMAT_PCM;
   wf.nSamplesPerSec = SND_FQ;
   wf.nChannels = 2; wf.wBitsPerSample = 16; wf.nBlockAlign = 4;
   wf.nAvgBytesPerSec = wf.nSamplesPerSec * wf.nBlockAlign;

   waveOutOpen(&hwo, WAVE_MAPPER, &wf, 0, 0, CALLBACK_NULL);
   wqhead = 0, wqtail = 0;
}

void wav_play(SNDSAMPLE *buf, unsigned nsamples)
{
   unsigned spbsize = nsamples * sizeof(SNDSAMPLE);

   for (;;) {
      while ((wqtail != wqhead) && (wq[wqtail].dwFlags & WHDR_DONE)) {
         waveOutUnprepareHeader(hwo, &wq[wqtail], sizeof(WAVEHDR));
         if (++wqtail == NUM_WAVBUFFERS) wqtail = 0;
      }
      if ((wqhead+1)%NUM_WAVBUFFERS != wqtail) break;
      Sleep(10);
   }

   // put new item and play
   LPSTR bfpos = (LPSTR)(wbuffer + wqhead*MAXDSPIECE);
   memcpy(bfpos, buf, spbsize);
   wq[wqhead].lpData = bfpos;
   wq[wqhead].dwBufferLength = spbsize;
   wq[wqhead].dwFlags = 0;
   waveOutPrepareHeader(hwo, &wq[wqhead], sizeof(WAVEHDR));
   waveOutWrite(hwo, &wq[wqhead], sizeof(WAVEHDR));
   if (++wqhead == NUM_WAVBUFFERS) wqhead = 0;
}

void wav_stop()
{
   waveOutReset(hwo);
   waveOutClose(hwo);
}
