/*
   sound resampling core for Unreal Speccy project
   created under public domain license by SMT, jan.2006
*/

#ifndef _SNDRENDER_H_INCLUDED
#define _SNDRENDER_H_INCLUDED

// if GNU C++ is used, define data types...
#ifdef __GNUC__
#include <stdint.h>
#define __int64 uint64_t
#define DWORD uint32_t
#define WORD uint16_t
#define HANDLE_PRAGMA_PACK_PUSH_POP
#endif

union SNDSAMPLE;
struct SNDOUT;

const int SNDR_DEFAULT_SYSTICK_RATE = 3500000; // ZX-Spectrum Z80 clock
const int SNDR_DEFAULT_SAMPLE_RATE = 44100;

#ifdef SND_EXTERNAL_BUFFER
 typedef unsigned bufptr_t;
#else
 typedef SNDSAMPLE *bufptr_t;
#endif

class SNDRENDER
{
 public:

   void set_timings(unsigned clock_rate, unsigned sample_rate);

   // 'render' is a function that converts array of DAC inputs into PCM-buffer
   unsigned render(SNDOUT *src, unsigned srclen, unsigned clk_ticks, bufptr_t dst);

   // set of functions that fills buffer in emulation progress
   void start_frame(bufptr_t dst);
   void update(unsigned timestamp, unsigned l, unsigned r);
   unsigned end_frame(unsigned clk_ticks);

   SNDRENDER();

 protected:

   unsigned mix_l, mix_r;

 private:

   unsigned tick, base_tick;
   unsigned s1_l, s1_r;
   unsigned s2_l, s2_r;

   unsigned mult_const;

   bufptr_t dstpos, dst_start;
   __int64 passed_clk_ticks, passed_snd_ticks;

   void flush(unsigned endtick);
};


union SNDSAMPLE
{
   DWORD sample; // left/right channels in low/high WORDs
   struct rl { WORD left, right; }; // or left/right separately
};

struct SNDOUT
{
   unsigned timestamp; // in 'system clock' ticks
   SNDSAMPLE newvalue;
};

#endif // _SNDRENDER_H_INCLUDED
