#define OS_LINUX
//#define OS_WINDOWS

#ifdef OS_WINDOWS
#include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include "sndrender/sndrender.cpp"
#include "sndrender/sndchip.cpp"

const unsigned Z80_FQ = 3500000;
const unsigned SND_FQ = 44100; //48000;

#include "unlzh.cpp"
#include "vtx.cpp"
#include "wavplay.cpp"

SNDSAMPLE outbuf[2000];

int main(int argc, char **argv)
{
   if (argc < 2) { printf("need an input .vtx filename\n"); return(1); }
   //if (!load_vtx(argv[1])) { printf("can't load <%s>\n", argv[1]); return(1); }

   //FILE *dst = fopen("wave.raw", "wb");

   SNDCHIP ch;

   for(int file=1;file<argc;file++)
   {   
	if (!load_vtx(argv[file])) { printf("can't load <%s>\n", argv[1]); continue; }   
	// this setup can be safely ignored (defaults in SNDCHIP constructor)
	setup_from_vtx(ch);
   
	wav_start();

	unsigned time = vtxlen / (14*hdr.intfq);
	printf("playtime %d:%02d\n", time / 60, time % 60);

	for (unsigned x = 0; x < vtxlen; x += 14) {

		//if ( !(x % 16) ) {
			unsigned time = x / (14*hdr.intfq), prc = (unsigned) ((uint64_t)x*1000/vtxlen);
			printf("%d:%02d (%d.%d%%)\t\r", time / 60, time % 60, prc/10, prc%10);
		//}

		AYOUT regsout[16]; unsigned nwrites = 0;
		for (int reg = 0; reg < 14; reg++) {
			if (reg == 13 && vtx[x+reg] == 0xFF) continue;
			regsout[nwrites].timestamp = 0;
			regsout[nwrites].reg_num = reg;
			regsout[nwrites].reg_value = vtx[x+reg];
			nwrites++;
		}
	
		unsigned nsamples = ch.render(regsout, nwrites, Z80_FQ / hdr.intfq, outbuf);
		wav_play(outbuf, nsamples);
		//fwrite(outbuf, 1, nsamples * sizeof(SNDSAMPLE), dst);
	}
	
	wav_stop();
	//fclose(dst);
	printf(" ok\t\t\t\t\n");
   
   }
   
   return(0);
}

#pragma comment(lib, "winmm")
