#define VERSION "0.01"

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <pthread.h>
#include <glib.h>
#include <gtk/gtkwidget.h>

#include "xmms/plugin.h"
#include "xmms/util.h"

const unsigned Z80_FQ = 3500000;
const unsigned SND_FQ = /*48000; */44100;

#include "sndrender/sndrender.cpp"
#include "sndrender/sndchip.cpp"
#include "unlzh.cpp"
#include "vtx.cpp"

static int playing=0;
static int audio_error;
static int end;
static int seek_to;
static pthread_t play_thread;

SNDSAMPLE outbuf[2000];

static SNDCHIP ch;

static int is_our_file(char *filename);
static void play_file(char *filename);
static int get_time(void);
static void pause(short p);
static void seek(int time);
static void stop(void);
static void get_song_info(char *filename, char **title, int *length);
static void about (void);

static InputPlugin vtx_ip =
{
	NULL,
	NULL,
	NULL, /* Description */
	NULL,
	about,
	NULL,
	is_our_file,
	NULL,
	play_file,
	stop,
	pause,
	seek,
	NULL,
	get_time,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	get_song_info,
	NULL,			/* file_info_box */
	NULL
};

static void about (void)
{
	static GtkWidget *box;
	box = xmms_show_message ("About VTXPlay","VTX module palyer, powered by UnrealSpeccy AY/YM engine by SMT.\n"
				"XMMS plugin by Boo_boo.", "Ok", FALSE, NULL, NULL);
}

static void* play_loop(void *arg)
{
	unsigned x = 0;
	AYOUT regsout[16];
	unsigned nwrites;
		
	while(playing)
	{
		if(!end)
		{

			nwrites = 0;
			for (int reg = 0; reg < 14; reg++) {
				if (reg == 13 && vtx[x+reg] == 0xFF) continue;
				regsout[nwrites].timestamp = 0;
				regsout[nwrites].reg_num = reg;
				regsout[nwrites].reg_value = vtx[x+reg];
				nwrites++;
			}
	
			unsigned nsamples = ch.render(regsout, nwrites, Z80_FQ / hdr.intfq, outbuf);
		
			unsigned bufbytes=nsamples * sizeof(SNDSAMPLE);
		
		
			vtx_ip.add_vis_pcm(vtx_ip.output->written_time(),
				    FMT_S16_NE, 2, bufbytes, outbuf);
			while (vtx_ip.output->buffer_free() < bufbytes && playing)
				xmms_usleep(10000);
			if (playing)
				vtx_ip.output->write_audio(outbuf, bufbytes);
		
			x += 14;
			
			if(x >= vtxlen) end=1;
		}
		else
		{
			vtx_ip.output->buffer_free ();
			xmms_usleep(10000);
		}
		
		if (seek_to != -1)
		{
			x = seek_to*50*14;
			vtx_ip.output->flush (seek_to * 1000);
			seek_to = -1;
		}
	}
	
	pthread_exit(NULL);
}

static int is_our_file(char *filename)
{
	int ext;

	ext = strlen(filename)-4;
	if (ext >= 0)
		if (!strcasecmp(&filename[ext], ".vtx"))
				return TRUE;
		
	return FALSE;
}

/*returns vtx playtime in seconds, fills title with "author - songname"*/
static float get_vtx_info(char *filename, char **title)
{
	char c;
	int i=0;
	static char song[0xff]="error getting title :(";
	static char author[0xff]="someone";
	char *out;

	#pragma pack(push,1)
	struct {
		uint16_t sig;
		uint8_t stereomode;
		uint16_t loop;
		uint32_t chipfq;
		uint8_t intfq;
		uint16_t year;
		uint32_t vtxsize;
	} header;
	#pragma pack(pop)
	
	FILE *ff = fopen(filename, "rb");
	if(ff != NULL)
	{
		if(fread(&header,sizeof(header),1,ff))
		{
			for(i=0;(c=fgetc(ff)) && !feof(ff) && i < 0xfe;) {song[i++]=c;}
			song[i]='\0';
			for(i=0;(c=fgetc(ff)) && !feof(ff) && i < 0xfe;) {author[i++]=c;}
			author[i]='\0';
		}
		else
		{
			header.vtxsize=0;
			header.intfq=1;
		}
	}		
	
	fclose(ff);
	
	out=(char *)malloc(strlen(song)+strlen(author)+3+1);
	*out='\0';
	strcpy(out,author);
	strcat(out," - ");
	strcat(out,song);
	
	*title=out;
	
	return(header.vtxsize / (14*header.intfq));
}

static void play_file(char *filename)
{
	audio_error=0;
	end=0;
	char *stitle;
	float time=get_vtx_info(filename,&stitle);	
	
	if (!load_vtx(filename))
	{
		return;
	}
	
	setup_from_vtx(ch);
	
	if (vtx_ip.output->open_audio(FMT_S16_NE, SND_FQ, 2) == 0)
	{
		fprintf(stderr,"vtxplay: open_audio failed!\n");		
		audio_error = 1;
		playing=0;
		return;
	}
	
	vtx_ip.set_info (stitle, (int)(time*1000), 5600, SND_FQ, 2);	
	
	playing=1;
	pthread_create(&play_thread, NULL, play_loop, NULL);
}

static int get_time(void)
{
	if (audio_error)
		return -2;
	if (!playing || (end && !vtx_ip.output->buffer_playing()))
		return -1;

	return vtx_ip.output->output_time();
}

static void pause(short p)
{
	vtx_ip.output->pause(p);
}

static void seek(int time)
{
	if(time > (vtxlen / (14*hdr.intfq))*1000) return;
	seek_to = time;
	end=0;
	
	while (seek_to != -1) xmms_usleep(10000);	
}

static void stop(void)
{
	if(playing)
	{	
		playing=0;
		pthread_join(play_thread, NULL);
		vtx_ip.output->close_audio();
	}
}

static void get_song_info(char *filename, char **title, int *length)
{
	char *stitle;
	float time=get_vtx_info(filename,&stitle);
			
	(*title)=stitle;
	(*length)=(int)(time*1000);
}

extern "C" {
	
InputPlugin *get_iplugin_info(void)
{
	vtx_ip.description = g_strdup_printf ("VtxPlay %s", VERSION);
	return &vtx_ip;
}

}
