#ifdef __GNUC__
#pragma pack(push,1)
#else
#pragma pack(push)
#endif

#pragma pack(1) // envelope period (envT, R13-R14) has invalid word alignment
struct VTXHDR
{
   unsigned short sig;
   unsigned char stereomode;
   unsigned short loop;
   unsigned chipfq;
   unsigned char intfq;
   unsigned short year;
   unsigned vtxsize;
};
#pragma pack(pop)

unsigned char *vtx;
unsigned vtxlen;
VTXHDR hdr;

#if 0 // debug
void saveregs(char *fname)
{
   FILE *ff = fopen(fname, "wb");
   fwrite(vtx, 1, vtxlen, ff);
   fclose(ff);
}
void load_regs(char *fname)
{
   FILE *ff = fopen(fname, "rb");
   fseek(ff, 0, SEEK_END);
   vtxlen = ftell(ff); rewind(ff);
   vtx = (unsigned char*)malloc(vtxlen);
   fread(vtx, 1, vtxlen, ff);
   fclose(ff);
}
#endif

void transpose_vtx()
{
   unsigned nrec = vtxlen / 14;
   unsigned char *newb = (unsigned char*)malloc(nrec*14);

   for (unsigned rec = 0; rec < nrec; rec++)
      for (unsigned j = 0; j < 14; j++)
         newb[rec*14+j] = vtx[j*nrec+rec];

   free(vtx);
   vtx = newb; vtxlen = nrec*14;
}

int load_vtx(char *filename)
{
   vtx = 0; vtxlen = 0;

   FILE *ff = fopen(filename, "rb");
   if (!ff) return 0;
   fseek(ff, 0, SEEK_END);
   unsigned fsize = ftell(ff);
   rewind(ff);

   int readsz = fread(&hdr, 1, sizeof(hdr), ff);
   if (readsz != sizeof(hdr)) { fclose(ff); return 0; }
   if (memcmp(&hdr.sig,"ym",2) && memcmp(&hdr.sig,"ay",2) /*hdr.sig != 'my' && hdr.sig != 'ya'*/) { fclose(ff); return 0; }

   unsigned packed_size = fsize - ftell(ff);
   unsigned char *packed = (unsigned char*)malloc(packed_size);
   fread(packed, 1, packed_size, ff);
   fclose(ff);

   static const char * const fields[] = {
      "Year   ",
      "Title  ",
      "Author ",
      "Program",
      "Tracker",
      "Comment"
   };

   unsigned char *start_packed = packed;

   for (unsigned str = 1; str <= 5; str++) {
      if (*packed) printf("%s - %s\n", fields[str], packed);
      packed += strlen((char*)packed)+1;
   }
   printf("%s - %04d\n", fields[0], hdr.year);

   packed_size -= (packed - start_packed);

   vtxlen = hdr.vtxsize;
   vtx = (unsigned char*)malloc(vtxlen+0x1000);
   printf("depacking %d -> %d ", packed_size, vtxlen);
   decode_buffer(vtx, vtxlen, packed, packed_size);
   printf("ok\n");
   free(start_packed);

   transpose_vtx();
   return 1;
}

void setup_from_vtx(SNDCHIP &ch)
{
   // this setup can be safely ignored (defaults in SNDCHIP constructor)

   ch.set_timings(Z80_FQ, hdr.chipfq, SND_FQ);
   const SNDCHIP_VOLTAB *vt = SNDR_VOL_AY;
   if (!memcmp(&hdr.sig,"ay",2)/*hdr.sig == 'ya'*/) ch.set_chip(SNDCHIP::CHIP_AY), vt = SNDR_VOL_AY;
   if (!memcmp(&hdr.sig,"ym",2)/*hdr.sig == 'my'*/) ch.set_chip(SNDCHIP::CHIP_YM), vt = SNDR_VOL_YM;

   const SNDCHIP_PANTAB *pt = SNDR_PAN_ABC;
   switch (hdr.stereomode)
   {
      case 0:
         pt = SNDR_PAN_MONO;
         break;
      case 1:
         pt = SNDR_PAN_ABC;
         break;
      case 2:
         pt = SNDR_PAN_ACB;
         break;
      case 3:
         pt = SNDR_PAN_BAC;
         break;
      case 4:
         printf("BCA stereo mode not supported, using default\n");
         break;
      case 5:
         printf("CAB stereo mode not supported, using default\n");
         break;
      case 6:
         printf("CBA stereo mode not supported, using default\n");
         break;
      default:
         printf("unknown stereo mode, using default\n");
         break;
   }

   ch.set_volumes(0x7FFF, vt, pt);
}

