#ifdef OS_LINUX
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/soundcard.h>
int audio;
#endif

#ifdef OS_WINDOWS
const NUM_WAVBUFFERS = 16;

const MAXWQSIZE = 32;
const MAXDSPIECE = (40000*4/20);

HWAVEOUT hwo = 0;
WAVEHDR wq[MAXWQSIZE];
unsigned char wbuffer[MAXWQSIZE*MAXDSPIECE];
unsigned wqhead, wqtail;
#endif

void wav_start()
{
#ifdef OS_LINUX	
   int tmp;
	
   audio = open ("/dev/dsp", O_WRONLY/*|O_NONBLOCK*/, 0);
   if (audio == -1)                                                                                
   {                                                                                             
	printf("Unable to open /dev/dsp for writing.\n");
	goto wav_start_fail;
   }
	
   tmp=AFMT_S16_LE;
   if((ioctl(audio,SNDCTL_DSP_SETFMT,&tmp))==-1)
   {
	printf("setting SNDCTL_DSP_SETFMT on audiodev failed\n");
	goto wav_start_fail;
   }
	   
   tmp = 16;                                                                               
   ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &tmp);                                               
   if (tmp != 16)
   {                                                                                               
	printf("Unable set samplesize = %d.\n", tmp);
	goto wav_start_fail;
   }
	
   tmp=1;   
   if (ioctl (audio, SNDCTL_DSP_STEREO, &tmp)==-1)                                          
   {
	printf ("Unable to set stereo.\n");
	goto wav_start_fail;
   }
   
   tmp=SND_FQ;
   if (ioctl (audio, SNDCTL_DSP_SPEED, &tmp) == -1)                                          
   {                                                                                             
	printf ("Unable to set audio speed = %d.\n",SND_FQ);
	goto wav_start_fail;   
   }
   	
#endif	
   
#ifdef OS_WINDOWS	
   WAVEFORMATEX wf = { 0 };
   wf.wFormatTag = WAVE_FORMAT_PCM;
   wf.nSamplesPerSec = SND_FQ;
   wf.nChannels = 2; wf.wBitsPerSample = 16; wf.nBlockAlign = 4;
   wf.nAvgBytesPerSec = wf.nSamplesPerSec * wf.nBlockAlign;

   waveOutOpen(&hwo, WAVE_MAPPER, &wf, 0, 0, CALLBACK_NULL);
   wqhead = 0, wqtail = 0;
#endif

   return;
   
#ifdef OS_LINUX
wav_start_fail:
   close(audio);
   audio=-1;
#endif
}

void wav_play(SNDSAMPLE *buf, unsigned nsamples)
{
   unsigned spbsize = nsamples * sizeof(SNDSAMPLE);

#ifdef OS_LINUX	
   if (audio == -1) return;

   if(write(audio,buf,/*SOUND_TICKS_PER_FRAME*4*/spbsize) != spbsize)
   {
	printf("Write to soundcard device failed\n");
   }
#endif
   
#ifdef OS_WINDOWS	
   for (;;) {
      while ((wqtail != wqhead) && (wq[wqtail].dwFlags & WHDR_DONE)) {
         waveOutUnprepareHeader(hwo, &wq[wqtail], sizeof(WAVEHDR));
         if (++wqtail == NUM_WAVBUFFERS) wqtail = 0;
      }
      if ((wqhead+1)%NUM_WAVBUFFERS != wqtail) break;
      Sleep(10);
   }

   // put new item and play
   LPSTR bfpos = (LPSTR)(wbuffer + wqhead*MAXDSPIECE);
   memcpy(bfpos, buf, spbsize);
   wq[wqhead].lpData = bfpos;
   wq[wqhead].dwBufferLength = spbsize;
   wq[wqhead].dwFlags = 0;
   waveOutPrepareHeader(hwo, &wq[wqhead], sizeof(WAVEHDR));
   waveOutWrite(hwo, &wq[wqhead], sizeof(WAVEHDR));
   if (++wqhead == NUM_WAVBUFFERS) wqhead = 0;
#endif	   
}


void wav_stop()
{
#ifdef OS_LINUX
   close(audio);	
#endif
#ifdef OS_WINDOWS
   waveOutReset(hwo);
   waveOutClose(hwo);
#endif	
}
