
;XTR-MODEM  NULL-  PC

        MAKE "Mdriver",#C000

        JP INST
        JP NAME
        JP STAT
        JP INIT
        JP SCAN
        JP LWAIT
        JP TX
        JP HUP
        JP HDR
        JP DIAL
        JP AON
        JP CONA
        JP CONP

        JP D_SET_TIME
        JP D_RD_TIME
        JP D_OFF_DRV
        JP D_SET_ALR
        JP D_ADD_ALR
        JP D_RD_ALR
;*****************************

TXTI
  DB "     XTR-modem driver v1.23 and CMOS"
  DB 13
  DB  "       (C) 1997 -=LD=-  1998 *MAS*"
  DB 0

ETXTI
TBAU    DB " 600 ","1800 ","2400 "
        DB " -PC-"
        DS 4*5
ETBAU
;*****************************

; PC-
; .  
; CY=0  [A]=1  - 

SCAN_PC IN A,(#1F): AND 3: JR Z,PCL_PAS
        CP 2: SCF: RET NZ
PCL_ACT LD A,2: LD (PCLINK),A
        OUT (#DD),A: SCF: RET

PCL_PAS LD A,(PCLINK): OR A: SCF: RET Z
       XOR A: LD (PCLINK),A: OUT (#DD),A
; 

        LD A,3: LD (BAUD),A
        CALL PC_IN: RET C
        CP #AA: SCF: RET NZ
          CALL PC_IN: RET C
          CP #55: SCF: RET NZ
        CALL PC_IN: RET C: LD C,A
        CALL PC_IN: RET C: LD B,A
        LD (BLEN),BC
        LD HL,(ABUF)
PC_IND CALL PC_IN: RET C
       LD (HL),A: INC HL
       DEC BC: LD A,B: OR C: JP NZ,PC_IND
       LD BC,(BLEN)
       LD A,(BAUD): LD D,A
       XOR A: INC A
       RET
;************************************

;     [BC]
; (ABUF)   

PC_TRANS CALL PCWAIT_0: RET C
        LD A,2: OUT (#DD),A
        CALL PCWAIT_1
        LD A,0: OUT (#DD),A
        RET C
        LD A,#AA: CALL PC_OUT: RET C
        LD A,#55: CALL PC_OUT: RET C
        LD A,C: CALL PC_OUT: RET C
        LD A,B: CALL PC_OUT: RET C
        LD HL,(ABUF)
PC_OUTD LD A,(HL): CALL PC_OUT: RET C
        INC HL: DEC BC
        LD A,B: OR C: JR NZ,PC_OUTD
        OR A: RET

PC_OUT  EXX: LD B,8: LD C,A
PC_OUT1 CALL PCWAIT_0: RET C
        LD A,1: RL C: RLA: OUT (#DD),A
        CALL PCWAIT_1
        LD A,0: OUT (#DD),A
        RET C
        DJNZ PC_OUT1
        EXX: OR A: RET
;-------------------------------

PC_IN   EXX: LD B,8
PC_IN1  CALL PCWAIT_1: RET C
        IN A,(#1F): RRA: RL C
        LD A,2: OUT (#DD),A
        CALL PCWAIT_0
        LD A,0: OUT (#DD),A
        RET C
        DJNZ PC_IN1
        LD A,C: EXX: OR A: RET

PCWAIT_0 LD DE,300
PCWAIT0 IN A,(#1F): AND 2: RET Z
        DEC DE
        LD A,D: OR E: JP NZ,PCWAIT0
        SCF: RET

PCWAIT_1 LD DE,300
PCWAIT1 IN A,(#1F): AND 2: RET NZ
        DEC DE
        LD A,D: OR E: JP NZ,PCWAIT1
        SCF: RET

;*****************************

SET_REG LD A,C: LD BC,#FFF9
OUT_D   LD HL,#3FF0: PUSH HL: JP #3D2F
IN_D    LD HL,#3FF3: PUSH HL: JP #3D2F

OUT_C  PUSH HL: PUSH AF: CALL SET_REG
       POP AF: LD BC,#FF79
       CALL OUT_D: POP HL: RET

IN_C  PUSH HL: CALL SET_REG: LD BC,#FF79
      CALL IN_D: POP HL: RET

;********************************
; 
;[H]-[L]-[D]-[B]-[C]-[E]-[A]
;            
D_SET_TIME RET
;-------------------------

; 
;[H]-[L]-[D]-[B]-[C]-[E]-[A]
;            
D_RD_TIME RET
;-------------------------

; 
D_OFF_DRV  RET
;-------------------------

;   [A] 
D_ADD_ALR RET
;-------------------------

;   [A] 
D_SET_ALR RET
;*************************************

;  , CY=1
;[A] -   
D_RD_ALR XOR A: RET
;**********************************

; . HL-
INST    RET C
        LD (ABUF),HL
        EX DE,HL
        LD HL,TBAU
        LD BC,ETBAU-TBAU
        LDIR
INST0   XOR A
        OUT (#B7),A
        LD (DPORT),A
        DI
        PUSH IX : PUSH IY
        CALL DPCAON
        POP IY  : POP IX
        LD A,#C9
        LD (INST0),A
        RET

NAME    LD DE,(ABUF)
        LD HL,TXTI
        LD BC,ETXTI-TXTI
        LDIR
        RET

;*****************************

;   
INIT    AND #0F
        LD (SOUND),A
        JR Z,INIT1
        LD BC,#FFFD:LD A,7:OUT (C),A
        LD B,#BF :LD A,#3E:OUT (C),A
        LD B,#FF   :XOR A :OUT (C),A
        LD B,#BF          :OUT (C),A
        LD B,#FF   :INC A :OUT (C),A
        LD B,#BF   :XOR A :OUT (C),A
INIT1   XOR A
        LD (BEEP),A
        LD H,A : LD L,A
        LD (TIME0),HL
        LD (TIME1),HL
        LD (TIME2),HL
;
        LD (PCLINK),A: OUT (#DD),A
        RET
;**********************************

;  
SCAN    DI
        CALL SCAN_PC: RET NC
        PUSH IX : PUSH IY
        CALL SC0
        POP IY  : POP IX
        RET NC
        LD C,111
        RET

SC0     LD A,(DPORT)
        AND 2: JP Z,SC11
        CALL SC16
        JR C,SC1
        CP 2
        JR Z,SC1   ; BEEP, NC
        CALL INIT1 ; BLOCK
        XOR A
        INC A
        RET

SC1     LD BC,(TIME)
        EX AF,AF
        SRL B : RR C
        PUSH BC
        EX AF,AF
        LD HL,(TIME0)
        LD DE,(TIME1)
        JR C,SC2
        EX DE,HL
        ADD HL,BC
        EX DE,HL
SC2     ADD HL,BC
        LD BC,1562    ; 0.05
        SBC HL,BC     ; NC
        ADD HL,BC
        CALL NC,SC4
        LD (TIME0),HL ; C/NC
        LD (TIME1),DE
        POP HL
        PUSH AF
        RR H : RR L
        RR H : RR L
        LD B,L   ; MAX 110
        POP AF
        RET

SC4     EX DE,HL    ; DE-TOTAL HL-BEEP
        ADD HL,HL
        SBC HL,DE   ; NC-BEEP C-NO BEEP
        RL C
        LD A,(BEEP)
        LD B,A
        XOR C
        RRA
        LD HL,(TIME2)
        JR NC,SC8
        ADD HL,DE
        EX DE,HL    ; DE-TOTAL
        LD HL,18750 ; 0.6
        SBC HL,DE
        CALL C,SC6  ; >0.6
        CCF
        LD (TIME2),DE
SC5     LD HL,0 : LD D,H : LD E,L
        LD A,2
        RET

SC6     XOR A
        BIT 0,C
        JR NZ,SC7   ; PAUSE, NC
        LD HL,46875 ; BEEP
        SBC HL,DE
        RET NC      ; <1.5
        LD A,0
        LD (MBEEP),A ; C
SC7     LD (BEEP),A
        LD DE,0
        RET         ; C/NC

SC8     LD (TIME2),DE ; NC
        EX DE,HL
        LD HL,3750
        SBC HL,DE
        JR NC,SC10    ; <0.12
        LD HL,18750
        SBC HL,DE
        JR C,SC10     ; >0.6
        RR C
        CCF
        RL B
        LD A,B
        CP #55
        JR Z,SC9
        LD (BEEP),A
        SCF : JR SC5

SC9     XOR A
        LD (BEEP),A
        INC A
        LD (MBEEP),A
        LD HL,0
        LD (TIME2),HL
        JR SC5

SC10    LD A,C
        XOR 1
        AND 1
        LD (BEEP),A
        SCF : JR SC5

SC11    XOR A
        OUT (#B7),A
        LD HL,#8081
        LD BC,#FF00
SC12    IN A,(#B7)
        AND L
        CP H
        JR NZ,SC13
        INC C
SC13    DJNZ SC12
        LD HL,(TIME0)
        ADD HL,BC
        LD DE,(TIME1)
        INC D
        LD A,D
        CP 12
        LD D,A
        CALL Z,SC14
        LD (TIME1),DE
        LD (TIME0),HL
        LD B,65
        RET           ; C/NC

SC14    LD BC,3060/6
        SBC HL,BC     ; NC-RING
        CCF
        RL E
        LD A,E
        CP #F0
        LD D,0 : LD H,D : LD L,D
        SCF
        RET NZ
        XOR A
        LD E,A
        LD A,3
        RET      ; NC

SC16    LD A,(SOUND)
        OR A
        JR Z,SC17
        LD D,A:LD E,0
        LD BC,#FFFD
        LD A,8:OUT (C),A
        LD B,#BF
        JR SC18

SC17    LD A,(BORDER):LD D,A:LD E,A
        LD C,#FE
SC18    EXX
        LD BC,#0400
        LD H,C:LD L,C:LD D,C:LD E,C
        EXX
        LD A,#83
        OUT (#B7),A
        LD L,2
        IN A,(#B7):LD H,A:RRA
        JR NC,SC19
        LD A,D:LD D,E:LD E,A
SC19    OUT (C),D
SC20    IN A,(#B7):INC L:JP M,SC24A
        XOR H: RRA:JR NC,SC20
        IN A,(#B7):INC L
        LD H,A
        LD A,L
        EXX
        LD C,A
        IN A,(#B7)
        EXX
SC21    OUT (C),E
        LD L,2
SC22    IN A,(#B7):INC L:JP M,SC24A
        XOR H: RRA:JR NC,SC22
        IN A,(#B7):INC L:OUT (C),D
SC23    IN A,(#B7):INC L:JR Z,SC24A
        XOR H: RRA:JR C,SC23
SC24    LD A,L
        EX AF,AF
        IN A,(#B7)
        EXX
        EX AF,AF
        LD D,E:LD E,H:LD H,L:LD L,A
        DEC B
        EXX
        IN A,(#B7)
        JR NZ,SC21
        OUT (C),E
        JR SC24B

SC24A   EXX:LD B,1:EXX
        LD A,L:OR A
        SCF
        JR NZ,SC24
        DEC L:JR SC24

SC24B   PUSH AF
        EXX
        LD A,C
        EX AF,AF
        LD A,H
        ADD A,L:JR NC,$+3:INC B
        ADD A,D:JR NC,$+3:INC B
        ADD A,E:JR NC,$+3:INC B
        LD C,A
        PUSH BC
        EX AF,AF
        ADD A,C:JR NC,$+3:INC B
        LD C,A
        LD (TIME),BC
        POP BC
        POP AF
        RET C
        PUSH BC
        RR B:RR C
        RR B:RR C:JR NC,$+3:INC C
        LD A,C
        SRL A : SRL A
        LD B,A
SC25    LD A,D:LD D,E:LD E,H:LD H,L
        LD L,#00
        SUB C : JR NC,SC26
        NEG
SC26    CP B
        JR NC,SC27
        INC D
        DEC D
        JR NZ,SC25
SC27    POP DE
        CCF : RET C
        LD IX,TBSCAN-3
        LD BC,3
SC28    ADD IX,BC
        LD L,(IX+0)
        LD H,(IX+1)
        OR A : SBC HL,DE
        JR C,SC28
        LD A,(IX+2)
        OR A
        JP P,SC29
        CP #FF
        LD A,2
        RET ; C/NC

SC29    CP 3
        CCF
        RET C
        LD (BAUD),A
        DEC A
        JP M,RXL
        LD C,A
        ADD A,A
        ADD A,C
        ADD A,A  ; *6
        LD E,A
        LD D,0
        LD HL,TBRX
        ADD HL,DE
        LD D,(HL) : INC HL
        LD E,(HL) : INC HL
        LD C,(HL) : INC HL
        PUSH HL
        EXX
        POP HL
        LD D,(HL) : INC HL
        LD E,(HL) : INC HL
        LD C,(HL)
        EXX
        LD A,#83
        OUT (#B7),A
        IN A,(#B7)
        LD H,A
        LD A,D : ADD A,E : ADD A,C
        LD B,A
SC30    IN A,(#B7):XOR H:RRA:JR C,SC31
        DJNZ SC30
        SCF : RET

SC31    IN A,(#B7)
        LD H,A
        LD L,2
SC32    LD B,D
SC33    IN A,(#B7):XOR H:RRA:RET C
        DJNZ SC33
        LD B,E
SC34    IN A,(#B7):XOR H:RRA:JR C,SC31
        DJNZ SC34
        LD B,C
SC35    IN A,(#B7):XOR H:RRA:JR C,SC36
        DJNZ SC35
        SCF : RET

SC36    DEC L
        IN A,(#B7)
        LD H,A
        JR NZ,SC32
        LD HL,(ABUF)
        EXX
        IN A,(#B7)
        LD H,A
        EXX
        LD DE,#0303
        JP SC38

SC37    IN A,(#B7):NOP:NOP
SC38    IN A,(#B7):INC HL
        IN A,(#B7):DEC HL
SC39    EXX
SC40    LD B,D
SC41    IN A,(#B7):XOR H:RRA:JR C,SC46
        DJNZ SC41
        LD B,E
SC42    IN A,(#B7):XOR H:RRA:JR C,SC48
        DJNZ SC42
        LD B,C
SC43    IN A,(#B7):XOR H:RRA:JR C,SC50
        DJNZ SC43
SC44    SCF : RET

SC45    IN A,(#B7):XOR H:RRA:JR NC,SC44
SC46    DJNZ SC45
        LD B,E
SC47    IN A,(#B7):XOR H:RRA:JR NC,SC52
SC48    DJNZ SC47
        LD B,C
SC49    IN A,(#B7):XOR H:RRA:JR NC,SC51
SC50    DJNZ SC49
        SCF : RET

SC51    SCF
SC52    EXX
        RL E : IN A,(#B7) :  JR NC,SC37
        DEC D: JP P,SC53
        INC D
        LD (HL),E
        IN A,(#B7)
        INC HL
        DEC BC : LD A,B : OR C
        JR NZ,SC56

RXEND   LD BC,(BLEN)
        LD A,(BAUD)
        LD D,A
        XOR A
        INC A
        RET

SC53    JP Z,SC55
        IN A,(#B7)
        LD A,D: DEC A: JR Z,SC57
        LD A,E: CP #AA
        IN A,(#B7)
        JR Z,SC58
SC54    SCF : RET

SC55    IN A,(#B7)
        LD C,E
        LD (BLEN),BC
        LD A,B: OR C: JR Z,SC54
SC56    IN A,(#B7)
        JR SC58

SC57    LD B,0
        IN A,(#B7)
        LD A,E: CP 8: JR NZ,SC58
        INC B
SC58    LD E,#01
        IN A,(#B7)
        JP SC39

RXL     LD A,#83:OUT (#B7),A
        IN A,(#B7)
        LD H,A
        LD B,20
RXL1    IN A,(#B7):XOR H:RRA:JR C,RXL3
        DJNZ RXL1
RXL2    SCF:RET

RXL3    IN A,(#B7)
        LD H,A
        LD L,2
RXL4    LD B,9
RXL5    IN A,(#B7):XOR H:RRA:JR C,RXL2
        DJNZ RXL5
        LD B,13
RXL6    IN A,(#B7):XOR H:RRA:JR C,RXL3
        DJNZ RXL6
        LD B,12
RXL7    IN A,(#B7):XOR H:RRA:JR C,RXL8
        DJNZ RXL7
        SCF:RET

RXL8    DEC L
        IN A,(#B7)
        LD H,A
        JR NZ,RXL4
        LD HL,(ABUF)
        EXX
        IN A,(#B7)
        LD H,A
        EXX
        LD DE,#0303
RXL9    IN A,(#B7):NOP:NOP
RXL11   EXX
RXL12   LD B,7
RXL13   IN A,(#B7):XOR H:RRA:JR C,RXL14
        DJNZ RXL13
        LD B,25
RXL10   IN A,(#B7):XOR H:RRA:JR C,RXL15
        DJNZ RXL10
RXL14   SCF:RET

RXL15   LD B,10
RXL16   IN A,(#B7):XOR H:RRA:JR NC,RXL14
        DJNZ RXL16
        LD B,25
RXL17   IN A,(#B7):XOR H:RRA:JR NC,RXL18
        DJNZ RXL17
        SCF:RET

RXL18   LD B,20
RXL19   IN A,(#B7):XOR H:RRA:JR C,RXL23
        DJNZ RXL19
        LD B,23
RXL20   IN A,(#B7):XOR H:RRA:JR C,RXL25
        DJNZ RXL20
        LD B,22
RXL21   IN A,(#B7):XOR H:RRA:JR C,RXL27
        DJNZ RXL21
        SCF:RET

RXL22   IN A,(#B7):XOR H:RRA:JR NC,RXL14
RXL23   DJNZ RXL22
        LD B,23
RXL24   IN A,(#B7):XOR H:RRA:JR NC,RXL29
RXL25   DJNZ RXL24
        LD B,22
RXL26   IN A,(#B7):XOR H:RRA:JR NC,RXL28
RXL27   DJNZ RXL26
        SCF:RET

RXL28   SCF
RXL29   EXX
        RL E
        IN A,(#B7)
        JR NC,RXL9
        DEC D
        JP P,RXL30
        INC D
        LD (HL),E
        IN A,(#B7)
        INC HL
        DEC BC : LD A,B : OR C
        JR NZ,RXL32
        JP RXEND

RXL30   JP Z,RXL31
        IN A,(#B7)
        LD A,D
        DEC A
        JR Z,RXL33
        LD A,E
        CP #AA
        IN A,(#B7)
        JR Z,RXL34
        SCF:RET

RXL31   IN A,(#B7
        LD C,E
        LD (BLEN),BC
RXL32   IN A,(#B7)
        JR RXL34

RXL33   LD B,0
        IN A,(#B7)
        LD A,E
        CP 8
        JR NZ,RXL34
        INC B
RXL34   LD E,#01
        IN A,(#B7)
        JP RXL11

;N=250000/F

TBSCAN  DW 83  : DB #80 ; 3012 Hz
        DW 91  : DB 2   ; 2747 Hz
        DW 98  : DB #80 ; 2551 Hz
        DW 109 : DB 1   ; 2294 Hz
        DW 128 : DB #80 ; 1953 Hz
        DW 156 : DB 0   ; 1603 Hz
        DW 455 : DB #80 ;  550 Hz
        DW 735 : DB #FF ;  340 Hz
        DW 0-1 : DB #80

TBRX    DB 6,9,9     ; 1800
        DB 12,17,17

        DB 6,6,6     ; 2400
        DB 10,13,13

;**********************************
;  , 2 

LWAIT   CALL INIT1
        LD D,#80
        CALL LW0
        RET C
        CP 1
        RET Z
        SCF
        RET

LW0     LD E,#00
LW1     CALL BREAK0: LD A,2: CCF: RET C
      PUSH DE: CALL SCAN: POP DE: RET NC
      LD A,E: ADD A,B: SUB C: JR NC,LW2
        ADD A,C
LW2     LD E,A
        JR C,LW1
        DEC D: JR NZ,LW1
        LD A,1
        SCF : RET


;********************************
;   MOD_BUFF
; BC-  A-

TX      DI
        LD (BAUD),A
        CP 3: JP Z,PC_TRANS
        LD A,(DPORT)
        BIT 1,A
        RET Z
        PUSH IX : PUSH IY
        PUSH BC
        LD A,#03 : OUT (#B7),A
;        CALL LNFREE
        LD DE,1500
TXW     IN A,(#B7)
        DEC DE: LD A,D: OR E: JR NZ,TXW
        CALL INIT1
        POP BC
        LD A,(BAUD)
        CALL TX0
        LD A,#F3:OUT (#B7),A
        POP IY  : POP IX
        RET

LNFREE  IN A,(#B7):LD H,A
        LD B,18
LNF1    IN A,(#B7):XOR H:RRA:JR C,LNF2
        DJNZ LNF1
        RET

LNF2    LD B,3
LNF3    IN A,(#B7):XOR H:RRA:RET NC
        DJNZ LNF3
        LD B,13
LNF4    IN A,(#B7):XOR H:RRA
        JR NC,LNFREE
        DJNZ LNF4
        RET

TX0     LD (BAUD),A
        DEC A: JP M,TXL
        EXX
        LD E,A
        ADD A,A: ADD A,A: ADD A,E
        LD E,A: LD D,0
        LD HL,TBAUD
        ADD HL,DE
        LD B,2
TX1     LD E,(HL) : INC HL
        LD D,(HL) : INC HL
        DEC D
        LD A,E
        ADD A,A : RL D
        ADD A,A : RL D
        LD A,E
        RRA: RRA: AND #0F: LD C,A
        RRA     ; ! NC
        ADD A,8
        NEG
        RLCA: RLCA: RLCA: RLCA
        LD E,A
        LD A,C: SRL A: ADC A,8
        NEG: AND E: LD E,A
        PUSH DE
        DJNZ TX1
        LD A,(HL)
        POP HL
        POP DE
        EXX
        ADD A,3
        LD D,A
        LD IX,(ABUF)
TX2     DEC D: JP M,TX3    ; INFO
        IN A,(#B7)
        JR Z,TX4    ; LEN l
        LD A,D: DEC A: JR Z,TX6  ; LEN h
        LD E,#AA
        DEC A: JR Z,TX7    ; #AA
        LD E,0
        JR TX7

TX3     IN A,(#B7)
        INC D
        LD E,(IX)
        INC IX
        JR TX8

TX4     LD E,C
        JR TX7

TX5     LD L,#02
        IN A,(#B7)
        JR TX9

TX5A    RL E
        LD L,#03
        IN A,(#B7)
        JR TX9

TX6     LD A,B
        ADD A,7
        LD E,A
TX7     INC BC
TX8     LD HL,#0803
TX9     IN A,(#B7)
        BIT 7,E
        LD A,L
        EXX
        JR Z,TX10
        LD B,H
        LD C,L
        JR TX11

TX10    LD B,D
        LD C,E
TX11    OUT (#B7),A
        DJNZ TX11
        LD B,A
        LD A,C: AND #F0: OR B: LD B,A
        LD A,C
        ADD A,A:ADD A,A:ADD A,A:ADD A,A
        LD C,A
        LD A,B: AND #0F: OR C
        OUT (#B7),A
        LD A,B : NOP
        OUT (#B7),A
        AND #0F
        OUT (#B7),A
        EXX
        RRA: JR C,TX5
        DEC H: JR NZ,TX5A
        DEC BC: LD A,B: OR A: RET M
        OR C: JR NZ,TX2
        IN A,(#B7)
        LD E,0
        LD HL,#0203
        LD B,#FF
        JR TX9

TXL     LD IX,(ABUF)
        LD D,5
TXL1    DEC D     ; 78
        IN A,(#B7)
        JP M,TXL3
        JR Z,TXL2 ; L
        LD A,D
        DEC A
        JR Z,TXL4 ; H
        LD E,#AA
        DEC A: JR Z,TXL5
        LD E,0
        JR TXL5

TXL2    LD E,C
        JR TXL5

TXL3    INC D
        LD E,(IX):INC IX
        JR TXL6

TXL4    LD A,B
        ADD A,7
        LD E,A
TXL5    INC BC
TXL6    IN A,(#B7)
        LD H,8
TXL7    RL E : RL L
        LD A,L
        EXX
        RLA:RLA:RLA
        AND #18
        LD L,A:LD H,0
        IN A,(#B7)
        LD BC,TBTXL
        ADD HL,BC
        LD C,3
TXL8    LD E,(HL): INC HL
        LD D,(HL): INC HL
        LD B,D: LD D,E
        RL D: RL B
        IN A,(#B7)
        LD A,B
        RL D: RLA : RL D: RLA
        SUB 7: LD B,A
        LD A,E: RRA: AND #0F: LD D,A
        RRA     ; ! NC
        ADD A,8
        LD E,A
        IN A,(#B7)
        LD A,E
        NEG
        ADD A,A:ADD A,A:ADD A,A:ADD A,A
        OR C:OR 2
        LD E,A
        LD A,D: SRL A: ADC A,8: LD D,A
        IN A,(#B7)
        LD A,D: NEG
        ADD A,A:ADD A,A:ADD A,A:ADD A,A
        OR C:OR 2
        LD D,A
        AND #03
TXL9    OUT (#B7),A:DJNZ TXL9
        LD A,D:OUT (#B7),A:NOP
        LD A,E:OUT (#B7),A
        AND #03         :OUT (#B7),A
        DEC C : JP M,TXL10
        IN A,(#B7):INC HL
        IN A,(#B7):DEC HL
        IN A,(#B7)
        JR TXL8

TXL10   EXX
        DEC H : JR Z,TXL11
        IN A,(#B7):LD A,0
TXL10A  IN A,(#B7)
        JP TXL7

TXL11   LD A,B:OR A:RET M
        DEC BC:LD A,B:OR C:JP NZ,TXL1
        IN A,(#B7)
        LD E,0:LD H,2
        LD B,#FF
        JR TXL10A

; / 0
; / 1
;    
; 1800   2429/1516 Hz *MAS*
; 2400   2876/1880 Hz *MAS*

TBAUD   DW 412,660   ; 1800
        DB 5
        DW 347,532   ; 2400
        DB 8

; /
;  ,    
;   
;      00,01,10,11

TBTXL   DW 280,280,280,280
        DW 280,316,360,412
        DW 412,360,316,280
        DW 412,412,412,412

;**********************************
;  

STAT    LD C,A
        LD (BORDER),A
        LD A,(DPORT)
        RRA
        AND 1
OR_STAT EQU $+1: OR %00100000
        LD B,A
        LD A,C
        RET

;*************************************
;  

HUP     LD A,#F3
HUP1    LD (DPORT),A
        OUT (#B7),A
        CALL INIT1
        RET

;*************************************
;  

HDR     LD A,#F0
        JR HUP1


;*************************************
;  

DIAL    DI
        PUSH IX : PUSH IY
        CALL DIAL0
        POP IY  : POP IX
        RET

DIAL0   LD (USPD),SP
        PUSH HL
        PUSH BC
        PUSH AF
        CALL HUP
        LD D,0
        CALL LW0
        POP DE
        POP BC
        POP HL
        RET C    ; NO BEEP OR BREAK
        CP 2
        JR Z,DIAL1
        XOR A
        SCF
        RET      ; BLOCK OR DIAL

DIAL1   LD A,(MBEEP)
        OR A
        SCF
        RET NZ   ; BUSY
        PUSH HL  ; O.K.
        SRL C
        LD L,B
        LD H,0
        ADD HL,HL    ; *2
        LD D,H
        LD E,L
        ADD HL,HL    ; *4
        ADD HL,HL    ; *8
        ADD HL,DE    ; *10
        LD A,H
        LD D,4
DIAL6   RRA
        RR L
        DEC D
        JR NZ,DIAL6  ; *10/16=.625
        LD D,L       ; D=N*.6
        LD A,B
        SUB D
        LD E,A       ; E=N*.4
        POP HL
DIAL7   LD A,(HL)
        OR A
        JR Z,DIAL10
        INC HL
        CP "-"
        JR Z,DIAL7
        SUB #30
        JR NZ,DIAL8
        LD A,10
DIAL8   LD B,A
        LD A,#02 : OUT (#B7),A
        CALL WAIT2
DIAL9   XOR A    : OUT (#B7),A
        LD A,D
        CALL WAIT5
        IN A,(#B7) : RLA : JR NC,DIALERR
        LD A,#02 : OUT (#B7),A
        LD A,E
        CALL WAIT5
        IN A,(#B7) : RLA : JR C,DIALERR
        CALL BREAK
        DJNZ DIAL9
        CALL WAIT2
        JR DIAL7

DIAL10  LD A,#03 : OUT (#B7),A
        OR A
        RET

DIALERR XOR A
        SCF
        RET

BREAK   CALL BREAK0
        RET C
        LD SP,(USPD)
        SCF
        LD A,2
        RET

BREAK0  LD A,#7F
        IN A,(#FE)
        RRA
        RET C
        LD A,#FE
        IN A,(#FE)
        RRA
        RET

WAIT    LD B,31      ; .001
WAIT1   IN A,(#B7)
        DJNZ WAIT1
        RET

WAIT2   PUSH BC      ; C*10*.001
WAIT3   LD A,10
WAIT4   EX AF,AF
        CALL WAIT
        EX AF,AF
        DEC A
        JR NZ,WAIT4
        DEC C
        JR NZ,WAIT3
        POP BC
        RET

WAIT5   PUSH BC      ; A*.001
        LD C,A
WAIT6   CALL WAIT
        DEC C
        JR NZ,WAIT6
        POP BC
        RET

;*************************************
;   -  ,
;   >  MOD_BUFF

AON     DI
        PUSH IY:PUSH IX
        CALL AON1
        POP IX:POP IY
        RET

AON1    LD (MINK),DE
        LD C,A
        PUSH BC
        LD A,#03:CALL HUP1
        POP BC
        LD A,C
        OR A
        JR NZ,AON2B
        LD HL,(ABUF)
        LD (HL),A
        RET

AON2B   LD (MAXREQ),A
AON2    LD D,30
AON2A   IN A,(#B7):DEC D:JR NZ,AON2A
        DJNZ AON2
        LD C,0
AON3    PUSH BC
        CALL REQ
        POP BC
        INC C
        LD B,10:LD L,#FF
AON4    PUSH HL
        PUSH BC
        CALL KORRAON
        POP BC
        POP HL
        CP #0C
        JR Z,AON5
        CP L
        JR NZ,AON5
        CP H
        JR Z,AON6
AON5    LD H,L:LD L,A
        DJNZ AON4
        LD A,(MAXREQ)
        CP C
        JR NZ,AON3
        LD HL,(AEDPC)
        JR AON7

AON6    LD HL,(AEDPC)
        LD (HL),A:INC L
        LD (HL),A:INC L
        LD (HL),A:INC L
AON7    LD A,C
        LD (NREQ),A
        LD A,(MINK)
        LD (MINKAON),A
AON8    PUSH HL
        CALL KORRAON
        POP HL
        LD (HL),A
        INC L
        JP P,AON8
        LD BC,#080C
AON9    LD (HL),C:INC L:DJNZ AON9
        PUSH HL
        POP IY
        LD C,#FF
        LD DE,0
        LD XH,D
        EXX
        LD HL,(AEDPC)
        LD C,(HL) : INC L
        LD D,(HL) : INC L
        LD E,(HL) : INC L
AON10   LD B,C : LD C,D : LD D,E
        LD E,(HL)
        LD A,C
        CP D
        JR Z,AON14
        LD A,D
        CP E
        JR NZ,AON11
        CP #0C
        JR NZ,AON14
        LD A,B
        CP C
        JR AON12

AON11   LD A,C
        CP B: JR Z,AON14
        CP E: JR NZ,AON13
        CP #0C: JR NZ,AON14
        LD A,B: CP D
AON12   JR Z,AON14
        LD A,#0C
        JR AON14

AON13   LD A,B: CP D: JR Z,AON14
        LD A,#FF
AON14   EXX
        OR A: JP P,AON15
        INC D
        LD A,D: CP 3: JR C,AON19
        JR AON16

AON15   CP #0C: JR NZ,AON17
        INC E
        LD A,E: CP 5: JR NZ,AON16
        LD C,#FF
AON16   LD A,#0C
AON17   CP C: JR Z,AON18
        LD (IY),A
        LD C,A
        CP #0B: JR NZ,AON18A
        LD A,XH
        CP 2: JR Z,AON18A
        INC XH
        PUSH IY
AON18A  INC IY
        LD E,0
AON18   LD D,0
AON19   EXX
        INC L: JP P,AON10
        LD BC,#080C
        LD HL,BUFNUM
AON20   LD (IY),C:INC IY
        LD (HL),C:INC HL
        DJNZ AON20
        DEC XH: JP M,AON33
        POP DE
        LD H,D: LD L,E
        JR Z,AON21
        POP DE
AON21   OR A: SBC HL,DE
        LD A,L
        ADD HL,DE
        CP 9
        LD C,2
        JR Z,AON22
        DEC C
        PUSH DE:PUSH DE
        JR AON23

AON22   PUSH HL: PUSH DE: PUSH HL
AON23   POP HL
        LD DE,BUFNUM
        LD B,8
AON24   DEC HL: LD A,(DE)
        CP #0C: JR NZ,AON25
        LD A,(HL): LD (DE),A
AON25   INC DE: DJNZ AON24
        DEC C: JR NZ,AON23

        POP HL:INC HL
        LD DE,BUFNUM+8
        LD B,8
AON26   DEC DE: LD A,(DE)
        CP #0C: JR NZ,AON27
        LD A,(HL): LD (DE),A
AON27   INC HL: DJNZ AON26

        EX DE,HL
        LD BC,#080C
AON28   LD A,(HL): CP #0A: JR NZ,AON29
        LD (HL),C: LD A,C
AON29   LD C,A: INC HL: DJNZ AON28

        LD DE,(ABUF)
        LD IX,BUFNUM
;
        LD B,3: CALL AON30
        LD A,"-": LD (DE),A: INC DE
        LD B,2: CALL AON30
        LD A,"-": LD (DE),A: INC DE
        LD B,2: CALL AON30

        LD A," ": LD (DE),A: INC DE
;
        LD B,1: CALL AON30
        JR AON34

AON30   LD A,(IX):INC IX
        CP #0C: JR NZ,AON31
        LD A,"?"
        JR AON32

AON31   ADD A,"0"
AON32   LD (DE),A:INC DE
        DJNZ AON30
        RET

AON33   LD DE,(ABUF)
        LD HL,TXTAERR
        LD BC,TXTAERR1-TXTAERR
        LDIR

;
AON34   LD A," ": LD (DE),A: INC DE
        LD A,(NREQ): LD B,A
        CP 10
        LD C,"?"-"0": LD A,C
        JR C,AON36
        LD A,B
        LD C,#FF
AON35   INC C
        SUB 10: JR NC,AON35
        ADD A,10

AON36   PUSH AF
        LD A,C: ADD A,"0"
        LD (DE),A: INC DE
        LD A," ": LD (DE),A: INC DE
        POP AF
        ADD A,"0": LD (DE),A: INC DE
        XOR A: LD (DE),A
        RET

;TXTA0   DB " "
;TXTA1   DB " ."
;TXTA2   DB "   "
;TXTA3   DB "   "
;TXTA4

TXTAERR DB "???-??-?? ? ?",0
TXTAERR1

REQ     LD C,#B7
        LD A,6
        LD HL,(RUNREQ)
        PUSH HL
        LD HL,(ADREQ)
        RET

KORRAON LD HL,(ADAON)
        CALL KORR
        LD A,(MINKAON)
        CP L
        JR NC,KRAON1
        CP H
        JR NC,KRAON1
        LD A,E
        ADD A,A
        LD E,A
        ADD A,A
        ADD A,E
        ADD A,D
        LD E,A
        LD D,0
        LD HL,TBRCDF
        ADD HL,DE
        LD A,(HL)
        RET

KRAON1  LD A,N
        RET

N       EQU #0C

TBRCDF  DB N,1,2,4,7,N
        DB 1,N,3,5,8,N
        DB 2,3,N,6,9,11
        DB 4,5,6,N,0,10
        DB 7,8,9,0,N,N
        DB N,N,11,10,N,N

;*************************************
; ⠭ ᮥ, ।

CONA    JR CONP

;*************************************
; ⠭ ᮥ, ਥ

CONP    LD DE,(ABUF)
        LD HL,TXTCON
        LD BC,ETXTCON-TXTCON
        LDIR
        LD A,#80 ; 
        RET

TXTCON  DB 13," ⠭",0
ETXTCON

;*************************************


;**********************************
;  

DPCAON  LD HL,BUFDPC
        CALL DPCREQ
        CALL DPCD
        CALL DPCTNB
        CALL DPCTQ
        LD A,L
        OR A
        JR Z,DPCAON1
        LD L,0:INC H
DPCAON1 LD (AEDPC),HL
        RET

DPCREQ  LD (ADREQ),HL
        PUSH HL
        LD IX,TBREQ
        LD B,191
        JR DPCR2

DPCR1   LD A,(IX)
        INC IX
        CALL DPCR4
DPCR2   LD A,(IX)
        RRA
        RRA
        RRA
        RRA
        CALL DPCR4
        DJNZ DPCR1
        LD (RUNREQ),HL
        POP DE
        PUSH HL
        OR A
        SBC HL,DE
        LD B,H
        LD C,L
        ADD HL,DE
        LD (HL),#21 : INC HL
        LD (HL),E   : INC HL
        LD (HL),D   : INC HL
        LD DE,#EDA3
DPCR3   LD (HL),D : INC HL
        LD (HL),E : INC HL
        DEC BC
        LD A,B
        OR C
        JR NZ,DPCR3
        POP DE
        LD (HL),#3D : INC HL
        LD (HL),#C2 : INC HL
        LD (HL),E   : INC HL
        LD (HL),D   : INC HL
        LD (HL),#C9 : INC HL
        RET

DPCR4   AND #0F
        LD E,A
        LD C,3
        ADD A,3
        CALL DPCR5
        LD C,2
        LD A,18
        SUB E
DPCR5   CP 17
        JR C,DPCR6
        SUB 3
        CALL DPCR6
        LD A,3
DPCR6   NEG
        ADD A,16
        ADD A,A
        ADD A,A
        ADD A,A
        ADD A,A
        OR C
        LD (HL),A
        INC HL
        RET

DPCD    LD (ADAON),HL
        LD IX,TBFAON
        LD DE,33*14
        ADD HL,DE
        PUSH HL
        DEC HL
        LD (HL),KR4/256
        DEC HL
        LD (HL),KR4\256
        LD DE,-13
        LD B,32
DPCD1   ADD HL,DE
        LD (HL),KR3/256
        DEC HL
        LD (HL),KR3\256
        DJNZ DPCD1
        DEC HL
        LD DE,14
        EXX
        LD B,12
DPCD2   LD HL,#4000
        BIT 0,B
        JR NZ,DPCD3
        LD H,0
        LD E,(IX) : INC IX
        LD D,(IX) : INC IX
DPCD3   EXX
        PUSH HL
        LD (HL),0
        ADD HL,DE
        LD B,32
DPCD4   LD C,1
DPCD5   EXX
        ADD HL,DE
        LD A,H
        EXX
        RLA
        RL C
        JR NC,DPCD5
        LD (HL),C
        EXX
        LD A,B
        EXX
        CP 12
        JR Z,DPCD6
        INC HL
        LD A,(HL)
        XOR C
        LD (HL),A
        DEC HL
DPCD6   ADD HL,DE
        DJNZ DPCD4
        POP HL
        DEC HL
        EXX
        DJNZ DPCD2
        POP HL
        RET

DPCTNB  LD A,L
        OR A
        JR Z,DPCTN1
        LD L,0
        INC H
DPCTN1  LD (ADRTNB),HL
DPCTN2  XOR A
        LD BC,#0800
DPCTN3  RLC L
        ADC A,C
        DJNZ DPCTN3
        LD (HL),A
        INC L
        JR NZ,DPCTN2
        INC H
        RET

DPCTQ   LD (ATB2),HL ; L=0
DPCTQ1  PUSH HL
        LD H,L
        LD E,L
        LD D,0
        LD L,D
        LD B,8
DPCTQ2  ADD HL,HL
        JR NC,DPCTQ3
        ADD HL,DE
DPCTQ3  DJNZ DPCTQ2
        ADD HL,HL
        BIT 7,L
        JR Z,DPCTQ4
        INC H
DPCTQ4  LD A,H
        POP HL
        LD (HL),A
        INC L
        BIT 7,L
        JR Z,DPCTQ1
        LD (HL),#7F
        INC L
        RET

;N=2.097152*F

TBFAON  DW 3565 ; 1700
        DW 3146 ; 1500
        DW 2726 ; 1300
        DW 2307 ; 1100
        DW 1887 ; 900
        DW 1468 ; 700

;**********************************
;    

KORR    LD (USP),SP
        LD A,#03
        OUT (#B7),A
        LD SP,HL
        LD HL,AKORR
        LD B,6
        XOR A
KR1     LD E,(HL) : INC HL
        LD D,(HL) : INC HL
        LD (DE),A : INC DE : LD (DE),A
        DJNZ KR1
        LD A,(ADRTNB+1)
        LD C,A
        LD B,0
KR2     IN A,(#B7)
        LD H,C
KR3     RRA
        LD A,B
        RL B
        POP DE
        XOR E
        LD L,A
        LD E,(HL)
        XOR D
        LD L,A
        LD D,(HL)
K0      LD HL,0
        EX AF,AF
        IN A,(#B7)
        RRA
        RL B
        EX AF,AF
        ADD HL,DE
        LD (K0+1),HL
        LD H,C
        POP DE
        XOR E
        LD L,A
        LD E,(HL)
        XOR D
        LD L,A
        IN A,(#B7)
        RRA
        RL B
        LD A,L
        LD D,(HL)
K1      LD HL,0
        ADD HL,DE
        LD (K1+1),HL
        LD H,C
        POP DE
        XOR E
        LD L,A
        IN A,(#B7)
        RRA
        RL B
        LD E,(HL)
        LD A,L
        XOR D
        LD L,A
        LD D,(HL)
K2      LD HL,0
        ADD HL,DE
        LD (K2+1),HL
        EX AF,AF
        IN A,(#B7)
        RRA
        EX AF,AF
        LD H,C
        POP DE
        XOR E
        LD L,A
        LD E,(HL)
        XOR D
        LD L,A
        LD D,(HL)
K3      LD HL,0
        ADD HL,DE
        EX AF,AF
        IN A,(#B7)
        RL B
        RRA
        RL B
        EX AF,AF
        LD (K3+1),HL
        LD H,C
        POP DE
        XOR E
        LD L,A
        LD E,(HL)
        XOR D
        LD L,A
        IN A,(#B7)
        RRA
        RL B
        LD D,(HL)
        LD A,L
K4      LD HL,0
        ADD HL,DE
        LD (K4+1),HL
        LD H,C
        POP DE
        XOR E
        LD L,A
        IN A,(#B7)
        RRA
        RL B
        LD E,(HL)
        LD A,L
        XOR D
        LD L,A
        LD D,(HL)
K5      LD HL,0
        ADD HL,DE
        LD (K5+1),HL
        LD H,C
        IN A,(#B7)
        RET

KR4     LD SP,(USP)
        LD IX,AKORR
        LD HL,0
        LD B,0
KR5     PUSH HL
        LD L,(IX) : INC IX
        LD H,(IX) : INC IX
        CALL KR8
        LD C,A
        CALL KR8
        POP HL
        ADD A,C
        CP H
        JR C,KR6
        LD L,H
        LD H,A
        LD E,D
        LD D,B
        JR KR7

KR6     CP L
        JR C,KR7
        LD L,A
        LD E,B
KR7     INC B
        LD A,B
        CP 6
        JR NZ,KR5
        RET

KR8     LD A,(HL) : INC HL
        PUSH HL
        SUB #80
        JP P,KR9
        NEG
KR9     LD L,A
        LD A,(ATB2+1)
        LD H,A
        LD A,(HL)
        POP HL
        RET

AKORR   DW K0+1,K1+1,K2+1
        DW K3+1,K4+1,K5+1

PCLINK  DB 0
MINK    DB 0
MINKAON DB 0
DPORT   DB 0
BAUD    DB 0
MAXREQ  DB 0
NREQ    DB 0
BEEP    DB 0
MBEEP   DB 0
BORDER  DB 0
SOUND   DB 0
ABUF    DW 0
ATB2    DW 0
AEDPC   DW 0
RUNREQ  DW 0
ADREQ   DW 0
ADAON   DW 0
ADMOD   DW 0
ADRTNB  DW 0
USP     DW 0
USPD    DW 0
BLEN    DW 0
TIME    DW 0
TIME0   DW 0
TIME1   DW 0
TIME2   DW 0
BUFNUM  DS 8

TBREQ
       INSERT "500HZ"

BUFDPC




