;     :
;    1/4  2/4
;    3/4  4/4


;     .:
; 7-6 : 00 - , 01 - , 10 -  , 11 -  
; (!!!) 5-4    5   4  
; 3-0 :   

;  .   :
; 7-6 : 01 (64) - , 10 (128) -  , 11 (192) -  
; 5-0 : .

;   -   ,  1  = 1 
;   -      (  )

; 

	ORG	24576

VOFFS           EQU     #20                             ; 24576 -     .   (  0)

BEGLAB          EQU     #7B00                           ; 31488 -   
ENDLAB          EQU     BEGLAB+16383                    ;       ( 1  = 1 )
BEGPOL          EQU     BEGLAB+1282                     ;        
BEGSTO          EQU     3                               ;   

TMIRR	EQU	#7B+#20	;      
TRMASK	EQU	#7B+#21	;      
TLMASK	EQU	#7B+#22	;      
PAL	equ	#7a

;   

PPUSTO	EQU	#00	;0 - 	A
PTRUP		EQU	#01	;1 - 	B
PAPTEK	EQU	#02	;2 - 	C
PBASS		EQU	#03	;3 - 	D
PKOLON	EQU	#04	;4 - 	E
PSTENA	EQU	#05	;5 -  	F
PVRSTO	EQU	#06	;6 -  	G
PVRUP1	EQU	#07	;7 -  	H
PVRDN1	EQU	#08	;8 -  	I
PVRLF1	EQU	#09	;9 -  	J
PVRRH1	EQU	#0A	;A -  	K
PVRSTR	EQU	#0B	;B -  	L
PVRST2	EQU	#0c	;C -  ,  2	M

BEGHEA	EQU	250	;  
APTVOL	EQU	50	;     


;       
;      , ..   
stek_ptr
	di
	ld sp,stek_ptr
	CALL	RMASK
	CALL	LMASK
	CALL	MIRROR
	call	pallete
	ld a,6
	out (#fe),a

	ld hl,#5800
	ld de,#5801
	ld bc,#0300
	ld (hl),#36
	ldir
	JP	beginning
pallete
	ld 	de,PAL*256
	ld 	hl,palet
	ld	bc,16
	ldir
	ld	h,d
	ld	l,c
	ld	bc,240
	ldir
	ret
palet	; 	16 
	defb	#36	; 
	defb	#30	; 
	defb	#12	;    
	defb	#33	;    
	defb	#00
	defb	#00
	defb	#00
	defb	#00
	defb	#00
	defb	#00
	defb	#00
	defb	#00
	defb	#00
	defb	#00
	defb	#00
	defb	#00
	


;       

RMASK	LD	H,TRMASK
	LD	L,0
RMASK1
	xor a
	LD	E,l
	dup 8
	or e
	srl e
	edup
	cpl
	LD	(HL),a
	INC	L
	jr nz,RMASK1
	RET

;       

LMASK	LD	H,TLMASK
	LD	L,0
LMASK1	
	xor a
	LD	E,l	
	dup 8
	or e
	sla e
	edup
	cpl
	LD	(HL),a
	INC	L
	jr nz,LMASK1
	RET



;    
;  : A =  
;  : A =   

MIRROR	LD	H,TMIRR
	LD	L,0
	LD	B,0
MIRR1	LD	A,L
	dup 8
	RLCA
	RR	E
	edup
MIRR2	LD	(HL),E
	INC	L
	DJNZ	MIRR1
	RET



; 
	ORG	#7B00
	defb    #55,#55,#55,#55,#55,#55
	ORG	#7B40
                	defb    #56,#56,#60,#56,#06,#05
	ORG	#7B80
                	defb    #50,#56,#30,#50,#56,#65
	ORG	#7BC0
                	defb    #50,#50,#56,#50,#55,#55
	ORG	#7C00
                	defb    #50,#50,#00,#00,#05,#05
	ORG	#7C40
                	defb    #50,#55,#05,#50,#05,#05
	ORG	#7C80
                	defb    #50,#00,#05,#00,#00,#05
	ORG	#7CC0
                	defb    #50,#53,#33,#55,#50,#05
	ORG	#7D00
                	defb    #50,#50,#00,#00,#00,#05
	ORG	#7D40
                	defb    #50,#50,#50,#00,#00,#05
	ORG	#7D80
                	defb    #50,#00,#50,#00,#06,#05
	ORG	#7DC0
	defb    #55,#55,#55,#55,#55,#55



;  
		ORG     40450
;     
vfr_attr		equ 	#6000		;  
vfr_data	equ 	vfr_attr+#300	;   
vfr_end 	equ 	vfr_data+#c00+2	;   /   


draw_screen
	ld (draw_st0),sp
	ld sp,vfr_data
	ld hl,vfr_attr
	ld de,#5800
	ld b,PAL
	exx
	ld de,#4000
	ret
;   
print_char
	pop hl
	ld a,d
	and #f8
	ld d,a
	exx
	ld a,7
	ld (de),a
	inc hl
	inc de
	exx
	dup 7
	ld a,(hl)
	ld (de),a
	inc l
	inc d
	edup
	ld a,(hl)
	ld (de),a
	
	inc e
	ret nz
	ld a,d
	add a,8
	ld d,a
	ret
empty_tile
;  
	pop af
	exx
	ld c,0
	ld a,(bc)
	ld (de),a
	inc hl
	inc de
	exx
	inc e
	ret nz
	ld a,d
	add a,8
	ld d,a
	ret
attr_tile
;  
	pop af
	exx
	ld c,(hl)
	ld a,(bc)
	ld (de),a
	inc hl
	inc de
	exx
	inc e
	ret nz
	ld a,d
	add a,8
	ld d,a
	ret
tile_
	pop hl
	ld (draw_st1),sp
	ld sp,hl
	ld l,e
	ld a,d
	and #f8
	ld h,a

	dup 3
	pop bc
	ld (hl),c
	inc h
	ld (hl),b
	inc h
	edup
	pop bc
	ld (hl),c
	inc h
	ld (hl),b
	
	exx
	ld c,(hl)
	ld a,(bc)
	ld (de),a
	inc hl
	inc de
	exx
	
	ld sp,$
draw_st1	equ $-2
	inc e
	ret nz
	ld a,d
	add a,8
	ld d,a
	ret

tile_f
	pop hl
	ld (draw_st2),sp
	ld sp,hl
	ld l,e
	ld a,d
	and #f8
	ld h,a
	ld d,TMIRR
	dup 3
	pop bc
	ld e,c
	ld a,(de)
	ld (hl),a
	inc h
	ld e,b
	ld a,(de)
	ld (hl),a
	inc h
	edup
	pop bc
	ld e,c
	ld a,(de)
	ld (hl),a
	inc h
	ld e,b
	ld a,(de)
	ld (hl),a
	ex de,hl
		
	exx
	ld c,(hl)
	ld a,(bc)
	ld (de),a
	inc hl
	inc de
	exx
	
	ld sp,$
draw_st2	equ $-2
	inc e
	ret nz
	ld a,d
	add a,8
	ld d,a
	ret
tile_h
	pop hl
	ld (draw_st3),sp
	ld sp,hl
	ld l,e
	ld a,d
	or #07
	ld h,a

	dup 3
	pop bc
	ld (hl),c
	dec h
	ld (hl),b
	dec h
	edup
	pop bc
	ld (hl),c
	dec h
	ld (hl),b
	
	exx
	ld c,(hl)
	ld a,(bc)
	ld (de),a
	inc hl
	inc de
	exx
	
	ld sp,$
draw_st3	equ $-2
	inc e
	ret nz
	ld a,d
	add a,8
	ld d,a
	ret
tile_hf
	pop hl
	ld (draw_st4),sp
	ld sp,hl
	ld l,e
	ld a,d
	or #07
	ld h,a
	ld d,TMIRR
	dup 3
	pop bc
	ld e,c
	ld a,(de)
	ld (hl),a
	dec h
	ld e,b
	ld a,(de)
	ld (hl),a
	dec h
	edup
	pop bc
	ld e,c
	ld a,(de)
	ld (hl),a
	dec h
	ld e,b
	ld a,(de)
	ld (hl),a
	ex de,hl
		
	exx
	ld c,(hl)
	ld a,(bc)
	ld (de),a
	inc hl
	inc de
	exx
	
	ld sp,$
draw_st4	equ $-2
	inc e
	ret nz
	ld a,d
	add a,8
	ld d,a
	ret
draw_ret
	ld sp,$
draw_st0	equ $-2
	ret
clear_vfr
	ld (clear_st0),sp
	ld sp,vfr_end
	ld (curr_tile),sp
;  	
	ld hl,draw_ret
	push hl
	ld hl,empty_tile
	ld de,#0000
	ld b,#10
	dup #30
	push de,hl
	edup
	djnz $-#60

	ld de,#0101
; 
fill_c
	ld b,8
	dup #30
	push de
	edup
	djnz $-#30

	ld sp,$
clear_st0	equ $-2
	ret
refill_c
	ld (clear_st0),sp
	ld sp,vfr_data
	jp fill_c	
								
curr_tile	dw	0
draw_spr
	ld a,(hl)
	or a
	ret z
	inc hl
	ld (draw_coor),de	
	ld (draw_st5),sp	
	exx
	ld b,a
	ld iy,draw_spr2
draw_spr0
	exx

;b'    
;hl     +  		
;d vert e horiz	
	ld de,$
draw_coor	equ $-2
	
	ld a,(hl)
	ex af,af'
	ld a,(hl)
	inc hl
	and #3f
	add a,d
	ld b,a
	ld a,(hl)
	inc hl
	add a,e
	add a,a
	add a,a
	add a,a
	srl b
	rra
	ld e,a
	ld d,b
	srl b
	rra 
	srl b
	rra
	ld c,a
	
	
;bc -   
;de -    		
		
	ld sp,hl
	ld hl,vfr_attr	
	add hl,bc
	ld a,(hl)
	and #c0
	jp z,draw_newsp
	jp m,draw_border	
; 
draw_spr1
	ld hl,8
	add hl,sp
draw_spr2
	exx
	djnz draw_spr0
	ld sp,$
draw_st5	equ $-2
	ret
draw_newsp
	ex af,af'
	xor (hl)
	and #c0
	xor (hl)
	ld (hl),a

	ld hl,vfr_data
	add hl,de
	ld (draw_n0),hl
	inc hl
	inc hl
	ld (draw_n1),hl

	ld hl,tile_
	ld ($),hl
draw_n0	equ $-2	
	ld ($),sp
draw_n1	equ $-2
	jp draw_spr1
draw_border

;%10xxxxxx    TLMASK  
;%11xxxxxx    TRMASK

; 
	ld (draw_b2),hl	
	ld hl,vfr_data
	add hl,de
	ld (draw_b0),hl
	inc hl
	inc hl
	ld (draw_b1),hl
	
	and #40
	ld a,TRMASK
	jr z,$+4
	ld a,TLMASK
	ld (draw_mask0),a
;  			
	ld hl,(curr_tile)
	dup 3
	pop de
	ld (hl),e
	inc hl
	ld (hl),d
	inc hl
	edup
	pop de
	ld (hl),e
	inc hl
	ld (hl),d
	ld (next_item),sp
draw_buni
	ld hl,(draw_b1)
	ld sp,hl
	pop hl
	ld sp,hl
	ld a,(0)
draw_b2	equ $-2
	ld ix,draw_m
	and #30
	jp nz,ready_mask
draw_m	
	ld hl,(curr_tile)
	ld d,0
draw_mask0	equ $-1		
	ex de,hl
	dup 3
	pop bc
	ld l,c
	ld a,(de)
	and (hl)
	or l
	ld (de),a
	inc de
	ld l,b
	ld a,(de)
	and (hl)
	or l
	ld (de),a
	inc de
	edup
	pop bc
	ld l,c
	ld a,(de)
	and (hl)
	or l
	ld (de),a
	inc de
	ld l,b
	ld a,(de)
	and (hl)
	or l
	ld (de),a
	
	ld hl,tile_
	ld ($),hl
draw_b0	equ $-2	
	ld hl,(curr_tile)	
	ld ($),hl
draw_b1	equ $-2
	ld de,8
	add hl,de
	ld (curr_tile),hl
	ld hl,(draw_b2)
	ld a,(hl)
	and #0f
	or #40
	ld (hl),a			
	ld hl,$
next_item	equ $-2		
	jp (iy)
ready_mask
	bit 5,a
	jp nz,r_mask_h 
r_mask_f	
	ld hl,(curr_tile)
	ld de,8
	add hl,de
	ex de,hl
	ld h,TMIRR
	dup 3
	pop bc
	ld l,c
	ld a,(hl)
	ld (de),a
	inc de
	ld l,b
	ld a,(hl)
	ld (de),a
	inc de
	edup
	pop bc
	ld l,c
	ld a,(hl)
	ld (de),a
	inc de
	ld l,b
	ld a,(hl)
	ld (de),a
	ld hl,-7
	add hl,de
	ld sp,hl
	jp (ix)
r_mask_h
	ld hl,(curr_tile)
	ld de,15
	add hl,de
	bit 4,a
	jp nz,r_mask_hf 
	
	dup 3
	pop bc
	ld (hl),c
	dec hl
	ld (hl),b
	dec hl
	edup 
	pop bc
	ld (hl),c
	dec hl
	ld (hl),b
	ld sp,hl	
	jp (ix)
r_mask_hf
	ex de,hl
	ld h,TMIRR
	dup 3
	pop bc
	ld l,c
	ld a,(hl)
	ld (de),a
	dec de
	ld l,b
	ld a,(hl)
	ld (de),a
	dec de
	edup 
	pop bc
	ld l,c
	ld a,(hl)
	ld (de),a
	dec de
	ld l,b
	ld a,(hl)
	ld (de),a
	ex de,hl	
	ld sp,hl	
	jp (ix)

draw_sprv
	ld a,(hl)
	or a
	ret z
	inc hl
	ld (draw_coorv),de	
	ld (draw_st5v),sp	
	exx
	ld b,a
	ld iy,draw_spr2v
draw_spr0v
	exx

;b'    
;hl     +  		
;d vert e horiz	
	ld de,$
draw_coorv	equ $-2	
	ld a,(hl)
	ex af,af'
	ld a,(hl)
	inc hl
	and #3f
	add a,d
	ld b,a
	ld a,31
	sub (hl)
	inc hl
	add a,e
	add a,a
	add a,a
	add a,a
	srl b
	rra
	ld e,a
	ld d,b
	srl b
	rra 
	srl b
	rra
	ld c,a
	
;bc -   
;de -    		
		
	ld sp,hl
	ld hl,vfr_attr	
	add hl,bc
	ld a,(hl)
	and #c0
	jp z,draw_newspv
	jp m,draw_borderv	
; 
draw_spr1v
	ld hl,8
	add hl,sp
draw_spr2v
	exx
	djnz draw_spr0v
	ld sp,$
draw_st5v	equ $-2
	ret
draw_newspv
	ex af,af'
	bit 7,a
	jr z,$+4
	xor #40
	xor (hl)
	and #c0
	xor (hl)
	or #10	;     
	ld (hl),a

	ld hl,vfr_data
	add hl,de
	ld (draw_n0v),hl
	inc hl
	inc hl
	ld (draw_n1v),hl

	ld hl,tile_f
	ld ($),hl
draw_n0v	equ $-2	
	ld ($),sp
draw_n1v	equ $-2
	jp draw_spr1v
draw_borderv	

;%10xxxxxx    TLMASK  
;%11xxxxxx    TRMASK

; 
	ld (draw_b2),hl	
	ld hl,vfr_data
	add hl,de
	ld (draw_b0),hl
	inc hl
	inc hl
	ld (draw_b1),hl
	
	and #40
	ld a,TRMASK
	jr z,$+4
	ld a,TLMASK
	ld (draw_mask0),a
;  			
	ld hl,(curr_tile)
	ld d,TMIRR
	ex hl,de
	dup 3
	pop bc
	ld l,c
	ld a,(hl)
	ld (de),a
	inc de
	ld l,b
	ld a,(hl)
	ld (de),a
	inc de
	edup
	pop bc
	ld l,c
	ld a,(hl)
	ld (de),a
	inc de
	ld l,b
	ld a,(hl)
	ld (de),a
	ld (next_item),sp

	jp draw_buni	
draw_sprh
	ld a,(hl)
	or a
	ret z
	inc hl
	ld (draw_coorh),de	
	ld (draw_st5h),sp	
	exx
	ld b,a
	ld iy,draw_spr2h
draw_spr0h
	exx

;b'    
;hl     +  		
;d vert e horiz	
	ld de,$
draw_coorh	equ $-2	
	ld a,(hl)
	ex af,af'
	ld a,(hl)
	inc hl
	and #3f
	sub 23
	neg
	add a,d
	ld b,a
	ld a,(hl)
	inc hl
	add a,e
	add a,a
	add a,a
	add a,a
	srl b
	rra
	ld e,a
	ld d,b
	srl b
	rra 
	srl b
	rra
	ld c,a
	
;bc -   
;de -    		
		
	ld sp,hl
	ld hl,vfr_attr	
	add hl,bc
	ld a,(hl)
	and #c0
	jp z,draw_newsph
	jp m,draw_borderh	
; 
draw_spr1h
	ld hl,8
	add hl,sp
draw_spr2h
	exx
	djnz draw_spr0h
	ld sp,$
draw_st5h	equ $-2
	ret
draw_newsph
	ex af,af'
	xor (hl)
	and #c0
	xor (hl)
	or #20	;  
	ld (hl),a

	ld hl,vfr_data
	add hl,de
	ld (draw_n0h),hl
	inc hl
	inc hl
	ld (draw_n1h),hl

	ld hl,tile_h
	ld ($),hl
draw_n0h	equ $-2	
	ld ($),sp
draw_n1h	equ $-2
	jp draw_spr1h
draw_borderh	

;%10xxxxxx    TLMASK  
;%11xxxxxx    TRMASK

; 
	ld (draw_b2),hl	
	ld hl,vfr_data
	add hl,de
	ld (draw_b0),hl
	inc hl
	inc hl
	ld (draw_b1),hl
	
	and #40
	ld a,TRMASK
	jr z,$+4
	ld a,TLMASK
	ld (draw_mask0),a
;  			
	ld hl,(curr_tile)
	ld de,7
	add hl,de
	dup 3
	pop bc
	ld (hl),c
	dec hl
	ld (hl),b
	dec hl
	edup
	pop bc
	ld (hl),c
	dec hl
	ld (hl),b
	ld (next_item),sp
	jp draw_buni	

draw_sprhv
	ld a,(hl)
	or a
	ret z
	inc hl
	ld (draw_coorhv),de	
	ld (draw_st5hv),sp	
	exx
	ld b,a
	ld iy,draw_spr2hv
draw_spr0hv
	exx

;b'    
;hl     +  		
;d vert e horiz	
	ld de,$
draw_coorhv	equ $-2	
	ld a,(hl)
	ex af,af'
	ld a,(hl)
	inc hl
	and #3f
	sub 23
	neg
	add a,d
	ld b,a
	ld a,31
	sub (hl)
	inc hl
	add a,e
	add a,a
	add a,a
	add a,a
	srl b
	rra
	ld e,a
	ld d,b
	srl b
	rra 
	srl b
	rra
	ld c,a
	
;bc -   
;de -    		
		
	ld sp,hl
	ld hl,vfr_attr	
	add hl,bc
	ld a,(hl)
	and #c0
	jp z,draw_newsphv
	jp m,draw_borderhv	
; 
draw_spr1hv
	ld hl,8
	add hl,sp
draw_spr2hv
	exx
	djnz draw_spr0hv
	ld sp,$
draw_st5hv	equ $-2
	ret
draw_newsphv
	ex af,af'
	bit 7,a
	jr z,$+4
	xor #40
	xor (hl)
	and #c0
	xor (hl)
	or #30	;   
	ld (hl),a

	ld hl,vfr_data
	add hl,de
	ld (draw_n0hv),hl
	inc hl
	inc hl
	ld (draw_n1hv),hl

	ld hl,tile_hf
	ld ($),hl
draw_n0hv	equ $-2	
	ld ($),sp
draw_n1hv	equ $-2
	jp draw_spr1hv
draw_borderhv	

;%10xxxxxx    TLMASK  
;%11xxxxxx    TRMASK

; 
	ld (draw_b2),hl	
	ld hl,vfr_data
	add hl,de
	ld (draw_b0),hl
	inc hl
	inc hl
	ld (draw_b1),hl
	
	and #40
	ld a,TRMASK
	jr z,$+4
	ld a,TLMASK
	ld (draw_mask0),a
;  			
	ld hl,(curr_tile)
	ld de,7
	add hl,de
	ex de,hl
	ld h,TMIRR
	dup 3
	pop bc
	ld l,c
	ld a,(hl)
	ld (de),a
	dec de
	ld l,b
	ld a,(hl)
	ld (de),a
	dec de
	edup
	pop bc
	ld l,c
	ld a,(hl)
	ld (de),a
	dec de
	ld l,b
	ld a,(hl)
	ld (de),a
	ld (next_item),sp
	jp draw_buni	
count_buff
	ld hl,(curr_tile)
	ld de,vfr_end
	or a
	sbc hl,de
	dup 3
	srl h
	rl l
	edup
	ld b,4
	exx
	ld de,print_char
	ld hl,#02c1*4+vfr_data
	exx
count_buff0	
	xor a
	dup 4
	add hl,hl
	adc a,a
	edup 
	add a,"0"
	cp #3a
	jr c,$+4
	add a,7
	ex de,hl
	ld l,a
	add hl,hl
	ld h,#0f
	add hl,hl
	add hl,hl	
	push hl
	ex de,hl
	exx
	pop bc
	ld (hl),e
	inc hl
	ld (hl),d
	inc hl
	ld (hl),c
	inc hl
	ld (hl),b
	inc hl
	exx
	djnz count_buff0
	ret

; 
PUTSPR equ draw_spr
MIR24 equ draw_sprv
MIR34 equ draw_sprh
MIR44 equ draw_sprhv 


beginning
	LD	A,BEGHEA
	LD	(HEALTH),A
KEY
	xor a
	ld (hero_fire),a
	ld (enemy_fire),a
	call	clear_vfr
	CALL	KBDJOY
	RRCA
	CALL	C,PRAWO
	RRCA
	CALL	C,LEWO
	RRCA
	CALL	C,WNIZ
	RRCA
	CALL	C,WWERH
	RRCA
	CALL	C,VYSTR
	RRCA
	CALL	C,SPRAWO
	RRCA
	CALL	C,SLEWO
	PUSH	AF
            	CALL    	VRAGI
	;CALL	PROVER

	LD	HL,ORUZH	;   
	LD	DE,0
	CALL	PUTSPR
	CALL	PEIZAS
	call 	count_buff
	call	chek_fire
	call	draw_screen
	POP	AF
	RRCA
	JR	NC,KEY
	EI
	RET
hero_fire 	db 0
enemy_fire	db 0	
chek_fire
	ld a,(enemy_fire)	
	ld de,#0303
	or a
	call nz,refill_c
	
	ld a,(hero_fire)
	or a
	call nz,draw_beam
	ret
draw_beam
	ld hl,vfr_attr+#1b0
	ld a,2
	ld de,32
	ld bc,33
	dup 2
	ld (hl),a
	add hl,de
	ld (hl),a
	add hl,bc
	edup
	
	ld hl,vfr_data+#6c0
	ld de,attr_tile
	ld bc,127
	dup 2
	ld (hl),e
	inc hl
	ld (hl),d
	add hl,bc
	ld (hl),e
	inc hl
	ld (hl),d
	add hl,bc
	inc hl
	inc hl
	inc hl
	inc hl
	edup	
	ret








;  

VYSTR	PUSH	AF
	CALL	FIRORU	;    

	LD	HL,SMEST	; ,    -
	LD	DE,(STOR)
	SLA	E
	LD	D,0
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)	; DE =   1     
	LD	HL,(POLOZ)

                LD      B,6                             ;   

VYSTR1	PUSH	BC

	SCF
	CCF
	SBC	HL,DE	;   

	PUSH	HL
	CALL	KLETKA	;  
	POP	HL

	JP	C,VYSTR2	;     , 
	CP	PVRSTO
	JP	NC,VYSTR3	;  , ,      
	CP	PKOLON
	JP	NC,VYSTR2	;    , 


	POP	BC
	DJNZ	VYSTR1	;     

	POP	AF
	RET

VYSTR3	LD	BC,BEGLAB
	SCF
	CCF
	SBC	HL,BC
	LD	A,PTRUP
	CALL	PUTLOG	;       
VYSTR2	POP	BC
	POP	AF
	RET


;        (  )

FIRVRA

	ld a,1
	ld (enemy_fire),a
	ret	
	LD      HL,ORUZH	;  
                LD      DE,0
                CALL	PUTSPR

	LD	A,3	;  
	JP	FIRE

;        (  )

FIRORU
	ld a,1
	ld (hero_fire),a

	ret
;   	
/*
	LD      HL,ORUZH	;  
                LD      D,1
                LD      E,0
	LD	B,24
                CALL	PUTS1

	LD	A,2	;  

*/
;       (  )
;  : A = 

FIRE	
	ret
;    
/*
	LD	(SCOLOR),A
	CALL	PEIZAS

                CALL    PUTVRT
	CALL	CLSV

                LD	A,1
	LD	(SCOLOR),A
*/
                RET


;   

PRAWO	PUSH	AF
	LD	A,(STOR)
	INC	A
	CP	9
	JR	NZ,PRAW1
	LD	A,1
PRAW1	LD	(STOR),A
	POP	AF
	RET

;   

LEWO	PUSH	AF
	LD	A,(STOR)
	DEC	A
	JR	NZ,LEW1
	LD	A,8
LEW1	LD	(STOR),A
	POP	AF
	RET

;    ()

WNIZ	LD	HL,09
	LD	(UPRAW1),HL
	LD	HL,SMEST
	JP	UPRAW

;    ()

WWERH	LD	HL,#42ED
	LD	(UPRAW1),HL
	LD	HL,SMEST
	JP	UPRAW

;   

SPRAWO	LD	HL,09
	LD	(UPRAW1),HL
	LD	HL,SMEST1
	JP	UPRAW

;   

SLEWO	LD	HL,#42ED
	LD	(UPRAW1),HL
	LD	HL,SMEST1

;       UPRAW1

UPRAW	PUSH	AF
	LD	BC,(STOR)
	SLA	C
	LD	B,0
	ADD	HL,BC
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	LD	HL,(POLOZ)
UPRAW1	NOP
	NOP

                PUSH    HL
                
	LD      BC,BEGLAB	;      
                SCF
                CCF
                SBC     HL,BC
	SRL	H
	RR	L
	JR	C,UPRAW3	;    ,     

	ADD	HL,BC	;   
	LD	A,(HL)
	RRCA
	RRCA
	RRCA
	RRCA
	JP	UPRAW4

UPRAW3	ADD	HL,BC
	LD	A,(HL)

UPRAW4          AND     #0F
                
                POP     HL
                
	CP	PAPTEK+1
                JP      NC,UPRAW2	;   ,    
	CP	PAPTEK
	CALL	Z,APTEKA	;    ,   

	PUSH	HL	;    ,     
	LD	HL,BUFIGR
	LD	B,A
	LD	A,(HL)
	LD	(HL),B
	LD	HL,(POLOZ)
	LD	BC,BEGLAB
	SCF
	CCF
	SBC	HL,BC
	CALL	PUTLOG
	POP	HL

	LD	(POLOZ),HL	;  

UPRAW2	POP	AF
                RET
                
SMEST           DEFW    0,128,127,-1,-129,-128,-127,1,129	;         
SMEST1	DEFW	0,1,129,128,127,-1,-129,-128,-127	;         


;     

APTEKA	LD	A,(HEALTH)
	CP	201
	JP	NC,APTEK1
	ADD	A,APTVOL
APTEK2	LD	(HEALTH),A
	XOR	A	;    
	RET
APTEK1	LD	A,250
	JP	APTEK2


;    
                
KBDJOY	IN	A,(31)
	and 	#1f
	LD	E,A
	AND	3
	CP	3
	JR	NZ,KBDJ1
	LD	E,0
KBDJ1	LD	HL,DKEY
KBDJ2	LD	C,(HL)
	INC	C
	DEC	C
	LD	A,E
	RET	Z
	INC	HL
	LD	B,(HL)
	INC	HL
	IN	A,(C)
	CPL
	AND	(HL)
	INC	HL
	JR	Z,KBDJ3
	LD	A,(HL)
	OR	E
	LD	E,A
KBDJ3	INC	HL
	JR	KBDJ2
DKEY	defb	#FE,#FB,2,8	; W
	defb	#FE,#FD,2,4	; S
	defb	#FE,#FD,1,2	; A
	defb	#FE,#FD,4,1	; D
	defb	#FE,#7F,1,16	; Space
	defb	#FE,#DF,2,64	; O
	defb	#FE,#DF,1,32	; P
                	defb    0

;       
;  : HL =  
;  : A =   ( 0-3);   ,     

KLETKA	PUSH    HL                      ;        
                LD      B,H
                LD      C,L
                LD      HL,ENDLAB
	SCF
	CCF
                SBC     HL,BC
	POP	HL
                RET	C

                LD      BC,BEGLAB
                SCF
                CCF
                SBC     HL,BC
                RET	C

	SRL	H	;      
	RR	L
	JP	C,KLET1	;    ,     

	ADD	HL,BC	;   
	LD	A,(HL)
	RRCA
	RRCA
	RRCA
	RRCA
	AND	#0F
                SCF
                CCF
	RET

KLET1	ADD	HL,BC
	LD	A,(HL)
	AND	#0F
                SCF
                CCF
	RET


;       
;  : HL =   
;  : B =    , C =    

KOORD	LD      BC,BEGLAB
	SCF
                CCF
	SBC     HL,BC

	PUSH	HL
	SLA	L
	RL	H	;   2    256 -  .
	LD	A,H
	LD	L,0
	SRL	H
	RR	L	;     2
	LD	B,H
	LD	C,L
	POP	HL
	SCF
	CCF
	SBC	HL,BC	;     -  .

	LD	B,A
	LD	C,L	
	RET


;      
;  : B =    , C =    
;  : A =   ( 0-3)

GETKL	LD	H,B	;    
	LD	L,0
	SRL	H
	RR	L
	LD	B,0
	ADD	HL,BC

	SRL	H	;      
	RR	L
	LD	BC,BEGLAB
	JP	C,GETKL1	;    ,     

	ADD	HL,BC	;   
	LD	A,(HL)
	RRCA
	RRCA
	RRCA
	RRCA
	AND	#0F
	RET

GETKL1	ADD	HL,BC
	LD	A,(HL)
	AND	#0F
	RET

;        
;  : B =    , C =    , A =   ( 0-3)
;   

PUTKL	LD	H,B	;    
	LD	L,0
	SRL	H
	RR	L
	LD	B,0
	ADD	HL,BC

;          BEGLAB

PUTLOG	SRL	H	;      
	RR	L
	LD	BC,BEGLAB
	JP	C,PUTKL1	;    ,     

	ADD	HL,BC	;   
	RLCA
	RLCA
	RLCA
	RLCA
	LD	C,A
	LD	A,(HL)
	AND	#0F
	OR	C
	LD	(HL),A
	RET

PUTKL1	ADD	HL,BC
	LD	C,A
	LD	A,(HL)
	AND	#F0
	OR	C
	LD	(HL),A
	RET


;    
;     

VRAGI	LD	HL,(POLOZ)	;    1313   
	LD	B,0
	LD	C,B
	LD	(BUFVRA),BC	;    

	PUSH	HL
	CALL	KOORD
	LD	(POLKRD),BC	;     
	POP	HL	

	LD	DE,903
	SCF
	CCF
	SBC	HL,DE	;      

	LD	B,13
VRAG1	PUSH	BC	;   
	LD	DE,128
	ADD	HL,DE

	LD	B,13
VRAG2	PUSH	BC	;   
	INC	HL
	PUSH	HL	; HL =    

	CALL	KLETKA	;  
	JP	C,VRAG3	;     ,   

	POP	HL	; HL =    
	
	PUSH	HL
	CP	PVRSTO
	CALL	NC,VRAG4	;   - ,  


VRAG3	POP	HL	; HL =    
	POP	BC
	DJNZ	VRAG2	;    

	LD	DE,13
	SCF
	CCF
	SBC	HL,DE

	POP	BC
	DJNZ	VRAG1	;    
	RET

;  , HL =    , A =  

VRAG4	CP	PVRDN1	;      ,        
	JP	Z,VRDN	;    ""

	CP	PVRRH1	;      ,        
	JP	Z,VRRH	;    ""

	CP	PVRSTR
	JP	Z,VRSTO2	;     ,    "  2"

	CP	PVRUP1
	JP	NC,VRSTOI	;        ,    ""

; ,   ,    

	CALL	KOORD	;       BC
	LD	DE,(POLKRD)	;       DE

	LD	A,D	;        ( )   H
	CP	B
	JP	C,VRAG41
	SUB	B
	JP	VRAG42
VRAG41	LD	A,B
	SUB	D
VRAG42	LD	H,A

	LD	A,E	;        ( )   L
	CP	C
	JP	C,VRAG43
	SUB	C
	JP	VRAG44
VRAG43	LD	A,C
	SUB	E
VRAG44	LD	L,A

	CP	H
	JP	Z,VRSTRD	;    ,    
	AND	A
	JP	Z,VRSTRV	;     ,    
	LD	A,H
	AND	A	;     ,    
	JP	Z,VRSTRG
	CP	L
	LD	A,2	;   
	JP	C,VRSMV	;     ,    ,   

;    

VRSMG	PUSH	AF	;    
	PUSH	BC	;    
	LD	A,C
	CP	E
	JP	C,VRSMG1	;     ,   
	DEC	C	; 
	LD	L,PVRLF1	; L =   
	JP	VRSMG2
VRSMG1	INC	C	; 
	LD	(BUFVRA),BC	;     ,  
	LD	L,PVRRH1	; L =   
VRSMG2	PUSH	HL	;  L
	PUSH	BC
	CALL	GETKL	;    
	POP	BC
	POP	HL	;  L
	CP	PBASS
	JP	C,VRPER	;    ,   ,    
	POP	BC	;    
	POP	AF	;    
	DEC	A
	JP	NZ,VRSMV	;   ,     
	LD	A,PVRSTO	;   ""
	JP	PUTKL	; 


;    

VRSMV	PUSH	AF	;    
	PUSH	BC	;    
	LD	A,B
	CP	D
	JP	C,VRSMV1	;     ,   
	DEC	B	; 
	LD	L,PVRUP1	; L =   
	JP	VRSMV2
VRSMV1	INC	B	; 
	LD	(BUFVRA),BC	;     ,  
	LD	L,PVRDN1	; L =   
VRSMV2	PUSH	HL	;  L
	PUSH	BC
	CALL	GETKL	;    
	POP	BC
	POP	HL	;  L
	CP	PBASS
	JP	C,VRPER	;    ,   ,    
	POP	BC	;    
	POP	AF	;    
	DEC	A
	JP	NZ,VRSMG	;   ,     
	LD	A,PVRSTO	;   ""
	JP	PUTKL	; 


;     

VRPER	PUSH	AF	;  ,    
	LD	A,L	;    
	CALL	PUTKL	;    
	POP	AF	; ,    
	POP	BC	;   
	CALL	PUTKL	;  ,     ,   
	POP	AF	;     ( )
	RET


;    

VRSTRD	PUSH	BC	;   
	LD	A,B
	CP	D
	JP	C,VRSD1	;   -  -, 
	LD	A,C
	CP	E
	JP	C,VRSD2	;   -, 
; -
VRSD3	DEC	B
	DEC	C
	LD	A,B
	CP	D
	JP	Z,VRSTRE	;     ,  
	PUSH	BC
	CALL	GETKL
	POP	BC
	CP	PKOLON
	JP	C,VRSD3	;     ,      
	POP	BC
	LD	A,2	; ..  ,     
	JP	VRSMV
; -
VRSD2	DEC	B
	INC	C
	LD	A,B
	CP	D
	JP	Z,VRSTRE	;     ,  
	PUSH	BC
	CALL	GETKL
	POP	BC
	CP	PKOLON
	JP	C,VRSD2	;     ,      
	POP	BC
	LD	A,2	; ..  ,     
	JP	VRSMV
; -  -
VRSD1	LD	A,C
	CP	E
	JP	C,VRSD4	;   -, 
; -
VRSD5	INC	B
	DEC	C
	LD	A,B
	CP	D
	JP	Z,VRSTRE	;     ,  
	PUSH	BC
	CALL	GETKL
	POP	BC
	CP	PKOLON
	JP	C,VRSD5	;     ,      
	POP	BC
	LD	A,2	; ..  ,     
	JP	VRSMV
; -
VRSD4	INC	B
	INC	C
	LD	A,B
	CP	D
	JP	Z,VRSTRE	;     ,  
	PUSH	BC
	CALL	GETKL
	POP	BC
	CP	PKOLON
	JP	C,VRSD4	;     ,      
	POP	BC
	LD	A,2	; ..  ,     
	JP	VRSMV

;    

VRSTRG	PUSH	BC	;   
	LD	A,C
	CP	E
	JP	C,VRSG2	;   , 
; 
VRSG1	DEC	C
	LD	A,C
	CP	E
	JP	Z,VRSTRE	;     ,  
	PUSH	BC
	CALL	GETKL
	POP	BC
	CP	PKOLON
	JP	C,VRSG1	;     ,      
	POP	BC
	LD	A,2	; ..  ,     
	JP	VRSMG
; 
VRSG2	INC	C
	LD	A,C
	CP	E
	JP	Z,VRSTRE	;     ,  
	PUSH	BC
	CALL	GETKL
	POP	BC
	CP	PKOLON
	JP	C,VRSG2	;     ,      
	POP	BC
	LD	A,2	; ..  ,     
	JP	VRSMG


;    

VRSTRV	PUSH	BC	;   
	LD	A,B
	CP	D
	JP	C,VRSV2	;   , 
; 
VRSV1	DEC	B
	LD	A,B
	CP	D
	JP	Z,VRSTRE	;     ,  
	PUSH	BC
	CALL	GETKL
	POP	BC
	CP	PKOLON
	JP	C,VRSV1	;     ,      
	POP	BC
	LD	A,2	; ..  ,     
	JP	VRSMV
; 
VRSV2	INC	B
	LD	A,B
	CP	D
	JP	Z,VRSTRE	;     ,  
	PUSH	BC
	CALL	GETKL
	POP	BC
	CP	PKOLON
	JP	C,VRSV2	;     ,      
	POP	BC
	LD	A,2	; ..  ,     
	JP	VRSMV

;    

VRSTRE	CALL	FIRVRA	;   
	LD	HL,HEALTH
	DEC	(HL)	;   
	JP	Z,KONEZ	;  =0,  
	POP	BC	;   
	LD	A,PVRSTR
	JP	PUTKL	;    

;    

VRDN	CALL	KOORD	;  ,      
	LD	A,(BUFVRA)
	CP	C
	JP	NZ,VRDN1
	LD	A,(BUFVRA+1)
	CP	B
	RET	Z
VRDN1	LD	A,PVRSTO
	JP	PUTKL	;       

;    

VRRH	CALL	KOORD	;  ,      
	LD	A,(BUFVRA)
	CP	C
	JP	NZ,VRRH1
	LD	A,(BUFVRA+1)
	CP	B
	RET	Z
VRRH1	LD	A,PVRSTO
	JP	PUTKL	;       

;    

VRSTOI	LD	BC,BEGLAB
	SCF
	CCF
	SBC	HL,BC
	LD	A,PVRSTO
	JP	PUTLOG	;       

;      2

VRSTO2	LD	BC,BEGLAB
	SCF
	CCF
	SBC	HL,BC
	LD	A,PVRST2
	JP	PUTLOG	;       


;   -      15x15

PROVER	CALL	3435
	LD	A,2
	CALL	5633

	LD	HL,(POLOZ)	;    1515   

	PUSH	HL	;     
	LD	DE,BEGLAB
	SCF
	CCF
	SBC	HL,DE
	LD	A,#0F
	CALL	PUTLOG
	POP	HL

	LD	DE,1032
	SCF
	CCF
	SBC	HL,DE	;      

	LD	B,15
PROV1	PUSH	BC	;   
	LD	DE,128
	ADD	HL,DE

	LD	B,15
PROV2	PUSH	BC	;   
	INC	HL
	PUSH	HL	; HL =    

	CALL	KLETKA	;  
	JP	C,PROV4	;     ,   

	ADD	A,65
	CP	66
	JP	C,PROV4
	CP	65+16
	JP	NC,PROV4

PROV5	RST	16
	JP	PROV3

PROV4	LD	A,32
	RST	16

PROV3	POP	HL	; HL =    
	POP	BC
	DJNZ	PROV2	;    

	LD	DE,15
	SCF
	CCF
	SBC	HL,DE

	PUSH	HL
	LD	A,13
	RST	16
	POP	HL

	POP	BC
	DJNZ	PROV1	;    

	LD	A,13
	RST	16

	LD	A,13
	RST	16

	LD	A,(HEALTH)
	LD	C,A
	LD	B,0
	CALL	6683	;    

	LD	A,32
	RST	16
	LD	A,32
	RST	16

	LD	A,(STOR)
	LD	C,A
	LD	B,0
	CALL	6683	;     

	LD	HL,(POLOZ)	;      
	LD	DE,BEGLAB
	SCF
	CCF
	SBC	HL,DE
	LD	A,#00
	CALL	PUTLOG

	LD	BC,0
	CALL	7997

	RET

pl_side_ptr	
	dw	#42ed,DPEIZ4,ELEM21-ELEM12+ELEM11	
	dw	#42ed,DPEIZ1,ELEM11-ELEM12+ELEM11	
	dw	#42ed,DPEIZ3,ELEM21-ELEM12+ELEM11	
	dw	#42ed,DPEIZ2,ELEM11-ELEM12+ELEM11
	dw	#0009,DPEIZ4,ELEM21-ELEM12+ELEM11	
	dw	#0009,DPEIZ1,ELEM11-ELEM12+ELEM11
	dw	#0009,DPEIZ3,ELEM21-ELEM12+ELEM11
	dw	#0009,DPEIZ2,ELEM11-ELEM12+ELEM11	

;   .  
	
PEIZAS
//-------------------------------------------
	ld (sp_peis),sp

	LD	A,(STOR)	;    
	and #07
	add a,a
	ld l,a
	add a,a
	add a,l
	ld l,a
	ld h,0

	ld sp,pl_side_ptr
	add hl,sp
	ld sp,hl
	pop de,hl,bc
	ld sp,$
sp_peis	equ $-2	
//--------------------------------------------

WPEIZ		LD	(MPZ1),DE
		LD	DE,(POLOZ)
WPEIZ4		PUSH	BC
		PUSH	BC
		LD	C,(HL)			; BC =      
		INC	HL
		LD	B,(HL)
		LD	A,B
		OR	C
                JP      Z,WPEIZ3                ; ,   
		EX	DE,HL			; DE=DPEIZ, HL=POLOZ
MPZ1            NOP                             ;     (   POLOZ)
                NOP

		PUSH	HL

		CALL	KLETKA			;   
		JP	C,WPEIZ5		;   . ,     

		POP	HL

		EX	(SP),HL			; HL=POLY
		PUSH	DE			;    = DPEIZ POLOZ POLY

		AND	A
                JP      Z,WPEIZ2                ;   =,    
		LD	DE,ELEM12-ELEM11	; DE =        (ELEM11+ELEM21)

		CP	PVRST2
		JP	Z,WPEIZ6		;   =   2,   " "

		CP	PVRUP1
		JP	Z,WPEIZ7		;   = ,       

		CP	PVRDN1
		JP	Z,WPEIZ8		;   = ,       

		CP	PVRLF1
		JP	Z,WPEIZ9		;   = ,       

		CP	PVRRH1
		JP	Z,WPEIZA		;   = ,       

		LD	B,A			; B =  
WPEIZ1		ADD	HL,DE
                DJNZ    WPEIZ1                  ;     KUBY  , HL=KUBY

                LD      C,(HL)
		INC	HL
		LD	B,(HL)			; BC =  
		INC	HL

		LD	A,(HL)			; A =    . 
		AND	%00011111		; A = . 

		LD	D,0
		LD	E,A			; DE = .  .  

		LD	A,(HL)			; A =    . 

		LD	H,B
		LD	L,C			; HL =  
		LD	(TMP_HL),HL

		CP	255
		JP	Z,BL1111		; PUTSPR,MIR24,MIR34,MIR44

		LD	(TMP_DE),DE

		AND	%11100000		; A =   
		JP	Z,BL1000		; PUTSPR
		CP	32
		JP	Z,BL0010		; MIR34
		CP	64
		JP	Z,BL0100		; MIR24
		CP	96
		JP	Z,BL0001		; MIR44
		CP	128
		JP	Z,BL1010		; PUTSPR,MIR34
		CP	160
		JP	Z,BL0101		; MIR24,MIR44
		CP	192
		JP	Z,BL1100		; PUTSPR,MIR24

		CALL	MIR34			; MIR34,MIR44
		LD	DE,(TMP_DE)
		LD	HL,(TMP_HL)
		CALL	MIR44

WPEIZ2
                ;-------------------
                ;PUSH    BC                     ;     ,  VOFFS   
                ;PUSH    DE
                ;PUSH    HL
                ;PUSH    AF
                ;CALL    PUTVRT
                ;LD      BC,0
                ;CALL    7997
                ;POP     AF
                ;POP     HL
                ;POP     DE
                ;POP     BC
                ;-------------------
                
	        POP     HL                      ; HL=DPEIZ
                POP     DE                      ; DE=POLOZ
		POP	BC			; BC=POLY
		INC	HL			;   
		INC	BC
		INC	BC
		INC	BC			;      ELEM10  ELEM11
                JP      WPEIZ4

WPEIZ5          POP     HL
                POP     BC
                POP     BC                      ; BC=POLY
                EX      DE,HL                   ; DE=POLOZ, HL=DPEIZ
                INC     HL                      ;   
                INC     BC
		INC	BC
                INC     BC			;      ELEM10  ELEM11
                JP      WPEIZ4

WPEIZ3		POP	BC
		POP	BC
		RET

WPEIZ6		LD	B,PVRSTO
		JP	WPEIZ1


;        
WPEIZ7		PUSH	HL
		LD	A,(STOR)
		DEC	A
		LD	C,A
		LD	B,0
		LD	HL,VYV_UP
		ADD	HL,BC
		LD	B,(HL)
		POP	HL
		JP	WPEIZ1
VYV_UP		DEFB	PVRDN1,PVRDN1,PVRLF1,PVRLF1,PVRUP1,PVRUP1,PVRRH1,PVRRH1


;        
WPEIZ8		PUSH	HL
		LD	A,(STOR)
		DEC	A
		LD	C,A
		LD	B,0
		LD	HL,VYV_DN
		ADD	HL,BC
		LD	B,(HL)
		POP	HL
		JP	WPEIZ1
VYV_DN		DEFB	PVRUP1,PVRUP1,PVRRH1,PVRRH1,PVRDN1,PVRDN1,PVRLF1,PVRLF1


;        
WPEIZ9		PUSH	HL
		LD	A,(STOR)
		DEC	A
		LD	C,A
		LD	B,0
		LD	HL,VYV_LF
		ADD	HL,BC
		LD	B,(HL)
		POP	HL
		JP	WPEIZ1
VYV_LF		DEFB	PVRLF1,PVRLF1,PVRUP1,PVRUP1,PVRRH1,PVRRH1,PVRDN1,PVRDN1


;        
WPEIZA		PUSH	HL
		LD	A,(STOR)
		DEC	A
		LD	C,A
		LD	B,0
		LD	HL,VYV_RH
		ADD	HL,BC
		LD	B,(HL)
		POP	HL
		JP	WPEIZ1
VYV_RH		DEFB	PVRRH1,PVRRH1,PVRDN1,PVRDN1,PVRLF1,PVRLF1,PVRUP1,PVRUP1



;   

BL1111		LD	E,0
		LD	(TMP_DE),DE
		CALL	PUTSPR
		LD	DE,(TMP_DE)
		LD	HL,(TMP_HL)
		CALL	MIR24
		LD	DE,(TMP_DE)
		LD	HL,(TMP_HL)
		CALL	MIR34                
		LD	DE,(TMP_DE)
		LD	HL,(TMP_HL)
		CALL	MIR44
		JP	WPEIZ2

BL1000		CALL	PUTSPR
		JP	WPEIZ2

BL0010		CALL	MIR34
		JP	WPEIZ2

BL0100		CALL	MIR24
		JP	WPEIZ2

BL0001		CALL	MIR44
		JP	WPEIZ2

BL1010		CALL	PUTSPR
		LD	DE,(TMP_DE)
		LD	HL,(TMP_HL)
		CALL	MIR34
		JP	WPEIZ2

BL0101		CALL	MIR24
		LD	DE,(TMP_DE)
		LD	HL,(TMP_HL)
		CALL	MIR44
		JP	WPEIZ2

BL1100		CALL	PUTSPR
		LD	DE,(TMP_DE)
		LD	HL,(TMP_HL)
		CALL	MIR24
		JP	WPEIZ2


;  

KONEZ		RET


SCOLOR		DEFB	1			;  INK 
STOR            DEFB    BEGSTO                  ;   
POLOZ           DEFW    BEGPOL                  ;      
POLKRD		DEFW	0			;     
BUFIGR		DEFB	0			;  ,   ,   
HEALTH		DEFB	BEGHEA			; 
BUFVRA		DEFW	0			;        ,      

TMP_SP          DEFW    0			;    SP
TMP_HL          DEFW    0			;    HL
TMP_DE          DEFW    0			;    DE


;         

DPEIZ1		DEFW	1,-2,129,1,1,-3,-1,130,1,1,1,-4,-1,-1			;        , 90 
		DEFW	131,1,1,1,1,-5,-1,-1,-1,132,1,1,1,1,-5,-1,-1,-1
		DEFW	132,1,1,1,1,1,-6,-1,-1,-1,-1
		DEFW	133,1,1,1,1,1,-6,-1,-1,-1,-1,0


DPEIZ2		DEFW	128,-256,127,128,128,-384,-128,255,128,128,128		;        , 90 
		DEFW	-512,-128,-128,383,128,128,128,128,-640,-128,-128,-128
		DEFW	511,128,128,128,128,-640,-128,-128,-128
		DEFW	511,128,128,128,128,128,-768,-128,-128,-128,-128
		DEFW	639,128,128,128,128,128,-768,-128,-128,-128,-128,0


DPEIZ3		DEFW	128,-129,128,129,-258,386,-129,-129,-129		;      -  -, 45 
		DEFW	257,258,-129,-258,-129,644,-129,-129,-129,-129,-129
		DEFW	386,387,-129,-129,-258,-129,-129
		DEFW	902,-129,-129,-129,-129,-129,-129,-129,0

DPEIZ4		DEFW	1,127,1,-127,254,-253,127,127,127			;      -  -, 45 
		DEFW	-126,-254,127,254,127,-507,127,127,127,127,127
		DEFW	-253,-381,127,127,254,127,127
		DEFW	-761,127,127,127,127,127,127,127,0


; ,     
; DEFW X -  
; DEFB Y - 7..5 :  , 4..0  - . ( = 0)
;  : 000 (0) - PUTSPR; 001 (32) - MIR34; 010 (64) - MIR24; 011 (96) - MIR44;
;                   100 (128) - PUTSPR,MIR34; 101 (160) - MIR24,MIR44; 110 (192) - PUTSPR,MIR24; 111 (224) - MIR34,MIR44;
;                     11111111 (255) - PUTSPR,MIR24,MIR34,MIR44


ELEM11		DEFW	SPR0							; , 90 
		DEFB	0
		DEFW	SPR0
		DEFB	0
		DEFW	T901F0
                DEFB    0+10
                DEFW    T901F0
                DEFB    0+0
                DEFW    SPR0
                DEFB    0
                DEFW    T901F0
                DEFB    0+22
                DEFW    SPR0
                DEFB    0
                DEFW    T902F0
                DEFB    0+13
                DEFW    T902F0
                DEFB    0+5
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    T902F0
                DEFB    0+21
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    T903F0
                DEFB    0+14
                DEFW    T903F0
                DEFB    0+9
                DEFW    T903F0
                DEFB    0+3
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    T903F0
                DEFB    0+19
                DEFW    T903F0
                DEFB    0+25
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    T904F0
                DEFB    0+15
                DEFW    T904F0
                DEFB    0+11
                DEFW    T904F0
                DEFB    0+7
                DEFW    T904F0
                DEFB    0+2
                DEFW    SPR0
                DEFB    0
                DEFW    T904F0
                DEFB    0+19
                DEFW    T904F0
                DEFB    0+23
                DEFW    T904F0
                DEFB    0+28
                DEFW    SPR0
                DEFB    0
                DEFW    T905F0
                DEFB    0+15
                DEFW    T905F0
                DEFB    0+12
                DEFW    T905F0
                DEFB    0+9
                DEFW    T905F0
                DEFB    0+5
                DEFW    T905F0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    T905F0
                DEFB    0+18
                DEFW    T905F0
                DEFB    0+21
                DEFW    T905F0
                DEFB    0+24
                DEFW    T905F0
                DEFB    0+28
                DEFW    SPR0
                DEFB    0
                DEFW    T906F0
                DEFB    0+15
                DEFW    T906F0
                DEFB    0+12
                DEFW    T906F0
                DEFB    0+9
                DEFW    T906F0
                DEFB    0+6
                DEFW    T906F0
                DEFB    0+3
                DEFW    T906F0
                DEFB    0
                DEFW    T906F0
                DEFB    0+17
                DEFW    T906F0
                DEFB    0+20
                DEFW    T906F0
                DEFB    0+23
                DEFW    T906F0
                DEFB    0+26
                DEFW    T906F0
                DEFB    0+29


ELEM21          DEFW    T901F0                                                  ; , 45 
                DEFB    0+0
                DEFW    T901F0
                DEFB    0+22
                DEFW    T901F0
                DEFB    0+12
                DEFW    T902L1
                DEFB    0+0
                DEFW    T902L1
                DEFB    0+26
                DEFW    T902F0
                DEFB    0+0
                DEFW    T902F0
                DEFB    0+8
                DEFW    T902F0
                DEFB    0+18
                DEFW    T902F0
                DEFB    0+26
                DEFW    T903L1
                DEFB    0+14
                DEFW    T903L1
                DEFB    0+0
                DEFW    T903L1
                DEFB    0+6
                DEFW    T903L1
                DEFB    0+22
                DEFW    T903L1
                DEFB    0+28
                DEFW    T904L1
                DEFB    0+0
                DEFW    T904L1
                DEFB    0+5
                DEFW    T904L1
                DEFB    0+11
                DEFW    T904L1
                DEFB    0+18
                DEFW    T904L1
                DEFB    0+24
                DEFW    T904L1
                DEFB    0+29
                DEFW    T905L1
                DEFB    0+15
                DEFW    T905L1
                DEFB    0+0
                DEFW    T905L1
                DEFB    0+4
                DEFW    T905L1
                DEFB    0+9
                DEFW    T905L1
                DEFB    0+21
                DEFW    T905L1
                DEFB    0+26
                DEFW    SPR0
                DEFB    0
                DEFW    T906F0
                DEFB    0+0
                DEFW    T906F0
                DEFB    0+4
                DEFW    T906F0
                DEFB    0+8
                DEFW    T906F0
                DEFB    0+12
                DEFW    T906F0
                DEFB    0+17
                DEFW    T906F0
                DEFB    0+21
                DEFW    T906F0
                DEFB    0+25
                DEFW    T906F0
                DEFB    0+29

ELEM12		DUP	54							; , 90 
		DEFW	SPR0
		DEFB	0
		EDUP

ELEM22		DUP	35							; , 45 
		DEFW	SPR0
		DEFB	0
		EDUP


ELEM13		DEFW	S901L1							; , 90 
		DEFB	32
		DEFW	S901L1
		DEFB	96
		DEFW	S902F0
		DEFB	224
		DEFW	S902L1
		DEFB	32
		DEFW	S902L2
		DEFB	32
		DEFW	S902L1
		DEFB	96
		DEFW	S902L2
		DEFB	96
		DEFW	S903F0
		DEFB	224
		DEFW	S903L1
		DEFB	32
		DEFW	S903L2
		DEFB	32
		DEFW	S903L3
		DEFB	32
		DEFW	S903L1
		DEFB	96
		DEFW	S903L2
		DEFB	96
		DEFW	S903L3
		DEFB	96
		DEFW	S904F0
		DEFB	224
		DEFW	S904L1
		DEFB	32
		DEFW	S904L2
		DEFB	32
		DEFW	S904L3
		DEFB	32
		DEFW	S904L4
		DEFB	32
		DEFW	S904L1
		DEFB	96
		DEFW	S904L2
		DEFB	96
		DEFW	S904L3
		DEFB	96
		DEFW	S904L4
		DEFB	96
		DEFW	S905F0
		DEFB	224
		DEFW	S905L1
		DEFB	32
		DEFW	S905L2
		DEFB	32
		DEFW	S905L3
		DEFB	32
		DEFW	S905L4
		DEFB	32
		DEFW	S905L1
		DEFB	96
		DEFW	S905L2
		DEFB	96
		DEFW	S905L3
		DEFB	96
		DEFW	S905L4
		DEFB	96
		DEFW	S906F0
		DEFB	224
		DEFW	S906L1
		DEFB	32
		DEFW	S906L2
		DEFB	32
		DEFW	S906L3
		DEFB	32
		DEFW	S906L4
		DEFB	32
		DEFW	S906L5
		DEFB	32
		DEFW	S906L1
		DEFB	96
		DEFW	S906L2
		DEFB	96
		DEFW	S906L3
		DEFB	96
		DEFW	S906L4
		DEFB	96
		DEFW	S906L5
		DEFB	96
		DEFW	S907F0
		DEFB	224
		DEFW	S907L1
		DEFB	32
		DEFW	S907L2
		DEFB	32
		DEFW	S907L3
		DEFB	32
		DEFW	S907L4
		DEFB	32
		DEFW	S907L5
		DEFB	32
		DEFW	S907L1
		DEFB	96
		DEFW	S907L2
		DEFB	96
		DEFW	S907L3
		DEFB	96
		DEFW	S907L4
		DEFB	96
		DEFW	S907L5
		DEFB	96


ELEM23		DEFW	S452L1							; , 45 
		DEFB	32
		DEFW	S452L1
		DEFB	96
		DEFW	S453F0
		DEFB	224
		DEFW	S453L1
		DEFB	32
		DEFW	S453L1
		DEFB	96
		DEFW	S454L2
		DEFB	32
		DEFW	S454L1
		DEFB	32
		DEFW	S454L1
		DEFB	96
		DEFW	S454L2
		DEFB	96
		DEFW	S455F0
		DEFB	224
		DEFW	S455L2
		DEFB	32
		DEFW	S455L1
		DEFB	32
		DEFW	S455L1
		DEFB	96
		DEFW	S455L2
		DEFB	96
		DEFW	S456L3
		DEFB	32
		DEFW	S456L2
		DEFB	32
		DEFW	S456L1
		DEFB	32
		DEFW	S456L1
		DEFB	96
		DEFW	S456L2
		DEFB	96
		DEFW	S456L3
		DEFB	96
		DEFW	S457F0
		DEFB	224
		DEFW	S457L3
		DEFB	32
		DEFW	S457L2
		DEFB	32
		DEFW	S457L1
		DEFB	32
		DEFW	S457L1
		DEFB	96
		DEFW	S457L2
		DEFB	96
		DEFW	S457L3
		DEFB	96
		DEFW	S458L4
		DEFB	32
		DEFW	S458L3
		DEFB	32
		DEFW	S458L2
		DEFB	32
		DEFW	S458L1
		DEFB	32
		DEFW	S458L1
		DEFB	96
		DEFW	S458L2
		DEFB	96
		DEFW	S458L3
		DEFB	96
		DEFW	S458L4
		DEFB	96


ELEM14		DEFW	SPR0							; , 90 
		DEFB	0
		DEFW	SPR0
		DEFB	0
		DEFW	S902F0
		DEFB	128
		DEFW	S902F0
		DEFB	128
		DEFW	S902F0
		DEFB	128
		DEFW	S902F0
		DEFB	128
		DEFW	S902F0
		DEFB	128
		DEFW	S902F0
		DEFB	128
		DEFW	S903L1
		DEFB	32
		DEFW	S903L2
		DEFB	32
		DEFW	S903L3
		DEFB	32
		DEFW	S903L1
		DEFB	96
		DEFW	S903L2
		DEFB	96
		DEFW	S903L3
		DEFB	96
		DEFW	S904F0
		DEFB	224
		DEFW	S904L1
		DEFB	32
		DEFW	S904L2
		DEFB	32
		DEFW	S904L3
		DEFB	32
		DEFW	S904L4
		DEFB	32
		DEFW	S904L1
		DEFB	96
		DEFW	S904L2
		DEFB	96
		DEFW	S904L3
		DEFB	96
		DEFW	S904L4
		DEFB	96
		DEFW	S905F0
		DEFB	224
		DEFW	S905L1
		DEFB	32
		DEFW	S905L2
		DEFB	32
		DEFW	S905L3
		DEFB	32
		DEFW	S905L4
		DEFB	32
		DEFW	S905L1
		DEFB	96
		DEFW	S905L2
		DEFB	96
		DEFW	S905L3
		DEFB	96
		DEFW	S905L4
		DEFB	96
		DEFW	S906F0
		DEFB	224
		DEFW	S906L1
		DEFB	32
		DEFW	S906L2
		DEFB	32
		DEFW	S906L3
		DEFB	32
		DEFW	S906L4
		DEFB	32
		DEFW	S906L5
		DEFB	32
		DEFW	S906L1
		DEFB	96
		DEFW	S906L2
		DEFB	96
		DEFW	S906L3
		DEFB	96
		DEFW	S906L4
		DEFB	96
		DEFW	S906L5
		DEFB	96
		DEFW	S907F0
		DEFB	224
		DEFW	S907L1
		DEFB	32
		DEFW	S907L2
		DEFB	32
		DEFW	S907L3
		DEFB	32
		DEFW	S907L4
		DEFB	32
		DEFW	S907L5
		DEFB	32
		DEFW	S907L1
		DEFB	96
		DEFW	S907L2
		DEFB	96
		DEFW	S907L3
		DEFB	96
		DEFW	S907L4
		DEFB	96
		DEFW	S907L5
		DEFB	96


ELEM24		DEFW	S452L1							; , 45 
		DEFB	32
		DEFW	S452L1
		DEFB	96
		DEFW	S453F0
		DEFB	224
		DEFW	S453L1
		DEFB	32
		DEFW	S453L1
		DEFB	96
		DEFW	S454L2
		DEFB	32
		DEFW	S454L1
		DEFB	32
		DEFW	S454L1
		DEFB	96
		DEFW	S454L2
		DEFB	96
		DEFW	S455F0
		DEFB	224
		DEFW	S455L2
		DEFB	32
		DEFW	S455L1
		DEFB	32
		DEFW	S455L1
		DEFB	96
		DEFW	S455L2
		DEFB	96
		DEFW	S456L3
		DEFB	32
		DEFW	S456L2
		DEFB	32
		DEFW	S456L1
		DEFB	32
		DEFW	S456L1
		DEFB	96
		DEFW	S456L2
		DEFB	96
		DEFW	S456L3
		DEFB	96
		DEFW	S457F0
		DEFB	224
		DEFW	S457L3
		DEFB	32
		DEFW	S457L2
		DEFB	32
		DEFW	S457L1
		DEFB	32
		DEFW	S457L1
		DEFB	96
		DEFW	S457L2
		DEFB	96
		DEFW	S457L3
		DEFB	96
		DEFW	S458L4
		DEFB	32
		DEFW	S458L3
		DEFB	32
		DEFW	S458L2
		DEFB	32
		DEFW	S458L1
		DEFB	32
		DEFW	S458L1
		DEFB	96
		DEFW	S458L2
		DEFB	96
		DEFW	S458L3
		DEFB	96
		DEFW	S458L4
		DEFB	96



ELEM15		DEFW	S901L1							; , 90 
		DEFB	128
		DEFW	S901L1
		DEFB	160
		DEFW	S902F0
		DEFB	255
		DEFW	S902L1
		DEFB	128
		DEFW	S902L2
		DEFB	128
		DEFW	S902L1
		DEFB	160
		DEFW	S902L2
		DEFB	160
		DEFW	S903F0
		DEFB	255
		DEFW	S903L1
		DEFB	128
		DEFW	S903L2
		DEFB	128
		DEFW	S903L3
		DEFB	128
		DEFW	S903L1
		DEFB	160
		DEFW	S903L2
		DEFB	160
		DEFW	S903L3
		DEFB	160
		DEFW	S904F0
		DEFB	255
		DEFW	S904L1
		DEFB	128
		DEFW	S904L2
		DEFB	128
		DEFW	S904L3
		DEFB	128
		DEFW	S904L4
		DEFB	128
		DEFW	S904L1
		DEFB	160
		DEFW	S904L2
		DEFB	160
		DEFW	S904L3
		DEFB	160
		DEFW	S904L4
		DEFB	160
		DEFW	S905F0
		DEFB	255
		DEFW	S905L1
		DEFB	128
		DEFW	S905L2
		DEFB	128
		DEFW	S905L3
		DEFB	128
		DEFW	S905L4
		DEFB	128
		DEFW	S905L1
		DEFB	160
		DEFW	S905L2
		DEFB	160
		DEFW	S905L3
		DEFB	160
		DEFW	S905L4
		DEFB	160
		DEFW	S906F0
		DEFB	255
		DEFW	S906L1
		DEFB	128
		DEFW	S906L2
		DEFB	128
		DEFW	S906L3
		DEFB	128
		DEFW	S906L4
		DEFB	128
		DEFW	S906L5
		DEFB	128
		DEFW	S906L1
		DEFB	160
		DEFW	S906L2
		DEFB	160
		DEFW	S906L3
		DEFB	160
		DEFW	S906L4
		DEFB	160
		DEFW	S906L5
		DEFB	160
		DEFW	S907F0
		DEFB	255
		DEFW	S907L1
		DEFB	128
		DEFW	S907L2
		DEFB	128
		DEFW	S907L3
		DEFB	128
		DEFW	S907L4
		DEFB	128
		DEFW	S907L5
		DEFB	128
		DEFW	S907L1
		DEFB	160
		DEFW	S907L2
		DEFB	160
		DEFW	S907L3
		DEFB	160
		DEFW	S907L4
		DEFB	160
		DEFW	S907L5
		DEFB	160


ELEM25		DEFW	S452L1							; , 45 
		DEFB	128
		DEFW	S452L1
		DEFB	160
		DEFW	S453F0
		DEFB	255
		DEFW	S453L1
		DEFB	128
		DEFW	S453L1
		DEFB	160
		DEFW	S454L2
		DEFB	128
		DEFW	S454L1
		DEFB	128
		DEFW	S454L1
		DEFB	160
		DEFW	S454L2
		DEFB	160
		DEFW	S455F0
		DEFB	255
		DEFW	S455L2
		DEFB	128
		DEFW	S455L1
		DEFB	128
		DEFW	S455L1
		DEFB	160
		DEFW	S455L2
		DEFB	160
		DEFW	S456L3
		DEFB	128
		DEFW	S456L2
		DEFB	128
		DEFW	S456L1
		DEFB	128
		DEFW	S456L1
		DEFB	160
		DEFW	S456L2
		DEFB	160
		DEFW	S456L3
		DEFB	160
		DEFW	S457F0
		DEFB	255
		DEFW	S457L3
		DEFB	128
		DEFW	S457L2
		DEFB	128
		DEFW	S457L1
		DEFB	128
		DEFW	S457L1
		DEFB	160
		DEFW	S457L2
		DEFB	160
		DEFW	S457L3
		DEFB	160
		DEFW	S458L4
		DEFB	128
		DEFW	S458L3
		DEFB	128
		DEFW	S458L2
		DEFB	128
		DEFW	S458L1
		DEFB	128
		DEFW	S458L1
		DEFB	160
		DEFW	S458L2
		DEFB	160
		DEFW	S458L3
		DEFB	160
		DEFW	S458L4
		DEFB	160


ELEM16		DEFW	SPR0							;  , 90 
		DEFB	0
		DEFW	SPR0
		DEFB	0
		DEFW	VSR1F0
                DEFB    0+11
                DEFW    VSR1F0
                DEFB    0+1
                DEFW    SPR0
                DEFB    0
                DEFW    VSR1F0
                DEFB    0+23
                DEFW    SPR0
                DEFB    0
                DEFW    VSR2F0
                DEFB    0+14
                DEFW    VSR2F0
                DEFB    0+5
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VSR2F0
                DEFB    0+22
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VSR3F0
                DEFB    0+15
                DEFW    VST3F0
                DEFB    0+10
                DEFW    VSR3F0
                DEFB    0+3
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VSR3F0
                DEFB    0+20
                DEFW    VSR3F0
                DEFB    0+27
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VSR4F0
                DEFB    0+15
                DEFW    VSR4F0
                DEFB    0+11
                DEFW    VSR4F0
                DEFB    0+7
                DEFW    VSR4F0
                DEFB    0+2
                DEFW    SPR0
                DEFB    0
                DEFW    VSR4F0
                DEFB    0+19
                DEFW    VSR4F0
                DEFB    0+23
                DEFW    VSR4F0
                DEFB    0+28
                DEFW    SPR0
                DEFB    0
                DEFW    VSR5F0
                DEFB    0+15
                DEFW    VSR5F0
                DEFB    0+12
                DEFW    VSR5F0
                DEFB    0+8
                DEFW    VSR5F0
                DEFB    0+4
                DEFW    VSR5F0
                DEFB    0+1
                DEFW    SPR0
                DEFB    0
                DEFW    VSR5F0
                DEFB    0+18
                DEFW    VSR5F0
                DEFB    0+22
                DEFW    VSR5F0
                DEFB    0+25
                DEFW    VSR5F0
                DEFB    0+29
                DEFW    SPR0
                DEFB    0
                DEFW    VSR6F0
                DEFB    0+15
                DEFW    VSR6F0
                DEFB    0+12
                DEFW    VSR6F0
                DEFB    0+9
                DEFW    VSR6F0
                DEFB    0+6
                DEFW    VSR6F0
                DEFB    0+3
                DEFW    VSR6F0
                DEFB    0+0
                DEFW    VSR6F0
                DEFB    0+17
                DEFW    VSR6F0
                DEFB    0+20
                DEFW    VSR6F0
                DEFB    0+23
                DEFW    VSR6F0
                DEFB    0+26
                DEFW    VSR6F0
                DEFB    0+29


ELEM26          DEFW    VSR1F0                                                  ;  , 45 
                DEFB    0+0
                DEFW    VSR1F0
                DEFB    0+20
                DEFW    VSR1F0
                DEFB    0+11
                DEFW    VSR2F0
                DEFB    0+0
                DEFW    VSR2F0
                DEFB    0+26
                DEFW    VSR2F0
                DEFB    0+0
                DEFW    VSR2F0
                DEFB    0+8
                DEFW    VSR2F0
                DEFB    0+18
                DEFW    VSR2F0
                DEFB    0+27
                DEFW    VSR3F0
                DEFB    0+14
                DEFW    VSR3F0
                DEFB    0+0
                DEFW    VSR3F0
                DEFB    0+5
                DEFW    VSR3F0
                DEFB    0+22
                DEFW    VSR3F0
                DEFB    0+28
                DEFW    VSR4F0
                DEFB    0+0
                DEFW    VSR4F0
                DEFB    0+4
                DEFW    VSR4F0
                DEFB    0+10
                DEFW    VSR4F0
                DEFB    0+18
                DEFW    VSR4F0
                DEFB    0+24
                DEFW    VSR4F0
                DEFB    0+29
                DEFW    VSR5F0
                DEFB    0+14
                DEFW    VSR5F0
                DEFB    0+0
                DEFW    VSR5F0
                DEFB    0+4
                DEFW    VSR5F0
                DEFB    0+9
                DEFW    VSR5F0
                DEFB    0+20
                DEFW    VSR5F0
                DEFB    0+25
                DEFW    VSR5F0
                DEFB    0+29
                DEFW    VSR6F0
                DEFB    0+0
                DEFW    VSR6F0
                DEFB    0+4
                DEFW    VSR6F0
                DEFB    0+8
                DEFW    VSR6F0
                DEFB    0+12
                DEFW    VSR6F0
                DEFB    0+17
                DEFW    VSR6F0
                DEFB    0+21
                DEFW    VSR6F0
                DEFB    0+25
                DEFW    VSR6F0
                DEFB    0+29


ELEM17		DEFW	SPR0							;  , 90 
		DEFB	0
		DEFW	SPR0
		DEFB	0
		DEFW	VF1F0
                DEFB    0+10
                DEFW    VF1F0
                DEFB    0+0
                DEFW    SPR0
                DEFB    0
                DEFW    VF1F0
                DEFB    0+22
                DEFW    SPR0
                DEFB    0
                DEFW    VF2F0
                DEFB    0+14
                DEFW    VF2F0
                DEFB    0+5
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VF2F0
                DEFB    0+22
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VF3F0
                DEFB    0+14
                DEFW    VF3F0
                DEFB    0+9
                DEFW    VF3F0
                DEFB    0+2
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VF3F0
                DEFB    0+19
                DEFW    VF3F0
                DEFB    0+26
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VF4F0
                DEFB    0+15
                DEFW    VF4F0
                DEFB    0+11
                DEFW    VF4F0
                DEFB    0+7
                DEFW    VF4F0
                DEFB    0+2
                DEFW    SPR0
                DEFB    0
                DEFW    VF4F0
                DEFB    0+19
                DEFW    VF4F0
                DEFB    0+23
                DEFW    VF4F0
                DEFB    0+28
                DEFW    SPR0
                DEFB    0
                DEFW    VF5F0
                DEFB    0+15
                DEFW    VF5F0
                DEFB    0+12
                DEFW    VF5F0
                DEFB    0+8
                DEFW    VF5F0
                DEFB    0+4
                DEFW    VF5F0
                DEFB    0+1
                DEFW    SPR0
                DEFB    0
                DEFW    VF5F0
                DEFB    0+18
                DEFW    VF5F0
                DEFB    0+22
                DEFW    VF5F0
                DEFB    0+25
                DEFW    VF5F0
                DEFB    0+29
                DEFW    SPR0
                DEFB    0
                DEFW    VF6F0
                DEFB    0+15
                DEFW    VF6F0
                DEFB    0+12
                DEFW    VF6F0
                DEFB    0+9
                DEFW    VF6F0
                DEFB    0+6
                DEFW    VF6F0
                DEFB    0+3
                DEFW    VF6F0
                DEFB    0+0
                DEFW    VF6F0
                DEFB    0+17
                DEFW    VF6F0
                DEFB    0+20
                DEFW    VF6F0
                DEFB    0+23
                DEFW    VF6F0
                DEFB    0+26
                DEFW    VF6F0
                DEFB    0+29


ELEM27          DEFW    VF1F0                                                  ;  , 45 
                DEFB    0+0
                DEFW    VF1F0
                DEFB    0+20
                DEFW    VF1F0
                DEFB    0+11
                DEFW    VF2F0
                DEFB    0+0
                DEFW    VF2F0
                DEFB    0+26
                DEFW    VF2F0
                DEFB    0+0
                DEFW    VF2F0
                DEFB    0+8
                DEFW    VF2F0
                DEFB    0+18
                DEFW    VF2F0
                DEFB    0+27
                DEFW    VF3F0
                DEFB    0+14
                DEFW    VF3F0
                DEFB    0+0
                DEFW    VF3F0
                DEFB    0+5
                DEFW    VF3F0
                DEFB    0+22
                DEFW    VF3F0
                DEFB    0+28
                DEFW    VF4F0
                DEFB    0+0
                DEFW    VF4F0
                DEFB    0+4
                DEFW    VF4F0
                DEFB    0+10
                DEFW    VF4F0
                DEFB    0+18
                DEFW    VF4F0
                DEFB    0+24
                DEFW    VF4F0
                DEFB    0+29
                DEFW    VF5F0
                DEFB    0+14
                DEFW    VF5F0
                DEFB    0+0
                DEFW    VF5F0
                DEFB    0+4
                DEFW    VF5F0
                DEFB    0+9
                DEFW    VF5F0
                DEFB    0+20
                DEFW    VF5F0
                DEFB    0+25
                DEFW    VF5F0
                DEFB    0+29
                DEFW    VF6F0
                DEFB    0+0
                DEFW    VF6F0
                DEFB    0+4
                DEFW    VF6F0
                DEFB    0+8
                DEFW    VF6F0
                DEFB    0+12
                DEFW    VF6F0
                DEFB    0+17
                DEFW    VF6F0
                DEFB    0+21
                DEFW    VF6F0
                DEFB    0+25
                DEFW    VF6F0
                DEFB    0+29


ELEM18		DEFW	SPR0							;  , 90 
		DEFB	0
		DEFW	SPR0
		DEFB	0
		DEFW	VF1F0
                DEFB    0+10
                DEFW    VF1F0
                DEFB    0+0
                DEFW    SPR0
                DEFB    0
                DEFW    VF1F0
                DEFB    0+22
                DEFW    SPR0
                DEFB    0
                DEFW    VF2F0
                DEFB    0+14
                DEFW    VF2F0
                DEFB    0+5
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VF2F0
                DEFB    0+22
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VF3F0
                DEFB    0+14
                DEFW    VF3F0
                DEFB    0+9
                DEFW    VF3F0
                DEFB    0+2
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VF3F0
                DEFB    0+19
                DEFW    VF3F0
                DEFB    0+26
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VF4F0
                DEFB    0+15
                DEFW    VF4F0
                DEFB    0+11
                DEFW    VF4F0
                DEFB    0+7
                DEFW    VF4F0
                DEFB    0+2
                DEFW    SPR0
                DEFB    0
                DEFW    VF4F0
                DEFB    0+19
                DEFW    VF4F0
                DEFB    0+23
                DEFW    VF4F0
                DEFB    0+28
                DEFW    SPR0
                DEFB    0
                DEFW    VF5F0
                DEFB    0+15
                DEFW    VF5F0
                DEFB    0+12
                DEFW    VF5F0
                DEFB    0+8
                DEFW    VF5F0
                DEFB    0+4
                DEFW    VF5F0
                DEFB    0+1
                DEFW    SPR0
                DEFB    0
                DEFW    VF5F0
                DEFB    0+18
                DEFW    VF5F0
                DEFB    0+22
                DEFW    VF5F0
                DEFB    0+25
                DEFW    VF5F0
                DEFB    0+29
                DEFW    SPR0
                DEFB    0
                DEFW    VF6F0
                DEFB    0+15
                DEFW    VF6F0
                DEFB    0+12
                DEFW    VF6F0
                DEFB    0+9
                DEFW    VF6F0
                DEFB    0+6
                DEFW    VF6F0
                DEFB    0+3
                DEFW    VF6F0
                DEFB    0+0
                DEFW    VF6F0
                DEFB    0+17
                DEFW    VF6F0
                DEFB    0+20
                DEFW    VF6F0
                DEFB    0+23
                DEFW    VF6F0
                DEFB    0+26
                DEFW    VF6F0
                DEFB    0+29


ELEM28          DEFW    VF1F0                                                  ;  , 45 
                DEFB    0+0
                DEFW    VF1F0
                DEFB    0+20
                DEFW    VF1F0
                DEFB    0+11
                DEFW    VF2F0
                DEFB    0+0
                DEFW    VF2F0
                DEFB    0+26
                DEFW    VF2F0
                DEFB    0+0
                DEFW    VF2F0
                DEFB    0+8
                DEFW    VF2F0
                DEFB    0+18
                DEFW    VF2F0
                DEFB    0+27
                DEFW    VF3F0
                DEFB    0+14
                DEFW    VF3F0
                DEFB    0+0
                DEFW    VF3F0
                DEFB    0+5
                DEFW    VF3F0
                DEFB    0+22
                DEFW    VF3F0
                DEFB    0+28
                DEFW    VF4F0
                DEFB    0+0
                DEFW    VF4F0
                DEFB    0+4
                DEFW    VF4F0
                DEFB    0+10
                DEFW    VF4F0
                DEFB    0+18
                DEFW    VF4F0
                DEFB    0+24
                DEFW    VF4F0
                DEFB    0+29
                DEFW    VF5F0
                DEFB    0+14
                DEFW    VF5F0
                DEFB    0+0
                DEFW    VF5F0
                DEFB    0+4
                DEFW    VF5F0
                DEFB    0+9
                DEFW    VF5F0
                DEFB    0+20
                DEFW    VF5F0
                DEFB    0+25
                DEFW    VF5F0
                DEFB    0+29
                DEFW    VF6F0
                DEFB    0+0
                DEFW    VF6F0
                DEFB    0+4
                DEFW    VF6F0
                DEFB    0+8
                DEFW    VF6F0
                DEFB    0+12
                DEFW    VF6F0
                DEFB    0+17
                DEFW    VF6F0
                DEFB    0+21
                DEFW    VF6F0
                DEFB    0+25
                DEFW    VF6F0
                DEFB    0+29


ELEM19		DEFW	SPR0							;  , 90 
		DEFB	0
		DEFW	SPR0
		DEFB	0
		DEFW	VL1F0
                DEFB    0+13
                DEFW    VL1F0
                DEFB    0+3
                DEFW    SPR0
                DEFB    0
                DEFW    VL1F0
                DEFB    0+23
                DEFW    SPR0
                DEFB    0
                DEFW    VL2F0
                DEFB    0+16
                DEFW    VL2F0
                DEFB    0+7
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VL2F0
                DEFB    0+24
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VL3F0
                DEFB    0+15
                DEFW    VL3F0
                DEFB    0+10
                DEFW    VL3F0
                DEFB    0+3
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VL3F0
                DEFB    0+20
                DEFW    VL3F0
                DEFB    0+27
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VL4F0
                DEFB    0+16
                DEFW    VL4F0
                DEFB    0+12
                DEFW    VL4F0
                DEFB    0+8
                DEFW    VL4F0
                DEFB    0+3
                DEFW    SPR0
                DEFB    0
                DEFW    VL4F0
                DEFB    0+20
                DEFW    VL4F0
                DEFB    0+24
                DEFW    VL4F0
                DEFB    0+28
                DEFW    SPR0
                DEFB    0
                DEFW    VL5F0
                DEFB    0+16
                DEFW    VL5F0
                DEFB    0+13
                DEFW    VL5F0
                DEFB    0+9
                DEFW    VL5F0
                DEFB    0+5
                DEFW    VL5F0
                DEFB    0+2
                DEFW    SPR0
                DEFB    0
                DEFW    VL5F0
                DEFB    0+19
                DEFW    VL5F0
                DEFB    0+23
                DEFW    VL5F0
                DEFB    0+26
                DEFW    VL5F0
                DEFB    0+30
                DEFW    SPR0
                DEFB    0
                DEFW    VL6F0
                DEFB    0+16
                DEFW    VL6F0
                DEFB    0+13
                DEFW    VL6F0
                DEFB    0+10
                DEFW    VL6F0
                DEFB    0+7
                DEFW    VL6F0
                DEFB    0+4
                DEFW    VL6F0
                DEFB    0+1
                DEFW    VL6F0
                DEFB    0+18
                DEFW    VL6F0
                DEFB    0+21
                DEFW    VL6F0
                DEFB    0+24
                DEFW    VL6F0
                DEFB    0+27
                DEFW    VL6F0
                DEFB    0+30


ELEM29          DEFW    VL1F0                                                  ;  , 45 
                DEFB    0+3
                DEFW    VL1F0
                DEFB    0+23
                DEFW    VL1F0
                DEFB    0+14
                DEFW    VL2F0
                DEFB    0+2
                DEFW    VL2F0
                DEFB    0+28
                DEFW    VL2F0
                DEFB    0+2
                DEFW    VL2F0
                DEFB    0+10
                DEFW    VL2F0
                DEFB    0+20
                DEFW    VL2F0
                DEFB    0+29
                DEFW    VL3F0
                DEFB    0+15
                DEFW    VL3F0
                DEFB    0+1
                DEFW    VL3F0
                DEFB    0+6
                DEFW    VL3F0
                DEFB    0+23
                DEFW    VL3F0
                DEFB    0+28
                DEFW    VL4F0
                DEFB    0+1
                DEFW    VL4F0
                DEFB    0+5
                DEFW    VL4F0
                DEFB    0+11
                DEFW    VL4F0
                DEFB    0+19
                DEFW    VL4F0
                DEFB    0+25
                DEFW    VL4F0
                DEFB    0+29
                DEFW    VL5F0
                DEFB    0+15
                DEFW    VL5F0
                DEFB    0+1
                DEFW    VL5F0
                DEFB    0+5
                DEFW    VL5F0
                DEFB    0+10
                DEFW    VL5F0
                DEFB    0+21
                DEFW    VL5F0
                DEFB    0+26
                DEFW    VL5F0
                DEFB    0+30
                DEFW    VL6F0
                DEFB    0+1
                DEFW    VL6F0
                DEFB    0+5
                DEFW    VL6F0
                DEFB    0+9
                DEFW    VL6F0
                DEFB    0+13
                DEFW    VL6F0
                DEFB    0+18
                DEFW    VL6F0
                DEFB    0+22
                DEFW    VL6F0
                DEFB    0+26
                DEFW    VL6F0
                DEFB    0+30


ELEM1A		DEFW	SPR0							;  , 90 
		DEFB	0
		DEFW	SPR0
		DEFB	0
		DEFW	VL1F0
                DEFB    0+7
                DEFW    VL1F0
                DEFB    0+0
                DEFW    SPR0
                DEFB    0
                DEFW    VL1F0
                DEFB    0+19
                DEFW    SPR0
                DEFB    0
                DEFW    VL2F0
                DEFB    0+12
                DEFW    VL2F0
                DEFB    0+3
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VL2F0
                DEFB    0+20
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VL3F0
                DEFB    0+11
                DEFW    VL3F0
                DEFB    0+8
                DEFW    VL3F0
                DEFB    0+1
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VL3F0
                DEFB    0+18
                DEFW    VL3F0
                DEFB    0+25
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VL4F0
                DEFB    0+14
                DEFW    VL4F0
                DEFB    0+10
                DEFW    VL4F0
                DEFB    0+6
                DEFW    VL4F0
                DEFB    0+1
                DEFW    SPR0
                DEFB    0
                DEFW    VL4F0
                DEFB    0+18
                DEFW    VL4F0
                DEFB    0+22
                DEFW    VL4F0
                DEFB    0+27
                DEFW    SPR0
                DEFB    0
                DEFW    VL5F0
                DEFB    0+14
                DEFW    VL5F0
                DEFB    0+11
                DEFW    VL5F0
                DEFB    0+7
                DEFW    VL5F0
                DEFB    0+3
                DEFW    VL5F0
                DEFB    0+0
                DEFW    SPR0
                DEFB    0
                DEFW    VL5F0
                DEFB    0+17
                DEFW    VL5F0
                DEFB    0+21
                DEFW    VL5F0
                DEFB    0+24
                DEFW    VL5F0
                DEFB    0+28
                DEFW    SPR0
                DEFB    0
                DEFW    VL6F0
                DEFB    0+14
                DEFW    VL6F0
                DEFB    0+11
                DEFW    VL6F0
                DEFB    0+8
                DEFW    VL6F0
                DEFB    0+5
                DEFW    VL6F0
                DEFB    0+2
                DEFW    VL6F0
                DEFB    0+0
                DEFW    VL6F0
                DEFB    0+16
                DEFW    VL6F0
                DEFB    0+19
                DEFW    VL6F0
                DEFB    0+22
                DEFW    VL6F0
                DEFB    0+25
                DEFW    VL6F0
                DEFB    0+28


ELEM2A          DEFW    VL1F0                                                  ;  , 45 
                DEFB    0+0
                DEFW    VL1F0
                DEFB    0+17
                DEFW    VL1F0
                DEFB    0+8
                DEFW    VL2F0
                DEFB    0+0
                DEFW    VL2F0
                DEFB    0+24
                DEFW    VL2F0
                DEFB    0+0
                DEFW    VL2F0
                DEFB    0+6
                DEFW    VL2F0
                DEFB    0+16
                DEFW    VL2F0
                DEFB    0+25
                DEFW    VL3F0
                DEFB    0+13
                DEFW    VL3F0
                DEFB    0+0
                DEFW    VL3F0
                DEFB    0+4
                DEFW    VL3F0
                DEFB    0+21
                DEFW    VL3F0
                DEFB    0+27
                DEFW    VL4F0
                DEFB    0+0
                DEFW    VL4F0
                DEFB    0+3
                DEFW    VL4F0
                DEFB    0+9
                DEFW    VL4F0
                DEFB    0+17
                DEFW    VL4F0
                DEFB    0+23
                DEFW    VL4F0
                DEFB    0+28
                DEFW    VL5F0
                DEFB    0+13
                DEFW    VL5F0
                DEFB    0+0
                DEFW    VL5F0
                DEFB    0+3
                DEFW    VL5F0
                DEFB    0+8
                DEFW    VL5F0
                DEFB    0+19
                DEFW    VL5F0
                DEFB    0+24
                DEFW    VL5F0
                DEFB    0+28
                DEFW    VL6F0
                DEFB    0+0
                DEFW    VL6F0
                DEFB    0+3
                DEFW    VL6F0
                DEFB    0+7
                DEFW    VL6F0
                DEFB    0+11
                DEFW    VL6F0
                DEFB    0+16
                DEFW    VL6F0
                DEFB    0+20
                DEFW    VL6F0
                DEFB    0+24
                DEFW    VL6F0
                DEFB    0+28



ELEM1B		DEFW	SPR0							;  , 90 
		DEFB	0
		DEFW	SPR0
		DEFB	0
		DEFW	VSR1F0
                DEFB    0+11
                DEFW    VSR1F0
                DEFB    0+1
                DEFW    SPR0
                DEFB    0
                DEFW    VSR1F0
                DEFB    0+23
                DEFW    SPR0
                DEFB    0
                DEFW    VSR2F0
                DEFB    0+14
                DEFW    VSR2F0
                DEFB    0+5
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VSR2F0
                DEFB    0+22
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VSR3F0
                DEFB    0+15
                DEFW    VST3F0
                DEFB    0+10
                DEFW    VSR3F0
                DEFB    0+3
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VSR3F0
                DEFB    0+20
                DEFW    VSR3F0
                DEFB    0+27
                DEFW    SPR0
                DEFB    0
                DEFW    SPR0
                DEFB    0
                DEFW    VSR4F0
                DEFB    0+15
                DEFW    VSR4F0
                DEFB    0+11
                DEFW    VSR4F0
                DEFB    0+7
                DEFW    VSR4F0
                DEFB    0+2
                DEFW    SPR0
                DEFB    0
                DEFW    VSR4F0
                DEFB    0+19
                DEFW    VSR4F0
                DEFB    0+23
                DEFW    VSR4F0
                DEFB    0+28
                DEFW    SPR0
                DEFB    0
                DEFW    VSR5F0
                DEFB    0+15
                DEFW    VSR5F0
                DEFB    0+12
                DEFW    VSR5F0
                DEFB    0+8
                DEFW    VSR5F0
                DEFB    0+4
                DEFW    VSR5F0
                DEFB    0+1
                DEFW    SPR0
                DEFB    0
                DEFW    VSR5F0
                DEFB    0+18
                DEFW    VSR5F0
                DEFB    0+22
                DEFW    VSR5F0
                DEFB    0+25
                DEFW    VSR5F0
                DEFB    0+29
                DEFW    SPR0
                DEFB    0
                DEFW    VSR6F0
                DEFB    0+15
                DEFW    VSR6F0
                DEFB    0+12
                DEFW    VSR6F0
                DEFB    0+9
                DEFW    VSR6F0
                DEFB    0+6
                DEFW    VSR6F0
                DEFB    0+3
                DEFW    VSR6F0
                DEFB    0+0
                DEFW    VSR6F0
                DEFB    0+17
                DEFW    VSR6F0
                DEFB    0+20
                DEFW    VSR6F0
                DEFB    0+23
                DEFW    VSR6F0
                DEFB    0+26
                DEFW    VSR6F0
                DEFB    0+29


ELEM2B          DEFW    VSR1F0                                                  ;  , 45 
                DEFB    0+0
                DEFW    VSR1F0
                DEFB    0+20
                DEFW    VSR1F0
                DEFB    0+11
                DEFW    VSR2F0
                DEFB    0+0
                DEFW    VSR2F0
                DEFB    0+26
                DEFW    VSR2F0
                DEFB    0+0
                DEFW    VSR2F0
                DEFB    0+8
                DEFW    VSR2F0
                DEFB    0+18
                DEFW    VSR2F0
                DEFB    0+27
                DEFW    VSR3F0
                DEFB    0+14
                DEFW    VSR3F0
                DEFB    0+0
                DEFW    VSR3F0
                DEFB    0+5
                DEFW    VSR3F0
                DEFB    0+22
                DEFW    VSR3F0
                DEFB    0+28
                DEFW    VSR4F0
                DEFB    0+0
                DEFW    VSR4F0
                DEFB    0+4
                DEFW    VSR4F0
                DEFB    0+10
                DEFW    VSR4F0
                DEFB    0+18
                DEFW    VSR4F0
                DEFB    0+24
                DEFW    VSR4F0
                DEFB    0+29
                DEFW    VSR5F0
                DEFB    0+14
                DEFW    VSR5F0
                DEFB    0+0
                DEFW    VSR5F0
                DEFB    0+4
                DEFW    VSR5F0
                DEFB    0+9
                DEFW    VSR5F0
                DEFB    0+20
                DEFW    VSR5F0
                DEFB    0+25
                DEFW    VSR5F0
                DEFB    0+29
                DEFW    VSR6F0
                DEFB    0+0
                DEFW    VSR6F0
                DEFB    0+4
                DEFW    VSR6F0
                DEFB    0+8
                DEFW    VSR6F0
                DEFB    0+12
                DEFW    VSR6F0
                DEFB    0+17
                DEFW    VSR6F0
                DEFB    0+21
                DEFW    VSR6F0
                DEFB    0+25
                DEFW    VSR6F0
                DEFB    0+29


SPR0		DEFB	0				;   -  

;  

ORUZH
DEFB 29
DEFB 128+17,18, 0,0,0,0,127,227,227,241
DEFB 192+17,19, 0,0,0,0,192,240,248,254
DEFB 128+18,18, 255,254,252,254,255,255,127,63
DEFB 64+18,19, 255,31,31,15,7,195,225,240
DEFB 192+18,20, 0,128,192,240,248,252,254,255
DEFB 128+19,18, 63,63,63,63,31,31,31,15
DEFB 64+19,19, 240,248,252,254,254,255,255,255
DEFB 64+19,20, 127,63,63,96,56,5,128,159
DEFB 192+19,21, 224,240,248,124,60,126,254,254
DEFB 128+20,18, 7,3,3,2,2,3,7,8
DEFB 64+20,19, 255,255,255,255,127,127,255,63
DEFB 64+20,20, 255,255,255,255,255,255,255,255
DEFB 64+20,21, 254,254,254,254,254,254,255,255
DEFB 192+20,22, 0,0,0,0,0,0,0,128
DEFB 128+21,18, 16,32,32,32,32,48,60,30
DEFB 64+21,19, 31,3,1,0,0,0,0,0
DEFB 64+21,20, 255,255,255,255,63,7,1,0
DEFB 64+21,21, 255,253,253,244,240,248,96,0
DEFB 192+21,22, 192,192,224,112,48,120,168,56
DEFB 128+22,18, 31,15,7,7,0,0,2,3
DEFB 64+22,19, 128,128,192,240,240,248,248,252
DEFB 64+22,20, 0,0,0,0,0,0,0,0
DEFB 64+22,21, 0,0,0,8,0,0,0,0
DEFB 192+22,22, 60,12,28,12,28,62,14,30
DEFB 128+23,18, 3,1,0,0,0,0,1,1
DEFB 64+23,19, 124,254,255,127,95,159,191,255
DEFB 64+23,20, 0,0,0,128,128,192,224,224
DEFB 64+23,21, 0,0,0,0,0,0,0,0
DEFB 192+23,22, 2,7,13,7,7,3,1,1

; : 291 


;  

T901F0
DEFB 28
DEFB 128+16,7, 0,0,0,0,0,0,0,56
DEFB 128+17,1, 0,0,0,0,0,0,0,15
DEFB 128+17,2, 0,0,0,0,0,0,7,255
DEFB 128+17,3, 0,0,0,0,0,7,255,255
DEFB 128+17,4, 0,0,29,126,255,255,255,255
DEFB 128+17,5, 31,59,255,255,255,239,255,255
DEFB 128+17,6, 225,255,255,255,255,255,255,255
DEFB 64+17,7, 252,254,254,255,255,253,253,255
DEFB 192+17,8, 0,0,0,0,128,128,128,128
DEFB 128+18,0, 0,0,0,3,31,63,56,0
DEFB 64+18,1, 127,255,255,243,255,127,127,248
DEFB 64+18,2, 255,255,255,253,231,255,127,127
DEFB 64+18,3, 255,255,127,255,255,255,255,255
DEFB 128+18,4, 255,255,255,255,243,195,129,0
DEFB 64+18,5, 255,255,255,255,255,255,255,127
DEFB 64+18,6, 255,255,255,255,255,254,252,248
DEFB 64+18,7, 255,255,255,127,63,15,7,3
DEFB 64+18,8, 216,223,255,255,253,255,255,255
DEFB 192+18,9, 0,128,224,224,224,0,192,192
DEFB 128+19,0, 7,63,62,56,0,0,0,0
DEFB 128+19,1, 240,128,0,0,0,0,0,0
DEFB 128+19,2, 127,255,127,127,12,0,0,0
DEFB 192+19,3, 255,252,248,224,0,0,0,0
DEFB 128+19,5, 63,0,0,0,0,0,0,0
DEFB 128+19,6, 248,0,0,0,0,0,0,0
DEFB 128+19,7, 1,1,0,0,0,0,0,0
DEFB 128+19,8, 255,255,255,127,127,7,0,0
DEFB 192+19,9, 240,248,254,254,252,224,0,0

T902F0
DEFB 11
DEFB 128+14,0, 0,0,0,0,0,0,0,1
DEFB 128+14,1, 0,0,0,0,0,63,63,255
DEFB 128+14,2, 0,0,0,7,127,255,255,255
DEFB 128+14,3, 0,0,127,255,255,255,255,255
DEFB 192+14,4, 0,192,224,224,240,248,255,255
DEFB 128+15,0, 1,1,1,0,0,0,0,0
DEFB 128+15,1, 255,255,195,1,0,0,0,0
DEFB 128+15,2, 253,248,240,128,0,0,0,0
DEFB 128+15,3, 254,252,0,0,0,0,0,0
DEFB 128+15,4, 127,63,31,31,0,0,0,0
DEFB 192+15,5, 0,128,192,128,0,0,0,0

T902L1
DEFB 11
DEFB 128+15,0, 0,0,0,0,0,0,0,1
DEFB 128+15,1, 0,0,0,0,0,63,63,255
DEFB 128+15,2, 0,0,0,7,127,255,255,255
DEFB 128+15,3, 0,0,127,255,255,255,255,255
DEFB 192+15,4, 0,192,224,224,240,248,255,255
DEFB 128+16,0, 1,1,1,0,0,0,0,0
DEFB 128+16,1, 255,255,195,1,0,0,0,0
DEFB 128+16,2, 253,248,240,128,0,0,0,0
DEFB 128+16,3, 254,252,0,0,0,0,0,0
DEFB 128+16,4, 127,63,31,31,0,0,0,0
DEFB 192+16,5, 0,128,192,128,0,0,0,0
  
T903F0
DEFB 8
DEFB 128+13,0, 0,0,0,0,0,0,1,7
DEFB 128+13,1, 0,0,0,0,3,255,255,255
DEFB 128+13,2, 0,0,0,102,255,255,255,255
DEFB 192+13,3, 0,0,0,0,0,0,224,224
DEFB 128+14,0, 7,6,0,0,0,0,0,0
DEFB 128+14,1, 252,124,0,0,0,0,0,0
DEFB 128+14,2, 251,1,0,0,0,0,0,0
DEFB 192+14,3, 224,240,64,0,0,0,0,0

T903L1
DEFB 8
DEFB 128+14,0, 0,0,0,0,0,0,1,7
DEFB 128+14,1, 0,0,0,0,3,255,255,255
DEFB 128+14,2, 0,0,0,102,255,255,255,255
DEFB 192+14,3, 0,0,0,0,0,0,224,224
DEFB 128+15,0, 7,6,0,0,0,0,0,0
DEFB 128+15,1, 252,124,0,0,0,0,0,0
DEFB 128+15,2, 251,1,0,0,0,0,0,0
DEFB 192+15,3, 224,240,64,0,0,0,0,0
  
T904F0
DEFB 3
DEFB 128+13,0, 0,3,127,255,254,156,0,0
DEFB 128+13,1, 120,252,255,255,255,7,0,0
DEFB 192+13,2, 0,0,0,0,128,128,0,0

T904L1
DEFB 3
DEFB 128+14,0, 0,3,127,255,254,156,0,0
DEFB 128+14,1, 120,252,255,255,255,7,0,0
DEFB 192+14,2, 0,0,0,0,128,128,0,0
  
T905F0
DEFB 2
DEFB 128+13,0, 1,31,63,62,0,0,0,0
DEFB 192+13,1, 248,254,254,14,0,0,0,0

T905L1
DEFB 2
DEFB 128+13,0, 0,0,0,0,1,31,63,62
DEFB 192+13,1, 0,0,0,0,248,254,254,14
  
T906F0
DEFB 4
DEFB 128+12,0, 0,0,0,0,0,0,15,31
DEFB 192+12,1, 0,0,0,0,0,112,240,252
DEFB 128+13,0, 31,0,0,0,0,0,0,0
DEFB 192+13,1, 252,0,0,0,0,0,0,0

; : 607 


;  



;      90 


S901L1
DEFB 81
DEFB 64+0,0, 254,58,29,7,3,1,0,0
DEFB 64+0,1, 3,0,0,128,192,240,120,60
DEFB 64+0,2, 240,208,120,60,30,7,3,1
DEFB 64+0,3, 120,24,14,7,3,128,192,224
DEFB 64+0,4, 0,0,0,0,128,192,224,48
DEFB 64+1,0, 128,128,224,240,252,62,11,13
DEFB 64+1,1, 31,7,3,1,0,0,0,192
DEFB 64+1,2, 0,128,192,224,248,60,62,63
DEFB 64+1,3, 240,120,28,14,7,7,7,134
DEFB 64+1,4, 24,12,4,3,131,195,227,243
DEFB 192+1,5, 0,0,0,0,128,192,96,48
DEFB 64+2,0, 15,14,14,14,14,142,238,254
DEFB 64+2,1, 224,248,62,31,7,3,1,0
DEFB 64+2,2, 51,49,48,48,176,240,208,124
DEFB 64+2,3, 198,230,126,62,30,15,3,1
DEFB 64+2,4, 59,31,15,7,3,129,192,224
DEFB 64+2,5, 24,14,6,131,193,224,112,56
DEFB 192+2,6, 0,0,0,0,192,224,112,16
DEFB 64+3,0, 250,57,15,3,1,0,0,0
DEFB 64+3,1, 0,0,192,224,248,126,31,7
DEFB 64+3,2, 62,15,7,1,0,0,0,192
DEFB 64+3,3, 0,128,192,240,120,62,15,7
DEFB 64+3,4, 240,60,30,15,7,3,3,195
DEFB 64+3,5, 30,15,7,7,198,230,246,126
DEFB 192+3,6, 8,8,136,200,232,120,56,24
DEFB 64+4,0, 0,128,224,248,254,63,9,15
DEFB 64+4,1, 3,0,0,0,0,128,224,248
DEFB 64+4,2, 240,248,46,63,55,49,48,48
DEFB 64+4,3, 7,6,6,134,230,254,126,31
DEFB 64+4,4, 227,251,63,31,7,3,0,0
DEFB 64+4,5, 30,15,3,1,128,224,240,124
DEFB 192+4,6, 8,8,136,232,248,120,16,8
DEFB 64+5,0, 14,14,14,14,14,142,238,254
DEFB 64+5,1, 254,63,7,3,0,0,0,0
DEFB 64+5,2, 48,176,240,200,254,31,7,1
DEFB 64+5,3, 15,3,0,0,0,128,224,248
DEFB 64+5,4, 192,224,248,62,31,5,3,3
DEFB 64+5,5, 30,15,7,7,6,198,246,126
DEFB 192+5,6, 8,8,200,248,120,56,8,8
DEFB 64+6,0, 249,63,15,1,0,0,0,0
DEFB 64+6,1, 0,192,248,254,63,15,1,0
DEFB 64+6,2, 0,0,0,0,192,240,254,111
DEFB 64+6,3, 126,27,7,6,6,6,6,198
DEFB 64+6,4, 3,131,243,255,63,15,3,0
DEFB 64+6,5, 62,15,3,0,0,192,240,252
DEFB 192+6,6, 8,136,232,248,120,24,8,8
DEFB 64+7,0, 0,0,224,252,255,57,15,14
DEFB 64+7,1, 0,0,0,0,192,248,255,127
DEFB 64+7,2, 63,49,48,48,48,48,48,240
DEFB 64+7,3, 246,254,127,15,1,0,0,0
DEFB 64+7,4, 0,0,128,240,252,63,13,3
DEFB 64+7,5, 63,15,7,6,6,134,246,254
DEFB 192+7,6, 8,200,248,240,24,8,8,8
DEFB 64+8,0, 14,14,14,14,14,14,238,251
DEFB 64+8,1, 15,0,0,0,0,0,0,0
DEFB 64+8,2, 206,255,31,1,0,0,0,0
DEFB 64+8,3, 0,192,252,255,59,7,6,6
DEFB 64+8,4, 3,3,3,131,243,255,63,7
DEFB 64+8,5, 127,15,1,0,0,0,224,254
DEFB 192+8,6, 136,232,248,56,8,8,8,8
DEFB 64+9,0, 249,127,3,0,0,0,0,0
DEFB 64+9,1, 240,255,255,31,0,0,0,0
DEFB 64+9,2, 0,128,252,223,111,49,48,48
DEFB 64+9,3, 6,6,6,230,251,255,15,0
DEFB 64+9,4, 0,0,0,0,128,248,255,61
DEFB 64+9,5, 127,15,6,6,6,6,198,254
DEFB 192+9,6, 200,248,248,24,8,8,8,8
DEFB 64+10,0, 0,0,224,255,255,249,14,14
DEFB 64+10,1, 0,0,0,240,255,255,31,0
DEFB 64+10,2, 48,48,48,48,248,207,255,3
DEFB 64+10,3, 0,0,0,0,0,254,255,251
DEFB 64+10,4, 3,3,3,3,3,3,255,255
DEFB 64+10,5, 255,15,0,0,0,0,0,255
DEFB 192+10,6, 248,248,56,8,8,8,8,200
DEFB 64+11,0, 14,14,14,14,14,14,238,249
DEFB 64+11,1, 0,0,0,0,0,0,0,255
DEFB 64+11,2, 0,0,0,0,0,0,0,255
DEFB 64+11,3, 6,6,6,6,6,6,6,251
DEFB 64+11,4, 127,0,0,0,0,0,0,255
DEFB 64+11,5, 255,15,6,6,6,6,6,255
DEFB 192+11,6, 240,248,8,8,8,8,8,248

S902L2
DEFB 16
DEFB 64+6,0, 0,0,0,0,0,0,0,128
DEFB 64+7,0, 240,159,131,224,252,31,25,248
DEFB 128+7,1, 0,0,224,252,207,192,248,63
DEFB 192+7,2, 0,0,0,0,128,192,64,192
DEFB 64+8,0, 254,159,129,224,254,31,24,248
DEFB 64+8,1, 7,230,254,223,193,240,255,15
DEFB 192+8,2, 192,64,64,192,192,64,64,192
DEFB 64+9,0, 255,159,128,224,255,31,24,248
DEFB 64+9,1, 6,254,255,195,192,254,63,6
DEFB 192+9,2, 64,64,192,192,64,64,192,192
DEFB 64+10,0, 255,143,128,224,255,31,24,248
DEFB 64+10,1, 230,255,207,192,248,255,6,6
DEFB 192+10,2, 64,192,192,64,64,192,192,64
DEFB 64+11,0, 255,131,128,224,255,24,24,248
DEFB 64+11,1, 255,255,192,192,255,31,6,6
DEFB 192+11,2, 192,192,64,64,192,192,64,64

S902L1
DEFB 98
DEFB 64+3,0, 255,0,0,0,0,0,255,255
DEFB 128+3,1, 63,192,192,192,192,192,255,255
DEFB 128+3,2, 255,0,0,0,0,0,255,239
DEFB 128+3,3, 253,7,7,7,7,7,255,255
DEFB 128+3,4, 255,0,0,0,0,0,255,255
DEFB 128+3,5, 255,0,0,0,0,0,255,191
DEFB 128+3,6, 244,30,27,25,24,24,252,254
DEFB 192+3,7, 0,0,0,128,192,96,48,24
DEFB 64+4,0, 0,0,0,0,0,255,255,255
DEFB 64+4,1, 0,0,0,0,0,255,255,255
DEFB 64+4,2, 24,24,24,24,24,255,255,255
DEFB 64+4,3, 0,0,0,0,0,255,255,255
DEFB 64+4,4, 0,0,0,0,0,255,255,255
DEFB 64+4,5, 224,224,224,224,224,255,255,255
DEFB 64+4,6, 31,31,25,24,24,248,252,255
DEFB 64+4,7, 12,134,195,227,114,126,126,103
DEFB 192+4,8, 0,0,0,128,224,96,56,28
DEFB 64+5,0, 0,0,0,0,255,255,255,0
DEFB 64+5,1, 192,192,192,192,255,255,255,0
DEFB 64+5,2, 0,0,0,0,255,255,255,24
DEFB 64+5,3, 7,7,7,7,255,255,255,0
DEFB 64+5,4, 0,0,0,0,255,255,255,0
DEFB 64+5,5, 0,0,0,0,255,255,255,224
DEFB 64+5,6, 31,25,24,24,248,252,255,31
DEFB 64+5,7, 227,225,240,120,28,15,7,131
DEFB 64+5,8, 140,199,231,126,62,46,167,227
DEFB 192+5,9, 0,0,128,192,96,48,16,140
DEFB 64+6,0, 0,0,0,0,255,255,0,0
DEFB 64+6,1, 0,0,0,0,255,63,192,192
DEFB 64+6,2, 24,24,24,24,239,255,0,0
DEFB 64+6,3, 0,0,0,0,255,253,7,7
DEFB 64+6,4, 0,0,0,0,255,255,0,0
DEFB 64+6,5, 224,224,224,224,191,255,0,0
DEFB 64+6,6, 25,24,24,24,252,247,31,25
DEFB 64+6,7, 226,242,126,126,103,99,224,224
DEFB 64+6,8, 225,120,28,14,135,199,246,126
DEFB 64+6,9, 206,235,121,92,206,199,227,123
DEFB 192+6,10, 0,0,128,192,96,112,216,204
DEFB 64+7,0, 0,0,0,255,255,0,0,0
DEFB 64+7,1, 192,192,192,63,255,0,0,0
DEFB 64+7,2, 0,0,0,255,239,24,24,24
DEFB 64+7,3, 7,7,7,253,255,0,0,0
DEFB 64+7,4, 0,0,0,255,255,0,0,0
DEFB 64+7,5, 0,0,0,255,191,224,224,224
DEFB 64+7,6, 24,24,24,252,255,31,25,24
DEFB 64+7,7, 120,62,15,3,3,194,242,126
DEFB 64+7,8, 62,47,163,225,240,124,30,7
DEFB 64+7,9, 63,15,207,235,120,124,79,199
DEFB 64+7,10, 246,63,157,222,247,115,127,207
DEFB 192+7,11, 0,128,192,224,240,144,208,112
DEFB 64+8,0, 0,0,255,255,255,0,0,0
DEFB 64+8,1, 0,0,255,255,255,192,192,192
DEFB 64+8,2, 24,24,255,255,255,0,0,0
DEFB 64+8,3, 0,0,255,255,255,7,7,7
DEFB 64+8,4, 0,0,255,255,255,0,0,0
DEFB 64+8,5, 224,224,255,255,255,0,0,0
DEFB 64+8,6, 24,24,252,255,255,25,24,24
DEFB 64+8,7, 127,103,97,96,224,248,127,15
DEFB 64+8,8, 7,230,254,126,63,35,32,224
DEFB 64+8,9, 227,251,63,15,139,233,248,126
DEFB 64+8,10, 231,247,60,30,215,243,123,95
DEFB 192+8,11, 48,240,240,240,176,208,240,112
DEFB 64+9,0, 0,255,255,255,0,0,0,0
DEFB 64+9,1, 192,255,255,255,0,0,0,0
DEFB 64+9,2, 0,255,255,255,24,24,24,24
DEFB 64+9,3, 7,255,255,255,0,0,0,0
DEFB 64+9,4, 0,255,255,255,0,0,0,0
DEFB 64+9,5, 0,255,255,255,224,224,224,224
DEFB 64+9,6, 24,248,255,255,25,24,24,24
DEFB 64+9,7, 3,2,130,242,254,127,99,96
DEFB 64+9,8, 248,127,15,7,6,230,254,63
DEFB 64+9,9, 79,67,195,251,127,15,9,136
DEFB 64+9,10, 199,231,252,62,31,211,243,127
DEFB 192+9,11, 176,240,240,176,144,240,112,48
DEFB 64+10,0, 0,255,255,0,0,0,0,0
DEFB 64+10,1, 0,255,255,192,192,192,192,192
DEFB 64+10,2, 24,239,255,0,0,0,0,0
DEFB 64+10,3, 0,255,255,7,7,7,7,7
DEFB 64+10,4, 0,255,255,0,0,0,0,0
DEFB 64+10,5, 224,191,255,0,0,0,0,0
DEFB 64+10,6, 24,255,255,25,24,24,24,24
DEFB 64+10,7, 96,224,252,255,15,2,2,2
DEFB 64+10,8, 39,32,32,224,255,63,7,6
DEFB 64+10,9, 248,127,79,67,67,251,255,15
DEFB 64+10,10, 79,69,244,254,31,19,211,255
DEFB 192+10,11, 240,240,240,144,208,240,48,48
DEFB 64+11,0, 255,255,0,0,0,0,0,255
DEFB 64+11,1, 63,255,0,0,0,0,0,255
DEFB 64+11,2, 255,239,24,24,24,24,24,255
DEFB 64+11,3, 253,255,0,0,0,0,0,255
DEFB 64+11,4, 255,255,0,0,0,0,0,255
DEFB 64+11,5, 255,191,224,224,224,224,224,255
DEFB 64+11,6, 247,255,25,24,24,24,24,255
DEFB 64+11,7, 226,255,255,96,96,96,96,255
DEFB 64+11,8, 6,246,255,63,32,32,32,255
DEFB 64+11,9, 8,8,252,255,67,67,67,255
DEFB 64+11,10, 127,69,68,254,255,19,19,255
DEFB 192+11,11, 240,240,144,144,240,112,48,48

S902F0
DEFB 90
DEFB 128+3,6, 7,12,12,12,12,12,15,15
DEFB 128+3,7, 255,0,0,0,0,0,255,254
DEFB 128+3,8, 255,0,0,0,0,0,255,255
DEFB 128+3,9, 159,96,96,96,96,96,255,255
DEFB 128+3,10, 255,0,0,0,0,0,255,243
DEFB 128+3,11, 254,1,1,1,1,1,255,255
DEFB 128+3,12, 255,128,128,128,128,128,255,255
DEFB 128+3,13, 255,0,0,0,0,0,255,223
DEFB 128+3,14, 251,14,14,14,14,14,255,255
DEFB 128+3,15, 255,0,0,0,0,0,255,255
DEFB 128+4,6, 12,12,12,12,12,15,15,15
DEFB 64+4,7, 3,3,3,3,3,255,255,255
DEFB 64+4,8, 0,0,0,0,0,255,255,255
DEFB 64+4,9, 0,0,0,0,0,255,255,255
DEFB 64+4,10, 12,12,12,12,12,255,255,255
DEFB 64+4,11, 0,0,0,0,0,255,255,255
DEFB 64+4,12, 0,0,0,0,0,255,255,255
DEFB 64+4,13, 112,112,112,112,112,255,255,255
DEFB 64+4,14, 0,0,0,0,0,255,255,255
DEFB 64+4,15, 1,1,1,1,1,255,255,255
DEFB 128+5,6, 12,12,12,12,15,15,15,12
DEFB 64+5,7, 0,0,0,0,255,255,255,3
DEFB 64+5,8, 0,0,0,0,255,255,255,0
DEFB 64+5,9, 96,96,96,96,255,255,255,0
DEFB 64+5,10, 0,0,0,0,255,255,255,12
DEFB 64+5,11, 1,1,1,1,255,255,255,0
DEFB 64+5,12, 128,128,128,128,255,255,255,0
DEFB 64+5,13, 0,0,0,0,255,255,255,112
DEFB 64+5,14, 14,14,14,14,255,255,255,0
DEFB 64+5,15, 0,0,0,0,255,255,255,1
DEFB 128+6,6, 12,12,12,12,15,7,12,12
DEFB 64+6,7, 3,3,3,3,254,255,0,0
DEFB 64+6,8, 0,0,0,0,255,255,0,0
DEFB 64+6,9, 0,0,0,0,255,159,96,96
DEFB 64+6,10, 12,12,12,12,243,255,0,0
DEFB 64+6,11, 0,0,0,0,255,254,1,1
DEFB 64+6,12, 0,0,0,0,255,255,128,128
DEFB 64+6,13, 112,112,112,112,223,255,0,0
DEFB 64+6,14, 0,0,0,0,255,251,14,14
DEFB 64+6,15, 1,1,1,1,255,255,0,0
DEFB 128+7,6, 12,12,12,7,15,12,12,12
DEFB 64+7,7, 0,0,0,255,254,3,3,3
DEFB 64+7,8, 0,0,0,255,255,0,0,0
DEFB 64+7,9, 96,96,96,159,255,0,0,0
DEFB 64+7,10, 0,0,0,255,243,12,12,12
DEFB 64+7,11, 1,1,1,254,255,0,0,0
DEFB 64+7,12, 128,128,128,255,255,0,0,0
DEFB 64+7,13, 0,0,0,255,223,112,112,112
DEFB 64+7,14, 14,14,14,251,255,0,0,0
DEFB 64+7,15, 0,0,0,255,255,1,1,1
DEFB 128+8,6, 12,12,15,15,15,12,12,12
DEFB 64+8,7, 3,3,255,255,255,0,0,0
DEFB 64+8,8, 0,0,255,255,255,0,0,0
DEFB 64+8,9, 0,0,255,255,255,96,96,96
DEFB 64+8,10, 12,12,255,255,255,0,0,0
DEFB 64+8,11, 0,0,255,255,255,1,1,1
DEFB 64+8,12, 0,0,255,255,255,128,128,128
DEFB 64+8,13, 112,112,255,255,255,0,0,0
DEFB 64+8,14, 0,0,255,255,255,14,14,14
DEFB 64+8,15, 1,1,255,255,255,0,0,0
DEFB 128+9,6, 12,15,15,15,12,12,12,12
DEFB 64+9,7, 0,255,255,255,3,3,3,3
DEFB 64+9,8, 0,255,255,255,0,0,0,0
DEFB 64+9,9, 96,255,255,255,0,0,0,0
DEFB 64+9,10, 0,255,255,255,12,12,12,12
DEFB 64+9,11, 1,255,255,255,0,0,0,0
DEFB 64+9,12, 128,255,255,255,0,0,0,0
DEFB 64+9,13, 0,255,255,255,112,112,112,112
DEFB 64+9,14, 14,255,255,255,0,0,0,0
DEFB 64+9,15, 0,255,255,255,1,1,1,1
DEFB 128+10,6, 12,15,15,12,12,12,12,12
DEFB 64+10,7, 3,254,255,0,0,0,0,0
DEFB 64+10,8, 0,255,255,0,0,0,0,0
DEFB 64+10,9, 0,255,255,96,96,96,96,96
DEFB 64+10,10, 12,243,255,0,0,0,0,0
DEFB 64+10,11, 0,255,255,1,1,1,1,1
DEFB 64+10,12, 0,255,255,128,128,128,128,128
DEFB 64+10,13, 112,223,255,0,0,0,0,0
DEFB 64+10,14, 0,255,255,14,14,14,14,14
DEFB 64+10,15, 1,255,255,0,0,0,0,0
DEFB 128+11,6, 7,15,12,12,12,12,12,15
DEFB 64+11,7, 255,254,3,3,3,3,3,255
DEFB 64+11,8, 255,255,0,0,0,0,0,255
DEFB 64+11,9, 159,255,0,0,0,0,0,255
DEFB 64+11,10, 255,243,12,12,12,12,12,255
DEFB 64+11,11, 254,255,0,0,0,0,0,255
DEFB 64+11,12, 255,255,0,0,0,0,0,255
DEFB 64+11,13, 255,223,112,112,112,112,112,255
DEFB 64+11,14, 251,255,0,0,0,0,0,255
DEFB 64+11,15, 255,255,1,1,1,1,1,255

S903L3
DEFB 4
DEFB 64+8,0, 0,0,0,0,0,0,0,128
DEFB 64+9,0, 252,142,250,62,250,254,130,254
DEFB 64+10,0, 30,250,254,130,254,26,254,254
DEFB 64+11,0, 226,254,26,254,130,254,254,26

S903L2
DEFB 32
DEFB 64+7,0, 0,0,0,0,0,255,1,1
DEFB 128+7,1, 0,0,0,0,0,255,0,0
DEFB 128+7,2, 0,0,0,0,0,240,126,99
DEFB 192+7,3, 0,0,0,0,0,0,0,224
DEFB 64+8,0, 255,255,96,96,255,1,1,255
DEFB 64+8,1, 255,255,12,12,255,0,0,255
DEFB 64+8,2, 240,255,103,102,254,127,97,248
DEFB 64+8,3, 124,79,225,255,15,205,252,95
DEFB 128+8,4, 0,0,240,190,199,254,63,243
DEFB 128+8,5, 0,0,0,0,192,120,191,241
DEFB 192+8,6, 0,0,0,0,0,0,128,240
DEFB 64+9,0, 255,96,96,255,1,1,255,255
DEFB 64+9,1, 255,12,12,255,0,0,255,255
DEFB 64+9,2, 255,103,102,254,127,96,248,255
DEFB 64+9,3, 193,249,63,15,252,127,67,225
DEFB 64+9,4, 252,159,199,254,63,240,254,159
DEFB 64+9,5, 191,199,252,63,241,255,143,244
DEFB 192+9,6, 62,243,127,207,253,31,241,127
DEFB 64+10,0, 96,96,255,1,1,255,255,96
DEFB 64+10,1, 12,12,255,0,0,255,255,12
DEFB 64+10,2, 103,102,255,111,96,254,255,102
DEFB 64+10,3, 255,15,204,255,79,65,255,63
DEFB 64+10,4, 198,255,63,240,255,143,134,255
DEFB 64+10,5, 127,51,253,191,132,255,63,241
DEFB 192+10,6, 199,253,31,241,255,197,255,31
DEFB 64+11,0, 96,255,1,1,255,255,96,96
DEFB 64+11,1, 12,255,0,0,255,255,12,12
DEFB 64+11,2, 102,255,99,96,255,255,102,102
DEFB 64+11,3, 12,255,255,65,255,255,12,12
DEFB 64+11,4, 55,176,255,135,134,255,48,48
DEFB 64+11,5, 255,132,254,255,49,255,143,132
DEFB 192+11,6, 249,255,69,255,17,255,255,69

S903L1
DEFB 57
DEFB 128+7,2, 0,0,0,0,0,63,32,32
DEFB 128+7,3, 0,0,0,0,0,255,8,8
DEFB 128+7,4, 0,0,0,0,0,255,3,3
DEFB 128+7,5, 0,0,0,0,0,255,0,0
DEFB 128+7,6, 0,0,0,0,0,255,64,64
DEFB 128+7,7, 0,0,0,0,0,255,24,24
DEFB 128+7,8, 0,0,0,0,0,255,2,2
DEFB 128+7,9, 0,0,0,0,0,255,0,0
DEFB 128+7,10, 0,0,0,0,0,255,192,192
DEFB 192+7,11, 0,0,0,0,0,248,28,22
DEFB 128+8,2, 63,63,35,35,63,32,32,63
DEFB 64+8,3, 255,255,0,0,255,8,8,255
DEFB 64+8,4, 255,255,96,96,255,3,3,255
DEFB 64+8,5, 255,255,24,24,255,0,0,255
DEFB 64+8,6, 255,255,3,3,255,64,64,255
DEFB 64+8,7, 255,255,0,0,255,24,24,255
DEFB 64+8,8, 255,255,192,192,255,2,2,255
DEFB 64+8,9, 255,255,24,24,255,0,0,255
DEFB 64+8,10, 255,255,6,6,255,192,192,255
DEFB 64+8,11, 251,255,30,31,253,31,23,251
DEFB 192+8,12, 0,128,192,224,176,248,124,254
DEFB 128+9,2, 63,35,35,63,32,32,63,63
DEFB 64+9,3, 255,0,0,255,8,8,255,255
DEFB 64+9,4, 255,96,96,255,3,3,255,255
DEFB 64+9,5, 255,24,24,255,0,0,255,255
DEFB 64+9,6, 255,3,3,255,64,64,255,255
DEFB 64+9,7, 255,0,0,255,24,24,255,255
DEFB 64+9,8, 255,192,192,255,2,2,255,255
DEFB 64+9,9, 255,24,24,255,0,0,255,255
DEFB 64+9,10, 255,6,6,255,192,192,255,255
DEFB 64+9,11, 254,31,31,253,31,19,251,254
DEFB 64+9,12, 255,255,187,255,127,223,254,251
DEFB 192+9,13, 0,128,128,128,128,128,128,128
DEFB 128+10,2, 35,35,63,32,32,63,63,35
DEFB 64+10,3, 0,0,255,8,8,255,255,0
DEFB 64+10,4, 96,96,255,3,3,255,255,96
DEFB 64+10,5, 24,24,255,0,0,255,255,24
DEFB 64+10,6, 3,3,255,64,64,255,255,3
DEFB 64+10,7, 0,0,255,24,24,255,255,0
DEFB 64+10,8, 192,192,255,2,2,255,255,192
DEFB 64+10,9, 24,24,255,0,0,255,255,24
DEFB 64+10,10, 6,6,255,192,192,255,255,6
DEFB 64+10,11, 31,29,255,31,19,254,255,31
DEFB 64+10,12, 191,255,127,222,255,255,191,255
DEFB 192+10,13, 128,128,128,128,128,128,128,128
DEFB 128+11,2, 35,63,32,32,63,63,35,35
DEFB 64+11,3, 0,255,8,8,255,255,0,0
DEFB 64+11,4, 96,255,3,3,255,255,96,96
DEFB 64+11,5, 24,255,0,0,255,255,24,24
DEFB 64+11,6, 3,255,64,64,255,255,3,3
DEFB 64+11,7, 0,255,24,24,255,255,0,0
DEFB 64+11,8, 192,255,2,2,255,255,192,192
DEFB 64+11,9, 24,255,0,0,255,255,24,24
DEFB 64+11,10, 6,255,192,192,255,255,6,6
DEFB 64+11,11, 29,255,23,18,255,255,29,29
DEFB 64+11,12, 127,223,255,191,190,255,95,91
DEFB 192+11,13, 128,128,128,128,128,128,128,128

S903F0
DEFB 25
DEFB 128+7,11, 0,0,0,0,0,31,16,16
DEFB 128+7,12, 0,0,0,0,0,255,6,6
DEFB 128+7,13, 0,0,0,0,0,255,0,0
DEFB 128+7,14, 0,0,0,0,0,255,128,128
DEFB 128+7,15, 0,0,0,0,0,255,48,48
DEFB 128+8,11, 31,31,16,16,31,16,16,31
DEFB 64+8,12, 255,255,192,192,255,6,6,255
DEFB 64+8,13, 255,255,16,16,255,0,0,255
DEFB 64+8,14, 255,255,6,6,255,128,128,255
DEFB 64+8,15, 255,255,0,0,255,48,48,255
DEFB 128+9,11, 31,16,16,31,16,16,31,31
DEFB 64+9,12, 255,192,192,255,6,6,255,255
DEFB 64+9,13, 255,16,16,255,0,0,255,255
DEFB 64+9,14, 255,6,6,255,128,128,255,255
DEFB 64+9,15, 255,0,0,255,48,48,255,255
DEFB 128+10,11, 16,16,31,16,16,31,31,16
DEFB 64+10,12, 192,192,255,6,6,255,255,192
DEFB 64+10,13, 16,16,255,0,0,255,255,16
DEFB 64+10,14, 6,6,255,128,128,255,255,6
DEFB 64+10,15, 0,0,255,48,48,255,255,0
DEFB 128+11,11, 16,31,16,16,31,31,16,16
DEFB 64+11,12, 192,255,6,6,255,255,192,192
DEFB 64+11,13, 16,255,0,0,255,255,16,16
DEFB 64+11,14, 6,255,128,128,255,255,6,6
DEFB 64+11,15, 0,255,48,48,255,255,0,0

S904L4
DEFB 3
DEFB 64+9,0, 0,0,0,0,0,0,128,192
DEFB 64+10,0, 192,192,192,192,192,192,192,192
DEFB 64+11,0, 192,192,192,192,192,192,192,192

S904L3
DEFB 15
DEFB 64+9,0, 0,255,131,255,19,255,255,131
DEFB 128+9,1, 0,224,127,235,255,231,255,15
DEFB 128+9,2, 0,0,0,248,207,254,31,252
DEFB 128+9,3, 0,0,0,0,224,127,243,255
DEFB 192+9,4, 0,0,0,0,0,0,248,236
DEFB 64+10,0, 255,19,255,131,255,255,255,255
DEFB 64+10,1, 254,127,249,127,232,255,97,255
DEFB 64+10,2, 95,254,63,252,127,250,255,248
DEFB 64+10,3, 249,63,250,191,252,63,255,159
DEFB 192+10,4, 252,236,252,252,252,252,60,252
DEFB 64+11,0, 131,255,19,255,255,255,255,19
DEFB 64+11,1, 9,255,111,255,255,248,255,97
DEFB 64+11,2, 255,242,255,200,255,66,255,8
DEFB 64+11,3, 255,47,255,139,255,34,255,136
DEFB 192+11,4, 204,252,252,252,252,124,252,140

S904L2
DEFB 30
DEFB 64+9,0, 0,1,1,1,1,1,1,1
DEFB 128+9,1, 0,255,6,255,32,255,255,6
DEFB 128+9,2, 0,255,12,255,64,255,255,12
DEFB 128+9,3, 0,255,24,255,129,255,255,24
DEFB 128+9,4, 0,255,32,255,6,255,255,32
DEFB 128+9,5, 0,255,64,255,12,255,255,64
DEFB 128+9,6, 0,255,129,255,25,255,255,129
DEFB 128+9,7, 0,192,120,255,255,223,249,63
DEFB 128+9,8, 0,0,0,0,240,190,255,191
DEFB 192+9,9, 0,0,0,0,0,0,192,224
DEFB 64+10,0, 1,1,1,1,1,1,1,1
DEFB 64+10,1, 255,32,255,6,255,255,255,255
DEFB 64+10,2, 255,64,255,12,255,255,255,255
DEFB 64+10,3, 255,129,255,24,255,255,255,255
DEFB 64+10,4, 255,6,255,32,255,255,255,255
DEFB 64+10,5, 255,12,255,64,255,255,255,255
DEFB 64+10,6, 255,25,255,129,255,255,255,255
DEFB 64+10,7, 247,127,251,255,247,255,79,255
DEFB 64+10,8, 251,159,255,191,255,159,255,63
DEFB 192+10,9, 224,224,224,224,224,224,224,224
DEFB 64+11,0, 1,1,1,1,1,1,1,1
DEFB 64+11,1, 6,255,32,255,255,255,255,32
DEFB 64+11,2, 12,255,64,255,255,255,255,64
DEFB 64+11,3, 24,255,129,255,255,255,255,129
DEFB 64+11,4, 32,255,6,255,255,255,255,6
DEFB 64+11,5, 64,255,12,255,255,255,255,12
DEFB 64+11,6, 129,255,25,255,255,255,255,25
DEFB 64+11,7, 63,254,127,253,255,246,255,73
DEFB 64+11,8, 255,159,255,47,255,149,255,43
DEFB 192+11,9, 96,224,224,224,224,224,224,96

S904L1
DEFB 24
DEFB 128+9,6, 0,1,1,1,1,1,1,1
DEFB 128+9,7, 0,255,2,255,48,255,255,2
DEFB 128+9,8, 0,255,4,255,96,255,255,4
DEFB 128+9,9, 0,255,8,255,193,255,255,8
DEFB 128+9,10, 0,255,16,255,131,255,255,16
DEFB 128+9,11, 0,255,32,255,4,255,255,32
DEFB 128+9,12, 0,255,193,255,9,255,255,193
DEFB 192+9,13, 0,128,192,224,248,252,254,254
DEFB 128+10,6, 1,1,1,1,1,1,1,1
DEFB 64+10,7, 255,48,255,2,255,255,255,255
DEFB 64+10,8, 255,96,255,4,255,255,255,255
DEFB 64+10,9, 255,193,255,8,255,255,255,255
DEFB 64+10,10, 255,131,255,16,255,255,255,255
DEFB 64+10,11, 255,4,255,32,255,255,255,255
DEFB 64+10,12, 255,9,255,193,255,255,255,255
DEFB 192+10,13, 254,254,254,254,254,254,254,254
DEFB 128+11,6, 1,1,1,1,1,1,1,1
DEFB 64+11,7, 2,255,48,255,255,255,255,48
DEFB 64+11,8, 4,255,96,255,255,255,255,96
DEFB 64+11,9, 8,255,193,255,255,255,255,193
DEFB 64+11,10, 16,255,131,255,255,255,255,131
DEFB 64+11,11, 32,255,4,255,255,255,255,4
DEFB 64+11,12, 193,255,9,255,255,255,255,9
DEFB 192+11,13, 254,254,254,254,254,254,254,254

S904F0
DEFB 9
DEFB 128+9,13, 0,255,131,255,144,255,255,131
DEFB 128+9,14, 0,255,6,255,32,255,255,6
DEFB 128+9,15, 0,255,12,255,64,255,255,12
DEFB 128+10,13, 255,144,255,131,255,255,255,255
DEFB 64+10,14, 255,32,255,6,255,255,255,255
DEFB 64+10,15, 255,64,255,12,255,255,255,255
DEFB 128+11,13, 131,255,144,255,255,255,255,144
DEFB 64+11,14, 6,255,32,255,255,255,255,32
DEFB 64+11,15, 12,255,64,255,255,255,255,64

S905L4
DEFB 9
DEFB 64+9,0, 0,0,0,0,0,0,0,255
DEFB 64+10,0, 247,255,255,95,255,243,255,254
DEFB 128+10,1, 254,247,255,255,239,255,255,63
DEFB 128+10,2, 0,252,255,127,255,255,127,255
DEFB 192+10,3, 0,0,240,240,240,240,240,240
DEFB 64+11,0, 255,255,71,255,255,255,255,209
DEFB 64+11,1, 255,249,255,255,153,255,255,191
DEFB 64+11,2, 253,255,255,254,255,255,255,255
DEFB 192+11,3, 240,240,240,240,240,240,240,240

S905L3
DEFB 22
DEFB 64+9,0, 0,0,0,0,0,0,0,127
DEFB 128+9,1, 0,0,0,0,0,0,0,255
DEFB 128+9,2, 0,0,0,0,0,0,0,255
DEFB 128+9,3, 0,0,0,0,0,0,0,255
DEFB 128+9,4, 0,0,0,0,0,0,0,255
DEFB 192+9,5, 0,0,0,0,0,0,0,192
DEFB 64+10,0, 127,127,127,66,127,127,127,127
DEFB 64+10,1, 255,255,255,24,255,255,255,255
DEFB 64+10,2, 255,255,255,194,255,255,255,255
DEFB 64+10,3, 255,255,255,16,255,255,255,255
DEFB 64+10,4, 255,255,255,133,255,255,255,255
DEFB 64+10,5, 255,255,255,255,255,127,255,223
DEFB 128+10,6, 0,248,255,255,255,255,255,255
DEFB 192+10,7, 0,0,128,128,128,128,128,128
DEFB 64+11,0, 88,127,66,127,127,127,127,88
DEFB 64+11,1, 66,255,24,255,255,255,255,66
DEFB 64+11,2, 16,255,194,255,255,255,255,16
DEFB 64+11,3, 198,255,16,255,255,255,255,198
DEFB 64+11,4, 23,255,132,255,255,255,255,21
DEFB 64+11,5, 255,253,255,255,229,255,255,47
DEFB 64+11,6, 247,255,255,255,255,255,255,255
DEFB 192+11,7, 128,128,128,128,128,128,128,128

S905L2
DEFB 20
DEFB 128+9,4, 0,0,0,0,0,0,0,7
DEFB 128+9,5, 0,0,0,0,0,0,0,255
DEFB 128+9,6, 0,0,0,0,0,0,0,255
DEFB 128+9,7, 0,0,0,0,0,0,0,255
DEFB 128+9,8, 0,0,0,0,0,0,0,255
DEFB 192+9,9, 0,0,0,0,0,0,0,248
DEFB 128+10,4, 7,7,7,4,7,7,7,7
DEFB 64+10,5, 255,255,255,48,255,255,255,255
DEFB 64+10,6, 255,255,255,132,255,255,255,255
DEFB 64+10,7, 255,255,255,33,255,255,255,255
DEFB 64+10,8, 255,255,255,12,255,255,255,255
DEFB 64+10,9, 255,255,255,127,255,255,255,255
DEFB 192+10,10, 0,224,252,252,252,252,252,252
DEFB 128+11,4, 4,7,4,7,7,7,7,4
DEFB 64+11,5, 132,255,48,255,255,255,255,132
DEFB 64+11,6, 33,255,132,255,255,255,255,33
DEFB 64+11,7, 140,255,33,255,255,255,255,140
DEFB 64+11,8, 33,255,12,255,255,255,255,33
DEFB 64+11,9, 127,254,127,255,250,255,255,123
DEFB 192+11,10, 252,252,252,252,252,252,252,252

S905L1
DEFB 17
DEFB 128+9,9, 0,0,0,0,0,0,0,63
DEFB 128+9,10, 0,0,0,0,0,0,0,255
DEFB 128+9,11, 0,0,0,0,0,0,0,255
DEFB 128+9,12, 0,0,0,0,0,0,0,255
DEFB 192+9,13, 0,0,0,0,0,0,0,255
DEFB 128+10,9, 63,63,63,33,63,63,63,63
DEFB 64+10,10, 255,255,255,8,255,255,255,255
DEFB 64+10,11, 255,255,255,66,255,255,255,255
DEFB 64+10,12, 255,255,255,24,255,255,255,255
DEFB 64+10,13, 255,255,255,195,255,255,255,255
DEFB 192+10,14, 128,192,224,224,224,224,224,224
DEFB 128+11,9, 40,63,33,63,63,63,63,40
DEFB 64+11,10, 67,255,8,255,255,255,255,67
DEFB 64+11,11, 8,255,66,255,255,255,255,8
DEFB 64+11,12, 66,255,24,255,255,255,255,66
DEFB 64+11,13, 19,255,195,255,255,255,255,19
DEFB 192+11,14, 224,224,224,224,224,224,224,224

S905F0
DEFB 9
DEFB 128+9,13, 0,0,0,0,0,0,0,3
DEFB 128+9,14, 0,0,0,0,0,0,0,255
DEFB 128+9,15, 0,0,0,0,0,0,0,255
DEFB 128+10,13, 3,3,3,2,3,3,3,3
DEFB 64+10,14, 255,255,255,16,255,255,255,255
DEFB 64+10,15, 255,255,255,134,255,255,255,255
DEFB 128+11,13, 2,3,2,3,3,3,3,2
DEFB 64+11,14, 198,255,16,255,255,255,255,198
DEFB 64+11,15, 16,255,134,255,255,255,255,16

S906L5
DEFB 6
DEFB 64+10,0, 0,0,128,255,255,255,255,255
DEFB 128+10,1, 0,0,0,224,255,255,255,255
DEFB 192+10,2, 0,0,0,0,240,248,248,248
DEFB 64+11,0, 255,255,255,255,255,255,231,255
DEFB 64+11,1, 255,255,255,255,255,255,255,255
DEFB 192+11,2, 248,248,248,248,248,248,248,248

S906L4
DEFB 12
DEFB 64+10,0, 0,0,255,255,255,255,255,136
DEFB 128+10,1, 0,0,255,255,255,255,255,136
DEFB 128+10,2, 0,0,255,255,255,255,255,204
DEFB 128+10,3, 0,0,252,255,255,255,255,95
DEFB 128+10,4, 0,0,0,248,255,255,255,255
DEFB 192+10,5, 0,0,0,0,240,248,248,248
DEFB 64+11,0, 255,255,255,255,255,255,255,255
DEFB 64+11,1, 255,255,255,255,255,255,255,255
DEFB 64+11,2, 255,255,255,255,255,255,255,255
DEFB 64+11,3, 255,255,255,255,255,255,254,255
DEFB 64+11,4, 255,255,255,255,255,255,255,255
DEFB 192+11,5, 248,248,248,248,248,248,248,248

S906L3
DEFB 12
DEFB 128+10,3, 0,0,31,31,31,31,31,20
DEFB 128+10,4, 0,0,255,255,255,255,255,68
DEFB 128+10,5, 0,0,255,255,255,255,255,68
DEFB 128+10,6, 0,0,255,255,255,255,255,102
DEFB 128+10,7, 0,0,192,254,255,255,255,255
DEFB 192+10,8, 0,0,0,0,248,248,248,248
DEFB 128+11,3, 31,31,31,31,31,31,31,31
DEFB 64+11,4, 255,255,255,255,255,255,255,255
DEFB 64+11,5, 255,255,255,255,255,255,255,255
DEFB 64+11,6, 255,255,255,255,255,255,255,255
DEFB 64+11,7, 255,255,255,255,255,255,239,255
DEFB 192+11,8, 248,248,248,248,248,248,248,248

S906L2
DEFB 10
DEFB 128+10,7, 0,0,255,255,255,255,255,162
DEFB 128+10,8, 0,0,255,255,255,255,255,34
DEFB 128+10,9, 0,0,255,255,255,255,255,35
DEFB 128+10,10, 0,0,252,255,255,255,255,63
DEFB 192+10,11, 0,0,0,192,248,248,248,248
DEFB 128+11,7, 255,255,255,255,255,255,255,255
DEFB 64+11,8, 255,255,255,255,255,255,255,255
DEFB 64+11,9, 255,255,255,255,255,255,255,255
DEFB 64+11,10, 255,255,255,255,255,255,255,255
DEFB 192+11,11, 248,248,248,248,248,248,248,248

S906L1
DEFB 10
DEFB 128+10,10, 0,0,7,7,7,7,7,5
DEFB 128+10,11, 0,0,255,255,255,255,255,17
DEFB 128+10,12, 0,0,255,255,255,255,255,17
DEFB 128+10,13, 0,0,255,255,255,255,255,17
DEFB 192+10,14, 0,0,224,240,248,248,248,248
DEFB 128+11,10, 7,7,7,7,7,7,7,7
DEFB 64+11,11, 255,255,255,255,255,255,255,255
DEFB 64+11,12, 255,255,255,255,255,255,255,255
DEFB 64+11,13, 255,255,255,255,255,255,255,255
DEFB 192+11,14, 248,248,248,248,248,248,248,248

S906F0
DEFB 4
DEFB 128+10,14, 0,0,63,63,63,63,63,56
DEFB 64+10,15, 0,0,255,255,255,255,255,136
DEFB 128+11,14, 63,63,63,63,63,63,63,63
DEFB 64+11,15, 255,255,255,255,255,255,255,255

S907L5
DEFB 10
DEFB 64+10,0, 0,0,0,0,0,255,255,255
DEFB 128+10,1, 0,0,0,0,0,255,255,255
DEFB 128+10,2, 0,0,0,0,0,255,255,255
DEFB 128+10,3, 0,0,0,0,0,252,255,255
DEFB 192+10,4, 0,0,0,0,0,0,240,240
DEFB 64+11,0, 255,255,255,255,255,255,255,255
DEFB 64+11,1, 255,255,255,255,255,255,255,255
DEFB 64+11,2, 255,255,255,255,255,255,255,255
DEFB 64+11,3, 255,255,255,255,255,255,255,255
DEFB 192+11,4, 240,240,240,240,240,240,240,240

S907L4
DEFB 12
DEFB 128+10,2, 0,0,0,0,0,15,15,15
DEFB 128+10,3, 0,0,0,0,0,255,255,255
DEFB 128+10,4, 0,0,0,0,0,255,255,255
DEFB 128+10,5, 0,0,0,0,0,255,255,255
DEFB 128+10,6, 0,0,0,0,0,240,255,255
DEFB 192+10,7, 0,0,0,0,0,0,128,128
DEFB 128+11,2, 15,15,15,15,15,15,15,15
DEFB 64+11,3, 255,255,255,255,255,255,255,255
DEFB 64+11,4, 255,255,255,255,255,255,255,255
DEFB 64+11,5, 255,255,255,255,255,255,255,255
DEFB 64+11,6, 255,255,255,255,255,255,255,255
DEFB 192+11,7, 128,128,128,128,128,128,128,128

S907L3
DEFB 10
DEFB 128+10,5, 0,0,0,0,0,15,15,15
DEFB 128+10,6, 0,0,0,0,0,255,255,255
DEFB 128+10,7, 0,0,0,0,0,255,255,255
DEFB 128+10,8, 0,0,0,0,0,255,255,255
DEFB 192+10,9, 0,0,0,0,0,192,252,252
DEFB 128+11,5, 15,15,15,15,15,15,15,15
DEFB 64+11,6, 255,255,255,255,255,255,255,255
DEFB 64+11,7, 255,255,255,255,255,255,255,255
DEFB 64+11,8, 255,255,255,255,255,255,255,255
DEFB 192+11,9, 252,252,252,252,252,252,252,252

S907L2
DEFB 10
DEFB 128+10,8, 0,0,0,0,0,15,15,15
DEFB 128+10,9, 0,0,0,0,0,255,255,255
DEFB 128+10,10, 0,0,0,0,0,255,255,255
DEFB 128+10,11, 0,0,0,0,0,255,255,255
DEFB 192+10,12, 0,0,0,0,0,0,192,192
DEFB 128+11,8, 15,15,15,15,15,15,15,15
DEFB 64+11,9, 255,255,255,255,255,255,255,255
DEFB 64+11,10, 255,255,255,255,255,255,255,255
DEFB 64+11,11, 255,255,255,255,255,255,255,255
DEFB 192+11,12, 192,192,192,192,192,192,192,192

S907L1
DEFB 8
DEFB 128+10,11, 0,0,0,0,0,15,15,15
DEFB 128+10,12, 0,0,0,0,0,255,255,255
DEFB 128+10,13, 0,0,0,0,0,255,255,255
DEFB 192+10,14, 0,0,0,0,0,252,254,254
DEFB 128+11,11, 15,15,15,15,15,15,15,15
DEFB 64+11,12, 255,255,255,255,255,255,255,255
DEFB 64+11,13, 255,255,255,255,255,255,255,255
DEFB 192+11,14, 254,254,254,254,254,254,254,254

S907F0
DEFB 4
DEFB 128+10,14, 0,0,0,0,0,15,15,15
DEFB 64+10,15, 0,0,0,0,0,255,255,255
DEFB 128+11,14, 15,15,15,15,15,15,15,15
DEFB 64+11,15, 255,255,255,255,255,255,255,255

; : 6720 



;      45 

S453L1
DEFB 60
DEFB 64+4,0, 0,0,0,0,0,0,0,128
DEFB 64+5,0, 240,31,1,0,128,248,255,15
DEFB 128+5,1, 0,128,252,14,3,3,227,255
DEFB 128+5,2, 0,0,0,224,255,135,128,128
DEFB 128+5,3, 0,0,0,0,0,240,63,1
DEFB 192+5,4, 0,0,0,0,0,0,128,252
DEFB 64+6,0, 14,14,206,255,127,1,0,0
DEFB 64+6,1, 63,1,0,0,252,255,7,3
DEFB 64+6,2, 248,255,7,0,0,240,255,143
DEFB 64+6,3, 0,192,255,255,193,192,192,255
DEFB 64+6,4, 111,96,96,248,255,7,0,0
DEFB 128+6,5, 224,127,3,0,192,254,63,48
DEFB 128+6,6, 0,0,248,63,32,32,248,255
DEFB 128+6,7, 0,0,0,128,252,15,0,192
DEFB 192+6,8, 0,0,0,0,0,0,128,128
DEFB 64+7,0, 248,255,15,14,14,142,255,255
DEFB 64+7,1, 3,227,255,31,0,0,0,255
DEFB 64+7,2, 128,128,192,255,63,0,0,0
DEFB 64+7,3, 127,0,0,128,255,255,192,192
DEFB 64+7,4, 248,255,99,96,96,252,255,1
DEFB 64+7,5, 48,240,255,15,0,0,248,255
DEFB 64+7,6, 7,0,192,254,63,32,32,240
DEFB 64+7,7, 254,127,96,96,248,255,3,0
DEFB 192+7,8, 128,128,128,128,128,128,128,128
DEFB 64+8,0, 0,0,0,240,255,31,14,14
DEFB 64+8,1, 255,3,3,3,251,255,7,0
DEFB 64+8,2, 255,255,128,128,128,252,255,1
DEFB 64+8,3, 192,255,255,0,0,0,255,255
DEFB 64+8,4, 0,0,255,255,96,96,96,255
DEFB 64+8,5, 55,48,48,255,255,0,0,128
DEFB 64+8,6, 255,7,0,0,254,255,32,32
DEFB 64+8,7, 224,255,127,96,96,254,255,0
DEFB 192+8,8, 128,128,128,128,128,128,128,128
DEFB 64+9,0, 14,255,255,0,0,0,192,255
DEFB 64+9,1, 0,128,255,255,3,3,3,255
DEFB 64+9,2, 0,0,248,255,143,128,128,128
DEFB 64+9,3, 192,192,192,255,255,0,0,0
DEFB 64+9,4, 255,0,0,0,255,127,96,96
DEFB 64+9,5, 255,63,48,48,240,255,7,0
DEFB 64+9,6, 224,255,15,0,0,255,255,32
DEFB 64+9,7, 0,240,255,103,96,96,255,127
DEFB 192+9,8, 128,128,128,128,128,128,128,128
DEFB 64+10,0, 127,14,14,14,255,255,0,0
DEFB 64+10,1, 255,0,0,0,224,255,63,3
DEFB 64+10,2, 255,127,0,0,0,255,255,128
DEFB 64+10,3, 255,255,192,192,192,255,255,0
DEFB 64+10,4, 224,255,127,0,0,192,255,127
DEFB 64+10,5, 0,255,255,48,48,48,255,255
DEFB 64+10,6, 32,32,255,63,0,0,255,255
DEFB 64+10,7, 0,0,254,255,96,96,224,255
DEFB 192+10,8, 128,128,128,128,128,128,128,128
DEFB 64+11,0, 0,0,255,255,14,14,14,255
DEFB 64+11,1, 3,3,255,255,0,0,0,255
DEFB 64+11,2, 128,128,255,255,0,0,0,255
DEFB 64+11,3, 0,0,255,255,192,192,192,255
DEFB 64+11,4, 96,96,240,255,0,0,0,255
DEFB 64+11,5, 0,0,0,255,255,48,48,255
DEFB 64+11,6, 32,32,32,255,255,0,0,255
DEFB 64+11,7, 15,0,0,255,255,96,96,255
DEFB 192+11,8, 128,128,128,128,128,128,128,128

S453F0
DEFB 65
DEFB 128+2,14, 0,0,0,0,0,0,0,1
DEFB 128+2,15, 0,0,0,1,7,30,56,224
DEFB 128+3,13, 0,0,0,0,3,15,28,112
DEFB 64+3,14, 3,14,56,224,224,96,99,111
DEFB 64+3,15, 128,0,1,15,63,252,224,192
DEFB 128+4,11, 0,0,0,0,0,3,14,56
DEFB 128+4,12, 1,7,30,118,230,134,7,15
DEFB 64+4,13, 192,0,3,15,62,248,248,152
DEFB 64+4,14, 127,248,224,192,0,1,15,63
DEFB 64+4,15, 192,192,195,223,254,248,224,0
DEFB 128+5,9, 0,0,0,0,0,1,7,28
DEFB 128+5,10, 0,3,15,60,120,216,27,31
DEFB 64+5,11, 248,152,27,31,62,248,224,128
DEFB 64+5,12, 62,248,224,192,193,207,255,254
DEFB 64+5,13, 24,27,31,126,240,192,0,1
DEFB 64+5,14, 252,224,224,96,97,111,127,252
DEFB 64+5,15, 0,1,15,63,252,160,192,192
DEFB 128+6,8, 0,1,7,14,58,99,71,95
DEFB 64+6,9, 120,200,143,15,124,240,192,71
DEFB 64+6,10, 61,241,193,129,143,191,248,248
DEFB 64+6,11, 131,159,254,248,216,24,31,31
DEFB 64+6,12, 230,134,6,7,63,252,240,192
DEFB 64+6,13, 7,63,252,248,152,24,25,31
DEFB 64+6,14, 224,128,0,0,7,63,252,224
DEFB 64+6,15, 192,195,223,255,248,192,0,0
DEFB 128+7,8, 124,112,81,95,126,122,98,67
DEFB 64+7,9, 95,124,248,200,15,31,252,224
DEFB 64+7,10, 152,31,31,253,225,129,129,159
DEFB 64+7,11, 252,224,128,128,143,191,248,248
DEFB 64+7,12, 192,195,223,254,246,134,6,7
DEFB 64+7,13, 127,248,192,0,0,3,63,255
DEFB 64+7,14, 96,96,96,103,127,254,224,0
DEFB 64+7,15, 0,15,127,254,224,192,192,192
DEFB 128+8,8, 95,124,112,81,95,127,122,66
DEFB 64+8,9, 192,71,127,252,232,8,15,63
DEFB 64+8,10, 254,248,152,24,31,127,249,193
DEFB 64+8,11, 24,24,31,255,248,128,128,129
DEFB 64+8,12, 31,255,240,192,192,192,207,255
DEFB 64+8,13, 248,24,24,24,31,255,254,192
DEFB 64+8,14, 0,0,3,127,255,224,96,96
DEFB 64+8,15, 193,255,191,248,0,0,0,0
DEFB 128+9,8, 67,127,124,112,80,95,127,114
DEFB 64+9,9, 252,192,64,71,127,252,136,8
DEFB 64+9,10, 129,131,191,254,216,24,24,31
DEFB 64+9,11, 159,255,248,24,24,25,127,255
DEFB 64+9,12, 254,134,6,6,7,255,254,192
DEFB 64+9,13, 0,0,0,31,255,248,24,24
DEFB 64+9,14, 96,97,127,255,224,0,0,0
DEFB 64+9,15, 7,255,255,192,192,192,192,192
DEFB 128+10,8, 66,67,127,126,80,80,95,127
DEFB 64+10,9, 15,255,248,64,64,71,255,248
DEFB 64+10,10, 255,241,129,129,135,255,252,24
DEFB 64+10,11, 192,128,128,131,255,255,24,24
DEFB 64+10,12, 192,192,193,255,255,6,6,6
DEFB 64+10,13, 24,24,255,255,128,0,0,0
DEFB 64+10,14, 0,255,255,224,96,96,96,96
DEFB 64+10,15, 255,255,240,0,0,0,0,7
DEFB 128+11,8, 98,66,66,127,127,80,80,127
DEFB 64+11,9, 8,8,15,255,224,64,64,255
DEFB 64+11,10, 24,24,255,255,129,129,129,255
DEFB 64+11,11, 24,31,255,254,128,128,128,255
DEFB 64+11,12, 6,255,255,192,192,192,192,255
DEFB 64+11,13, 7,255,255,24,24,24,24,255
DEFB 64+11,14, 255,255,192,0,0,0,0,255
DEFB 64+11,15, 255,191,192,192,192,192,192,255

S455L2
DEFB 13
DEFB 64+8,0, 0,0,0,0,0,0,0,255
DEFB 64+9,0, 131,252,255,140,255,129,255,255
DEFB 128+9,1, 255,64,255,15,254,255,64,255
DEFB 128+9,2, 224,127,240,255,3,255,63,254
DEFB 192+9,3, 0,224,16,240,240,240,240,16
DEFB 64+10,0, 12,255,128,255,255,12,255,128
DEFB 64+10,1, 3,255,255,192,255,2,255,79
DEFB 64+10,2, 255,131,255,48,255,7,255,255
DEFB 192+10,3, 240,16,240,48,240,240,16,240
DEFB 64+11,0, 255,255,12,255,128,255,255,12
DEFB 64+11,1, 252,255,2,255,64,255,255,2
DEFB 64+11,2, 48,255,3,255,55,255,255,3
DEFB 192+11,3, 16,240,16,240,240,240,240,16

S455L1
DEFB 35
DEFB 128+8,3, 0,0,0,0,0,0,0,1
DEFB 128+8,4, 0,0,0,3,14,59,239,255
DEFB 128+8,5, 0,0,192,255,128,252,255,132
DEFB 128+8,6, 0,0,0,192,255,96,252,127
DEFB 128+8,7, 0,0,0,0,192,255,49,254
DEFB 128+8,8, 0,0,0,0,0,192,255,49
DEFB 128+8,9, 0,0,0,0,0,0,128,255
DEFB 192+8,10, 0,0,0,0,0,0,0,128
DEFB 128+9,3, 7,31,23,31,31,31,31,31
DEFB 64+9,4, 253,255,254,251,239,253,247,223
DEFB 64+9,5, 252,255,128,255,255,132,255,191
DEFB 64+9,6, 2,255,127,96,255,15,130,255
DEFB 64+9,7, 63,3,255,63,240,255,3,255
DEFB 64+9,8, 254,63,195,255,51,252,255,3
DEFB 64+9,9, 49,255,31,226,255,48,255,31
DEFB 64+9,10, 255,97,255,15,252,255,224,255
DEFB 192+9,11, 128,254,130,254,30,254,190,226
DEFB 128+10,3, 29,31,30,23,31,29,31,30
DEFB 64+10,4, 254,235,191,253,215,255,234,175
DEFB 64+10,5, 128,255,191,132,255,143,128,255
DEFB 64+10,6, 97,224,255,2,254,255,96,255
DEFB 64+10,7, 255,48,255,63,3,255,49,240
DEFB 64+10,8, 255,63,240,255,3,255,255,48
DEFB 64+10,9, 226,255,48,255,63,194,255,48
DEFB 64+10,10, 7,255,127,224,255,4,255,127
DEFB 192+10,11, 254,18,254,130,254,62,250,254
DEFB 128+11,3, 23,31,29,31,30,31,31,29
DEFB 64+11,4, 255,213,127,254,170,255,245,85
DEFB 64+11,5, 135,132,255,128,128,255,132,132
DEFB 64+11,6, 255,2,255,127,96,255,2,2
DEFB 64+11,7, 255,3,255,255,48,255,3,3
DEFB 64+11,8, 255,3,255,255,48,255,255,3
DEFB 64+11,9, 255,255,2,255,48,255,255,2
DEFB 64+11,10, 248,255,4,255,96,255,255,4
DEFB 192+11,11, 130,254,18,254,190,254,254,18

S455F0
DEFB 19
DEFB 128+8,12, 0,0,0,0,0,0,0,1
DEFB 128+8,13, 0,0,0,0,0,0,15,253
DEFB 128+8,14, 0,0,0,0,3,126,236,159
DEFB 128+8,15, 0,0,1,31,240,39,255,244
DEFB 128+9,11, 0,1,1,1,1,1,1,1
DEFB 64+9,12, 63,243,63,252,207,255,227,127
DEFB 64+9,13, 151,255,228,223,255,19,255,244
DEFB 64+9,14, 253,161,127,252,143,255,225,63
DEFB 64+9,15, 135,255,224,47,255,196,159,255
DEFB 128+10,11, 1,1,1,1,1,1,1,1
DEFB 64+10,12, 248,223,255,35,255,200,255,255
DEFB 64+10,13, 223,255,17,255,244,207,255,17
DEFB 64+10,14, 255,140,255,253,33,255,236,143
DEFB 64+10,15, 32,63,255,132,255,254,32,255
DEFB 128+11,11, 1,1,1,1,1,1,1,1
DEFB 64+11,12, 39,255,200,255,227,255,255,200
DEFB 64+11,13, 255,252,199,255,17,255,255,196
DEFB 64+11,14, 255,33,255,255,140,255,225,33
DEFB 64+11,15, 252,132,255,224,32,255,132,132

S457L3
DEFB 4
DEFB 64+10,0, 255,253,255,255,193,255,255,79
DEFB 192+10,1, 248,188,252,252,252,252,252,252
DEFB 64+11,0, 255,255,255,255,8,255,255,15
DEFB 192+11,1, 252,180,252,252,52,252,252,252

S457L2
DEFB 18
DEFB 128+9,2, 0,0,0,0,0,0,63,255
DEFB 128+9,3, 0,0,0,0,0,0,255,103
DEFB 128+9,4, 0,0,0,0,0,0,0,255
DEFB 192+9,5, 0,0,0,0,0,0,0,248
DEFB 128+10,1, 3,3,3,3,3,3,3,3
DEFB 64+10,2, 255,255,255,255,243,255,240,255
DEFB 64+10,3, 255,228,255,254,255,255,111,255
DEFB 64+10,4, 254,127,255,131,255,240,255,255
DEFB 64+10,5, 31,255,243,255,255,95,255,248
DEFB 128+10,6, 255,254,255,255,195,255,255,95
DEFB 192+10,7, 224,112,240,240,240,240,240,240
DEFB 128+11,1, 3,3,3,3,3,3,3,3
DEFB 64+11,2, 255,255,255,255,255,241,255,243
DEFB 64+11,3, 4,255,252,255,255,255,255,4
DEFB 64+11,4, 31,255,130,255,255,255,255,16
DEFB 64+11,5, 255,255,31,255,255,255,255,67
DEFB 64+11,6, 255,255,255,255,8,255,255,31
DEFB 192+11,7, 240,80,240,240,80,240,240,240

S457L1
DEFB 18
DEFB 128+9,8, 0,0,0,0,0,0,3,127
DEFB 128+9,9, 0,0,0,0,0,0,255,249
DEFB 128+9,10, 0,0,0,0,0,0,240,63
DEFB 192+9,11, 0,0,0,0,0,0,0,252
DEFB 128+10,7, 15,31,31,31,29,31,31,31
DEFB 64+10,8, 223,255,255,247,255,239,255,127
DEFB 64+10,9, 255,255,255,255,239,255,97,255
DEFB 64+10,10, 255,79,255,248,255,254,127,255
DEFB 64+10,11, 207,255,249,255,255,55,255,252
DEFB 128+10,12, 255,253,255,255,199,255,255,95
DEFB 192+10,13, 128,192,192,192,192,192,192,192
DEFB 128+11,7, 31,31,31,31,26,31,31,30
DEFB 64+11,8, 250,255,215,255,255,255,255,170
DEFB 64+11,9, 248,255,255,255,255,231,255,232
DEFB 64+11,10, 67,255,248,255,255,255,255,66
DEFB 64+11,11, 255,255,199,255,255,255,255,49
DEFB 64+11,12, 255,253,255,255,17,255,255,31
DEFB 192+11,13, 192,64,192,192,64,192,192,192

S457F0
DEFB 8
DEFB 128+9,14, 0,0,0,0,0,0,0,63
DEFB 128+9,15, 0,0,0,0,0,0,63,235
DEFB 128+10,13, 63,127,127,127,121,127,127,127
DEFB 64+10,14, 231,255,223,254,255,233,255,63
DEFB 64+10,15, 255,191,255,127,254,255,248,255
DEFB 128+11,13, 127,95,127,127,86,127,127,126
DEFB 64+11,14, 255,255,228,255,255,255,255,201
DEFB 64+11,15, 51,255,127,255,255,254,255,50

S452L1
DEFB 185
DEFB 64+0,0, 0,0,0,0,0,0,128,176
DEFB 64+0,1, 5,0,0,0,0,0,0,0
DEFB 64+0,2, 182,54,6,0,0,0,0,0
DEFB 64+0,3, 0,192,216,221,93,12,4,5
DEFB 64+0,4, 0,0,0,0,192,216,93,221
DEFB 64+0,5, 7,0,0,0,0,0,0,192
DEFB 64+0,6, 188,55,19,31,28,28,28,28
DEFB 64+0,7, 0,0,208,220,223,31,7,0
DEFB 64+0,8, 7,7,7,7,7,199,247,255
DEFB 64+0,9, 252,63,15,3,0,0,0,0
DEFB 64+0,10, 14,142,206,254,122,63,7,3
DEFB 64+0,11, 62,3,0,0,0,0,224,248
DEFB 64+0,12, 0,128,224,56,30,7,1,0
DEFB 64+0,13, 0,0,0,0,0,0,192,112
DEFB 64+1,0, 181,181,16,20,21,21,21,21
DEFB 64+1,1, 0,160,172,173,173,141,129,128
DEFB 64+1,2, 0,0,0,128,176,182,182,54
DEFB 64+1,3, 5,5,5,5,5,5,197,221
DEFB 64+1,4, 205,193,192,192,192,192,192,192
DEFB 64+1,5, 232,238,111,15,1,0,0,0
DEFB 64+1,6, 28,28,156,188,178,63,15,3
DEFB 64+1,7, 0,0,0,0,0,128,216,222
DEFB 64+1,8, 60,15,1,0,0,0,0,0
DEFB 64+1,9, 128,224,248,127,31,7,0,0
DEFB 64+1,10, 0,0,0,0,192,240,254,63
DEFB 64+1,11, 124,63,7,1,0,0,0,128
DEFB 64+1,12, 0,128,224,248,94,127,103,97
DEFB 64+1,13, 24,15,15,14,14,142,238,254
DEFB 128+1,14, 0,0,192,96,60,14,3,0
DEFB 192+1,15, 0,0,0,0,0,0,128,224
DEFB 64+2,0, 21,21,21,21,21,181,177,176
DEFB 64+2,1, 128,128,128,128,128,128,128,128
DEFB 64+2,2, 2,0,0,0,0,0,0,0
DEFB 64+2,3, 220,92,13,1,0,0,0,0
DEFB 64+2,4, 192,64,220,221,93,5,0,0
DEFB 64+2,5, 0,0,0,128,224,238,239,15
DEFB 64+2,6, 0,0,0,0,0,0,128,184
DEFB 64+2,7, 95,15,1,0,0,0,0,0
DEFB 64+2,8, 192,240,254,63,12,7,7,7
DEFB 64+2,9, 0,0,0,192,240,254,127,15
DEFB 64+2,10, 11,15,14,14,14,14,142,254
DEFB 64+2,11, 224,248,127,31,7,0,0,0
DEFB 64+2,12, 96,96,96,224,208,252,63,7
DEFB 64+2,13, 122,31,7,1,0,0,128,224
DEFB 64+2,14, 0,128,224,248,126,31,7,3
DEFB 64+2,15, 56,14,7,1,1,129,225,249
DEFB 64+3,0, 53,5,0,0,0,0,0,0
DEFB 64+3,1, 172,173,173,13,0,0,0,0
DEFB 64+3,2, 0,128,176,182,182,22,0,0
DEFB 64+3,3, 0,0,0,128,208,221,221,28
DEFB 64+3,4, 0,0,0,0,0,0,208,93
DEFB 64+3,5, 3,0,0,0,0,0,0,0
DEFB 64+3,6, 191,51,27,29,28,28,28,28
DEFB 64+3,7, 0,192,220,223,31,3,0,0
DEFB 64+3,8, 7,7,7,135,247,255,124,15
DEFB 64+3,9, 1,0,0,0,0,0,192,248
DEFB 64+3,10, 250,127,15,3,0,0,0,0
DEFB 64+3,11, 0,128,224,252,127,15,3,0
DEFB 64+3,12, 1,0,0,0,128,224,252,127
DEFB 64+3,13, 248,126,27,15,14,14,14,14
DEFB 64+3,14, 3,3,195,243,255,63,7,1
DEFB 64+3,15, 63,15,3,1,1,1,225,249
DEFB 64+4,0, 0,0,0,128,176,181,177,48
DEFB 64+4,1, 0,0,0,0,0,128,172,173
DEFB 64+4,2, 0,0,0,0,0,0,0,160
DEFB 64+4,3, 4,5,5,5,5,5,5,5
DEFB 64+4,4, 93,221,197,192,192,192,192,192
DEFB 64+4,5, 192,236,239,111,7,0,0,0
DEFB 64+4,6, 28,28,156,180,179,63,7,0
DEFB 64+4,7, 0,0,0,0,128,216,223,223
DEFB 64+4,8, 1,0,0,0,0,0,128,240
DEFB 64+4,9, 255,63,7,0,0,0,0,0
DEFB 64+4,10, 0,224,254,127,27,15,14,14
DEFB 64+4,11, 0,0,0,128,240,254,63,7
DEFB 64+4,12, 111,97,96,96,96,96,224,220
DEFB 64+4,13, 238,254,123,15,3,0,0,0
DEFB 64+4,14, 0,0,0,224,252,127,15,3
DEFB 64+4,15, 127,15,3,1,1,1,225,249
DEFB 64+5,0, 21,21,21,21,21,21,21,21
DEFB 64+5,1, 173,141,128,128,128,128,128,128
DEFB 64+5,2, 182,182,182,6,0,0,0,0
DEFB 64+5,3, 5,213,220,220,93,1,0,0
DEFB 128+5,4, 192,192,192,88,221,221,29,0
DEFB 64+5,5, 0,0,0,0,128,236,239,239
DEFB 64+5,6, 0,0,0,0,0,0,128,188
DEFB 64+5,7, 7,0,0,0,0,0,0,0
DEFB 64+5,8, 255,255,12,7,7,7,7,7
DEFB 64+5,9, 0,224,254,255,31,1,0,0
DEFB 64+5,10, 14,14,14,206,254,251,63,3
DEFB 64+5,11, 0,0,0,0,0,192,252,255
DEFB 64+5,12, 255,63,3,0,0,0,0,128
DEFB 64+5,13, 0,240,254,127,15,15,14,14
DEFB 64+5,14, 3,3,3,195,251,255,62,7
DEFB 64+5,15, 127,15,3,1,1,1,225,253
DEFB 64+6,0, 21,21,181,176,176,181,5,0
DEFB 128+6,1, 128,128,128,128,172,173,173,13
DEFB 64+6,2, 0,0,0,0,0,176,182,182
DEFB 192+6,3, 0,0,0,0,0,0,192,221
DEFB 128+6,5, 15,0,0,0,0,0,0,0
DEFB 64+6,6, 191,179,31,28,28,28,28,28
DEFB 64+6,7, 192,223,223,31,1,0,0,0
DEFB 64+6,8, 7,7,247,253,254,15,0,0
DEFB 64+6,9, 0,0,0,128,248,255,127,7
DEFB 64+6,10, 0,0,0,0,0,192,252,255
DEFB 64+6,11, 63,3,0,0,0,0,0,224
DEFB 64+6,12, 248,255,127,103,96,96,96,96
DEFB 64+6,13, 14,14,254,250,127,15,0,0
DEFB 64+6,14, 0,0,0,0,224,254,255,14
DEFB 64+6,15, 127,15,1,1,1,1,193,253
DEFB 128+7,2, 54,0,0,0,0,0,0,0
DEFB 64+7,3, 221,220,4,5,5,5,5,5
DEFB 128+7,4, 220,93,93,205,192,192,192,192
DEFB 64+7,5, 0,224,239,239,47,0,0,0
DEFB 64+7,6, 28,28,156,179,187,191,1,0
DEFB 64+7,7, 0,0,0,0,220,223,223,7
DEFB 64+7,8, 0,0,0,0,0,240,255,255
DEFB 64+7,9, 0,0,0,0,0,0,192,255
DEFB 64+7,10, 123,15,14,14,14,14,14,14
DEFB 64+7,11, 254,255,31,0,0,0,0,0
DEFB 64+7,12, 96,224,255,255,15,0,0,0
DEFB 64+7,13, 0,0,0,240,255,123,15,14
DEFB 64+7,14, 3,3,3,3,131,251,255,63
DEFB 64+7,15, 255,15,1,1,1,1,193,253
DEFB 64+8,0, 0,180,181,176,176,21,21,21
DEFB 128+8,1, 0,0,173,173,173,173,128,128
DEFB 128+8,2, 0,0,0,182,182,182,22,0
DEFB 128+8,3, 5,5,5,5,221,220,221,5
DEFB 64+8,4, 192,192,192,192,192,93,221,221
DEFB 64+8,5, 0,0,0,0,0,128,239,239
DEFB 64+8,6, 0,0,0,0,0,0,128,191
DEFB 64+8,7, 0,0,0,0,0,0,0,192
DEFB 64+8,8, 12,7,7,7,7,7,7,7
DEFB 64+8,9, 255,127,0,0,0,0,0,0
DEFB 64+8,10, 254,251,255,3,0,0,0,0
DEFB 64+8,11, 0,224,255,255,7,0,0,0
DEFB 64+8,12, 0,0,128,255,223,127,96,96
DEFB 64+8,13, 14,14,14,14,254,251,127,1
DEFB 64+8,14, 1,0,0,0,0,224,255,255
DEFB 64+8,15, 255,15,1,1,1,1,129,255
DEFB 64+9,0, 21,21,21,21,21,21,21,149
DEFB 192+9,1, 128,128,128,128,128,128,128,128
DEFB 128+9,4, 1,0,0,0,0,0,0,0
DEFB 64+9,5, 239,1,0,0,0,0,0,0
DEFB 64+9,6, 191,179,28,28,28,28,28,28
DEFB 64+9,7, 223,223,95,0,0,0,0,0
DEFB 64+9,8, 247,252,255,31,0,0,0,0
DEFB 64+9,9, 0,240,255,255,15,0,0,0
DEFB 64+9,10, 0,0,248,255,251,15,14,14
DEFB 64+9,11, 0,0,0,252,255,255,1,0
DEFB 64+9,12, 96,96,96,96,252,255,255,0
DEFB 64+9,13, 0,0,0,0,0,254,255,123
DEFB 64+9,14, 7,3,3,3,3,3,255,254
DEFB 64+9,15, 255,15,1,1,1,1,1,255
DEFB 64+10,0, 176,176,181,1,0,0,0,0
DEFB 64+10,1, 173,173,173,173,0,0,0,0
DEFB 128+10,2, 128,182,182,182,0,0,0,0
DEFB 128+10,3, 0,221,221,220,92,5,5,5
DEFB 64+10,4, 0,128,221,93,93,192,192,192
DEFB 64+10,5, 0,0,239,239,239,7,0,0
DEFB 64+10,6, 28,28,156,179,191,191,0,0
DEFB 64+10,7, 0,0,0,223,223,223,0,0
DEFB 64+10,8, 0,0,0,224,255,252,126,7
DEFB 64+10,9, 0,0,0,0,255,255,255,0
DEFB 64+10,10, 14,14,14,14,238,251,255,15
DEFB 64+10,11, 0,0,0,0,0,255,255,255
DEFB 64+10,12, 0,0,0,0,0,224,255,223
DEFB 64+10,13, 14,14,14,14,14,14,255,255
DEFB 64+10,14, 63,0,0,0,0,0,240,255
DEFB 64+10,15, 255,15,1,1,1,1,1,255
DEFB 64+11,0, 0,0,0,0,0,0,181,181
DEFB 64+11,1, 0,0,0,0,0,0,173,173
DEFB 64+11,2, 0,0,0,0,0,0,182,182
DEFB 64+11,3, 5,5,5,5,5,5,221,220
DEFB 64+11,4, 192,192,192,192,192,192,221,93
DEFB 64+11,5, 0,0,0,0,0,0,239,239
DEFB 64+11,6, 0,0,0,0,0,0,128,191
DEFB 64+11,7, 0,0,0,0,0,0,0,223
DEFB 64+11,8, 7,7,7,7,7,7,7,252
DEFB 64+11,9, 0,0,0,0,0,0,0,255
DEFB 64+11,10, 0,0,0,0,0,0,0,255
DEFB 64+11,11, 0,0,0,0,0,0,0,255
DEFB 64+11,12, 96,96,96,96,96,96,96,223
DEFB 64+11,13, 255,0,0,0,0,0,0,255
DEFB 64+11,14, 254,3,3,3,3,3,3,254
DEFB 64+11,15, 255,15,1,1,1,1,1,255

S454L2
DEFB 27
DEFB 64+7,0, 0,0,0,0,0,224,127,12
DEFB 128+7,1, 0,0,0,0,0,0,224,127
DEFB 192+7,2, 0,0,0,0,0,0,0,192
DEFB 64+8,0, 236,255,3,0,255,127,12,252
DEFB 64+8,1, 0,240,255,19,16,255,31,0
DEFB 64+8,2, 127,96,240,255,1,193,255,103
DEFB 128+8,3, 192,255,4,252,255,128,224,255
DEFB 128+8,4, 0,192,255,1,249,255,49,249
DEFB 192+8,5, 0,0,0,128,128,128,128,128
DEFB 64+9,0, 255,0,0,255,63,12,252,255
DEFB 64+9,1, 254,255,16,240,255,1,0,255
DEFB 64+9,2, 96,255,63,1,255,255,96,248
DEFB 64+9,3, 5,196,255,131,128,255,15,4
DEFB 64+9,4, 255,1,249,255,49,241,255,1
DEFB 192+9,5, 128,128,128,128,128,128,128,128
DEFB 64+10,0, 0,0,255,15,12,255,255,0
DEFB 64+10,1, 31,16,255,255,0,192,255,16
DEFB 64+10,2, 255,1,129,255,96,96,255,31
DEFB 64+10,3, 255,159,128,255,255,4,255,255
DEFB 64+10,4, 241,255,49,241,255,1,225,255
DEFB 192+10,5, 128,128,128,128,128,128,128,128
DEFB 64+11,0, 0,255,12,12,255,255,0,0
DEFB 64+11,1, 16,255,63,0,255,255,16,16
DEFB 64+11,2, 1,255,255,96,255,255,1,1
DEFB 64+11,3, 128,255,255,4,252,255,128,128
DEFB 64+11,4, 49,241,255,1,1,255,49,49
DEFB 192+11,5, 128,128,128,128,128,128,128,128

S454L1
DEFB 57
DEFB 128+6,7, 0,0,0,0,0,0,3,14
DEFB 128+6,8, 0,0,0,0,0,224,255,195
DEFB 192+6,9, 0,0,0,0,0,0,0,248
DEFB 128+7,5, 0,0,0,0,0,0,1,3
DEFB 128+7,6, 0,0,1,7,29,121,207,222
DEFB 64+7,7, 56,121,207,159,254,242,227,127
DEFB 64+7,8, 192,240,255,199,195,227,255,207
DEFB 64+7,9, 31,12,204,254,63,0,128,254
DEFB 128+7,10, 128,252,7,1,241,255,55,48
DEFB 128+7,11, 0,0,224,255,131,192,254,31
DEFB 128+7,12, 0,0,0,0,248,127,96,240
DEFB 128+7,13, 0,0,0,0,0,192,252,39
DEFB 192+7,14, 0,0,0,0,0,0,0,224
DEFB 128+8,5, 14,63,247,159,249,235,223,254
DEFB 64+8,6, 250,227,175,63,249,203,223,254
DEFB 64+8,7, 124,248,139,159,254,242,227,127
DEFB 64+8,8, 192,192,255,255,195,195,255,255
DEFB 64+8,9, 63,12,12,254,127,0,0,254
DEFB 64+8,10, 248,255,3,1,253,255,49,48
DEFB 64+8,11, 12,236,255,143,128,248,255,15
DEFB 64+8,12, 255,7,134,254,127,96,224,255
DEFB 64+8,13, 224,254,31,2,250,255,35,224
DEFB 64+8,14, 63,35,240,255,3,226,255,47
DEFB 128+8,15, 0,248,95,192,254,31,140,254
DEFB 128+9,5, 247,159,253,233,207,254,246,151
DEFB 64+9,6, 226,167,63,249,201,207,254,242
DEFB 64+9,7, 252,232,137,159,254,226,98,127
DEFB 64+9,8, 192,192,252,255,195,195,243,255
DEFB 64+9,9, 255,12,12,254,255,0,0,254
DEFB 64+9,10, 254,255,1,1,255,127,48,48
DEFB 64+9,11, 12,254,255,128,128,255,31,12
DEFB 64+9,12, 7,6,254,127,96,224,255,15
DEFB 64+9,13, 255,15,2,254,127,32,224,255
DEFB 64+9,14, 160,255,31,2,254,127,32,248
DEFB 64+9,15, 127,64,252,63,12,252,127,64
DEFB 128+10,5, 255,249,203,255,254,151,255,253
DEFB 64+10,6, 35,63,253,201,207,255,242,34
DEFB 64+10,7, 255,232,136,159,255,226,98,127
DEFB 64+10,8, 199,192,192,255,255,195,195,255
DEFB 64+10,9, 255,12,12,254,255,0,0,254
DEFB 64+10,10, 255,127,1,1,255,63,48,48
DEFB 64+10,11, 236,255,131,128,254,255,12,12
DEFB 64+10,12, 6,254,255,96,96,255,31,6
DEFB 64+10,13, 3,2,255,63,32,252,255,2
DEFB 64+10,14, 255,2,194,255,35,32,255,31
DEFB 64+10,15, 252,255,12,252,255,64,248,255
DEFB 128+11,5, 201,255,255,150,159,255,201,201
DEFB 64+11,6, 63,255,201,201,255,254,34,34
DEFB 64+11,7, 255,200,136,159,255,98,98,127
DEFB 64+11,8, 255,192,192,255,255,195,195,255
DEFB 64+11,9, 255,12,12,254,255,0,0,254
DEFB 64+11,10, 255,7,1,1,255,48,48,48
DEFB 64+11,11, 255,255,128,128,255,31,12,12
DEFB 64+11,12, 254,255,96,96,255,255,6,6
DEFB 64+11,13, 2,255,39,32,255,255,2,2
DEFB 64+11,14, 2,255,255,32,255,255,2,2
DEFB 64+11,15, 12,252,255,64,192,255,12,12

S456L3
DEFB 9
DEFB 64+9,0, 0,0,0,0,240,63,255,255
DEFB 128+9,1, 0,0,0,0,0,255,9,255
DEFB 192+9,2, 0,0,0,0,0,192,240,240
DEFB 64+10,0, 255,31,255,207,255,15,255,193
DEFB 64+10,1, 193,255,248,255,253,255,255,255
DEFB 192+10,2, 176,240,16,240,144,240,144,240
DEFB 64+11,0, 255,12,255,192,255,12,255,192
DEFB 64+11,1, 255,63,255,131,255,8,255,129
DEFB 192+11,2, 240,240,240,240,240,16,240,144

S456L2
DEFB 24
DEFB 128+9,2, 0,0,0,1,7,31,31,31
DEFB 128+9,3, 0,28,127,252,255,241,255,240
DEFB 128+9,4, 0,0,255,19,255,15,255,63
DEFB 128+9,5, 0,0,128,255,240,255,2,255
DEFB 128+9,6, 0,0,0,224,127,252,255,252
DEFB 128+9,7, 0,0,0,0,252,143,255,31
DEFB 128+9,8, 0,0,0,0,0,255,137,255
DEFB 192+9,9, 0,0,0,0,0,128,192,192
DEFB 128+10,2, 31,31,31,31,31,31,31,31
DEFB 64+10,3, 255,241,255,255,252,255,241,255
DEFB 64+10,4, 252,255,227,255,16,255,3,255
DEFB 64+10,5, 49,255,3,255,63,255,63,255
DEFB 64+10,6, 255,248,255,252,255,224,255,204
DEFB 64+10,7, 255,135,255,19,255,131,255,16
DEFB 64+10,8, 225,255,248,255,253,255,255,255
DEFB 192+10,9, 192,192,64,192,64,192,64,192
DEFB 128+11,2, 31,31,31,31,31,31,31,31
DEFB 64+11,3, 240,255,241,255,255,255,255,241
DEFB 64+11,4, 17,255,127,255,255,144,255,3
DEFB 64+11,5, 255,255,255,242,255,48,255,2
DEFB 64+11,6, 255,96,255,12,255,96,255,12
DEFB 64+11,7, 255,130,255,16,255,130,255,16
DEFB 64+11,8, 255,63,255,67,255,8,255,65
DEFB 192+11,9, 192,192,192,192,192,64,192,64

S456L1
DEFB 21
DEFB 128+9,9, 0,0,0,0,1,63,59,63
DEFB 128+9,10, 0,0,0,15,253,255,254,159
DEFB 128+9,11, 0,3,127,211,255,231,127,243
DEFB 128+9,12, 0,128,255,137,255,71,255,31
DEFB 128+9,13, 0,0,0,255,227,255,11,255
DEFB 128+9,14, 0,0,0,0,255,211,255,199
DEFB 128+9,15, 0,0,0,0,0,255,203,255
DEFB 128+10,9, 55,63,47,63,63,63,63,62
DEFB 64+10,10, 253,127,254,159,255,111,255,151
DEFB 64+10,11, 191,255,95,255,151,255,199,255
DEFB 64+10,12, 252,127,241,255,136,255,65,255
DEFB 64+10,13, 103,255,15,255,127,255,127,254
DEFB 64+10,14, 255,145,255,199,255,16,255,70
DEFB 64+10,15, 227,255,248,255,254,255,255,127
DEFB 128+11,9, 63,61,63,54,63,41,63,54
DEFB 64+11,10, 255,111,255,147,255,109,255,146
DEFB 64+11,11, 211,255,255,255,255,159,255,71
DEFB 64+11,12, 9,255,95,255,255,232,255,65
DEFB 64+11,13, 255,255,255,232,255,99,255,8
DEFB 64+11,14, 255,16,255,70,255,16,255,70
DEFB 64+11,15, 255,159,255,39,255,136,255,34

S458L4
DEFB 4
DEFB 64+10,0, 0,0,252,207,255,255,255,127
DEFB 192+10,1, 0,0,0,224,224,224,224,224
DEFB 64+11,0, 255,255,255,255,255,255,255,255
DEFB 192+11,1, 224,224,224,224,224,224,224,224

S458L3
DEFB 12
DEFB 128+10,1, 0,15,63,62,63,63,62,63
DEFB 128+10,2, 0,255,255,223,255,255,255,255
DEFB 128+10,3, 0,252,223,255,255,199,255,255
DEFB 128+10,4, 0,0,255,255,231,255,255,255
DEFB 128+10,5, 0,0,252,239,255,255,255,63
DEFB 192+10,6, 0,0,0,192,192,192,192,192
DEFB 128+11,1, 63,62,63,63,63,63,63,63
DEFB 64+11,2, 255,255,255,255,255,255,255,255
DEFB 64+11,3, 226,255,255,254,255,255,255,255
DEFB 64+11,4, 255,255,255,19,255,255,255,255
DEFB 64+11,5, 255,255,255,255,255,255,255,255
DEFB 192+11,6, 192,192,192,192,192,192,192,192

S458L2
DEFB 12
DEFB 128+10,6, 0,1,63,127,127,127,127,127
DEFB 128+10,7, 0,255,255,250,255,255,243,255
DEFB 128+10,8, 0,255,253,255,255,252,255,255
DEFB 128+10,9, 0,128,255,255,253,255,255,255
DEFB 128+10,10, 0,0,254,255,255,255,255,159
DEFB 192+10,11, 0,0,0,128,128,128,128,128
DEFB 128+11,6, 127,127,127,125,127,127,127,127
DEFB 64+11,7, 255,243,255,255,247,255,255,255
DEFB 64+11,8, 254,255,255,255,255,255,255,255
DEFB 64+11,9, 127,255,255,197,255,255,255,255
DEFB 64+11,10, 255,255,255,255,255,255,255,255
DEFB 192+11,11, 128,128,128,128,128,128,128,128

S458L1
DEFB 10
DEFB 128+10,11, 0,0,63,127,127,127,127,127
DEFB 128+10,12, 0,63,255,255,255,239,255,255
DEFB 128+10,13, 0,255,255,215,255,255,223,255
DEFB 128+10,14, 0,240,191,255,255,159,255,255
DEFB 128+10,15, 0,0,254,247,255,255,255,255
DEFB 128+11,11, 127,127,127,127,127,127,127,127
DEFB 64+11,12, 255,255,255,127,255,255,255,255
DEFB 64+11,13, 255,223,255,255,255,255,255,255
DEFB 64+11,14, 207,255,255,249,255,255,255,255
DEFB 64+11,15, 255,255,255,127,255,255,255,255

; : 6029 


;   

VST1F0
DEFB 83
DEFB 128+7,5, 0,0,0,0,0,0,0,56
DEFB 128+8,4, 0,1,3,3,7,7,7,7
DEFB 64+8,5, 254,255,255,255,255,255,255,255
DEFB 192+8,6, 0,0,128,128,128,128,128,128
DEFB 128+9,3, 0,0,0,0,0,0,0,30
DEFB 64+9,4, 6,6,7,7,3,7,15,63
DEFB 64+9,5, 60,56,255,255,255,255,251,255
DEFB 64+9,6, 192,192,192,192,192,160,240,191
DEFB 192+9,7, 0,0,0,0,0,0,0,240
DEFB 128+10,2, 0,0,0,1,1,1,1,0
DEFB 64+10,3, 63,119,255,253,255,255,255,255
DEFB 64+10,4, 255,191,255,255,255,255,191,255
DEFB 64+10,5, 255,255,255,199,255,255,255,255
DEFB 64+10,6, 63,255,255,255,255,255,255,255
DEFB 192+10,7, 254,254,254,252,252,252,252,252
DEFB 128+11,2, 0,0,1,3,3,3,1,7
DEFB 64+11,3, 255,255,255,255,255,255,254,254
DEFB 64+11,4, 253,255,255,255,255,255,127,127
DEFB 64+11,5, 255,127,255,255,255,255,255,255
DEFB 64+11,6, 255,255,255,255,255,254,254,252
DEFB 192+11,7, 252,254,190,254,254,126,126,127
DEFB 128+12,2, 2,7,7,7,15,15,15,15
DEFB 64+12,3, 254,254,252,240,240,224,192,192
DEFB 64+12,4, 255,255,127,127,127,127,127,127
DEFB 64+12,5, 255,255,255,255,255,255,255,255
DEFB 64+12,6, 252,252,252,252,248,240,240,240
DEFB 64+12,7, 127,127,127,31,31,31,15,7
DEFB 192+12,8, 0,128,224,224,224,240,176,248
DEFB 128+13,1, 0,0,0,0,0,0,0,3
DEFB 64+13,2, 31,63,63,127,119,255,255,255
DEFB 64+13,3, 192,128,0,0,0,128,128,0
DEFB 64+13,4, 63,63,63,63,127,255,127,255
DEFB 64+13,5, 255,255,255,254,255,127,255,255
DEFB 64+13,6, 240,248,124,252,254,255,255,255
DEFB 64+13,7, 7,3,1,0,0,0,0,192
DEFB 64+13,8, 236,236,222,239,255,31,31,30
DEFB 192+13,9, 0,0,0,0,0,0,128,128
DEFB 128+14,1, 3,7,15,15,31,31,31,63
DEFB 64+14,2, 255,255,252,252,184,120,248,240
DEFB 64+14,3, 1,3,3,7,7,7,15,31
DEFB 64+14,4, 255,191,255,191,255,255,255,255
DEFB 128+14,5, 255,255,255,255,255,255,227,129
DEFB 64+14,6, 255,255,255,255,255,255,255,255
DEFB 64+14,7, 192,240,248,252,252,252,252,254
DEFB 64+14,8, 29,7,7,7,1,1,0,0
DEFB 192+14,9, 128,192,192,224,224,224,192,192
DEFB 128+15,0, 0,0,0,0,0,1,3,3
DEFB 64+15,1, 63,121,123,115,231,231,207,158
DEFB 64+15,2, 240,224,224,224,128,128,0,0
DEFB 64+15,3, 29,23,63,63,127,255,247,255
DEFB 192+15,4, 255,255,255,254,252,252,252,248
DEFB 128+15,6, 255,127,63,63,15,7,3,1
DEFB 64+15,7, 255,255,255,255,251,255,255,255
DEFB 192+15,8, 0,0,128,192,224,224,224,248
DEFB 128+16,0, 3,15,15,15,15,14,0,0
DEFB 128+16,1, 158,184,56,0,0,0,0,0
DEFB 64+16,2, 1,1,1,3,3,3,3,3
DEFB 64+16,3, 255,255,255,255,255,255,255,255
DEFB 192+16,4, 248,248,248,240,240,240,240,240
DEFB 128+16,6, 1,1,1,1,1,3,3,3
DEFB 64+16,7, 255,255,255,255,255,255,255,255
DEFB 192+16,8, 248,248,248,240,240,224,192,192
DEFB 128+17,2, 3,3,3,3,3,7,7,7
DEFB 64+17,3, 255,255,255,255,255,255,255,254
DEFB 192+17,4, 240,240,240,192,192,128,0,0
DEFB 128+17,6, 3,3,3,3,3,3,3,3
DEFB 64+17,7, 255,255,255,255,255,255,255,254
DEFB 192+17,8, 192,192,192,128,0,0,0,0
DEFB 128+18,2, 7,3,3,3,3,3,7,15
DEFB 192+18,3, 254,254,254,252,252,248,248,248
DEFB 128+18,6, 3,3,1,1,1,1,1,1
DEFB 192+18,7, 254,254,254,254,254,254,254,255
DEFB 128+19,1, 0,0,0,0,0,0,0,3
DEFB 64+19,2, 15,15,31,31,63,127,247,255
DEFB 192+19,3, 248,240,224,224,224,192,192,192
DEFB 128+19,6, 1,3,3,1,1,0,0,0
DEFB 64+19,7, 255,255,255,255,255,255,31,15
DEFB 192+19,8, 128,192,224,224,248,252,254,255
DEFB 128+20,1, 7,7,7,3,0,0,0,0
DEFB 128+20,2, 255,255,255,255,0,0,0,0
DEFB 192+20,3, 192,192,192,0,0,0,0,0
DEFB 128+20,7, 7,1,0,0,0,0,0,0
DEFB 192+20,8, 255,252,0,0,0,0,0,0

VST2F0
DEFB 22
DEFB 128+10,1, 0,0,1,1,1,1,1,1
DEFB 192+10,2, 0,96,240,248,248,248,248,248
DEFB 128+11,1, 63,127,255,255,127,255,255,255
DEFB 64+11,2, 255,255,255,255,255,255,255,254
DEFB 192+11,3, 192,224,224,224,224,224,224,224
DEFB 128+12,0, 1,1,1,1,3,7,7,15
DEFB 64+12,1, 247,247,231,199,199,135,199,143
DEFB 64+12,2, 254,254,252,252,254,254,255,255
DEFB 192+12,3, 240,248,120,124,60,30,31,143
DEFB 128+13,0, 31,31,31,62,62,124,120,216
DEFB 64+13,1, 143,31,63,63,63,127,254,254
DEFB 64+13,2, 255,255,255,159,143,3,3,1
DEFB 64+13,3, 199,231,227,240,240,248,252,252
DEFB 192+13,4, 0,128,0,0,0,0,0,0
DEFB 128+14,0, 208,192,0,0,1,1,1,0
DEFB 64+14,1, 254,254,254,254,252,248,240,240
DEFB 64+14,2, 1,3,3,3,3,3,3,1
DEFB 192+14,3, 252,248,240,240,240,240,224,224
DEFB 128+15,0, 0,1,3,3,7,15,15,15
DEFB 128+15,1, 240,224,224,224,192,192,192,128
DEFB 128+15,2, 1,1,3,1,1,0,0,0
DEFB 192+15,3, 224,240,248,252,254,126,0,0

VST3F0
DEFB 15
DEFB 128+10,1, 0,0,0,0,0,0,0,1
DEFB 192+10,2, 0,0,0,0,0,0,64,224
DEFB 128+11,1, 1,1,1,31,31,31,31,31
DEFB 192+11,2, 224,240,240,255,255,254,254,255
DEFB 128+12,0, 0,0,0,0,0,0,1,1
DEFB 64+12,1, 63,63,59,115,115,247,231,239
DEFB 64+12,2, 255,255,243,249,253,254,254,191
DEFB 192+12,3, 0,128,128,192,192,224,96,96
DEFB 128+13,0, 1,3,7,6,0,0,0,0
DEFB 64+13,1, 223,223,159,31,30,62,60,28
DEFB 64+13,2, 159,15,7,15,15,15,15,14
DEFB 192+13,3, 128,128,128,128,0,0,0,0
DEFB 128+14,1, 60,56,248,240,240,0,0,0
DEFB 128+14,2, 15,15,7,3,0,0,0,0
DEFB 192+14,3, 0,128,192,192,0,0,0,0

VST4F0
DEFB 6
DEFB 128+11,0, 0,0,1,1,7,15,15,15
DEFB 192+11,1, 0,224,224,224,248,252,252,252
DEFB 128+12,0, 15,15,29,63,59,127,127,239
DEFB 192+12,1, 254,254,247,255,255,253,190,30
DEFB 128+13,0, 207,15,14,14,12,28,60,56
DEFB 192+13,1, 30,28,28,28,28,30,15,0

VST5F0
DEFB 6
DEFB 128+11,0, 0,0,0,0,0,7,7,7
DEFB 192+11,1, 0,0,192,192,224,248,248,248
DEFB 128+12,0, 7,15,13,31,27,63,63,7
DEFB 192+12,1, 248,252,254,254,254,188,60,56
DEFB 128+13,0, 7,6,14,28,12,0,0,0
DEFB 192+13,1, 56,56,60,28,0,0,0,0

VST6F0
DEFB 6
DEFB 128+11,0, 0,0,0,0,0,1,3,7
DEFB 192+11,1, 0,0,0,192,192,224,240,240
DEFB 128+12,0, 7,7,15,15,31,31,7,7
DEFB 192+12,1, 248,248,252,252,248,56,56,48
DEFB 128+13,0, 6,14,14,0,0,0,0,0
DEFB 192+13,1, 56,56,0,0,0,0,0,0

; : 1386 


;   

VSR1F0
DEFB 71
DEFB 128+8,4, 1,15,31,31,31,63,63,63
DEFB 192+8,5, 192,240,248,252,252,252,252,252
DEFB 128+9,2, 0,0,0,0,0,0,15,15
DEFB 128+9,3, 0,0,0,0,0,0,128,192
DEFB 64+9,4, 63,49,27,63,63,31,63,127
DEFB 192+9,5, 252,132,204,252,252,252,255,221
DEFB 128+10,1, 0,0,0,0,0,1,3,3
DEFB 64+10,2, 13,15,15,7,31,255,255,255
DEFB 64+10,3, 241,239,240,255,255,255,255,255
DEFB 64+10,4, 255,255,127,255,255,255,255,127
DEFB 64+10,5, 253,255,247,255,255,255,255,255
DEFB 128+10,6, 255,255,255,255,255,255,255,255
DEFB 192+10,7, 0,240,240,240,224,224,224,224
DEFB 128+11,1, 2,2,0,0,0,0,0,0
DEFB 64+11,2, 127,127,255,127,63,31,7,6
DEFB 64+11,3, 255,255,255,255,255,223,199,199
DEFB 64+11,4, 127,239,247,255,127,255,255,255
DEFB 64+11,5, 255,255,255,255,255,255,255,255
DEFB 64+11,6, 255,255,255,253,255,247,231,231
DEFB 192+11,7, 224,224,240,240,240,240,240,248
DEFB 128+12,2, 6,7,3,3,0,0,0,0
DEFB 64+12,3, 231,231,199,135,7,3,7,7
DEFB 64+12,4, 255,255,255,255,255,255,255,255
DEFB 64+12,5, 255,255,255,255,255,255,255,255
DEFB 64+12,6, 231,199,195,193,193,128,128,128
DEFB 64+12,7, 248,252,254,254,255,255,255,56
DEFB 192+12,8, 0,0,0,0,0,0,128,128
DEFB 128+13,3, 15,15,15,15,31,63,127,127
DEFB 64+13,4, 223,255,255,255,255,127,255,255
DEFB 64+13,5, 255,255,255,252,255,255,255,255
DEFB 64+13,6, 128,128,192,224,224,224,240,240
DEFB 128+13,7, 60,31,14,15,7,7,3,3
DEFB 192+13,8, 128,192,192,224,240,248,248,252
DEFB 128+14,2, 0,0,1,1,3,7,7,15
DEFB 64+14,3, 255,255,255,255,255,255,255,255
DEFB 64+14,4, 255,255,255,255,252,248,248,240
DEFB 64+14,5, 255,255,255,255,255,127,63,31
DEFB 192+14,6, 248,248,248,252,252,254,254,255
DEFB 128+14,8, 252,124,124,60,28,24,0,0
DEFB 128+15,2, 15,31,31,63,63,63,63,63
DEFB 64+15,3, 255,255,255,255,255,255,254,254
DEFB 128+15,4, 224,192,192,128,0,0,0,0
DEFB 64+15,5, 31,15,15,15,7,3,3,3
DEFB 64+15,6, 255,255,255,255,255,255,253,255
DEFB 192+15,7, 0,0,128,128,128,224,224,160
DEFB 128+16,2, 63,127,127,127,255,255,255,255
DEFB 192+16,3, 252,248,248,248,240,240,240,224
DEFB 128+16,5, 3,1,1,1,1,3,3,7
DEFB 64+16,6, 255,255,255,255,255,255,255,255
DEFB 192+16,7, 224,240,240,240,240,224,192,128
DEFB 128+17,1, 0,1,1,1,1,3,3,3
DEFB 64+17,2, 255,255,255,255,255,255,255,255
DEFB 192+17,3, 224,224,224,224,192,128,128,0
DEFB 128+17,5, 7,7,7,3,3,3,3,3
DEFB 64+17,6, 255,255,255,255,255,255,255,255
DEFB 192+17,7, 128,128,128,128,128,0,0,0
DEFB 128+18,1, 3,3,3,1,3,3,3,7
DEFB 192+18,2, 254,254,252,252,248,248,248,248
DEFB 128+18,5, 3,3,3,3,1,1,3,1
DEFB 192+18,6, 254,254,252,252,252,252,252,254
DEFB 128+19,0, 0,0,0,0,0,0,0,1
DEFB 64+19,1, 15,15,15,31,63,119,239,255
DEFB 192+19,2, 240,240,224,224,224,192,192,192
DEFB 128+19,5, 1,3,3,3,3,1,0,0
DEFB 64+19,6, 255,255,255,255,255,255,255,31
DEFB 192+19,7, 0,0,128,224,224,248,252,254
DEFB 128+20,0, 7,7,7,15,3,0,0,0
DEFB 128+20,1, 79,255,255,255,255,0,0,0
DEFB 192+20,2, 192,192,192,128,0,0,0,0
DEFB 128+20,6, 15,15,1,0,0,0,0,0
DEFB 192+20,7, 254,254,252,0,0,0,0,0

VSR2F0
DEFB 19
DEFB 128+10,2, 0,0,60,126,126,126,126,126
DEFB 128+11,1, 60,63,63,255,255,255,127,63
DEFB 64+11,2, 255,255,255,255,255,255,255,255
DEFB 192+11,3, 0,248,248,248,248,248,248,248
DEFB 128+12,1, 29,29,1,1,3,3,7,15
DEFB 64+12,2, 255,255,255,255,255,255,255,255
DEFB 64+12,3, 188,188,158,30,15,135,199,195
DEFB 192+12,4, 0,0,0,0,0,128,128,192
DEFB 128+13,1, 15,15,31,63,63,63,63,127
DEFB 64+13,2, 255,255,239,199,135,131,3,1
DEFB 64+13,3, 193,225,224,240,240,248,248,248
DEFB 192+13,4, 192,192,128,0,0,0,0,0
DEFB 128+14,1, 126,126,124,252,252,248,248,240
DEFB 64+14,2, 1,3,3,3,3,3,3,3
DEFB 192+14,3, 248,248,240,240,240,224,224,224
DEFB 128+15,0, 0,1,1,3,7,15,31,15
DEFB 128+15,1, 240,224,224,224,192,192,192,192
DEFB 128+15,2, 3,3,3,3,1,0,0,0
DEFB 192+15,3, 224,224,240,248,252,124,124,0

VSR3F0
DEFB 13
DEFB 128+10,1, 0,0,0,0,0,0,0,120
DEFB 128+11,0, 0,0,0,15,15,31,31,15
DEFB 64+11,1, 120,120,120,255,255,255,255,255
DEFB 192+11,2, 0,0,0,128,128,128,128,128
DEFB 128+12,0, 7,7,1,1,3,7,7,15
DEFB 64+12,1, 255,253,253,252,254,254,254,223
DEFB 192+12,2, 128,192,192,224,240,112,48,0
DEFB 128+13,0, 15,15,31,31,30,30,30,28
DEFB 64+13,1, 159,143,15,15,15,15,15,14
DEFB 192+13,2, 0,128,128,128,0,0,0,0
DEFB 128+14,0, 56,56,120,248,240,0,0,0
DEFB 128+14,1, 15,15,15,3,0,0,0,0
DEFB 192+14,2, 0,128,192,192,0,0,0,0

VSR4F0
DEFB 7
DEFB 128+11,0, 0,0,0,0,7,7,15,15
DEFB 192+11,1, 0,112,240,240,248,254,254,254
DEFB 128+12,0, 3,3,1,3,3,7,7,7
DEFB 64+12,1, 254,255,251,251,253,252,158,158
DEFB 192+12,2, 0,0,0,128,128,128,0,0
DEFB 128+13,0, 15,15,14,14,12,28,60,60
DEFB 192+13,1, 30,28,28,28,28,30,14,0

VSR5F0
DEFB 6
DEFB 128+11,0, 0,0,0,0,0,3,7,7
DEFB 192+11,1, 0,0,0,224,224,252,252,252
DEFB 128+12,0, 3,1,1,3,3,3,7,7
DEFB 192+12,1, 252,254,246,254,250,184,60,56
DEFB 128+13,0, 7,6,14,28,28,0,0,0
DEFB 192+13,1, 56,56,60,28,0,0,0,0

VSR6F0
DEFB 6
DEFB 128+11,0, 0,0,0,0,0,3,3,7
DEFB 192+11,1, 0,0,0,64,224,224,248,248
DEFB 128+12,0, 3,1,1,3,3,3,7,7
DEFB 192+12,1, 248,252,252,244,184,184,48,48
DEFB 128+13,0, 6,14,14,0,0,0,0,0
DEFB 192+13,1, 56,56,0,0,0,0,0,0

VSR7F0
DEFB 6
DEFB 128+11,0, 0,0,0,0,0,0,1,3
DEFB 192+11,1, 0,0,0,0,192,224,240,240
DEFB 128+12,0, 3,1,1,3,3,3,3,7
DEFB 192+12,1, 248,248,248,248,176,48,48,48
DEFB 128+13,0, 6,0,0,0,0,0,0,0
DEFB 192+13,1, 56,0,0,0,0,0,0,0

; : 1287 


;   

VF1F0
DEFB 62
DEFB 128+8,2, 0,0,0,0,0,0,1,1
DEFB 128+8,3, 0,0,0,0,28,255,255,255
DEFB 192+8,4, 0,0,0,0,0,0,192,192
DEFB 128+9,2, 1,3,3,3,3,3,3,3
DEFB 64+9,3, 255,255,255,255,156,28,255,255
DEFB 192+9,4, 192,192,192,192,64,96,224,224
DEFB 128+10,1, 0,0,0,1,15,63,62,127
DEFB 64+10,2, 1,3,63,255,255,255,255,255
DEFB 64+10,3, 255,255,255,254,255,255,252,255
DEFB 64+10,4, 192,240,255,223,191,255,255,255
DEFB 192+10,5, 0,0,224,254,254,254,248,248
DEFB 128+11,0, 0,0,0,0,0,0,3,3
DEFB 64+11,1, 255,255,255,255,255,255,255,255
DEFB 64+11,2, 255,255,255,255,255,254,253,255
DEFB 64+11,3, 255,255,255,255,127,255,255,255
DEFB 64+11,4, 255,255,255,255,255,255,255,255
DEFB 192+11,5, 216,184,248,252,252,252,252,252
DEFB 128+12,0, 3,7,7,7,7,7,7,15
DEFB 64+12,1, 255,255,255,254,254,254,252,252
DEFB 64+12,2, 255,63,127,119,63,63,63,63
DEFB 64+12,3, 255,255,255,255,255,255,255,255
DEFB 64+12,4, 255,255,255,255,255,255,255,247
DEFB 192+12,5, 252,248,248,248,248,248,240,240
DEFB 128+13,0, 15,15,15,7,7,3,3,1
DEFB 64+13,1, 248,248,248,248,252,255,255,255
DEFB 64+13,2, 63,63,63,63,63,63,111,255
DEFB 64+13,3, 255,255,255,255,255,255,255,255
DEFB 64+13,4, 243,243,243,251,251,249,253,252
DEFB 192+13,5, 240,208,240,248,252,252,254,254
DEFB 128+14,1, 255,251,127,125,127,255,254,121
DEFB 64+14,2, 255,255,255,255,247,255,255,255
DEFB 64+14,3, 255,255,255,255,255,255,255,255
DEFB 64+14,4, 252,254,255,255,255,255,255,255
DEFB 64+14,5, 126,127,63,159,159,207,231,243
DEFB 192+14,6, 0,0,0,128,128,128,192,192
DEFB 128+15,1, 123,127,127,123,63,31,15,7
DEFB 64+15,2, 247,243,255,255,255,255,255,255
DEFB 64+15,3, 119,241,225,241,248,248,248,128
DEFB 64+15,4, 255,253,255,255,127,127,63,31
DEFB 64+15,5, 243,113,241,249,248,188,252,254
DEFB 192+15,6, 128,128,128,0,0,0,0,0
DEFB 128+16,1, 1,7,7,7,7,7,15,15
DEFB 64+16,2, 223,255,255,255,254,254,254,254
DEFB 128+16,3, 128,128,0,0,0,0,0,0
DEFB 64+16,4, 31,15,15,7,7,3,3,3
DEFB 192+16,5, 254,238,255,255,243,223,255,255
DEFB 128+17,1, 15,15,15,31,31,31,31,31
DEFB 192+17,2, 252,252,248,248,248,240,240,224
DEFB 128+17,4, 3,7,7,7,7,7,3,3
DEFB 192+17,5, 255,255,255,255,254,254,254,254
DEFB 128+18,1, 31,63,63,63,127,127,255,223
DEFB 192+18,2, 224,224,192,192,192,192,224,224
DEFB 128+18,4, 3,3,3,3,3,3,3,3
DEFB 192+18,5, 254,254,254,254,252,252,252,252
DEFB 128+19,0, 3,7,7,7,7,3,0,0
DEFB 128+19,1, 255,255,255,255,255,255,0,0
DEFB 192+19,2, 224,192,192,0,0,0,0,0
DEFB 128+19,4, 3,3,3,1,3,1,0,0
DEFB 64+19,5, 252,254,254,254,255,255,255,255
DEFB 192+19,6, 0,0,0,0,0,0,128,128
DEFB 128+20,5, 255,127,127,127,127,0,0,0
DEFB 192+20,6, 192,192,192,192,192,0,0,0

VF2F0
DEFB 19
DEFB 128+10,1, 0,0,0,3,15,15,15,15
DEFB 192+10,2, 0,0,0,0,128,128,128,192
DEFB 128+11,0, 0,0,1,3,7,7,7,15
DEFB 64+11,1, 15,15,255,255,255,255,255,255
DEFB 192+11,2, 192,192,254,254,254,254,254,254
DEFB 128+12,0, 15,15,15,31,31,15,15,7
DEFB 64+12,1, 255,255,191,63,63,63,255,255
DEFB 192+12,2, 254,254,254,252,220,254,254,238
DEFB 128+13,0, 7,7,7,7,7,3,1,1
DEFB 64+13,1, 255,255,255,255,254,254,254,248
DEFB 64+13,2, 255,255,255,255,255,254,126,126
DEFB 192+13,3, 0,0,128,128,0,0,0,0
DEFB 128+14,0, 1,1,1,1,3,3,3,3
DEFB 64+14,1, 248,240,240,240,224,224,224,192
DEFB 192+14,2, 63,31,31,63,62,30,30,30
DEFB 128+15,0, 7,15,15,15,15,0,0,0
DEFB 128+15,1, 224,224,192,128,128,0,0,0
DEFB 128+15,2, 30,30,30,31,31,15,15,15
DEFB 192+15,3, 0,0,0,0,0,128,128,128

VF3F0
DEFB 8
DEFB 128+11,0, 7,7,7,7,63,127,127,255
DEFB 192+11,1, 128,128,128,128,248,248,248,248
DEFB 128+12,0, 255,255,239,239,255,127,127,127
DEFB 192+12,1, 248,248,240,248,248,252,252,252
DEFB 128+13,0, 127,63,62,60,60,60,56,120
DEFB 192+13,1, 252,248,120,60,60,56,56,56
DEFB 128+14,0, 248,248,240,0,0,0,0,0
DEFB 192+14,1, 56,56,60,60,28,0,0,0

VF4F0
DEFB 6
DEFB 128+11,0, 0,0,3,3,3,15,31,31
DEFB 192+11,1, 0,0,128,128,128,240,240,240
DEFB 128+12,0, 63,63,63,63,31,31,31,15
DEFB 192+12,1, 240,240,240,240,240,248,240,240
DEFB 128+13,0, 14,30,28,28,60,60,0,0
DEFB 192+13,1, 112,112,112,112,112,112,56,56

VF5F0
DEFB 6
DEFB 128+11,0, 0,0,0,1,3,3,15,15
DEFB 192+11,1, 0,0,0,128,128,128,224,224
DEFB 128+12,0, 31,31,31,15,15,15,7,14
DEFB 192+12,1, 224,224,224,240,240,240,112,112
DEFB 128+13,0, 14,14,30,12,0,0,0,0
DEFB 192+13,1, 96,96,112,112,48,0,0,0

VF6F0
DEFB 6
DEFB 128+11,0, 0,0,0,0,1,1,7,7
DEFB 192+11,1, 0,0,0,0,128,128,224,224
DEFB 128+12,0, 15,15,15,7,7,7,7,6
DEFB 192+12,1, 224,224,224,224,224,224,96,96
DEFB 128+13,0, 14,14,0,0,0,0,0,0
DEFB 192+13,1, 96,96,96,0,0,0,0,0


; : 1127 


;   

VL1F0
DEFB 76
DEFB 128+8,4, 0,0,0,0,0,0,7,7
DEFB 192+8,5, 0,0,0,0,0,224,252,254
DEFB 128+9,4, 7,7,15,15,15,15,12,12
DEFB 192+9,5, 254,255,255,255,255,255,113,243
DEFB 128+10,2, 0,0,0,0,0,0,3,7
DEFB 128+10,3, 0,0,0,0,26,122,255,55
DEFB 64+10,4, 15,15,7,15,255,251,255,63
DEFB 64+10,5, 255,255,255,223,255,251,254,253
DEFB 128+10,6, 0,0,0,128,255,255,255,255
DEFB 192+10,7, 0,0,0,0,252,252,252,248
DEFB 128+11,2, 15,15,15,7,7,15,15,15
DEFB 64+11,3, 127,127,254,255,255,255,255,255
DEFB 64+11,4, 255,255,255,255,255,255,255,255
DEFB 64+11,5, 255,255,254,255,255,255,255,255
DEFB 64+11,6, 255,255,255,255,255,255,255,255
DEFB 192+11,7, 240,240,240,120,248,248,252,252
DEFB 128+12,2, 31,31,63,127,255,255,255,255
DEFB 64+12,3, 255,255,255,249,241,243,225,193
DEFB 64+12,4, 255,247,247,255,247,255,255,255
DEFB 64+12,5, 255,255,255,255,255,255,255,255
DEFB 64+12,6, 255,255,251,251,251,241,241,240
DEFB 64+12,7, 254,255,255,255,255,255,255,255
DEFB 192+12,8, 0,0,0,0,128,128,128,128
DEFB 128+13,1, 1,1,3,3,3,15,31,63
DEFB 64+13,2, 255,255,254,254,254,248,248,252
DEFB 64+13,3, 129,1,1,1,0,0,0,0
DEFB 64+13,4, 255,255,255,255,255,255,255,255
DEFB 64+13,5, 255,255,255,255,255,255,255,255
DEFB 64+13,6, 240,224,224,224,224,224,224,224
DEFB 64+13,7, 255,255,127,63,31,31,15,15
DEFB 192+13,8, 128,128,224,224,240,240,248,248
DEFB 128+14,0, 0,1,0,1,1,3,3,3
DEFB 64+14,1, 127,253,255,255,239,255,255,255
DEFB 64+14,2, 254,252,254,254,248,248,240,224
DEFB 64+14,3, 0,0,1,7,7,15,31,31
DEFB 64+14,4, 255,255,255,255,255,255,255,255
DEFB 64+14,5, 255,255,255,255,255,255,255,255
DEFB 64+14,6, 224,224,224,248,248,252,252,254
DEFB 64+14,7, 7,7,3,1,0,0,0,0
DEFB 192+14,8, 248,252,252,252,126,62,63,63
DEFB 128+15,0, 7,15,15,31,31,30,60,60
DEFB 64+15,1, 255,143,135,7,7,15,15,31
DEFB 64+15,2, 224,192,192,192,193,131,3,3
DEFB 64+15,3, 31,63,127,127,255,255,255,255
DEFB 64+15,4, 255,255,255,255,255,254,248,248
DEFB 64+15,5, 255,255,254,255,63,31,15,7
DEFB 64+15,6, 254,255,255,255,255,255,255,255
DEFB 64+15,7, 0,0,0,128,192,224,224,224
DEFB 192+15,8, 31,30,14,6,0,0,0,0
DEFB 128+16,0, 56,0,0,0,0,0,0,0
DEFB 64+16,1, 30,30,60,124,120,120,48,0
DEFB 64+16,2, 3,15,15,15,31,30,63,127
DEFB 64+16,3, 255,255,127,255,255,255,254,254
DEFB 128+16,4, 240,224,224,192,128,0,0,0
DEFB 128+16,5, 7,1,1,0,0,0,0,0
DEFB 64+16,6, 255,255,255,255,63,63,63,31
DEFB 192+16,7, 240,240,248,248,252,252,252,252
DEFB 128+17,1, 0,0,0,0,1,1,1,1
DEFB 64+17,2, 255,255,255,255,255,255,255,255
DEFB 192+17,3, 252,248,248,240,240,224,224,192
DEFB 128+17,6, 31,15,15,7,7,3,3,3
DEFB 192+17,7, 252,254,254,254,254,255,255,255
DEFB 128+18,1, 1,1,1,1,1,3,7,7
DEFB 64+18,2, 255,255,255,255,255,254,254,254
DEFB 192+18,3, 192,0,0,0,0,0,0,0
DEFB 128+18,6, 3,3,1,1,1,1,0,0
DEFB 64+18,7, 255,255,255,255,255,255,255,127
DEFB 192+18,8, 0,128,128,128,128,128,128,128
DEFB 128+19,1, 7,7,7,15,29,25,125,127
DEFB 192+19,2, 252,252,252,252,254,254,252,252
DEFB 128+19,7, 255,255,127,127,127,127,127,127
DEFB 192+19,8, 128,128,192,224,224,240,248,252
DEFB 128+20,1, 255,255,255,127,0,0,0,0
DEFB 192+20,2, 252,240,224,224,0,0,0,0
DEFB 128+20,7, 63,31,15,7,3,1,0,0
DEFB 192+20,8, 252,252,254,254,254,254,0,0

VL2F0
DEFB 24
DEFB 128+10,2, 0,0,0,0,3,3,7,7
DEFB 192+10,3, 0,0,0,0,224,224,224,224
DEFB 128+11,1, 0,0,0,0,1,3,1,3
DEFB 64+11,2, 7,7,7,255,255,255,255,255
DEFB 64+11,3, 240,240,247,255,255,255,255,255
DEFB 192+11,4, 0,0,0,192,192,128,128,192
DEFB 128+12,1, 3,7,7,15,15,31,63,127
DEFB 64+12,2, 255,255,223,223,159,31,31,31
DEFB 64+12,3, 255,255,255,251,249,249,248,248
DEFB 192+12,4, 224,224,224,224,240,240,248,248
DEFB 128+13,0, 0,0,0,1,3,3,3,0
DEFB 64+13,1, 255,255,254,252,220,157,57,51
DEFB 64+13,2, 31,63,127,127,255,255,254,252
DEFB 64+13,3, 248,252,252,254,255,255,127,63
DEFB 192+13,4, 124,60,28,28,12,128,128,128
DEFB 128+14,1, 115,103,7,15,15,15,15,15
DEFB 64+14,2, 248,240,240,224,192,192,128,128
DEFB 64+14,3, 31,15,15,7,7,7,7,3
DEFB 192+14,4, 192,192,192,192,224,224,224,224
DEFB 128+15,1, 31,31,31,63,127,127,126,60
DEFB 128+15,2, 128,0,0,0,0,0,0,0
DEFB 128+15,3, 3,1,1,1,1,1,0,0
DEFB 192+15,4, 224,224,240,240,248,252,252,124
DEFB 128+16,4, 60,0,0,0,0,0,0,0

VL3F0
DEFB 12
DEFB 128+11,0, 0,0,0,0,0,1,1,1
DEFB 128+11,1, 14,15,31,31,31,255,255,255
DEFB 192+11,2, 0,0,0,0,224,240,240,240
DEFB 128+12,0, 3,3,7,7,15,31,31,62
DEFB 64+12,1, 255,255,255,191,63,63,127,127
DEFB 192+12,2, 240,248,248,248,188,156,142,206
DEFB 128+13,0, 54,111,13,15,3,7,7,7
DEFB 64+13,1, 255,251,241,224,224,192,128,128
DEFB 192+13,2, 230,224,240,240,240,240,120,120
DEFB 128+14,0, 7,15,31,31,30,0,0,0
DEFB 128+14,1, 128,0,0,0,0,0,0,0
DEFB 192+14,2, 120,120,60,60,30,0,0,0

VL4F0
DEFB 9
DEFB 128+11,0, 0,0,0,0,0,0,1,1
DEFB 128+11,1, 0,0,28,28,28,127,255,255
DEFB 192+11,2, 0,0,0,0,0,128,128,128
DEFB 128+12,0, 1,3,3,7,15,15,31,31
DEFB 64+12,1, 255,255,255,190,254,255,255,255
DEFB 192+12,2, 128,192,192,224,224,96,32,128
DEFB 128+13,0, 7,3,3,3,3,7,7,7
DEFB 128+13,1, 231,195,195,129,129,129,1,0
DEFB 192+13,2, 128,128,192,192,192,192,224,224

VL5F0
DEFB 8
DEFB 128+11,0, 0,0,0,0,0,0,0,1
DEFB 192+11,1, 0,0,0,16,56,56,254,254
DEFB 128+12,0, 1,1,3,7,15,15,7,3
DEFB 64+12,1, 255,255,251,255,253,254,238,207
DEFB 192+12,2, 0,0,128,128,128,128,0,0
DEFB 128+13,0, 3,3,3,7,7,0,0,0
DEFB 128+13,1, 135,135,131,131,3,0,0,0
DEFB 192+13,2, 0,0,0,128,128,0,0,0

VL6F0
DEFB 6
DEFB 128+11,0, 0,0,0,0,0,0,0,1
DEFB 192+11,1, 0,0,0,0,48,48,252,252
DEFB 128+12,0, 1,1,3,7,7,7,1,1
DEFB 192+12,1, 254,254,254,255,255,252,206,142
DEFB 128+13,0, 3,3,3,0,0,0,0,0
DEFB 192+13,1, 142,135,7,0,0,0,0,0

; : 1407 

