; 8bit addres	page write size
; 24C01		8
; 24C02		8
; 24C04		16
; 24C08		16
; 24C016	16
; 16bit addres
; 24C032	32
; 24C064	32
; 24C0128	64
; 24C0256	64
; 24C0512	128

.equ	VccIIC	= 6 ;PA6
.equ	SCL	= 4 ;PA4
.equ	SDA	= 3 ;PA3

.def	i2cdata	= r21
.def	i2cret	= r22
.equ	i2crd	= 1
.equ	i2cwr	= 0

POnIIC:
	sbi	DDRD,led
	sbi	PORTD,led
	ser	temp
	out	DDRA,temp
	sbi	PORTA,VccIIC
	ldz	Do_End
	ijmp
	
ReadBlockIICW:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	ldz	Tx_Dat
	ldi	loop,0x7F
	rcall	i2c_init	
	ldi	i2cdata,0xA0+i2cwr
	rcall	i2c_start_wait
	mov	i2cdata,addrH
	rcall	i2c_write
	mov	i2cdata,addrL
	rcall	i2c_write
	ldi	i2cdata,0xA0+i2crd
	rcall	i2c_rep_start
	rjmp	ReadBlock_loop

ReadBlockIICB:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	ldz	Tx_Dat
	ldi	loop,0x7F
	rcall	i2c_init	
	mov	i2cdata,addrH
	lsl     i2cdata
	ori	i2cdata,0xA0+i2cwr
	rcall	i2c_start_wait
	mov	i2cdata,addrL
	rcall	i2c_write
	ldi	i2cdata,0xA0+i2crd
	rcall	i2c_rep_start
ReadBlock_loop:
	rcall	i2c_readAck
	st	Z+,i2cdata
	adiw	r26,1
	dec	loop
	brne	ReadBlock_loop
	rcall	i2c_readNak
	st	Z+,i2cdata
	adiw	r26,1
	rcall	i2c_stop
	ldi	loop,0x80
	ldz	Do_End
	ijmp

WriteBlockIICW:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	rcall	i2c_init	
	ldi	loop2,4
WriteBlockW_loop0:
	ldi	i2cdata,0xA0+i2cwr
	rcall	i2c_start_wait
	mov	i2cdata,addrH
	rcall	i2c_write
	mov	i2cdata,addrL
	rcall	i2c_write
	ldi	loop,0x20
WriteBlockW_loop:
	ld	i2cdata,Y+
	rcall	i2c_write
	inc	addrL
	dec	loop
	brne	WriteBlockW_loop
	rcall	i2c_stop
	dec	loop2
	brne	WriteBlockW_loop0
	ldz	Do_End
	ijmp

WriteBlockIICB:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	rcall	i2c_init	

	ldi	loop2,0x10
WriteBlockB_loop0:
	mov	i2cdata,addrH
	lsl     i2cdata
	ori	i2cdata,0xA0+i2cwr
	rcall	i2c_start_wait
	mov	i2cdata,addrL
	rcall	i2c_write
	ldi	loop,0x08
WriteBlock_loop:
	ld	i2cdata,Y+
	rcall	i2c_write
	inc	addrL
	dec	loop
	brne	WriteBlock_loop
	rcall	i2c_stop
	dec	loop2
	brne	WriteBlockB_loop0
	ldz	Do_End
	ijmp

;*************************************************************************	
; Issues a start condition and sends address and transfer direction.
; addr = r24, return = r25(=0):r24
; return 0 = device accessible, 1= failed to access device
;*************************************************************************
i2c_start:
	cbi	PORTA,SDA
	sbi 	DDRA,SDA	;force SDA low
	rcall 	i2c_delay_T2	;delay T/2
	rcall 	i2c_write	;write address
	ret

;*************************************************************************
; Issues a repeated start condition and sends address and transfer direction.
; addr = r24,  return = r25(=0):r24
; return 0 = device accessible, 1= failed to access device
;*************************************************************************
i2c_rep_start:
	cbi	PORTA,SCL
	sbi	DDRA,SCL	;force SCL low
	rcall 	i2c_delay_T2	;delay  T/2
	sbi	PORTA,SDA
	cbi	DDRA,SDA	;release SDA
	rcall	i2c_delay_T2	;delay T/2
	sbi	PORTA,SCL
	cbi	DDRA,SCL	;release SCL
	rcall 	i2c_delay_T2	;delay  T/2
	cbi	PORTA,SDA
	sbi 	DDRA,SDA	;force SDA low
	rcall 	i2c_delay_T2	;delay	T/2
	rcall	i2c_write	;write address
	ret

;*************************************************************************	
; Issues a start condition and sends address and transfer direction.
; If device is busy, use ack polling to wait until device is ready
; addr = r24
;*************************************************************************
i2c_start_wait:
	mov	temp,i2cdata
i2c_start_wait1:
	cbi	PORTA,SDA
	sbi 	DDRA,SDA	;force SDA low
	rcall 	i2c_delay_T2	;delay T/2
	mov	i2cdata,temp
	rcall 	i2c_write	;write address
	tst	i2cdata		;if device not busy -> done
	breq	i2c_start_wait_done
	rcall	i2c_stop	;terminate write operation
	rjmp	i2c_start_wait1	;device busy, poll ack again
i2c_start_wait_done:
	ret

i2c_stop:
	cbi	PORTA,SCL
	sbi	DDRA,SCL	;force SCL low
	cbi	PORTA,SDA
	sbi	DDRA,SDA	;force SDA low
	rcall	i2c_delay_T2	;delay T/2
	sbi	PORTA,SCL
	cbi	DDRA,SCL	;release SCL
	rcall	i2c_delay_T2	;delay T/2
	sbi	PORTA,SDA
	cbi	DDRA,SDA	;release SDA
	rcall	i2c_delay_T2	;delay T/2
	ret

;*************************************************************************
; Send one byte to I2C device
; data = r24,  return = r25(=0):r24
; return 0 = write successful, 1 = write failed
;*************************************************************************
i2c_write:
	sec			;set carry flag
	rol 	i2cdata		;shift in carry and out bit one
	rjmp	i2c_write_first
i2c_write_bit:
	lsl	i2cdata		;if transmit register empty
i2c_write_first:
	breq	i2c_get_ack
	cbi	PORTA,SCL
	sbi	DDRA,SCL	;force SCL low
	brcc	i2c_write_low
	nop
	sbi	PORTA,SDA
	cbi	DDRA,SDA	;release SDA
	rjmp	i2c_write_high
i2c_write_low:
	cbi	PORTA,SDA
	sbi	DDRA,SDA	;force SDA low
	rjmp	i2c_write_high
i2c_write_high:
	rcall 	i2c_delay_T2	;delay T/2
	sbi	PORTA,SCL
	cbi	DDRA,SCL	;release SCL
	rcall	i2c_delay_T2	;delay T/2
	rjmp	i2c_write_bit
i2c_get_ack:
	cbi	PORTA,SCL
	sbi	DDRA,SCL	;force SCL low
	sbi	PORTA,SDA
	cbi	DDRA,SDA	;release SDA
	rcall	i2c_delay_T2	;delay T/2
	sbi	PORTA,SCL
	cbi	DDRA,SCL	;release SCL
i2c_ack_wait:
	sbis	PINA,SCL	;wait SCL high (in case wait states are inserted)
	rjmp	i2c_ack_wait
	clr	i2cdata		;return 0
	sbic	PINA,SDA	;if SDA high -> return 1
	ldi	i2cdata,1
	rcall	i2c_delay_T2	;delay T/2
	clr	i2cret
	ret

;*************************************************************************
; read one byte from the I2C device, send ack or nak to device
; (ack=1, send ack, request more data from device 
;  ack=0, send nak, read is followed by a stop condition)
;ack = r24, return = r25(=0):r24
;*************************************************************************
i2c_readNak:
	clr	i2cdata
	rjmp	i2c_read
i2c_readAck:
	ldi	i2cdata,0x01
i2c_read:
	ldi	temp,0x01	;data = 0x01
i2c_read_bit:
	cbi	PORTA,SCL
	sbi	DDRA,SCL	;force SCL low
	sbi	PORTA,SDA
	cbi	DDRA,SDA	;release SDA (from previous ACK)
	rcall	i2c_delay_T2	;delay T/2
	sbi	PORTA,SCL
	cbi	DDRA,SCL	;release SCL
	rcall	i2c_delay_T2	;delay T/2
i2c_read_stretch:
	sbis	PINA,SCL        ;loop until SCL is high (allow slave to stretch SCL)
	rjmp	i2c_read_stretch
	clc			;clear carry flag
	sbic	PINA,SDA	;if SDA is high
	sec			;  set carry flag
	rol	temp		;store bit
	brcc	i2c_read_bit	;while receive register not full
i2c_put_ack:
	cbi	PORTA,SCL
	sbi	DDRA,SCL	;force SCL low	
	cpi	i2cdata,1
	breq	i2c_put_ack_low	;if (ack=0)
	cbi	PORTA,SDA
	cbi	DDRA,SDA	;      release SDA
	rjmp	i2c_put_ack_high
i2c_put_ack_low:                ;else
	cbi	PORTA,SDA
	sbi	DDRA,SDA	;      force SDA low
i2c_put_ack_high:
	rcall	i2c_delay_T2	;delay T/2
	sbi	PORTA,SCL
	cbi	DDRA,SCL	;release SCL
i2c_put_ack_wait:
	sbis	PINA,SCL	;wait SCL high
	rjmp	i2c_put_ack_wait
	rcall	i2c_delay_T2	;delay T/2
	mov	i2cdata,temp
	clr	i2cret
	ret

i2c_init:
	cbi DDRA,SDA		;release SDA
	cbi DDRA,SCL		;release SCL
	sbi PORTA,SDA
	sbi PORTA,SCL
	ret

;*************************************************************************
; delay half period
; For I2C in normal mode (100kHz), use T/2 > 5us
; For I2C in fast mode (400kHz),   use T/2 > 1.3us
;*************************************************************************
i2c_delay_T2:
	rjmp i2c_delay_T21
i2c_delay_T21:
	rjmp i2c_delay_T22
i2c_delay_T22:
	rjmp i2c_delay_T23
i2c_delay_T23:
	rjmp i2c_delay_T24
i2c_delay_T24:
	rjmp i2c_delay_T25
i2c_delay_T25:
 	rjmp i2c_delay_T26
i2c_delay_T26:
	nop
	ret
