;[BEGIN]
;
; CMOS.EXE 
;
; Default control CMOS register values
; reg 0A = #26
; reg 0B = #02
; reg 0C = #50
; reg 0D = #80
;
	ORG	#8100-512
	INCLUDE	"dos_equ.asm"
	DB	"EXE"	;EXE ID
	DB	#00	;EXE VERSION
	DW	#0200	;CODE OFFSET LOW
	DW	#0000	;CODE OFFSET HIGH
	DW	#0000	;END-BEG ;PRIMARY LOADER
	DW	#0000	;
	DW	#0000	;RESERVED
	DW	#0000	;
	DW	#8100	;LOAD ADDRESS
	DW	#8100	;START ADDRESS
	DW	#BFFF	;STACK ADDRESS
	DS	490

START	PUSH	IX
;	CALL	CRLF
;	CALL	CRLF
	LD	HL,HELLO
	CALL	PRINTZ
	LD	C,#F5
	RST	#08
	JR	NC,CMOS_PRESENT
	LD	HL,WARNMSG
	CALL	PRINTZ
CMOS_PRESENT
	POP	HL
	INC	HL
	INC	HL

	LD	DE,CMDBUF
	LD	C,#43
	RST	#10
	LD	A,(CMDBUF)
	OR	A
	JR	Z,USAGE
	CP	"-"
	JR	NZ,USAGE
	CP	#20
	JR	C,USAGE
	LD	A,(CMDBUF+1)
	LD	HL,HELP
	CP	"h"
	JR	Z,QUIT
	CP	"H"
	JR	Z,QUIT
	CP	"?"
	JR	Z,QUIT
	LD	HL,CMD_TABLE
	LD	DE,CMDBUF+1
	CALL	COMPARE
	JP	Z,C_INIT
	CALL	COMPARE
	JP	Z,C_DUMP
	CALL	COMPARE
	JP	Z,C_SETR
	LD	HL,UNKKEYM
QUIT	CALL	PRINTZ
	LD	C,EXIT
	RST	#10
	RET

USAGE	LD	HL,MUSAGE
	JP	QUIT

C_INIT
	LD	HL,INITMSG
	CALL	PRINTZ
	LD	D,10
	LD	A,#26	;FREQ
	LD	C,#F7
	RST	#08
	LD	D,11
	LD	A,#02	;TIME FORMAT
	LD	C,#F7
	RST	#08
	LD	D,12
	LD	A,#50
	LD	C,#F7
	RST	#08
	LD	D,13
	LD	A,#80
	LD	C,#F7
	RST	#08
	LD	HL,ELINE
	JP	QUIT

C_DUMP	
	CALL	CMOSDUMP
	LD	HL,ELINE
	JP	QUIT

C_SETR	LD	HL,4
	ADD	HL,DE
	CALL	GETVALUE
	LD	(REGISTER),A
	LD	A,(HL)
	INC	HL
	CP	"="
	JR	NZ,ERR_SETR
	CALL	GETVALUE
	LD	E,A
	LD	A,(REGISTER)
	LD	D,A
	LD	A,E
	PUSH	AF
	LD	C,#F7
	RST	#08
	LD	HL,SETREGM
	CALL	PRINTZ
	LD	A,"#"
	CALL	PRINT_
	LD	A,(REGISTER)
	CALL	PHEX
	LD	A,"="
	CALL	PRINT_
	POP	AF
	CALL	PHEX
	LD	A,"."
	CALL	PRINT_
	LD	HL,ELINE
	JP	QUIT

ERR_SETR
	LD	HL,ERRSETM
	JP	QUIT

GETVALUE
	LD	A,(HL)
	INC	HL
	CP	"#"
	JR	Z,GETVALUE
	SUB	#30
	RES	5,A
	CP	10
	JR	C,GETV0
	SUB	7
GETV0
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,A
	AND	#F0
	LD	C,A
	LD	A,(HL)
	INC	HL
	SUB	#30
	RES	5,A
	CP	10
	JR	C,GETV1
	SUB	7
GETV1	OR	C
	RET


COMPARE	PUSH	DE
	LD	B,4
COMP1	LD	A,(DE)
	RES	5,A
	CP	(HL)
	JR	NZ,NEXTK
	INC	DE
	INC	HL
	DJNZ	COMP1	
	POP	DE
	RET

NEXTK	INC	HL
	DJNZ	NEXTK
	POP	DE
	RET

CMD_TABLE
	DB	"INIT"
	DB	"DUMP"
	DB	"REG",#03

REGISTER
	DB	0

CRLF	LD	A,#0D
	LD      C,PUTCHAR
	RST     #10
	LD      A,#0A
PRINT_	
PRNCHAR	LD      C,PUTCHAR
	RST     #10
	RET

PRINTZ	LD	C,PCHARS
	RST	#10
	RET

ELINE	DB	13,10,0

HELP	DB	13,10
	DB	"Usage: CMOS.EXE [-command]",13,10
	DB	"   -H -?	This page",13,10
	DB	"   -DUMP	Print registers dump",13,10
	DB	"   -REG#xx=#yy	Set value #YY to CMOS register #XX",13,10 
	DB	"   -INIT	Initialization control registers",13,10,13,10,0

WARNMSG	DB	"WARNING! CMOS not found.",13,10,13,10,0

INITMSG	DB	13,10,"  CMOS control registers has been reinitialization.",13,10,0

SETREGM	DB	13,10,"  Set register ",0

ERRSETM	DB	13,10,"  Incorrect value.",13,10,0

UNKKEYM	DB	13,10,"  Unknown command.",13,10,0

HELLO	DB	13,10,"CMOS Utility version 1.00 (c) PETERS PLUS LTD.",13,10,0
MUSAGE	DB	"type CMOS.EXE -? for help.",13,10,0

UPDUMP	DB	13,10
	DB	"    00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F ",13,10
	DB	"    ----------------------------------------------- ",0

CMOSDUMP
	LD	HL,UPDUMP
	CALL	PRINTZ

	LD	BC,#0400
L1	PUSH	BC
	PUSH	BC
	LD	L,C
	CALL	CRLF
	LD	A,L
	CALL	PHEX
	LD	A,":"
	CALL	PRNCHAR
	LD	A," "
	CALL	PRNCHAR
	POP	BC
	LD	B,#10
L2	PUSH	BC
	LD	D,C
	LD	C,#F6
	RST	#08
	CALL	PHEX
	LD	A," "
	CALL	PRNCHAR
	POP	BC
	INC	C
	DJNZ	L2
	LD	A,C
	POP	BC
	LD	C,A
	DJNZ	L1
	CALL	CRLF
	RET


PHEX    LD      E,A
        RRCA
        RRCA
        RRCA
        RRCA
        AND     #0F
        ADD     A,#30
        CP      #3A
        JR      C,PHEX2
        ADD     A,7
PHEX2   CALL    PRINT_
        LD      A,E
        AND     #0F
        ADD     A,#30
        CP      #3A
        JR      C,PHEX3
        ADD     A,7
PHEX3   CALL    PRINT_
        RET

CMDBUF	DB	0
