function [field,success] = place_all_ships(all_ships)
% Place all ships randomly, fail if at any stage a ship could not be
% placed by a random position and orientation
field = zeros(10,10);

success = false;
for shtype = 1:size(all_ships,1)
    shlen = all_ships(shtype,2);
    for shn = 1:all_ships(shtype,1)
        hrz = rand*2<1;
        if hrz
            x = 1+floor(rand*(11-shlen));
            y = 1+floor(rand*10);
        else
            x = 1+floor(rand*10);
            y = 1+floor(rand*(11-shlen));
        end
        shrect = shiprect(x,y,shlen,hrz);
        if any(any(field(shrect.top:shrect.bottom,shrect.left:shrect.right)))
            % Failure
            return;
        end
        shbody = shipbody(x,y,shlen,hrz);
        field(shbody.top:shbody.bottom,shbody.left:shbody.right) = 1;
    end
end
success = true;
