#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define XSIZE 10
#define YSIZE 10

typedef unsigned char BOOL;
#define TRUE 1
#define FALSE 0

typedef unsigned char SEASQUARE;

typedef struct tagSRECT
{
    int left;
    int top;
    int right;
    int bottom;
} SRECT;

typedef struct tagSHIP
{
    int x;
    int y;
    BOOL hrz;
} SHIP;

void shiprect(SRECT* sr, int x, int y, int len, BOOL horizontal)
{
    if(x>0)
        sr->left = x-1;
    else
        sr->left = x;

    if(y>0)
        sr->top = y-1;
    else
        sr->top = y;

    if(horizontal)
    {
        if(x+len < XSIZE)
            sr->right = x+len;
        else
            sr->right = XSIZE-1;

        if(y < YSIZE-1)
            sr->bottom = y+1;
        else
            sr->bottom = YSIZE-1;
    }
    else
    {
        if(x < XSIZE-1)
            sr->right = x+1;
        else
            sr->right = XSIZE-1;

        if(y+len < YSIZE)
            sr->bottom = y+len;
        else
            sr->bottom = YSIZE-1;
    }
}

void shipbody(SRECT* sb, int x, int y, int len, BOOL horizontal)
{
    sb->left = x;
    sb->top = y;
    if(horizontal)
    {
        sb->right = x+len-1;
        sb->bottom = y;
    }
    else
    {
        sb->right = x;
        sb->bottom = y+len-1;
    }
}


void display_field(SEASQUARE field[YSIZE][XSIZE])
{
    int i,j;
    for(i=0; i<YSIZE; i++)
    {
        for(j=0; j<XSIZE; j++)
        {
            printf("%3d",(int)field[i][j]);
        }
        putc('\n',stdout);
    }
}

BOOL place_all_ships(SEASQUARE field[YSIZE][XSIZE], SHIP ships[], int shiplens[], int n_ships)
{
    int sh;
    int shlen;
    BOOL hrz;
    int x;
    int y;
    int i;
    int j;
    SRECT shrect;
    SRECT sbody;

    memset(field,0,YSIZE*XSIZE);
    for(sh=0; sh<n_ships; sh++)
    {
        shlen = shiplens[sh];
        hrz = 2*rand()/(RAND_MAX+1);
        if(hrz)
        {
            x = rand()*(XSIZE+1-shlen)/(RAND_MAX+1);
            y = rand()*YSIZE/(RAND_MAX+1);
        }
        else
        {
            x = rand()*XSIZE/(RAND_MAX+1);
            y = rand()*(YSIZE+1-shlen)/(RAND_MAX+1);
        }
        shiprect(&shrect,x,y,shlen,hrz);
        for(i=shrect.top; i<=shrect.bottom; i++)
        {
            for(j=shrect.left; j<=shrect.right; j++)
            {
                if(field[i][j])
                {
                    return FALSE;
                }
            }
        }
        ships[sh].x = x;
        ships[sh].y = y;
        ships[sh].hrz = hrz;
        shipbody(&sbody,x,y,shlen,hrz);
        for(i=sbody.top; i<=sbody.bottom; i++)
        {
            for(j=sbody.left; j<=sbody.right; j++)
            {
                field[i][j] = 1;
            }
        }
    }
    return TRUE;
}


int main(int argc, char* argv[])
{
    SEASQUARE field[YSIZE][XSIZE];
    int shiplens[] = {4,3,3,2,2,2,1,1,1,1};
    SHIP ships[10];
    int n;
    int m;
    int sh;
    FILE* ft;

    srand((unsigned)time(NULL));

    ft = fopen("C:\\0\\ships.txt","w");
    m = 0;
    for(n=0; n<300000000; n++)
    {
        if(place_all_ships(field,ships,shiplens,sizeof(shiplens)/sizeof(int)))
        {
            m++;
            for(sh=0; sh<sizeof(shiplens)/sizeof(int); sh++)
            {
                fprintf(ft,"%d %d %d ",ships[sh].x,ships[sh].y,ships[sh].hrz);
            }
            putc('\n',ft);

            if(m%100 == 0)
            {
                printf("%d\n",m);
            }
        }
    }
    printf("N=%d M=%d ratio=%f\n",n,m,1.0*n/m);
    fclose(ft);
    return 0;
}
