#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>

#define XSIZE 10
#define YSIZE 10

typedef unsigned char BOOL;
#define TRUE 1
#define FALSE 0

typedef unsigned char SEASQUARE;

typedef struct tagSRECT
{
    int left;
    int top;
    int right;
    int bottom;
} SRECT;

typedef struct tagSHIP
{
    int x;
    int y;
    BOOL hrz;
} SHIP;


// Random number generator from Numerical Recepies, long period
#define IM1 2147483563
#define IM2 2147483399
#define AM (1.0/IM1)
#define IMM1 (IM1-1)
#define IA1 40014
#define IA2 40692
#define IQ1 53668
#define IQ2 52774
#define IR1 12211
#define IR2 3791
#define NTAB 32
#define NDIV (1+IMM1/NTAB)
#define RNMX (1.0-FLT_EPSILON)

float rand2(int seed)
{
    int j;
    int k;
    static int idum=0;
    static int idum2=0;
    static int iy=0;
    static int iv[NTAB];
    float temp;

    if(seed)
    {
        idum = seed;
        idum2 = seed;
        for(j=NTAB+7; j>=0; j--)
        {
            // Load the shuffle table (after 8 warm-ups)
            k=idum/IQ1;
            idum = IA1*(idum-k*IQ1)-k*IR1;
            if(idum<0)
                idum += IM1;
            if(j<NTAB)
                iv[j] = idum;
        }
        iy=iv[0];
    }

    k = idum/IQ1;
    idum = IA1*(idum-k*IQ1)-k*IR1;  // compute idum = (IA1*idum)%IM1 without overflows by Schrage's method
    if(idum<0)
        idum += IM1;
    k = idum2/IQ2;
    idum2 = IA2*(idum2-k*IQ2)-k*IR2;
    if(idum2<0)
        idum2 += IM2;

    j = iy/NDIV;        // will be in the range 0..NTAB-1
    iy = iv[j]-idum2;   // Here idum is shuffled, idum and idum2 are combined
    iv[j] = idum;
    if(iy<1)
        iy += IMM1;
    temp = (float)(AM*iy);
    if(temp>RNMX)
        return RNMX;
    else
        return temp;
}


void shiprect(SRECT* sr, int x, int y, int len, BOOL horizontal)
{
    if(x>0)
        sr->left = x-1;
    else
        sr->left = x;

    if(y>0)
        sr->top = y-1;
    else
        sr->top = y;

    if(horizontal)
    {
        if(x+len < XSIZE)
            sr->right = x+len;
        else
            sr->right = XSIZE-1;

        if(y < YSIZE-1)
            sr->bottom = y+1;
        else
            sr->bottom = YSIZE-1;
    }
    else
    {
        if(x < XSIZE-1)
            sr->right = x+1;
        else
            sr->right = XSIZE-1;

        if(y+len < YSIZE)
            sr->bottom = y+len;
        else
            sr->bottom = YSIZE-1;
    }
}

void shipbody(SRECT* sb, int x, int y, int len, BOOL horizontal)
{
    sb->left = x;
    sb->top = y;
    if(horizontal)
    {
        sb->right = x+len-1;
        sb->bottom = y;
    }
    else
    {
        sb->right = x;
        sb->bottom = y+len-1;
    }
}


void display_field(SEASQUARE field[YSIZE][XSIZE])
{
    int i,j;
    for(i=0; i<YSIZE; i++)
    {
        for(j=0; j<XSIZE; j++)
        {
            printf("%3d",(int)field[i][j]);
        }
        putc('\n',stdout);
    }
}

BOOL place_all_ships(SEASQUARE field[YSIZE][XSIZE], SHIP ships[], int shiplens[], int n_ships)
{
    int sh;
    int shlen;
    BOOL hrz;
    int x;
    int y;
    int i;
    int j;
    SRECT shrect;
    SRECT sbody;

    memset(field,0,YSIZE*XSIZE);
    for(sh=0; sh<n_ships; sh++)
    {
        shlen = shiplens[sh];
        hrz = (int)(2*rand2(0));
        if(hrz)
        {
            x = (int)(rand2(0)*(XSIZE+1-shlen));
            y = (int)(rand2(0)*YSIZE);
        }
        else
        {
            x = (int)(rand2(0)*XSIZE);
            y = (int)(rand2(0)*(YSIZE+1-shlen));
        }
        shiprect(&shrect,x,y,shlen,hrz);
        for(i=shrect.top; i<=shrect.bottom; i++)
        {
            for(j=shrect.left; j<=shrect.right; j++)
            {
                if(field[i][j])
                {
                    return FALSE;
                }
            }
        }
        ships[sh].x = x;
        ships[sh].y = y;
        ships[sh].hrz = hrz;
        shipbody(&sbody,x,y,shlen,hrz);
        for(i=sbody.top; i<=sbody.bottom; i++)
        {
            for(j=sbody.left; j<=sbody.right; j++)
            {
                field[i][j] = 1;
            }
        }
    }
    return TRUE;
}


int main(int argc, char* argv[])
{
    SEASQUARE field[YSIZE][XSIZE];
    int shiplens[] = {4,3,3,2,2,2,1,1,1,1};
    SHIP ships[10];
    int n;
    int m;
    int sh;
    FILE* ft;
    char ofname[256];
    int file_number;

    rand2((int)(time(NULL)&0x7FFFFFFF));

    file_number = 20;

    while(1)
    {
        sprintf(ofname,"C:\\0\\ships%03d.txt",file_number);
        ft = fopen(ofname,"w");
        m = 0;
        for(n=0; n<300000000; n++)
        {
            if(place_all_ships(field,ships,shiplens,sizeof(shiplens)/sizeof(int)))
            {
                m++;
                for(sh=0; sh<sizeof(shiplens)/sizeof(int); sh++)
                {
                    fprintf(ft,"%d %d %d ",ships[sh].x,ships[sh].y,ships[sh].hrz);
                }
                putc('\n',ft);

                if(m%100 == 0)
                {
                    printf("%d\n",m);
                }
            }
        }
        printf("N=%d M=%d ratio=%f\n",n,m,1.0*n/m);
        fclose(ft);
        file_number++;
    }
    return 0;
}
