unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,
  EthThrd;


type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    LBLguid: TLabel;
    CBConnection: TComboBox;
    MemDump: TMemo;
    btnGetPackets: TButton;
    edtFName: TEdit;
    Label3: TLabel;
    lblReaded: TLabel;
    Label4: TLabel;
    lblMAC: TLabel;
    Label5: TLabel;
    edtIPAddr: TEdit;
    Label6: TLabel;
    edtIPMask: TEdit;
    Timer1: TTimer;
    procedure CBConnectionChange(Sender: TObject);
    procedure btnGetPacketsClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    procedure ShowDump(const Buffer: TFrame);
  public
    IniName: string;
  end;

var
  Form1: TForm1;
  List: TThreadList;
  GUIDList: TStringList;
  Paused: boolean;
  IPMask: DWORD;

implementation

{$R *.DFM}

const
  ARP_CACHE_TIME_TO_LIVE = 100;
  stEthernet='Ethernet';
  stMAC='MAC';
  st55='!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';

type
  TArpEntry = packed record
    ipaddr: DWORD;            ///< remote-note IP address
    ethaddr: TMacAddr;        ///< remote-node ethernet (hardware/mac) address
    time: BYTE;               ///< time to live (in ARP table); this is decremented by arpTimer()
  end;
  PArpEntry = ^TArpEntry;

var
  ARPTable: TList;
  ArpMyAddr: TArpEntry;      ///< my local interface information (IP and MAC address)
  iii: integer;

function LeftSubstrList(var s:String; DelimList: string): String;
var ch:char;
    j:integer;
begin
  Result:='';
  if Length(s)<1 then exit;
  j:=0;
  if (s[1]=' ')then s:=TrimLeft(s);
  if (s[1]='"')or(s[1]='''') then
  begin
    inc(j);
    ch:=s[1];
    while (j<Length(s))and(s[j+1]<>ch) do inc(j);
      if (Length(s)>1)and(j>1) then Result:=copy(s, 2, j-1);
    if (j<Length(s))and(s[j+1]=ch) then inc(j);
  end
  else
  begin
    while (j<Length(s))and(pos(s[j+1], DelimList)=0)and(s[j+1]<>#9) do inc(j);
    Result:=copy(s, 1, j);
  end;
  while (j<Length(s))and((pos(s[j+1], DelimList)>0)or(s[j+1]=#9)) do inc(j);
  delete(s,1,j);
end;

{}

function arpMatchIp(ipaddr: DWORD):integer;
var i: integer;
begin
    // check if IP address is present in arp table       Tlist
  for i:=0 to ARPTable.Count-1 do
    if ( PArpEntry(ArpTable[i])^.ipaddr = ipaddr) then
    begin         // IP address found
      result:=i;
      exit;
    end;
  // no match
  result:=-1;
end;

procedure arpIpIn(var Buffer: TFrame);
var index: integer;
    ArpEntry: PArpEntry;
begin
  with PNetEthIpHeader(pointer(@Buffer[0]))^ do
  begin

    // check if sender is already present in arp table
    index := arpMatchIp(HTONL(ip.srcipaddr));
    if (index <> -1) then
    begin
        // sender's IP address found, update ARP entry
        PArpEntry(ArpTable[index])^.ethaddr := eth.src;
        // and we're done
        exit;
    end;

    // sender was not present in table,
    // must add in empty/expired slot
    for index:=0 to ARPTable.Count-1  do
      if (PArpEntry(ArpTable[index])^.time=0) then
      begin
        PArpEntry(ArpTable[index])^.ipaddr := HTONL(ip.srcipaddr);    // write entry
        PArpEntry(ArpTable[index])^.ethaddr := eth.src;
        PArpEntry(ArpTable[index])^.time := ARP_CACHE_TIME_TO_LIVE;
        exit;    // and we're done
      end;
    new(ArpEntry);
    ArpEntry^.ipaddr := HTONL(ip.srcipaddr);
    ArpEntry^.ethaddr := eth.src;
    ArpEntry^.time := ARP_CACHE_TIME_TO_LIVE;
    ArpTable.Add(ArpEntry);
  end;
end;

procedure arpIpOut(var Buffer: TFrame; phyDstIp: DWORD);
var index: integer;
begin
  with PNetEthIpHeader(pointer(@Buffer[0]))^ do
  begin
    // check if destination is already present in arp table
    // use the physical dstIp if it's provided, otherwise the dstIp in packet
    if (phyDstIp<>0) then
        index := arpMatchIp(phyDstIp)
    else
        index := arpMatchIp(HTONL(ip.destipaddr));
    // fill in ethernet info
    if (index <> -1) then
    begin
        // ARP entry present, fill eth address(es)
        eth.src   := ArpMyAddr.ethaddr;
        eth.dest  := PArpEntry(ArpTable[index])^.ethaddr;
        eth.proto := HTONS(ETHTYPE_IP);
    end
    else
    begin
        // not in table, must send ARP request
        eth.src := ArpMyAddr.ethaddr;
        // MUST CHANGE, but for now, send this one broadcast
        eth.dest[0] := #$FF;
        eth.dest[1] := #$FF;
        eth.dest[2] := #$FF;
        eth.dest[3] := #$FF;
        eth.dest[4] := #$FF;
        eth.dest[5] := #$FF;
        eth.proto := HTONS(ETHTYPE_IP);
    end;
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var index: integer;
begin
    // this function meant to be called on a regular time interval
    // decrement time-to-live for all entries
  for index:=0 to ARPTable.Count-1 do
    if PArpEntry(ArpTable[index])^.time<>0 then
      PArpEntry(ArpTable[index])^.time:=PArpEntry(ArpTable[index])^.time-1;
end;

procedure icmpEchoRequest(var Buffer: TFrame); //packet: PICMPip_hdr);
var tempIp: DWORD;
begin
  with PICMPip_hdr(@(PNetEthIpHeader(@Buffer[0])^.ip))^ do
  begin
    // change type to reply
    icmp.itype := ICMP_TYPE_ECHOREPLY;
    // recalculate checksum
    icmp.icmpchksum := 0;
    icmp.icmpchksum := netChecksum(pointer(@icmp), htons(ip.len)-IP_HEADER_LEN);
    // return to sender
    tempIp := ip.destipaddr;
    ip.destipaddr := ip.srcipaddr;
    ip.srcipaddr := tempIp;
    // add ethernet routing
    arpIpOut(Buffer, 0);

    // send it (packet->ip.len+ETH_HEADER_LEN
    EthThread.PutPacket((@Buffer[0])^, htons(ip.len)+ETH_HEADER_LEN);
  end;
end;

procedure icmpIpIn(var Buffer: TFrame); // packet: PICMPip_hdr)
begin
  with PICMPip_hdr(@(PNetEthIpHeader(@Buffer[0])^.ip))^ do
  begin
    // check ICMP type
    case icmp.itype of
      ICMP_TYPE_ECHOREQUEST:
        // echo request
        icmpEchoRequest(Buffer)
      else
        ;
    end;
  end;
end;

procedure UDPIPProcess(var Buffer: TFrame);
begin
end;

procedure TCPIPProcess(var Buffer: TFrame);
begin
end;

procedure ProcessIP(var Buffer: TFrame);
var destip: DWORD;
begin
// check IP addressing, stop processing if not for me and not a broadcast
  with PNetIpHeader(@(PNetEthIpHeader(@Buffer[0])^.ip))^ do
  begin
    destip:=htonl(destipaddr);
//    ShowMessage(Format('%x %x %x', [destip, ArpMyAddr.ipaddr, (ArpMyAddr.ipaddr and {or} IPMask)]));
    if ((destip = ArpMyAddr.ipaddr) or                          // my IP
        (destip = (ArpMyAddr.ipaddr or (not IPMask))) or        // broadcast IP
        
        (destip = $FFFFFFFF) ) then
      case proto of
        IP_PROTO_ICMP: icmpIpIn(Buffer);                        // handle ICMP packet
        IP_PROTO_UDP: UDPIPProcess(Buffer);
        IP_PROTO_TCP: TCPIPProcess(Buffer)
        else
          ;
      end;
  end;
end;

procedure ProcessPacket(var Buffer: TFrame);                    //  Ethernet-  (46-1500  + 4  CRC32)
var proto, len: WORD;
begin
  if Assigned(EthThread) then
  with PEthArpHeader(@Buffer[0])^ do begin
    len:=EthThread.FrameLen(Buffer);
    case htons(eth.proto) of
      ETH_P_IP:
        begin
          arpIpIn(Buffer);
          ProcessIP(Buffer);
        end;
      ETH_P_ARP:
        if (arp.dipaddr = htonl(ArpMyAddr.ipaddr)) and
           (arp.opcode = htons(ARP_OPCODE_REQUEST)) then
        begin
          // in ARP header
          // copy sender's address info to dest. fields
          arp.dhwaddr := arp.shwaddr;
          arp.dipaddr := arp.sipaddr;
          // fill in our information
          CopyMemory(@arp.shwaddr[0], EthThread.MACAddr, sizeof(arp.shwaddr));
          arp.sipaddr := htonl(ArpMyAddr.ipaddr);
          // change op to reply
          arp.opcode := htons(ARP_OPCODE_REPLY);

          // in ethernet header
          eth.dest := eth.src;
          CopyMemory(@eth.src[0], EthThread.MACAddr, sizeof(eth.src));

          EthThread.PutPacket((@Buffer[0])^, EthThread.FrameLen(Buffer));
        end
      else ; // raise Exception.CreateFmt('Unsupported Ethernet frame type: %d', [proto]);
    end; {case}
  end;
end;

procedure TForm1.btnGetPacketsClick(Sender: TObject);
var Buffer: TFrame;
    PrevInp: integer;
    PrevOut: integer;
    PrevDis: integer;
    st: string;
    ii: integer;
//    fs: TFileStream;
    buf: array [0..MAX_PATH] of char;
begin
//  fs:=nil;
  if CBConnection.ItemIndex=-1 then raise Exception.Create('Select corresponding TAP-connection (aka adapter) in connection list');
  btnGetPackets.Enabled:=False;
  PrevInp:=0;  PrevOut:=0;  PrevDis:=0;
  Paused:=false;
//  if not FileExists(trim(edtFName.Text)) then
//  begin
//    fs:=TFileStream.Create(trim(edtFName.Text), fmCreate);
//    fs.Free;
//  end;
//  fs:=TFileStream.Create(trim(edtFName.Text), fmOpenReadWrite or fmShareDenyNone);
  CreateEthThread;
  for ii:=0 to 5 do
    PDWORD(@buf[ii])^:=GetPrivateProfileInt(stEthernet, PChar(stMAC+IntToStr(ii)), $FF, PChar(IniName));
  if (buf[0]<>#$FF) then
    EthThread.MACAddr:=buf;
  EthThread.TAPguid:=GUIDList.Strings[CBConnection.ItemIndex];
  EthThread.BufSize:=16384;
  lblMAC.Caption:=IntToHex(ord(EthThread.MACAddr[0]),2)+'-'+
                  IntToHex(ord(EthThread.MACAddr[1]),2)+'-'+
                  IntToHex(ord(EthThread.MACAddr[2]),2)+'-'+
                  IntToHex(ord(EthThread.MACAddr[3]),2)+'-'+
                  IntToHex(ord(EthThread.MACAddr[4]),2)+'-'+
                  IntToHex(ord(EthThread.MACAddr[5]),2);
  st:=trim(edtIPAddr.Text);
  ArpMyAddr.ipaddr:=(StrToInt(LeftSubstrList(st, '.,')) and $FF) shl 24 +
                    (StrToInt(LeftSubstrList(st, '.,')) and $FF) shl 16 +
                    (StrToInt(LeftSubstrList(st, '.,')) and $FF) shl 8 +
                    (StrToInt(LeftSubstrList(st, '.,')) and $FF);
  CopyMemory(@ArpMyAddr.ethaddr[0], EthThread.MACAddr, sizeof(TMacAddr));
  st:=trim(edtIPMask.Text);
  IPMask:=(StrToInt(LeftSubstrList(st, '.,')) and $FF) shl 24 +
          (StrToInt(LeftSubstrList(st, '.,')) and $FF) shl 16 +
          (StrToInt(LeftSubstrList(st, '.,')) and $FF) shl 8 +
          (StrToInt(LeftSubstrList(st, '.,')) and $FF);
  StartEthThread;
  repeat
    Application.ProcessMessages;
    if EthThread.GetPacket(Buffer) then begin
//      fs.Write(Buffer, EthThread.FrameLen(Buffer));
//      fs.Write(st55, 32);
      ShowDump(Buffer);
      ProcessPacket(Buffer);
      if ((EthThread.InpFrames)>PrevInp) or ((EthThread.OutFrames)>PrevOut) or ((EthThread.DisFrames)>PrevDis) then
      begin
        PrevInp:=EthThread.InpFrames;
        PrevOut:=EthThread.OutFrames;
        PrevDis:=EthThread.DisFrames;
        lblReaded.Caption:=Format('I:%d, O:%d, D:%d', [PrevInp, PrevOut, PrevDis]);
        Form1.Update;
      end;
    end;
    sleep(1);
    Application.ProcessMessages;
  until False;
  StopEthThread;
  DestroyEthThread;
//  if Assigned(fs) then fs.Free;
end;

procedure TForm1.CBConnectionChange(Sender: TObject);
begin
  LBLguid.Caption:=GUIDList.Strings[CBConnection.ItemIndex];
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var ii:integer;
begin
  if Assigned(EthThread) then
    for ii:=0 to 5 do
      WritePrivateProfileString(stEthernet, PChar(stMAC+IntToStr(ii)), PChar(IntToStr(BYTE(EthThread.MACAddr[ii]))), PChar(IniName));
  StopEthThread;
  DestroyEthThread;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Paused:=true;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  OnActivate:=nil;
  IniName:=ChangeFileExt(System.ParamStr(0),'.INI');
  GetConnectionInfo(CBConnection.Items, GUIDList);
end;

function padl(stt:string;max:integer;ch:string):string;
begin
  if length(stt)>=max then padl:=copy(stt,1,max)
  else
  begin
    while length(stt)+length(ch)<=max do stt:=ch+stt;
    if length(stt)<max then stt:=copy(ch,1,max-length(stt))+stt;
    padl:=stt;
  end;
end;

procedure TForm1.ShowDump(const Buffer: TFrame);
var Addr, len, i, j, dd: integer;
    st, stt: string;
begin
  Addr:=0;
  len:=EthThread.FrameLen(Buffer);
  MemDump.Lines.BeginUpdate;
  MemDump.Clear;
  st:='0:0000  00000000 00000000 00000000 00000000  0000000000000000  ';
  j:=0;
  while (j<16) and (Addr<len) do
  begin
    stt:=padl(IntToHex(Addr, 4), 4, '0');
    st[3]:=stt[1]; st[4]:=stt[2]; st[5]:=stt[3]; st[6]:=stt[4];
    for i:=0 to 15 do
    begin
      stt:=padl(IntToHex(Buffer[Addr], 2), 2, '0');
      case i of
        0..3:  dd:=9;
        4..7:  dd:=10;
        8..11: dd:=11
        else   dd:=12;
      end;
      st[i*2+dd]:=stt[1]; st[i*2+dd+1]:=stt[2];
      if Buffer[Addr]>32 then st[i+46]:=chr(Buffer[Addr]) else st[i+46]:='.';
      inc(Addr);
    end;
    MemDump.Lines.Add(st);
  end;
  MemDump.Lines.EndUpdate;
  MemDump.SelStart:=0;
  MemDump.SelLength:=1;
  MemDump.Update;
end;

initialization
  GUIDList:=TStringList.Create;
  ARPTable:=TList.Create;

finalization
  GUIDList.Free;
  for iii:=0 to ARPTable.Count-1 do dispose(PArpEntry(ARPTable[iii]));
  ARPTable.Free;

end.
