#include "border.h"

Z80EX_BYTE C_Border::portFB;
unsigned C_Border::lastSpkVal=0; //[boo]
unsigned C_Border::spkCnt; //[boo]
SNDRENDER C_Border::spkRender; //[boo]

void C_Border::Init(void)
{
	AttachZ80OutputHandler(OnOutputByte);
	AttachFrameStartHandler(OnFrameStart); //[boo]
	AttachAfterFrameRenderHandler(OnAfterFrameRender); //[boo]
	portFB = 7;
	spkCnt = 0; //[boo]
}

void C_Border::Close(void)
{
}

bool C_Border::OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value)
{
	if (port & 1) return false;
	
	//[boo] -- speaker
	const unsigned MAX_SPK_VOL = 0x2FFF;
	
	if (!params.maxSpeed && params.sound)
	{
		unsigned val=(value & 0x10)? MAX_SPK_VOL: 0;
		spkRender.update(currClk, val, val);
	}
	//[/boo]	

	
	portFB = value;
	return true;
}

//[boo]
void C_Border::OnFrameStart(void)
{
	if (!params.maxSpeed && params.sound) spkRender.start_frame(spkCnt);
}


void C_Border::OnAfterFrameRender(void)
{
	int spk_samples;
	
	if (!params.maxSpeed && params.sound)
	{
		spk_samples = spkRender.end_frame(currClk);
			
		spkCnt+=spk_samples;
		if (spkCnt >= SOUND_BUFFER_SIZE) spkCnt -= SOUND_BUFFER_SIZE;	
	}
}
//[/boo]
