
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/soundcard.h>
#include <math.h>
int audio;

//
void wav_start(unsigned frag_size)
{
	int tmp;

	audio = open("/dev/dsp", O_WRONLY, 0);
	if (audio == -1) StrikeError("Unable to open /dev/dsp for writing.\n");

	tmp = /*0x80000*/0x80000 | (int) (log(frag_size) + 0.5); /*max 8 fragments*/
	
	if (ioctl(audio, SNDCTL_DSP_SETFRAGMENT, &tmp) == -1) {close(audio); StrikeError("Unable to set audio fragment size\n");}

	tmp = AFMT_S16_LE;
	if (ioctl(audio,SNDCTL_DSP_SETFMT,&tmp) == -1) {close(audio); StrikeError("setting SNDCTL_DSP_SETFMT on audiodev failed\n");}

	tmp = 16;
	ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &tmp);
	if (tmp != 16) StrikeError("Unable set samplesize = %d.\n", tmp);

	tmp = 1;
	if (ioctl(audio, SNDCTL_DSP_STEREO, &tmp) == -1) {close(audio); StrikeError("Unable to set stereo.\n");}

	tmp = SND_FQ;
	if (ioctl (audio, SNDCTL_DSP_SPEED, &tmp) == -1) {close(audio); StrikeError("Unable to set audio speed = %d.\n",SND_FQ);}
}

//play nsamples from ring buffer buf (all sizes are in samples) and clear written data
void wav_play(SNDSAMPLE *buf, unsigned from_sample, unsigned nsamples, unsigned buff_size)
{
	unsigned spbsize,wrsize,restsize=0;

	if((from_sample + nsamples) <= buff_size)
		wrsize = nsamples;
	else
	{
		wrsize = buff_size - from_sample;
		restsize = from_sample + nsamples - buff_size;
	}
	
	spbsize=wrsize*sizeof(SNDSAMPLE);
	if(write(audio, &buf[from_sample], spbsize) != spbsize) printf("Write to soundcard device failed\n");
	memset(&buf[from_sample],0,spbsize);
	
	if(restsize)
	{		
		spbsize=restsize*sizeof(SNDSAMPLE);
		if(write(audio, buf, spbsize) != spbsize) printf("Write to soundcard device failed\n");
		memset(buf,0,spbsize);
	}
}

//
void wav_stop()
{

	close(audio);	
}
