;PORTA = data
;PORTB = addrH
;PORTC = addrL

.equ	VccFlash	= 4 ;PD4
.equ	A16		= 7 ;PD7
.equ	A17		= 0 ;PE0
.equ	A18		= 6 ;PD6
.equ	OE		= 1 ;PE1
.equ	CS		= 2 ;PE2
.equ	WE		= 5 ;PD5

POnFlash:
	clr	temp
	out	PORTA,temp
	out	PORTB,temp
	out	PORTC,temp
	out	PORTD,temp
	out	PORTE,temp
	ser	temp
	out	DDRA,temp
	out	DDRB,temp
	out	DDRC,temp
	out	DDRD,temp
	out	DDRE,temp
	sbi	PORTD,led
	sbi	PORTD,VccFlash
	sbi	PORTE,CS
	sbi	PORTD,WE
	sbi	PORTE,OE
	cbi	PORTD,A16
	cbi	PORTE,A17
	ldz	Do_End
	ijmp

;Z -> count, addrLo,addrHi,Data, ...
FlashSequence:
	lpm	loop2,Z+
FlashSequence_loop:
	lpm	addrL,Z+
	lpm	addrH,Z+
	lpm	temp,Z+
	rcall	WriteByteFlash
	dec	loop2
	brne	FlashSequence_loop
	ret

ReadFlash:
	ld	addrL,Y+
	ld	addrH,Y+
	ld	temp,Y+
	rcall	SetBankFlash
	ldz	Tx_Dat
	ldi	loop,0x80
ReadFlash_loop:
	rcall	ReadByteFlash
	st	Z+,temp
	adiw	r26,1
	dec	loop
	brne	ReadFlash_loop
	ldi	loop,0x80
	ldz	Do_End
	ijmp

SetBankFlash:
	sbrs	temp,0
	cbi	PORTD,A16
	sbrc	temp,0
	sbi	PORTD,A16
	sbrs	temp,1
	cbi	PORTE,A17
	sbrc	temp,1
	sbi	PORTE,A17
	sbrs	temp,2
	cbi	PORTD,A18
	sbrc	temp,2
	sbi	PORTD,A18
	ret

ReadByteFlash:
	clr	temp
	out	DDRA,temp
	out	PORTA,temp
ReadByte:
	out	PORTC,addrL
	out	PORTB,addrH
	cbi	PORTE,CS
	cbi	PORTE,OE
	nop
	nop
	in	temp,PINA
	sbi	PORTE,OE
	sbi	PORTE,CS
	ret

WriteByteFlash:
	ser	temp2
	out	DDRA,temp2
	out	PORTC,addrL
	out	PORTB,addrH
	out	PORTA,temp
	cbi	PORTE,CS
	cbi	PORTD,WE
	nop
	nop
	sbi	PORTD,WE
	sbi	PORTE,CS
	ret

FlashWait:
	ldi	loop,0xFF
FlashWait_loop:
	rcall	wait
	dec	loop
	brne	FlashWait_loop

wait:	push	loop		;2  1ms ;)
	ldi	loop,9		;1
wait1:	push	loop		;2
	ldi	loop,100	;1
wait2:	wdr			;1
	nop			;1
	nop			;1
	nop			;1
	nop			;1
	nop			;1
	nop			;1
	nop			;1
	dec	loop		;1
	brne	wait2		;1/2
	pop	loop		;2
	dec	loop		;1
	brne	wait1		;1/2
	pop	loop		;2
	ret			;4 + rcall 3
