{

flasher: the free flash memory programmer

Copyright 2006-2011 skyther.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, Spin, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    MPort: TMenuItem;
    MDeviceType: TMenuItem;
    StatusBar1: TStatusBar;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Bevel1: TBevel;
    BufAddrPr: TEdit;
    FlashAddrPr: TEdit;
    BlockSizePr: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure SaveClick(Sender: TObject);
    procedure OpenClick(Sender: TObject);
    procedure SaveAsClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BlockSizePrKeyPress(Sender: TObject; var Key: Char);
    procedure FlashAddrPrKeyPress(Sender: TObject; var Key: Char);
    procedure BufAddrPrKeyPress(Sender: TObject; var Key: Char);
    procedure MgotoClick(Sender: TObject);
    procedure MainMenuClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  CRC_Init=$DE;
  FEND=$C0;
  FESC=$DB;
  TFEND=$DC;
  TFESC=$DD;

  C_Nop         = 0;
  C_Err         = 1;
  C_Echo        = 2;
  C_Info        = 3;
  C_Setup       = 4;
  C_POff        = 5;
  C_POn         = 6;
  C_ReadBlock   = 7;
  C_WriteBlock  = 8;
  C_Erase       = 9;
  C_Lock        = 10;
  C_Unlock      = 11;

  OEM2ANSI:string[128]=''+
                        ''+
                        ''+
                        '................'+
                        '................'+
                        '................'+
                        ''+
                        '.............';

  KOI2ANSI:string[128]='................'+
                        '................'+
                        '...............'+
                        '...............'+
                        ''+
                        ''+
                        ''+
                        '';

  patterns:array[0..10] of byte = (1,2,4,8,16,32,64,128,255,85,170);

var
  Form1:TForm1;
  dcb,dcbc:TDCB;
  ComTo,ComToc:TCOMMTIMEOUTS;
  TxBuff,RxBuff:array[0..255]of byte;
  half,Adr,Cmd,N:byte;
  FileBuff:array[0..$80000]of byte;
  CursorX,CursorY,CurrAddr,BuffAddr,FlashAddr,BlockSize,hCom:dword;
  breakOperation:boolean;
  ManufName,DevName,StatusMsg,Port,iniFile,firmware:string;
  speed:dword;
  online:boolean;
  charset:string;

implementation
{$R *.DFM}

function GetDevID(ManufName,DevName:string):byte;
begin
  result:=255;
  if ManufName='type' then begin
    if DevName='rt4a' then result:=4;
    if DevName='re3' then result:=5;
  end else begin
    if ManufName='eeprom' then result:=0;
    if ManufName='iic8' then result:=1;
    if ManufName='iic16' then result:=2;
    if ManufName='ram' then result:=3;
    if ManufName='rt4a' then result:=4;
    if ManufName='re3' then result:=5;
    if ManufName='winbond' then result:=6;
    if ManufName='amd' then result:=7;
    if ManufName='atmel' then result:=8;
    if ManufName='sst' then result:=9;
  end;
end;

procedure OnDeviceTypeChange;
begin
  CursorX:=0; CursorY:=0; CurrAddr:=0;
  BuffAddr:=0; FlashAddr:=0; BlockSize:=$80000;
  if ManufName='type' then begin
    if DevName='rt4a' then BlockSize:=$0100;
    if DevName='re3' then BlockSize:=$0100;
  end;
  if ManufName='eeprom' then begin
    if DevName='27C128' then BlockSize:=$4000;
    if DevName='27C256' then BlockSize:=$8000;
    if DevName='27C512' then BlockSize:=$10000;
  end;
  if ManufName='ram' then begin
    if DevName='62256' then BlockSize:=$8000;
    if DevName='62512' then BlockSize:=$10000;
    if DevName='621024' then BlockSize:=$20000;
  end;
  if ManufName='iic8' then begin
    if DevName='24C01' then BlockSize:=$80;
    if DevName='24C02' then BlockSize:=$100;
    if DevName='24C04' then BlockSize:=$200;
    if DevName='24C08' then BlockSize:=$400;
    if DevName='24C16' then BlockSize:=$800;
  end;
  if ManufName='iic16' then begin
    if DevName='24C32' then BlockSize:=$1000;
    if DevName='24C64' then BlockSize:=$2000;
    if DevName='24C128' then BlockSize:=$4000;
    if DevName='24C256' then BlockSize:=$8000;
    if DevName='24C512' then BlockSize:=$10000;
  end;
  if ManufName='amd' then begin
    if DevName='AM29F010' then BlockSize:=$20000;
    if DevName='AM29F020' then BlockSize:=$40000;
    if DevName='AM29F040' then BlockSize:=$80000;
  end;
  if ManufName='atmel' then begin
    if DevName='AT29F010' then BlockSize:=$20000;
    if DevName='AT29F020' then BlockSize:=$40000;
    if DevName='AT29F040' then BlockSize:=$80000;
  end;
  if ManufName='sst' then begin
    if DevName='SST39SF010' then BlockSize:=$20000;
    if DevName='SST39SF020' then BlockSize:=$40000;
    if DevName='SST39SF040' then BlockSize:=$80000;
  end;
  if ManufName='winbond' then begin
    if DevName='W29C010' then BlockSize:=$20000;
    if DevName='W29C020' then BlockSize:=$40000;
    if DevName='W29C040' then BlockSize:=$80000;
  end;
end;

// ===== wake protocol =====
function FlushCOM:boolean;
begin
  result:=FlushFileBuffers(hCom);
end;

 function PurgeCOM:boolean;
begin
  result:=PurgeComm(hCom, PURGE_TXABORT or PURGE_RXABORT or PURGE_TXCLEAR or PURGE_RXCLEAR);
end;

function SetModLns(F:dword):boolean;
begin
  result:=EscapeCommFunction(hCom, F);
end;

function GetModLns(var lpD:dword):boolean;
begin
 result:=GetCommModemStatus(hCom, lpD);
end;

function GetMaskCOM(var lpEvtMask:dword):boolean;
begin
  result:=GetCommMask(hCom, lpEvtMask);
end;

function SetMaskCOM(EvtMask:dword):boolean;
begin
 result:=SetCommMask(hCom, EvtMask);
end;

function WaitEventCOM(var lpEvtMask:dword):boolean;
begin
 result:=WaitCommEvent(hCom, lpEvtMask, nil);
end;

function AccessCOM(p:PChar):boolean;
var hTemp:dword;
begin
  p:=pChar('\\.\'+p);
  hTemp:=CreateFile(p,GENERIC_READ or GENERIC_WRITE,0,nil,OPEN_EXISTING,0,0);
  if hTemp=INVALID_HANDLE_VALUE then begin
    result:=false;
    exit;
  end;
  CloseHandle(hTemp);
  result:=true;
end;

procedure DowCRC(b:byte;var crc:byte);
var i:dword;
begin
  for i:=0 to 7 do begin
    if ((b xor crc) and 1)<>0 then crc:=((crc xor $18) shr 1) or $80
                              else crc:=(crc shr 1) and $7F;
    b:=b shr 1;
  end;
end;

function RxByteCOM(var b:byte):boolean;
var r:dword;
    x:boolean;
begin
  x:=ReadFile(hCom,b,1,r,nil);
  result:=x and (r=1);
end;

function RxFrame(Tout:dword; var ADD,CMD,N:byte; var Data:array of byte):boolean;
var i:integer;
    b,crc:byte;
begin
  crc:=CRC_Init;
  b:=0;
  ComTo.ReadTotalTimeoutConstant:=Tout;
  if not SetCommTimeouts(hCom, ComTo) then begin
    RxFrame:=false;
    exit;
  end;
  for i:=0 to 511 do begin
    if not RxByteCOM(b) then break;
    if b=FEND then break;
  end;
  if b<>FEND then begin
    RxFrame:=false;
    exit;
  end;
  DowCRC(b, crc);
  ADD:=0; N:=0;
  i:=-3;
  repeat
    if not RxByteCOM(b)then break;
    if (b=FESC) then
      if not RxByteCOM(b) then break
      else begin
        if b=TFEND then b:=FEND
        else
          if b=TFESC then b:=FESC
          else break;
      end;
    DowCRC(b, crc);
    if i=-3 then
      if b and $80=0 then begin
        CMD:=b;
        inc(i);
      end
      else ADD:=b and $7F
    else
      if i=-2 then
        if b and $80<>0 then break
        else CMD:=b
      else
        if i=-1 then N:=b
        else
          if i<>N then Data[i]:=b;
    inc(i);
  until i>N;
  result:=(i=N+1) and (crc=0);
end;

function TxFrame(ADDR,CMD,N:byte;Data:array of byte):boolean;
var Buff:array[0..518]of byte;
    i:integer;
    r,j:dword;
    d,crc:byte;
    x:boolean;
begin
  crc:=CRC_Init;
  j:=0;
  i:=-4;
  repeat;
    if (i=-3) and (ADDR=0) then inc(i);
    if i=-4 then d:=FEND
    else
      if i=-3 then d:=ADDR
      else
        if i=-2 then d:=CMD
        else
          if i=-1 then d:=N
          else
            if i=N then d:=crc
            else
              d:=Data[i];
    DowCRC(d, crc);
    if i=-3 then d:=d or $80;
    if (i>-4) and ((d=FEND) or (d=FESC)) then begin
      Buff[j]:=FESC;
      inc(j);
      if d=FEND then d:=TFEND
                else d:=TFESC;
    end;
    Buff[j]:=d;
    inc(j);
    inc(i);
  until i>N;
  x:=WriteFile(hCom,Buff,j,r,nil);
  result:=x and (r=j);
end;

// ===== COM port =====
function OpenCOM(p:PChar;baud:dword):boolean;
begin
  p:=pChar('\\.\'+p);
  hCom:=CreateFile(p,GENERIC_READ or GENERIC_WRITE,0,nil,OPEN_EXISTING,0,0);
  if hCom = INVALID_HANDLE_VALUE then begin
    result:=false;
    exit;
  end;
  if not GetCommState(hCom, dcb) then begin
    result:=false;
    exit;
  end;
  if not GetCommTimeouts(hCom, ComTo) then begin
    result:=false;
    exit;
  end;
  dcbc:=dcb;
  ComToc:=ComTo;
  dcb.BaudRate:=baud;
  dcb.ByteSize:=8;
  dcb.Parity:=NOPARITY;
  dcb.StopBits:=ONESTOPBIT;
//  dcb.fBinary:=1;
//  dcb.fDtrControl:=DTR_CONTROL_DISABLE;
//  dcb.fRtsControl:=RTS_CONTROL_ENABLE;
  if not SetCommState(hCom, dcb) then begin
    result:=false;
    exit;
  end;
  if not SetupComm(hCom, 512, 512) then begin
    result:=false;
    exit;
  end;
  ComTo.ReadIntervalTimeout:=MAXDWORD;
  ComTo.ReadTotalTimeoutMultiplier:=MAXDWORD;
  ComTo.ReadTotalTimeoutConstant:=1000;
  ComTo.WriteTotalTimeoutMultiplier:=0;
  ComTo.WriteTotalTimeoutConstant:=1000;
  if not SetCommTimeouts(hCom, ComTo)then begin
    result:=false;
    exit;
  end;
  if not PurgeCOM then begin
    result:=false;
    exit;
  end;
  result:=true;
end;

function CloseCOM:boolean;
begin
  if not SetCommState(hCom, dcbc) then begin
    result:=false;
    exit;
  end;
  if not SetCommTimeouts(hCom, ComToc) then begin
    result:=false;
    exit;
  end;
  if not CloseHandle(hCom) then begin
    result:=false;
    exit;
  end;
  result:=true;
end;

function InitCOM(PortN:string;speedN:dword; var ErrorMsg:string):boolean;
var i:integer;
begin
  result:=false;
  case speedN of
    19200: TxBuff[0]:=71;
    57600: TxBuff[0]:=23;
    115200: TxBuff[0]:=11;
  else
    exit;
  end;
  CloseCOM;
  if not AccessCOM(PChar(PortN)) then begin
    ErrorMsg:='error opening port!';
    exit;
  end;
  OpenCOM(PChar(PortN),19200);
  TxFrame(0,C_Setup,1,TxBuff);
  sleep(100);
  CloseCOM;
  OpenCOM(PChar(PortN),57600);
  TxFrame(0,C_Setup,1,TxBuff);
  sleep(100);
  CloseCOM;
  OpenCOM(PChar(PortN),115200);
  TxFrame(0,C_Setup,1,TxBuff);
  sleep(100);
  CloseCOM;
  OpenCOM(PChar(PortN),speedN);
  TxFrame(0,C_Info,0,TxBuff);
  if not RxFrame(200,Adr,Cmd,N,RxBuff) or (Cmd=C_Err) then begin
    ErrorMsg:='offline';
    Port:=PortN;
    speed:=speedN;
    exit;
  end;
  firmware:='';
  for i:=0 to N-2 do firmware:=firmware+chr(RxBuff[i]);
  Port:=PortN;
  speed:=speedN;
  ErrorMsg:='online';
  result:=true;
end;
// ===== flash =====
function ReadBlock(addr:dword):boolean;
begin
  TxBuff[0]:=GetDevID(ManufName,DevName);
  TxBuff[1]:=lo(addr);
  TxBuff[2]:=hi(addr);
  TxBuff[3]:=(addr and $FF0000)shr $10;
  TxFrame(0,C_ReadBlock,4,TxBuff);
  fillchar(RxBuff,128,0);
  result:=RxFrame(200,Adr,Cmd,N,RxBuff) and (Cmd<>C_Err);
end;

function WriteBlock(addr:dword):boolean;
begin
  TxBuff[0]:=GetDevID(ManufName,DevName);
  TxBuff[1]:=lo(addr);
  TxBuff[2]:=hi(addr);
  TxBuff[3]:=(addr and $FF0000)shr $10;
  TxFrame(0,C_WriteBlock,128+4,TxBuff);
  fillchar(RxBuff,128,0);
  result:=RxFrame(200,Adr,Cmd,N,RxBuff) and (Cmd<>C_Err);
end;

function PowerOn:boolean;
begin
  TxBuff[0]:=GetDevID(ManufName,DevName);
  TxFrame(0,C_POn,1,TxBuff);
  result:=RxFrame(200,Adr,Cmd,N,RxBuff) and (Cmd<>C_Err);
end;

function PowerOff:boolean;
begin
  TxFrame(0,C_POff,0,TxBuff);
  result:=RxFrame(200,Adr,Cmd,N,RxBuff) and (Cmd<>C_Err);
end;

function CheckBlock(addr:dword):boolean;
var k:dword;
begin
  for k:=0 to 127 do
    if RxBuff[k]<>FileBuff[addr+k] then begin
      result:=false;
      exit;
    end;
  result:=true;
end;

procedure ReadDevice;
var err,i,j,k:dword;
begin
  if not BreakOperation or not online then exit;
  BreakOperation:=false;
//  PowerOn;
  i:=BuffAddr;
  j:=FlashAddr;
  err:=0;
  repeat
    if BreakOperation then break;
    Form1.StatusBar1.SimpleText:='reading: '+intToHex(j,5);
    if err>0 then Form1.StatusBar1.SimpleText:=Form1.StatusBar1.SimpleText+' trying: '+intToStr(err);
PowerOn;
    if not ReadBlock(j) then begin
      PowerOff;
      if err=10 then begin
        PowerOff;
        MessageDlg('read error!',mtError,[mbOK],0);
        BreakOperation:=true;
        Form1.Paint;
        exit;
      end;
      inc(err);
      sleep(200);
      PowerOn;
      Application.ProcessMessages;
      continue;
    end;
    for k:=0 to 127 do FileBuff[i+k]:=RxBuff[k];
PowerOff;
    inc(i,128);
    inc(j,128);
    err:=0;
    Application.ProcessMessages;
  until i>=BuffAddr+BlockSize;
//  PowerOff;
  if i>=BuffAddr+BlockSize then MessageDlg('read complete!',mtInformation,[mbOK],0);
  BreakOperation:=true;
  FlashAddr:=j;
  Form1.FlashAddrPr.Text:=intToHex(FlashAddr,5);
  Form1.Paint;
end;

procedure WriteDevice;
var err,i,j,k:dword;
begin
  if not BreakOperation or not online then exit;
  BreakOperation:=false;
  PowerOn;
  i:=BuffAddr;
  j:=FlashAddr;
  err:=0;
  repeat
    if BreakOperation then break;
    Form1.StatusBar1.SimpleText:='writing: '+intToHex(j,5);
    if err>0 then Form1.StatusBar1.SimpleText:=Form1.StatusBar1.SimpleText + ' trying: '+intToStr(err);
    for k:=0 to 127 do TxBuff[k+4]:=FileBuff[i+k];
    WriteBlock(j);
    ReadBlock(j);
    if not CheckBlock(i) then begin
      PowerOff;
      if err=10 then begin
        MessageDlg('write error!',mtError,[mbOK],0);
        BreakOperation:=true;
        Form1.Paint;
        exit;
      end;
      PowerOn;
      inc(err);
      sleep(100);
      Application.ProcessMessages;
      continue;
    end;
    err:=0;
    inc(i,128);
    inc(j,128);
    Application.ProcessMessages;
  until i>=BuffAddr+BlockSize;
  PowerOff;
  if i>=BuffAddr+BlockSize then MessageDlg('write complete!',mtInformation,[mbOK],0);
  BreakOperation:=true;
  FlashAddr:=j;
  Form1.FlashAddrPr.Text:=intToHex(FlashAddr,5);
  Form1.Paint;
end;

procedure VerifyDevice;
var err,i,j:dword;
begin
  if not BreakOperation or not online then exit;
  BreakOperation:=false;
  PowerOn;
  i:=BuffAddr;
  j:=FlashAddr;
  err:=0;
  repeat
    if BreakOperation then break;
    Form1.StatusBar1.SimpleText:='verifing: '+intToHex(j,5);
    if err>0 then Form1.StatusBar1.SimpleText:=Form1.StatusBar1.SimpleText + ' trying: '+intToStr(err);
    ReadBlock(j);
    if not CheckBlock(i) then begin
      if err=10 then begin
        PowerOff;
        MessageDlg('difference found!',mtError,[mbOK],0);
        BreakOperation:=true;
        Form1.Paint;
        exit;
      end;
      inc(err);
      sleep(100);
      Application.ProcessMessages;
      continue;
    end;
    err:=0;
    inc(i,128);
    inc(j,128);
    Application.ProcessMessages;
  until i>=BuffAddr+BlockSize;
  PowerOff;
  if i>=BuffAddr+BlockSize then MessageDlg('identical!',mtInformation,[mbOK],0);
  BreakOperation:=true;
  Form1.Paint;
end;

procedure VerifyRAM;
var i,j,k:dword;
begin
  if not BreakOperation or not online then exit;
  BreakOperation:=false;
  PowerOn;
  for i:=0 to 10 do begin
    for j:=0 to 127 do TxBuff[j+4]:=patterns[i];
    j:=0; //RAMAddr
    repeat
      if BreakOperation then break;
      Form1.StatusBar1.SimpleText:='writing: '+intToHex(j,5)+' pattern: '+intToHex(patterns[i],2);
      WriteBlock(j);
      inc(j,128);
      Application.ProcessMessages;
    until j>=BlockSize;
    j:=0; //RAMAddr
    repeat
      if BreakOperation then break;
      Form1.StatusBar1.SimpleText:='reading: '+intToHex(j,5)+' pattern: '+intToHex(patterns[i],2);
      ReadBlock(j);
      for k:=0 to 127 do
        if RxBuff[k]<>patterns[i] then begin
          PowerOff;
          MessageDlg('test failed!'+chr($0d)+chr($0a)+'error at: '+IntToHex(j,4)+'h',mtError,[mbOK],0);
          BreakOperation:=true;
          Form1.Paint;
          exit;
        end;
      inc(j,128);
      Application.ProcessMessages;
    until j>=BlockSize;
  end;
  PowerOff;
  if j>=$8000 then MessageDlg('test passed!',mtInformation,[mbOK],0);
  BreakOperation:=true;
  Form1.Paint;
end;

procedure EraseDevice;
begin
  if not BreakOperation or not online then exit;
  if MessageDlg('realy?',mtConfirmation,[mbYes,mbNo],0)<>mrYes then exit;
  BreakOperation:=false;
  PowerOn;
  TxBuff[0]:=GetDevID(ManufName,DevName);
  TxFrame(0,C_Erase,1,TxBuff);
  if not ((RxFrame(10000,Adr,Cmd,N,RxBuff) or (Cmd=C_Err))) then MessageDlg('error!',mtError,[mbOk],0);
  PowerOff;
  BreakOperation:=true;
  Form1.Paint;
end;

procedure LockDevice;
begin
  if not BreakOperation or not online then exit;
  BreakOperation:=false;
  PowerOn;
  TxBuff[0]:=GetDevID(ManufName,DevName);
  TxFrame(0,C_Lock,1,TxBuff);
  if not ((RxFrame(200,Adr,Cmd,N,RxBuff) or (Cmd=C_Err))) then MessageDlg('error!',mtError,[mbOk],0);
  PowerOff;
  BreakOperation:=true;
  Form1.Paint;
end;

procedure UnlockDevice;
begin
  if not BreakOperation or not online then exit;
  BreakOperation:=false;
  PowerOn;
  TxBuff[0]:=GetDevID(ManufName,DevName);
  TxFrame(0,C_UnLock,1,TxBuff);
  if not ((RxFrame(200,Adr,Cmd,N,RxBuff) or (Cmd=C_Err))) then MessageDlg('error!',mtError,[mbOk],0);
  PowerOff;
  BreakOperation:=true;
  Form1.Paint;
end;

function GetIniKey(section,key,def:string):string;
var buffer:array[0..127]of byte;
    temp:string;
    i:integer;
begin
  GetPrivateProfileStringA(PChar(section),PChar(key),PChar(def),addr(buffer),sizeof(buffer),PChar(iniFile));
  temp:='';
  for i:=0 to 127 do
    if buffer[i]=0 then break
                   else temp:=temp+chr(buffer[i]);
  result:=temp;
end;

// ===== form =====
procedure AddDevice(Parent,Device:string);
var OldItem,NewItem:TMenuItem;
begin
  OldItem:=Form1.MDeviceType.Find(Parent);
  if OldItem = nil then begin
    OldItem:=TMenuItem.Create(Form1.MainMenu1);
    OldItem.Caption:=Parent;
    Form1.MDeviceType.Add(OldItem);
  end;
  NewItem:=TMenuItem.Create(Form1.MainMenu1);
  NewItem.Caption:=Device;
  NewItem.OnClick:=Form1.MainMenuClick;
  OldItem.Add(NewItem);
end;

procedure AddDevices;
{var i,size:dword;
  TempManufName,TempDevName:string;}
begin
{  for i:=0 to 100 do begin
    TempManufName:=GetIniKey('device_'+IntToHex(i,4),'ManufName','');
    TempDevName:=GetIniKey('device_'+IntToHex(i,4),'DevName','');
    size:=StrToInt(GetIniKey('device_'+IntToHex(i,4),'Size','0'));
    if (TempManufName='') and (TempDevName='') then break;
    AddDevice(TempManufName,TempDevName);
  end;}
  AddDevice('eeprom','27C128');
  AddDevice('eeprom','27C256');
  AddDevice('eeprom','27C512');

  AddDevice('iic8','24C01');
  AddDevice('iic8','24C02');
  AddDevice('iic8','24C04');
  AddDevice('iic8','24C08');
  AddDevice('iic8','24C16');

  AddDevice('iic16','24C32');
  AddDevice('iic16','24C64');
  AddDevice('iic16','24C128');
  AddDevice('iic16','24C256');
  AddDevice('iic16','24C512');

  AddDevice('ram','62256');
  AddDevice('ram','62512');
  AddDevice('ram','621024');

  AddDevice('amd','AM29F010');
  AddDevice('amd','AM29F020');
  AddDevice('amd','AM29F040');

  AddDevice('atmel','AT29F010');
  AddDevice('atmel','AT29F020');
  AddDevice('atmel','AT29F040');

  AddDevice('winbond','W29C010');
  AddDevice('winbond','W29C020');
  AddDevice('winbond','W29C040');

  AddDevice('sst','SST39SF010');
  AddDevice('sst','SST39SF020');
  AddDevice('sst','SST39SF040');
end;

procedure AddCOMPorts;
var i:integer;
    NewItem:TMenuItem;
begin
  Port:='';
  for i:=1 to 255 do begin
    if AccessCOM(PChar('COM'+IntToStr(i))) then begin
      NewItem:=TMenuItem.Create(Form1.MainMenu1);
      NewItem.Caption:='COM'+IntToStr(i);
      NewItem.OnClick:=Form1.MainMenuClick;
      Form1.MPort.Add(NewItem);
      if Port='' then Port:=NewItem.Caption;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  iniFile:=ChangeFileExt(Application.ExeName,'.ini');
  AddDevices;
  AddCOMPorts;
  port:=GetIniKey('options','Port',port);
  speed:=StrToInt(GetIniKey('options','Speed','19200'));
  ManufName:=GetIniKey('options','ManufName','winbond');
  DevName:=GetIniKey('options','DevName','W29C020');
  OnDeviceTypeChange;
  online:=InitCOM(port,speed, StatusMsg);
  FillChar(FileBuff,sizeof(FileBuff),0);
  CurrAddr:=0; CursorX:=0; CursorY:=0; half:=$F0;
  Form1.SaveDialog1.InitialDir:=GetCurrentDir;
  Form1.OpenDialog1.InitialDir:=GetCurrentDir;
  BreakOperation:=true;
  charset:='ansi';
  Form1.Paint;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var temp:string;
begin
  if not BreakOperation then begin
    BreakOperation:=true;
    CanClose:=false;
    exit;
  end;
  WritePrivateProfileString('options','Port',PChar(Port),PChar(iniFile));
  temp:=intToStr(speed);
  WritePrivateProfileString('options','Speed',PChar(temp),PChar(iniFile));
  WritePrivateProfileString('options','ManufName',PChar(ManufName),PChar(iniFile));
  WritePrivateProfileString('options','DevName',PChar(DevName),PChar(iniFile));
  CloseCOM;
  CanClose:=true;
end;

procedure TForm1.FormPaint(Sender: TObject);
var i,j:word;
begin
  Form1.StatusBar1.SimpleText:='';
  Form1.StatusBar1.SimpleText:=Port+' '+IntToStr(speed)+' '+DevName+' '+StatusMsg;
  Form1.BufAddrPr.Text:=IntToHex(BuffAddr,5);
  Form1.FlashAddrPr.Text:=IntToHex(FlashAddr,5);
  Form1.BlockSizePr.Text:=IntToHex(BlockSize,5);
  Form1.ActiveControl:=nil;
  for i:=0 to 15 do begin
    Form1.Canvas.Font.Color:=clRed;
    Form1.Canvas.TextOut(2,1+i*14,IntToHex(CurrAddr+i*16,5)+' ');
    Form1.Canvas.Font.Color:=clBlack;
    for j:=0 to 15 do begin
      if (i=CursorY) and (j=CursorX) then Form1.Canvas.Brush.Color:=clGray
                                      else Form1.Canvas.Brush.Color:=clBtnFace;
      Form1.Canvas.TextOut(42+j*16,1+i*14,IntToHex(FileBuff[CurrAddr+i*16+j],2));
      Form1.Canvas.Brush.Color:=clBtnFace;
      if (FileBuff[CurrAddr+i*16+j]>=$20) then
        if (FileBuff[CurrAddr+i*16+j]<=$7F) then
          Form1.Canvas.TextOut(304+j*8,1+i*14,chr(FileBuff[CurrAddr+i*16+j]))
        else begin
          if charset='ansi' then Form1.Canvas.TextOut(304+j*8,1+i*14,chr(FileBuff[CurrAddr+i*16+j]));
          if charset='oem' then Form1.Canvas.TextOut(304+j*8,1+i*14,OEM2ANSI[FileBuff[CurrAddr+i*16+j]-127]);
          if charset='koi8-r' then Form1.Canvas.TextOut(304+j*8,1+i*14,KOI2ANSI[FileBuff[CurrAddr+i*16+j]-127]);
        end
      else Form1.Canvas.TextOut(304+j*8,1+i*14,'.');
    end;
  end;
end;

procedure TForm1.MainMenuClick(Sender: TObject);
var Item:TMenuItem;
    temp:string;
begin
  Item:=Sender as TMenuItem;

  if Item.Caption = 'read' then
    ReadDevice;
  if Item.Caption = 'write' then
    WriteDevice;
  if Item.Caption = 'verify' then
    if ManufName='ram' then VerifyRAM else VerifyDevice;
  if Item.Caption = 'erase' then
    EraseDevice;
  if Item.Caption = 'lock' then
    LockDevice;
  if Item.Caption = 'unlock' then
    UnLockDevice;
  if Item.Caption = 'about' then begin
    temp:='flasher v0.17b'+chr($0d)+chr($0a)+'firmware: '+firmware+chr($0d)+chr($0a)+'(C) 2006 - 2011 skyther';
    MessageDlg(temp,mtInformation,[mbOK],0);
  end;

  if (Item.Caption = 'ansi') or (Item.Caption = 'oem') or (Item.Caption = 'koi8-r') then
    charset:=Item.Caption;

  if Item.Caption = '19200' then
    online:=InitCOM(Port, 19200, StatusMsg);
  if Item.Caption = '57600' then
    online:=InitCOM(Port, 57600, StatusMsg);
  if Item.Caption = '115200' then
    online:=InitCOM(Port, 115200, StatusMsg);
  if copy(Item.Caption,1,3) = 'COM' then
    online:=InitCOM(PChar(Item.Caption), speed, StatusMsg);

  if GetDevID(Item.Parent.Caption, Item.Caption) <> 255 then begin
    ManufName:=Item.Parent.Caption;
    DevName:=Item.Caption;
    OnDeviceTypeChange;
  end;
  
  Form1.Paint;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var ch:char;
begin
  if Key=VK_ESCAPE then breakOperation:=true;

  if HiWord(GetKeyState(VK_CONTROL))=0 then begin
    if Key=VK_UP then
      if CursorY=0 then dec(CurrAddr,16*byte(CurrAddr>0))
                   else dec(CursorY);
    if Key=VK_DOWN then
      if CursorY=15 then inc(CurrAddr,16*byte(CurrAddr<$7FF00))
                    else inc(CursorY);
    if Key=VK_LEFT then dec(CursorX,byte(CursorX>0));
    if Key=VK_RIGHT then inc(CursorX,byte(CursorX<15));
    if Key=VK_HOME then CursorX:=0;
    if Key=VK_END then CursorX:=15;

    if Key=VK_PRIOR then
      if CursorY>0 then CursorY:=0
                   else dec(CurrAddr,$100*byte(CurrAddr>=$100));
    if Key=VK_NEXT then
      if CursorY<15 then CursorY:=15
                    else inc(CurrAddr,$100*byte(CurrAddr<=$7FE00));
  end
  else begin
    if Key=VK_UP then dec(CurrAddr,16*byte(CurrAddr>0));
    if Key=VK_DOWN then inc(CurrAddr,16*byte(CurrAddr<$7FF00));
    if Key=VK_HOME then begin
      CurrAddr:=0;
      CursorX:=0;
      CursorY:=0;
    end;
    if Key=VK_END then begin
      CurrAddr:=$7FF00;
      CursorX:=15;
      CursorY:=15;
    end;
    if Key=VK_PRIOR then dec(CurrAddr,$4000*byte(CurrAddr>=$4000));
    if Key=VK_NEXT then inc(CurrAddr,$4000*byte(CurrAddr<=$7BFF0));
  end;
  if BreakOperation then begin
    ch:=upCase(chr(Key));
    case ch of
      '0'..'9': begin
        FileBuff[CurrAddr+CursorX+CursorY*$10]:=(FileBuff[CurrAddr+CursorX+CursorY*$10] and not half) or (ord(ch)-ord('0')+(ord(ch)-ord('0'))*$10)and half;
        half:=not half;
        if half=$F0 then inc(CursorX);
        if CursorX=16 then begin
          CursorX:=0;
         if CursorY=15 then inc(CurrAddr,16*byte(CurrAddr<$3FF00))
                       else inc(CursorY);
        end;
      end;
      'A'..'F': begin
        FileBuff[CurrAddr+CursorX+CursorY*$10]:=(FileBuff[CurrAddr+CursorX+CursorY*$10] and not half) or (ord(ch)-ord('A')+$0A+(ord(ch)-ord('A')+$0A)*$10)and half;
        half:=not half;
        if half=$F0 then inc(CursorX);
        if CursorX=16 then begin
          CursorX:=0;
         if CursorY=15 then inc(CurrAddr,16*byte(CurrAddr<$3FF00))
                       else inc(CursorY);
        end;
      end
      else
      half:=$F0;
    end;
  end;
  Form1.Paint;
end;

procedure TForm1.OpenClick(Sender: TObject);
var FileSize,hFile:dword;
begin
  if not Form1.OpenDialog1.Execute then exit;
  hFile:=CreateFile(PChar(Form1.OpenDialog1.FileName),GENERIC_READ or GENERIC_WRITE,0,nil,OPEN_EXISTING,0,0);
  ReadFile(hFile,FileBuff,$80000,FileSize,nil);
  CloseHandle(hFile);
  Form1.BufAddrPr.Text:='00000';
  BuffAddr:=0;
  BlockSize:=FileSize;
  Form1.BlockSizePr.Text:=intToHex(FileSize,5);
  Form1.Caption:='flasher - '+ExtractFileName(Form1.OpenDialog1.FileName);
  Application.Title:='flasher - '+ExtractFileName(Form1.OpenDialog1.FileName);
  Form1.Paint;
end;

procedure TForm1.SaveClick(Sender: TObject);
var i,hFile:dword;
begin
  if Form1.SaveDialog1.FileName='' then
    if not Form1.SaveDialog1.Execute then exit;
  hFile:=CreateFile(PChar(Form1.SaveDialog1.FileName),GENERIC_READ or GENERIC_WRITE,0,nil,CREATE_ALWAYS,0,0);
  WriteFile(hFile,FileBuff,BlockSize,i,nil);
  CloseHandle(hFile);
  Form1.Caption:='flasher - '+ExtractFileName(Form1.SaveDialog1.FileName);
  Application.Title:='flasher - '+ExtractFileName(Form1.SaveDialog1.FileName);
  Form1.Paint;
end;

procedure TForm1.SaveAsClick(Sender: TObject);
var i,hFile:dword;
begin
  if not Form1.SaveDialog1.Execute then exit;
  hFile:=CreateFile(PChar(Form1.SaveDialog1.FileName),GENERIC_READ or GENERIC_WRITE,0,nil,CREATE_ALWAYS,0,0);
  WriteFile(hFile,FileBuff,BlockSize,i,nil);
  CloseHandle(hFile);
  Form1.Caption:='flasher - '+ExtractFileName(Form1.SaveDialog1.FileName);
  Application.Title:='flasher - '+ExtractFileName(Form1.SaveDialog1.FileName);
  Form1.Paint;
end;

procedure TForm1.BufAddrPrKeyPress(Sender: TObject; var Key: Char);
var i,j:dword;
    ch:char;
begin
  if ord(Key)=$0d then begin
    j:=0;
    for i:=1 to length(Form1.BufAddrPr.Text) do begin
      ch:=upcase(Form1.BufAddrPr.Text[i]);
      case ch of
        '0'..'9': j:=j*16+ord(ch)-ord('0');
        'A'..'F': j:=j*16+ord(ch)-ord('A')+10;
      end;
    end;
    Form1.BufAddrPr.Text:=intToHex(j,5);
    BuffAddr:=j;
    Form1.ActiveControl:=nil;
  end;
end;

procedure TForm1.FlashAddrPrKeyPress(Sender: TObject; var Key: Char);
var i,j:dword;
    ch:char;
begin
  if ord(Key)=$0d then begin
    j:=0;
    for i:=1 to length(Form1.FlashAddrPr.Text) do begin
      ch:=upcase(Form1.FlashAddrPr.Text[i]);
      case ch of
        '0'..'9': j:=j*16+ord(ch)-ord('0');
        'A'..'F': j:=j*16+ord(ch)-ord('A')+10;
      end;
    end;
    Form1.FlashAddrPr.Text:=intToHex(j,5);
    FlashAddr:=j;
    Form1.ActiveControl:=nil;
  end;
end;

procedure TForm1.BlockSizePrKeyPress(Sender: TObject; var Key: Char);
var i,j:dword;
    ch:char;
begin
  if ord(Key)=$0d then begin
    j:=0;
    for i:=1 to length(Form1.BlockSizePr.Text) do begin
      ch:=upcase(Form1.BlockSizePr.Text[i]);
      case ch of
        '0'..'9': j:=j*16+ord(ch)-ord('0');
        'A'..'F': j:=j*16+ord(ch)-ord('A')+10;
      end;
    end;
    Form1.BlockSizePr.Text:=intToHex(j,5);
    BlockSize:=j;
    Form1.ActiveControl:=nil;
  end;
end;

procedure TForm1.MgotoClick(Sender: TObject);
var temp:string;
    i:dword;
begin
  temp:=InputBox('goto','','0');
  CurrAddr:=0;
  for i:=1 to length(temp) do
    case UpCase(temp[i]) of
      '0'..'9': CurrAddr:=CurrAddr*16+ord(temp[i])-ord('0');
      'A'..'F': CurrAddr:=CurrAddr*16+ord(UpCase(temp[i]))-ord('A')+10;
    end;
  CursorX:=CurrAddr and $0F;
  CurrAddr:=CurrAddr and $FFFFF0;
  CursorY:=CurrAddr;
  if CurrAddr>$3FF00 then CurrAddr:=$3FF00;
  CursorY:=(CursorY-CurrAddr) div 16 and $0F;
  Form1.Paint;
end;

end.
