/*

ZXMAK2 Device Plugin Example

USAGE: Compile, run ZXMAK2 and type OUT 3,111

*/
using System;
using System.Windows.Forms;
using ZXMAK2.Engine.Interfaces;
using ZXMAK2.Engine.Z80;


public class IO_Test : IBusDevice
{
	private Z80CPU m_cpu;

        public string Name { get { return "IO_Test"; } }
        public string Description { get { return "Block device"; } }
        public BusCategory Category { get { return BusCategory.Other; } }

        public void BusConnect(IBusManager bmgr)
        {
            MessageBox.Show("Connect", "IO_TEST");
            m_cpu = bmgr.GetMainCpu();
            bmgr.SubscribeWRIO(0xFFFF, 0x0003, writePort0001);
        }

        public void BusDisconnect()
        {
            MessageBox.Show("Disconnect", "IO_TEST");
        }

        private void writePort0001(long cpuTact, ushort addr, byte value)
        {
            MessageBox.Show(string.Format(
		"OUT (#{0:X4}),{1} @ PC=#{2:X4}",
		addr,
		value,
		m_cpu.regs.PC), "IO_TEST");
        }
}
