#include "ay.h"
#include "../../bin.h"

unsigned C_Ay::ayCnt=0;
SNDCHIP C_Ay::ayChip;

void wav_play(SNDSAMPLE *buf, unsigned from_sample, unsigned nsamples, unsigned buff_size);

void C_Ay::Init(void)
{
	AttachZ80InputHandler(OnInputByte);
	AttachZ80OutputHandler(OnOutputByte);
	AttachFrameStartHandler(OnFrameStart);
	AttachAfterFrameRenderHandler(OnAfterFrameRender);
	AttachResetHandler(OnReset);
	ayCnt = 0;
}

void C_Ay::Close(void)
{
}

bool C_Ay::OnInputByte(Z80EX_WORD port, Z80EX_BYTE &retval)
{
	if ((port & MAKEWORD(BIN(0x11000000),BIN(0x00000010))) == MAKEWORD(BIN(0x11000000),BIN(0x00000000)))	// 0xFFFD
	{
		retval = ayChip.read();
		return true;
	}

	return false;
}

bool C_Ay::OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value)
{
	if ((port & MAKEWORD(BIN(0x11000000),BIN(0x00000010))) == MAKEWORD(BIN(0x11000000),BIN(0x00000000)))	// 0xFFFD
	{
		ayChip.select(value);
		return true;
	}

	if ((port & MAKEWORD(BIN(0x11000000),BIN(0x00000010))) == MAKEWORD(BIN(0x10000000),BIN(0x00000000)))	// 0xFFFD
	{
		ayChip.write((!params.sound || params.maxSpeed) ? 0 : currClk, value);
		return true;
	}

	return false;
}

void C_Ay::OnFrameStart(void)
{
	if (!params.maxSpeed && params.sound)
	{		
		ayChip.start_frame(ayCnt); //[boo]
	}
}

void C_Ay::OnAfterFrameRender(void)
{
	unsigned ay_samples;
//static double av=0;
//static int f=0;
	
	if (!params.maxSpeed && params.sound)
	{
		ay_samples = ayChip.end_frame(currClk);
//av=(av+ay_samples)/(av? 2: 1);		
//if(!(++f%=100)) printf("ay  frame: %lf\n\n",av);	
	
		ayCnt+=ay_samples;
		if (ayCnt >= SND_EXTERNAL_BUFFER_SIZE) ayCnt -= SOUND_BUFFER_SIZE;
	}
}

void C_Ay::OnReset(void)
{
	ayChip.reset();
}
