#include <string.h>
#include "dialog.h"
#include "font.h"
#include "dirwork.h"

#define MAX_FILES 4096
#define MAX_FNAME 256

extern C_Font font;
char oldFileName[MAX_PATH];
int currentDrive = 0;

void Bar(int x1, int y1, int x2, int y2, int c)
{
	int sw;
	SDL_Rect r;

	if (x2 < x1) {sw = x1; x1 = x2; x2 = sw;}
	if (y2 < y1) {sw = y1; y1 = y2; y2 = sw;}
	if (x2<0 || y2<0 || x1>=WIDTH || y1>=HEIGHT) return;

	if (SDL_MUSTLOCK(screen)) {if (SDL_LockSurface(screen) < 0) return;}

	r.x = x1;
	r.y = y1;
	r.w = x2 - x1 + 1;
	r.h = y2 - y1 + 1;
	SDL_FillRect(screen, &r, c);

	if (SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
}

int FileNameCmp(int f1, char *s1, int f2, char *s2)
{
	if (f1 == f2) return stricmp(s1, s2);
	else
	if (f1) return (-1);
	else return (1);
}

void DlgClearScreen(void)
{
	int i, j, cl;
	int *s, *p;

	if (SDL_MUSTLOCK(screen)) {if (SDL_LockSurface(screen) < 0) return;}
	s = (int *)screen->pixels;

	for (i = 0; i < HEIGHT; i++)
	{
		p = s;
		cl = (i & 1) ? DRGB(0,0,64) : DRGB(0,0,32);
		for (j = 0; j < WIDTH; j++) *(p++) = cl;
		s += PITCH;
	}

	if (SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
}

char* SelectFile(char *oldFile)
{
	int key;
	SDL_Event event;
	C_DirWork dw;
	static char path[MAX_PATH], ofl[MAX_FNAME+1];
	char fnames[MAX_FILES][MAX_FNAME+1], temp[MAX_FNAME+1];
	int i, j, filesCnt, folders[MAX_FILES], pos, csr, mx, gl, h, x, tmp;
	int scrEnd, keyx;
	bool isRoot;

	scrEnd = HEIGHT - font.Height() - 8;

	strcpy(ofl, C_DirWork::ExtractFileName(oldFile));
	strcpy(path, C_DirWork::ExtractPath(oldFile));
	strcpy(path, C_DirWork::Normalize(path));

	h = font.Height();
	mx = scrEnd / h;
	x = font.StrLenPx("[]");

	do
	{
		isRoot = !strcmp(path, "/");
		strcat(path, "*.*");
		filesCnt = 0;

		if (dw.EnumFiles(path))
		{
			do
			{
				if (strcmp(dw.name, "."))
				{
					if (strcmp(dw.name, "..") || !isRoot)
					{
						strcpy(fnames[filesCnt], dw.name);
						folders[filesCnt] = (dw.attr == DW_FOLDER);
						filesCnt++;
					}
				}
			} while (dw.EnumNext());

			dw.EnumClose();
		}

		if (filesCnt > 0)
		{
			if (strcmp(fnames[0], "..")) gl = 0; else gl = 1;
		} else gl = 0;

		for (i = gl; i < filesCnt-1; i++)
			for (j = i+1; j < filesCnt; j++)
			{
				if (FileNameCmp(folders[i], fnames[i], folders[j], fnames[j]) > 0)
				{
					strcpy(temp, fnames[i]);
					strcpy(fnames[i], fnames[j]);
					strcpy(fnames[j], temp);

					tmp = folders[i];
					folders[i] = folders[j];
					folders[j] = tmp;
				}
			}

		pos = 0;
		csr = 0;

		for (i = gl; i < filesCnt; i++)
		{
			if (!strcmp(ofl, fnames[i]))
			{
				csr = i;

				if (filesCnt > mx)
				{
					pos = csr - mx / 2;
					if (pos < 0) pos = 0;
				}

				break;
			}
		}

		if (filesCnt > mx) gl = mx; else gl = filesCnt;

		do
		{
			do
			{
				for (key = 0; SDL_PollEvent(&event);)
				{
					if (event.type == SDL_QUIT) exit(0);
					if (event.type == SDL_KEYDOWN) key = event.key.keysym.sym;
				}

				DlgClearScreen();
				Bar(0, scrEnd, WIDTH-1, HEIGHT-1, DRGB(0x80, 0x20, 0x20));

				switch (currentDrive)
				{
					case 0:
						font.PrintString(4, scrEnd+4, "<A> B C D");
						break;
					case 1:
						font.PrintString(4, scrEnd+4, "A <B> C D");
						break;
					case 2:
						font.PrintString(4, scrEnd+4, "A B <C> D");
						break;
					case 3:
						font.PrintString(4, scrEnd+4, "A B C <D>");
						break;
				}

				for (i = 0; i < gl; i++)
				{
					if (csr-pos == i) Bar(0, i*h, x+font.StrLenPx(fnames[i+pos])+x, i*h+h-1, DRGB(0x80, 0x20, 0x20));

					if (folders[i+pos]) font.PrintString(0, i*h, "[]");
					font.PrintString(x, i*h, fnames[i+pos]);
				}

				SDL_UpdateRect(screen, 0, 0, WIDTH, HEIGHT);
				SDL_Delay(10);
			} while (key == 0);

			if (key == SDLK_UP)
			{
				csr--;
				if (csr-pos < 0)
				{
					if (pos > 0) pos--;
					else csr++;
				}
			}
			else
			if (key == SDLK_DOWN)
			{
				csr++;
				if (csr-pos >= gl)
				{
					if (pos+gl < filesCnt) pos++;
					else csr--;
				}
			}
			else
			if (key == SDLK_HOME)
			{
				csr = 0;
				pos = 0;
			}
			else
			if (key == SDLK_END)
			{
				csr = filesCnt - 1;
				if (filesCnt > mx)
				{
					pos = filesCnt - mx;
				}
				else pos = 0;
			}
			else
			if (key == SDLK_PAGEUP)
			{
				pos -= mx;
				csr -= mx;
				if (pos < 0)
				{
					pos = 0;
					csr = 0;
				}
			}
			else
			if (key == SDLK_PAGEDOWN)
			{
				pos += mx;
				csr += mx;
				if (pos+gl > filesCnt)
				{
					if (filesCnt > mx)
					{
						csr = filesCnt - 1;
						pos = filesCnt - mx;
					}
					else
					{
						pos = 0;
						csr = filesCnt - 1;
					}
				}
			}
			else
			if (key == SDLK_LEFT)
			{
				currentDrive--;
				if (currentDrive < 0) currentDrive = 0;
			}
			else
			if (key == SDLK_RIGHT)
			{
				currentDrive++;
				if (currentDrive > 3) currentDrive = 3;
			}

		} while (key!=SDLK_RETURN && key!=SDLK_ESCAPE && key!=SDLK_BACKSPACE);

		do
		{
			SDL_Delay(1);
			for (keyx = 0; SDL_PollEvent(&event);)
			{
				if (event.type == SDL_QUIT) exit(0);
				if (event.type == SDL_KEYUP) keyx = event.key.keysym.sym;
			}
		} while (key != keyx);

		if (key == SDLK_BACKSPACE)
		{
			strcpy(ofl, C_DirWork::LastDirName(path));
			strcpy(path, C_DirWork::LevelUp(path));
		}
		else
		if (key == SDLK_RETURN)
		{
			if (folders[csr])
			{
				strcpy(ofl, C_DirWork::LastDirName(path));
				if (!strcmp(fnames[csr], "..")) strcpy(path, C_DirWork::LevelUp(path));
				else
				{
					strcpy(path, C_DirWork::ExtractPath(path));
					strcat(path, fnames[csr]);
					strcat(path, "/");
				}
			}
			else
			{
				strcpy(path, dw.ExtractPath(path));
				strcat(path, fnames[csr]);
				return path;
			}
		}
	} while (key != SDLK_ESCAPE);

	return NULL;
}

void FileDialog(void)
{
	char *fname;

	disableSound = true;

	SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
	fname = SelectFile(oldFileName);
	SDL_EnableKeyRepeat(0, SDL_DEFAULT_REPEAT_INTERVAL);

	if (fname != NULL) {
		strcpy(oldFileName, fname);
		TryNLoadFile(oldFileName, currentDrive);
	}

	disableSound = false;
}

void FileDialogInit(void)
{
	char *str;

	if (config.GetString("root/Drives/A", &str)) strcpy(oldFileName, str);
	else strcpy(oldFileName, "/");
}
