#include "sndcounter.h"

#ifdef SND_EXTERNAL_BUFFER

//#define SND_TEST_FAILURES // disable after careful debug

//#include "sndcounter.h"

void SNDCOUNTER::begin()
{
   n_samples = SND_EXTERNAL_BUFFER_SIZE;
}

void SNDCOUNTER::count(SNDRENDER &render)
{
   unsigned rendsamples = (render.dstpos - bufstart) & (SND_EXTERNAL_BUFFER_SIZE-1);
   if (rendsamples < n_samples) n_samples = rendsamples;
   #ifdef SND_TEST_FAILURES
   unsigned lastframe_samples = (render.dstpos - render.dst_start) & (SND_EXTERNAL_BUFFER_SIZE-1);
   if (lastframe_samples > rendsamples)
      errexit("SNDRENDER object is out of sync with other sound objects");
   #endif // SND_TEST_FAILURES
}

void SNDCOUNTER::end(bufptr_t &start_offset, unsigned &n_samples)
{
   start_offset = bufstart;
   n_samples = SNDCOUNTER::n_samples;
   bufstart = (bufstart + n_samples) & (SND_EXTERNAL_BUFFER_SIZE-1);
}

void SNDCOUNTER::reset()
{
   bufstart = 0;
}

#endif // SND_EXTERNAL_BUFFER
