/*

ZXMAK2 Device Plugin Example

USAGE: Compile, run ZXMAK2 and type OUT 3,111

*/
using System;
using System.Windows.Forms;
using ZXMAK2.Engine.Interfaces;
using ZXMAK2.Engine.Z80;


public class IO_Test : IBusDevice
{
	private Z80CPU m_cpu;

        public string Name { get { return "IO_Test"; } }
        public string Description { get { return "Type in BASIC: OUT 3,123 to see results ;)"; } }
        public BusCategory Category { get { return BusCategory.Other; } }
	private int m_busOrder = 0;
	public int BusOrder { get { return m_busOrder; } set { m_busOrder = value; } }

        public void BusInit(IBusManager bmgr)
        {
		// Register your bus handlers here
		m_cpu = bmgr.CPU;
		bmgr.SubscribeWRIO(0xFFFF, 0x0003, writePort0001);
        }

	public void BusConnect()
	{
		// Open your resources here (files, etc)
	}

        public void BusDisconnect()
        {
		// Close your resources here
        }

        private void writePort0001(ushort addr, byte value, ref bool iorqge)
        {
		if(!iorqge)
			return;
		iorqge=false;		// capture bus

		// This code will be called when (addr&0xFFFF)==0x0003
		// see method BusInit
		MessageBox.Show(string.Format(
			"OUT (#{0:X4}),{1} @ PC=#{2:X4}",
			addr,
			value,
			m_cpu.regs.PC), "IO_TEST");
        }
}
