;
; MCTEST2 - timing test by Alex Makeev
;

	device zxspectrum128
;------------------------------------------------------------------------------
	org	#8000
start:
	CALL		FILTER
	di
	ld		hl,#4000
	ld		de,#4001
	ld		bc,31
	ld		(hl),#55
	ldir
	ld		hl,#57E0
	ld		de,#57E1
	ld		bc,31
	ld		(hl),#55
	ldir

	ld		sp,#5800+768
	ld		c,12
fill0:
	ld		b,16
	ld		de,#7838
fill1:
	push	de
	djnz	fill1
	ld		b,16
	ld		de,#3878
fill2:
	push	de
	djnz	fill2
	dec		c
	jr		nz,fill0

	ld		sp,#A000

;--------------------
	ld		a,#FE
	ld		i,a
	ld		hl,#FE00
	push	hl
	pop		de
	inc		de
	ld		bc,256
	ld		(hl),#FF
	ldir
	ld		l,h
	ld		(hl),#C9
	im		2
frame:
	ld		hl,#0204	; 3 yellow, 4 white, 5 black
	ld		d,#01
	ld		c,#FE
	ld		b,23
	ld		a,11
	ld		e,b
	ei
	halt
loop1:					; 19T+10T here

	dec		b			; 4
	jp		z,switch	; 10

	out		(c),0		; 12  12
	out		(c),h		; 12  24
	out		(c),l		; 12  36
	out		(c),d		; 12  48
	out		(c),h		; 12  60
	out		(c),l		; 12  72
	out		(c),d		; 12  84
	out		(c),h		; 12  96
	out		(c),l		; 12  108
	out		(c),d		; 12  120
	out		(c),h		; 12  132
	out		(c),l		; 12  144
	out		(c),d		; 12  156
	out		(c),h		; 12  168
	out		(c),l		; 12  180
	;out		(c),h		; 12  192
	;out		(c),l		; 12  204
	nop
	nop
	nop
	nop
	nop
	jp		loop1		; 10T

switch:
	out		(c),0		; 12  12
	out		(c),h		; 12  24
	out		(c),l		; 12  36
	out		(c),d		; 12  48
	out		(c),h		; 12  60
	out		(c),l		; 12  72
	out		(c),d		; 12  84
	out		(c),h		; 12  96
	out		(c),l		; 12  108
	out		(c),d		; 12  120
	out		(c),h		; 12  132
	out		(c),l		; 12  144
	out		(c),d		; 12  156
	out		(c),h		; 12  168
	out		(c),l		; 12  180
	;out		(c),h		; 12  192
	;out		(c),l		; 12  204
	inc		h
	inc		l
	inc		d
	ld		b,e
	dec		a
	jp		nz,loop1		; 10T

	ld		a,0
	;inc		hl

	jp		frame

FILTER: 
	DI
	LD 	HL,INT
	LD 	(#81FF),HL
	LD 	A,0
	LD 	(BUFF+4),A
	LD 	E,1
	LD 	HL,BUFF
	LD 	A,#81
	LD 	I,A
	IM 	2
	EI
	HALT

	CALL 	WAIT
	INC 	E
	CALL 	WAIT
	INC 	E
	CALL 	WAIT
	INC 	E
	DI

	LD 	BC,2749
	LD 	HL,(BUFF+1)
	EX 	DE,HL
	LD 	HL,(BUFF+3)
	LD 	A,H
	OR 	A
	JR 	NZ,F2

F0: 
	LD 	A,L
	CP 	4
	JR 	Z,DISP3
	LD 	A,D
	CP 	L
	JR 	Z,DISP2
	LD 	A,E
	CP 	D
	JR 	Z,DISP1
DISP0:
	NOP
	LD 	R,A
	LD 	R,A
F1:
	DEC 	BC
	LD 	A,B
	OR 	C
	JR 	NZ,F1
	RET
F2:
	LD 	E,D
	LD 	D,L
	LD 	L,H
	DEC 	BC
	DEC 	BC
	LD 	A,(HL)
	NOP
	JR 	F0
DISP1: 
	DEC 	BC
	NOP
	JR 	DISP0
DISP2: 
	JR 	DISP0

DISP3: 
	LD 	R,A
	LD 	A,(HL)
	JR 	DISP0
WAIT:
	LD 	BC,2753
W1: 
	DEC 	BC
	LD 	A,B
	OR 	C
	JR 	NZ,W1
	LD 	B,(HL)
	RET
INT: 
	LD 	(HL),E
	INC 	HL
	LD 	D,(HL)
	LD 	D,(HL)
	EI
	RET
BUFF: 
	DEFS 	5

;------------------------------------------------------------------------------
	;savesna "mctest2.sna",start
	emptytrd "mctest2.trd"
	savetrd "mctest2.trd", "mctest2.C", start, $-start
