unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtDlgs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ImgPalette: TImage;
    ImgPlane0: TImage;
    ImgPlane1: TImage;
    Button1: TButton;
    OpenPictureDialog1: TOpenPictureDialog;
    Memo1: TMemo;
    Panel1: TPanel;
    Panel2: TPanel;
    ImgPalette16: TImage;
    SelectColorMode: TComboBox;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    SelectScreenMode: TComboBox;
    Img16cbig: TImage;
    ImgInput: TImage;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  t_conv_pall = record
    color: TColor;
    zx:array[0..1] of byte;
    b:array[0..1] of byte;
    end;
  t_opcode = record
    jp_l:byte;
    jp_h:byte;
    t:byte;
    end;
var
  Form1: TForm1;
  progdir:string;
  f:file of byte;
  conv_pall: array[0..101] of t_conv_pall;

  x2size:byte;

  cp_index:integer;
  lx,ly,scr_4,scr_lr,tmp_byte0,tmp_byte1:byte;
  tmp_color:TColor;
  tbmp:TBitmap;
  color_mask:TColor;
  plane:array[0..3,0..7999]of byte;
  plane0:array[0..3,0..7999]of byte;
  plane1:array[0..3,0..7999]of byte;  
  con16c_color:array[0..15]of byte=(0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7);
  con16c_bright:array[0..15]of byte=(0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1);
implementation

{$R *.dfm}

//=======================================================
//  
//=======================================================
procedure ClearImg();
begin
Form1.ImgPlane0.Canvas.Brush.Color:=clBlack;
Form1.ImgPlane0.Canvas.FillRect(Rect(0,0,320,200));
Form1.ImgPlane1.Canvas.Brush.Color:=clBlack;
Form1.ImgPlane1.Canvas.FillRect(Rect(0,0,320,200));
Form1.ImgInput.Canvas.Brush.Color:=clBlack;
Form1.ImgInput.Canvas.FillRect(Rect(0,0,320,200));
end;
//=======================================================
//  
//=======================================================
//---------- conv 16c
function Conv16c(x,y:integer):byte;
var tempcolor:TColor;
  b:integer;
  retbyte:byte;
begin
retbyte:=0;
if (Form1.SelectColorMode.ItemIndex=1) then
  begin
  //  16 x
  b:=0;
  tempcolor:=TColor(Form1.ImgInput.Canvas.Pixels[x,y]);
  While ((Form1.ImgPalette16.Canvas.Pixels[b,0]<>tempcolor) and (b<17)) do Inc(b);
  if (b=16) then b:=0;
  if (b=17) then //  
    begin
    b:=0;
    Form1.Memo1.Lines.Add('Color not found x='+inttostr(x)+' y='+inttostr(y));
    end;
    retbyte:=con16c_color[b]+64*con16c_bright[b];
  //  16 x+1
  b:=0;
  tempcolor:=TColor(Form1.ImgInput.Canvas.Pixels[x+1,y]);
  While ((Form1.ImgPalette16.Canvas.Pixels[b,0]<>tempcolor) and (b<17)) do Inc(b);
  if (b=16) then b:=0;
  if (b=17) then //  
    begin
    b:=0;
    Form1.Memo1.Lines.Add('Color not found x='+inttostr(x+1)+' y='+inttostr(y));
    end;
    retbyte:=retbyte+8*con16c_color[b]+128*con16c_bright[b];
  end;
Conv16c:=retbyte;
end;
//---------- conv giga
function ConvGiga(pl,x,y:integer):byte;
begin
end;
//=======================================================
//  
//=======================================================
procedure Convert();
var i,x,y,p:integer;
f:file of byte;
nol:byte;
begin
for p:=0 to 3 do
  for y:=0 to 199 do
    for x:=0 to 39 do
      begin
      i:=p*2+x*8;
      //  
      plane[p,y*40+x]:=Conv16c(i,y);
      end;
//--- save sprite
nol:=0;
AssignFile(f,'scr_page0.bin'); ReWrite(f);
for i:=0 to 7999 do Write(f,plane[0,i]);
for i:=0 to 191 do Write(f,nol);
for i:=0 to 7999 do Write(f,plane[2,i]);
for i:=0 to 191 do Write(f,nol);
Close(f);
AssignFile(f,'scr_page1.bin'); ReWrite(f);
for i:=0 to 7999 do Write(f,plane[1,i]);
for i:=0 to 191 do Write(f,nol);
for i:=0 to 7999 do Write(f,plane[3,i]);
for i:=0 to 191 do Write(f,nol);
Close(f);
end;
//=======================================================
//       
//=======================================================
procedure TForm1.Button1Click(Sender: TObject);
begin
ClearImg();
Form1.Memo1.Lines.Clear;
Application.ProcessMessages;
//---------------------------  
if (OpenPictureDialog1.Execute) then
  begin
  ImgInput.Picture.LoadFromFile(OpenPictureDialog1.FileName);
  Memo1.Lines.Add('Converting image:');
  Application.ProcessMessages;
  Convert();
  Form1.Memo1.Lines.Add('');
  Form1.Memo1.Lines.Add('Complete.');
  end;
end;
//=======================================================
//   gigascreen
//=======================================================
procedure CreatePaletteGiga();
var x,y:integer;
begin
conv_pall[0].color:=rgb(0,0,0);
conv_pall[0].zx[0]:=0; conv_pall[0].zx[1]:=0;
conv_pall[0].b[0]:=0; conv_pall[0].b[1]:=0;
cp_index:=1;
for y:=0 to 15 do
  begin
  for x:=0 to 15 do
    begin
    tmp_color:=Form1.ImgPalette.Picture.Bitmap.Canvas.Pixels[x,y];
    //       
    if (tmp_color<>TColor(rgb(0,0,0))) then
      begin
      conv_pall[cp_index].color:=tmp_color;
      conv_pall[cp_index].zx[0]:=trunc(x/2);
      conv_pall[cp_index].zx[1]:=trunc(y/2);
      conv_pall[cp_index].b[0]:=x-2*trunc(x/2);
      conv_pall[cp_index].b[1]:=y-2*trunc(y/2);
      Inc(cp_index);
      end;
    end; //x cycle
  end; //y cycle
end;
//=======================================================
//    16c
//=======================================================
procedure LoadPalette16c(filename:string);
begin
Form1.ImgPalette16.Picture.LoadFromFile(filename);
end;
procedure CreatePalette16big();
var i:integer;
begin
color_mask:=TColor(Form1.ImgPalette16.Canvas.Pixels[16,0]);
for i:=0 to 16 do Form1.Img16cbig.Canvas.CopyRect(Rect(i*16,0,(i+1)*16,16),Form1.ImgPalette16.Canvas,Rect(i,0,i+1,1));
end;
//=======================================================
//  
//=======================================================
procedure TForm1.FormCreate(Sender: TObject);
begin
progdir:=GetCurrentDir();
CreatePaletteGiga();
LoadPalette16c(progdir+'/16c_pall.bmp');
CreatePalette16big();
ClearImg();
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if (Form1.OpenPictureDialog1.Execute) then
  begin
  CopyFile(PChar(Form1.OpenPictureDialog1.Filename),PChar(progdir+'/16c_pall.bmp'),FALSE);
  LoadPalette16c(progdir+'/16c_pall.bmp');
CreatePalette16big();
ClearImg();
  end;
end;

end.
