unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtDlgs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ImgPalette: TImage;
    ImgPlane0R: TImage;
    ImgPlane1R: TImage;
    Button1: TButton;
    OpenPictureDialog1: TOpenPictureDialog;
    Memo1: TMemo;
    ImgInputR: TImage;
    ImgPlane0L: TImage;
    ImgPlane1L: TImage;
    ImgInputL: TImage;
    Panel1: TPanel;
    Panel2: TPanel;
    ImgMaskR: TImage;
    ImgMaskL: TImage;
    ImgPalette16: TImage;
    SelectColorMode: TComboBox;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    SelectScreenMode: TComboBox;
    Memo2: TMemo;
    Img16cbig: TImage;
    ImgInput: TImage;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  t_conv_pall = record
    color: TColor;
    zx:array[0..1] of byte;
    b:array[0..1] of byte;
    end;
  t_opcode = record
    jp_l:byte;
    jp_h:byte;
    t:byte;
    end;
var
  Form1: TForm1;
  progdir:string;
  f:file of byte;
  conv_pall: array[0..101] of t_conv_pall;

  x2size:byte;
  opcode:array [0..511] of t_opcode;
  op_ln:integer=256+64+16+4;
  op_lnblank:integer=256+64+16+4+1;
  op_ret:integer=256+64+16+4+2;  

  planedx:array[0..3] of byte;

  cp_index:integer;
  xwidth,xheight,sprlen:integer;
  lx,ly,scr_4,scr_lr,tmp_byte0,tmp_byte1:byte;
  tmp_color:TColor;
  tbmp:TBitmap;

  color_mask:TColor;
  maskarr:array[0..7]of byte = (1,2,4,8,16,32,64,128);

  mask:array[0..6911]of byte;
  mask_len:integer;
  spr,spr0,spr1:array[0..6911]of byte;
  spr_len:integer;
  takts:dword;

  con16c_color:array[0..15]of byte=(0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7);
  con16c_bright:array[0..15]of byte=(0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1);
implementation

{$R *.dfm}

//=======================================================
//  
//=======================================================
procedure ClearImg();
begin
Form1.ImgPlane0R.Canvas.Brush.Color:=color_mask;
Form1.ImgPlane0R.Canvas.FillRect(Rect(0,0,95,95));
Form1.ImgPlane1R.Canvas.Brush.Color:=color_mask;
Form1.ImgPlane1R.Canvas.FillRect(Rect(0,0,95,95));
Form1.ImgInputR.Canvas.Brush.Color:=color_mask;
Form1.ImgInputR.Canvas.FillRect(Rect(0,0,95,95));
Form1.ImgPlane0L.Canvas.Brush.Color:=color_mask;
Form1.ImgPlane0L.Canvas.FillRect(Rect(0,0,95,95));
Form1.ImgPlane1L.Canvas.Brush.Color:=color_mask;
Form1.ImgPlane1L.Canvas.FillRect(Rect(0,0,95,95));
Form1.ImgInputL.Canvas.Brush.Color:=color_mask;
Form1.ImgInputL.Canvas.FillRect(Rect(0,0,95,95));
end;
//=======================================================
//  
//=======================================================
//---------- conv 16c
function Conv16c(x,y:integer):byte;
var tempcolor:TColor;
  b:integer;
  retbyte:byte;
begin
retbyte:=0;
if (Form1.SelectColorMode.ItemIndex=1) then
  begin
  //  16 x
  b:=0;
  tempcolor:=TColor(Form1.ImgInput.Canvas.Pixels[x,y]);
  While ((Form1.ImgPalette16.Canvas.Pixels[b,0]<>tempcolor) and (b<17)) do Inc(b);
  if (b=16) then b:=0;
  if (b=17) then //  
    begin
    b:=0;
    Form1.Memo1.Lines.Add('Color not found x='+inttostr(x)+' y='+inttostr(y));
    end;
    retbyte:=con16c_color[b]+64*con16c_bright[b];
  //  16 x+1
  b:=0;
  tempcolor:=TColor(Form1.ImgInput.Canvas.Pixels[x+1,y]);
  While ((Form1.ImgPalette16.Canvas.Pixels[b,0]<>tempcolor) and (b<17)) do Inc(b);
  if (b=16) then b:=0;
  if (b=17) then //  
    begin
    b:=0;
    Form1.Memo1.Lines.Add('Color not found x='+inttostr(x+1)+' y='+inttostr(y));
    end;
    retbyte:=retbyte+8*con16c_color[b]+128*con16c_bright[b];
  end;
Conv16c:=retbyte;
end;
//---------- conv giga
function ConvGiga(pl,x,y:integer):byte;
begin
end;
//=======================================================
//  
//=======================================================
procedure Convert(direct:byte);
var i,x,y,px,plane,temp_mask:byte;
j:integer;
f:file of byte;
fname_mask,fname_spr:string;
begin
if (direct=0) then
  begin
  Form1.Memo1.Lines.Add('');  
  Form1.Memo1.Lines.Add('Converting Right sprite...');
  fname_mask:='mask_r'; fname_spr:='sprite_r';
  Form1.ImgInput.Canvas.CopyRect(Rect(0,0,96,96),Form1.ImgInputR.Canvas,Rect(0,0,96,96));
  Form1.ImgInput.Refresh;
  Form1.ImgInput.Repaint;
  Application.ProcessMessages;
  end
else
  begin
  Form1.Memo1.Lines.Add('');
  Form1.Memo1.Lines.Add('Converting Left sprite...');
  fname_mask:='mask_l'; fname_spr:='sprite_l';
  Form1.ImgInput.Canvas.CopyRect(Rect(0,0,96,96),Form1.ImgInputL.Canvas,Rect(0,0,96,96));
  Form1.ImgInput.Refresh;
  Form1.ImgInput.Repaint;
  Application.ProcessMessages;
  end;
 //---
 takts:=0; mask_len:=0; spr_len:=0;
 for plane:=0 to 3 do
 begin
 mask[mask_len]:=40-planedx[plane]; Inc(mask_len);
 mask[mask_len]:=40-4*trunc(planedx[plane]/4); Inc(mask_len);
 Form1.Memo2.Lines.Add('--------------------- PLANE '+inttostr(plane));
   for y:=0 to xheight-1 do
    begin
    px:=planedx[plane];
    While (px>0) do
    begin
       //--------------- 4 byte
    if (px>=4) then
    begin
         //   -  plane*2  2    8
    temp_mask:=0;
         x:=plane*2+trunc(planedx[plane]-px)*8;
         for i:=0 to 3 do
           begin
           if (Form1.ImgInput.Canvas.Pixels[x+i*8+1,y]<>color_mask) then temp_mask:=temp_mask+maskarr[i*2];
           if (Form1.ImgInput.Canvas.Pixels[x+i*8,y]<>color_mask) then temp_mask:=temp_mask+maskarr[i*2+1];
           if ((Form1.ImgInput.Canvas.Pixels[x+i*8+1,y]<>color_mask) or (Form1.ImgInput.Canvas.Pixels[x+i*8,y]<>color_mask)) then
             begin //   
             spr[spr_len]:=Conv16c(x+i*8,y);
             spr0[spr_len]:=ConvGiga(0,x+i*8,y);
             spr1[spr_len]:=ConvGiga(1,x+i*8,y);
             inc(spr_len);
             end;
           end;
         // 
         mask[mask_len]:=opcode[temp_mask].jp_l; inc(mask_len);
         mask[mask_len]:=opcode[temp_mask].jp_h; inc(mask_len);
         takts:=takts+opcode[temp_mask].t;
         Form1.Memo2.Lines.Add('4_b'+#09+inttostr(temp_mask)+#09+inttostr(opcode[temp_mask].t));
    px:=px-4;
         if (px=0) then // 
           begin
           mask[mask_len]:=opcode[op_ln].jp_l; inc(mask_len);
           mask[mask_len]:=opcode[op_ln].jp_h; inc(mask_len);
           takts:=takts+opcode[op_ln].t;
           Form1.Memo2.Lines.Add('ln'+#09+'-'+#09+inttostr(opcode[op_ln].t));
           end;
    end
       //--------------- 3 byte
    else if (px=3) then
    begin
         //   -  plane*2  2    8
    temp_mask:=0;
         x:=plane*2+trunc(planedx[plane]-px)*8;
         for i:=0 to 2 do
           begin
           if (Form1.ImgInput.Canvas.Pixels[x+i*8+1,y]<>color_mask) then temp_mask:=temp_mask+maskarr[i*2];
           if (Form1.ImgInput.Canvas.Pixels[x+i*8,y]<>color_mask) then temp_mask:=temp_mask+maskarr[i*2+1];
           if ((Form1.ImgInput.Canvas.Pixels[x+i*8+1,y]<>color_mask) or (Form1.ImgInput.Canvas.Pixels[x+i*8,y]<>color_mask)) then
             begin //   
             spr[spr_len]:=Conv16c(x+i*8,y);
             spr0[spr_len]:=ConvGiga(0,x+i*8,y);
             spr1[spr_len]:=ConvGiga(1,x+i*8,y);
             inc(spr_len);
             end;
           end;
         // 
         if (temp_mask<>0) then
         begin
           mask[mask_len]:=opcode[256+temp_mask].jp_l; inc(mask_len);
           mask[mask_len]:=opcode[256+temp_mask].jp_h; inc(mask_len);
           takts:=takts+opcode[256+temp_mask].t;
           Form1.Memo2.Lines.Add('3_b_ln'+#09+inttostr(temp_mask)+#09+inttostr(opcode[256+temp_mask].t));
           end
         else
           begin
           mask[mask_len]:=opcode[op_lnblank].jp_l; inc(mask_len);
           mask[mask_len]:=opcode[op_lnblank].jp_h; inc(mask_len);
           takts:=takts+opcode[op_lnblank].t;
           Form1.Memo2.Lines.Add('3_b_lnb'+#09+inttostr(temp_mask)+#09+inttostr(opcode[op_lnblank].t));
           end;
    px:=px-3;
    end
       //--------------- 2 byte
    else if (px=2) then
    begin
         //   -  plane*2  2    8
    temp_mask:=0;
         x:=plane*2+trunc(planedx[plane]-px)*8;
         for i:=0 to 1 do
           begin
           if (Form1.ImgInput.Canvas.Pixels[x+i*8+1,y]<>color_mask) then temp_mask:=temp_mask+maskarr[i*2];
           if (Form1.ImgInput.Canvas.Pixels[x+i*8,y]<>color_mask) then temp_mask:=temp_mask+maskarr[i*2+1];
           if ((Form1.ImgInput.Canvas.Pixels[x+i*8+1,y]<>color_mask) or (Form1.ImgInput.Canvas.Pixels[x+i*8,y]<>color_mask)) then
             begin //   
             spr[spr_len]:=Conv16c(x+i*8,y);
             spr0[spr_len]:=ConvGiga(0,x+i*8,y);
             spr1[spr_len]:=ConvGiga(1,x+i*8,y);
             inc(spr_len);
             end;
           end;
         // 
         if (temp_mask<>0) then
         begin
         mask[mask_len]:=opcode[64+256+temp_mask].jp_l; inc(mask_len);
         mask[mask_len]:=opcode[64+256+temp_mask].jp_h; inc(mask_len);
         takts:=takts+opcode[64+256+temp_mask].t;
         Form1.Memo2.Lines.Add('2_b_ln'+#09+inttostr(temp_mask)+#09+inttostr(opcode[64+256+temp_mask].t));
           end
         else
           begin
           mask[mask_len]:=opcode[op_lnblank].jp_l; inc(mask_len);
           mask[mask_len]:=opcode[op_lnblank].jp_h; inc(mask_len);
           takts:=takts+opcode[op_lnblank].t;
           Form1.Memo2.Lines.Add('2_b_lnb'+#09+inttostr(temp_mask)+#09+inttostr(opcode[op_lnblank].t));
           end;
    px:=px-2;
    end
       //--------------- 1 byte
    else if (px=1) then
    begin
         //   -  plane*2  2    8
    temp_mask:=0;
         x:=plane*2+trunc(planedx[plane]-px)*8;
         if (Form1.ImgInput.Canvas.Pixels[x+1,y]<>color_mask) then temp_mask:=temp_mask+maskarr[0];
         if (Form1.ImgInput.Canvas.Pixels[x,y]<>color_mask) then temp_mask:=temp_mask+maskarr[1];
         if ((Form1.ImgInput.Canvas.Pixels[x+1,y]<>color_mask) or (Form1.ImgInput.Canvas.Pixels[x,y]<>color_mask)) then
           begin //   
           spr[spr_len]:=Conv16c(x,y);
           spr0[spr_len]:=ConvGiga(0,x,y);
           spr1[spr_len]:=ConvGiga(1,x,y);
           inc(spr_len);
           end;
         // 
         if (temp_mask<>0) then
         begin
         mask[mask_len]:=opcode[16+64+256+temp_mask].jp_l; inc(mask_len);
         mask[mask_len]:=opcode[16+64+256+temp_mask].jp_h; inc(mask_len);
         takts:=takts+opcode[16+64+256+temp_mask].t;
         Form1.Memo2.Lines.Add('1_b_ln'+#09+inttostr(temp_mask)+#09+inttostr(opcode[16+64+256+temp_mask].t));
           end
         else
           begin
           mask[mask_len]:=opcode[op_lnblank].jp_l; inc(mask_len);
           mask[mask_len]:=opcode[op_lnblank].jp_h; inc(mask_len);
           takts:=takts+opcode[op_lnblank].t;
           Form1.Memo2.Lines.Add('1_b_lnb'+#09+inttostr(temp_mask)+#09+inttostr(opcode[op_lnblank].t));
           end;
    px:=px-1;
    end;
       //px cycle
       end;
     //y cycle
    end;
 mask[mask_len]:=opcode[op_ret].jp_l; inc(mask_len);
 mask[mask_len]:=opcode[op_ret].jp_h; inc(mask_len);
 takts:=takts+opcode[op_ret].t;
 Form1.Memo2.Lines.Add('ret'+#09+' '+#09+inttostr(opcode[op_ret].t));
 //plane cycle
 end;
Form1.Memo1.Lines.Add('takts: '+inttostr(takts));
Form1.Memo1.Lines.Add('mask size: '+inttostr(mask_len));
Form1.Memo1.Lines.Add('spr size: '+inttostr(spr_len));
Form1.Memo1.Lines.Add('total size 16c: '+inttostr(mask_len+spr_len));
Form1.Memo1.Lines.Add('total size giga: '+inttostr(mask_len+spr_len*2));
//--- save sprite
AssignFile(f,fname_mask+'.bin'); ReWrite(f);
for j:=0 to mask_len-1 do
  begin
  Write(f,mask[j]);
  end;
Close(f);
AssignFile(f,fname_spr+'.bin'); ReWrite(f);
for j:=0 to spr_len-1 do
  begin
  Write(f,spr[j]);
  end;
Close(f);
end;
//=======================================================
//       
//=======================================================
procedure TForm1.Button1Click(Sender: TObject);
var x,y:integer;
begin
ClearImg();
Form1.Memo1.Lines.Clear;
Form1.Memo2.Lines.Clear;
Application.ProcessMessages;
//---------------------------  
tbmp:=TBitmap.Create;
OpenPictureDialog1.Execute;
tbmp.LoadFromFile(OpenPictureDialog1.FileName);
xwidth:=tbmp.Width; xheight:=tbmp.Height;
ImgInputR.Canvas.CopyRect(Rect(0,0,width-1,height-1),tbmp.Canvas,Rect(0,0,width-1,height-1));
tbmp.Free;
Memo1.Lines.Add('Input image size:');
Memo1.Lines.Add(' - width: '+inttostr(xwidth));
Memo1.Lines.Add(' - height: '+inttostr(xheight));
//   
planedx[0]:=0;While((planedx[0]*8+0)<xwidth)do inc(planedx[0]);
planedx[1]:=0;While((planedx[1]*8+2)<xwidth)do inc(planedx[1]);
planedx[2]:=0;While((planedx[2]*8+4)<xwidth)do inc(planedx[2]);
planedx[3]:=0;While((planedx[3]*8+6)<xwidth)do inc(planedx[3]);
Memo1.Lines.Add(' ');
Memo1.Lines.Add('Planes width:');
Memo1.Lines.Add('plane0_x_len: '+inttostr(planedx[0]));
Memo1.Lines.Add('plane1_x_len: '+inttostr(planedx[1]));
Memo1.Lines.Add('plane2_x_len: '+inttostr(planedx[2]));
Memo1.Lines.Add('plane3_x_len: '+inttostr(planedx[3]));
Application.ProcessMessages;
//---------------------------   
for y:=0 to xheight-1 do
  for x:=0 to xwidth-1 do
    begin
    tmp_color:=ImgInputR.Picture.Bitmap.Canvas.Pixels[x,y];
    ImgInputL.Canvas.Pixels[xwidth-x-1,y]:=tmp_color;
    end;
Convert(0); //right
Convert(1); //left
Form1.Memo1.Lines.Add('');
Form1.Memo1.Lines.Add('Complete.');
end;
//=======================================================
//   gigascreen
//=======================================================
procedure CreatePaletteGiga();
var x,y:integer;
begin
conv_pall[0].color:=rgb(0,0,0);
conv_pall[0].zx[0]:=0; conv_pall[0].zx[1]:=0;
conv_pall[0].b[0]:=0; conv_pall[0].b[1]:=0;
cp_index:=1;
for y:=0 to 15 do
  begin
  for x:=0 to 15 do
    begin
    tmp_color:=Form1.ImgPalette.Picture.Bitmap.Canvas.Pixels[x,y];
    //       
    if (tmp_color<>TColor(rgb(0,0,0))) then
      begin
      conv_pall[cp_index].color:=tmp_color;
      conv_pall[cp_index].zx[0]:=trunc(x/2);
      conv_pall[cp_index].zx[1]:=trunc(y/2);
      conv_pall[cp_index].b[0]:=x-2*trunc(x/2);
      conv_pall[cp_index].b[1]:=y-2*trunc(y/2);
      Inc(cp_index);
      end;
    end; //x cycle
  end; //y cycle
end;
//=======================================================
//    16c
//=======================================================
procedure LoadPalette16c(filename:string);
begin
Form1.ImgPalette16.Picture.LoadFromFile(filename);
end;
procedure CreatePalette16big();
var i:integer;
begin
color_mask:=TColor(Form1.ImgPalette16.Canvas.Pixels[16,0]);
for i:=0 to 16 do Form1.Img16cbig.Canvas.CopyRect(Rect(i*16,0,(i+1)*16,16),Form1.ImgPalette16.Canvas,Rect(i,0,i+1,1));
end;
//=======================================================
//  
//=======================================================
procedure TForm1.FormCreate(Sender: TObject);
var i: integer;
begin
progdir:=GetCurrentDir();
CreatePaletteGiga();
LoadPalette16c(progdir+'/16c_pall.bmp');
CreatePalette16big();
ClearImg();
//-------------------   
AssignFile(f,'table.bin');
Reset(f);
for i:=0 to 256+64+16+4+2 do
  begin
  Read (f,opcode[i].jp_l);
  Read (f,opcode[i].jp_h);
  Read (f,opcode[i].t);
  end;
CloseFile(f);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if (Form1.OpenPictureDialog1.Execute) then
  begin
  CopyFile(PChar(Form1.OpenPictureDialog1.Filename),PChar(progdir+'/16c_pall.bmp'),FALSE);
  LoadPalette16c(progdir+'/16c_pall.bmp');
CreatePalette16big();
ClearImg();
  end;
end;

end.
