//---------------------------
	DEVICE	ZXSPECTRUM128
//---------------------------
	ORG	#5D3B	;basic
	INCBIN "BASIC.B"
BASIC_END
	ORG	#5D42	;correct clear sp (#BE00)
	DB	"48640"
	;---
	ORG	#5D4D	;correct_usr_adr
	DB	"23893"
	;---
	ORG	#5D55	;basic_code
	;--
	LD	A,#10
	LD	BC,#7FFD
	OUT	(C),A
	;--
	LD	HL,#8000	;load game code
	LD	DE,#0102
	LD	B,(END_8000-#8000)/256+1
	LD	C,#05
	CALL	#3D13
	;--
	JP	#8000
END_CODE
ALL_LEN=END_CODE-#5D3B
	DISPLAY	/A,ALL_LEN
;----------------------------------------------
	ORG	#8000
	CALL	LOADCAT		; 
	;---
	LD	HL,#BE00	;load himem #be00
	CALL	LOAD
	DB	"BE00    "
	;--
	LD	A,0
	CALL	LOADPAGE
	DB	"PAGE0   "
	;--
	LD	A,12
	CALL	LOADPAGE
	DB	"PAGE12  "
	;--
	LD	A,13
	CALL	LOADPAGE
	DB	"PAGE13  "
	;--
	LD	A,16
	CALL	LOADPAGE
	DB	"PAGE16  "
	;--
	LD	A,17
	CALL	LOADPAGE
	DB	"PAGE17  "
	;-------------------
	CALL	SET_IM2
	XOR	A
	CALL	PAGER0
	CALL	INI_TBL
	CALL	XSPR_INIT
	;----------------------- title screen
	CALL	CLEARSCR
	CALL	TITLE_SCR
	CALL	SHOWSCR0
	CALL	TITLE_ANYKEY
	LD	HL,#400F+40*190
	LD	BC,#0B08
	CALL	CLRSPR
	CALL	FADESCR
	;----------------------- mode screen (1vs1 mode / tournament)
	LD	HL,S_1VS1MODE
	LD	DE,#400F+40*80
	LD	IY,#0709
	CALL	PUTSPR
	LD	HL,S_TOURNAMENT
	LD	DE,#400F+40*90
	LD	IY,#0709
	CALL	PUTSPR
	EI
	HALT
	LD	HL,S_ARR_R
	LD	DE,#400E+40*79
	LD	IY,#0901
	CALL	PUTSPR
	LD	HL,S_ARR_L
	LD	DE,#400F+40*79+9
	LD	IY,#0901
	CALL	PUTSPR
	;-----------------------
	CALL	SELECT_SCR
XXX	;-- frame 1
	EI
	HALT
	LD	BC,#7FFD	
	LD	A,#10
	OUT	(C),A
	CALL	P1_WOST
	CALL	P2_WOST
	CALL	P1_OUT
	CALL	P2_OUT
	;-- frame 2
	EI
	HALT
	LD	BC,#7FFD	
	LD	A,#18
	OUT	(C),A
	CALL	P1_WOST1
	CALL	P2_WOST1
	CALL	P1_OUT1
	CALL	P2_OUT1
	;--------------
	CALL	DO_IDLE_1
	CALL	DO_IDLE_2
	;--------------     
	;--------------
	JP	XXX
//================================================
//   
//================================================
P1_WOST1
	LD	IY,(P1_X4_OLD)
	LD	A,LY
	ADD	A,64
	LD	LY,A
	JP	P12WOST
P1_WOST	LD	IY,(P1_X4_OLD)
P12WOST	LD	DE,(P1_SCR_OLD)
	LD	A,(P1_X_SIZE_OLD)
	OR	A
	RET	Z
	;--
	LD	A,(P1_X_SIZE_OLD)
	LD	HL,WOST40
	CP	5
	JP	Z,P11WOST
	LD	HL,WOST48
P11WOST	PUSH	HL
	;--
	LD	A,(P1_Y_UP_OLD)
	LD	HL,P1_Y
	SUB	(HL)
	INC	A
	RET
P2_WOST1 ;--------------------
	LD	IY,(P2_X4_OLD)
	LD	A,LY
	ADD	A,64
	LD	LY,A
	JP	P22WOST
P2_WOST	LD	IY,(P2_X4_OLD)
P22WOST	LD	DE,(P2_SCR_OLD)
	LD	A,(P2_X_SIZE_OLD)
	OR	A
	RET	Z
	;--
	LD	A,(P2_X_SIZE_OLD)
	LD	HL,WOST40
	CP	5
	JP	Z,P21WOST
	LD	HL,WOST48
P21WOST	PUSH	HL
	;--
	LD	A,(P2_Y_UP_OLD)
	LD	HL,P2_Y
	SUB	(HL)
	INC	A
	RET
//------------------------------
//     :
//	IY-   X4
//	DE-  
//	A-  
//------------------------------
WOST40
	LD	(W40S),DE
	LD	(W40DY),A
	EXX
	LD	A,(IY+0)
	LD	E,(IY+4)
	LD	D,(IY+5)
	LD	C,(IY+12)
	CALL	W40
	LD	A,(IY+1)
	LD	E,(IY+6)
	LD	D,(IY+7)
	LD	C,(IY+13)
	CALL	W40
	LD	A,(IY+2)
	LD	E,(IY+8)
	LD	D,(IY+9)
	LD	C,(IY+14)
	CALL	W40
	LD	A,(IY+3)
	LD	E,(IY+10)
	LD	D,(IY+11)
	LD	C,(IY+15)
W40	;---
	CALL	PAGER1
	LD	A,C
	CALL	PAGER3
	LD	HL,0
W40S	EQU	$-2
	ADD	HL,DE
	LD	D,H
	LD	E,L
	SET	7,H
	LD	LX,48
W40DY	EQU	$-1
W40_1	DUP	5
	LDI
	EDUP
	LD	BC,40-5
	ADD	HL,BC
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	LX
	JP	NZ,W40_1
	RET
;-------------------------
WOST48	LD	(W48S),DE
	LD	(W48DY),A
	EXX
	LD	A,(IY+0)
	LD	E,(IY+4)
	LD	D,(IY+5)
	LD	C,(IY+12)
	CALL	W48
	LD	A,(IY+1)
	LD	E,(IY+6)
	LD	D,(IY+7)
	LD	C,(IY+13)
	CALL	W48
	LD	A,(IY+2)
	LD	E,(IY+8)
	LD	D,(IY+9)
	LD	C,(IY+14)
	CALL	W48
	LD	A,(IY+3)
	LD	E,(IY+10)
	LD	D,(IY+11)
	LD	C,(IY+15)
W48	;---
	CALL	PAGER1
	LD	A,C
	CALL	PAGER3
	LD	HL,0
W48S	EQU	$-2
	ADD	HL,DE
	LD	D,H
	LD	E,L
	SET	7,H
	LD	A,48
W48DY	EQU	$-1
W48_1	DUP	6
	LDI		;16*6=96
	EDUP
	LD	BC,40-6	;10
	ADD	HL,BC	;15
	LD	D,H	;4
	LD	E,L	;4
	RES	7,D	;8
	DEC	A	;4
	JP	NZ,W48_1 ;10 //151*48=7248*4=28992
	RET
//================================================
//   
//================================================
P1_OUT1	LD	HL,P1_X_SIZE
	LD	DE,P1_X_SIZE_OLD
	LD	BC,OLD_LEN
	LDIR
	;--
	LD	A,(P1_SPRPAGE)
	CALL	PAGER3
	LD	DE,(P1_SCR)
	LD	IY,(P1_X4)
	LD	A,LY
	ADD	A,64
	LD	LY,A
	LD	BC,(P1_MASKADR)
	LD	HL,(P1_SPRADR)
	JP	XSPROUT
	;--------------
P1_OUT	LD	IX,(P1_NSPR) ;   
	LD	A,LX
	ADD	A,A
	LD	LX,A
	;--
	LD	A,(IX+0)	;set sprite page [3]
	LD	(P1_SPRPAGE),A
	CALL	PAGER3
	;--
	LD	H,TBL_Y/256	;DE=scr_adr_y
	LD	A,(P1_Y)
	ADD	A,(IX+1)
	INC	HX
	LD	(P1_Y_UP),A
	LD	L,A
	LD	E,(HL)
	INC	H
	LD	D,(HL)
	INC	H
	;--
	LD	A,(P1_DIR)
	LD	(DIRP1),A
	LD	A,(P1_X)
	ADD	A,(IX+0)
DIRP1	EQU	$-1
	INC	HX
	LD	(P1_X_L),A
	LD	L,A
	LD	A,(HL)
	ADD	A,E
	LD	E,A
	ADC	A,D
	SUB	E
	LD	D,A	;DE=scr_adr_yx
	LD	(P1_SCR),DE
	;------ 
	LD	A,(IX)
	INC	HX
	LD	(P1_X_SIZE),A
	;------ tbl4x
	LD	A,L
	AND	3
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,A	;a*16
	LD	LY,A
	LD	HY,TBL_X4/256
	LD	(P1_X4),IY ;IY=     (, )
	;---
	LD	A,(P1_DIR); 
	ADD	A,A
	ADD	A,HX
	LD	HX,A
	LD	C,(IX+0) ;bc=mask
	LD	B,(IX+1)
	LD	(P1_MASKADR),BC
	;---
	INC	HX	;hl=spr
	LD	A,(IX+0)
	LD	L,A
	LD	A,(IX+1)
	LD	H,A
	LD	(P1_SPRADR),HL
	;---
	JP	XSPROUT
//---------------------
P2_OUT1	LD	HL,P2_X_SIZE
	LD	DE,P2_X_SIZE_OLD
	LD	BC,OLD_LEN
	LDIR
	;--
	LD	A,(P2_SPRPAGE)
	CALL	PAGER3
	LD	DE,(P2_SCR)
	LD	IY,(P2_X4)
	LD	A,LY
	ADD	A,64
	LD	LY,A
	LD	BC,(P2_MASKADR)
	LD	HL,(P2_SPRADR)
	JP	XSPROUT
	;--------------
P2_OUT	LD	IX,(P2_NSPR) ;   
	LD	A,LX
	ADD	A,A
	LD	LX,A
	;--
	LD	A,(IX+0)	;set sprite page [3]
	LD	(P2_SPRPAGE),A
	CALL	PAGER3
	;--
	LD	H,TBL_Y/256	;DE=scr_adr_y
	LD	A,(P2_Y)
	ADD	A,(IX+1)
	INC	HX
	LD	(P2_Y_UP),A
	LD	L,A
	LD	E,(HL)
	INC	H
	LD	D,(HL)
	INC	H
	;--
	LD	A,(P2_DIR)
	LD	(DIRP2),A
	LD	A,(P2_X)
	ADD	A,(IX+0)
DIRP2	EQU	$-1
	INC	HX
	LD	(P2_X_L),A
	LD	L,A
	LD	A,(HL)
	ADD	A,E
	LD	E,A
	ADC	A,D
	SUB	E
	LD	D,A	;DE=scr_adr_yx
	LD	(P2_SCR),DE
	;------ 
	LD	A,(IX)
	INC	HX
	LD	(P2_X_SIZE),A
	;------ tbl4x
	LD	A,L
	AND	3
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,A	;a*16
	LD	LY,A
	LD	HY,TBL_X4/256
	LD	(P2_X4),IY ;IY=     (, )
	;---
	LD	A,(P2_DIR); 
	ADD	A,A
	ADD	A,HX
	LD	HX,A
	LD	C,(IX+0) ;bc=mask
	LD	B,(IX+1)
	LD	(P2_MASKADR),BC
	;---
	INC	HX	;hl=spr
	LD	A,(IX+0)
	LD	L,A
	LD	A,(IX+1)
	LD	H,A
	LD	(P2_SPRADR),HL
	;---
	JP	XSPROUT
;-----------------------------
TITLE_SCR ; 
	CALL	CLEARSCR
	LD	HL,PAL_SELECT
	CALL	SETPAL
	;--
	LD	A,13
	CALL	PAGER3
	LD	A,8
	LD	HL,TITLESCR0
	LD	DE,#4000
	CALL	PAGER1
	CALL	DEPACK
	LD	A,9
	LD	HL,TITLESCR1
	LD	DE,#4000
	CALL	PAGER1
	CALL	DEPACK
	RET
;-----------------------------
SELECT_SCR ;  
	CALL	CLEARSCR
	LD	HL,PAL_SELECT
	CALL	SETPAL
	;--
	LD	A,12		;retrokombat_BG
	CALL	PAGER3
	LD	A,8
	LD	HL,SELSCR0
	LD	DE,#4000
	CALL	PAGER1
	CALL	DEPACK
	LD	A,9
	LD	HL,SELSCR1
	LD	DE,#4000
	CALL	PAGER1
	CALL	DEPACK
	LD	A,10
	LD	HL,SELSCR0
	LD	DE,#4000
	CALL	PAGER1
	CALL	DEPACK
	LD	A,11
	LD	HL,SELSCR1
	LD	DE,#4000
	CALL	PAGER1
	CALL	DEPACK
	CALL	SHOWSCR0
	;--
	RET
;--------------------------------
TITLE_ANYKEY ;   press any key
	LD	A,#10
	EX	AF,AF
ANYKEY0	EI
	HALT
	LD	BC,#7FFD
	EX	AF,AF
	XOR	#08
	OUT	(C),A
	EX	AF,AF
	;--
	LD	A,25
ANYKEY1	EQU	$-1
	DEC	A
	LD	(ANYKEY1),A
	CALL	Z,ANYKEY2
	;--
	XOR	A
	IN	A,(#FE)
	OR	%11100000
	XOR	#FF
	JP	Z,ANYKEY0
	RET
	;--
ANYKEY2	LD	A,25
	LD	(ANYKEY1),A
	LD	A,0
ANYKEY3	EQU	$-1
	XOR	#FF
	LD	(ANYKEY3),A
	JP	Z,ANYKEY4
	;-put-sprite
	LD	A,12
	CALL	PAGER3
	LD	HL,S_ANYKEY
	LD	DE,#400F+40*190
	LD	IY,#070B
	JP	PUTSPR
ANYKEY4 ;-clear
	LD	HL,#400F+40*190
	LD	BC,#0B08
CLRSPR	LD	A,B
	LD	(CLRSPR2+1),A
	LD	A,1
	RES	5,H
	CALL	CLRSPR0
	;--
	LD	A,5
	RES	5,H
	CALL	CLRSPR0
	;--
	LD	A,1
	SET	5,H
	CALL	CLRSPR0
	;--
	LD	A,5
	SET	5,H
	CALL	CLRSPR0
	;----
	LD	A,3
	RES	5,H
	CALL	CLRSPR0
	;--
	LD	A,7
	RES	5,H
	CALL	CLRSPR0
	;--
	LD	A,3
	SET	5,H
	CALL	CLRSPR0
	;--
	LD	A,7
	SET	5,H
	;----
CLRSPR0	PUSH	HL,BC
	PUSH	BC
	CALL	PAGER1
	POP	BC
	LD	DE,40
	XOR	A
CLRSPR2	LD	B,0
	PUSH	HL
CLRSPR1	LD	(HL),A
	INC	HL
	DJNZ	CLRSPR1
	POP	HL
	ADD	HL,DE
	DEC	C
	JP	NZ,CLRSPR2
	POP	BC,HL
	RET
;---------------------------   
PUTSPR	LD	A,LY
	LD	(PUTSPR2),A
	LD	A,3
	RES	5,D
	CALL	PUTSPR0
	;--
	LD	A,7
	RES	5,D
	CALL	PUTSPR0
	;--
	LD	A,3
	SET	5,D
	CALL	PUTSPR0
	;--
	LD	A,7
	SET	5,D
	CALL	PUTSPR0
	;----
	LD	A,1
	RES	5,D
	CALL	PUTSPR0
	;--
	LD	A,5
	RES	5,D
	CALL	PUTSPR0
	;--
	LD	A,1
	SET	5,D
	CALL	PUTSPR0
	;--
	LD	A,5
	SET	5,D
	;---
PUTSPR0	PUSH	DE,IY
	CALL	PAGER1
PUTSPR3	PUSH	DE
	LD	BC,0
PUTSPR2	EQU	$-2
	LDIR
	POP	DE
	EX	DE,HL
	LD	BC,40
	ADD	HL,BC
	EX	DE,HL
	DEC	HY
	JP	NZ,PUTSPR3
	POP	IY,DE
	RET
;--------------------------------
FADESCR ;  -
	LD	HL,#4000+7960
	EXX
	LD	HL,#4000
	LD	A,#10
	EX	AF,AF
	LD	LY,100
	;--
FSCR1_0	EI
	HALT
	LD	BC,#7FFD
	EX	AF,AF
	XOR	#08
	OUT	(C),A
	EX	AF,AF
	;--
	LD	A,#03
	CALL	FSCR1_1
	LD	A,#07
	CALL	FSCR1_1
	LD	A,#01
	CALL	FSCR1_1
	LD	A,#05
	CALL	FSCR1_1
	;--
	EXX
	LD	A,#03
	CALL	FSCR1_1
	LD	A,#07
	CALL	FSCR1_1
	LD	A,#01
	CALL	FSCR1_1
	LD	A,#05
	CALL	FSCR1_1
	;--
	LD	BC,0-80
	ADD	HL,BC
	EXX
	;--
	LD	BC,80
	ADD	HL,BC
	;--
	DEC	LY
	JP	NZ,FSCR1_0
	;---
FSCR1_1	PUSH	HL,DE,HL,DE
	CALL	PAGER1
	XOR	A
	LD	B,40
FSCR1_2	LD	(HL),A
	INC	HL
	DJNZ	FSCR1_2
	POP	DE,HL
	SET	5,H
	SET	5,D
	LD	B,40
FSCR1_3	LD	(HL),A
	INC	HL
	DJNZ	FSCR1_3
	POP	DE,HL
	RET
;--------------------------------
SHOWSCR0 ; 
	EI
	HALT
	LD	BC,#7FFD
	LD	A,#10
	OUT	(C),A
	LD	BC,#0308
	CALL	SSCR0_1
	LD	BC,#0709
	CALL	SSCR0_1
	EI
	HALT
	LD	BC,#7FFD
	LD	A,#18
	OUT	(C),A
	LD	BC,#0108
	CALL	SSCR0_1
	LD	BC,#0509
	CALL	SSCR0_1
	RET
SSCR0_1	LD	A,B
	CALL	PAGER1
	LD	A,C
	CALL	PAGER3
	LD	HL,#C000
	LD	DE,#4000
	LD	B,D
	LD	C,E
	LDIR
	RET
;--------------------------------
SHOWSCR1 ;  -
	LD	HL,#C000+7960
	LD	DE,#4000+7960
	EXX
	LD	HL,#C000
	LD	DE,#4000
	LD	A,#10
	EX	AF,AF
	LD	LY,100
	;--
SSCR1_0	EI
	HALT
	LD	BC,#7FFD
	EX	AF,AF
	XOR	#08
	OUT	(C),A
	EX	AF,AF
	;--
	LD	BC,#0308
	CALL	SSCR1_1
	LD	BC,#0709
	CALL	SSCR1_1
	LD	BC,#010A
	CALL	SSCR1_1
	LD	BC,#050B
	CALL	SSCR1_1
	;--
	EXX
	LD	BC,#0308
	CALL	SSCR1_1
	LD	BC,#0709
	CALL	SSCR1_1
	LD	BC,#010A
	CALL	SSCR1_1
	LD	BC,#050B
	CALL	SSCR1_1
	;--
	LD	BC,0-80
	ADD	HL,BC
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	EXX
	;--
	LD	BC,80
	ADD	HL,BC
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	;--
	DEC	LY
	JP	NZ,SSCR1_0
	;---
SSCR1_1	PUSH	HL,DE,HL,DE
	LD	A,B
	CALL	PAGER1
	LD	A,C
	CALL	PAGER3
	LD	BC,40
	LDIR
	POP	DE,HL
	SET	5,H
	SET	5,D
	LD	BC,40
	LDIR
	POP	DE,HL
	RET
;--------------------------------
CLEARSCR ; 
	EI
	HALT
	LD	BC,#7FFD
	LD	A,#10
	OUT	(C),A
	LD	A,%11100011 ;set zx_screen 6912
	LD	BC,#FF77
	CALL	OUT_SHADOW
	;--
	LD	A,5
	CALL	PAGER1
	LD	HL,#5800	;clr 768 attr
	LD	DE,#5801
	LD	BC,767
	LD	(HL),L
	LDIR
	;--
	LD	A,1	;   320*200*16
	CALL	CLRSCR1
	LD	A,3
	CALL	CLRSCR1
	LD	A,5
	CALL	CLRSCR1
	LD	A,7
	CALL	CLRSCR1
	;--
	LD	A,%11100000 ;set 320*200*16
	LD	BC,#FF77
	JP	OUT_SHADOW
	;--
CLRSCR1	CALL	PAGER3
	LD	HL,#C000
	LD	DE,#C001
	LD	BC,#3FFF
	LD	(HL),L
	LDIR
	RET
;--------------------------------
OUT_SHADOW ;   
;	LD	IX,#2A53
;	PUSH	IX
;	JP	#3D2F
	PUSH	AF
	LD	A,%00000001
	OUT	(#BF),A
	POP	AF
	OUT	(C),A
	XOR	A
	OUT	(#BF),A
	RET
;--------------------------------
PAGER0 ;     0
	PUSH	BC
	LD	BC,#3FF7
	JP	PAGER
PAGER1 ;     1
	LD	(PAGE1),A
	PUSH	BC
	LD	BC,#7FF7
	JP	PAGER
PAGER3 ;     3
	LD	(PAGE3),A
	PUSH	BC
	LD	BC,#FFF7
PAGER	XOR	%00111111
	OR	%01000000
	RES	7,A
	CALL	OUT_SHADOW
	POP	BC
	RET
PAGE1	DB	0
PAGE3	DB	0
;--------------------------------
LOADPAGE ;  
	LD	HL,#C000
	JP	LOAD0
LOAD	;  
	XOR	A
LOAD0	LD	(LOADPG),A
	LD	(LOADHL),HL
	POP	HL
	LD	D,H
	LD	E,L
	LD	BC,8
	ADD	HL,BC
	PUSH	HL
	LD	HL,0
LOADHL	EQU	$-2
	JP	LOADNAME
//==========================================================
// TR-DOS LOADER
//==========================================================
LOADCAT ;    ( 4)
	LD	A,4
	CALL	PAGER3
	LD	HL,#C000
	LD	BC,#0805
	LD	D,L
	LD	E,L
	JP	#3D13
LOADNAME ;   
	;hl-,de-   (  8 )
	PUSH	HL
	LD	A,4
	CALL	PAGER3
	LD	HL,#C000
LOADN2	PUSH	HL,DE
	LD	B,8
LOADN0	LD	A,(DE)
	CP	(HL)
	JP	NZ,LOADN1
	INC	DE
	INC	HL
	DJNZ	LOADN0
	; 
	POP	DE,IX
	LD	C,#05
	LD	B,(IX+13) ;b=sector size
	LD	E,(IX+14)
	LD	D,(IX+15) ;de=trk,sec file
	POP	HL
	LD	A,0
LOADPG	EQU	$-1
	CALL	PAGER3
	CALL	#3D13
	RET
LOADN1	;next
	POP	DE,HL
	LD	BC,16
	ADD	HL,BC
	JP	LOADN2
//==========================================================
// PLAYER 1 VARIABLES
//==========================================================
;---   (  )
P1_Y		DB	32
P1_X		DB	8
P1_NSPR		DB	1		;  
P1_SPRTBL	DB	DIZZY_TBL/256	;   
P1_DIR		DB	0	;  (0-,1-)
P1_DY		DB	0	;  
;---   (   )
P1_MASKADR	DW	0
P1_SPRADR	DW	0
P1_X_L		DB	0	;  X
P1_X_SIZE	DB	0	; 
P1_Y_UP		DB	0	; 
P1_SCR		DW	0	;   
P1_X4		DW	0	;   X4
P1_SPRPAGE	DB	0
;--- .   
P1_X_L_OLD	DB	0	;  X
P1_X_SIZE_OLD	DB	0	; 
P1_Y_UP_OLD	DB	0	; 
P1_SCR_OLD	DW	0	;   
P1_X4_OLD	DW	0	;   X4
P1_SPRPAGE_OLD	DB	0
OLD_LEN		EQU	8
	DB	0
//==========================================================
// PLAYER 2 VARIABLES
//==========================================================
;---   (  )
P2_Y		DB	32
P2_X		DB	139
P2_NSPR		DB	1		;  
P2_SPRTBL	DB	DIZZY_TBL/256	;   
P2_DIR		DB	1	;  (0-,1-)
P2_DY		DB	0	;  
;---   (   )
P2_MASKADR	DW	0
P2_SPRADR	DW	0
P2_X_L		DB	0	;  X
P2_X_SIZE	DB	0	; 
P2_Y_UP		DB	0	; 
P2_SCR		DW	0	;   
P2_X4		DW	0	;   X4
P2_SPRPAGE	DB	0
;--- .   
P2_X_L_OLD	DB	0	;  X
P2_X_SIZE_OLD	DB	0	; 
P2_Y_UP_OLD	DB	0	; 
P2_SCR_OLD	DW	0	;   
P2_X4_OLD	DW	0	;   X4
P2_SPRPAGE_OLD	DB	0
	DB	0
//===================================================
//  
//===================================================
SETPAL	;  HL- 
	EI
	HALT
	LD	A,%11100000 ;set 320*200*16
	LD	BC,#BF77
	CALL	OUT_SHADOW
	LD	A,15
SETPAL0	PUSH	AF
	CALL	SETBORDER
	AND	7
	OUT	(C),A
	LD	A,(HL)
	INC	HL
	LD	BC,#00FF
	CALL	OUT_SHADOW
	POP	AF
	DEC	A
	CP	#FF
	JR	NZ,SETPAL0
	LD	A,%11100000 ;set 320*200*16
	LD	BC,#FF77
	JP	OUT_SHADOW
SETBORDER
	LD	BC,#00FE
	CP	8
	RET	C
	LD	BC,#00F6
	RET
// palette format
// %grbG11RB
// ~{Rr}. ~{Gg}, ~{Bb},  ~   .
PAL_SELECT
	DB	%00111101
	DB	%10101100
	DB	%11011110
	DB	%10111111
	DB	%00001100
	DB	%11101100
	DB	%00011111
	DB	%00101101
	DB	%10101101
	DB	%10111101
	DB	%11111101
	DB	%01001110
	DB	%11001110
	DB	%01011110
	DB	%11111110
	DB	%11111111

//==========================================================
END_8000
//==========================================================
// HIMEM #BE00 (INT,STACK,ETC..)
//==========================================================
	ORG	#BE00
	DS	257,#BF
DEPACK	INCLUDE	"depacker.asm"
END_BE01
	ORG	#BFBF ; 
	DI
	NOP
	NOP
	NOP
	EI
FNRET	RET
	;--
SET_IM2	;  IM2
	DI
	LD	A,#BE
	LD	I,A
	IM	2
	EI
	RET
SET_IM1	;  IM1
	DI
	LD	IY,#5C3A
	LD	A,#3F
	LD	I,A
	IM	1
	EI
	RET
END_BFBF
//==========================================================
//   
//==========================================================
	DISPLAY	"END #8000 CODE: ",/A,END_8000
	DISPLAY	"END #BE01 CODE: ",/A,END_BE01
	DISPLAY	"END #BFBF CODE: ",/A,END_BFBF
//==========================================================
// SAVE CODE
//==========================================================
	EMPTYTRD "game.trd"
	SAVETRD "game.trd","RUNME.B",#5D3B,BASIC_END-#5D3B
	SAVETRD "game.trd","CODE.C",#8000,END_8000-#8000
	SAVETRD "game.trd","BE00.C",#BE00,512
//==========================================================
// PAGES
//==========================================================
	INCLUDE	"page0.asm"
	INCLUDE	"page12.asm"
	INCLUDE	"page13.asm"
	INCLUDE	"page16.asm"
	INCLUDE	"page17.asm"
