//===================================================
// 
//===================================================
IDLE_SPEED	EQU	3

//===================================================
// 
//===================================================
	ORG	#1900
TBL_Y	;, ,      
	DS	512,0
TBL_X	; X   4 (..  4      )
	DS	256,0
TBL_X4	;      X
	;     
	DB	3,7,3,7,#00,#00,#00,#00,#00,#20,#00,#20,8,9,8,9
	DB	7,3,7,3,#00,#00,#00,#20,#00,#20,#01,#00,9,8,9,8
	DB	3,7,3,7,#00,#20,#00,#20,#01,#00,#01,#00,8,9,8,9
	DB	7,3,7,3,#00,#20,#01,#00,#01,#00,#01,#20,9,8,9,8
	DB	1,5,1,5,#00,#00,#00,#00,#00,#20,#00,#20,10,11,10,11
	DB	5,1,5,1,#00,#00,#00,#20,#00,#20,#01,#00,11,10,11,10
	DB	1,5,1,5,#00,#20,#00,#20,#01,#00,#01,#00,10,11,10,11
	DB	5,1,5,1,#00,#20,#01,#00,#01,#00,#01,#20,11,10,11,10
	DS	128
//---------------------------------------------------
MARIO_TBL ;  
//---------------------------------------------------

//---------------------------------------------------
DIZZY_TBL ;  
//---------------------------------------------------
	DB	16,41,16,42,16,42,16,41
	 ORG	DIZZY_TBL+256*1
	DB	0-3,0-6,0-3,0-6,0-3,0-6,0-4,0-5
	 ORG	DIZZY_TBL+256*2
	DW	6,6,6,6
	;-- right
	 ORG	DIZZY_TBL+256*3
	DW	diz_idle0_rm,diz_idle1_rm,diz_idle2_rm,diz_idle3_rm
	 ORG	DIZZY_TBL+256*4
	DW	diz_idle0_rs,diz_idle1_rs,diz_idle2_rs,diz_idle3_rs
	;-- left
	 ORG	DIZZY_TBL+256*5
	DW	diz_idle0_lm,diz_idle1_lm,diz_idle2_lm,diz_idle3_lm
	 ORG	DIZZY_TBL+256*6
	DW	diz_idle0_ls,diz_idle1_ls,diz_idle2_ls,diz_idle3_ls

//===================================================
//  
//===================================================
DO_IDLE_1
	LD	HL,P1_NSPR
	LD	DE,P1_IDLEP
	LD	BC,P1_IDLEC
	JP	DO_IDLE
DO_IDLE_2
	LD	HL,P2_NSPR
	LD	DE,P2_IDLEP
	LD	BC,P2_IDLEC
DO_IDLE	;---
	LD	A,(DE)
	DEC	A
	LD	(DE),A
	RET	NZ
	LD	A,IDLE_SPEED	
	LD	(DE),A
	;-
	PUSH	HL
	LD	A,(BC)
	INC	A
	CP	6
	JP	NZ,DO_IDLE0
	XOR	A
DO_IDLE0 LD	(BC),A
	LD	E,A
	LD	D,0
	LD	HL,DO_IDLE_TBL
	ADD	HL,DE
	LD	A,(HL)
	POP	HL
	LD	(HL),A
	RET
DO_IDLE_TBL	DB	0,1,2,3,2,1
P1_IDLEP	DB	IDLE_SPEED
P2_IDLEP	DB	IDLE_SPEED
P1_IDLEC	DB	0
P2_IDLEC	DB	0
//===================================================
//--------------------------
// SPRITE OUTPUT
//--------------------------
XS_SOHRSP	EQU	0
XS_MASK		EQU	2
//------------------------------
; IY-   X4
; BC -  
; DE -   
; HL -   
//------------------------------
XSPROUT	; 
	LD	(XS_MASK),BC
	LD	(XS_SCR),DE
	LD	A,(IY+0)
	LD	C,(IY+4)
	LD	B,(IY+5)
	CALL	XSPR
	LD	A,(IY+1)
	LD	C,(IY+6)
	LD	B,(IY+7)
	CALL	XSPR
	LD	A,(IY+2)
	LD	C,(IY+8)
	LD	B,(IY+9)
	CALL	XSPR
	LD	A,(IY+3)
	LD	C,(IY+10)
	LD	B,(IY+11)
;-------------------------
;HL -   
;-------------------------
XSPR	CALL	PAGER1
	LD	(XS_SOHRSP),SP	;20
	LD	SP,(XS_MASK)	;10
	EX	DE,HL		;4      
	LD	HL,0		;10 
XS_SCR	EQU	$-2		;
	ADD	HL,BC		;15
	EX	DE,HL		;4
	;--
	POP	IX		;14    nextln
	RET			;10    
;-------------------------
; SPROUT GENERATOR
;-------------------------
MASK_L	EQU	%10111000
MASK_R	EQU	%01000111
P00	INC	DE	;6 /6
P00_END
//---
P01	LD	A,(DE)	;7
	AND	MASK_R	;7
	OR	(HL)	;7
	LD	(DE),A	;7
	INC	HL	;6
	INC	DE	;6 /40
P01_END
//---
P10	LD	A,(DE)	;7
	AND	MASK_L	;7
	OR	(HL)	;7
	LD	(DE),A	;7
	INC	HL	;6
	INC	DE	;6 /40
P10_END
//---
P11	LDI		;16 /16
P11_END
//---
LN	LD	A,E	;4
	ADD	A,LX	;8
	LD	E,A	;4
	ADC	A,D	;4
	SUB	E	;4
	LD	D,A	;4
	RET		;10 /38 (8b)
LN_END
//---
LNBLANK	LD	A,E	;4
	ADD	A,HX	;8
	LD	E,A	;4
	ADC	A,D	;4
	SUB	E	;4
	LD	D,A	;4
	RET		;10 /38 (8b)
LNBLANK_END
//---
XRET	LD	(XS_MASK),SP ;20
	LD	SP,(XS_SOHRSP)  ;20
	RET		     ;10
XRET_END
//---
XSPR_INIT
	LD	LX,0
	LD	DE,#0004
	;--
XS_INI4	LD	A,LX
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	A,LX
	RRA:RRA
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	A,LX
	RRA:RRA:RRA:RRA
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	A,LX
	RRA:RRA:RRA:RRA:RRA:RRA
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	A,#C9
	LD	(DE),A
	INC	DE
	;--
	INC	LX
	JP	NZ,XS_INI4
;--- 3_byte + nextln
	LD	LX,0
XS_INI3	LD	A,LX
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	A,LX
	RRA:RRA
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	A,LX
	RRA:RRA:RRA:RRA
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	HL,LN
	LD	BC,LN_END-LN
	LDIR
	;--
	INC	LX
	LD	A,LX
	CP	64
	JP	NZ,XS_INI3
;--- 2_byte + nextln
	LD	LX,0
XS_INI2	LD	A,LX
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	A,LX
	RRA:RRA
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	HL,LN
	LD	BC,LN_END-LN
	LDIR
	;--
	INC	LX
	LD	A,LX
	CP	16
	JP	NZ,XS_INI2
;--- 1_byte + nextln
	LD	LX,0
XS_INI1	LD	A,LX
	AND	%00000011
	CALL	X_CALCHL
	LDIR
	;--
	LD	HL,LN
	LD	BC,LN_END-LN
	LDIR
	;--
	INC	LX
	LD	A,LX
	CP	4
	JP	NZ,XS_INI1
;--- nextln (in previous)
;--- nextln blank
	LD	HL,LNBLANK
	LD	BC,LNBLANK_END-LNBLANK
	LDIR
;--- ret
	LD	HL,XRET
	LD	BC,XRET_END-XRET
	LDIR
	RET
;---
X_CALCHL
	LD	HL,P00
	LD	BC,P00_END-P00
	OR	A
	RET	Z
	LD	HL,P01
	LD	BC,P01_END-P01
	DEC	A
	RET	Z
	LD	HL,P10
	LD	BC,P10_END-P10
	DEC	A
	RET	Z
	LD	HL,P11
	LD	BC,P11_END-P11
	RET
INI_TBL ; 
	CALL	INI_TBL_Y
	CALL	INI_TBL_X
	RET
;-----------------
INI_TBL_Y
	LD	HL,TBL_Y
	LD	DE,#4000+40*199
	LD	BC,0-40
	LD	LX,200
I_T_Y0	LD	(HL),E
	INC	H
	LD	(HL),D
	DEC	H
	INC	L
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	DEC	LX
	JP	NZ,I_T_Y0
	RET
;-----------------
INI_TBL_X
	LD	HL,TBL_X
	XOR	A
	LD	B,40
I_T_X0	DUP	4
	LD	(HL),A
	INC	L
	EDUP
	INC	A
	DJNZ	I_T_X0
	RET
//===================================================
END_PG0
//===================================================
	DISPLAY	"PAGE 0 LEN: ",/A,END_PG0-#0000
	SAVETRD	"game.trd","PAGE0.C",#0000,END_PG0-#0000