#ifndef _AY_H_INCLUDED_
#define _AY_H_INCLUDED_

#include "../../zemu.h"
#include "../device.h"
#include "../../lib_ay/sndchip.h"
#include "../../lib_ay/sndrender.h"

#define MAX_AY_BUFFER_SIZE 2048

class C_Ay : public C_Device
{
	public:

	static SNDCHIP ayChip;

	void Init(void);
	void Close(void);

	static bool OnInputByte(Z80EX_WORD port, Z80EX_BYTE &retval);
	static bool OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value);
	static void OnFrameStart(void);
	static void OnAfterFrameRender(void);
	static void OnReset(void);

	static SNDSAMPLE soundBuffer[MAX_AY_BUFFER_SIZE];
	static int samples;
};

#endif
