#ifndef _MMANAGER_H_INCLDUED_
#define _MMANAGER_H_INCLDUED_

#include "../../zemu.h"
#include "../device.h"

#define RAM_BANK2 (0x4000 * 2)
#define RAM_BANK5 (0x4000 * 5)
#define RAM_BANK7 (0x4000 * 7)

class C_MemoryManager : public C_Device
{
	public:

	static Z80EX_BYTE port7FFD;
	static BYTE rom[0x8000];
	static BYTE ram[0x4000*32];

	static BYTE *rom_map, *ram_map;
	static bool enable512;

	static void ReadFile(void);
	void Init(void);
	void Close(void);

	static void Remap(void);
	static bool OnReadByte(Z80EX_WORD addr, bool m1, Z80EX_BYTE &retval);
	static bool OnWriteByte(Z80EX_WORD addr, Z80EX_BYTE value);
	static bool OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value);
	static void OnReset(void);
};

#endif
