#include "mouse.h"

Z80EX_BYTE C_Mouse::portFBDF;
Z80EX_BYTE C_Mouse::portFFDF;
Z80EX_BYTE C_Mouse::portFADF;

void C_Mouse::Init(void)
{
	AttachZ80InputHandler(OnInputByte);
//	AttachSDLHandler(SDL_MOUSEMOTION, OnMouseMotion);
//	AttachSDLHandler(SDL_MOUSEBUTTONDOWN, OnMouseButtonDown);
//	AttachSDLHandler(SDL_MOUSEBUTTONUP, OnMouseButtonUp);

	portFBDF = 128;
	portFFDF = 96;
	portFADF = 255;
}

void C_Mouse::Close(void)
{
}

void C_Mouse::UpdateState(void)
{
	int mx, my, bt;

	bt = SDL_GetRelativeMouseState(&mx, &my);
	portFBDF += mx / params.mouseDiv;
	portFFDF -= my / params.mouseDiv;

	portFADF = 255;
	if (bt & SDL_BUTTON_LMASK) portFADF &= ~1;
	if (bt & SDL_BUTTON_RMASK) portFADF &= ~2;
	if (bt & SDL_BUTTON_MMASK) portFADF &= ~3;	// middle button works as LMB + RMB
}

bool C_Mouse::OnInputByte(Z80EX_WORD port, Z80EX_BYTE &retval)
{
	if (port == 0xFBDF)
	{
		UpdateState();
		retval = portFBDF;
		return true;
	}
	else
	if (port == 0xFFDF)
	{
		UpdateState();
		retval = portFFDF;
		return true;
	}
	else
	if (port == 0xFADF)
	{
		UpdateState();
		retval = portFADF;
		return true;
	}

	return false;
}

/*

bool C_Mouse::OnMouseMotion(SDL_Event &event)
{
	return false;
}

bool C_Mouse::OnMouseButtonDown(SDL_Event &event)
{
	return false;
}

bool C_Mouse::OnMouseButtonUp(SDL_Event &event)
{
	return false;
}







case SDL_MOUSEMOTION:
	mouseX = event.motion.x;
	mouseY = event.motion.y;
	break;

case SDL_MOUSEBUTTONDOWN:
	if (event.button.button == SDL_BUTTON_LEFT) mouseLB = 1; else
	if (event.button.button == SDL_BUTTON_RIGHT) mouseRB = 1;
	break;

case SDL_MOUSEBUTTONUP:
	if (event.button.button == SDL_BUTTON_LEFT) mouseLB = 0; else
	if (event.button.button == SDL_BUTTON_RIGHT) mouseRB = 0;

typedef struct SDL_MouseMotionEvent {
	Uint8 type;
	Uint8 which;
	Uint8 state; - buttons
	Uint16 x, y;
	Sint16 xrel;
	Sint16 yrel;
} SDL_MouseMotionEvent;

typedef struct SDL_MouseButtonEvent {
	Uint8 type;
	Uint8 which;
	Uint8 button;
	Uint8 state;
	Uint16 x, y;
} SDL_MouseButtonEvent;

*/
