#include <stdlib.h>
#include <string.h>
#include "wd93_fdd.hpp"

static unsigned char snbuf[2*1048576]; /* large temporary buffer */

int FDD::save_dimage(char *filename, enum DIMAGE_TYPE type)
{
	FILE *fp;
	int ret=0;

	if ((fp=fopen(filename,"wb")) == NULL)
	{
		ret=0;
	}
	else
	switch(type)
	{
		case imgTRD:
			ret=write_trd(fp);
			break;
		
		case imgUDI:
			ret=write_udi(fp);
			break;
		
		case imgTD0:
			ret=write_td0(fp);
			break;
		
		case imgFDI:
			ret=write_fdi(fp);
			break;
		
		default:
			ret=0;
	}

	if (fp != NULL) fclose(fp);

	if (ret) optype = 0;	// [rst] - reset "changed" flag after saving
	return(ret);
}

void FDD::set_appendboot(char *boot_name)
{
	if(boot_name) strncpy(appendboot, boot_name, 255);
	else *appendboot='\0';	
}

char FDD::is_changed()
{
	if (optype) return 1;
	return 0;
}

void FDD::free()
{	
	if (rawdata) ::free(rawdata);
	
	rawdata=NULL;
	rawsize=0;
	cyls=0; sides=0;
	memset(trklen, 0, sizeof(trklen));
	memset(trkd, 0, sizeof(trkd));
	memset(trki, 0, sizeof(trki));
	optype=0;
	snaptype=0;
	memset(name, 0, sizeof(name));
	memset(dsc, 0, sizeof(dsc));   
   
	set_wprotected(0);
	if(trkcache!=NULL) trkcache->clear();
	t.clear();
}

void FDD::newdisk(unsigned cyls, unsigned sides)
{
   free();

   FDD::cyls = cyls; FDD::sides = sides;
   unsigned len = MAX_TRACK_LEN;
   unsigned len2 = len + (len/8) + ((len & 7) ? 1 : 0);
   rawsize = align_by(cyls * sides * len2, 4096);
   rawdata = (unsigned char*)malloc(rawsize);
   memset(rawdata,0,rawsize);

   for (unsigned i = 0; i < cyls; i++)
      for (unsigned j = 0; j < sides; j++) {
         trklen[i][j] = len;
         trkd[i][j] = rawdata + len2*(i*sides + j);
         trki[i][j] = trkd[i][j] + len;
      }
   // comp.wd.trkcache.clear(); // already done in free()
}

int FDD::read(unsigned char type)
{
   int ok = 0;
   if (type == snTRD) ok = read_trd();
   if (type == snUDI) ok = read_udi();
   if (type == snHOB) ok = read_hob();
   if (type == snSCL) ok = read_scl();
   if (type == snFDI) ok = read_fdi();
   if (type == snTD0) ok = read_td0();
   return ok;
}

int FDD::load_dimage(char *filename)
{
	unsigned char type = what_is(filename);
			
	if(!read(type)) return(0);
		
	if (get_appendboot()) addboot();
	strcpy(name, filename);
		
	/* TODO
	if (GetFileAttributes(filename) & FILE_ATTRIBUTE_READONLY)
		set_wprotected(1);*/

	snaptype = (type == snHOB || type == snSCL)? snTRD : type;
		
	return(1);
}

unsigned char FDD::what_is(char *filename)
{
   FILE *ff = fopen(filename, "rb");
   if (!ff) return snNOFILE;
   snapsize = fread(snbuf, 1, sizeof snbuf, ff);
   fclose(ff);
   if (snapsize == sizeof snbuf) return snTOOLARGE;
   unsigned char type = snUNKNOWN;
   char *ptr = strrchr(filename, '.');
   unsigned ext = ptr? (*(int*)(ptr+1) | 0x20202020) : 0;
   if (snapsize < 32) return type;

   if (!snbuf[13] && snbuf[14] && (int)snapsize == snbuf[14]*256+17) type = snHOB;
   if (snapsize >= 8192 && !(snapsize & 0xFF) && ext == WORD4('t','r','d',' ')) type = snTRD;
   if (!memcmp(snbuf, "SINCLAIR", 8) && (int)snapsize >= 9+(0x100+14)*snbuf[8]) type = snSCL;
   if (!memcmp(snbuf, "FDI", 3) && *(unsigned short*)(snbuf+4) <= MAX_CYLS && *(unsigned short*)(snbuf+6) <= 2) type = snFDI;
   if (((*(short*)snbuf|0x2020) == WORD2('t','d')) && snbuf[4] >= 10 && snbuf[4] <= 21 && snbuf[9] <= 2) type = snTD0;
   if (*(unsigned*)snbuf == WORD4('U','D','I','!') && *(unsigned*)(snbuf+4)==snapsize-4 && snbuf[9] < MAX_CYLS && snbuf[10]<2 && !snbuf[8]) type = snUDI;
  
   return type;
}

#include "wldr_trd.cpp.inc"
#include "wldr_udi.cpp.inc"
#include "wldr_fdi.cpp.inc"
#include "wldr_td0.cpp.inc"
