#include "ay.h"
#include "../../bin.h"

SNDCHIP C_Ay::ayChip;
SNDSAMPLE C_Ay::soundBuffer[MAX_AY_BUFFER_SIZE];
int C_Ay::samples;

void C_Ay::Init(void)
{
	AttachZ80InputHandler(OnInputByte);
	AttachZ80OutputHandler(OnOutputByte);
	AttachFrameStartHandler(OnFrameStart);
	AttachAfterFrameRenderHandler(OnAfterFrameRender);
	AttachResetHandler(OnReset);
	samples = 0;	// [boo]
}

void C_Ay::Close(void)
{
}

bool C_Ay::OnInputByte(Z80EX_WORD port, Z80EX_BYTE &retval)
{
	if ((port & MAKEWORD(BIN(0x11000000),BIN(0x00000010))) == MAKEWORD(BIN(0x11000000),BIN(0x00000000)))	// 0xFFFD
	{
		retval = ayChip.read();
		return true;
	}

	return false;
}

bool C_Ay::OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value)
{
	if ((port & MAKEWORD(BIN(0x11000000),BIN(0x00000010))) == MAKEWORD(BIN(0x11000000),BIN(0x00000000)))	// 0xFFFD
	{
		ayChip.select(value);
		return true;
	}

	if ((port & MAKEWORD(BIN(0x11000000),BIN(0x00000010))) == MAKEWORD(BIN(0x10000000),BIN(0x00000000)))	// 0xFFFD
	{
		ayChip.write((!params.sound || params.maxSpeed) ? 0 : devClk, value);
		return true;
	}

	return false;
}

void C_Ay::OnFrameStart(void)
{
	if (!params.maxSpeed && params.sound) {
		ayChip.start_frame(&soundBuffer[samples]);	// [boo]
	}
}

void C_Ay::OnAfterFrameRender(void)
{
	if (!params.maxSpeed && params.sound) {
		samples += ayChip.end_frame(lastDevClk);	// [boo]
	}
}

void C_Ay::OnReset(void)
{
	ayChip.reset();
}
