#include "border.h"

Z80EX_BYTE C_Border::portFB;
SNDRENDER C_Border::spkRender; //[boo]
SNDSAMPLE C_Border::soundBuffer[MAX_SPEAKER_BUFFER_SIZE];
int C_Border::samples;

void C_Border::Init(void)
{
	AttachZ80OutputHandler(OnOutputByte);
	AttachFrameStartHandler(OnFrameStart);	// [boo]
	AttachAfterFrameRenderHandler(OnAfterFrameRender);	// [boo]
	portFB = 7;
	samples = 0;	// [boo]
}

void C_Border::Close(void)
{
}

bool C_Border::OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value)
{
	if (port & 1) return false;

	// [boo] -- speaker
	const unsigned MAX_SPK_VOL = 0x2FFF;
	
	if (!params.maxSpeed && params.sound)
	{
		unsigned val = (value & 0x10) ? MAX_SPK_VOL : 0;
		spkRender.update(devClk, val, val);
	}
	// [/boo]

	portFB = value;
	return true;
}

// [boo]
void C_Border::OnFrameStart(void)
{
	if (!params.maxSpeed && params.sound) {
		spkRender.start_frame(&soundBuffer[samples]);	// [boo]
	}
}


void C_Border::OnAfterFrameRender(void)
{
	if (!params.maxSpeed && params.sound) {
		samples += spkRender.end_frame(lastDevClk);	// [boo]
	}
}
// [/boo]
