#include "mouse.h"

Z80EX_BYTE C_Mouse::portFBDF;
Z80EX_BYTE C_Mouse::portFFDF;
Z80EX_BYTE C_Mouse::portFADF;

void C_Mouse::Init(void)
{
	AttachZ80InputHandler(OnInputByte);

	portFBDF = 128;
	portFFDF = 96;
	portFADF = 255;
}

void C_Mouse::Close(void)
{
}

void C_Mouse::UpdateState(void)
{
	int mx, my, bt;

	bt = SDL_GetRelativeMouseState(&mx, &my);
	portFBDF += mx / params.mouseDiv;
	portFFDF -= my / params.mouseDiv;

	portFADF = 255;
	if (bt & SDL_BUTTON_LMASK) portFADF &= ~1;
	if (bt & SDL_BUTTON_RMASK) portFADF &= ~2;
	if (bt & SDL_BUTTON_MMASK) portFADF &= ~3;	// middle button works as LMB + RMB
}

bool C_Mouse::OnInputByte(Z80EX_WORD port, Z80EX_BYTE &retval)
{
	if (port == 0xFBDF)
	{
		UpdateState();
		retval = portFBDF;
		return true;
	}
	else
	if (port == 0xFFDF)
	{
		UpdateState();
		retval = portFFDF;
		return true;
	}
	else
	if (port == 0xFADF)
	{
		UpdateState();
		retval = portFADF;
		return true;
	}

	return false;
}
