#include "trdos.h"
#include "../../file.h"
#include "../../exceptions.h"
#include "../mmanager/mmanager.h"

extern C_MemoryManager dev_mman;

bool C_TrDos::trdos;
BYTE C_TrDos::rom[0x4000];

void C_TrDos::ReadFile(void)
{
	int i;
	C_File fl;
	char *fname;

	if (!config.GetString("root/Roms/TrDos", &fname)) throw C_E(E_General, "root/Roms/TrDos not found in config");
	fl.Read(fname);
	fl.ReadBlock(rom, 0x4000);
	fl.Close();
}

void C_TrDos::Init(void)
{
	ReadFile();
	AttachZ80ReadHandler(OnReadByte);
	AttachZ80InputHandler(OnInputByte);
	AttachZ80OutputHandler(OnOutputByte);
	AttachResetHandler(OnReset);
	trdos = false;
}

void C_TrDos::Close(void)
{
}

bool C_TrDos::OnReadByte(Z80EX_WORD addr, bool m1, Z80EX_BYTE &retval)
{
	if (m1)
	{
		if ((addr & 0xFF00)==0x3D00 && (dev_mman.port7FFD & 0x10)) trdos = true;
		else
		if (addr > 0x3FFF) trdos = false;
	}

	if (trdos && addr<0x4000)
	{
		retval = rom[addr];
		return true;
	}

	return false;
}

bool C_TrDos::OnInputByte(Z80EX_WORD port, Z80EX_BYTE &retval)
{
	int err;
	int lport = port & 0xFF;
	if (trdos && (lport==0xFF || lport==0x7F || lport==0x1F || lport==0x3F || lport==0x5F))
	{
		retval = wd1793_in(lport, devClkCounter, &err);
		return true;
	}
	return false;
}

bool C_TrDos::OnOutputByte(Z80EX_WORD port, Z80EX_BYTE value)
{
	int err;
	int lport = port & 0xFF;
	if (trdos && (lport==0xFF || lport==0x7F || lport==0x1F || lport==0x3F || lport==0x5F))
	{
		wd1793_out(lport, value, devClkCounter, &err);
		return true;
	}
	return false;
}

void C_TrDos::OnReset(void)
{
	trdos = false;
}

enum DRIVE_STATE C_TrDos::GetIndicatorState(void)
{
	return wd1793_get_drive_state(wd1793_get_current_drive(), devClkCounter);
}

