#include <string.h>
#include <ctype.h>
#include "dialog.h"
#include "font.h"
#include "dirwork.h"
#include "graphics.h"
#include "lib_wd1793/unreal_wd1793.h"

#include "images/zemu_ico.h"

#define MAX_FILES 4096
#define MAX_FNAME 256

extern C_Font font;
char oldFileName[4][MAX_PATH] = {"", "", "" ,""};
int currentDrive = 0;

int FileNameCmp(int f1, char *s1, int f2, char *s2)
{
	if (f1 == f2) return stricmp(s1, s2);
	else
	if (f1) return (-1);
	else return (1);
}

void DlgClearScreen(void)
{
	int i, j, cl;
	int *s, *p;

	if (SDL_MUSTLOCK(screen)) {if (SDL_LockSurface(screen) < 0) return;}
	s = (int *)screen->pixels;

	for (i = 0; i < HEIGHT; i++)
	{
		p = s;
		cl = (i & 1) ? DRGB(0,0,64) : DRGB(0,0,32);
		for (j = 0; j < WIDTH; j++) *(p++) = cl;
		s += PITCH;
	}

	if (SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);
}

bool DlgConfirm(char *message)
{
	int x, y, key;
	SDL_Event event;
	int wdt = font.StrLenPx(message) + 0x10;
	int hgt = font.Height() + 0x10;

	x = (WIDTH - wdt) / 2;
	y = (HEIGHT - hgt) / 2;

	Bar(x, y, x+wdt-1, y+hgt-1, DRGB(0x80, 0x20, 0x20));
	font.PrintString(x+8, y+8, message); 
	SDL_UpdateRect(screen, 0, 0, WIDTH, HEIGHT);

	for (;;)
	{
		for (key = 0; SDL_PollEvent(&event);)
		{
			if (event.type == SDL_QUIT) exit(0);
			if (event.type == SDL_KEYDOWN) key = event.key.keysym.sym;
		}

		if (key==SDLK_y || key==SDLK_RETURN) return true;
		if (key==SDLK_n || key==SDLK_ESCAPE) return false;

		SDL_Delay(10);
	}
}

char* SelectFile(char *oldFile)
{
	int key;
	SDL_Event event;
	C_DirWork dw;
	static char path[MAX_PATH], ofl[MAX_FNAME+1];
	char fnames[MAX_FILES][MAX_FNAME+1], temp[MAX_FNAME+1];
	int i, j, filesCnt, folders[MAX_FILES], pos, csr, mx, gl, h, x, tmp;
	int scrEnd, keyx;
	bool isRoot;

	scrEnd = HEIGHT - font.Height() - 8;

	strcpy(ofl, C_DirWork::ExtractFileName(oldFile));
	strcpy(path, C_DirWork::ExtractPath(oldFile));
	strcpy(path, C_DirWork::Normalize(path));

	h = font.Height();
	mx = scrEnd / h;
	x = font.StrLenPx("[]");

	do
	{
		isRoot = !strcmp(path, "/");
		strcat(path, "*.*");
		filesCnt = 0;

		if (dw.EnumFiles(path))
		{
			do
			{
				if (strcmp(dw.name, "."))
				{
					if (strcmp(dw.name, "..") || !isRoot)
					{
						strcpy(fnames[filesCnt], dw.name);
						folders[filesCnt] = (dw.attr == DW_FOLDER);
						filesCnt++;
					}
				}
			} while (dw.EnumNext());

			dw.EnumClose();
		}

		if (filesCnt > 0)
		{
			if (strcmp(fnames[0], "..")) gl = 0; else gl = 1;
		} else gl = 0;

		for (i = gl; i < filesCnt-1; i++)
			for (j = i+1; j < filesCnt; j++)
			{
				if (FileNameCmp(folders[i], fnames[i], folders[j], fnames[j]) > 0)
				{
					strcpy(temp, fnames[i]);
					strcpy(fnames[i], fnames[j]);
					strcpy(fnames[j], temp);

					tmp = folders[i];
					folders[i] = folders[j];
					folders[j] = tmp;
				}
			}

		pos = 0;
		csr = 0;

		for (i = gl; i < filesCnt; i++)
		{
			if (!strcmp(ofl, fnames[i]))
			{
				csr = i;

				if (filesCnt > mx)
				{
					pos = csr - mx / 2;
					if (pos < 0) pos = 0;
				}

				break;
			}
		}

		if (filesCnt > mx) gl = mx; else gl = filesCnt;

		do
		{
			do
			{
				for (key = 0; SDL_PollEvent(&event);)
				{
					if (event.type == SDL_QUIT) exit(0);
					if (event.type == SDL_KEYDOWN) key = event.key.keysym.sym;
				}

				DlgClearScreen();
				Bar(0, scrEnd, WIDTH-1, HEIGHT-1, DRGB(0x80, 0x20, 0x20));

				Bar(4+(currentDrive*16), scrEnd+4, 4+(currentDrive*16)+12, scrEnd+4+12, DRGB(0x40, 0x10, 0x10));
				font.PrintString(5, scrEnd+5, "A");
				font.PrintString(5+0x10+1, scrEnd+5, "B");
				font.PrintString(5+0x20+1, scrEnd+5, "C");
				font.PrintString(5+0x30+1, scrEnd+5, "D");

				Bar(4+0x50, scrEnd+4, 4+0x50+20, scrEnd+4+12, wd1793_is_disk_wprotected(currentDrive) ? DRGB(255,128,32) : DRGB(0x40,0x10,0x10));
				Bar(4+0x68, scrEnd+4, 4+0x68+20, scrEnd+4+12, wd1793_is_disk_loaded(currentDrive) ? DRGB(255,128,32) : DRGB(0x40,0x10,0x10));
				Bar(4+0x80, scrEnd+4, 4+0x80+20, scrEnd+4+12, wd1793_is_disk_changed(currentDrive) ? DRGB(255,128,32) : DRGB(0x40,0x10,0x10));

				font.PrintString(5+0x50, scrEnd+5, "WP");
				font.PrintString(5+0x68, scrEnd+5, "LD");
				font.PrintString(5+0x80, scrEnd+5, "CH");

				for (i = 0; i < gl; i++)
				{
					if (csr-pos == i) Bar(0, i*h, x+font.StrLenPx(fnames[i+pos])+x, i*h+h-1, DRGB(0x80, 0x20, 0x20));

					if (folders[i+pos]) font.PrintString(0, i*h, "[]");
					font.PrintString(x, i*h, fnames[i+pos]);
				}

				OutputGimpImage(WIDTH - img_zemuIco.width - 8, 8, (s_GimpImage *) &img_zemuIco);
				SDL_UpdateRect(screen, 0, 0, WIDTH, HEIGHT);
				SDL_Delay(10);
			} while (key == 0);

			if (key == SDLK_s)
			{
				if (DlgConfirm("Are you sure to save disk? (Y/N)")) {
					wd1793_save_dimage(oldFileName[currentDrive], currentDrive, imgTRD);
				}
			}
			else
			if (key == SDLK_e)
			{
				wd1793_eject_dimage(currentDrive);
			}
			else
			if (key == SDLK_w)
			{
				wd1793_set_disk_wprotected(currentDrive, !wd1793_is_disk_wprotected(currentDrive));
			}
			else
			if (key == SDLK_UP)
			{
				csr--;
				if (csr-pos < 0)
				{
					if (pos > 0) pos--;
					else csr++;
				}
			}
			else
			if (key == SDLK_DOWN)
			{
				csr++;
				if (csr-pos >= gl)
				{
					if (pos+gl < filesCnt) pos++;
					else csr--;
				}
			}
			else
			if (key == SDLK_HOME)
			{
				csr = 0;
				pos = 0;
			}
			else
			if (key == SDLK_END)
			{
				csr = filesCnt - 1;
				if (filesCnt > mx)
				{
					pos = filesCnt - mx;
				}
				else pos = 0;
			}
			else
			if (key == SDLK_PAGEUP)
			{
				pos -= mx;
				csr -= mx;
				if (pos < 0)
				{
					pos = 0;
					csr = 0;
				}
			}
			else
			if (key == SDLK_PAGEDOWN)
			{
				pos += mx;
				csr += mx;
				if (pos+gl > filesCnt)
				{
					if (filesCnt > mx)
					{
						csr = filesCnt - 1;
						pos = filesCnt - mx;
					}
					else
					{
						pos = 0;
						csr = filesCnt - 1;
					}
				}
			}
			else
			if (key == SDLK_LEFT)
			{
				currentDrive--;
				if (currentDrive < 0) currentDrive = 0;
			}
			else
			if (key == SDLK_RIGHT)
			{
				currentDrive++;
				if (currentDrive > 3) currentDrive = 3;
			}

		} while (key!=SDLK_RETURN && key!=SDLK_ESCAPE && key!=SDLK_BACKSPACE);

		do
		{
			SDL_Delay(1);
			for (keyx = 0; SDL_PollEvent(&event);)
			{
				if (event.type == SDL_QUIT) exit(0);
				if (event.type == SDL_KEYUP) keyx = event.key.keysym.sym;
			}
		} while (key != keyx);

		if (key == SDLK_BACKSPACE)
		{
			strcpy(ofl, C_DirWork::LastDirName(path));
			strcpy(path, C_DirWork::LevelUp(path));
		}
		else
		if (key == SDLK_RETURN)
		{
			if (folders[csr])
			{
				strcpy(ofl, C_DirWork::LastDirName(path));
				if (!strcmp(fnames[csr], "..")) strcpy(path, C_DirWork::LevelUp(path));
				else
				{
					strcpy(path, C_DirWork::ExtractPath(path));
					strcat(path, fnames[csr]);
					strcat(path, "/");
				}
			}
			else
			{
				strcpy(path, dw.ExtractPath(path));
				strcat(path, fnames[csr]);
				return path;
			}
		}
	} while (key != SDLK_ESCAPE);

	return NULL;
}

void FileDialog(void)
{
	char *fname;

	disableSound = true;

	SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
	fname = SelectFile(oldFileName[currentDrive]);
	SDL_EnableKeyRepeat(0, SDL_DEFAULT_REPEAT_INTERVAL);

	if (fname != NULL)
	{
		strcpy(oldFileName[currentDrive], fname);
		TryNLoadFile(oldFileName[currentDrive], currentDrive);
	}

	disableSound = false;
}

void FileDialogInit(void)
{
	char *str;

	if (config.GetString("root/Drives/A", &str)) strcpy(oldFileName[0], str);
	else strcpy(oldFileName[0], "/");
}
