#include <string.h>
#include "dirwork.h"
#include "exceptions.h"

#ifdef _WIN32

C_DirWork::C_DirWork()
{
	hFile = -1;
}

C_DirWork::~C_DirWork()
{
	if (hFile != -1) _findclose(hFile);
}

bool C_DirWork::EnumFiles(char *pathNmask)
{
	if (hFile != -1) throw C_E(E_DirWork);
	hFile = _findfirst(pathNmask, &cf);

	if (hFile != -1)
	{
		strcpy(name, cf.name);
		attr = (cf.attrib & _A_SUBDIR) ? DW_FOLDER : DW_NORMAL;
		size = cf.size;
		return true;
	}

	return false;
}

bool C_DirWork::EnumNext(void)
{
	if (hFile == -1) throw C_E(E_DirWork);

	if (_findnext(hFile, &cf) == 0)
	{
		strcpy(name, cf.name);
		attr = (cf.attrib & _A_SUBDIR) ? DW_FOLDER : DW_NORMAL;
		size = cf.size;
		return true;
	}

	return false;
}

void C_DirWork::EnumClose(void)
{
	if (hFile == -1) throw C_E(E_DirWork);
	_findclose(hFile);
	hFile = -1;
}

#endif	// _WIN32

#ifdef _LINUX

#include <sys/stat.h>

// TODO: at this time all functions ignore file mask. do it ^_~

C_DirWork::C_DirWork()
{
	hDir = NULL;
}

C_DirWork::~C_DirWork()
{
	if (hDir != NULL) closedir(hDir);
}

bool C_DirWork::EnumFiles(char *pathNmask)
{
	struct dirent *di;
	struct stat st;
	char path[MAX_PATH];

	if (hDir != NULL) throw C_E(E_DirWork);

	strcpy(bpath, ExtractPath(pathNmask));
	hDir = opendir(bpath);
	if (hDir == NULL) return false;

	di = readdir(hDir);
	if (di == NULL)
	{
		closedir(hDir);
		hDir = NULL;
		return false;
	}

	strcpy(name, di->d_name);
	strcpy(path, bpath);
	strcat(path, name);
	stat(path, &st);

	attr = (S_ISDIR(st.st_mode)) ? DW_FOLDER : DW_NORMAL;
	size = st.st_size;
	return true;
}

bool C_DirWork::EnumNext(void)
{
	struct dirent *di;
	struct stat st;
	char path[MAX_PATH];

	if (hDir == NULL) throw C_E(E_DirWork);

	di = readdir(hDir);
	if (di == NULL) return false;

	strcpy(name, di->d_name);
	strcpy(path, bpath);
	strcat(path, name);
	stat(path, &st);

	attr = (S_ISDIR(st.st_mode)) ? DW_FOLDER : DW_NORMAL;
	size = st.st_size;
	return true;
}

void C_DirWork::EnumClose(void)
{
	if (hDir == NULL) throw C_E(E_DirWork);

	closedir(hDir);
	hDir = NULL;
}

char* C_DirWork::Normalize(char *path)
{
	static char result[MAX_PATH];

	if (realpath(path, result) == NULL)
	{
		strcpy(result, "/");
		return result;
	}

	if (strcmp(result, "/")) strcat(result, "/");
	return result;
}

#endif	// _LINUX

char* C_DirWork::LevelUp(char *path)
{
	int i, l;
	static char result[MAX_PATH];

	l = strlen(path)-1;
	while (l >= 0)
	{
		if (path[l] == '/') break;
		l--;
	}

	if (l < 0)
	{
		strcpy(result, "../");
		return result;
	}

	if (l == 0)
	{
		strcpy(result, "/");
		return result;
	}

	l--;

	if (l > 0)
	{
		if (path[l]=='.' && path[l-1]=='.')
		{
			if (l == 1)
			{
				strcpy(result, "../../");
				return result;
			}

			if (path[l-2] == '/')
			{
				for (i = 0; i <= l; i++) result[i] = path[i];
				result[i] = 0;

				strcat(result, "/../");
				return result;
			}
		}
	}

	while (l >= 0)
	{
		if (path[l] == '/') break;
		l--;
	}

	if (l < 0)
	{
		strcpy(result, "");
		return result;
	}

	for (i = 0; i <= l; i++) result[i] = path[i];
	result[i] = 0;

	return result;
}

char* C_DirWork::ExtractPath(char *path)
{
	int i, l;
	static char result[MAX_PATH];

	l = strlen(path)-1;
	while (l >= 0)
	{
		if (path[l] == '/') break;
		l--;
	}

	if (l < 0)
	{
		strcpy(result, "");
		return result;
	}

	for (i = 0; i <= l; i++) result[i] = path[i];
	result[i] = 0;

	return result;
}

char* C_DirWork::ExtractExt(char *path)
{
	int i, l, le;
	static char result[MAX_PATH];

	le = strlen(path);
	l = le - 1;

	while (l >= 0)
	{
		if (path[l] == '.') break;
		l--;
	}

	if (l < 0)
	{
		strcpy(result, "");
		return result;
	}

	l++;
	for (i = 0; i < le-l; i++) result[i] = path[i+l];
	result[i] = 0;

	return result;
}

char* C_DirWork::ExtractFileName(char *path)
{
	int i, l;
	static char result[MAX_PATH];

	l = strlen(path)-1;
	while (l >= 0)
	{
		if (path[l] == '/') break;
		l--;
	}

	if (l < 0)
	{
		strcpy(result, path);
		return result;
	}

	l++;
	for (i = l; i < strlen(path); i++) result[i-l] = path[i];
	result[i-l] = 0;

	return result;
}

char* C_DirWork::LastDirName(char *path)
{
	static char result[MAX_PATH];

	if (realpath(C_DirWork::ExtractPath(path), result) == NULL)
	{
		strcpy(result, "");
		return result;
	}

	return C_DirWork::ExtractFileName(result);
}
