#ifndef _DIRWORK_H_
#define _DIRWORK_H_ 1

#include "defines.h"

#ifdef _WIN32
	#include <io.h>
#endif

#ifdef _LINUX
	#include <sys/types.h>
	#include <dirent.h>
#endif

#define DW_NORMAL 0
#define DW_FOLDER 1

class C_DirWork
{
	public:

	C_DirWork();
	~C_DirWork();

	bool EnumFiles(char *pathNmask);
	bool EnumNext(void);
	void EnumClose(void);

	static char* Normalize(char *path);
	static char* LevelUp(char *path);
	static char* ExtractPath(char *path);
	static char* ExtractExt(char *path);
	static char* ExtractFileName(char *path);
	static char* LastDirName(char *path);

	char name[MAX_PATH];
	int attr;
	long size;

	private:

#ifdef _WIN32
	struct _finddata_t cf;
	long hFile;
#endif

#ifdef _LINUX
	DIR *hDir;
	char bpath[MAX_PATH];
#endif

};

#endif
