#ifndef _ZEMU_H_INCLUDED_
#define _ZEMU_H_INCLUDED_

#include "defines.h"
#include "SDL.h"
#include "lib_z80ex/z80ex.h"
#include "lib_ay/sndrender.h"
#include "config.h"

#define WIDTH 320
#define HEIGHT 240

#define FRAME_WAIT_MS 20
#define MAX_SPEED_FRAME_SKIP 64

#define AUDIO_HW_BUFFER 1024
#define MIX_BUFFER_SIZE 2048
#define SOUND_BUFFER_SIZE ((MIX_BUFFER_SIZE) * 2)

struct s_Action
{
	char *name;
	void (* action)(void);
};

struct s_Params
{
	bool fullscreen;
	bool sound;
	bool maxSpeed;
	bool antiFlicker;
	bool sdl_sound;
	int mouseDiv;
	bool showInactiveIcons;
	int ossFragNum;
};

extern C_Config config;
extern Z80EX_CONTEXT *cpu;
extern unsigned long long clk, devClk, lastDevClk, devClkCounter;
extern s_Params params;
extern SDL_Surface *screen;
extern int PITCH;
extern bool drawFrame;
extern int frames;
extern bool disableSound;

extern s_Action cfgActions[];

//--------------------------------------------------------------------------------------------------------------

#define MAX_HANDLERS 64

void AttachZ80ReadHandler(bool (* func)(Z80EX_WORD, bool, Z80EX_BYTE&));
void AttachZ80WriteHandler(bool (* func)(Z80EX_WORD, Z80EX_BYTE));
void AttachZ80InputHandler(bool (* func)(Z80EX_WORD, Z80EX_BYTE&));
void AttachZ80OutputHandler(bool (* func)(Z80EX_WORD, Z80EX_BYTE));
void AttachFrameStartHandler(void (* func)(void));
void AttachAfterFrameRenderHandler(void (* func)(void));
void AttachSDLHandler(int eventType, bool (* func)(SDL_Event&));
void AttachResetHandler(void (* func)(void));

//--------------------------------------------------------------------------------------------------------------

void TryNLoadFile(char *fname);
void TryNLoadFile(char *fname, int drive);

#endif
