        ; zxn-m0.asm
        ;
        ;   ZX-NEXT (http://zxnext.narod.ru/zxnext.htm).
        ; :  ,  .
        ; -------------------------------------------------------------------
        ;
        ;      NEXT ROM VIDEO, 2011-11-15.
        ;  ZX-SPECTRUM.
        ;
        ;       - .  readme.txt.
        ;
        ;     :
        ;    Mdesk, zx-pk.ru, 15  2011 .
        ;    http://zx-pk.ru/showthread.php?t=112
        ;

        OUTPUT zxn-m0.bin
        
        ORG     #0000
        DI
        LD      H, high START1 + #60
        LD      L, low START1
        LD      SP, HL             
        LD      A, H
        LD      I, A
        JP      (HL)

        ; START1 - START3 -      
        ; START1 -    C5 (/INT),   CPU
START1  LD      B, #FF
        DJNZ    $
        LD      L, low START2
        EI
        HALT                    ; V21 (RES) -> 0     1.
                                ;  nINT,   START2

        ; START2 -    C5 (/INT)  /Q4
START2  LD      (HL), D         ; 103T  IN A,(C).    =   D10. #00 -> D10.
        LD      B, 5
        DJNZ    $
        NOP
        NOP
        LD      L, low TAB2
        LD      DE, #0000
        LD      B, H
        IN      A, (C)          ; /Q4 -> .  A
        RRCA                    ; 23T  IN A,(C)
        RL      E
        LD      A, (HL)
        NOP
        IN      A, (C)          ; /Q4 -> .  A
        RRCA
        RL      E               ; E = 0, 1, 2  3, ..  4  ""   C5 (/INT)
        ADD     HL, DE          ; HL -   TAB2
        LD      L, (HL)         ; HL -   (CORR0, CORR1, CORR2  CORR3)    
        SCF
        JP      (HL)            ;  CORR0, CORR1, CORR2  CORR3

CORR0   NOP                     ; 4T
        JR      CONT

CORR1   RET     NC              ; 5T
        JR      CONT

CORR2   LD      A, (HL)         ; 7T
        JR      CONT

        BLOCK   #0038 - $, #FF
nINT    JP      (HL)            ;  START2  START3. V13 = 0     D4, D6.
        
CORR3   INC     DE              ; 6T
        JR      CONT

CONT    LD      B, 3            ; 62T  JP nINT
        DJNZ    $
        LD      A, (HL)
        LD      A, (HL)
        LD      L, low START3
        JP      nINT            ;  nINT,   START3

        ; START3 -  , ,     
START3  LD      B, 5            ; 117T  JP (HL)  ADD0
        DJNZ    $
        LD      A, I
        LD      A, (HL)
        LD      D, #0F
        LD      H, high ADD0 + #60
        LD      L, low ADD0             
        LD      A, H
        LD      I, A
        JP      (HL)            ;  ADD0

TAB1    DEFB    #2F, #37, #37, #3F, #3F, #47, #47, #4F, #4F
TAB2    DEFB    low CORR0, low CORR1, low CORR2, low CORR3

        ; 1 -     312.
ADD0    LD      (HL), D         ; SYNH -> 1, BORD -> 1.
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        LD      A, I
        LD      B, 13
        DJNZ    $
        LD      D, #0E
        LD      (HL), D
        NOP
        INC     D

        ; 2
        LD      (HL), D         ; SYNH -> 1
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        LD      A, I
        LD      B, 13
        DJNZ    $
        LD      D, #16
        LD      (HL), D
        NOP
        INC     D
   
        ; 3
        LD      (HL), D         ; SYNH -> 1
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        LD      A, (HL)
        LD      A, (HL)
        NOP
        LD      B, 11
        DJNZ    $
        LD      D, #57
        LD      L, low ADD1
        SET     4, H
        LD      A, H
        LD      I, A
        JP      (HL)            ; KSYN -> 1

        ; 4
ADD1    LD      (HL), D         ; SYNH -> 1
        LD      A, (HL)
        NOP
        LD      B, 14
        DJNZ    $
        LD      D, #1E
        LD      (HL), D         ; SYNH -> 0
        NOP
        INC     D
        
        ; 5
        LD      (HL), D         ; SYNH -> 1
        LD      A, (HL)
        NOP
        LD      B, 14
        DJNZ    $
        LD      D, #5E
        LD      (HL), D         ; SYNH -> 0
        NOP
        INC     D
        
        ; 6
        LD      (HL), D         ; SYNH -> 1
        LD      A, (HL)
        LD      A, (HL)
        NOP
        LD      B, 11
        DJNZ    $
        LD      D, #26
        LD      L, low ADD2
        RES     4, H
        LD      A, H
        LD      I, A
        JP      (HL)            ; KSYN -> 0
ADD2    LD      (HL), D         ; SYNH -> 0
        NOP
        INC     D
        
        ; 7
        LD      (HL), D         ; SYNH -> 1
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        INC     DE
        LD      B, 7
        DJNZ    $
        LD      L, low ADD3
        LD      E, IYL          ;   FLASH
        LD      A, E
        AND     #20
        ADD     A, A
        ADD     A, A
        XOR     H               ;  32  FLASH 
        RES     5, E            ; 32 -> 0
        INC     E
        LD      IYL, E
        LD      H, A            
        LD      I, A
        JP      (HL)            ; FLASH
ADD3    LD      A, (HL)
        LD      A, (HL)
        LD      A, (HL)
        LD      D, #23
        
        ; 8
        LD      (HL), D         ; SYNH -> 1, INT -> 0
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        SET     2, D
        LD      (HL), D         ; INT -> 1
        LD      A, (HL)
        NOP
        NOP
        LD      B, 12
        DJNZ    $
        LD      D, #2F
        LD      C, #6E
        
        ; 9
        LD      (HL), D         ; SYNH -> 1
        NOP
        NOP
        LD      (HL), C         ; SYNH -> 0
        NOP
        LD      B, 13
        DJNZ    $
        LD      E, #09
        LD      L, low TAB1 - 1
ADD4    INC     HL
        LD      D, (HL)
        
        ; 10-18
        LD      (HL), D         ; SYNH -> 1
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        NOP
        NOP
        LD      A, (HL)
        LD      B, 12
        DJNZ    $
        DEC     E
        JR      NZ, ADD4
        LD      A, (HL)
        NOP
        LD      D, #D7

        ; 19
        LD      (HL), D         ; SYNH -> 1
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        SET     0, H            ;  .   : #60->#61  #E0->#E1
        LD      A, (HL)
        LD      B, 12
        DJNZ    $
        LD      C, #D6
        LD      D, #56
        LD      (HL), D
        NOP
        INC     D
        
        ; 20
        LD      (HL), D         ; SYNH -> 1
        NOP
        NOP
        LD      (HL), C         ; SYNH -> 0
        LD      A, I
        LD      B, 13
        DJNZ    $
        LD      D, #5E
        LD      (HL), D
        NOP
        INC     D
        
        ; 21
        LD      (HL), D         ; SYNH -> 1
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        LD      A, (HL)
        LD      A, (HL)
        LD      B, 14
        DJNZ    $
        INC     D
        
        ; 22
        LD      (HL), D         ; SYNH -> 1
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        NOP
        NOP
        LD      B, 12
        DJNZ    $
        LD      L, low ADD5
        LD      A, H
        AND     #BF
        LD      B, A            ; .  ADD5: #21  #A1
        LD      C, #5E
        LD      D, #67
        
        ; 23
        LD      (HL), D         ; SYNH -> 1
        NOP
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        LD      H, B
        LD      A, H
        LD      I, A
        JP      (HL)            ; BLANK -> 0
ADD5    OUT     (C), C          ;    =   D11.
        NOP
        LD      B, 4
        DJNZ    $
        LD      E, low ADD7
        LD      B, H            ; .  ADD7: #21  #A1
        LD      A, #07
        LD      IYH, A
        LD      C, #50
        LD      A, #40          ;   24-71
        EX      AF, AF'
        LD      D, #46
        LD      L, low ADD6
        LD      A, H
        XOR     #60             ; .  ADD6: #41  #C1
        AND     A
        RET     C
        LD      (HL), D
        RET     C
        INC     D
        LD      H, A
        LD      I, A
        JP      (HL)            ; BLANK -> 1, V13 -> 0
        
        ; 24-71, 72-263, 264-312 
ADD6    LD      (HL), D         ; SYNH -> 1
        LD      L, E
        DEC     D
        LD      (HL), D         ; SYNH -> 0
        LD      H, B
        LD      A, H
        LD      I, A
        JP      (HL)            ; BLANK -> 0, V13 -> 1
        
        ; 24-71  ADD7, 72-263  ADD10, 264-312  ADD7
ADD7    OUT     (C), C
        SET     1, D
        LD      (HL), D
        XOR     #60             ; .  ADD6: #41  #C1
        EX      AF, AF'
        ADD     A, #04          ;  
        LD      L, A
        AND     #C7
        OR      #10
        LD      C, A            ; C -    D11   
        LD      A, L
        OR      IYH
        LD      D, A            ; D -    D10       
        LD      A, L
        OR      A
        JR      Z, ADD8         ;  24-71 ,   ADD8.
                                ;  A = 0,      72-263.
        CP      #06
        JR      Z, ADD11        ;  264-312 ,   ADD11.
        RET     Z
        RET     Z
        LD      E, low ADD7
        LD      L, low ADD6
        DEC     D
        EX      AF, AF'
        AND     A
        LD      (HL), D
        RET     C
        INC     D
        LD      H, A
        LD      I, A
        JP      (HL)            ; BLANK -> 1, V13 -> 0,  ADD6

ADD8    LD      E, #00          
        LD      E, low ADD10
        JR      ADD9
ADD9    LD      L, low ADD6
        DEC     D
        EX      AF, AF'
        AND     A
        LD      (HL), D         ; BORD -> 1  72-263
        RET     C
        INC     D
        LD      H, A
        LD      I, A
        JP      (HL)            ; BLANK -> 1, V13 -> 0,  ADD6
        
        ; 72-263 
ADD10   OUT     (C), C
        RES     1, D
        LD      (HL), D         ; BORD -> 0
        XOR     #60             ; .  ADD6: #41  #C1
        EX      AF, AF'
        INC     A               ;  
        LD      L, A
        AND     #D7
        OR      #10
        LD      C, A            ; C -    D11   
        LD      A, L
        OR      IYH
        LD      D, A            ; D -    D10
        LD      A, L
        CP      #C0
        JR      NZ, ADD8        ;  72-263  ,   ADD8
        RET     NZ              ;  5 
        LD      A, #42          ;   264-312
        LD      E, low ADD7
        JR      ADD9 

        ; 312, 
ADD11   EX      AF, AF'
        LD      A, I
        NOP
        NOP
        NOP
        NOP
        LD      L, low ADD0
        LD      A, B            ; B = #21  #A1
        XOR     #41             ;  .  ADD0: #21->#60  #A1->E0
        LD      H, A
        LD      I, A
        JP      (HL)            ; BLANK -> 1,   ADD0 ( )
        
        BLOCK   #0400 - $, #FF
