$MOD51
$nolist
FADDR		EQU	0a0h		; fixed address for AT24Cxx EEPROMs
PADDR		EQU	0		; programmable address (0..7)
;SIZE		EQU	2000h		; bytes per AT24C64
PSIZE		EQU	32		; bytes per page for AT24C64
FILL		EQU	0ff2h		; example fill value

; Register definitions.

index		EQU	r0		; buffer pointer
kount		EQU	r1		; byte count register
zdata		EQU	r1		; data register
addr_lo		EQU	r2		; 2-byte address register
addr_hi		EQU	r3		;
ram_locate	equ     r7

SCL		BIT	p1.4		; serial clock
SDA		BIT	p2.3
OK		BIT  	p1.5
EN		BIT 	p2.2		; indikator EN
RST		BIT    	p2.1		; indikator RST
beeper		BIT 	p2.0
KEY_SW1		BIT    	p1.6
CD		BIT 	p1.7		; indikator CD


 ;   CD              EQU    P1.2     ; DATA=HIGH /CONTROL=LOW
 ;   EN              EQU    P1.3     ; ENABLE
 ;   RST             EQU    P1.4     ; REST=LOW
;----------------------------------------




;--------------------------------------------------------------
	


		; serial data
		DSEG AT 20H
		ORG	40H
buffer:		DS	PSIZE		; storage for read/write data
             	ORG	60H		; stack origin
stack:		DS	80H		; stack depth
		CSEG
		ORG	0000H		; power on/reset vector
		jmp	on_reset
		ORG	0003H		; external interrupt 0 vector
		jmp	on_reset			; undefined
		ORG	000BH		; timer 0 overflow vector
		jmp	on_reset			; undefined
		ORG	0013H		; external interrupt 1 vector
		jmp	on_reset			; undefined
		ORG	001BH		; timer 1 overflow vector
		jmp	on_reset			; undefined
		ORG	0023H		; serial I/O interrupt vector
		jmp	on_reset			; undefined
		ORG	0080H		; begin code space
		USING	0		; register bank zero
on_reset:	setb IE.7
		mov	sp, #(stack-1)	; initialize stack pointer

		; Initialize AT24Cxx serial bus lines.

		setb	SDA		; high
		setb	SCL		; high
;----------------------------------------------------------------		
		call port_init
;----------------------------------------------------------------
		call zaderj
call zaderj
call zaderj
call zaderj
		MOV A,0H

                MOV R3,#07fh		;HIGH	
                MOV R2,#0FFh		;LOW
                mov r1,#0aah		;data
		mov dptr,#07fffh	
		CALL write_b
;--------------------------------------------------------

		call wait
		call wait
		
call scr_main

		call gauge_init
		
		mov dptr,#text1
		call print_1
		call ZADERJ
		CALL beep_hi
		mov dptr,#text2
		call print2
		call ZADERJ
		mov dptr,#text3
		call print3
		call ZADERJ
		call beep_low
		call ZADERJ
		call beep_low
		




                mov dptr,#07fffh
		call read_b
		cjne a,#0aah,fault_long
		sjmp go_1
fault_long:	nop
		mov dptr,#text31
		call print4
		call ZADERJ
		mov dptr,#text32
		call print5
		call ZADERJ

		jmp fault	


	
go_1:		mov (p0),a
		mov (p1),#0ffh
;		call wait
main:		nop				
;		call beep_hi
;		call beep_low
		
		
		mov dptr,#text4
		call print4
		call ZADERJ
		mov dptr,#text5
		call print4
		call ZADERJ
		mov dptr,#07fffh
		call read_b
		;cjne a,#0aah,faultt

	rrr:	mov dptr,#text6
		call print4
		call ZADERJ
		mov dptr,#text7
		call print4
		call ZADERJ
		mov dptr,#text8
		call print4
		call ZADERJ
		mov dptr,#text9
		call print5

		call ZADERJ
		mov dptr,#text10
		call print5
		call ZADERJ
		mov dptr,#text11
		call print5
		call ZADERJ
		mov dptr,#text12
		call print5
		call ZADERJ
		mov dptr,#text78
		call print5
		call ZADERJ
		call beep_low
		call beep_hi
	
;----------------------------
		mov a,#01h
zed1:		nop
		push acc
		call gauge_add
		;call ZADERJ
		;call beep_low
		call beep_hi
		pop acc 
		inc a

		cjne a,#054h,zed1

;---------------------------------
		call 	prog_disp
		

		call wait
;		ljmp prog_nex1
;jgut_net1:	ljmp jgut_net
;prog_nex1:	call beep_hi
;-----------------------------------------------------

		call cls		
		call ZADERJ

		
		mov dptr,#text47
		call print_1
		mov dptr,#text48
		call print2
		mov dptr,#text49
		call print3
		mov dptr,#text50
		call print4
		call ZADERJ
;--------------------------------------; show key_sw	call ZADERJ
		mov c,KEY_SW1
		jnc  write_shnu
		ljmp go2
write_shnu:	ljmp write_shnur		

go2:		clr  c
		call ZADERJ
		call ZADERJ		
		call  beep_hi
		call ZADERJ
		call  beep_hi

		call scr_MAIN

				call cls
		call beep_low
		call beep_low
		call beep_hi
				
		sjmp read_shnur

		ljmp on_reset	
		

		
;------------------------------------------------------------------		

;---------------------------------------------------
;		 mov r1,#0aah		;data
;		mov dptr,#07fffh	
;		CALL write_b
;		call wait
;		call wait
;		mov dptr,#07fffh
;		call read_b
;		cjne a,#0aah,fault_long

zal1:		sjmp zal1



read_shnur:     	;nomer in a

		call gauge_init
	;==================	
		mov dptr,#text18
		call print2
		call port_init
		nop
		call get_progno
		
		mov dpl,0
		mov dph,a
		mov r7,#0h
		mov r6,#00fh   ; 0f
readl1:		mov (p1),r6
		mov r5,(p0)  ; get and verify p0 state 
		call read_b           ;data from eeprom to a data b r5
 		mov b,r5	
		cjne a,b,err_read
		inc dptr
		mov r5,(p3)  ; get and verify p3 state 
		mov b,r5
		call read_b
 		cjne a,b,err_read
		inc dptr
		;-----------------------

;--------------------------------------------------
		mov a,r6
		cpl a
		
		anl a,#0Fh
		clr c 
		inc a
	
		
		
		call gauge_add
		call zaderj

;-------------------------------------------------------------------
		djnz r6,readl1              ;p spt

		mov (p1),r6
		mov r5,(p0)  ; get and verify p0 state 
		call read_b
		mov b,r5	
		cjne a,b,err_read
		inc dptr
		mov r5,(p3)  ; get and verify p0 state 
		mov b,r5
		call read_b
		cjne a,b,err_read
		inc dptr





		call beep_low
		call port_init
;		setb ok
		call beep_hi
		call wait
		call wait
		call beep_hi
		call wait
		call wait
		jmp on_reset
;--------------------------------------------------------------------



err_read:	nop
		;dpl iz step
		mov b,dpl
		mov dph,#10
		call get_progno

		mov r1,a
err_c:		inc dph
		djnz r1,err_c
		
;-----------------------------------------------
		;add dph,a
		;                     adres #1|a|dpl|
		




		call eeprn1	
		
		call beep_low
		call beep_low
		call beep_low
		call beep_low
		call beep_low
		call beep_hi
		call beep_hi
		call port_init		
zzz1:		ajmp zzz1


;		jc	fault

write_disp:	ret ;display routines
;err_read_errp:	nop
err_no_type:	nop
err_read_errp1: nop
err_unknown:    nop
	


fault:  
		;MOV P1,#001
		call scr_main
		mov dptr,#text31
		call print4
		call ZADERJ
		mov dptr,#text32
		call print5
		call ZADERJ

		
fault_1:	nop;
	
		
		call beep_low	
		ajmp	fault_1



write_b:	nop ; DPTR - ADRESS
		mov r3,dph
		mov r2,dpl
		mov a,0
		call write_byte
		jc fault
		ret


read_b:		nop ;DPTR - ADRESS
		mov r3,dph
		mov r2,dpl
		mov a,0
		call read_random
		jc fault
		ret

;		print


lcd_ini:                    LCALL       INICIALIZA
                    SETB        SDA
                    CALL        SCL_HIGH
                    SETB        CD
                    SETB        EN


                    CALL        RST_LCD
			ret


;---------middle--------------------------------------

write_shnur:	CLR C
		call cls
		mov dptr,#text80
		call print_1
		call gauge_init
				       

	        call beep_low
		call wait	
		call beep_hi
		call wait
		call port_init
		
		call get_progno
		mov dpl,0
		mov dph,a
		mov r7,#0h
		mov r6,#0fh
write1:		nop
		call port_init
		mov (p1),r6
		mov r1,(p0)  ; get and verify p0 state 
		call write_b
 		call wait
		inc dptr
		mov r1,(p3)  ; get and verify p3 state 
		call write_b
		call wait
 		inc dptr
		djnz r6,write1
;-------------------------------------------
		;call port_init
		mov (p1),r6
		mov r1,(p0)  ; get and verify p0 state 
		call write_b
 		call wait
		inc dptr
		mov r1,(p3)  ; get and verify p0 state 
		call write_b
		;++++++++++++++
		;write ok
		;call scr_main
		call de_sub_wr
		CALL ZADERJ
		
		
		mov dptr,#text46        ;write ok
		call print3
		call wait
		call zaderj
		mov dptr,#text99
		call print5

		call zaderj
		call zaderj
		call zaderj
		ljmp on_reset

;---------------------------------------------------------------------------------







;-----------                           --desub 

de_sub_wr:	call get_progno
		mov r1,a
		jz jgut_net2
		mov dptr,#jgut0
jgut_lop1:	inc dptr
		inc dptr
		inc dptr	
		inc dptr
	
		
		inc dptr
		inc dptr

		inc dptr
		inc dptr	
		inc dptr
		inc dptr
		
		djnz r1,jgut_lop1
		call print5
		ret
jgut_net2:	ljmp jgut_net
;------------sub---------------------------------------------

write_byte:

	; AT24Cxx Byte Write function.
	; Called with programmable address in A, byte address in
	; register pair ADDR_HI:ADDR_LO, data in register XDATA.
	; Does not wait for write cycle to complete.
	; Returns CY set to indicate that the bus is not available
	; or that the addressed device failed to acknowledge.
	; Destroys A.

		call	start
		jc	x49		; abort if bus not available

		rl	a		; programmable address to bits 3:1
		orl	a, #FADDR	; add fixed address
		clr	acc.0		; specify write operation
		call	shout		; send device address
		jc	x48		; abort if no acknowledge

		mov	a, addr_hi	; send high byte of address
		call	shout		;
		jc	x48		; abort if no acknowledge

		mov	a, addr_lo	; send low byte of address
		call	shout		;
		jc	x48		; abort if no acknowledge

		mov	a, zdata	; get data
		call	shout		; send data
		jc	x48		; abort if no acknowledge

		clr	c		; clear error flag
	x48:
		call	stop
	x49:
		ret


read_current:

	; AT24Cxx Current Address Read function.
	; Called with programmable address in A. Returns data in A.
	; Returns CY set to indicate that the bus is not available
	; or that the addressed device failed to acknowledge.

		call	start
		jc	x45		; abort if bus not available

		rl	a		; programmable address to bits 3:1
		orl	a, #FADDR	; add fixed address
		setb	acc.0		; specify read operation
		call	shout		; send device address
		jc	x44		; abort if no acknowledge

		call	shin		; receive data byte
		call	NAK		; do not acknowledge byte
		clr	c		; clear error flag
	x44:
		call	stop
	x45:
		ret


read_random:

	; AT24Cxx Random Read function.
	; Called with programmable address in A, byte address in
	; register pair ADDR_HI:ADDR_LO. Returns data in A.
	; Returns CY set to indicate that the bus is not available
	; or that the addressed device failed to acknowledge.

		push	b
		mov	b, a		; save copy of programmable address

		; Send dummy write command to set internal address.

		call	start
		jc	x47		; abort if bus not available

		rl	a		; programmable address to bits 3:1
		orl	a, #FADDR	; add fixed address
		clr	acc.0		; specify write operation
		call	shout		; send device address
		jc	x46		; abort if no acknowledge

		mov	a, addr_hi	; send high byte of address
		call	shout		;
		jc	x46		; abort if no acknowledge

		mov	a, addr_lo	; send low byte of address
		call	shout		;
		jc	x46		; abort if no acknowledge

		; Call Current Address Read function.

		mov	a, b		; get programmable address
		call	read_current
		jmp	x47		; exit
	x46:
		call	stop
	x47:
		pop	b
		ret


start:

	; Send START, defined as high-to-low SDA with SCL high.
	; Return with SCL, SDA low.
	; Returns CY set if bus is not available.

		setb	SDA
		setb	SCL

		; Verify bus available.

		jnb	SDA, x40	; jump if not high
		jnb	SCL, x40	; jump if not high

		nop			; enforce setup delay and cycle delay
		clr	SDA
		nop			; enforce hold delay
		nop			;
		nop			;
		nop			;
		nop			;
		clr	SCL

		clr	c		; clear error flag
		jmp	x41
	x40:
		setb	c		; set error flag
	x41:
		ret


stop:

	; Send STOP, defined as low-to-high SDA with SCL high.
	; SCL expected low on entry. Return with SCL, SDA high.

		clr	SDA
		nop			; enforce SCL low and data setup
		nop
		setb	SCL
		nop			; enforce setup delay
		nop			;
		nop			;
		nop			;
		nop			;
		setb	SDA
		ret


shout:

	; Shift out a byte to the AT24Cxx, most significant bit first.
	; SCL, SDA expected low on entry. Return with SCL low.
	; Called with data to send in A.
	; Returns CY set to indicate failure by slave to acknowledge.
	; Destroys A.

		push	b
		mov	b, #8		; bit counter
	x42:
		rlc	a		; move bit into CY
		mov	SDA, c		; output bit
		nop			; enforce SCL low and data setup
		setb	SCL		; raise clock
		nop			; enforce SCL high
		nop			;
		nop			;
		nop			;
		clr	SCL		; drop clock
		djnz	b, x42		; next bit

		setb	SDA		; release SDA for ACK
		nop			; enforce SCL low and tAA
		nop			;
		setb	SCL		; raise ACK clock
		nop			; enforce SCL high
		nop			;
		nop			;
		nop			;
		mov	c, SDA		; get ACK bit
		clr	SCL		; drop ACK clock

		pop	b
		ret


shin:

	; Shift in a byte from the AT24Cxx, most significant bit first.
	; SCL expected low on entry. Return with SCL low.
	; Returns received data byte in A.

		setb	SDA		; make SDA an input

		push	b
		mov	b, #8		; bit count
	x43:
		nop			; enforce SCL low and data setup
		nop			;
		nop			;
		setb	SCL		; raise clock
		nop			; enforce SCL high
		nop			;
		mov	c, SDA		; input bit
		rlc	a		; move bit into byte
		clr	SCL		; drop clock
		djnz	b, x43		; next bit

		pop	b
		ret


ACK:

	; Clock out an acknowledge bit (low).
	; SCL expected low on entry. Return with SCL, SDA low.

		clr	SDA		; ACK bit
		nop			; enforce SCL low and data setup
		nop			;
		setb	SCL		; raise clock
		nop			; enforce SCL high
		nop			;
		nop			;
		nop			;
		clr	SCL		; drop clock
		ret


NAK:

	; Clock out a negative acknowledge bit (high).
	; SCL expected low on entry. Return with SCL low, SDA high.

		setb	SDA		; NAK bit
		nop			; enforce SCL low and data setup
		nop			;
		setb	SCL		; raise clock
		nop			; enforce SCL high
		nop			;
		nop			;
		nop			;
		clr	SCL		; drop clock
		ret

wait:		push b 
		mov b,r3
		push b		
		MOV B,R1
		PUSH B
		mov r3,#0FFh
		

on_wait:	MOV R1,#0daH
ON_WAIT_1:	DIV AB ;DUMIIE 48 ;) 
 		
		
		DJNZ R1,ON_WAIT_1		
		
		 
		djnz r3,on_wait
		POP B
		MOV R1,B
		pop b
		mov r3,b
		pop b				
		ret

beep_low:		mov r4,#01h

beep_2:		mov r3,#0afh

beep_1:		cpl beeper
		mov r2,#0c0h
beep_3:		nop
		nop
		nop
		djnz r2,beep_3

		djnz r3,beep_1
		djnz r4,beep_2				
		ret

beep_hi:	mov r4,#01h

beep_h_2:	mov r3,#0afh

beep_h_1:	cpl beeper
		mov r2,#020h
beep_h_3:	nop
		nop
		nop
		djnz r2,beep_h_3

		djnz r3,beep_h_1
		djnz r4,beep_h_2				
		ret
	
prog_disp:	mov dptr,#text36
		call print5
		call ZADERJ
		call beep_low
		call beep_hi
		
		call get_progno
		mov r1,a
		jz jgut_net3
		mov dptr,#jgut0
jgut_loop:	inc dptr
		inc dptr
		inc dptr	
		inc dptr	
		
		inc dptr
		inc dptr

		inc dptr
		inc dptr	
		inc dptr
		inc dptr
		
		djnz r1,jgut_loop
		call print5
		ret
jgut_net3:	ljmp jgut_net



jgut_net:	mov dptr,#jgut0
		call print5
		call beep_hi		
		
		ljmp jgut_net 

cls:		mov dptr,#text78
		call print_1
		mov dptr,#text78
		call print2
		mov dptr,#text78
		call print3
		mov dptr,#text78
		call print4
		mov dptr,#text78
		call print5	
		ret



port_init:	nop			;
		MOV (p0),#0ffh
		MOV (P1),#0ffh
		mov (p2),#0ffh
		mov (p3),#0ffh
		ret

get_progno:	mov a,(p2)        ; get no
		
		swap a
		cpl a
		anl  a,#0fh
		
		ret

print5:	nop ;pe4ataem str 5 |in dptr=>stroka 
		clr c
		push dpl
		push dph
		call setx
		mov b,#45h	
		call CM_LCD
		pop dph
		pop dpl
		ljmp print11
print4:	nop ;pe4ataem str 3 |in dptr=>stroka 
		clr c
		push dpl
		push dph
		call setx
		mov b,#43h	
		call CM_LCD
		pop dph
		pop dpl
		ljmp print11
print3:	nop ;pe4ataem str 2 |in dptr=>stroka 
		clr c
		push dpl
		push dph
		call setx
		mov b,#42h	
		call CM_LCD
		pop dph
		pop dpl
		ljmp print11

print2:	nop ;pe4ataem str 1 |in dptr=>stroka 
		clr c
		push dpl
		push dph
		call setx
		mov b,#41h	
		call CM_LCD
		pop dph
		pop dpl
		ljmp print11
;----------------------------------------------------------
print_1:	nop ;pe4ataem str 0 |in dptr=>stroka 
		clr c
		push dpl
		push dph
		call setx
		mov b,#40h	
		call CM_LCD
		pop dph
		pop dpl
;----------------------------------------------------		
print11:	call get_byte   ;v a=(dptr)
		
		mov r7,dph
		mov r6,dpl          ;sohran s4et4
				

		call symboladr   ; ras4et gfx stroki dptr	
		;dptr->code gfx
				
		call print_2   ; vyvod 8 byte		;nape4 1
		
		mov dpl,r6
		mov dph,r7    ; vostan s4et4
				
		inc dptr      ;+1
		
;2------------------------------------------------------
		call get_byte   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 2
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
;3------------------------------------------------------

		call get_byte   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 3
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
;4------------------------------------------------------
		call get_byte   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 4
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
		inc dptr

;5------------------------------------------------------
		call get_byte   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 5
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr	
		inc dptr
		inc dptr

;6------------------------------------------------------
		call get_byte   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 6
		mov dpl,r6
		mov dph,r7 


		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
;7------------------------------------------------------
		call get_byte   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 7
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr

;8------------------------------------------------------
		call get_byte   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 8
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr

;9------------------------------------------------------
		call get_byte   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 9
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr


;0------------------------------------------------------
		call get_byte   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 10
		mov dpl,r6
		mov dph,r7 
	

;------------------------------------------------------










		ret

;-------------------------------------------------------
		; print 8 bytes in dptr adress of symb
print_2:	mov r5,#8h 
print21:                MOV    A,#0		;
	        MOVC        A,@A+DPTR
                MOV         B,A ; b a 
		
                CALL        DATA_LCD
			
		inc dptr
	        djnz r5,print21
		ret 

;-------------------------------------------------------

;-------------------------------------------------------
get_byte:	mov a,0  ;[a]<=(DPTR
		movc a,@a+DPTR
		ret

;-------------------------------------------------------
symboladr:	;in a-kod symbol
		;ret dptr-adress
		mov dptr,#TABELA1
		;clr c		 
		subb a,#20h
		
		jz netsmes4		
		mov r1,a
countadr:	inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr				
		djnz r1,countadr
		
		ret



netsmes4:	
		
		ret


;--------------------------------print from eeprom-------------------------
;--------------------------------------------------------------------------

eeprn1:		nop ;pe4ataem str 0 |in dptr=>stroka in eeprom 
		clr c
		push dpl
		push dph
		;setx on displ
		call setx
		mov b,#40h	
		call CM_LCD
		pop dph
		pop dpl
;----------------------------------------------------		
print11e:	call get_bytee   ;v a=(kod simvola s4itanogo iz eeprom po adr dptr)
		
		mov r7,dph
		mov r6,dpl          ;sohran s4et4
				

		call symboladr   ; ras4et gfx stroki dptr	
		;dptr->code gfx
				
		call print_2   ; vyvod 8 byte		;nape4 1
		
		mov dpl,r6
		mov dph,r7    ; vostan s4et4
				
		inc dptr      ;+1
		
;2------------------------------------------------------
		call get_bytee   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 2
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
;3------------------------------------------------------

		call get_bytee   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 3
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
;4------------------------------------------------------
		call get_bytee   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 4
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
		inc dptr

;5------------------------------------------------------
		call get_bytee  ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 5
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr	
		inc dptr
		inc dptr

;6------------------------------------------------------
		call get_bytee   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 6
		mov dpl,r6
		mov dph,r7 


		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
;7------------------------------------------------------
		call get_bytee   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 7
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr

;8------------------------------------------------------
		call get_bytee   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 8
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr

;9------------------------------------------------------
		call get_bytee   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 9
		mov dpl,r6
		mov dph,r7 
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr
		inc dptr


;0------------------------------------------------------
		call get_bytee   ;v a=(dptr)
		call symboladr  
		call print_2   ;nape4 10
		mov dpl,r6
		mov dph,r7 
	

;------------------------------------------------------










		ret

;-------------------------------------------------------


;-------------------------------------------------------

;-------------------------------------------------------
get_bytee:	mov a,0  ;[a]<=(DPTR
		call read_b
		ret

;-------------------------------------------------------



;-------------------------------------------------------

gauge_init:	nop
		push acc
		push b
		
				
		call setx
		mov b,#44h	
		call CM_LCD
		mov r1,#54h
gauge_l1:		mov b,#081h
		call DATA_LCD
		djnz r1,gauge_l1
		
		
		pop b
		pop acc

		ret
gauge_add:	push b
		push acc
		
		call setx  ;input a-% +5
		mov b,#044h	
		call CM_LCD
		pop acc
		push acc
		mov r1,a
gauge_l2:	nop
		mov b,#0bdh
		call DATA_LCD
		djnz r1,gauge_l2
		pop acc
		pop b
		ret
		
		

push_stk:	;temp is b? ; b a dph dpl r1
		push b
		mov b,a
		push b
		push dph
		push dpl
		
		mov b,r0
		push b
		mov b,r1
		push b
		mov b,r2
		push b
		mov b,r3
		push b
		mov b,r4
		push b
		mov b,r5
		push b
		mov b,r6
		push b		
		mov b,r7
		push b
		ret ;vse sohraneno
pop_stk:	
		pop b
		mov r7,b
		pop b
		mov r6,b
		pop b
		mov r5,b
		pop b
		mov r4,b
		pop b
		mov r3,b
		pop b
		mov r2,b
		pop b
		mov r1,b
		pop b
		mov r0,b
		pop dpl
		pop dph
		pop b
		mov a,b
		pop b		

		ret

;---------------------------------------------------
  ;   AMARELO         EQU    P3.6     ; LED PISCA PISCA

             ;   SCL             EQU    P1.0     ;
             ;   SDA             EQU    P1.1     ;
             ;   CD              EQU    P1.2     ; DATA=HIGH /CONTROL=LOW
             ;   EN              EQU    P1.3     ; ENABLE
             ;   RST             EQU    P1.4     ; REST=LOW
                ;CX              EQU    80H
                ;CY              EQU    40H
             ;   FLAGS           EQU    20H
                BITCNT          EQU    21H
             ;   BYTECNT         EQU    22H
             ;   LASTREAD        EQU    FLAGS.0
             ;   ACK             EQU    FLAGS.5
             ;   BUS_FLT         EQU    FLAGS.6
             ;   _2W_BUSY        EQU    FLAGS.7
             ;   INTE            EQU    10H
             ;   SEGUNDO1        EQU    12H
             ;  DELAY1          EQU    11H


               ; registros do dallas

                   ;  PCON              EQU  87H
                     MCON              EQU  0C6H
                     TA                EQU  0C7H

              scr_MAIN:
                 ;  MOV         TA,#0AAH
                 ;  MOV         TA,#55H
                   MOV         PCON,#0
                 ;  MOV         MCON,#048H



                  ;  CLR         AMARELO
                  ;  CLR         EA             ; INIBE INTERRUPCOES
                   ; MOV         SP,#50H         ; INICIALIZA STACK
                    LCALL       INICIALIZA
                    SETB        SDA
                    CALL        SCL_HIGH
                    SETB        CD
                    SETB        EN


                    CALL        RST_LCD
                  
            INICIAL:
                    MOV         B,#21H    ; 21
                    CALL        CM_LCD
                    MOV         B,#90H    ;90
                    CALL        CM_LCD
                    MOV         B,#20H    ;20
                    CALL        CM_LCD
                    MOV         B,#0CH    ;0C
                    CALL        CM_LCD
                    CALL        X_Y		;set x y 0/0
                    CALL        LIMPA		;cls
                    CALL        X_Y		;set x y 0/0
                   
	       	 MOV         DPTR,#TABELA1	;mov 
	        ;    CALL        ESCREVE		;
			

			ret
                    
                   
            ESCREVE:nop
                   

             NEXT:				; data to scr
                    MOV         A,#0		;
                    MOVC        A,@A+DPTR
                    CJNE        A,#'%',ES_FIM
                    RET
            ES_FIM:
                    MOV         B,A ; b a 

                    CALL        DATA_LCD
                    INC         DPTR


                    JMP         NEXT


            LIMPA:                        ;o4istaka ekrana
                 MOV         R0,#0
                 MOV         R1,#3
                 MOV         B,#0
         LIMPA_1:
                 CALL        DATA_LCD
                 DJNZ        R0,LIMPA_1
                 DJNZ        R1,LIMPA_1
                 RET

          X_Y:
                 MOV         B,#40H    ;  Y
                 CALL        CM_LCD

setx:		 MOV         B,#80H    ; X
                 CALL        CM_LCD
                 RET


          RST_LCD:
                  CLR        RST
                  CALL       DELAY
                  SETB       RST
                  RET

          CM_LCD:
                  CLR       CD
                  CLR        EN
                  CALL       SEND_BYTE
                  SETB       EN
                  RET

          DATA_LCD:
                  SETB       CD
                  CLR        EN
                  CALL       SEND_BYTE
                  SETB       EN
                  CALL       ATRASO
	          RET

             ; **********************************************************
             ; SUB DELAYS THE BUS
             ; **********************************************************

             DELAY:

        
atraso:	nop

          
                   nop
      
                   nop
			nop
			nop
			nop
		nop
			nop
			nop
                  nop
			nop
			nop 
                   RET
ZADERJ:		mov r1,#0ffh
		mov r2,#0ah
zaderj1:	nop
		
          	
		call delay
		call delay
  	call delay
	call delay
	call delay
	call delay
	call delay
	call delay
	call delay
	
	call delay
	call delay
		
		djnz r1,zaderj1
		djnz r2,zaderj1
		ret

       SEND_BYTE:

              MOV         BITCNT,#08H; SET COUNTER FOR 8-BITS
              CLR         SCL
       SB_LOOP:
              MOV         A,B
              JNB         ACC.7,NOTONE; CHECK TO SEE IF BIT-7 OF
              SETB        SDA        ; ACC IS A 1, AND SET SDA HIGH
              JMP         ONE

       NOTONE:
              CLR         SDA        ; CLR SDA LOW
       ONE:
              CALL        SCL_HIGH               ; TRANSITION SCL LOW-TO-HIGH
              CALL        DELAY
              CLR         SCL        ; TRANSITION SCL LOW-TO-HIGH
              CALL        DELAY
              MOV         A,B
              RL          A
              MOV         B,A
              DJNZ        BITCNT,SB_LOOP; LOOP FOR 8-BITS
              SETB        SDA        ; SET SDA HIGH TO LOOK FOR
              CALL        SCL_HIGH               ; ACKNOWLEDGE PULSE
 RET

      SCL_HIGH:
                 SETB        SCL
                 JNB         SCL,$
                 RET


                INICIALIZA:

                  
                    RET


               
       TABELA1:
           

    

	        db 0, 0, 0, 0, 0
		db 0, 0, 0, 0, 0, 4Eh
		db 5Eh,	4Eh, 0,	0, 0, 0
		db 0, 0Ch, 0, 0, 0Ch, 0
		db 0, 0, 0, 28h, 7Ch, 28h
		db 7Ch,	28h, 0,	0, 0, 28h
		db 54h,	0FEh, 54h, 20h,	0
		db 0, 0, 44h, 20h, 10h,	8
		db 44h,	0, 0, 0, 28h, 54h
		db 58h,	20h, 50h, 0, 0,	8
		db 4, 0, 0, 0, 0, 0
		db 0, 0, 0, 0, 38h, 7Ch
		db 44h,	0, 0, 0, 44h, 7Ch
		db 38h,	0, 0, 0, 0, 0
		db 10h,	54h, 38h, 54h, 10h
		db 0, 0, 0, 10h, 10h, 7Ch
		db 10h,	10h, 0,	0, 0, 80h
		db 0E0h, 60h, 0, 0, 0, 0
		db 0, 10h, 10h,	10h, 10h, 10h
		db 0, 0, 0, 60h, 60h, 0
		db 0, 0, 0, 0, 0, 28h
		db 44h,	54h, 7Ch, 38h, 0, 0
		db 0, 38h, 7Ch,	44h, 7Ch, 38h
		db 0, 0, 0, 0, 48h, 7Ch
		db 7Ch,	40h, 0,	0, 0, 48h
		db 64h,	74h, 5Ch, 48h, 0, 0
		db 0, 28h, 44h,	54h, 7Ch, 28h
		db 0, 0, 0, 30h, 28h, 7Ch
		db 7Ch,	20h, 0,	0, 0, 2Ch
		db 4Ch,	54h, 74h, 20h, 0, 0
		db 0, 38h, 7Ch,	54h, 74h, 20h
		db 0, 0, 0, 4, 74h, 7Ch
		db 0Ch,	4, 0, 0, 0, 28h
		db 7Ch,	54h, 54h, 7Ch, 28h
		db 0, 0, 8, 5Ch, 54h, 7Ch
		db 38h,	0, 0, 0, 0, 48h
		db 48h,	0, 0, 0, 0, 0
		db 80h,	0C8h, 48h, 0, 0, 0
		db 0, 0, 0, 10h, 38h, 6Ch
		db 44h,	0, 0, 0, 28h, 28h
		db 28h,	28h, 0,	0, 0, 0
		db 44h,	6Ch, 38h, 10h, 0, 0
		db 0, 0, 4, 54h, 5Ch, 8
		db 0, 0, 0, 38h, 7Ch, 10h
		db 38h,	44h, 7Ch, 38h, 0, 0
		db 38h,	7Ch, 14h, 7Ch, 38h
		db 0, 0, 0, 38h, 7Ch, 54h
		db 7Ch,	28h, 0,	0, 0, 38h
		db 7Ch,	44h, 6Ch, 28h, 0, 0
		db 0, 7Ch, 7Ch,	44h, 7Ch, 38h
		db 0, 0, 0, 38h, 7Ch, 54h
		db 5Ch,	8, 0, 0, 0, 38h
		db 7Ch,	14h, 4,	0, 0, 0
		db 0, 38h, 7Ch,	44h, 54h, 30h
		db 0, 0, 0, 38h, 7Ch, 10h
		db 7Ch,	38h, 0,	0, 0, 0
		db 44h,	7Ch, 7Ch, 44h, 0, 0
		db 0, 20h, 60h,	40h, 7Ch, 38h
		db 0, 0, 0, 38h, 7Ch, 10h
		db 28h,	44h, 0,	0, 0, 38h
		db 7Ch,	40h, 40h, 60h, 0, 0
		db 0, 38h, 6Ch,	18h, 8,	7Ch
		db 38h,	0, 0, 38h, 7Ch,	18h
		db 30h,	7Ch, 38h, 0, 0,	38h
		db 7Ch,	44h, 7Ch, 38h, 0, 0
		db 0, 38h, 7Ch,	14h, 1Ch, 8
		db 0, 0, 0, 38h, 7Ch, 44h
		db 7Ch,	0B8h, 0, 0, 0, 38h
		db 7Ch,	14h, 3Ch, 48h, 0, 0
		db 0, 48h, 5Ch,	54h, 74h, 20h
		db 0, 0, 0, 0, 4, 7Ch
		db 7Ch,	4, 0, 0, 0, 38h
		db 7Ch,	40h, 7Ch, 38h, 0, 0
		db 0, 1Ch, 3Ch,	40h, 3Ch, 1Ch
		db 0, 0, 0, 38h, 7Ch, 60h
		db 30h,	6Ch, 38h, 0, 0,	44h
		db 6Ch,	38h, 38h, 6Ch, 44h
		db 0, 0, 44h, 6Ch, 38h,	18h
		db 0Ch,	0, 0, 40h, 64h,	74h
		db 5Ch,	4Ch, 4,	0, 0, 0
		db 38h,	7Ch, 60h, 70h, 6Ch
		db 38h,	0, 0, 28h, 44h,	54h
		db 7Ch,	38h, 0,	0, 0, 38h
		db 7Ch,	60h, 70h, 6Ch, 0B8h
		db 0, 0, 8, 1Ch, 10h, 7Ch
		db 38h,	0, 80h,	80h, 80h, 80h
		db 80h,	80h, 80h, 80h, 0, 38h
		db 7Ch,	10h, 38h, 44h, 7Ch
		db 38h,	0, 0, 38h, 7Ch,	14h
		db 7Ch,	38h, 0,	0, 0, 38h
		db 7Ch,	54h, 74h, 20h, 0, 0
		db 0, 38h, 7Ch,	40h, 7Ch, 0B8h
		db 0, 0, 0, 0C0h, 78h, 7Ch
		db 44h,	7Ch, 0C0h, 0, 0, 38h
		db 7Ch,	54h, 54h, 44h, 0, 0
		db 0, 18h, 24h,	7Ch, 24h, 18h
		db 0, 0, 0, 38h, 7Ch, 4
		db 4, 4, 0, 0, 0, 44h
		db 6Ch,	38h, 38h, 6Ch, 44h
		db 0, 0, 38h, 7Ch, 30h,	18h
		db 7Ch,	38h, 0,	38h, 7Ch, 32h
		db 0Ah,	7Ch, 38h, 0, 0,	0
		db 38h,	7Ch, 10h, 28h, 44h
		db 0, 0, 40h, 78h, 3Ch,	4
		db 7Ch,	7Ch, 0,	0, 0, 38h
		db 74h,	8, 4, 7Ch, 38h,	0
		db 0, 38h, 7Ch,	10h, 7Ch, 38h
		db 0, 0, 0, 38h, 7Ch, 44h
		db 7Ch,	38h, 0,	0, 0, 78h
		db 7Ch,	4, 7Ch,	78h, 0,	0
		db 0, 68h, 7Ch,	14h, 7Ch, 78h
		db 0, 0, 0, 7Ch, 7Ch, 14h
		db 1Ch,	8, 0, 0, 0, 38h
		db 7Ch,	44h, 6Ch, 28h, 0, 0
		db 0, 0, 4, 7Ch, 7Ch, 4
		db 0, 0, 0, 2Ch, 4Ch, 50h
		db 7Ch,	3Ch, 0,	0, 0, 6Ch
		db 7Ch,	10h, 7Ch, 10h, 6Ch
		db 0, 0, 38h, 7Ch, 54h,	7Ch
		db 28h,	0, 0, 0, 38h, 7Ch
		db 50h,	70h, 20h, 0, 0,	0
		db 38h,	7Ch, 50h, 20h, 7Ch
		db 38h,	0, 0, 28h, 44h,	54h
		db 7Ch,	28h, 0,	0, 0, 38h
		db 7Ch,	60h, 70h, 6Ch, 38h
		db 0, 0, 28h, 44h, 54h,	7Ch
		db 38h,	0, 0, 0, 38h, 7Ch
		db 60h,	70h, 6Ch, 0B8h,	0
		db 0, 8, 1Ch, 10h, 7Ch,	38h
		db 0, 0, 38h, 44h, 0BAh, 0AAh
		db 0AAh, 44h, 38h



  db '%'
              ;  ===0123456789
TEXT1:           db'  stend   '
TEXT2:           db' prowerki '
TEXT3:           db'  vgutow  '
TEXT4:           db'(C)2003-04'
TEXT5:           db'(C)wegas  '
TEXT6:           db'(C)UNICUM '
TEXT7:           db'(C)ORION  '
TEXT8:           db'START     '
TEXT9:           db'STOP      '
TEXT10:          db'TEST      '
TEXT11:          db'obryw     '
TEXT12:          db'zamykanie '
TEXT13:          db'priwet !  '
TEXT14:          db'vgut      '
TEXT15:          db'prowod    '
TEXT16:          db'razxem    '
TEXT17:          db'kontakt   '
TEXT18:          db' prowerka '
TEXT19:          db'pitaniq   '
TEXT20:          db'BILLACCEPT'
TEXT21:          db'   tip    '
TEXT22:          db'JCM WBA   '
TEXT23:          db'ait 2     '
TEXT24:          db'ait 2.2   '
TEXT25:          db'o]ibka !  '
TEXT26:          db'podkl^&en '
TEXT27:          db'  modulx  '
TEXT28:          db'prowerte  '
TEXT29:          db'podk&^enie'
TEXT30:          db'  modulq  '
TEXT31:          db'net swqzi '
TEXT32:          db's 24C256  '
TEXT33:          db'init..HIGH'
TEXT34:          db'init...LOW'
TEXT35:          db'.OK       '
TEXT36:          db'swqzx..OK '
TEXT37:          db'zwuk      '
TEXT38:          db'knopka    '
TEXT39:          db'na%mite   '
TEXT40:          db'knopku    '
TEXT41:          db'sbros     '
TEXT42:          db'interfejs '
TEXT43:          db'ne najden ' 
TEXT44:          db'podk&^ite '
TEXT45:          db'ispytuemyj'
TEXT46:          db' zapisan! '
TEXT47:          db' navmite  '  ;key sw
TEXT48:          db' KEY_SW 1 '
TEXT49:          db'dlq zapisi'
TEXT50:          db' etalona  '
TEXT67:          db'o testere '
TEXT69:          db'spasibo   '
TEXT70:          db'ceh 1.1   '
text78:		 db'          '
text80:		 db'zapisx pzu'
text90:		 db'          '
text99:		 db'navm.sbros'



;-------------------------------------------------------------------------

jgut0:          db'vguta net!'  ; tabl nazvanuj jgutov
jgut1:          db'vgut 1    '
jgut2:          db'vgut 2    '
jgut3:          db'vgut 3    '
jgut4:          db'vgut 4    '
jgut5:          db'vgut 5    '
jgut6:          db'vgut 6    '
jgut7:          db'vgut 7    '
jgut8:          db'vgut 8    '
jgut9:          db'vgut 9    '
jgut10:          db'vgut 10   '
jgut11:          db'vgut 11   '
jgut12:          db'vgut 12   '
jgut13:          db'vgut 13   '
jgut14:          db'vgut 14   '		; xxxx
jgut15:          db'vgut 15   '         ; xxxx0000 



		END
