program lvread;

{$I-}

{ 砥   Turbo Vision -   ... }
uses objects, drivers, views, menus, dialogs, stddlg, msgbox, app, strings;

const

 BUFSIZE = $1000;

type

 LvStr = array [0..8] of char;

const

 TitleStr        = '   LvRead 0.2 (c) AVISoft 1999'#13+
                   '      http://lvovpc.chat.ru'#13+
                   '    mailto: antonign@chat.ru';
 LvStrStd: LvStr = ('L','V','O','V','/','2','.','0','/');
 cmRead          = 100;
 cmHelp          = 102;
 cmSelect1       = 103;
 cmSelect2       = 104;

type

 pBufArray = ^BufArray;
 BufArray = array [0..$7FFF] of byte;

var

 ProgressRecord: record
  pWritedStr: ^string;
  pReadedStr: ^string;
  Samples:    longint;
  Position:   longint;
  pOperStr:   ^string;
  pInfStr:    ^string;
  pKCStr:     ^string;
 end;

 ParamRecord: record
  InFile:     string;
  OutFile:    string;
  Inversed:   word;
 end;

 WritedStr:  string;
 ReadedStr:  string;
 Operation:  string;
 Informat:   string;
 KCStr:      string;

 f,g:        file;
 Buff:       pBufArray;
 BufCnt:     word;
 Speed:      word;

type

 pParamDialog = ^tParamDialog;
 tParamDialog = object(tDialog)
  L1,L2: pInputLine;
  constructor Init;
  procedure HandleEvent(var Event: tEvent); virtual;
 end;

 pProgressDialog = ^tProgressDialog;
 tProgressDialog = object(tDialog)
  L1,L2,L3,L4,L5,L6,L7: pParamText;
  constructor Init;
  procedure ReDraw;
 end;

 tMyApp = object(tApplication)
  PD: pProgressDialog;
  procedure Error(n: byte);
  procedure ReadWav;
  function  CheckBreak: boolean;
  procedure Bload;
  procedure Cload;
  procedure InitMenuBar; virtual;
  procedure InitStatusLine; virtual;
  procedure HandleEvent(var Event: tEvent); virtual;
 end;

var
 MyApp:  tMyApp;

 constructor tParamDialog.Init;
 var
  R: tRect;
  P: pInputLine;
 begin
  R.Assign(0,0,41,15);
  inherited Init(R,'砫 ');
  Options:=Options or ofCentered;
  R.Assign(2,3,30,4);
  P:=New(pInputLine,Init(R,255));
  L1:=P;
  Insert(P);
  R.Assign(2,2,30,3);
  Insert(New(pLabel,Init(R,'室 䠩 (WAV)',P)));
  R.Assign(30,3,39,5);
  Insert(New(pButton,Init(R,'롮',cmSelect1,bfNormal)));
  R.Assign(2,6,30,7);
  P:=New(pInputLine,Init(R,255));
  L2:=P;
  Insert(P);
  R.Assign(2,5,30,6);
  Insert(New(pLabel,Init(R,'-१ (LVT)',P)));
  R.Assign(30,6,39,8);
  Insert(New(pButton,Init(R,'롮',cmSelect2,bfNormal)));
  R.Assign(2,9,30,10);
  Insert(New(pCheckBoxes,Init(R,NewSItem(' ᨣ',NIL))));
  R.Assign(7,12,19,14);
  Insert(New(pButton,Init(R,'',cmOk,bfDefault)));
  R.Assign(20,12,32,14);
  Insert(New(pButton,Init(R,'',cmCancel,bfNormal)));
  SelectNext(false);
 end;

 procedure tParamDialog.HandleEvent(var Event: tEvent);
 var
  s: string;
 begin
  if Event.What=EvCommand then
   case Event.Command of
    cmSelect1:
     begin
      s:='*.WAV';
      if Application^.ExecuteDialog(New(pFileDialog,
         Init('*.DBF',' 䠩','',fdOpenButton,0)),
         @s)<>cmCancel then L1^.SetData(s);
     end;
    cmSelect2:
     begin
      s:='*.LVT';
      if Application^.ExecuteDialog(New(pFileDialog,
         Init('*.RFM','࠭ 䠩','',fdOpenButton,0)),
         @s)<>cmCancel then L2^.SetData(s);
     end;
   end;
  inherited HandleEvent(Event);
 end;

 constructor tProgressDialog.Init;
 var
  R: tRect;
 begin
  R.Assign(0,0,40,15);
  inherited Init(R,'ண');
  Options:=Options or ofCentered;
  Flags:=wfMove;
  Palette:=0;
  R.Assign(2,2,39,3);
  L1:=New(pParamText,Init(R,'뢠:  %s',1));
  Insert(L1);
  R.Assign(2,3,39,4);
  L2:=New(pParamText,Init(R,'⠥:      %s',1));
  Insert(L2);
  R.Assign(2,5,39,6);
  L3:=New(pParamText,Init(R,'ᥣ : %d',1));
  Insert(L3);
  R.Assign(2,6,39,7);
  L4:=New(pParamText,Init(R,'騩 : %d',1));
  Insert(L4);
  R.Assign(2,8,39,9);
  L5:=New(pParamText,Init(R,':      %s',1));
  Insert(L5);
  R.Assign(2,9,39,10);
  L6:=New(pParamText,Init(R,'ଠ:    %s',1));
  Insert(L6);
  R.Assign(2,10,39,11);
  L7:=New(pParamText,Init(R,'KC:            %s',1));
  Insert(L7);
  L1^.SetData(ProgressRecord.pWritedStr);
  L2^.SetData(ProgressRecord.pReadedStr);
  L3^.SetData(ProgressRecord.Samples);
  L4^.SetData(ProgressRecord.Position);
  L5^.SetData(ProgressRecord.pOperStr);
  L6^.SetData(ProgressRecord.pInfStr);
  L7^.SetData(ProgressRecord.pKCStr);
  R.Assign(14,12,25,14);
  Insert(New(pButton,Init(R,'!',cmCancel,bfDefault)));
  SelectNext(false);
 end;

 procedure tProgressDialog.ReDraw;
 begin
  L1^.SetData(ProgressRecord.pWritedStr);
  L2^.SetData(ProgressRecord.pReadedStr);
  L3^.SetData(ProgressRecord.Samples);
  L4^.SetData(ProgressRecord.Position);
  L5^.SetData(ProgressRecord.pOperStr);
  L6^.SetData(ProgressRecord.pInfStr);
  L7^.SetData(ProgressRecord.pKCStr);
 end;

 procedure tMyApp.Error(n: byte);
 var
  s: string;
 begin
  case n of
   1: s:='室 䠩  ';
   2: s:='訡 ᮧ 䠩';
   3: s:='訡 ⥭ 䠩';
   4: s:='訡  䠩';
   5: s:='⨣  室 䠩,    த'
  end;
  MessageBox(s,NIL,mfError+mfOKButton);
 end;

 { 뤠 ⥪騩   ६頥 㪠⥫  ᫥騩 }
 function GetNextSample: byte;
 begin
  GetNextSample:=Buff^[BufCnt];
  Inc(ProgressRecord.Position);
  if ProgressRecord.Position>=ProgressRecord.Samples then Exit;
  Inc(BufCnt);
  if BufCnt>=BUFSIZE then
   begin
    BlockRead(f,Buff^,BUFSIZE);
    BufCnt:=0;
   end;
 end;

 { "" ᬥ ୮;  室 ॡ㥬 ୮;
    室 ⥪  }
 function Polarity(Pol: boolean): longint;
 var
  RealPol: boolean;
 begin
  RealPol:=Pol xor (ParamRecord.Inversed<>0);
  if (Buff^[BufCnt]>$80)<>RealPol then
  repeat
   if ProgressRecord.Position>=ProgressRecord.Samples then Exit;
  until RealPol=(GetNextSample>$80);
  Polarity:=ProgressRecord.Position;
 end;

 { ஭  ; ᫥ Speed }
 procedure LoadPilot;
 var
  Cnt,Avg,Now,Posit: longint;
 begin
  Cnt:=0;
  Avg:=0;
  repeat
   if MyApp.CheckBreak or (ProgressRecord.Position>=
   ProgressRecord.Samples) then Exit;
   Posit:=Polarity(true);
   Polarity(false);
   Now:=Polarity(true)-Posit;
   if Cnt=0 then begin Avg:=Now; Inc(Cnt); end
    else if Abs(Avg-Now)>Avg/4 then Cnt:=0
         else begin Inc(Cnt); Avg:=(Avg+Now) shr 1; end;
  until Cnt>=200;
  Speed:=Round(Avg*1.5);
 end;

 { 뢠   }
 function LoadBit: boolean;
 var
  Posit:  longint;
  b:      boolean;
 begin
  Posit:=Polarity(true);
  Polarity(false);
  b:=(Polarity(true)-Posit)<Speed;
  if b then
   begin
    Polarity(false);
    Polarity(true);
   end;
  LoadBit:=b;
 end;

 { 뢠   }
 function LoadByte: byte;
 var
  b,i:    byte;
  Posit:  longint;
 begin
  Polarity(true);
  repeat
   if ProgressRecord.Position>=ProgressRecord.Samples then Exit;
   Posit:=Polarity(true);
   Polarity(false);
  until (Polarity(true)-Posit)>Speed;
  b:=0;
  for i:=0 to 7 do
   if LoadBit then b:=(b shr 1) or $80
   else b:=b shr 1;
  LoadBit;
  LoadBit;
  LoadByte:=b;
 end;

 { 뢠  ᫮ }
 function LoadWord: word;
 var
  h,l: word;
 begin
  l:=LoadByte; h:=LoadByte;
  LoadWord:=(h shl 8) or l;
 end;

 function tMyApp.CheckBreak: boolean;
 var
  E: tEvent;
 begin
  PD^.ReDraw;
  GetEvent(E);
  HandleEvent(E);
  CheckBreak:=E.Command=cmCancel;
 end;

 function Hex(b: byte): string;
 var
  b1,b2: byte;
 begin
  b1:=b and $0F;
  if b1>9 then b1:=b1+7;
  b2:=(b shr 4) and $0F;
  if b2>9 then b2:=b2+7;
  Hex:=Chr(b2+$30)+Chr(b1+$30);
 end;

 function HexWord(w: word): string;
 begin
  HexWord:=Hex(Hi(w))+Hex(Lo(w));
 end;

 function CheckSum: string;
 var
  a,b:        byte;
  i,bc,xthl:  word;
  s:          string;
 begin
  s:='';
  Seek(g,$16);
  bc:=0; xthl:=0; a:=0;
  while not EOF(g) do
   begin
    BlockRead(g,b,1);
    asm
     mov    bx,bc
     mov    bl,b
     mov    bc,bx
     mov    ax,xthl
     add    ax,bx
     mov    xthl,ax
     jnc    @001
     inc    a
     @001:
    end;
   end;
  if a<>0 then s:=s+Hex(a);
  s:=s+HexWord(xthl);
  CheckSum:=s;
 end;

 procedure tMyApp.Bload;
 var
  BegAddr,EndAddr,StaAddr,i:  word;
  b:                          byte;
 begin
  { 㧪 ᮢ }
  BegAddr:=LoadWord;
  EndAddr:=LoadWord;
  StaAddr:=LoadWord;
  if CheckBreak then begin Close(f); Close(g); Exit; end;
  { ࠭ ᮢ }
  BlockWrite(g,BegAddr,2);
  BlockWrite(g,EndAddr,2);
  BlockWrite(g,StaAddr,2);
  if IOResult<>0 then begin Error(3); Close(f); Close(g); Exit; end;
  { 㧪 ⥫ 䠩 }
  Informat:='BLOAD: '+HexWord(BegAddr)+','+HexWord(EndAddr)+','+HexWord(StaAddr);
  for i:=BegAddr to EndAddr do
   begin
    b:=LoadByte;
    if CheckBreak then Break;
    if ProgressRecord.Position>=ProgressRecord.Samples then
    begin Error(5); Break; end;
    BlockWrite(g,b,1);
   end;
 end;

 procedure tMyApp.Cload;
 var
  b,c: byte;
 begin
  c:=0;
  Informat:='CLOAD';
  repeat
   b:=LoadByte;
   if CheckBreak then Break;
   if ProgressRecord.Position>=ProgressRecord.Samples then
   begin Error(5); Break; end;
   BlockWrite(g,b,1);
   if b=0 then Inc(c) else c:=0;
  until c>=3;
 end;

 procedure tMyApp.ReadWav;
 var
  InFile:                   string;
  OutFile:                  string;
  i:                        longint;
  E:                        tEvent;
  Header:                   array [0..16] of byte;
  BegAddr,EndAddr,StaAddr:  word;
  b:                        byte;
 begin
  ParamRecord.InFile:='SOUND001.WAV';
  ParamRecord.OutFile:='OUT.LVT';
  ParamRecord.Inversed:=0;
  if ExecuteDialog(New(pParamDialog,Init),@ParamRecord)=cmCancel then Exit;
  Assign(f,ParamRecord.InFile);
  Reset(f,1);
  if IOResult<>0 then begin Error(1); Exit; end;
  Assign(g,ParamRecord.OutFile);
  Rewrite(g,1);
  if IOResult<>0 then begin Error(2); Close(f); Exit; end;
  BlockWrite(g,LvStrStd,SizeOf(LvStrStd));
  if IOResult<>0 then begin Error(3); Close(f); Close(g); Exit; end;
  WritedStr:=ParamRecord.OutFile;
  ReadedStr:='[⥭]';
  Operation:='஭...';
  Informat:='[㯭]';
  KCStr:='[㯭]';
  ProgressRecord.Samples:=FileSize(f)-$2C;
  ProgressRecord.Position:=0;
  BufCnt:=0;
  Seek(f,$2C);
  BlockRead(f,Buff^,BUFSIZE);
  if IOResult<>0 then begin Error(3); Close(f); Close(g); Exit; end;
  PD:=New(pProgressDialog,Init);
  InsertWindow(PD);
  {  ࢮ  }
  LoadPilot;
  Operation:=' ...';
  if CheckBreak then begin Close(f); Close(g); Exit; end;
  { 㧪  }
  for i:=0 to 15 do Header[i]:=LoadByte;
  Header[16]:=0;
  ReadedStr:=StrPas(@Header[10]);
  { ࠭  }
  BlockWrite(g,Header[9],7);
  if IOResult<>0 then begin Error(3); Close(f); Close(g); Exit; end;
  {  ண  }
  Operation:='஭...';
  LoadPilot;
  Operation:=' ⥫ 䠩...';
  if CheckBreak then begin Close(f); Close(g); Exit; end;
  { 㧪 ⥫ 䠩 }
  Operation:='㧪 䠩...';
  case Header[9] of
   $D3: Cload;
  else Bload;
  end;
  { ᨭ... }
  Operation:='㬬஢...';
  CheckBreak;
  KCStr:=CheckSum;
  Operation:='!  ...';
  Close(f);
  Close(g);
  repeat
  until CheckBreak;
  PD^.Done;
 end;

 procedure tMyApp.InitMenuBar;
 var
  R: tRect;
 begin
  GetExtent(R);
  R.B.Y:=R.A.Y+1;
  MenuBar:=New(pMenuBar,Init(R,NewMenu(
   NewItem('','',kbNoKey,cmRead,0,
   NewItem(' ணࠬ','',kbF1,cmHelp,0,
   NIL)))));
 end;

 procedure tMyApp.InitStatusLine;
 var
  R: tRect;
 begin
  GetExtent(R);
  R.A.Y:=R.B.Y-1;
  StatusLine:=New(pStatusLine,Init(R,
   NewStatusDef(0,0,
   NewStatusKey('~Alt-X~ 室',kbAltX,cmQuit,
   NewStatusKey('',kbF1,cmHelp,
   NewStatusKey('',kbF10,cmMenu,
   NIL))),
  NIL)));
 end;

 procedure tMyApp.HandleEvent(var Event: tEvent);
 begin
  inherited HandleEvent(Event);
  if Event.What=evCommand then
   case Event.Command of
    cmRead:   ReadWav;
    cmHelp:   MessageBox(TitleStr,NIL,mfInformation+mfOKButton);
   end;
  ClearEvent(Event);
 end;

begin
 ProgressRecord.pWritedStr:=@WritedStr;
 ProgressRecord.pReadedStr:=@ReadedStr;
 ProgressRecord.pOperStr:=@Operation;
 ProgressRecord.pInfStr:=@Informat;
 ProgressRecord.pKCStr:=@KCStr;
 GetMem(Buff,BUFSIZE);
 MyApp.Init;
 MyApp.Run;
 MyApp.Done;
end.
