# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-embedded/urjtag/urjtag-0.10.ebuild,v 1.2 2011/12/10 18:41:38 vapier Exp $

inherit eutils

DESCRIPTION="tool for communicating over JTAG with flash chips, CPUs, and many more (fork of openwince jtag)"
HOMEPAGE="http://urjtag.sourceforge.net/"
SRC_URI="mirror://sourceforge/urjtag/${P}.tar.bz2"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 ppc sparc x86"
IUSE="ftdi ftd2xx readline"

DEPEND="!dev-embedded/jtag
	ftd2xx? ( dev-embedded/libftd2xx )
	ftdi? ( dev-embedded/libftdi )
	readline? ( sys-libs/readline )"

src_prepare() {
	epatch "${FILESDIR}"/add_cable_list_command.patch
	epatch "${FILESDIR}"/svf_guard_against_chain_cable_being_null.patch
}

src_configure() {
#	use ftd2xx && append-flags -g -O2 -DSUPPORT_FT245R

	# add explicitely the path to libftd2xx
	use ftd2xx && LDFLAGS="${LDFLAGS} -L/opt/$(get_libdir)"
	use ftd2xx && export FTD2XXLIB="/opt/$(get_libdir)"


	default 
}

src_compile() {
	use readline || export vl_cv_lib_readline=no
	use ftd2xx && export FTD2XXLIB="/opt/$(get_libdir)"
	econf $(use_enable ftdi libftdi) \
		$(use_with ftd2xx ftd2xx="${FTD2XXLIB}") || die
	emake || die
}

src_install() {
	emake DESTDIR="${D}" install || die "failed to install"
	dodoc AUTHORS ChangeLog NEWS README THANKS
}
