;---------------------------------------------------------------------------
; Copyright (C) 2003 CYGNAL INTEGRATED PRODUCTS, INC.
; All rights reserved.
;
;
; FILE NAME: C8051F120.INC
; TARGET MCUs: C8051F120, F121, F122, F123, F124, F125, F126, F127
; DESCRIPTION: Register/bit definitions for the C8051F120 product family.
;
; REVISION 1.6
;
;---------------------------------------------------------------------------

;REGISTER DEFINITIONS
;
P0             DATA 080H    ; PORT 0 LATCH
SP             DATA 081H    ; STACK POINTER
DPL            DATA 082H    ; DATA POINTER LOW BYTE
DPH            DATA 083H    ; DATA POINTER HIGH BYTE
SFRPAGE        DATA 084H    ; SFR PAGE SELECT
SFRNEXT        DATA 085H    ; SFR STACK NEXT PAGE
SFRLAST        DATA 086H    ; SFR STACK LAST PAGE
PCON           DATA 087H    ; POWER CONTROL
FLSTAT         DATA 088H    ; FLASH STATUS
CPT0CN         DATA 088H    ; COMPARATOR 0 CONTROL
CPT1CN         DATA 088H    ; COMPARATOR 1 CONTROL
TCON           DATA 088H    ; TIMER/COUNTER CONTROL
TMOD           DATA 089H    ; TIMER/COUNTER MODE
CPT0MD         DATA 089H    ; COMPARATOR 0 CONFIGURATION
CPT1MD         DATA 089H    ; COMPARATOR 1 CONFIGURATION
PLL0CN         DATA 089H    ; PLL CONTROL
OSCICN         DATA 08AH    ; INTERNAL OSCILLATOR CONTROL
TL0            DATA 08AH    ; TIMER/COUNTER 0 LOW BYTE
OSCICL         DATA 08BH    ; INTERNAL OSCILLATOR CALIBRATION
TL1            DATA 08BH    ; TIMER/COUNTER 1 LOW BYTE
OSCXCN         DATA 08CH    ; EXTERNAL OSCILLATOR CONTROL
TH0            DATA 08CH    ; TIMER/COUNTER 0 HIGH BYTE
TH1            DATA 08DH    ; TIMER/COUNTER 1 HIGH BYTE
PLL0DIV        DATA 08DH    ; PLL DIVIDER
CKCON          DATA 08EH    ; CLOCK CONTROL
PLL0MUL        DATA 08EH    ; PLL MULTIPLIER
PSCTL          DATA 08FH    ; FLASH WRITE/ERASE CONTROL
PLL0FLT        DATA 08FH    ; PLL FILTER
P1             DATA 090H    ; PORT 1 LATCH
SSTA0          DATA 091H    ; UART 0 STATUS
MAC0BL         DATA 091H    ; MAC0 B REGISTER LOW BYTE
MAC0BH         DATA 092H    ; MAC0 B REGISTER HIGH BYTE
MAC0ACC0       DATA 093H    ; MAC0 ACCUMULATOR BYTE 0
MAC0ACC1       DATA 094H    ; MAC0 ACCUMULATOR BYTE 1
MAC0ACC2       DATA 095H    ; MAC0 ACCUMULATOR BYTE 2
SFRPGCN        DATA 096H    ; SFR PAGE CONTROL
MAC0ACC3       DATA 096H    ; MAC0 ACCUMULATOR BYTE 3
MAC0OVR        DATA 097H    ; MAC0 ACCUMULATOR OVERFLOW BYTE
CLKSEL         DATA 097H    ; SYSTEM CLOCK SELECT
SCON0          DATA 098H    ; UART 0 CONTROL
SCON1          DATA 098H    ; UART 1 CONTROL
SBUF0          DATA 099H    ; UART 0 DATA BUFFER
SBUF1          DATA 099H    ; UART 1 DATA BUFFER
SPI0CFG        DATA 09AH    ; SPI CONFIGURATION
CCH0MA         DATA 09AH    ; CACHE MISS ACCUMULATOR
SPI0DAT        DATA 09BH    ; SPI DATA
P4MDOUT        DATA 09CH    ; PORT 4 OUTPUT MODE CONFIGURATION
P5MDOUT        DATA 09DH    ; PORT 5 OUTPUT MODE CONFIGURATION
SPI0CKR        DATA 09DH    ; SPI CLOCK RATE CONTROL
P6MDOUT        DATA 09EH    ; PORT 6 OUTPUT MODE CONFIGURATION
P7MDOUT        DATA 09FH    ; PORT 7 OUTPUT MODE CONFIGURATION
P2             DATA 0A0H    ; PORT 2 LATCH
EMI0TC         DATA 0A1H    ; EMIF TIMING CONTROL
CCH0CN         DATA 0A1H    ; CACHE CONTROL
EMI0CN         DATA 0A2H    ; EMIF CONTROL
CCH0TN         DATA 0A2H    ; CACHE TUNING
EMI0CF         DATA 0A3H    ; EMIF CONFIGURATION
CCH0LC         DATA 0A3H    ; CACHE LOCK
P0MDOUT        DATA 0A4H    ; PORT 0 OUTPUT MODE CONFIGURATION
P1MDOUT        DATA 0A5H    ; PORT 1 OUTPUT MODE CONFIGURATION
P2MDOUT        DATA 0A6H    ; PORT 2 OUTPUT MODE CONFIGURATION
P3MDOUT        DATA 0A7H    ; PORT 3 OUTPUT MODE CONFIGURATION
IE             DATA 0A8H    ; INTERRUPT ENABLE
SADDR0         DATA 0A9H    ; UART 0 SLAVE ADDRESS
P1MDIN         DATA 0ADH    ; PORT 1 INPUT MODE
P3             DATA 0B0H    ; PORT 3 LATCH
PSBANK         DATA 0B1H    ; FLASH BANK SELECT
FLACL          DATA 0B7H    ; FLASH ACCESS LIMIT
FLSCL          DATA 0B7H    ; FLASH SCALE
IP             DATA 0B8H    ; INTERRUPT PRIORITY
SADEN0         DATA 0B9H    ; UART 0 SLAVE ADDRESS MASK
AMX0CF         DATA 0BAH    ; ADC0 MULTIPLEXER CONFIGURATION
AMX2CF         DATA 0BAH    ; ADC2 MULTIPLEXER CONFIGURATION
AMX0SL         DATA 0BBH    ; ADC0 MULTIPLEXER CHANNEL SELECT
AMX2SL         DATA 0BBH    ; ADC2 MULTIPLEXER CHANNEL SELECT
ADC0CF         DATA 0BCH    ; ADC0 CONFIGURATION
ADC2CF         DATA 0BCH    ; ADC2 CONFIGURATION
ADC0L          DATA 0BEH    ; ADC0 DATA WORD LOW BYTE
ADC2           DATA 0BEH    ; ADC2DATA WORD
ADC0H          DATA 0BFH    ; ADC0 DATA WORD HIGH BYTE
MAC0STA        DATA 0C0H    ; MAC0 STATUS
SMB0CN         DATA 0C0H    ; SMBUS CONTROL
MAC0AL         DATA 0C1H    ; MAC0 A REGISTER LOW BYTE
SMB0STA        DATA 0C1H    ; SMBUS STATUS
MAC0AH         DATA 0C2H    ; MAC0 A REGISTER HIGH BYTE
SMB0DAT        DATA 0C2H    ; SMBUS DATA
MAC0CF         DATA 0C3H    ; MAC0 CONFIGURATION REGISTER
SMB0ADR        DATA 0C3H    ; SMBUS SLAVE ADDRESS
ADC0GTL        DATA 0C4H    ; ADC0 GREATER-THAN LOW BYTE
ADC2GT         DATA 0C4H    ; ADC2 GREATER-THAN
ADC0GTH        DATA 0C5H    ; ADC0 GREATER-THAN HIGH BYTE
ADC0LTL        DATA 0C6H    ; ADC0 LESS-THAN LOW BYTE
ADC2LT         DATA 0C6H    ; ADC2 LESS-THAN
ADC0LTH        DATA 0C7H    ; ADC0 LESS-THAN HIGH BYTE
P4             DATA 0C8H    ; PORT 4 LATCH
TMR2CN         DATA 0C8H    ; TIMER/COUNTER 2 CONTROL
TMR3CN         DATA 0C8H    ; TIMER 3 CONTROL
TMR4CN         DATA 0C8H    ; TIMER/COUNTER 4 CONTROL
TMR2CF         DATA 0C9H    ; TIMER/COUNTER 2 CONFIGURATION
TMR3CF         DATA 0C9H    ; TIMER 3 CONFIGURATION
TMR4CF         DATA 0C9H    ; TIMER/COUNTER 4 CONFIGURATION
RCAP2L         DATA 0CAH    ; TIMER/COUNTER 2 CAPTURE/RELOAD LOW BYTE
RCAP3L         DATA 0CAH    ; TIMER 3 CAPTURE/RELOAD LOW BYTE
RCAP4L         DATA 0CAH    ; TIMER/COUNTER 4 CAPTURE/RELOAD LOW BYTE
RCAP2H         DATA 0CBH    ; TIMER/COUNTER 2 CAPTURE/RELOAD HIGH BYTE
RCAP3H         DATA 0CBH    ; TIMER 3 CAPTURE/RELOAD HIGH BYTE
RCAP4H         DATA 0CBH    ; TIMER/COUNTER 4 CAPTURE/RELOAD HIGH BYTE
TMR2L          DATA 0CCH    ; TIMER/COUNTER 2 LOW BYTE
TMR3L          DATA 0CCH    ; TIMER 3 LOW BYTE
TMR4L          DATA 0CCH    ; TIMER/COUNTER 4 LOW BYTE
TMR2H          DATA 0CDH    ; TIMER/COUNTER 2 HIGH BYTE
TMR3H          DATA 0CDH    ; TIMER 3 HIGH BYTE
TMR4H          DATA 0CDH    ; TIMER/COUNTER 4 HIGH BYTE
MAC0RNDL       DATA 0CEH    ; MAC0 ROUNDING REGISTER LOW BYTE
MAC0RNDH       DATA 0CFH    ; MAC0 ROUNDING REGISTER HIGH BYTE
SMB0CR         DATA 0CFH    ; SMBUS CLOCK RATE
PSW            DATA 0D0H    ; PROGRAM STATUS WORD
REF0CN         DATA 0D1H    ; VOLTAGE REFERENCE CONTROL
DAC0L          DATA 0D2H    ; DAC0 LOW BYTE
DAC1L          DATA 0D2H    ; DAC1 LOW BYTE
DAC0H          DATA 0D3H    ; DAC0 HIGH BYTE
DAC1H          DATA 0D3H    ; DAC1 HIGH BYTE
DAC0CN         DATA 0D4H    ; DAC0 CONTROL
DAC1CN         DATA 0D4H    ; DAC1 CONTROL
P5             DATA 0D8H    ; PORT 5 LATCH
PCA0CN         DATA 0D8H    ; PCA CONTROL
PCA0MD         DATA 0D9H    ; PCA MODE
PCA0CPM0       DATA 0DAH    ; PCA MODULE 0 MODE
PCA0CPM1       DATA 0DBH    ; PCA MODULE 1 MODE REGISTER
PCA0CPM2       DATA 0DCH    ; PCA MODULE 2 MODE
PCA0CPM3       DATA 0DDH    ; PCA MODULE 3 MODE
PCA0CPM4       DATA 0DEH    ; PCA MODULE 4 MODE
PCA0CPM5       DATA 0DFH    ; PCA MODULE 5 MODE
ACC            DATA 0E0H    ; ACCUMULATOR
XBR0           DATA 0E1H    ; PORT I/O CROSSBAR CONTROL 0
PCA0CPL5       DATA 0E1H    ; PCA MODULE 5 CAPTURE/COMPARE LOW BYTE
PCA0CPH5       DATA 0E2H    ; PCA MODULE 5 CAPTURE/COMPARE HIGH BYTE
XBR1           DATA 0E2H    ; PORT I/O CROSSBAR CONTROL 1
XBR2           DATA 0E3H    ; PORT I/O CROSSBAR CONTROL 2
EIE1           DATA 0E6H    ; EXTENDED INTERRUPT ENABLE 1
EIE2           DATA 0E7H    ; EXTENDED INTERRUPT ENABLE 2
ADC0CN         DATA 0E8H    ; ADC0 CONTROL
ADC2CN         DATA 0E8H    ; ADC2 CONTROL
P6             DATA 0E8H    ; PORT 6 LATCH
PCA0CPL2       DATA 0E9H    ; PCA MODULE 2 CAPTURE/COMPARE LOW BYTE
PCA0CPH2       DATA 0EAH    ; PCA MODULE 2 CAPTURE/COMPARE HIGH BYTE
PCA0CPL3       DATA 0EBH    ; PCA MODULE 3 CAPTURE/COMPARE LOW BYTE
PCA0CPH3       DATA 0ECH    ; PCA MODULE 3 CAPTURE/COMPARE HIGH BYTE
PCA0CPL4       DATA 0EDH    ; PCA MODULE 4 CAPTURE/COMPARE LOW BYTE
PCA0CPH4       DATA 0EEH    ; PCA MODULE 4 CAPTURE/COMPARE HIGH BYTE
RSTSRC         DATA 0EFH    ; RESET SOURCE
B              DATA 0F0H    ; B REGISTER
EIP1           DATA 0F6H    ; EXTERNAL INTERRUPT PRIORITY 1
EIP2           DATA 0F7H    ; EXTERNAL INTERRUPT PRIORITY 2
P7             DATA 0F8H    ; PORT 7 LATCH
SPI0CN         DATA 0F8H    ; SPI CONTROL
PCA0L          DATA 0F9H    ; PCA COUNTER LOW BYTE
PCA0H          DATA 0FAH    ; PCA COUNTER HIGH BYTE
PCA0CPL0       DATA 0FBH    ; PCA MODULE 0 CAPTURE/COMPARE LOW BYTE
PCA0CPH0       DATA 0FCH    ; PCA MODULE 0 CAPTURE/COMPARE HIGH BYTE
PCA0CPL1       DATA 0FDH    ; PCA MODULE 1 CAPTURE/COMPARE LOW BYTE
PCA0CPH1       DATA 0FEH    ; PCA MODULE 1 CAPTURE/COMPARE HIGH BYTE
WDTCN          DATA 0FFH    ; WATCHDOG TIMER CONTROL

;
;------------------------------------------------------------------------------
;BIT DEFINITIONS
;
; TCON 088H
TF1            BIT 08FH     ; TIMER 1 OVERFLOW FLAG
TR1            BIT 08EH     ; TIMER 1 ON/OFF CONTROL
TF0            BIT 08DH     ; TIMER 0 OVERFLOW FLAG
TR0            BIT 08CH     ; TIMER 0 ON/OFF CONTROL
IE1            BIT 08BH     ; EXT. INTERRUPT 1 EDGE FLAG
IT1            BIT 08AH     ; EXT. INTERRUPT 1 TYPE
IE0            BIT 089H     ; EXT. INTERRUPT 0 EDGE FLAG
IT0            BIT 088H     ; EXT. INTERRUPT 0 TYPE

; CPT0CN 088H
CP0EN          BIT 08FH     ; COMPARATOR 0 ENABLE
CP0OUT         BIT 08EH     ; COMPARATOR 0 OUTPUT
CP0RIF         BIT 08DH     ; COMPARATOR 0 RISING EDGE INTERRUPT
CP0FIF         BIT 08CH     ; COMPARATOR 0 FALLING EDGE INTERRUPT
CP0HYP1        BIT 08BH     ; COMPARATOR 0 POSITIVE HYSTERISIS 1
CP0HYP0        BIT 08AH     ; COMPARATOR 0 POSITIVE HYSTERISIS 0
CP0HYN1        BIT 089H     ; COMPARATOR 0 NEGATIVE HYSTERISIS 1
CP0HYN0        BIT 088H     ; COMPARATOR 0 NEGATIVE HYSTERISIS 0

; CPT1CN 088H
CP1EN          BIT 08FH     ; COMPARATOR 1 ENABLE
CP1OUT         BIT 08EH     ; COMPARATOR 1 OUTPUT
CP1RIF         BIT 08DH     ; COMPARATOR 1 RISING EDGE INTERRUPT
CP1FIF         BIT 08CH     ; COMPARATOR 1 FALLING EDGE INTERRUPT
CP1HYP1        BIT 08BH     ; COMPARATOR 1 POSITIVE HYSTERISIS 1
CP1HYP0        BIT 08AH     ; COMPARATOR 1 POSITIVE HYSTERISIS 0
CP1HYN1        BIT 089H     ; COMPARATOR 1 NEGATIVE HYSTERISIS 1
CP1HYN0        BIT 088H     ; COMPARATOR 1 NEGATIVE HYSTERISIS 0

; FLSTAT 088H
FLHBUSY        BIT 088H     ; FLASH BUSY

; SCON0 098H
SM00           BIT 09FH     ; UART 0 MODE 0
SM10           BIT 09EH     ; UART 0 MODE 1
SM20           BIT 09DH     ; UART 0 MULTIPROCESSOR EN
REN0           BIT 09CH     ; UART 0 RX ENABLE
TB80           BIT 09BH     ; UART 0 TX BIT 8
RB80           BIT 09AH     ; UART 0 RX BIT 8
TI0            BIT 099H     ; UART 0 TX INTERRUPT FLAG
RI0            BIT 098H     ; UART 0 RX INTERRUPT FLAG

; SCON1 098H
S1MODE         BIT 09FH     ; UART 1 MODE
MCE1           BIT 09DH     ; UART 1 MCE
REN1           BIT 09CH     ; UART 1 RX ENABLE
TB81           BIT 09BH     ; UART 1 TX BIT 8
RB81           BIT 09AH     ; UART 1 RX BIT 8
TI1            BIT 099H     ; UART 1 TX INTERRUPT FLAG
RI1            BIT 098H     ; UART 1 RX INTERRUPT FLAG

; IE 0A8H
EA             BIT 0AFH     ; GLOBAL INTERRUPT ENABLE
ET2            BIT 0ADH     ; TIMER 2 INTERRUPT ENABLE
ES0            BIT 0ACH     ; UART0 INTERRUPT ENABLE
ET1            BIT 0ABH     ; TIMER 1 INTERRUPT ENABLE
EX1            BIT 0AAH     ; EXTERNAL INTERRUPT 1 ENABLE
ET0            BIT 0A9H     ; TIMER 0 INTERRUPT ENABLE
EX0            BIT 0A8H     ; EXTERNAL INTERRUPT 0 ENABLE

; IP 0B8H
PT2            BIT 0BDH     ; TIMER 2 PRIORITY
PS             BIT 0BCH     ; SERIAL PORT PRIORITY
PT1            BIT 0BBH     ; TIMER 1 PRIORITY
PX1            BIT 0BAH     ; EXTERNAL INTERRUPT 1 PRIORITY
PT0            BIT 0B9H     ; TIMER 0 PRIORITY
PX0            BIT 0B8H     ; EXTERNAL INTERRUPT 0 PRIORITY

; SMB0CN 0C0H
BUSY           BIT 0C7H     ; SMBUS 0 BUSY
ENSMB          BIT 0C6H     ; SMBUS 0 ENABLE
STA            BIT 0C5H     ; SMBUS 0 START FLAG
STO            BIT 0C4H     ; SMBUS 0 STOP FLAG
SI             BIT 0C3H     ; SMBUS 0 INTERRUPT PENDING FLAG
AA             BIT 0C2H     ; SMBUS 0 ASSERT/ACKNOWLEDGE FLAG
SMBFTE         BIT 0C1H     ; SMBUS 0 FREE TIMER ENABLE
SMBTOE         BIT 0C0H     ; SMBUS 0 TIMEOUT ENABLE

; MAC0STA 0C0H
MAC0HO         BIT 0C3H     ; MAC0 HARD OVERFLOW
MAC0Z          BIT 0C2H     ; MAC0 ZERO
MAC0SO         BIT 0C1H     ; MAC0 SOFT OVERFLOW
MAC0N          BIT 0C0H     ; MAC0 NEGATIVE

; TMR2CN 0C8H
TF2            BIT 0CFH     ; TIMER 2 OVERFLOW FLAG
EXF2           BIT 0CEH     ; TIMER 2 EXTERNAL FLAG
EXEN2          BIT 0CBH     ; TIMER 2 EXTERNAL ENABLE FLAG
TR2            BIT 0CAH     ; TIMER 2 ON/OFF CONTROL
CT2            BIT 0C9H     ; TIMER 2 COUNTER SELECT
CPRL2          BIT 0C8H     ; TIMER 2 CAPTURE SELECT

; TMR3CN 0C8H
TF3            BIT 0CFH     ; TIMER 3 OVERFLOW FLAG
EXF3           BIT 0CEH     ; TIMER 3 EXTERNAL FLAG
EXEN3          BIT 0CBH     ; TIMER 3 EXTERNAL ENABLE FLAG
TR3            BIT 0CAH     ; TIMER 3 ON/OFF CONTROL
CT3            BIT 0C9H     ; TIMER 3 COUNTER SELECT
CPRL3          BIT 0C8H     ; TIMER 3 CAPTURE SELECT

; TMR4CN 0C8H
TF4            BIT 0CFH     ; TIMER 4 OVERFLOW FLAG
EXF4           BIT 0CEH     ; TIMER 4 EXTERNAL FLAG
EXEN4          BIT 0CBH     ; TIMER 4 EXTERNAL ENABLE FLAG
TR4            BIT 0CAH     ; TIMER 4 ON/OFF CONTROL
CT4            BIT 0C9H     ; TIMER 4 COUNTER SELECT
CPRL4          BIT 0C8H     ; TIMER 4 CAPTURE SELECT

; PSW 0D0H
CY             BIT 0D7H     ; CARRY FLAG
AC             BIT 0D6H     ; AUXILIARY CARRY FLAG
F0             BIT 0D5H     ; USER FLAG 0
RS1            BIT 0D4H     ; REGISTER BANK SELECT 1
RS0            BIT 0D3H     ; REGISTER BANK SELECT 0
OV             BIT 0D2H     ; OVERFLOW FLAG
F1             BIT 0D1H     ; USER FLAG 1
P              BIT 0D0H     ; ACCUMULATOR PARITY FLAG

; PCA0CN 0D8H
CF             BIT 0DFH     ; PCA 0 COUNTER OVERFLOW FLAG
CR             BIT 0DEH     ; PCA 0 COUNTER RUN CONTROL BIT
CCF5           BIT 0DDH     ; PCA 0 MODULE 5 INTERRUPT FLAG
CCF4           BIT 0DCH     ; PCA 0 MODULE 4 INTERRUPT FLAG
CCF3           BIT 0DBH     ; PCA 0 MODULE 3 INTERRUPT FLAG
CCF2           BIT 0DAH     ; PCA 0 MODULE 2 INTERRUPT FLAG
CCF1           BIT 0D9H     ; PCA 0 MODULE 1 INTERRUPT FLAG
CCF0           BIT 0D8H     ; PCA 0 MODULE 0 INTERRUPT FLAG

; ADC0CN 0E8H
AD0EN          BIT 0EFH     ; ADC 0 ENABLE
AD0TM          BIT 0EEH     ; ADC 0 TRACK MODE
AD0INT         BIT 0EDH     ; ADC 0 EOC INTERRUPT FLAG
AD0BUSY        BIT 0ECH     ; ADC 0 BUSY FLAG
AD0CM1         BIT 0EBH     ; ADC 0 CONVERT START MODE BIT 1
AD0CM0         BIT 0EAH     ; ADC 0 CONVERT START MODE BIT 0
AD0WINT        BIT 0E9H     ; ADC 0 WINDOW INTERRUPT FLAG
AD0LJST        BIT 0E8H     ; ADC 0 LEFT JUSTIFY DATA BIT

; ADC2CN 0E8H
AD2EN          BIT 0EFH     ; ADC 2 ENABLE
AD2TM          BIT 0EEH     ; ADC 2 TRACK MODE
AD2INT         BIT 0EDH     ; ADC 2 EOC INTERRUPT FLAG
AD2BUSY        BIT 0ECH     ; ADC 2 BUSY FLAG
AD2CM2         BIT 0EBH     ; ADC 2 CONVERT START MODE BIT 2
AD2CM1         BIT 0EAH     ; ADC 2 CONVERT START MODE BIT 1
AD2CM0         BIT 0E9H     ; ADC 2 CONVERT START MODE BIT 0
AD2WINT        BIT 0E8H     ; ADC 2 WINDOW INTERRUPT FLAG

; SPI0CN 0F8H
SPIF           BIT 0FFH     ; SPI 0 INTERRUPT FLAG
WCOL           BIT 0FEH     ; SPI 0 WRITE COLLISION FLAG
MODF           BIT 0FDH     ; SPI 0 MODE FAULT FLAG
RXOVRN         BIT 0FCH     ; SPI 0 RX OVERRUN FLAG
NSSMD1         BIT 0FBH     ; SPI 0 SLAVE SELECT MODE 1
NSSMD0         BIT 0FAH     ; SPI 0 SLAVE SELECT MODE 0
TXBMT          BIT 0F9H     ; SPI 0 TX BUFFER EMPTY FLAG
SPIEN          BIT 0F8H     ; SPI 0 SPI ENABLE

;
;------------------------------------------------------------------------------
; SFR PAGE DEFINITIONS
;
CONFIG_PAGE                 EQU 0FH   ; SYSTEM AND PORT CONFIGURATION PAGE
LEGACY_PAGE                 EQU 00H   ; LEGACY SFR PAGE
TIMER01_PAGE                EQU 00H   ; TIMER 0 AND TIMER 1
CPT0_PAGE                   EQU 01H   ; COMPARATOR 0
CPT1_PAGE                   EQU 02H   ; COMPARATOR 1
UART0_PAGE                  EQU 00H   ; UART 0
UART1_PAGE                  EQU 01H   ; UART 1
SPI0_PAGE                   EQU 00H   ; SPI 0
EMI0_PAGE                   EQU 00H   ; EXTERNAL MEMORY INTERFACE
ADC0_PAGE                   EQU 00H   ; ADC 0
ADC2_PAGE                   EQU 02H   ; ADC 2
SMB0_PAGE                   EQU 00H   ; SMBUS 0
TMR2_PAGE                   EQU 00H   ; TIMER 2
TMR3_PAGE                   EQU 01H   ; TIMER 3
TMR4_PAGE                   EQU 02H   ; TIMER 4
DAC0_PAGE                   EQU 00H   ; DAC 0
DAC1_PAGE                   EQU 01H   ; DAC 1
PCA0_PAGE                   EQU 00H   ; PCA 0
PLL0_PAGE                   EQU 0FH   ; PLL 0
MAC0_PAGE                   EQU 03H   ; MAC 0