/**************************************************************************
		p⢮ FY: (3"/5" )
		   p PDP-11

	- প   ன⢠ FY0: .. FY7:

**************************************************************************/
#include	"pdp11dev.h"
#include	<string.h>
#include	<stdio.h>

extern unsigned		_stklen 	= 128;
extern unsigned		_heaplen	= 1024;

char		*FY0Name     	= "FY:";	//
char		*FYxName     	= "FY0:";	//  p⢠  BOOT

/**************************************************************************
		p  設 PDP-11
**************************************************************************/

#define		FY_csr		0177100		// pp   ﭨ
#define		FY_cntb		0177102		// 稪 
#define		FY_block	0177104		//   ᪥
#define		FY_DMA		0177106		// p  設  

//	  pp ﭨ   FY_csr
//	RW
#define	    FY_run	001		//  p樨
#define	    FY_reset	000		// p
#define	    FY_read	002		// ⥭
#define	    FY_write	004		// 
#define	    FY_gsize	006		// ⥭ ࠧ
#define	    FY_format	010		// ଠ஢ (१)
#define	    FY_comm	016		// ᪠ 
#define	    FY_dev	07000		// p p⢠ (0..7)
#define	    FY_eni	0100		// pp. pp. (pp)
#define	    FY_allRW	(FY_comm|FY_dev|FY_eni)
//	R-
#define	    FY_ready	0200		// ⮢ p樨
#define	    FY_error	0100000		// 訡 p樨

char	FY_READY	= 1;		// ⮢ !
char	FY_ERROR	= 0;		//  訡 !
uns	FY_SR		= 0;		// pp ﭨ
uns	FY_CNTB		= 0;		// 稪 
uns	FY_BLOCK	= 0;		// p ⥪. 
uns	FY_ADDR		= 0;		// p  設
uns	FY_DRV		= 0;		//  ன⢠
uns	Drive		= 0;		// 5"-,p 0,1 (A,B)

/**************************************************************************
		㭪 p饭  A: p BIOS
**************************************************************************/

#define	DiskWrite	3		//    INT $13
#define	DiskRead	2
#define	Retry		8		// - p p 訡

char		Buffer[01000];		// 䠩 p
char far	*MEMORY	= NULL;		// p⨢ 
uns  far	*IRQ	= 0;		// ᫮ pᮢ pp.
uns		IRQ_M	= 0;		// ᪠ p

void	DiskReset(byte Driver)	{
_DL = Driver;
_AH = 0;
asm	int	13h     // Call Disk_I/O Reset
}	// DiskReset

int	BiosDisk(int Comm, int Block, char far *Buffer)	{
int register	AH;
int	Ret  = Retry;			// ७  訡
int	cyl;				// 樫
int	sect;				// ᥪ
int	head;				// 

if ((FY_DRV & 004) == 0)
	{				//  MY:
	cyl  = Block / 20;
	sect = Block % 20;
	head = sect / 10;
	sect = sect % 10;
	}
else	{				//  DZ:
	head = 0;			//  
	cyl  = Block / 10;
	sect = (Block % 10)*2;
	if (sect >= 10)	sect -= 9;
	sect = (sect+(cyl*2)) % 10;
	cyl  += 1;			// 樫 1 ...
	}

sect += 1;				// ᥪ  1..10

do {
_DL = Drive;		// p p⢠
_DH = head;
_CH = cyl;
_CL = sect;
_AH = Comm;		//    INT 13H
_AL = 1;		// ⮫쪮  ᥪ()
asm	{
	les	bx,Buffer
	int	13h
	pushf
	pop	AX
}			// Call Disk_I/O BIOS-function
AH = _AX;
if ((AH & 0x01) == 0)	return(0);	// ⮢ !!!
DiskReset(Drive);
}	while (--Ret);
return(1);			// 訡 !
}	// BiosDisk

void	cprintf(char *str)	{
char	C;
while (C = *str++)	{
	_AH = 0x0E;
	_AL = C;
	asm	int	10h
	}
}	/* cprintf */

int	CmpName	(char far *Name)	{
if (!(_fstricmp(Name,MK_FP(_DS,FY0Name))))	{
	FY_DRV = 0;
	return 0;
	}
else	{
	FYxName[2] = Name[2];
	FY_DRV = Name[2] - '0';
	if ((!(_fstricmp(Name,MK_FP(_DS,FYxName)))) && (FY_DRV <= 7))
		return 0;
	}
return(1);
}	// CmpName

/***********************************************************************
 *                p⪠ pp뢠  p饭  FY:
 */

void interrupt	(* SysInt60)(void);	// ᫥. pp뢠

void	UnLoad(void)			// p   !!!
{
cprintf("FY.EXE aborted.\r\n");
asm	cli
setvect(PDPvec,SysInt60);
freemem(*(unsigned*)MK_FP(_psp,0x2c));
freemem(_psp);
asm	sti
}

void interrupt	FY_sys
	(uns BP,uns DI,uns SI,uns DS,
	 uns ES,uns DX,uns CX,uns BX,uns AX)	{

switch(AX >> 8)	{
	case	READW:			// ⥭ ᫮
	case	READB:			// ⥭ 
		switch(BX)	{
			case FY_csr:
				DX = FY_SR;
				if (FY_READY)	DX |= FY_ready;
				if (FY_ERROR)	DX |= FY_error;
				AX = 0;	return;
			case FY_cntb:
				DX = FY_CNTB;
				AX = 0;	return;
			case FY_block:
				DX = FY_BLOCK;
				AX = 0;	return;
			case FY_DMA:
				DX = FY_ADDR;
				AX = 0;	return;
		}
		break;
	case	WRITEB:			//  
	case	WRITEW:			//  ᫮
		switch(BX)	{
			case FY_csr:
				FY_SR = (DX & FY_allRW);
				FY_DRV = (FY_SR >> 9) & 007;
				Drive = (FY_DRV & 1);
//				poke(0xB800,6,0x4C00+'0'+Drive);
				// ⭮-ᨬ 
				if (DX & FY_run)
					switch (DX & FY_comm)	{
case FY_reset:	DiskReset(Drive);
		FY_ERROR = 0;
		break;
case FY_gsize:	FY_BLOCK = 80 * 10;
		if ((FY_DRV & 004) == 0) FY_BLOCK *= 2;
		break;
case FY_read:
//		poke(0xB800,4,0x4C00+'R');
				// ⭮-ᨬ 
		while (FY_CNTB >= 01000)	{
			if ((FY_ERROR =	BiosDisk(DiskRead,FY_BLOCK,
					&MEMORY[FY_ADDR]))!=0)
				{ AX = 0; return;	}
			FY_BLOCK++;
			FY_ADDR += 01000;
			FY_CNTB -= 01000;
			}
		if (FY_CNTB)	{	//    !!!
			memset(Buffer,0,01000);	// ⨬ p
			if ((FY_ERROR =	BiosDisk(DiskRead,FY_BLOCK,
					MK_FP(_DS,Buffer)))!=0)
				{ AX = 0; return;	}
			_fmemcpy(&MEMORY[FY_ADDR],MK_FP(_DS,Buffer),FY_CNTB);
			FY_BLOCK++;
			FY_ADDR += FY_CNTB;
			FY_CNTB = 0;
			}

		break;
case FY_write:
//		poke(0xB800,4,0x4C00+'W');
				// ⭮-ᨬ 
		while (FY_CNTB >= 01000)	{
			if ((FY_ERROR =	BiosDisk(DiskWrite,FY_BLOCK,
					&MEMORY[FY_ADDR]))!=0)
				{ AX = 0; return;	}
			FY_BLOCK++;
			FY_ADDR += 01000;
			FY_CNTB -= 01000;
			}
		if (FY_CNTB)	{	//    !!!
			memset(Buffer,0,01000);	// ⨬ p
			_fmemcpy(MK_FP(_DS,Buffer),&MEMORY[FY_ADDR],FY_CNTB);
			if ((FY_ERROR =	BiosDisk(DiskWrite,FY_BLOCK,
					MK_FP(_DS,Buffer)))!=0)
				{ AX = 0; return;	}
			FY_BLOCK++;
			FY_ADDR += FY_CNTB;
			FY_CNTB = 0;
			}
		break;
					}
//		poke(0xB800,4,0);
//		poke(0xB800,6,0);
// ⭮-ᨬ 

		AX = 0;	return;

			case FY_cntb:
				FY_CNTB = DX;
				AX = 0;	return;
			case FY_block:
				FY_BLOCK = DX;
				AX = 0;	return;
			case FY_DMA:
				FY_ADDR = DX;
				AX = 0;	return;
		}
		break;
	case	BOOT:
//			DiskReset(Drive);
			if (!CmpName(MK_FP(ES,BX)))	{
				FY_SR = FY_DRV << 9;
				Drive = FY_DRV & 1;
				if (MEMORY == NULL) { AX = 0xFF; return; }
			if ((FY_ERROR = BiosDisk(DiskRead,0,MEMORY))!=0)
				AX = 0xFF; else	AX = 0;
				return;
				}
			else	break;
	case	INIT:			// 砫쭠 ⠭
			IRQ = MK_FP(ES,BX);	// ᫮ pᮢ pp.
			IRQ_M = DX;		// ᪠ p
			DX <<= 1;
			FY_BLOCK = 0;
			FY_ADDR  = 0;
			FY_DRV   = 0;
	case	RESET:			// p p⢠
			FY_ERROR = 0;
			FY_READY = 1;
			FY_SR   = 0;
			FY_CNTB  = 0;
			DiskReset(Drive);
			break;
	case	DMA:			// p   
			MEMORY = MK_FP(ES,BX);
			break;
	case ABORT:	UnLoad();	// p㧪   !!!
			break;
}	/*case*/

if (SysInt60 == NULL)	return;
_ES = ES;
_DX = DX;
_CX = CX;
_BX = BX;
_AX = AX;
(*SysInt60)();
AX = _AX;
DX = _DX;
}	/* FY_sys */

void	main(void)	{

if ((SysInt60 = getvect(PDPvec)) != NULL)	{
	_BX = FY_csr;
	_AH = READW;
	asm	int	60h
	if (_AL == 0)	{
		cprintf("FY.EXE already resident !\r\n");
		return;
		}
	}

setvect(PDPvec,FY_sys);
cprintf("FY.EXE V02.01 floppy disk driver loaded.\r\n");

keep(0,(_SS + (_SP/16) - _psp));
}	/* main(FY_sys) */
