#include	<string.h>
#include	<stdio.h>
#include	<io.h>
#include	<dir.h>
#include	<dos.h>
#include	<fcntl.h>

#include	"pdp11dev.h"
#include	"HD_sys.h"

uns	IRQ = 0;
int	n,handle;
uns	Fsize;
char	Fname[81];


void near	BUS_Init(void)	{		// 樠 p
uns register	S,Q;
S = FP_SEG(&IRQ);
Q = FP_OFF(&IRQ);
_ES = S;		// SEG
_BX = Q;		// OFF ᫮ pᮢ pp뢠
_DX = 1;		// ᪠ pᮢ pp뢠  1 p⢠
_AH = INIT;
_AL = 0xFF;
asm	int	60h
S = _DS;
Q = (uns)Fname;
_ES = S;		// SEG
_BX = Q;		// OFF p⨢ 
_AH = DMA;
_AL = 0xFF;
asm	int	60h
}	// BUS_Init

void near	BUS_Done(void)	{		// p襭 p
_AH = DONE;
_AL = 0xFF;
asm	int	60h
}	// BUS_Done

byte near	BUS_PutW(uns Addr, uns Data)	{	//  ᫮
_BX = Addr;
_DX = Data;
_AH = WRITEW;
asm	int	60h
if (_AL) return(4);
return(0);
}	// BUS_PutW

byte near	BUS_GetW(uns Addr, int near *Data)	{ // ⥭ ᫮  p
uns register	D;
_BX = Addr;
_AH = READW;
_AL = 0xFF;
asm	int	60h
D = _DX;
if (_AL) return(4);
*Data = D;
return(0);
}	// BUS_GetW


void	main(int argc, char **argv)	{
int	CSR;

printf("HD.SYS file builder V00.01\n\n");

if (getvect(PDPvec) == NULL)	{
	printf("PDP-11 devices not loaded !\n");
	return;
	}
if (BUS_GetW(HD_csr,&CSR))	{
	printf("HD.SYS device simulator not loaded !\n");
	return;
	}

BUS_Init();

for (n=1; n<argc; n++)	{
	strcpy(Fname,searchpath(argv[n]));
	if (*Fname)	{
		BUS_PutW(HD_addr,0);
		BUS_PutW(HD_csr,HD_mount|HD_run|((n-1)<<9));
		BUS_GetW(HD_csr,&CSR);
		if (CSR >= 0)	{
 			BUS_GetW(HD_block,&(int)Fsize);
			BUS_GetW(HD_cntb,&handle);
			}
		else	printf("Can't access. Error code: %o, file %s\n",
				(CSR & 070000)>>12,Fname);
		}
	else	printf("File not found: %s\n",argv[n]);
	}

for (n=0; n<8; n++)	{
	BUS_PutW(HD_addr,0);
	*Fname = 0;
	BUS_PutW(HD_csr,(n<<9) + HD_stat + HD_run);
	BUS_GetW(HD_csr,&CSR);
	if (CSR >= 0)	{
		BUS_GetW(HD_block,&(int)Fsize);
		BUS_GetW(HD_cntb,&handle);
		printf("HD%d: %6u blocks, hnd %2d, file %s\n"
			,n,Fsize,handle,Fname);
		}
	}
BUS_Done();

}	// main(HD_mount)
