/**************************************************************************
		p⢮ HD: (Hard-)
		   p PDP-11

**************************************************************************/
#include	<string.h>
#include	<fcntl.h>

#include	"pdp11dev.h"
#include	"HD_sys.h"

extern unsigned		_stklen 	= 128;
extern unsigned		_heaplen	= 1024;

char	HD_Name[5]	= "HD0:";		//  p⢠  BOOT

char	HD_READY	= 1;		// ⮢ !
char	HD_ERROR	= 0;		//  訡 !
uns	HD_CSR		= 0;		// pp ﭨ
uns	HD_CNTB		= 0;		// 稪 
uns	HD_BLOCK	= 0;		// p ⥪. 
uns	HD_ADDR		= 0;		// p  設
uns	HD_DRV		= 0;		// p p⢠
long	LFS;

/**************************************************************************
		㭪 p饭   p BIOS
**************************************************************************/

long	Filelength(int handle)	{	// !!!  ᮯ  Borland'a
long	L;
int	HH,LL;
asm {
	mov	ax,4202h
	mov	bx,handle
	mov	cx,0
	mov	dx,0
	int	21h
	mov	HH,dx
	mov	LL,ax
	}
return(((long)HH << 16) | ((unsigned)LL));
}	// Filelength


#define	DiskWrite	3		//    INT $13
#define	DiskRead	2

char		Buffer[01000];		// 䠩 p
char far	*MEMORY	= NULL;		// p⨢ 
uns  far	*IRQ	= 0;		// ᫮ pᮢ pp.
uns		IRQ_M	= 0;		// ᪠ p
char far	*NamStr	= NULL;		//  p⢠  BOOT

int	handle[8]	= {-1,-1,-1,-1,-1,-1,-1,-1};	// 
char	Fnames[8][80]	= {"","","","","","","",""};	//  䠩
uns	Fsizes[8]	= { 0, 0, 0, 0, 0, 0, 0, 0};	// pp 䠩

int	BiosDisk(int Drive, int Comm, int Block, char far *DBuffer)	{
if (handle[Drive] < 0)	return(1);
if (Block >= Fsizes[Drive])	return(2);
lseek(handle[Drive],(long)Block<<9,SEEK_SET);
switch(Comm)	{
case DiskRead:
	if (_read(handle[Drive],Buffer,01000) < 0)	return(3);
	_fmemcpy(DBuffer,MK_FP(_DS,Buffer),01000);
	break;
case DiskWrite:
	_fmemcpy(MK_FP(_DS,Buffer),DBuffer,01000);
	if (_write(handle[Drive],Buffer,01000) < 0)	return(3);
	break;
default:	return(7);
}
return(0);
}	// BiosDisk

/***********************************************************************
 *                뢮 ⥪  ࠭
 */

#define	StatColor	0x1A	// 梥  窨

void	cpoke(byte X, byte C)	{
int	DX;
// ⠥  
_BH = 0;
_AH = 0x03;
asm	int	10h
DX = _DX;
//  -   
_DL = X;
_DH = 0;
_BX = 0;
_AH = 0x02;
asm	int	10h
// ᨬ -  
_BX = (C)?StatColor:0;
_CX = 1;
_AH = 0x09;
_AL = C;
asm	int	10h
//  - ⭮
_DX = DX;
_BX = 0;
_AH = 0x02;
asm	int	10h
}	// cpoke

void	cprintf(char *str)	{
char	C;
while ((C = *str++) != NULL)	{
	_AH = 0x0E;
	_AL = C;
asm	int	10h
	}
}	/* cprintf */

/***********************************************************************
 *                p⪠ pp뢠  p饭  HD:
 */

void interrupt	(* SysInt60)(void);	// ᫥. pp뢠

void	UnLoad(void)			// p   !!!
{
asm	cli
setvect(PDPvec,SysInt60);
freemem(*(unsigned*)MK_FP(_psp,0x2c));
freemem(_psp);
asm	sti
}

void interrupt	HD_sys
	(uns BP,uns DI,uns SI,uns DS,
	 uns ES,uns DX,uns CX,uns BX,uns AX)	{

switch(AX >> 8)	{
	case	READW:			// ⥭ ᫮
	case	READB:			// ⥭ 
		switch(BX)	{
			case HD_csr:
				DX = HD_CSR;
				if (HD_READY)	DX |= HD_ready;
				if (HD_ERROR)	DX |= (HD_error|(HD_ERROR<<12));
				AX = 0;	return;
			case HD_cntb:
				DX = HD_CNTB;
				AX = 0;	return;
			case HD_block:
				DX = HD_BLOCK;
				AX = 0;	return;
			case HD_addr:
				DX = HD_ADDR;
				AX = 0;	return;
		}
		break;
	case	WRITEB:			//  
	case	WRITEW:			//  ᫮
		switch(BX)	{
			case HD_csr:
				if ((AX >> 8) == WRITEB)	// . 
					(char)HD_CSR = (char)(DX & HD_allRW);
				else	{
					HD_CSR = (DX & HD_allRW);
					HD_DRV = (HD_CSR & HD_dev) >> 9;
					}
				cpoke(1,'0'+HD_DRV);
				if (DX & HD_run)
					switch (DX & HD_comm)	{
case HD_reset:	HD_ERROR = 0;
		break;
case HD_read:	DX = HD_CNTB;
		cpoke(0,'R');
		if (handle[HD_DRV] < 0)
			{ HD_ERROR = 8; break;	}
		while (DX >= 01000)	{
			if ((HD_ERROR =	BiosDisk(HD_DRV,DiskRead,HD_BLOCK,
					&MEMORY[HD_ADDR]))!=0)
				break;
			HD_BLOCK++;
			HD_ADDR += 01000;
			DX -= 01000;
			}
		if (DX)	{	//    !!!
			if ((HD_ERROR =	BiosDisk(HD_DRV,DiskRead,HD_BLOCK,
					MK_FP(_DS,Buffer)))!=0)
				break;
			_fmemcpy(&MEMORY[HD_ADDR],MK_FP(_DS,Buffer),DX);
			HD_BLOCK++;
			HD_ADDR += DX;
			DX = 0;
			}

		break;
case HD_write:	DX = HD_CNTB;
		cpoke(0,'W');
		if (handle[HD_DRV] < 0)
			{ HD_ERROR = 8; break;	}
		while (DX >= 01000)	{
			if ((HD_ERROR =	BiosDisk(HD_DRV,DiskWrite,HD_BLOCK,
					&MEMORY[HD_ADDR]))!=0)
				break;
			HD_BLOCK++;
			HD_ADDR += 01000;
			DX -= 01000;
			}
		if (DX)	{	//    !!!
			_fmemcpy(MK_FP(_DS,Buffer),&MEMORY[HD_ADDR],DX);
			if ((HD_ERROR =	BiosDisk(HD_DRV,DiskWrite,HD_BLOCK,
					MK_FP(_DS,Buffer)))!=0)
				break;
			HD_BLOCK++;
			HD_ADDR += DX;
			DX = 0;
			}
		break;
case HD_size:
		cpoke(0,'S');
		if (handle[HD_DRV] < 0)
			HD_ERROR = 1;
		else	HD_ERROR = 0;
		MEMORY[HD_ADDR] = HD_BLOCK = Fsizes[HD_DRV];
		MEMORY[HD_ADDR+1] = HD_BLOCK >> 8;
		break;
case HD_mount:
		cpoke(0,'M');
		NamStr = &MEMORY[HD_ADDR];
		HD_BLOCK = 0;
		HD_CNTB  = 0;
		if (handle[HD_DRV] >= 0)
			_close(handle[HD_DRV]);
		_fstrcpy(MK_FP(_DS,Fnames[HD_DRV]),NamStr);
		if ((handle[HD_DRV] = HD_CNTB =
			_open(Fnames[HD_DRV],O_BINARY|O_RDWR)) < 0)
			{ HD_ERROR = 5; break;	}
		else	HD_ERROR = 0;
		HD_BLOCK = Fsizes[HD_DRV] =
			(uns)(Filelength(handle[HD_DRV]) >> 9);
		break;
case HD_stat:
		cpoke(0,'I');
		NamStr = &MEMORY[HD_ADDR];
		HD_ERROR = BiosDisk(HD_DRV,DiskRead,0,
				MK_FP(_DS,Buffer));
		HD_BLOCK = Fsizes[HD_DRV];	// pp
		HD_CNTB = handle[HD_DRV];
		_fstrcpy(&MEMORY[HD_ADDR],MK_FP(_DS,Fnames[HD_DRV]));
		break;
					} // case
				cpoke(0,0);
				cpoke(1,0);
				AX = 0;	return;

			case HD_cntb:
				HD_CNTB = DX;
				AX = 0;	return;
			case HD_block:
				HD_BLOCK = DX;
				AX = 0;	return;
			case HD_addr:
				HD_ADDR = DX;
				AX = 0;	return;
		}
		break;
	case	BOOT:			// 㧪 㫥  䠩
			if (MEMORY == NULL)	{ AX = 0xFF; return;	}
			NamStr = MK_FP(ES,BX);
// ।塞  ன⢠  㧪
			HD_DRV = NamStr[2]-'0';
			cpoke(1,'0'+HD_DRV);
			if (HD_DRV > 07)	{ HD_DRV = 0; break;	}
			HD_Name[2] = HD_DRV+'0';
			if (_fstrcmp(NamStr,MK_FP(_DS,HD_Name)))
				break;
			cpoke(0,'B');
			HD_ERROR = BiosDisk(HD_DRV,DiskRead,0,MEMORY);
			if (HD_ERROR)	AX = 0xFF; else	AX = 0;
			cpoke(0,0);
			cpoke(1,0);
			HD_CSR = (HD_DRV << 9) | HD_read;
			return;
	case	INIT:			// 砫쭠 ⠭
			IRQ = MK_FP(ES,BX);	// ᫮ pᮢ pp.
			IRQ_M = DX;		// ᪠ p
			DX <<= 1;
			HD_BLOCK = 0;
			HD_ADDR  = 0;
			for (HD_DRV=0; HD_DRV<8; HD_DRV++)
			    handle[HD_DRV] =
				_open(Fnames[HD_DRV],O_BINARY|O_RDWR);
	case	RESET:			// p p⢠
			HD_ERROR = 0;
			HD_READY = 1;
			HD_CSR   = 0;
			HD_CNTB  = 0;
			HD_DRV   = 0;
		break;
	case	DMA:			// p   
			MEMORY = MK_FP(ES,BX);
		break;
	case ABORT:			// p㧪   !!!
			for (HD_DRV=0; HD_DRV<8; HD_DRV++)
				if (handle[HD_DRV] >= 0)
					_close(handle[HD_DRV]);
			cprintf("HD.SYS aborted.\r\n");
			UnLoad();
	case DONE:      		// p襭 p
			IRQ = NULL;
			IRQ_M = 0;
			MEMORY = NULL;
			break;
}	/*case*/

if (SysInt60 == NULL)	return;
_ES = ES;
_DX = DX;
_CX = CX;
_BX = BX;
_AX = AX;
(*SysInt60)();
AX = _AX;
DX = _DX;
}	/* HD_sys */

void	main(void)	{	// (uns argc, char **argv)	{

if ((SysInt60 = getvect(PDPvec)) != NULL)	{
	_BX = HD_csr;
	_AH = READW;
	asm	int	60h
	if (_AL == 0)	{
		printf("HD.SYS already resident !\r\n");
		return;
		}
	}

setvect(PDPvec,HD_sys);

printf("HD.SYS device driver loaded.\n");

keep(0,(_SS + (_SP/16) - _psp));
}	/* main(TV_sys) */
