#include	"pdp11dev.h"
#define	GR_mode		0x11	//  : VGA, 640/480/2
#define	GR_title	"VGA 640/480/2"

/************************************************************************
 *		p  設 PDP-11
 */

extern unsigned		_stklen 	= 128;
extern unsigned		_heaplen	= 128;

#define	GD_CSR	0176640		// ॣ ﭨ  ࠢ
#define	GD_DAT	0176642		// ॣ 
#define	GD_ADR	0176644		// ॣ 
#define	GD_CNT	0176646		// ॣ 稪

#define	GD_seg		0xA000	//  

#define	GD_X0	15
#define	GD_Y0	50

/************************************************************************
 *		窠  <conio.h>
 */

void _fastcall	cprintf(char *str)	{
char register	C;
while (*str != NULL)	{
	C = *str++;
	_AH = 0x0E;
	_AL = C;
	asm	int	10h
	}
}	/* cprintf */


/************************************************************************
 *		 pp
 */

uns	ADR_GD		= 0;
uns	CSR_GD		= 0;
byte	Open_FLAG	= 0;
byte	GR_FLAG		= 0;
byte	OldMODE		= 0;

byte _fastcall	GetVmode(void)		{	// ⥪ 
_AH = 0x0F;
asm int 10h;
return(_AL);
}	/* GetVmode */

int _fastcall	SetVmode(byte Mode)	{	// ⠭ 
byte	SM;
if (Mode == OldMODE)	{	// 㦥  ⥪⮢  ?
	if (GR_FLAG == 0)	return(0);
	GR_FLAG = 0;
	}
else	{			// 㦥  䨪 ?
	if (GR_FLAG)		return(0);
	GR_FLAG = 1;
	}
// ⠢ 
_AL = Mode;
_AH = 0;
asm int 10h;
SM = GetVmode();		//  稫 ?
return(SM-Mode);		//  ࠧ ???
}	/* SetVmode */

char	CalcData(char D)	{
uns	a,Q = 0;
for (a=0; a<8; a++)	{
	Q <<= 1;
	if (D & 1)	Q |= 1;
	D >>= 1;
	}
return(Q);
}	// CalcData

uns _fastcall	CalcAddr(uns Addr)	{	// ᫥ 
int	X	= (Addr%50);
int	Y	= Addr/50;
return((Y+GD_Y0)*80 + (X+GD_X0));
}	/* CalcAddr */

/***********************************************************************
 *		p饭  pp
 */

char _fastcall	GetDAT(void)		{	// ⥭ ॣ 
//if (GR_FLAG)
	return(CalcData(peekb(GD_seg,CalcAddr(ADR_GD))));
//else	return(0);
}	/* GetDAT */

void _fastcall	PutDAT(char DAT)	{	//   pp 
//if (GR_FLAG)
	pokeb(GD_seg,CalcAddr(ADR_GD),CalcData(DAT));

}	/* PutDAT */

int	PutCSR(uns DAT)		{	//   pp ࠢ
CSR_GD = DAT;
if (DAT & 0100000)
	return(SetVmode(GR_mode));
else	return(SetVmode(OldMODE));
}	/* PutCSR */

uns _fastcall	GetCNT(void)		{	// ⥭ ॣ 
return(0);
}	/* GetCNT */


/***********************************************************************
 *                p⪠ int 60
 */

void interrupt	(* SysInt60)();

void	KGD_UnLoad(void)		// p   !!!
{
setvect(PDPvec,SysInt60);

asm	cli
freemem(*(unsigned*)MK_FP(_psp,0x2c));
freemem(_psp);
asm	sti
}	// KGD_UnLoad


void interrupt	MYint60
	(uns BP,uns DI,uns SI,uns DS,
	 uns ES,uns DX,uns CX,uns BX,uns AX)
{
switch (AX >> 8)	{
case	INIT:			// 樠
		Open_FLAG = 1;
		break;
case	RESET:
case	DONE:			// p襭 p
		SetVmode(OldMODE);
		Open_FLAG = 0;
		break;
case	ABORT:
		cprintf("KGD_SYS aborted.\r\n");
		KGD_UnLoad();
		break;
case	READW:
case	READB:			//  "⥭" ?
		switch(BX)	{
	case	GD_CSR:	DX = CSR_GD;
			goto reti;
	case	GD_DAT:	DX = GetDAT();
			goto reti;
	case	GD_ADR:	DX = ADR_GD;
			goto reti;
	case	GD_CNT: DX = GetCNT();
			goto reti;
		}	// switch(BX)
		break;
case	WRITEW:			//  ᫮
case	WRITEB:			//  
		switch(BX)	{
	case	GD_CSR:	if (PutCSR(DX))	return;	// 訡 !
			goto reti;
	case	GD_DAT:	PutDAT(DX);
			goto reti;
	case	GD_ADR:	ADR_GD = DX;
	case	GD_CNT: goto reti;
		}	// switch(BX)
		break;

}	// switch(AX>>8)

if (SysInt60 == NULL)			//  ᫥. p⢮ ?
	return;				//  ?  !
_ES = ES;
_DX = DX;
_CX = CX;
_BX = BX;
_AX = AX;
(*SysInt60)();				// p ᫥. p
DX = _DX;
AX = _AX;
return;
reti:
AX = 0;
}	// MYint60

void	main(void)	{	// (uns argc, char **argv)	{

if ((SysInt60 = getvect(PDPvec)) != NULL)	{
	_BX = GD_CSR;
	_AH = READW;
	asm	int	60h
	if (_AL == 0)	{
		cprintf("KGD_SYS already resident !\r\n");
		return;
		}
	}

cprintf("KGD_SYS device driver in ");
cprintf(GR_title);
cprintf(" mode loaded.\r\n");

OldMODE = GetVmode();			// ⥪ 

setvect(PDPvec,MYint60);		//  뢠 int60
keep(0,(_SS + (_SP/16) - _psp));
}	/* main(TV_sys) */
 